/* LocaleInformation_da.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_da extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|LRD|ALV|HRK|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|SUR|SUN|NCF|CVE|ZAR|DOP|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|UYF|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|BSP|CMF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordansk dinar|Boliviansk mvdol|Guld|F\u00e6r\u00f8sk krone|Libanesisk pund|Euro|Vietnamesisk dong|Tanzanisk shilling|Boliviansk peso|Cambodjansk riel|Gammel cambodjansk riel|Zambisk pund|Australsk pund|Beninsk CFA-franc|Maltesisk pund|Ghanesisk revalueret cedi|Zambisk kwacha|Ghanesisk pund|Gammel ghanesisk cedi|Maltesisk lira|Australsk dollar|Amerikansk dollar (samme dag)|Italiensk lira|Amerikansk dollar (n\u00e6ste dag)|Ghanesisk cedi|Singaporeansk dollar|Panamansk balboa|Laotisk kip|Kirgisisk som|Schweizisk franc|\u00d8strigsk schilling|Amerikanske dollar|Etiopisk dollar|Bruneisk dollar|Jamaicansk pund|Etiopisk birr|Algerisk franc germinal|Ny algerisk franc|Algerisk dinar|Paraguaysk guarani|Libysk pund|Jamaicansk dollar|Islandsk krona|Spansk peseta|Bermudansk pund|Libysk dinar|Bermudansk dollar|Hollandsk guilder|Mauritansk ouguiya|Iransk rial|Svensk krona|Eritreisk nakfa|Kenyansk shilling|CFA-franc fra den Centralafrikanske republik|Argentinsk peso|Argentinsk peso (1983-1985)|Argentinsk peso moneda nacional|Ny taiwansk dollar|Sudansk pund|Georgisk lari|Georgisk kupon larit|Martiniquisk franc|Pund fra Falklands\u00f8erne|Argentinsk austral|Sudansk dinar|Irakisk dinar|Tuvaluansk dollar|Seychellisk rupee|Lettisk rubel|Fijiansk pund|Lettisk lats|Congolesisk Zaire|Congolesisk franc|Congolesisk franc congolais|Fijiansk dollar|Nicaraguansk cordoba oro|Macaosk pataca|Nicaraguansk gold cordoba|Nicaraguansk cordoba|Finsk mark (1860-1962)|Finsk mark|Salomonsk dollar|Luxembourgsk franc|Gammel dollar fra Trinidad og Tobago|Angolansk escudo|Angolansk kwanza reajustado (1995-1999)|Mongolsk tugrik|Ungarsk forint|Burundisk franc|Ny angolansk kwanza (1990-2000)|Angolansk kwanza (1977-1990)|Dollar fra Trinidad og Tobago|Swazilandsk lilangeni|CFP-franc fra Ny-Hebriderne|Britisk pund|Saudisk sovereign riyal|Saudisk riyal|Litauisk talonas|Indisk rupee|Portugisisk escudo|Angolansk kwanza|Portugisisk conto|Litauisk lita|Kasakhisk tenge|Kasakhisk rubel|Dollar fra De Britiske Jomfru\u00f8er|Nigeriansk pund|Nigeriansk naira|Haitisk gourde|Syrisk pund|Pal\u00e6stinensisk pund|Bahrainsk dinar|Myanmarsk kyat|Gylden fra De Nederlandske Antiller|Tjekkisk koruna|Lesothisk loti|Gabonesisk CFA-franc|Bulgarsk lev (1879-1952)|Ny Bulgarsk lev|Bulgarsk socialist lev|Canadisk dollar|Bulgarsk hard lev|Tyrkisk lira|Dollar fra Cayman\u00f8erne|Cypriotisk pund|Ny israelsk shekel|Guyansk dollar|Armensk dram|Israelsk pund|Malisk franc|Israelsk shekel|Venezuelansk bolivar|Liberisk dollar|Albansk lek|Kroatisk kuna|Kroatisk dinar|Albansk lek|Pund fra Jersey|Albansk lek (1946-1961)|Makedonsk denar (1992-1993)|Nordvietnamesisk viet minh piastre dong viet|Ny nordvietnamesisk dong|Makedonsk denar|Nordvietnamesisk piastre dong viet|Pataca fra Timor|CFP-franc|Belgisk franc (financial)|Guineansk peso|Kuwaitisk dinar|Portugisisk guinea mil reis|Belgisk franc|Escudo fra Timor|Belgisk franc (konvertibel)|Portugisisk guinea escudo|Salvadoransk colon|Curacaosk gylden|Bangladeshisk taka|Tongask pund|Tongask pa\u02bbanga|Sovjetisk rubel|Ny sovjetisk rubel|Nykaledonsk franc germinal|Kapverdisk escudo|Sydafrikansk rand|Dominikansk peso|Sydafrikansk pund|Sydafrikansk rand (financial)|Tunesisk dinar|Cubansk peso|Fransk-guyansk franc guiana|Ugandisk shilling|Ceylonesisk rupee|Affars og Issas franc|Vatikansk lira|Escudo fra Sao Tome og Principe|Ugandisk shilling (1966-1987)|Dobra fra Sao Tome og Principe|Dollar fra Marshall\u00f8erne|New Zealandsk pund|Samoansk tala|Samoansk pund|Honduransk lempira|Turkmensk manat|Guatemalansk quetzal|New Zealandsk dollar|Skotsk pund|Barbadisk dollar|Namibisk dollar|Madagaskisk franc|Madagaskisk ariary|Egyptisk pund|Britisk Honduras dollar|Polsk zloty (1950-1995)|Ny bosnien-hercegovinsk dinar|Bosnien-Hercegovinsk konvertibel mark|Belizisk dollar|Bosnien-Hercegovinsk dinar|Polsk zloty|Yemenitisk rial|Surinamsk guilder|Tjekkoslovakisk hard koruna|Sydkoreansk won|Hviderussisk rubel|Yemenitisk imadi riyal|Hviderussisk rubel (1992-1994)|Tjekkoslovakisk koruna|Gammel sydkoreansk won|Sydkoreansk hwan|Ny hviderussisk rubel (1994-1999)|Somalilands shilling|Ny gr\u00e6sk drachma|Pakistansk rupee|Zimbabwisk dollar|Srilankansk rupee|Gr\u00e6sk drachma|Irsk pund|Yemenitisk dinar|Rwandisk franc|Costaricansk colon|Tadsjikisk somoni|Tadsjikisk rubel|Estisk kroon|\u00c6kvatorialguineask peseta guineana|Moldovisk ruble cupon|Dansk krone|Moldovisk leu|\u00c6kvatorialguineask franco|\u00c6kvatorialguineask ekwele guineana|Indonesisk pupiah|Dirham fra de Forenede Arabiske Emirater|Nordkoreansk won|Ny indonesisk rupiah|Botswansk pula|Moldovisk leu cupon|Indonesisk java rupiah|Indonesisk nica guilder|Vanuaisk vatu|Islamisk dinar|Somalisk shilling|Andorransk peseta|Russisk rubel (1991-1998)|Guadeloupsk franc|Djiboutisk franc|Andorransk diner|Monegaskisk franc germinal|Ny monegaskisk franc|Ecuadoriansk sucre|Liechtensteinsk franc|Russisk rubel|Filippinsk peso|Usbekisk sum|Colombiansk peso|Thailandsk baht|Nordirsk pund|Burmesisk rupee|Congolesisk CFA-franc|Burmesisk kyat|Colombiansk papirpeso|Usbekisk coupon som|Ukrainsk karbovanetz|Qatarsk rial|Ukrainsk grynia|Guineansk syli|Kinesisk yuan renminbi|Mozambiquisk metical|Uruguaysk peso uruguayo|Guineansk franc (1960-1972)|Lira fra San Marino|Mozambiquisk escudo|Kinesisk jen min piao yuan|Papuansk kina|Omansk rial saidi|Guineansk franc|Uruguaysk peso (1975-1993)|Omansk rial|Fransk UIC-franc|Zairisk naire|Bhutansk rupee|Marokkansk franc|Marokkansk dirham|Fransk guldfranc|Bhutansk ngultrum|Uruguaysk peso fuerte|Ny zairisk zaire|Malaysisk ringgit|Aserbajdsjansk manat|Gambisk pund|Comorisk franc|Sierraleonsk leone|Gambisk dalasi|Bahamansk pund|Camerounsk CFA-franc|Bahamansk dollar|Mexicansk silver peso (1861-1992)|Mexicansk peso|Peruviansk sol|Gr\u00f8nlandsk krone|Brasiliansk cruzeiro (1942-1967)|Peruviansk sol nuevo|Chilensk peso|Slovakisk koruna|Peruviansk inti|Brasiliansk cruzeiro|Fransk franc|Brasiliansk cruzado novo|Chilensk unidades de fomento|Chilensk escudo|Brasiliansk real|Chilensk condor|Brasiliansk cruzeiro (1990-1993)|Tysk sperrmark|Malawisk pund|Brasiliansk cruzado|Brasiliansk cruzeiro novo (1967-1986)|Malawisk kwacha|Transdniestrisk rubel|Tysk mark|Tchadisk CFA-franc|Ny transdniestrisk rubel|Transdniestrisk rubelkupon|Nepalesisk rupee|Dollar fra Cook\u00f8erne|Japansk yen|Maldivisk rufiyaa|Maldivisk rupee|\u00d8st-karaibisk dollar|Slovensk tolar|Jugoslavisk reformed dinar|Arubansk gylden|Jugoslavisk october dinar|\u00d8sttysk mark|Jugoslavisk convertible dinar|Jugoslavisk noviy dinar|Jugoslavisk 1994 dinar|Jugoslavisk federation dinar|Ny rum\u00e6nsk leu|Jugoslavisk hard dinar|Rum\u00e6nsk leu|Slovensk tolar bons|Norsk krone|Mauritisk rupee|Gibraltarisk pund|Vietnamesisk national dong|Vietnamesisk republikansk dong|Pund fra Saint Helena|Ny vietnamesisk dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|LRD|ALV|HRK|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|SUR|SUN|NCF|CVE|ZAR|DOP|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|ZWD|LKR|GRD|IEP|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|XFU|ZRZ|BTR|MAF|MAD|XFO|BTN|UYF|ZRN|MYR|AZM|GMP|KMF|SLL|GMD|BSP|CMF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|GHP|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|FIN|FIM|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|LRD|ALV|HRK|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|SUR|SUN|NCF|CVEsc|R|RD$|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Z$|SL Re|GRD|IR\u00a3|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|kr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|Ur$|GNI|SML|MZE|CNP|PGK|OMS|GF|UYP|RO|XFU|ZRZ|BTR|MAF|MAD|XFO|Nu|UYF|ZRN|RM|AZM|GMP|CF|SLL|GMD|BSP|CMF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|GIP|VNS|VNR|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "maj",
    "jun",
    "jul",
    "aug",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "januar",
    "februar",
    "marts",
    "april",
    "maj",
    "juni",
    "juli",
    "august",
    "september",
    "oktober",
    "november",
    "december",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "s\u00f8n",
    "man",
    "tir",
    "ons",
    "tor",
    "fre",
    "l\u00f8r",
  };

  private static final String[] weekdays = {
    null,
    "s\u00f8ndag",
    "mandag",
    "tirsdag",
    "onsdag",
    "torsdag",
    "fredag",
    "l\u00f8rdag",
  };

  private static final String[] eras = {
    "f.Kr.",
    "e.Kr.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Pacific-normaltid", "PDT", "Pacific-sommertid",  "America/Los_Angeles" },
    { "GMT", "Verdenstid", "GMT", "Verdenstid",  "Africa/Casablanca" },
    { "EST", "Eastern-normaltid", "EDT", "Eastern-sommertid",  "America/New_York" },
    { "AST", "Alaska-normaltid", "ADT", "Alaska-sommertid",  "America/Anchorage" },
    { "GMT", "Verdenstid", "GMT", "Verdenstid",  "Etc/GMT" },
    { "CTT", "Kinesisk normaltid", "CDT", "Kinesisk normaltid",  "Asia/Shanghai" },
    { "AST", "Atlantic-normaltid", "ADT", "Atlantic-sommertid",  "America/Halifax" },
    { "CET", "Mellemeurop\u00e6isk normaltid", "CEST", "Mellemeurop\u00e6isk sommertid",  "Europe/Paris" },
    { "MST", "Mountain-normaltid", "MDT", "Mountain-sommertid",  "America/Denver" },
    { "IST", "Israelsk normaltid", "IDT", "Israelsk sommertid",  "Asia/Jerusalem" },
    { "HST", "Hawaii-normaltid", "HST", "Hawaii-normaltid",  "Pacific/Honolulu" },
    { "CNT", "Newfoundland-normaltid", "CDT", "Newfoundland-sommertid",  "America/St_Johns" },
    { "EST", "Eastern-normaltid", "EST", "Eastern-normaltid",  "America/Indianapolis" },
    { "CST", "Central-normaltid", "CDT", "Central-sommertid",  "America/Chicago" },
    { "EET", "\u00d8steurop\u00e6isk normaltid", "EEST", "\u00d8steurop\u00e6isk sommertid",  "Europe/Bucharest" },
    { "JST", "Japansk normaltid", "JST", "Japansk normaltid",  "Asia/Tokyo" },
    { "MST", "Mountain-normaltid", "MST", "Mountain-normaltid",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor-Leste|Tokelau|Tadsjikistan|Thailand|Togo|Franske Besiddelser i Det Sydlige Indiske Ocean|Guyana|Tchad|Turks- og Caicos\u00f8erne|Guinea-Bissau|Guam|Guatemala|South Georgia og De Sydlige Sandwich\u00f8er|Gr\u00e6kenland|\u00c6kvatorialguinea|Guadeloupe|Swaziland|Syrien|Guinea|Gambia|Gr\u00f8nland|El Salvador|S\u00e3o Tom\u00e9 og Pr\u00edncipe|Gibraltar|Ghana|Surinam|Fransk Guyana|Serbien|Georgien|Somalia|Grenada|Senegal|San Marino|Storbritannien|Sierra Leone|Gabon|Slovakiet|Svalbard og Jan Mayen|Slovenien|St. Helena|Singapore|Sverige|Sudan|Seychellerne|Salomon\u00f8erne|Saudi-Arabien|Frankrig|F\u00e6r\u00f8erne|Mikronesiens Forenede Stater|Rwanda|Falklands\u00f8erne|Rusland|Fiji-\u00f8erne|Finland|Rum\u00e6nien|Reunion|Etiopien|Spanien|Eritrea|Vestsahara|Egypten|Estland|Ecuador|Algeriet|Qatar|Den Dominikanske Republik|Paraguay|Dominica|Palau|Danmark|Djibouti|Portugal|De pal\u00e6stinensiske omr\u00e5der|Puerto Rico|Tyskland|Pitcairn|Saint Pierre og Miquelon|Polen|Pakistan|Filippinerne|Papua Ny Guinea|Fransk Polynesien|Tjekkiet|Peru|Cypern|Jule\u00f8en|Kap Verde|Panama|Cuba|Costa Rica|Colombia|Kina|Cameroun|Chile|Cook-\u00f8erne|Elfenbenskysten|Schweiz|Congo|Centralafrikanske Republik|Den Demokratiske Republik Congo|Cocos-\u00f8erne (Keeling\u00f8erne)|Oman|Canada|Belize|Hviderusland|Botswana|Bouvet\u00f8|Bhutan|Bahamas|Brasilien|New Zealand|Bolivia|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgarien|Burkina Faso|Nepal|Belgien|Norge|Bangladesh|Barbados|Zimbabwe|Holland|Bosnien-Hercegovina|Nicaragua|Nigeria|Norfolk Island|Aserbajdsjan|Niger|Ny Caledonien|Aruba|Zambia|Namibia|Australien|\u00d8strig|Amerikansk Samoa|Argentina|Antarktis|Mozambique|Angola|Malaysia|Hollandske Antiller|Mexico|Armenien|Malawi|Albanien|Maldiverne|Sydafrika|Mauritius|Malta|Anguilla|Montserrat|Mauretanien|Antigua og Barbuda|Martinique|Afghanistan|Nordmarianerne|Forenede Arabiske Emirater|SAR Macao|Andorra|Mongoliet|Myanmar|Mali|Republikken Makedonien|Jugoslavien|Mayotte|Marshall\u00f8erne|Madagaskar|Republikken Moldova|Monaco|Marokko|Yemen|Libyen|Letland|Luxembourg|Litauen|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|Libanon|Laos|Kasakhstan|Cayman\u00f8erne|Kuwait|Sydkorea|Nordkorea|Saint Kitts og Nevis|Comorerne|Kiribati|Samoa|Cambodja|Kirgisistan|Kenya|Wallis og Futuna\u00f8erne|Japan|Jordan|Jamaica|Vanuatu|Vietnam|De amerikanske jomfru\u00f8er|De britiske jomfru\u00f8er|Venezuela|St. Vincent og Grenadinerne|Vatikanstaten|Italien|Island|Iran|Irak|Usbekistan|Det Britiske Territorium i Det Indiske Ocean|Uruguay|Indien|Israel|USA|Irland|Indonesien|De Mindre Amerikanske Overs\u00f8iske \u00d8er|Uganda|Ukraine|Ungarn|Haiti|Kroatien|Tanzania|Honduras|Heard- og McDonald-\u00f8erne|Taiwan|Tuvalu|SAR Hongkong|Trinidad og Tobago|Tyrkiet|Tonga|Tunesien|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|mic|wa|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|ku|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "Gwich\u02bbin|Akkadisk|Ekajuk|Ijo|Xhosa|Sumerisk|Susu|Diverse sprog|Lozi|Tonga (Nyasa)|Ponape|Minangkabau|Sukuma|Wolof|Mongo|Micmac|Vallonsk|Zapotec|Kusjitiske sprog (\u00f8vrige)|Lojban|Dogri|Volap\u00fck|Otomi sprog|Vietnamesisk|Vai|Rarotongan|Venda|Rapanui|Rajasthani|Osmannisk (1500-1928)|Nzima|Neapolitansk|Usbekisk|Ugaristisk|Tamashek|Nordamerikanske indianske sprog (\u00f8vrige)|Nahuatl|Urdu|Fanti|Ukrainsk|Egyptisk (oldtid)|Uigurisk|Fang|Afrikanske sprog syd for Sahara (\u00f8vrige)|Irsk, Middel- (900-1200)|Baltiske sprog (\u00f8vrige)|Nyoro sprog|Basa|Nyankole|Nyamwezi|Hmong|Balinesisk|Osage|Baluchi|Tahitiansk|Twi|Serer|Tlingit|Tatarisk|Tsonga|Banda|Tyrkisk|Tonga (Tonga\u00f8erne)|Tswana|Tagalog|Turkmensk|Tigrinya|Thailandsk|Kurukh|Tajik|Blin|Telugu|Kru|Kashubian|Tamilsk|Tokelau|Efik|Swahili|Svensk|Sundanesisk|Karachay-Balkar|Sotho, Southern|Swati|Serbisk|Albansk|Mende|Kreolsk og pidgin (\u00f8vrige)|Somalisk|Afrihili|Shona|Samoansk|Slovensk|Gr\u00e6sk, Old- (til 1453)|Slovakisk|Grebo|Singalesisk|Serbokroatisk|Krim-tyrkisk; Krim-tatarisk|Afro-asiatisk (\u00f8vrige)|Sango|Nordsamisk|Sindhi|Udmurt|Sardinsk|Sanskrit|Kinyarwanda|Russisk|Mandar|Rum\u00e6nsk|Rundi|R\u00e6toromansk|Moksha|Tivi|Adyghe|Zuni|Kpelle|Quechua|Tigre|Songhai|Kreolsk og pidgin, baseret p\u00e5 portugisisk (\u00f8vrige)|Sogdiansk|Adangme|Kosraean|Hittitisk|Kreolsk og pidgin, baseret p\u00e5 fransk (\u00f8vrige)|Kreolsk og pidgin, baseret p\u00e5 engelsk (\u00f8vrige)|Himachali|Konkani|Hiligaynon|Gotisk|Gorontalo|Gondi|Dinka|Nubiske sprog|Portugisisk|Pashto (Pushto)|Friulian|F\u00f8nikisk|Tysk, Oldh\u00f8j- (ca.750-1050)|Soninke|Koptisk|Yap|Acoli|Yao|Filippinske sprog (\u00f8vrige)|Polsk|Achinesisk|Pali|Punjabi|Buginesisk|Iban|Skolt Sami|Buriat|Masai|Inari Sami|Ossetisk|Malajo-polynesiske sprog (\u00f8vrige)|Oriya|Mandingo|Lule Sami|Samiske sprog (\u00f8vrige)|Makasar|Oromo|Maithili|Ojibwa|Magahi|Madurese|Sydsamisk|Occitansk (efter 1500); Provencalsk|Sotho, Nord|Batak|Erzya|Dogrib|Nyanja; Chichewa; Chewa|Maya sprog|Navajo|Kimbundu|Ndebele, Syd|Tysk, Middelh\u00f8j- (ca.1050-1500)|Norsk|Nynorsk|Hollandsk|Ndonga|Slaviske sprog (\u00f8vrige)|Nepalesisk|Ndebele, Nord|Chamic sprog|Tetum|Norsk Bokm\u00e5l|Nauru|Tereno|Temne|Burmesisk|Lezghian|Maltesisk|Persisk, Old- (ca. 600-400 f. Kr.)|Malay|Marathisk|Fransk, Old- (842-ca.1400)|Moldovisk|Fransk, Middel- (ca.1400-1600)|Mongolsk|J\u00f8disk-arabisk|Malayalam|Makedonsk|Maori|Marshallese|Malagasy|Marwari|Braj|Slave (Athapascan)|Lettisk|Luba-Katanga|Delaware|Litauisk|Lao|Lingala|Limburgsk|Ewondo|Ganda|Luxembourgsk|Latin|J\u00f8disk-persisk|Votisk|Sino-tibetanske sprog (\u00f8vrige)|Kirgisisk|Cornisk|Kurdisk|Kashmiri|Kanuri|Awadhi|Koreansk|Kannaresisk|Khmer|Kalaallisut|Kasakhisk|Romani|Kuanyama|Sidamo|Kikuyu|Kongo|Islandsk, Old-|Georgisk|Creek|Romanske sprog (\u00f8vrige)|Nogai|Munda (\u00f8vrige)|Flere sprog|Javanesisk|Gilbertesisk|Zande|Shan|Fon|Kalmyk|Australske sprog|Khotanesisk|Japansk|Khoisan (\u00f8vrige)|Palauansk|Cheyenne|Tai (\u00f8vrige)|Inuktitut|Papiamento|Italiensk|Tegnsprog|Islandsk|Khasi|Cherokee|Pampanga|Pahlavi|Chipewyan|Ido|Choctaw|Chinook|Mari|Tuvinian|Bantu|Pangasinan|Inupiaq|Chuukese|Sichuan Yi|Hawaiiansk|Lamba|Igbo|Chagatai|Irsk, Old- (indtil 900)|Papua-australske sprog (\u00f8vrige)|Interlingue|Indonesisk|Lahnda|Dayak|Chibcha|Interlingua|Ladino|Herero|Haida|Dargwa|Armensk|Ungarsk|Haitisk|Dakota|Kroatisk|Hiri Motu|Hindi|Dyula|Hebraisk|Asturisk|Hausa|Vendiske sprog|Manx|Gujaratisk|Semitiske sprog (\u00f8vrige)|Selkupisk|Irokesiske sprog|Guarani|Galicisk|Arawak|Geez|Kunstsprog (\u00f8vrige)|G\u00e6lisk (skotsk)|Iranske sprog (\u00f8vrige)|Irsk|Arapaho|Araukansk|Frisisk|Siksika|Germanske sprog (\u00f8vrige)|Aram\u00e6isk|Fransk|F\u00e6r\u00f8sk|Keltiske sprog (\u00f8vrige)|Fijian|Finsk|Fulah|Tuvalu|Cebuano|Persisk|Baskisk|Skotsk|Estisk|Spansk|Esperanto|Engelsk|Gr\u00e6sk|Tyrkisk-tatariske sprog (\u00f8vrige)|Niuean|Ewe|Tumbuka|Mossi|Dzongkha|Niger-Congo sprog (\u00f8vrige)|Lushai|Finsk-ugriske sprog (\u00f8vrige)|Divehi|Nias|Mohawk|Luo|Lunda|Apache sprog|Luiseno|Hupa|Bini|Tysk|Luba-Lulua|Bikol|Washo|Sproget kan ikke bestemmes|Waray|Dansk|Hollandsk (ca. 1050-1350)|Walamo|Santali|Walisisk|Sasak|Kabardian|Chuvash|Kirkeslavisk|Manipuri|Tjekkisk|Samaritansk|Cree|Duala|Korsikansk|Sydamerikanske indianske sprog (\u00f8vrige)|Manchu|Yakut|Kawi|Ingush|Gbaya|Sandawe|Chamorro|Indoeurop\u00e6iske sprog (\u00f8vrige)|Bhojpuri|Engelsk, Middel- (1100-1500)|Karen|Indiske sprog (\u00f8vrige)|Tjetjensk|Gayo|Katalansk|Umbundu|Syrisk|Kamba|Tsimshisk|Angelsaksisk (ca.450-1100)|Kachin|Kaukasiske sprog (\u00f8vrige)|Kabyle|Karakalpakisk|Bosnisk|Caribisk|Bretonsk|Tibetansk|Bengalsk|Bambara|Ga|Mellemamerikanske indianske sprog (\u00f8vrige)|Bislama|Bihari|Bulgarsk|Hviderussisk|Caddo|Bashkir|Zulu|Zenaga|Provencalsk (f\u00f8r 1500)|\u00d8vre sorbisk|Aserbajdsjan|Aymara|Avarisk|Assamesisk|Nedre sorbisk|Arabisk|Iloko|Elamitisk|Kinesisk|Aragonesisk|Amharisk|Newari|Akan|Zhuang|Afrikaans|Avestan|Abkhasisk|Afar|Yoruba|Algonkiske sprog|Aleutiske sprog|Mon-khmer (\u00f8vrige)|Jiddisch|Dravidiske sprog (\u00f8vrige)|Berberiske sprog|Nedertysk; nedersachsisk|Bemba|Beja|Tok Pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GuMtkHmsSEDFwWahKzUeygAZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd-MM-yy" },
    { "mediumDateFormat", "dd-MM-yyyy" },
    { "longDateFormat", "d. MMM yyyy" },
    { "fullDateFormat", "EEEE dd MMMM yyyy" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
