/* -*-c-*- -------------- mixgtk_widgets.c :
 * Implementation of the functions declared in mixgtk_widgets.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-04-29 14:32:17 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */



#include <glade/glade.h>
#include <mixlib/mix.h>
#include "mixgtk_config.h"
#include "mixgtk_widgets.h"

/* the glade spec */
static GladeXML *xml_ = NULL;

/* widget names */
static const gchar *names_[] = {
  "main_window",
  "main_statusbar",
  "word_dialog",
  "about_dialog",
  "goto_dialog",
  "color_dialog",
  "fontsel_dialog",
  "mixvm_widget",
  "command_prompt",
  "command_log",
  "mixal_clist",
  "rA_entry",
  "rX_entry",
  "rJ_entry",
  "rI1_entry",
  "rI2_entry",
  "rI3_entry",
  "rI4_entry",
  "rI5_entry",
  "rI6_entry",
  "lesser_radio",
  "equal_radio",
  "greater_radio",
  "over_toggle",
  "memory_cells",
  "elapsed_label",
  "program_label",
  "uptime_label",
  "memory_scroll",
  "devices_notebook",
  "loc_entry",
  NULL
};

#define WIDGET_NO_ (sizeof (names_) / sizeof (names_[0]))

#define VERSION_LABEL_ "version_label"
#define GPL_TEXT_ "gpl_text"
#define AUTOSAVE_ITEM_ "save_on_exit"

GtkWidget *about_;

static void
init_autosave_ (void)
{
  GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM
    (mixgtk_widget_factory_get_by_name (AUTOSAVE_ITEM_));
  if (item)
    {
      gtk_check_menu_item_set_active (item, mixgtk_config_is_autosave ());
    }
}

/* create a new factory from an xml glade file */
gboolean
mixgtk_widget_factory_init (const char *glade_file)
{
  GtkWidget *label;
  
  glade_init ();
  xml_ = glade_xml_new (glade_file, NULL);
  if (!xml_) return FALSE;
  glade_xml_signal_autoconnect (xml_);
  
  about_ = mixgtk_widget_factory_get (MIXGTK_WIDGET_ABOUT_DIALOG);
  g_return_val_if_fail (about_ != NULL, FALSE);
  label = mixgtk_widget_factory_get_by_name (VERSION_LABEL_);
  g_return_val_if_fail (label != NULL, FALSE);
  gtk_label_set_text (GTK_LABEL(label), VERSION);
  gtk_widget_show (label);
  
  init_autosave_ ();
  
  return TRUE;
}

/* get a widget */
GtkWidget *
mixgtk_widget_factory_get (mixgtk_widget_id_t widget)
{
  g_return_val_if_fail (widget < WIDGET_NO_, NULL);
  return glade_xml_get_widget (xml_, names_[widget]);
}

/* Get a widget by name */
GtkWidget *
mixgtk_widget_factory_get_by_name (const gchar *name)
{
  return glade_xml_get_widget (xml_, name);
}

/* about box */
void
on_about_activate (GtkWidget *w, gpointer data)
{
  gtk_widget_show (about_);
}
