/* -*-c-*- ---------------- mixgtk_widgets.h :
 * glade-based factory of mixvm widgets
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: <01/03/15 14:42:13 jose>
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#ifndef MIXGTK_WIDGETS_H
#define MIXGTK_WIDGETS_H

#include <gtk/gtk.h>
#include <mixlib/mix_vm.h>

/* enumeration of mixvm widget ids */
typedef enum {
  MIXGTK_WIDGET_MAIN,		/* main app window */
  MIXGTK_WIDGET_STATUSBAR,
  MIXGTK_WIDGET_WORD_DIALOG,	/* input dialog for a mix word */
  MIXGTK_WIDGET_ABOUT_DIALOG,
  MIXGTK_WIDGET_GOTO_DIALOG,
  MIXGTK_WIDGET_PROMPT,		/* command prompt */
  MIXGTK_WIDGET_LOG,		/* command output */
  MIXGTK_WIDGET_MIXAL,		/* mixal source file */
  MIXGTK_WIDGET_rA,
  MIXGTK_WIDGET_rX,
  MIXGTK_WIDGET_rJ,
  MIXGTK_WIDGET_rI1,
  MIXGTK_WIDGET_rI2,
  MIXGTK_WIDGET_rI3,
  MIXGTK_WIDGET_rI4,
  MIXGTK_WIDGET_rI5,
  MIXGTK_WIDGET_rI6,
  MIXGTK_WIDGET_CMP_L,
  MIXGTK_WIDGET_CMP_E,
  MIXGTK_WIDGET_CMP_G,
  MIXGTK_WIDGET_OVER,
  MIXGTK_WIDGET_CELLS,
  MIXGTK_WIDGET_CELLS_SCROLL,
  MIXGTK_WIDGET_DEVICE,
  MIXGTK_WIDGET_LOC,
  MIXGTK_WIDGET_LAPTIME,
  MIXGTK_WIDGET_PROGTIME,
  MIXGTK_WIDGET_UPTIME,
  MIXGTK_WIDGET_NONE
} mixgtk_widget_id_t;


/* create a new factory from an xml glade file */
extern gboolean
mixgtk_widget_factory_init (const char *glade_file);


/* get a widget */
extern GtkWidget *
mixgtk_widget_factory_get (mixgtk_widget_id_t widget);

/* Get a widget by name */
extern GtkWidget *
mixgtk_widget_factory_get_by_name (const gchar *name);


#endif /* MIXGTK_WIDGETS_H */

