/*
 ** Copyright 2003-2010, VisualOn, Inc.
 **
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 **
 **     http://www.apache.org/licenses/LICENSE-2.0
 **
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 */
/*******************************************************************************
	File:		aac_rom.c

	Content:	constant tables

*******************************************************************************/

#include "aac_rom.h"

#if defined (ARMV5E) && !defined (ARMV7Neon)

/* 
 *  Q30 for 128 and 1024 
 *
 * for (i = 0; i < num/4; i++) {
 *   angle = (i + 0.125) * M_PI / num;
 *   x = cos(angle) * (1 << 30);
 *   x = sin(angle) * (1 << 30);
 * 
 *   angle = (num/2 - 1 - i + 0.125) * M_PI / num;
 *   x = cos(angle) * (1 << 30);
 *   x = sin(angle) * (1 << 30);
 * }
 */
const int cossintab[128 + 1024] = {
	/* 128 */
	0x3fffec43, 0x003243f1, 0x015fd4d2, 0x3ffc38d1, 0x3ff9c13a, 0x01c454f5, 0x02f1b755, 0x3feea776, 
	0x3fe9b8a9, 0x03562038, 0x0483259d, 0x3fd73a4a, 0x3fcfd50b, 0x04e767c5, 0x0613e1c5, 0x3fb5f4ea, 
	0x3fac1a5b, 0x0677edbb, 0x07a3adff, 0x3f8adc77, 0x3f7e8e1e, 0x08077457, 0x09324ca7, 0x3f55f796, 
	0x3f473759, 0x0995bdfd, 0x0abf8043, 0x3f174e70, 0x3f061e95, 0x0b228d42, 0x0c4b0b94, 0x3eceeaad, 
	0x3ebb4ddb, 0x0cada4f5, 0x0dd4b19a, 0x3e7cd778, 0x3e66d0b4, 0x0e36c82a, 0x0f5c35a3, 0x3e212179, 
	0x3e08b42a, 0x0fbdba40, 0x10e15b4e, 0x3dbbd6d4, 0x3da106bd, 0x11423ef0, 0x1263e699, 0x3d4d0728, 
	0x3d2fd86c, 0x12c41a4f, 0x13e39be9, 0x3cd4c38b, 0x3cb53aaa, 0x144310dd, 0x15604013, 0x3c531e88, 
	0x3c314060, 0x15bee78c, 0x16d99864, 0x3bc82c1f, 0x3ba3fde7, 0x173763c9, 0x184f6aab, 0x3b3401bb, 
	0x3b0d8909, 0x18ac4b87, 0x19c17d44, 0x3a96b636, 0x3a6df8f8, 0x1a1d6544, 0x1b2f971e, 0x39f061d2, 
	0x39c5664f, 0x1b8a7815, 0x1c997fc4, 0x39411e33, 0x3913eb0e, 0x1cf34baf, 0x1dfeff67, 0x38890663, 
	0x3859a292, 0x1e57a86d, 0x1f5fdee6, 0x37c836c2, 0x3796a996, 0x1fb7575c, 0x20bbe7d8, 0x36fecd0e, 
	0x36cb1e2a, 0x21122240, 0x2212e492, 0x362ce855, 0x35f71fb1, 0x2267d3a0, 0x2364a02e, 0x3552a8f4, 
	0x351acedd, 0x23b836ca, 0x24b0e699, 0x34703095, 0x34364da6, 0x250317df, 0x25f78497, 0x3385a222, 
	0x3349bf48, 0x264843d9, 0x273847c8, 0x329321c7, 0x32554840, 0x27878893, 0x2872feb6, 0x3198d4ea, 
	0x31590e3e, 0x28c0b4d2, 0x29a778db, 0x3096e223, 0x30553828, 0x29f3984c, 0x2ad586a3, 0x2f8d713a, 
	0x2f49ee0f, 0x2b2003ac, 0x2bfcf97c, 0x2e7cab1c, 0x2e37592c, 0x2c45c8a0, 0x2d1da3d5, 0x2d64b9da, 
	/* 1024 */
	0x3fffffb1, 0x0006487f, 0x002bfb74, 0x3ffff0e3, 0x3fffe705, 0x00388c6e, 0x005e3f4c, 0x3fffba9b, 
	0x3fffa6de, 0x006ad03b, 0x009082ea, 0x3fff5cd8, 0x3fff3f3c, 0x009d13c5, 0x00c2c62f, 0x3ffed79b, 
	0x3ffeb021, 0x00cf56ef, 0x00f508fc, 0x3ffe2ae5, 0x3ffdf98c, 0x01019998, 0x01274b31, 0x3ffd56b5, 
	0x3ffd1b7e, 0x0133dba3, 0x01598cb1, 0x3ffc5b0c, 0x3ffc15f7, 0x01661cf0, 0x018bcd5b, 0x3ffb37ec, 
	0x3ffae8f9, 0x01985d60, 0x01be0d11, 0x3ff9ed53, 0x3ff99483, 0x01ca9cd4, 0x01f04bb4, 0x3ff87b44, 
	0x3ff81896, 0x01fcdb2e, 0x02228924, 0x3ff6e1bf, 0x3ff67534, 0x022f184d, 0x0254c544, 0x3ff520c5, 
	0x3ff4aa5d, 0x02615414, 0x0286fff3, 0x3ff33858, 0x3ff2b813, 0x02938e62, 0x02b93914, 0x3ff12878, 
	0x3ff09e56, 0x02c5c71a, 0x02eb7086, 0x3feef126, 0x3fee5d28, 0x02f7fe1c, 0x031da62b, 0x3fec9265, 
	0x3febf48b, 0x032a3349, 0x034fd9e5, 0x3fea0c35, 0x3fe96480, 0x035c6682, 0x03820b93, 0x3fe75e98, 
	0x3fe6ad08, 0x038e97a9, 0x03b43b17, 0x3fe48990, 0x3fe3ce26, 0x03c0c69e, 0x03e66852, 0x3fe18d1f, 
	0x3fe0c7da, 0x03f2f342, 0x04189326, 0x3fde6945, 0x3fdd9a27, 0x04251d77, 0x044abb73, 0x3fdb1e06, 
	0x3fda450f, 0x0457451d, 0x047ce11a, 0x3fd7ab64, 0x3fd6c894, 0x04896a16, 0x04af03fc, 0x3fd4115f, 
	0x3fd324b7, 0x04bb8c42, 0x04e123fa, 0x3fd04ffc, 0x3fcf597c, 0x04edab83, 0x051340f6, 0x3fcc673b, 
	0x3fcb66e4, 0x051fc7b9, 0x05455ad1, 0x3fc8571f, 0x3fc74cf3, 0x0551e0c7, 0x0577716b, 0x3fc41fac, 
	0x3fc30baa, 0x0583f68c, 0x05a984a6, 0x3fbfc0e3, 0x3fbea30c, 0x05b608eb, 0x05db9463, 0x3fbb3ac7, 
	0x3fba131b, 0x05e817c3, 0x060da083, 0x3fb68d5b, 0x3fb55bdc, 0x061a22f7, 0x063fa8e7, 0x3fb1b8a2, 
	0x3fb07d50, 0x064c2a67, 0x0671ad71, 0x3facbc9f, 0x3fab777b, 0x067e2df5, 0x06a3ae00, 0x3fa79954, 
	0x3fa64a5f, 0x06b02d81, 0x06d5aa77, 0x3fa24ec6, 0x3fa0f600, 0x06e228ee, 0x0707a2b7, 0x3f9cdcf7, 
	0x3f9b7a62, 0x0714201b, 0x073996a1, 0x3f9743eb, 0x3f95d787, 0x074612eb, 0x076b8616, 0x3f9183a5, 
	0x3f900d72, 0x0778013d, 0x079d70f7, 0x3f8b9c28, 0x3f8a1c29, 0x07a9eaf5, 0x07cf5726, 0x3f858d79, 
	0x3f8403ae, 0x07dbcff2, 0x08013883, 0x3f7f579b, 0x3f7dc405, 0x080db016, 0x083314f1, 0x3f78fa92, 
	0x3f775d31, 0x083f8b43, 0x0864ec4f, 0x3f727661, 0x3f70cf38, 0x08716159, 0x0896be80, 0x3f6bcb0e, 
	0x3f6a1a1c, 0x08a3323a, 0x08c88b65, 0x3f64f89b, 0x3f633de2, 0x08d4fdc6, 0x08fa52de, 0x3f5dff0e, 
	0x3f5c3a8f, 0x0906c3e0, 0x092c14ce, 0x3f56de6a, 0x3f551026, 0x09388469, 0x095dd116, 0x3f4f96b4, 
	0x3f4dbeac, 0x096a3f42, 0x098f8796, 0x3f4827f0, 0x3f464626, 0x099bf44c, 0x09c13831, 0x3f409223, 
	0x3f3ea697, 0x09cda368, 0x09f2e2c7, 0x3f38d552, 0x3f36e006, 0x09ff4c78, 0x0a24873a, 0x3f30f181, 
	0x3f2ef276, 0x0a30ef5e, 0x0a56256c, 0x3f28e6b6, 0x3f26ddec, 0x0a628bfa, 0x0a87bd3d, 0x3f20b4f5, 
	0x3f1ea26e, 0x0a94222f, 0x0ab94e8f, 0x3f185c43, 0x3f164001, 0x0ac5b1dc, 0x0aead944, 0x3f0fdca5, 
	0x3f0db6a9, 0x0af73ae5, 0x0b1c5d3d, 0x3f073621, 0x3f05066d, 0x0b28bd2a, 0x0b4dda5c, 0x3efe68bc, 
	0x3efc2f50, 0x0b5a388d, 0x0b7f5081, 0x3ef5747b, 0x3ef3315a, 0x0b8bacf0, 0x0bb0bf8f, 0x3eec5965, 
	0x3eea0c8e, 0x0bbd1a33, 0x0be22766, 0x3ee3177e, 0x3ee0c0f4, 0x0bee8038, 0x0c1387e9, 0x3ed9aecc, 
	0x3ed74e91, 0x0c1fdee1, 0x0c44e0f9, 0x3ed01f55, 0x3ecdb56a, 0x0c513610, 0x0c763278, 0x3ec66920, 
	0x3ec3f585, 0x0c8285a5, 0x0ca77c47, 0x3ebc8c31, 0x3eba0ee9, 0x0cb3cd84, 0x0cd8be47, 0x3eb2888f, 
	0x3eb0019c, 0x0ce50d8c, 0x0d09f85b, 0x3ea85e41, 0x3ea5cda3, 0x0d1645a0, 0x0d3b2a64, 0x3e9e0d4c, 
	0x3e9b7306, 0x0d4775a1, 0x0d6c5443, 0x3e9395b7, 0x3e90f1ca, 0x0d789d71, 0x0d9d75db, 0x3e88f788, 
	0x3e8649f5, 0x0da9bcf2, 0x0dce8f0d, 0x3e7e32c6, 0x3e7b7b90, 0x0ddad406, 0x0dff9fba, 0x3e734778, 
	0x3e70869f, 0x0e0be28e, 0x0e30a7c5, 0x3e6835a4, 0x3e656b2b, 0x0e3ce86b, 0x0e61a70f, 0x3e5cfd51, 
	0x3e5a2939, 0x0e6de580, 0x0e929d7a, 0x3e519e86, 0x3e4ec0d1, 0x0e9ed9af, 0x0ec38ae8, 0x3e46194a, 
	0x3e4331fa, 0x0ecfc4d9, 0x0ef46f3b, 0x3e3a6da4, 0x3e377cbb, 0x0f00a6df, 0x0f254a53, 0x3e2e9b9c, 
	0x3e2ba11b, 0x0f317fa5, 0x0f561c15, 0x3e22a338, 0x3e1f9f21, 0x0f624f0c, 0x0f86e460, 0x3e168480, 
	0x3e1376d5, 0x0f9314f5, 0x0fb7a317, 0x3e0a3f7b, 0x3e07283f, 0x0fc3d143, 0x0fe8581d, 0x3dfdd432, 
	0x3dfab365, 0x0ff483d7, 0x10190352, 0x3df142ab, 0x3dee1851, 0x10252c94, 0x1049a49a, 0x3de48aef, 
	0x3de15708, 0x1055cb5b, 0x107a3bd5, 0x3dd7ad05, 0x3dd46f94, 0x1086600e, 0x10aac8e6, 0x3dcaa8f5, 
	0x3dc761fc, 0x10b6ea90, 0x10db4baf, 0x3dbd7ec7, 0x3dba2e48, 0x10e76ac3, 0x110bc413, 0x3db02e84, 
	0x3dacd481, 0x1117e088, 0x113c31f3, 0x3da2b834, 0x3d9f54af, 0x11484bc2, 0x116c9531, 0x3d951bde, 
	0x3d91aed9, 0x1178ac53, 0x119cedaf, 0x3d87598c, 0x3d83e309, 0x11a9021d, 0x11cd3b50, 0x3d797145, 
	0x3d75f147, 0x11d94d02, 0x11fd7df6, 0x3d6b6313, 0x3d67d99b, 0x12098ce5, 0x122db583, 0x3d5d2efe, 
	0x3d599c0e, 0x1239c1a7, 0x125de1da, 0x3d4ed50f, 0x3d4b38aa, 0x1269eb2b, 0x128e02dc, 0x3d40554e, 
	0x3d3caf76, 0x129a0954, 0x12be186c, 0x3d31afc5, 0x3d2e007c, 0x12ca1c03, 0x12ee226c, 0x3d22e47c, 
	0x3d1f2bc5, 0x12fa231b, 0x131e20c0, 0x3d13f37e, 0x3d10315a, 0x132a1e7e, 0x134e1348, 0x3d04dcd2, 
	0x3d011145, 0x135a0e0e, 0x137df9e7, 0x3cf5a082, 0x3cf1cb8e, 0x1389f1af, 0x13add481, 0x3ce63e98, 
	0x3ce2603f, 0x13b9c943, 0x13dda2f7, 0x3cd6b71e, 0x3cd2cf62, 0x13e994ab, 0x140d652c, 0x3cc70a1c, 
	0x3cc318ff, 0x141953cb, 0x143d1b02, 0x3cb7379c, 0x3cb33d22, 0x14490685, 0x146cc45c, 0x3ca73fa9, 
	0x3ca33bd3, 0x1478acbc, 0x149c611d, 0x3c97224c, 0x3c93151d, 0x14a84652, 0x14cbf127, 0x3c86df8e, 
	0x3c82c909, 0x14d7d32a, 0x14fb745e, 0x3c76777b, 0x3c7257a2, 0x15075327, 0x152aeaa3, 0x3c65ea1c, 
	0x3c61c0f1, 0x1536c62b, 0x155a53d9, 0x3c55377b, 0x3c510501, 0x15662c18, 0x1589afe3, 0x3c445fa2, 
	0x3c4023dd, 0x159584d3, 0x15b8fea4, 0x3c33629d, 0x3c2f1d8e, 0x15c4d03e, 0x15e83fff, 0x3c224075, 
	0x3c1df21f, 0x15f40e3a, 0x161773d6, 0x3c10f935, 0x3c0ca19b, 0x16233eac, 0x16469a0d, 0x3bff8ce8, 
	0x3bfb2c0c, 0x16526176, 0x1675b286, 0x3bedfb99, 0x3be9917e, 0x1681767c, 0x16a4bd25, 0x3bdc4552, 
	0x3bd7d1fa, 0x16b07d9f, 0x16d3b9cc, 0x3bca6a1d, 0x3bc5ed8d, 0x16df76c3, 0x1702a85e, 0x3bb86a08, 
	0x3bb3e440, 0x170e61cc, 0x173188be, 0x3ba6451b, 0x3ba1b620, 0x173d3e9b, 0x17605ad0, 0x3b93fb63, 
	0x3b8f6337, 0x176c0d15, 0x178f1e76, 0x3b818ceb, 0x3b7ceb90, 0x179acd1c, 0x17bdd394, 0x3b6ef9be, 
	0x3b6a4f38, 0x17c97e93, 0x17ec7a0d, 0x3b5c41e8, 0x3b578e39, 0x17f8215e, 0x181b11c4, 0x3b496574, 
	0x3b44a8a0, 0x1826b561, 0x18499a9d, 0x3b36646e, 0x3b319e77, 0x18553a7d, 0x1878147a, 0x3b233ee1, 
	0x3b1e6fca, 0x1883b097, 0x18a67f3f, 0x3b0ff4d9, 0x3b0b1ca6, 0x18b21791, 0x18d4dad0, 0x3afc8663, 
	0x3af7a516, 0x18e06f50, 0x1903270f, 0x3ae8f38b, 0x3ae40926, 0x190eb7b7, 0x193163e1, 0x3ad53c5b, 
	0x3ad048e3, 0x193cf0a9, 0x195f9128, 0x3ac160e1, 0x3abc6458, 0x196b1a09, 0x198daec8, 0x3aad6129, 
	0x3aa85b92, 0x199933bb, 0x19bbbca6, 0x3a993d3e, 0x3a942e9d, 0x19c73da3, 0x19e9baa3, 0x3a84f52f, 
	0x3a7fdd86, 0x19f537a4, 0x1a17a8a5, 0x3a708906, 0x3a6b6859, 0x1a2321a2, 0x1a45868e, 0x3a5bf8d1, 
	0x3a56cf23, 0x1a50fb81, 0x1a735442, 0x3a47449c, 0x3a4211f0, 0x1a7ec524, 0x1aa111a6, 0x3a326c74, 
	0x3a2d30cd, 0x1aac7e6f, 0x1acebe9d, 0x3a1d7066, 0x3a182bc8, 0x1ada2746, 0x1afc5b0a, 0x3a08507f, 
	0x3a0302ed, 0x1b07bf8c, 0x1b29e6d2, 0x39f30ccc, 0x39edb649, 0x1b354727, 0x1b5761d8, 0x39dda55a, 
	0x39d845e9, 0x1b62bdf8, 0x1b84cc01, 0x39c81a36, 0x39c2b1da, 0x1b9023e5, 0x1bb22530, 0x39b26b6d, 
	0x39acfa2b, 0x1bbd78d2, 0x1bdf6d4a, 0x399c990d, 0x39971ee7, 0x1beabca1, 0x1c0ca432, 0x3986a324, 
	0x3981201e, 0x1c17ef39, 0x1c39c9cd, 0x397089bf, 0x396afddc, 0x1c45107c, 0x1c66ddfe, 0x395a4ceb, 
	0x3954b82e, 0x1c72204f, 0x1c93e0ab, 0x3943ecb6, 0x393e4f23, 0x1c9f1e96, 0x1cc0d1b6, 0x392d692f, 
	0x3927c2c9, 0x1ccc0b35, 0x1cedb106, 0x3916c262, 0x3911132d, 0x1cf8e611, 0x1d1a7e7d, 0x38fff85e, 
	0x38fa405e, 0x1d25af0d, 0x1d473a00, 0x38e90b31, 0x38e34a69, 0x1d52660f, 0x1d73e374, 0x38d1fae9, 
	0x38cc315d, 0x1d7f0afb, 0x1da07abc, 0x38bac795, 0x38b4f547, 0x1dab9db5, 0x1dccffbf, 0x38a37142, 
	0x389d9637, 0x1dd81e21, 0x1df9725f, 0x388bf7ff, 0x3886143b, 0x1e048c24, 0x1e25d282, 0x38745bdb, 
	0x386e6f60, 0x1e30e7a4, 0x1e52200c, 0x385c9ce3, 0x3856a7b6, 0x1e5d3084, 0x1e7e5ae2, 0x3844bb28, 
	0x383ebd4c, 0x1e8966a8, 0x1eaa82e9, 0x382cb6b7, 0x3826b030, 0x1eb589f7, 0x1ed69805, 0x38148f9f, 
	0x380e8071, 0x1ee19a54, 0x1f029a1c, 0x37fc45ef, 0x37f62e1d, 0x1f0d97a5, 0x1f2e8911, 0x37e3d9b7, 
	0x37ddb945, 0x1f3981ce, 0x1f5a64cb, 0x37cb4b04, 0x37c521f6, 0x1f6558b5, 0x1f862d2d, 0x37b299e7, 
	0x37ac6841, 0x1f911c3d, 0x1fb1e21d, 0x3799c66f, 0x37938c34, 0x1fbccc4d, 0x1fdd8381, 0x3780d0aa, 
	0x377a8ddf, 0x1fe868c8, 0x2009113c, 0x3767b8a9, 0x37616d51, 0x2013f196, 0x20348b35, 0x374e7e7b, 
	0x37482a9a, 0x203f6699, 0x205ff14f, 0x3735222f, 0x372ec5c9, 0x206ac7b8, 0x208b4372, 0x371ba3d4, 
	0x37153eee, 0x209614d9, 0x20b68181, 0x3702037c, 0x36fb9618, 0x20c14ddf, 0x20e1ab63, 0x36e84135, 
	0x36e1cb58, 0x20ec72b1, 0x210cc0fc, 0x36ce5d10, 0x36c7debd, 0x21178334, 0x2137c232, 0x36b4571b, 
	0x36add058, 0x21427f4d, 0x2162aeea, 0x369a2f69, 0x3693a038, 0x216d66e2, 0x218d870b, 0x367fe608, 
	0x36794e6e, 0x219839d8, 0x21b84a79, 0x36657b08, 0x365edb09, 0x21c2f815, 0x21e2f91a, 0x364aee7b, 
	0x3644461b, 0x21eda17f, 0x220d92d4, 0x36304070, 0x36298fb4, 0x221835fb, 0x2238178d, 0x361570f8, 
	0x360eb7e3, 0x2242b56f, 0x22628729, 0x35fa8023, 0x35f3beba, 0x226d1fc1, 0x228ce191, 0x35df6e03, 
	0x35d8a449, 0x229774d7, 0x22b726a8, 0x35c43aa7, 0x35bd68a1, 0x22c1b496, 0x22e15655, 0x35a8e621, 
	0x35a20bd3, 0x22ebdee5, 0x230b707e, 0x358d7081, 0x35868def, 0x2315f3a8, 0x23357509, 0x3571d9d9, 
	0x356aef08, 0x233ff2c8, 0x235f63dc, 0x35562239, 0x354f2f2c, 0x2369dc29, 0x23893cdd, 0x353a49b2, 
	0x35334e6f, 0x2393afb2, 0x23b2fff3, 0x351e5056, 0x35174ce0, 0x23bd6d48, 0x23dcad03, 0x35023636, 
	0x34fb2a92, 0x23e714d3, 0x240643f4, 0x34e5fb63, 0x34dee795, 0x2410a639, 0x242fc4ad, 0x34c99fef, 
	0x34c283fb, 0x243a215f, 0x24592f13, 0x34ad23eb, 0x34a5ffd5, 0x2463862c, 0x2482830d, 0x34908768, 
	0x34895b36, 0x248cd487, 0x24abc082, 0x3473ca79, 0x346c962f, 0x24b60c57, 0x24d4e757, 0x3456ed2f, 
	0x344fb0d1, 0x24df2d81, 0x24fdf775, 0x3439ef9c, 0x3432ab2e, 0x250837ed, 0x2526f0c1, 0x341cd1d2, 
	0x34158559, 0x25312b81, 0x254fd323, 0x33ff93e2, 0x33f83f62, 0x255a0823, 0x25789e80, 0x33e235df, 
	0x33dad95e, 0x2582cdbc, 0x25a152c0, 0x33c4b7db, 0x33bd535c, 0x25ab7c30, 0x25c9efca, 0x33a719e8, 
	0x339fad70, 0x25d41369, 0x25f27584, 0x33895c18, 0x3381e7ac, 0x25fc934b, 0x261ae3d6, 0x336b7e7e, 
	0x33640223, 0x2624fbbf, 0x26433aa7, 0x334d812d, 0x3345fce6, 0x264d4cac, 0x266b79dd, 0x332f6435, 
	0x3327d808, 0x267585f8, 0x2693a161, 0x331127ab, 0x3309939c, 0x269da78b, 0x26bbb119, 0x32f2cba1, 
	0x32eb2fb5, 0x26c5b14c, 0x26e3a8ec, 0x32d45029, 0x32ccac64, 0x26eda322, 0x270b88c2, 0x32b5b557, 
	0x32ae09be, 0x27157cf5, 0x27335082, 0x3296fb3d, 0x328f47d5, 0x273d3eac, 0x275b0014, 0x327821ee, 
	0x327066bc, 0x2764e82f, 0x27829760, 0x3259297d, 0x32516686, 0x278c7965, 0x27aa164c, 0x323a11fe, 
	0x32324746, 0x27b3f235, 0x27d17cc1, 0x321adb83, 0x3213090f, 0x27db5288, 0x27f8caa5, 0x31fb8620, 
	0x31f3abf5, 0x28029a45, 0x281fffe2, 0x31dc11e8, 0x31d4300b, 0x2829c954, 0x28471c5e, 0x31bc7eee, 
	0x31b49564, 0x2850df9d, 0x286e2002, 0x319ccd46, 0x3194dc14, 0x2877dd07, 0x28950ab6, 0x317cfd04, 
	0x3175042e, 0x289ec17a, 0x28bbdc61, 0x315d0e3b, 0x31550dc6, 0x28c58cdf, 0x28e294eb, 0x313d00ff, 
	0x3134f8f1, 0x28ec3f1e, 0x2909343e, 0x311cd564, 0x3114c5c0, 0x2912d81f, 0x292fba40, 0x30fc8b7d, 
	0x30f47449, 0x293957c9, 0x295626da, 0x30dc235e, 0x30d404a0, 0x295fbe06, 0x297c79f5, 0x30bb9d1c, 
	0x30b376d8, 0x29860abd, 0x29a2b378, 0x309af8ca, 0x3092cb05, 0x29ac3dd7, 0x29c8d34d, 0x307a367c, 
	0x3072013c, 0x29d2573c, 0x29eed95b, 0x30595648, 0x30511991, 0x29f856d5, 0x2a14c58b, 0x30385840, 
	0x30301418, 0x2a1e3c8a, 0x2a3a97c7, 0x30173c7a, 0x300ef0e5, 0x2a440844, 0x2a604ff5, 0x2ff6030a, 
	0x2fedb00d, 0x2a69b9ec, 0x2a85ee00, 0x2fd4ac04, 0x2fcc51a5, 0x2a8f516b, 0x2aab71d0, 0x2fb3377c, 
	0x2faad5c1, 0x2ab4cea9, 0x2ad0db4e, 0x2f91a589, 0x2f893c75, 0x2ada318e, 0x2af62a63, 0x2f6ff63d, 
	0x2f6785d7, 0x2aff7a05, 0x2b1b5ef8, 0x2f4e29af, 0x2f45b1fb, 0x2b24a7f6, 0x2b4078f5, 0x2f2c3ff2, 
	0x2f23c0f6, 0x2b49bb4a, 0x2b657844, 0x2f0a391d, 0x2f01b2de, 0x2b6eb3ea, 0x2b8a5cce, 0x2ee81543, 
	0x2edf87c6, 0x2b9391c0, 0x2baf267d, 0x2ec5d479, 0x2ebd3fc4, 0x2bb854b4, 0x2bd3d53a, 0x2ea376d6, 
	0x2e9adaee, 0x2bdcfcb0, 0x2bf868ed, 0x2e80fc6e, 0x2e785958, 0x2c01899e, 0x2c1ce181, 0x2e5e6556, 
	0x2e55bb17, 0x2c25fb66, 0x2c413edf, 0x2e3bb1a4, 0x2e330042, 0x2c4a51f3, 0x2c6580f1, 0x2e18e16d, 
	0x2e1028ed, 0x2c6e8d2e, 0x2c89a79f, 0x2df5f4c7, 0x2ded352f, 0x2c92ad01, 0x2cadb2d5, 0x2dd2ebc7, 
	0x2dca251c, 0x2cb6b155, 0x2cd1a27b, 0x2dafc683, 0x2da6f8ca, 0x2cda9a14, 0x2cf5767c, 0x2d8c8510, 
	0x2d83b04f, 0x2cfe6728, 0x2d192ec1, 0x2d692784, 0x2d604bc0, 0x2d22187a, 0x2d3ccb34, 0x2d45adf6
};


const int twidTab512[(8*6 + 32*6 + 128*6)/2] = {
	0x40000000, 0x40000000, 0x40000000, 0x3b20187d, 
	0x3ec50c7c, 0x3536238e, 0x2d412d41, 0x3b20187d, 
	0x187d3b20, 0x187d3b20, 0x3536238e, 0xf3843ec5, 
	0x00004000, 0x2d412d41, 0xd2bf2d41, 0xe7833b20, 
	0x238e3536, 0xc13b0c7c, 0xd2bf2d41, 0x187d3b20, 
	0xc4e0e783, 0xc4e0187d, 0x0c7c3ec5, 0xdc72caca, 

	0x40000000, 0x40000000, 0x40000000, 0x3fb10645, 
	0x3fec0323, 0x3f4e0964, 0x3ec50c7c, 0x3fb10645, 
	0x3d3e1294, 0x3d3e1294, 0x3f4e0964, 0x39da1b5d, 
	0x3b20187d, 0x3ec50c7c, 0x3536238e, 0x38711e2b, 
	0x3e140f8c, 0x2f6b2afa, 0x3536238e, 0x3d3e1294, 
	0x28993179, 0x31792899, 0x3c42158f, 0x20e736e5, 
	0x2d412d41, 0x3b20187d, 0x187d3b20, 0x28993179, 
	0x39da1b5d, 0x0f8c3e14, 0x238e3536, 0x38711e2b, 
	0x06453fb1, 0x1e2b3871, 0x36e520e7, 0xfcdd3fec, 
	0x187d3b20, 0x3536238e, 0xf3843ec5, 0x12943d3e, 
	0x3367261f, 0xea713c42, 0x0c7c3ec5, 0x31792899, 
	0xe1d53871, 0x06453fb1, 0x2f6b2afa, 0xd9e13367, 
	0x00004000, 0x2d412d41, 0xd2bf2d41, 0xf9bb3fb1, 
	0x2afa2f6b, 0xcc99261f, 0xf3843ec5, 0x28993179, 
	0xc78f1e2b, 0xed6c3d3e, 0x261f3367, 0xc3be158f, 
	0xe7833b20, 0x238e3536, 0xc13b0c7c, 0xe1d53871, 
	0x20e736e5, 0xc0140323, 0xdc723536, 0x1e2b3871, 
	0xc04ff9bb, 0xd7673179, 0x1b5d39da, 0xc1ecf074, 
	0xd2bf2d41, 0x187d3b20, 0xc4e0e783, 0xce872899, 
	0x158f3c42, 0xc91bdf19, 0xcaca238e, 0x12943d3e, 
	0xce87d767, 0xc78f1e2b, 0x0f8c3e14, 0xd506d095, 
	0xc4e0187d, 0x0c7c3ec5, 0xdc72caca, 0xc2c21294, 
	0x09643f4e, 0xe4a3c626, 0xc13b0c7c, 0x06453fb1, 
	0xed6cc2c2, 0xc04f0645, 0x03233fec, 0xf69cc0b2, 

	0x40000000, 0x40000000, 0x40000000, 0x3ffb0192, 
	0x3ffe00c9, 0x3ff4025b, 0x3fec0323, 0x3ffb0192, 
	0x3fd304b5, 0x3fd304b5, 0x3ff4025b, 0x3f9c070d, 
	0x3fb10645, 0x3fec0323, 0x3f4e0964, 0x3f8407d5, 
	0x3fe103ec, 0x3eeb0bb6, 0x3f4e0964, 0x3fd304b5, 
	0x3e710e05, 0x3f0e0af1, 0x3fc3057d, 0x3de2104f, 
	0x3ec50c7c, 0x3fb10645, 0x3d3e1294, 0x3e710e05, 
	0x3f9c070d, 0x3c8414d1, 0x3e140f8c, 0x3f8407d5, 
	0x3bb61708, 0x3dae1111, 0x3f6a089c, 0x3ad21937, 
	0x3d3e1294, 0x3f4e0964, 0x39da1b5d, 0x3cc51413, 
	0x3f2f0a2a, 0x38cf1d79, 0x3c42158f, 0x3f0e0af1, 
	0x37af1f8b, 0x3bb61708, 0x3eeb0bb6, 0x367c2192, 
	0x3b20187d, 0x3ec50c7c, 0x3536238e, 0x3a8219ef, 
	0x3e9c0d41, 0x33de257d, 0x39da1b5d, 0x3e710e05, 
	0x3274275f, 0x392a1cc6, 0x3e440ec9, 0x30f82934, 
	0x38711e2b, 0x3e140f8c, 0x2f6b2afa, 0x37af1f8b, 
	0x3de2104f, 0x2dce2cb2, 0x36e520e7, 0x3dae1111, 
	0x2c212e5a, 0x3612223d, 0x3d7711d3, 0x2a652ff1, 
	0x3536238e, 0x3d3e1294, 0x28993179, 0x345324da, 
	0x3d021354, 0x26c032ee, 0x3367261f, 0x3cc51413, 
	0x24da3453, 0x3274275f, 0x3c8414d1, 0x22e635a5, 
	0x31792899, 0x3c42158f, 0x20e736e5, 0x307629cd, 
	0x3bfd164c, 0x1edc3811, 0x2f6b2afa, 0x3bb61708, 
	0x1cc6392a, 0x2e5a2c21, 0x3b6c17c3, 0x1aa63a2f, 
	0x2d412d41, 0x3b20187d, 0x187d3b20, 0x2c212e5a, 
	0x3ad21937, 0x164c3bfd, 0x2afa2f6b, 0x3a8219ef, 
	0x14133cc5, 0x29cd3076, 0x3a2f1aa6, 0x11d33d77, 
	0x28993179, 0x39da1b5d, 0x0f8c3e14, 0x275f3274, 
	0x39831c12, 0x0d413e9c, 0x261f3367, 0x392a1cc6, 
	0x0af13f0e, 0x24da3453, 0x38cf1d79, 0x089c3f6a, 
	0x238e3536, 0x38711e2b, 0x06453fb1, 0x223d3612, 
	0x38111edc, 0x03ec3fe1, 0x20e736e5, 0x37af1f8b, 
	0x01923ffb, 0x1f8b37af, 0x374b2039, 0xff373ffe, 
	0x1e2b3871, 0x36e520e7, 0xfcdd3fec, 0x1cc6392a, 
	0x367c2192, 0xfa833fc3, 0x1b5d39da, 0x3612223d, 
	0xf82b3f84, 0x19ef3a82, 0x35a522e6, 0xf5d63f2f, 
	0x187d3b20, 0x3536238e, 0xf3843ec5, 0x17083bb6, 
	0x34c62434, 0xf1373e44, 0x158f3c42, 0x345324da, 
	0xeeef3dae, 0x14133cc5, 0x33de257d, 0xecac3d02, 
	0x12943d3e, 0x3367261f, 0xea713c42, 0x11113dae, 
	0x32ee26c0, 0xe83d3b6c, 0x0f8c3e14, 0x3274275f, 
	0xe6113a82, 0x0e053e71, 0x31f727fd, 0xe3ee3983, 
	0x0c7c3ec5, 0x31792899, 0xe1d53871, 0x0af13f0e, 
	0x30f82934, 0xdfc7374b, 0x09643f4e, 0x307629cd, 
	0xddc33612, 0x07d53f84, 0x2ff12a65, 0xdbcc34c6, 
	0x06453fb1, 0x2f6b2afa, 0xd9e13367, 0x04b53fd3, 
	0x2ee32b8e, 0xd80331f7, 0x03233fec, 0x2e5a2c21, 
	0xd6333076, 0x01923ffb, 0x2dce2cb2, 0xd4722ee3, 
	0x00004000, 0x2d412d41, 0xd2bf2d41, 0xfe6e3ffb, 
	0x2cb22dce, 0xd11d2b8e, 0xfcdd3fec, 0x2c212e5a, 
	0xcf8a29cd, 0xfb4b3fd3, 0x2b8e2ee3, 0xce0927fd, 
	0xf9bb3fb1, 0x2afa2f6b, 0xcc99261f, 0xf82b3f84, 
	0x2a652ff1, 0xcb3a2434, 0xf69c3f4e, 0x29cd3076, 
	0xc9ee223d, 0xf50f3f0e, 0x293430f8, 0xc8b52039, 
	0xf3843ec5, 0x28993179, 0xc78f1e2b, 0xf1fb3e71, 
	0x27fd31f7, 0xc67d1c12, 0xf0743e14, 0x275f3274, 
	0xc57e19ef, 0xeeef3dae, 0x26c032ee, 0xc49417c3, 
	0xed6c3d3e, 0x261f3367, 0xc3be158f, 0xebed3cc5, 
	0x257d33de, 0xc2fe1354, 0xea713c42, 0x24da3453, 
	0xc2521111, 0xe8f83bb6, 0x243434c6, 0xc1bc0ec9, 
	0xe7833b20, 0x238e3536, 0xc13b0c7c, 0xe6113a82, 
	0x22e635a5, 0xc0d10a2a, 0xe4a339da, 0x223d3612, 
	0xc07c07d5, 0xe33a392a, 0x2192367c, 0xc03d057d, 
	0xe1d53871, 0x20e736e5, 0xc0140323, 0xe07537af, 
	0x2039374b, 0xc00200c9, 0xdf1936e5, 0x1f8b37af, 
	0xc005fe6e, 0xddc33612, 0x1edc3811, 0xc01ffc14, 
	0xdc723536, 0x1e2b3871, 0xc04ff9bb, 0xdb263453, 
	0x1d7938cf, 0xc096f764, 0xd9e13367, 0x1cc6392a, 
	0xc0f2f50f, 0xd8a13274, 0x1c123983, 0xc164f2bf, 
	0xd7673179, 0x1b5d39da, 0xc1ecf074, 0xd6333076, 
	0x1aa63a2f, 0xc289ee2d, 0xd5062f6b, 0x19ef3a82, 
	0xc33bebed, 0xd3df2e5a, 0x19373ad2, 0xc403e9b4, 
	0xd2bf2d41, 0x187d3b20, 0xc4e0e783, 0xd1a62c21, 
	0x17c33b6c, 0xc5d1e55a, 0xd0952afa, 0x17083bb6, 
	0xc6d6e33a, 0xcf8a29cd, 0x164c3bfd, 0xc7efe124, 
	0xce872899, 0x158f3c42, 0xc91bdf19, 0xcd8c275f, 
	0x14d13c84, 0xca5bdd1a, 0xcc99261f, 0x14133cc5, 
	0xcbaddb26, 0xcbad24da, 0x13543d02, 0xcd12d940, 
	0xcaca238e, 0x12943d3e, 0xce87d767, 0xc9ee223d, 
	0x11d33d77, 0xd00fd59b, 0xc91b20e7, 0x11113dae, 
	0xd1a6d3df, 0xc8511f8b, 0x104f3de2, 0xd34ed232, 
	0xc78f1e2b, 0x0f8c3e14, 0xd506d095, 0xc6d61cc6, 
	0x0ec93e44, 0xd6cccf08, 0xc6261b5d, 0x0e053e71, 
	0xd8a1cd8c, 0xc57e19ef, 0x0d413e9c, 0xda83cc22, 
	0xc4e0187d, 0x0c7c3ec5, 0xdc72caca, 0xc44a1708, 
	0x0bb63eeb, 0xde6ec984, 0xc3be158f, 0x0af13f0e, 
	0xe075c851, 0xc33b1413, 0x0a2a3f2f, 0xe287c731, 
	0xc2c21294, 0x09643f4e, 0xe4a3c626, 0xc2521111, 
	0x089c3f6a, 0xe6c9c52e, 0xc1ec0f8c, 0x07d53f84, 
	0xe8f8c44a, 0xc18f0e05, 0x070d3f9c, 0xeb2fc37c, 
	0xc13b0c7c, 0x06453fb1, 0xed6cc2c2, 0xc0f20af1, 
	0x057d3fc3, 0xefb1c21e, 0xc0b20964, 0x04b53fd3, 
	0xf1fbc18f, 0xc07c07d5, 0x03ec3fe1, 0xf44ac115, 
	0xc04f0645, 0x03233fec, 0xf69cc0b2, 0xc02d04b5, 
	0x025b3ff4, 0xf8f3c064, 0xc0140323, 0x01923ffb, 
	0xfb4bc02d, 0xc0050192, 0x00c93ffe, 0xfda5c00c	
};

const int twidTab64[(4*6 + 16*6)/2] = {
	0x40000000, 0x40000000, 0x40000000, 0x2d412d41, 
	0x3b20187d, 0x187d3b20, 0x00004000, 0x2d412d41, 
	0xd2bf2d41, 0xd2bf2d41, 0x187d3b20, 0xc4e0e783, 

	0x40000000, 0x40000000, 0x40000000, 0x3ec50c7c, 
	0x3fb10645, 0x3d3e1294, 0x3b20187d, 0x3ec50c7c, 
	0x3536238e, 0x3536238e, 0x3d3e1294, 0x28993179, 
	0x2d412d41, 0x3b20187d, 0x187d3b20, 0x238e3536, 
	0x38711e2b, 0x06453fb1, 0x187d3b20, 0x3536238e, 
	0xf3843ec5, 0x0c7c3ec5, 0x31792899, 0xe1d53871, 
	0x00004000, 0x2d412d41, 0xd2bf2d41, 0xf3843ec5, 
	0x28993179, 0xc78f1e2b, 0xe7833b20, 0x238e3536, 
	0xc13b0c7c, 0xdc723536, 0x1e2b3871, 0xc04ff9bb, 
	0xd2bf2d41, 0x187d3b20, 0xc4e0e783, 0xcaca238e, 
	0x12943d3e, 0xce87d767, 0xc4e0187d, 0x0c7c3ec5, 
	0xdc72caca, 0xc13b0c7c, 0x06453fb1, 0xed6cc2c2 
};

#elif defined ARMV7Neon
/* 
 *  Q29 for 128 and 1024 
 *
 * for (i = 0; i < num/4; i++) {
 *   angle = (i + 0.125) * M_PI / num;
 *   x = cos(angle) * (1 << 29);
 *   x = sin(angle) * (1 << 29);
 * 
 *   angle = (num/2 - 1 - i + 0.125) * M_PI / num;
 *   x = cos(angle) * (1 << 29);
 *   x = sin(angle) * (1 << 29);
 * }
 */
const int cossintab[128 + 1024] = {
	/* 128 */
	0x1ffff621, 0x001921f9, 0x00afea69, 0x1ffe1c68, 0x1ffce09d, 0x00e22a7a, 0x0178dbaa, 0x1ff753bb, 
	0x1ff4dc55, 0x01ab101c, 0x024192cf, 0x1feb9d25, 0x1fe7ea85, 0x0273b3e2, 0x0309f0e2, 0x1fdafa75, 
	0x1fd60d2e, 0x033bf6dd, 0x03d1d700, 0x1fc56e3b, 0x1fbf470f, 0x0403ba2b, 0x04992653, 0x1faafbcb, 
	0x1fa39bac, 0x04cadefe, 0x055fc022, 0x1f8ba738, 0x1f830f4a, 0x059146a1, 0x062585ca, 0x1f677557, 
	0x1f5da6ed, 0x0656d27a, 0x06ea58cd, 0x1f3e6bbc, 0x1f33685a, 0x071b6415, 0x07ae1ad2, 0x1f1090bd, 
	0x1f045a15, 0x07dedd20, 0x0870ada7, 0x1eddeb6a, 0x1ed0835f, 0x08a11f78, 0x0931f34d, 0x1ea68394, 
	0x1e97ec36, 0x09620d27, 0x09f1cdf5, 0x1e6a61c5, 0x1e5a9d55, 0x0a21886e, 0x0ab02009, 0x1e298f44, 
	0x1e18a030, 0x0adf73c6, 0x0b6ccc32, 0x1de4160f, 0x1dd1fef4, 0x0b9bb1e5, 0x0c27b555, 0x1d9a00de, 
	0x1d86c484, 0x0c5625c3, 0x0ce0bea2, 0x1d4b5b1b, 0x1d36fc7c, 0x0d0eb2a2, 0x0d97cb8f, 0x1cf830e9, 
	0x1ce2b328, 0x0dc53c0a, 0x0e4cbfe2, 0x1ca08f1a, 0x1c89f587, 0x0e79a5d7, 0x0eff7fb3, 0x1c448331, 
	0x1c2cd149, 0x0f2bd437, 0x0fafef73, 0x1be41b61, 0x1bcb54cb, 0x0fdbabae, 0x105df3ec, 0x1b7f6687, 
	0x1b658f15, 0x10891120, 0x11097249, 0x1b16742a, 0x1afb8fd9, 0x1133e9d0, 0x11b25017, 0x1aa9547a, 
	0x1a8d676e, 0x11dc1b65, 0x1258734d, 0x1a38184a, 0x1a1b26d3, 0x12818bef, 0x12fbc24b, 0x19c2d111, 
	0x19a4dfa4, 0x132421ec, 0x139c23e4, 0x194990e4, 0x192aa420, 0x13c3c44a, 0x14397f5b, 0x18cc6a75, 
	0x18ac871f, 0x14605a69, 0x14d3bc6d, 0x184b7112, 0x182a9c14, 0x14f9cc26, 0x156ac352, 0x17c6b89d, 
	0x17a4f708, 0x159001d6, 0x15fe7cbe, 0x173e558e, 0x171bac96, 0x1622e450, 0x168ed1eb, 0x16b25ced,
	/* 1024 */
	0x1fffffd9, 0x0003243f, 0x0015fdba, 0x1ffff872, 0x1ffff382, 0x001c4637, 0x002f1fa6, 0x1fffdd4d, 
	0x1fffd36f, 0x0035681d, 0x00484175, 0x1fffae6c, 0x1fff9f9e, 0x004e89e3, 0x00616318, 0x1fff6bce, 
	0x1fff5811, 0x0067ab77, 0x007a847e, 0x1fff1572, 0x1ffefcc6, 0x0080cccc, 0x0093a599, 0x1ffeab5b, 
	0x1ffe8dbf, 0x0099edd2, 0x00acc658, 0x1ffe2d86, 0x1ffe0afc, 0x00b30e78, 0x00c5e6ad, 0x1ffd9bf6, 
	0x1ffd747c, 0x00cc2eb0, 0x00df0688, 0x1ffcf6aa, 0x1ffcca41, 0x00e54e6a, 0x00f825da, 0x1ffc3da2, 
	0x1ffc0c4b, 0x00fe6d97, 0x01114492, 0x1ffb70e0, 0x1ffb3a9a, 0x01178c27, 0x012a62a2, 0x1ffa9063, 
	0x1ffa552e, 0x0130aa0a, 0x01437ffa, 0x1ff99c2c, 0x1ff95c09, 0x0149c731, 0x015c9c8a, 0x1ff8943c, 
	0x1ff84f2b, 0x0162e38d, 0x0175b843, 0x1ff77893, 0x1ff72e94, 0x017bff0e, 0x018ed316, 0x1ff64932, 
	0x1ff5fa46, 0x019519a5, 0x01a7ecf2, 0x1ff5061b, 0x1ff4b240, 0x01ae3341, 0x01c105c9, 0x1ff3af4c, 
	0x1ff35684, 0x01c74bd5, 0x01da1d8c, 0x1ff244c8, 0x1ff1e713, 0x01e0634f, 0x01f33429, 0x1ff0c68f, 
	0x1ff063ed, 0x01f979a1, 0x020c4993, 0x1fef34a3, 0x1feecd14, 0x02128ebb, 0x02255db9, 0x1fed8f03, 
	0x1fed2287, 0x022ba28f, 0x023e708d, 0x1febd5b2, 0x1feb644a, 0x0244b50b, 0x025781fe, 0x1fea08b0, 
	0x1fe9925c, 0x025dc621, 0x027091fd, 0x1fe827fe, 0x1fe7acbe, 0x0276d5c1, 0x0289a07b, 0x1fe6339d, 
	0x1fe5b372, 0x028fe3dd, 0x02a2ad69, 0x1fe42b90, 0x1fe3a679, 0x02a8f063, 0x02bbb8b6, 0x1fe20fd6, 
	0x1fe185d5, 0x02c1fb46, 0x02d4c253, 0x1fdfe071, 0x1fdf5186, 0x02db0475, 0x02edca32, 0x1fdd9d64, 
	0x1fdd098e, 0x02f40be2, 0x0306d042, 0x1fdb46ae, 0x1fdaadee, 0x030d117c, 0x031fd474, 0x1fd8dc51, 
	0x1fd83ea8, 0x03261534, 0x0338d6b8, 0x1fd65e4f, 0x1fd5bbbd, 0x033f16fb, 0x0351d700, 0x1fd3ccaa, 
	0x1fd32530, 0x035816c1, 0x036ad53c, 0x1fd12763, 0x1fd07b00, 0x03711477, 0x0383d15c, 0x1fce6e7c, 
	0x1fcdbd31, 0x038a100e, 0x039ccb51, 0x1fcba1f5, 0x1fcaebc3, 0x03a30975, 0x03b5c30b, 0x1fc8c1d2, 
	0x1fc806b9, 0x03bc009f, 0x03ceb87c, 0x1fc5ce14, 0x1fc50e14, 0x03d4f57a, 0x03e7ab93, 0x1fc2c6bd, 
	0x1fc201d7, 0x03ede7f9, 0x04009c42, 0x1fbfabcd, 0x1fbee202, 0x0406d80b, 0x04198a78, 0x1fbc7d49, 
	0x1fbbae99, 0x041fc5a1, 0x04327628, 0x1fb93b31, 0x1fb8679c, 0x0438b0ac, 0x044b5f40, 0x1fb5e587, 
	0x1fb50d0e, 0x0451991d, 0x046445b2, 0x1fb27c4e, 0x1fb19ef1, 0x046a7ee3, 0x047d296f, 0x1faeff87, 
	0x1fae1d47, 0x048361f0, 0x04960a67, 0x1fab6f35, 0x1faa8813, 0x049c4235, 0x04aee88b, 0x1fa7cb5a, 
	0x1fa6df56, 0x04b51fa1, 0x04c7c3cb, 0x1fa413f8, 0x1fa32313, 0x04cdfa26, 0x04e09c18, 0x1fa04912, 
	0x1f9f534c, 0x04e6d1b4, 0x04f97163, 0x1f9c6aa9, 0x1f9b7003, 0x04ffa63c, 0x0512439d, 0x1f9878c1, 
	0x1f97793b, 0x051877af, 0x052b12b6, 0x1f94735b, 0x1f936ef6, 0x053145fd, 0x0543de9e, 0x1f905a7a, 
	0x1f8f5137, 0x054a1117, 0x055ca748, 0x1f8c2e21, 0x1f8b2000, 0x0562d8ee, 0x05756ca2, 0x1f87ee52, 
	0x1f86db55, 0x057b9d73, 0x058e2e9f, 0x1f839b10, 0x1f828336, 0x05945e95, 0x05a6ed2e, 0x1f7f345e, 
	0x1f7e17a8, 0x05ad1c47, 0x05bfa840, 0x1f7aba3e, 0x1f7998ad, 0x05c5d678, 0x05d85fc7, 0x1f762cb2, 
	0x1f750647, 0x05de8d19, 0x05f113b3, 0x1f718bbf, 0x1f70607a, 0x05f7401c, 0x0609c3f5, 0x1f6cd766, 
	0x1f6ba748, 0x060fef71, 0x0622707d, 0x1f680fab, 0x1f66dab5, 0x06289b08, 0x063b193c, 0x1f633490, 
	0x1f61fac3, 0x064142d3, 0x0653be23, 0x1f5e4619, 0x1f5d0775, 0x0659e6c2, 0x066c5f24, 0x1f594448, 
	0x1f5800ce, 0x067286c6, 0x0684fc2e, 0x1f542f21, 0x1f52e6d2, 0x068b22d0, 0x069d9532, 0x1f4f06a6, 
	0x1f4db983, 0x06a3bad0, 0x06b62a22, 0x1f49cadc, 0x1f4878e5, 0x06bc4eb9, 0x06cebaee, 0x1f447bc4, 
	0x1f4324fb, 0x06d4de79, 0x06e74786, 0x1f3f1963, 0x1f3dbdc8, 0x06ed6a03, 0x06ffcfdd, 0x1f39a3bc, 
	0x1f384350, 0x0705f147, 0x071853e3, 0x1f341ad2, 0x1f32b595, 0x071e7436, 0x0730d388, 0x1f2e7ea9, 
	0x1f2d149d, 0x0736f2c0, 0x07494ebd, 0x1f28cf43, 0x1f276069, 0x074f6cd7, 0x0761c574, 0x1f230ca5, 
	0x1f2198fd, 0x0767e26c, 0x077a379d, 0x1f1d36d2, 0x1f1bbe5d, 0x07805370, 0x0792a52a, 0x1f174dce, 
	0x1f15d08d, 0x0798bfd3, 0x07ab0e0a, 0x1f11519c, 0x1f0fcf91, 0x07b12786, 0x07c37230, 0x1f0b4240, 
	0x1f09bb6b, 0x07c98a7a, 0x07dbd18c, 0x1f051fbe, 0x1f03941f, 0x07e1e8a1, 0x07f42c0e, 0x1efeea19, 
	0x1efd59b3, 0x07fa41eb, 0x080c81a9, 0x1ef8a155, 0x1ef70c28, 0x0812964a, 0x0824d24d, 0x1ef24577, 
	0x1ef0ab84, 0x082ae5ad, 0x083d1dea, 0x1eebd682, 0x1eea37ca, 0x08433007, 0x08556473, 0x1ee5547a, 
	0x1ee3b0fe, 0x085b7548, 0x086da5d8, 0x1edebf64, 0x1edd1724, 0x0873b562, 0x0885e209, 0x1ed81742, 
	0x1ed66a41, 0x088bf044, 0x089e18f9, 0x1ed15c1a, 0x1ecfaa57, 0x08a425e1, 0x08b64a98, 0x1eca8def, 
	0x1ec8d76c, 0x08bc562a, 0x08ce76d8, 0x1ec3acc6, 0x1ec1f184, 0x08d4810f, 0x08e69da8, 0x1ebcb8a3, 
	0x1ebaf8a3, 0x08eca681, 0x08febefb, 0x1eb5b18a, 0x1eb3eccd, 0x0904c673, 0x0916dac2, 0x1eae977f, 
	0x1eacce07, 0x091ce0d4, 0x092ef0ed, 0x1ea76a87, 0x1ea59c55, 0x0934f596, 0x0947016e, 0x1ea02aa7, 
	0x1e9e57bb, 0x094d04aa, 0x095f0c36, 0x1e98d7e2, 0x1e97003e, 0x09650e01, 0x09771136, 0x1e91723e, 
	0x1e8f95e3, 0x097d118d, 0x098f1060, 0x1e89f9bf, 0x1e8818ad, 0x09950f3f, 0x09a709a4, 0x1e826e69, 
	0x1e8088a2, 0x09ad0707, 0x09befcf4, 0x1e7ad041, 0x1e78e5c7, 0x09c4f8d8, 0x09d6ea40, 0x1e731f4c, 
	0x1e71301f, 0x09dce4a1, 0x09eed17b, 0x1e6b5b8f, 0x1e6967b1, 0x09f4ca56, 0x0a06b296, 0x1e63850e, 
	0x1e618c80, 0x0a0ca9e6, 0x0a1e8d81, 0x1e5b9bce, 0x1e599e91, 0x0a248343, 0x0a36622e, 0x1e539fd4, 
	0x1e519dea, 0x0a3c565e, 0x0a4e308f, 0x1e4b9126, 0x1e498a8e, 0x0a542329, 0x0a65f894, 0x1e436fc7, 
	0x1e416485, 0x0a6be995, 0x0a7dba2f, 0x1e3b3bbd, 0x1e392bd1, 0x0a83a993, 0x0a957551, 0x1e32f50e, 
	0x1e30e079, 0x0a9b6315, 0x0aad29ec, 0x1e2a9bbd, 0x1e288281, 0x0ab3160c, 0x0ac4d7f1, 0x1e222fd1, 
	0x1e2011ee, 0x0acac26a, 0x0adc7f52, 0x1e19b14f, 0x1e178ec7, 0x0ae2681f, 0x0af41fff, 0x1e11203b, 
	0x1e0ef910, 0x0afa071d, 0x0b0bb9eb, 0x1e087c9b, 0x1e0650ce, 0x0b119f56, 0x0b234d07, 0x1dffc674, 
	0x1dfd9606, 0x0b2930bb, 0x0b3ad943, 0x1df6fdcc, 0x1df4c8bf, 0x0b40bb3e, 0x0b525e92, 0x1dee22a9, 
	0x1debe8fd, 0x0b583ecf, 0x0b69dce6, 0x1de5350f, 0x1de2f6c6, 0x0b6fbb62, 0x0b81542f, 0x1ddc3504, 
	0x1dd9f220, 0x0b8730e6, 0x0b98c45f, 0x1dd3228e, 0x1dd0db10, 0x0b9e9f4d, 0x0bb02d68, 0x1dc9fdb2, 
	0x1dc7b19b, 0x0bb6068a, 0x0bc78f3b, 0x1dc0c676, 0x1dbe75c8, 0x0bcd668e, 0x0bdee9ca, 0x1db77cdf, 
	0x1db5279c, 0x0be4bf4a, 0x0bf63d07, 0x1dae20f4, 0x1dabc71d, 0x0bfc10af, 0x0c0d88e2, 0x1da4b2ba, 
	0x1da25450, 0x0c135ab0, 0x0c24cd4e, 0x1d9b3237, 0x1d98cf3b, 0x0c2a9d3e, 0x0c3c0a3d, 0x1d919f70, 
	0x1d8f37e5, 0x0c41d84b, 0x0c533fa0, 0x1d87fa6d, 0x1d858e53, 0x0c590bc9, 0x0c6a6d68, 0x1d7e4332, 
	0x1d7bd28b, 0x0c7037a8, 0x0c819388, 0x1d7479c5, 0x1d720493, 0x0c875bdb, 0x0c98b1f0, 0x1d6a9e2e, 
	0x1d682472, 0x0c9e7854, 0x0cafc894, 0x1d60b070, 0x1d5e322c, 0x0cb58d04, 0x0cc6d764, 0x1d56b094, 
	0x1d542dc9, 0x0ccc99de, 0x0cddde53, 0x1d4c9e9f, 0x1d4a174f, 0x0ce39ed2, 0x0cf4dd52, 0x1d427a97, 
	0x1d3feec3, 0x0cfa9bd2, 0x0d0bd452, 0x1d384483, 0x1d35b42d, 0x0d1190d1, 0x0d22c347, 0x1d2dfc68, 
	0x1d2b6791, 0x0d287dc1, 0x0d39aa21, 0x1d23a24e, 0x1d2108f8, 0x0d3f6292, 0x0d5088d3, 0x1d19363a, 
	0x1d169867, 0x0d563f38, 0x0d675f4e, 0x1d0eb833, 0x1d0c15e4, 0x0d6d13a3, 0x0d7e2d85, 0x1d04283f, 
	0x1d018176, 0x0d83dfc6, 0x0d94f369, 0x1cf98666, 0x1cf6db24, 0x0d9aa393, 0x0dabb0ec, 0x1ceed2ad, 
	0x1cec22f4, 0x0db15efc, 0x0dc26600, 0x1ce40d1b, 0x1ce158ed, 0x0dc811f3, 0x0dd91298, 0x1cd935b7, 
	0x1cd67d15, 0x0ddebc69, 0x0defb6a5, 0x1cce4c87, 0x1ccb8f74, 0x0df55e51, 0x0e065219, 0x1cc35192, 
	0x1cc0900f, 0x0e0bf79c, 0x0e1ce4e6, 0x1cb844df, 0x1cb57eee, 0x0e22883e, 0x0e336eff, 0x1cad2675, 
	0x1caa5c17, 0x0e391027, 0x0e49f055, 0x1ca1f65b, 0x1c9f2792, 0x0e4f8f4b, 0x0e6068db, 0x1c96b497, 
	0x1c93e165, 0x0e66059a, 0x0e76d883, 0x1c8b6131, 0x1c888997, 0x0e7c7308, 0x0e8d3f3e, 0x1c7ffc2f, 
	0x1c7d202f, 0x0e92d787, 0x0ea39d00, 0x1c748599, 0x1c71a535, 0x0ea93308, 0x0eb9f1ba, 0x1c68fd75, 
	0x1c6618ae, 0x0ebf857d, 0x0ed03d5e, 0x1c5d63ca, 0x1c5a7aa4, 0x0ed5ceda, 0x0ee67fdf, 0x1c51b8a1, 
	0x1c4ecb1c, 0x0eec0f10, 0x0efcb92f, 0x1c45fc00, 0x1c430a1d, 0x0f024612, 0x0f12e941, 0x1c3a2ded, 
	0x1c3737b0, 0x0f1873d2, 0x0f291006, 0x1c2e4e72, 0x1c2b53db, 0x0f2e9842, 0x0f3f2d71, 0x1c225d94, 
	0x1c1f5ea6, 0x0f44b354, 0x0f554175, 0x1c165b5b, 0x1c135818, 0x0f5ac4fc, 0x0f6b4c03, 0x1c0a47cf, 
	0x1c074038, 0x0f70cd2a, 0x0f814d0e, 0x1bfe22f8, 0x1bfb170f, 0x0f86cbd3, 0x0f974489, 0x1bf1ecdb, 
	0x1beedca2, 0x0f9cc0e7, 0x0fad3265, 0x1be5a582, 0x1be290fb, 0x0fb2ac5a, 0x0fc31697, 0x1bd94cf4, 
	0x1bd63421, 0x0fc88e1e, 0x0fd8f10f, 0x1bcce337, 0x1bc9c61a, 0x0fde6626, 0x0feec1c0, 0x1bc06855, 
	0x1bbd46f0, 0x0ff43464, 0x1004889e, 0x1bb3dc55, 0x1bb0b6a9, 0x1009f8cb, 0x101a459a, 0x1ba73f3d, 
	0x1ba4154d, 0x101fb34d, 0x102ff8a8, 0x1b9a9117, 0x1b9762e4, 0x103563dc, 0x1045a1b9, 0x1b8dd1ea, 
	0x1b8a9f77, 0x104b0a6c, 0x105b40c1, 0x1b8101be, 0x1b7dcb0c, 0x1060a6ef, 0x1070d5b1, 0x1b74209b, 
	0x1b70e5ac, 0x10763958, 0x1086607e, 0x1b672e88, 0x1b63ef5f, 0x108bc19a, 0x109be119, 0x1b5a2b8e, 
	0x1b56e82c, 0x10a13fa6, 0x10b15775, 0x1b4d17b4, 0x1b49d01c, 0x10b6b371, 0x10c6c385, 0x1b3ff304, 
	0x1b3ca737, 0x10cc1cec, 0x10dc253c, 0x1b32bd84, 0x1b2f6d85, 0x10e17c0b, 0x10f17c8d, 0x1b25773d, 
	0x1b22230e, 0x10f6d0c0, 0x1106c96a, 0x1b182038, 0x1b14c7da, 0x110c1afe, 0x111c0bc6, 0x1b0ab87c, 
	0x1b075bf1, 0x11215ab8, 0x11314395, 0x1afd4012, 0x1af9df5d, 0x11368fe1, 0x114670c8, 0x1aefb702, 
	0x1aec5225, 0x114bba6b, 0x115b9354, 0x1ae21d54, 0x1adeb451, 0x1160da4b, 0x1170ab2a, 0x1ad47311, 
	0x1ad105e9, 0x1175ef72, 0x1185b83f, 0x1ac6b841, 0x1ac346f8, 0x118af9d4, 0x119aba84, 0x1ab8ecec, 
	0x1ab57784, 0x119ff964, 0x11afb1ee, 0x1aab111c, 0x1aa79796, 0x11b4ee14, 0x11c49e6f, 0x1a9d24d9, 
	0x1a99a737, 0x11c9d7d9, 0x11d97ff9, 0x1a8f282b, 0x1a8ba670, 0x11deb6a4, 0x11ee5682, 0x1a811b1b, 
	0x1a7d9549, 0x11f38a6a, 0x120321fa, 0x1a72fdb2, 0x1a6f73ca, 0x1208531c, 0x1217e256, 0x1a64cff8, 
	0x1a6141fd, 0x121d10af, 0x122c9789, 0x1a5691f5, 0x1a52ffeb, 0x1231c316, 0x12414186, 0x1a4843b4, 
	0x1a44ad9b, 0x12466a44, 0x1255e041, 0x1a39e53d, 0x1a364b17, 0x125b062b, 0x126a73ac, 0x1a2b7698, 
	0x1a27d868, 0x126f96c1, 0x127efbbb, 0x1a1cf7ce, 0x1a195597, 0x12841bf6, 0x12937861, 0x1a0e68e9, 
	0x1a0ac2ac, 0x129895c0, 0x12a7e991, 0x19ffc9f1, 0x19fc1fb1, 0x12ad0412, 0x12bc4f40, 0x19f11af0, 
	0x19ed6caf, 0x12c166de, 0x12d0a960, 0x19e25bee, 0x19dea9ae, 0x12d5be18, 0x12e4f7e5, 0x19d38cf4, 
	0x19cfd6b8, 0x12ea09b4, 0x12f93ac2, 0x19c4ae0c, 0x19c0f3d6, 0x12fe49a6, 0x130d71eb, 0x19b5bf3f, 
	0x19b20111, 0x13127de0, 0x13219d53, 0x19a6c096, 0x19a2fe73, 0x1326a656, 0x1335bcef, 0x1997b21b, 
	0x1993ec04, 0x133ac2fc, 0x1349d0b0, 0x198893d6, 0x1984c9ce, 0x134ed3c5, 0x135dd88c, 0x197965d0, 
	0x197597da, 0x1362d8a6, 0x1371d476, 0x196a2815, 0x19665632, 0x1376d191, 0x1385c461, 0x195adaab, 
	0x195704df, 0x138abe7b, 0x1399a841, 0x194b7d9e, 0x1947a3eb, 0x139e9f56, 0x13ad800a, 0x193c10f7, 
	0x1938335e, 0x13b27417, 0x13c14bb0, 0x192c94bf, 0x1928b343, 0x13c63cb2, 0x13d50b26, 0x191d08ff, 
	0x191923a3, 0x13d9f91b, 0x13e8be60, 0x190d6dc1, 0x19098488, 0x13eda944, 0x13fc6553, 0x18fdc310, 
	0x18f9d5fa, 0x14014d23, 0x140ffff1, 0x18ee08f4, 0x18ea1805, 0x1414e4aa, 0x14238e2f, 0x18de3f77, 
	0x18da4ab2, 0x14286fce, 0x14371001, 0x18ce66a3, 0x18ca6e0a, 0x143bee83, 0x144a855b, 0x18be7e82, 
	0x18ba8217, 0x144f60bd, 0x145dee30, 0x18ae871e, 0x18aa86e3, 0x1462c670, 0x14714a76, 0x189e8080, 
	0x189a7c78, 0x14761f8f, 0x14849a1f, 0x188e6ab2, 0x188a62e0, 0x14896c0f, 0x1497dd20, 0x187e45be, 
	0x187a3a25, 0x149cabe4, 0x14ab136d, 0x186e11af, 0x186a0250, 0x14afdf03, 0x14be3cfa, 0x185dce8e, 
	0x1859bb6c, 0x14c3055e, 0x14d159bc, 0x184d7c65, 0x18496583, 0x14d61eeb, 0x14e469a6, 0x183d1b3e, 
	0x1839009e, 0x14e92b9e, 0x14f76cad, 0x182cab24, 0x18288cc8, 0x14fc2b6a, 0x150a62c6, 0x181c2c20, 
	0x18180a0c, 0x150f1e45, 0x151d4be3, 0x180b9e3d, 0x18077873, 0x15220422, 0x153027fb, 0x17fb0185, 
	0x17f6d807, 0x1534dcf6, 0x1542f700, 0x17ea5602, 0x17e628d3, 0x1547a8b5, 0x1555b8e8, 0x17d99bbe, 
	0x17d56ae0, 0x155a6754, 0x15686da7, 0x17c8d2c4, 0x17c49e3b, 0x156d18c7, 0x157b1532, 0x17b7fb1f, 
	0x17b3c2ec, 0x157fbd03, 0x158daf7c, 0x17a714d7, 0x17a2d8fe, 0x159253fb, 0x15a03c7a, 0x17961ff9, 
	0x1791e07b, 0x15a4dda5, 0x15b2bc22, 0x17851c8e, 0x1780d96f, 0x15b759f5, 0x15c52e67, 0x17740aa1, 
	0x176fc3e3, 0x15c9c8e0, 0x15d7933f, 0x1762ea3d, 0x175e9fe2, 0x15dc2a5a, 0x15e9ea9d, 0x1751bb6b, 
	0x174d6d77, 0x15ee7e58, 0x15fc3477, 0x17407e37, 0x173c2cac, 0x1600c4cf, 0x160e70c1, 0x172f32ab, 
	0x172add8c, 0x1612fdb3, 0x16209f70, 0x171dd8d2, 0x17198021, 0x162528fa, 0x1632c078, 0x170c70b7, 
	0x17081477, 0x16374697, 0x1644d3d0, 0x16fafa64, 0x16f69a97, 0x16495680, 0x1656d96a, 0x16e975e4, 
	0x16e5128e, 0x165b58aa, 0x1668d13e, 0x16d7e341, 0x16d37c65, 0x166d4d0a, 0x167abb3e, 0x16c64288, 
	0x16c1d827, 0x167f3394, 0x168c9760, 0x16b493c2, 0x16b025e0, 0x16910c3d, 0x169e659a, 0x16a2d6fb
};

const int twidTab512[8*6 + 32*6 + 128*6] = {
	0x20000000, 0x00000000, 0x1d906bcf, 0x0c3ef153, 0x16a09e66, 0x16a09e66, 0x0c3ef153, 0x1d906bcf, 
	0x20000000, 0x00000000, 0x1f6297d0, 0x063e2e0f, 0x1d906bcf, 0x0c3ef153, 0x1a9b6629, 0x11c73b3a, 
	0x20000000, 0x00000000, 0x1a9b6629, 0x11c73b3a, 0x0c3ef153, 0x1d906bcf, 0xf9c1d1f1, 0x1f6297d0, 
	0x00000000, 0x20000000, 0xf3c10ead, 0x1d906bcf, 0xe95f619a, 0x16a09e66, 0xe26f9431, 0x0c3ef153, 
	0x16a09e66, 0x16a09e66, 0x11c73b3a, 0x1a9b6629, 0x0c3ef153, 0x1d906bcf, 0x063e2e0f, 0x1f6297d0, 
	0xe95f619a, 0x16a09e66, 0xe09d6830, 0x063e2e0f, 0xe26f9431, 0xf3c10ead, 0xee38c4c6, 0xe56499d7, 

	0x20000000, 0x00000000, 0x1fd88da4, 0x0322f4d8, 0x1f6297d0, 0x063e2e0f, 0x1e9f4157, 0x094a0317, 
	0x20000000, 0x00000000, 0x1ff621e3, 0x0191f65f, 0x1fd88da4, 0x0322f4d8, 0x1fa7557f, 0x04b2041c, 
	0x20000000, 0x00000000, 0x1fa7557f, 0x04b2041c, 0x1e9f4157, 0x094a0317, 0x1ced7af4, 0x0dae8805, 
	0x1d906bcf, 0x0c3ef153, 0x1c38b2f2, 0x0f15ae9c, 0x1a9b6629, 0x11c73b3a, 0x18bc806b, 0x144cf325, 
	0x1f6297d0, 0x063e2e0f, 0x1f0a7efc, 0x07c67e5f, 0x1e9f4157, 0x094a0317, 0x1e212105, 0x0ac7cd3b, 
	0x1a9b6629, 0x11c73b3a, 0x17b5df22, 0x157d6935, 0x144cf325, 0x18bc806b, 0x10738799, 0x1b728345, 
	0x16a09e66, 0x16a09e66, 0x144cf325, 0x18bc806b, 0x11c73b3a, 0x1a9b6629, 0x0f15ae9c, 0x1c38b2f2, 
	0x1d906bcf, 0x0c3ef153, 0x1ced7af4, 0x0dae8805, 0x1c38b2f2, 0x0f15ae9c, 0x1b728345, 0x10738799, 
	0x0c3ef153, 0x1d906bcf, 0x07c67e5f, 0x1f0a7efc, 0x0322f4d8, 0x1fd88da4, 0xfe6e09a1, 0x1ff621e3, 
	0x0c3ef153, 0x1d906bcf, 0x094a0317, 0x1e9f4157, 0x063e2e0f, 0x1f6297d0, 0x0322f4d8, 0x1fd88da4, 
	0x1a9b6629, 0x11c73b3a, 0x19b3e048, 0x130ff7fd, 0x18bc806b, 0x144cf325, 0x17b5df22, 0x157d6935, 
	0xf9c1d1f1, 0x1f6297d0, 0xf53832c5, 0x1e212105, 0xf0ea5164, 0x1c38b2f2, 0xecf00803, 0x19b3e048, 
	0x00000000, 0x20000000, 0xfcdd0b28, 0x1fd88da4, 0xf9c1d1f1, 0x1f6297d0, 0xf6b5fce9, 0x1e9f4157, 
	0x16a09e66, 0x16a09e66, 0x157d6935, 0x17b5df22, 0x144cf325, 0x18bc806b, 0x130ff7fd, 0x19b3e048, 
	0xe95f619a, 0x16a09e66, 0xe64c1fb8, 0x130ff7fd, 0xe3c74d0e, 0x0f15ae9c, 0xe1dedefb, 0x0ac7cd3b, 
	0xf3c10ead, 0x1d906bcf, 0xf0ea5164, 0x1c38b2f2, 0xee38c4c6, 0x1a9b6629, 0xebb30cdb, 0x18bc806b, 
	0x11c73b3a, 0x1a9b6629, 0x10738799, 0x1b728345, 0x0f15ae9c, 0x1c38b2f2, 0x0dae8805, 0x1ced7af4, 
	0xe09d6830, 0x063e2e0f, 0xe009de1d, 0x0191f65f, 0xe027725c, 0xfcdd0b28, 0xe0f58104, 0xf83981a1, 
	0xe95f619a, 0x16a09e66, 0xe7437f95, 0x144cf325, 0xe56499d7, 0x11c73b3a, 0xe3c74d0e, 0x0f15ae9c, 
	0x0c3ef153, 0x1d906bcf, 0x0ac7cd3b, 0x1e212105, 0x094a0317, 0x1e9f4157, 0x07c67e5f, 0x1f0a7efc, 
	0xe26f9431, 0xf3c10ead, 0xe48d7cbb, 0xef8c7867, 0xe7437f95, 0xebb30cdb, 0xea8296cb, 0xe84a20de, 
	0xe26f9431, 0x0c3ef153, 0xe160bea9, 0x094a0317, 0xe09d6830, 0x063e2e0f, 0xe027725c, 0x0322f4d8, 
	0x063e2e0f, 0x1f6297d0, 0x04b2041c, 0x1fa7557f, 0x0322f4d8, 0x1fd88da4, 0x0191f65f, 0x1ff621e3, 
	0xee38c4c6, 0xe56499d7, 0xf25177fb, 0xe312850c, 0xf6b5fce9, 0xe160bea9, 0xfb4dfbe4, 0xe058aa81, 

	0x20000000, 0x00000000, 0x1ffd8861, 0x00c90ab0, 0x1ff621e3, 0x0191f65f, 0x1fe9cdad, 0x025aa412, 
	0x20000000, 0x00000000, 0x1fff6217, 0x00648748, 0x1ffd8861, 0x00c90ab0, 0x1ffa72f0, 0x012d8657, 
	0x20000000, 0x00000000, 0x1ffa72f0, 0x012d8657, 0x1fe9cdad, 0x025aa412, 0x1fce15fd, 0x0386f0b9, 
	0x1fd88da4, 0x0322f4d8, 0x1fc26471, 0x03eac9cb, 0x1fa7557f, 0x04b2041c, 0x1f8764fa, 0x05788511, 
	0x1ff621e3, 0x0191f65f, 0x1ff09566, 0x01f656e8, 0x1fe9cdad, 0x025aa412, 0x1fe1cafd, 0x02beda01, 
	0x1fa7557f, 0x04b2041c, 0x1f7599a4, 0x05db7678, 0x1f38f3ac, 0x0702e09b, 0x1ef178a4, 0x0827dc07, 
	0x1f6297d0, 0x063e2e0f, 0x1f38f3ac, 0x0702e09b, 0x1f0a7efc, 0x07c67e5f, 0x1ed740e7, 0x0888e931, 
	0x1fd88da4, 0x0322f4d8, 0x1fce15fd, 0x0386f0b9, 0x1fc26471, 0x03eac9cb, 0x1fb57972, 0x044e7c34, 
	0x1e9f4157, 0x094a0317, 0x1e426a4b, 0x0a68f121, 0x1ddb13b7, 0x0b844298, 0x1d696174, 0x0c9b9532, 
	0x1e9f4157, 0x094a0317, 0x1e6288ec, 0x0a09ae4a, 0x1e212105, 0x0ac7cd3b, 0x1ddb13b7, 0x0b844298, 
	0x1fa7557f, 0x04b2041c, 0x1f97f925, 0x05155dac, 0x1f8764fa, 0x05788511, 0x1f7599a4, 0x05db7678, 
	0x1ced7af4, 0x0dae8805, 0x1c678b35, 0x0ebcbbae, 0x1bd7c0ac, 0x0fc5d26e, 0x1b3e4d3f, 0x10c9704d, 
	0x1d906bcf, 0x0c3ef153, 0x1d4134d1, 0x0cf7bca2, 0x1ced7af4, 0x0dae8805, 0x1c954b21, 0x0e63374d, 
	0x1f6297d0, 0x063e2e0f, 0x1f4e603b, 0x06a0a809, 0x1f38f3ac, 0x0702e09b, 0x1f2252f7, 0x0764d3f9, 
	0x1a9b6629, 0x11c73b3a, 0x19ef43ef, 0x12bedb26, 0x193a224a, 0x13affa29, 0x187c4010, 0x149a449c, 
	0x1c38b2f2, 0x0f15ae9c, 0x1bd7c0ac, 0x0fc5d26e, 0x1b728345, 0x10738799, 0x1b090a58, 0x111eb354, 
	0x1f0a7efc, 0x07c67e5f, 0x1ef178a4, 0x0827dc07, 0x1ed740e7, 0x0888e931, 0x1ebbd8c9, 0x08e9a220, 
	0x17b5df22, 0x157d6935, 0x16e74455, 0x16591926, 0x1610b755, 0x172d0838, 0x15328293, 0x17f8ece3, 
	0x1a9b6629, 0x11c73b3a, 0x1a29a7a0, 0x126d054d, 0x19b3e048, 0x130ff7fd, 0x193a224a, 0x13affa29, 
	0x1e9f4157, 0x094a0317, 0x1e817bab, 0x09aa0861, 0x1e6288ec, 0x0a09ae4a, 0x1e426a4b, 0x0a68f121, 
	0x144cf325, 0x18bc806b, 0x136058b1, 0x19777ef5, 0x126d054d, 0x1a29a7a0, 0x11734d64, 0x1ad2bc9e, 
	0x18bc806b, 0x144cf325, 0x183b0e0c, 0x14e6cabc, 0x17b5df22, 0x157d6935, 0x172d0838, 0x1610b755, 
	0x1e212105, 0x0ac7cd3b, 0x1dfeae62, 0x0b263eef, 0x1ddb13b7, 0x0b844298, 0x1db65262, 0x0be1d499, 
	0x10738799, 0x1b728345, 0x0f6e0ca9, 0x1c08c426, 0x0e63374d, 0x1c954b21, 0x0d536416, 0x1d17e774, 
	0x16a09e66, 0x16a09e66, 0x1610b755, 0x172d0838, 0x157d6935, 0x17b5df22, 0x14e6cabc, 0x183b0e0c, 
	0x1d906bcf, 0x0c3ef153, 0x1d696174, 0x0c9b9532, 0x1d4134d1, 0x0cf7bca2, 0x1d17e774, 0x0d536416, 
	0x0c3ef153, 0x1d906bcf, 0x0b263eef, 0x1dfeae62, 0x0a09ae4a, 0x1e6288ec, 0x08e9a220, 0x1ebbd8c9, 
	0x144cf325, 0x18bc806b, 0x13affa29, 0x193a224a, 0x130ff7fd, 0x19b3e048, 0x126d054d, 0x1a29a7a0, 
	0x1ced7af4, 0x0dae8805, 0x1cc1f0f4, 0x0e0924ec, 0x1c954b21, 0x0e63374d, 0x1c678b35, 0x0ebcbbae, 
	0x07c67e5f, 0x1f0a7efc, 0x06a0a809, 0x1f4e603b, 0x05788511, 0x1f8764fa, 0x044e7c34, 0x1fb57972, 
	0x11c73b3a, 0x1a9b6629, 0x111eb354, 0x1b090a58, 0x10738799, 0x1b728345, 0x0fc5d26e, 0x1bd7c0ac, 
	0x1c38b2f2, 0x0f15ae9c, 0x1c08c426, 0x0f6e0ca9, 0x1bd7c0ac, 0x0fc5d26e, 0x1ba5aa67, 0x101cfc87, 
	0x0322f4d8, 0x1fd88da4, 0x01f656e8, 0x1ff09566, 0x00c90ab0, 0x1ffd8861, 0xff9b78b8, 0x1fff6217, 
	0x0f15ae9c, 0x1c38b2f2, 0x0e63374d, 0x1c954b21, 0x0dae8805, 0x1ced7af4, 0x0cf7bca2, 0x1d4134d1, 
	0x1b728345, 0x10738799, 0x1b3e4d3f, 0x10c9704d, 0x1b090a58, 0x111eb354, 0x1ad2bc9e, 0x11734d64, 
	0xfe6e09a1, 0x1ff621e3, 0xfd4125ff, 0x1fe1cafd, 0xfc153635, 0x1fc26471, 0xfaeaa254, 0x1f97f925, 
	0x0c3ef153, 0x1d906bcf, 0x0b844298, 0x1ddb13b7, 0x0ac7cd3b, 0x1e212105, 0x0a09ae4a, 0x1e6288ec, 
	0x1a9b6629, 0x11c73b3a, 0x1a63091b, 0x121a7999, 0x1a29a7a0, 0x126d054d, 0x19ef43ef, 0x12bedb26, 
	0xf9c1d1f1, 0x1f6297d0, 0xf89b2c07, 0x1f2252f7, 0xf77716cf, 0x1ed740e7, 0xf655f79f, 0x1e817bab, 
	0x094a0317, 0x1e9f4157, 0x0888e931, 0x1ed740e7, 0x07c67e5f, 0x1f0a7efc, 0x0702e09b, 0x1f38f3ac, 
	0x19b3e048, 0x130ff7fd, 0x19777ef5, 0x136058b1, 0x193a224a, 0x13affa29, 0x18fbcca4, 0x13fed953, 
	0xf53832c5, 0x1e212105, 0xf41e2b67, 0x1db65262, 0xf308435e, 0x1d4134d1, 0xf1f6db14, 0x1cc1f0f4, 
	0x063e2e0f, 0x1f6297d0, 0x05788511, 0x1f8764fa, 0x04b2041c, 0x1fa7557f, 0x03eac9cb, 0x1fc26471, 
	0x18bc806b, 0x144cf325, 0x187c4010, 0x149a449c, 0x183b0e0c, 0x14e6cabc, 0x17f8ece3, 0x15328293, 
	0xf0ea5164, 0x1c38b2f2, 0xefe30379, 0x1ba5aa67, 0xeee14cac, 0x1b090a58, 0xede58667, 0x1a63091b, 
	0x0322f4d8, 0x1fd88da4, 0x025aa412, 0x1fe9cdad, 0x0191f65f, 0x1ff621e3, 0x00c90ab0, 0x1ffd8861, 
	0x17b5df22, 0x157d6935, 0x1771e75f, 0x15c77bbe, 0x172d0838, 0x1610b755, 0x16e74455, 0x16591926, 
	0xecf00803, 0x19b3e048, 0xec0126ad, 0x18fbcca4, 0xeb193544, 0x183b0e0c, 0xea388442, 0x1771e75f, 
	0x00000000, 0x20000000, 0xff36f550, 0x1ffd8861, 0xfe6e09a1, 0x1ff621e3, 0xfda55bee, 0x1fe9cdad, 
	0x16a09e66, 0x16a09e66, 0x16591926, 0x16e74455, 0x1610b755, 0x172d0838, 0x15c77bbe, 0x1771e75f, 
	0xe95f619a, 0x16a09e66, 0xe88e18a1, 0x15c77bbe, 0xe7c4f1f4, 0x14e6cabc, 0xe704335c, 0x13fed953, 
	0xfcdd0b28, 0x1fd88da4, 0xfc153635, 0x1fc26471, 0xfb4dfbe4, 0x1fa7557f, 0xfa877aef, 0x1f8764fa, 
	0x157d6935, 0x17b5df22, 0x15328293, 0x17f8ece3, 0x14e6cabc, 0x183b0e0c, 0x149a449c, 0x187c4010, 
	0xe64c1fb8, 0x130ff7fd, 0xe59cf6e5, 0x121a7999, 0xe4f6f5a8, 0x111eb354, 0xe45a5599, 0x101cfc87, 
	0xf9c1d1f1, 0x1f6297d0, 0xf8fd1f65, 0x1f38f3ac, 0xf83981a1, 0x1f0a7efc, 0xf77716cf, 0x1ed740e7, 
	0x144cf325, 0x18bc806b, 0x13fed953, 0x18fbcca4, 0x13affa29, 0x193a224a, 0x136058b1, 0x19777ef5, 
	0xe3c74d0e, 0x0f15ae9c, 0xe33e0f0c, 0x0e0924ec, 0xe2becb2f, 0x0cf7bca2, 0xe249ad9e, 0x0be1d499, 
	0xf6b5fce9, 0x1e9f4157, 0xf5f651b6, 0x1e6288ec, 0xf53832c5, 0x1e212105, 0xf47bbd68, 0x1ddb13b7, 
	0x130ff7fd, 0x19b3e048, 0x12bedb26, 0x19ef43ef, 0x126d054d, 0x1a29a7a0, 0x121a7999, 0x1a63091b, 
	0xe1dedefb, 0x0ac7cd3b, 0xe17e8455, 0x09aa0861, 0xe128bf19, 0x0888e931, 0xe0ddad09, 0x0764d3f9, 
	0xf3c10ead, 0x1d906bcf, 0xf308435e, 0x1d4134d1, 0xf25177fb, 0x1ced7af4, 0xf19cc8b3, 0x1c954b21, 
	0x11c73b3a, 0x1a9b6629, 0x11734d64, 0x1ad2bc9e, 0x111eb354, 0x1b090a58, 0x10c9704d, 0x1b3e4d3f, 
	0xe09d6830, 0x063e2e0f, 0xe06806db, 0x05155dac, 0xe03d9b8f, 0x03eac9cb, 0xe01e3503, 0x02beda01, 
	0xf0ea5164, 0x1c38b2f2, 0xf03a2d92, 0x1bd7c0ac, 0xef8c7867, 0x1b728345, 0xeee14cac, 0x1b090a58, 
	0x10738799, 0x1b728345, 0x101cfc87, 0x1ba5aa67, 0x0fc5d26e, 0x1bd7c0ac, 0x0f6e0ca9, 0x1c08c426, 
	0xe009de1d, 0x0191f65f, 0xe0009de9, 0x00648748, 0xe002779f, 0xff36f550, 0xe00f6a9a, 0xfe09a918, 
	0xee38c4c6, 0x1a9b6629, 0xed92fab3, 0x1a29a7a0, 0xecf00803, 0x19b3e048, 0xec5005d7, 0x193a224a, 
	0x0f15ae9c, 0x1c38b2f2, 0x0ebcbbae, 0x1c678b35, 0x0e63374d, 0x1c954b21, 0x0e0924ec, 0x1cc1f0f4, 
	0xe027725c, 0xfcdd0b28, 0xe04a868e, 0xfbb183cc, 0xe0789b06, 0xfa877aef, 0xe0b19fc5, 0xf95f57f7, 
	0xebb30cdb, 0x18bc806b, 0xeb193544, 0x183b0e0c, 0xea8296cb, 0x17b5df22, 0xe9ef48ab, 0x172d0838, 
	0x0dae8805, 0x1ced7af4, 0x0d536416, 0x1d17e774, 0x0cf7bca2, 0x1d4134d1, 0x0c9b9532, 0x1d696174, 
	0xe0f58104, 0xf83981a1, 0xe1442737, 0xf7165de0, 0xe19d7714, 0xf5f651b6, 0xe201519e, 0xf4d9c111, 
	0xe95f619a, 0x16a09e66, 0xe8d2f7c8, 0x1610b755, 0xe84a20de, 0x157d6935, 0xe7c4f1f4, 0x14e6cabc, 
	0x0c3ef153, 0x1d906bcf, 0x0be1d499, 0x1db65262, 0x0b844298, 0x1ddb13b7, 0x0b263eef, 0x1dfeae62, 
	0xe26f9431, 0xf3c10ead, 0xe2e8188c, 0xf2ac9bea, 0xe36ab4df, 0xf19cc8b3, 0xe3f73bda, 0xf091f357, 
	0xe7437f95, 0x144cf325, 0xe6c5ddb6, 0x13affa29, 0xe64c1fb8, 0x130ff7fd, 0xe5d65860, 0x126d054d, 
	0x0ac7cd3b, 0x1e212105, 0x0a68f121, 0x1e426a4b, 0x0a09ae4a, 0x1e6288ec, 0x09aa0861, 0x1e817bab, 
	0xe48d7cbb, 0xef8c7867, 0xe52d4362, 0xee8cb29c, 0xe5d65860, 0xed92fab3, 0xe688810b, 0xec9fa74f, 
	0xe56499d7, 0x11c73b3a, 0xe4f6f5a8, 0x111eb354, 0xe48d7cbb, 0x10738799, 0xe4283f54, 0x0fc5d26e, 
	0x094a0317, 0x1e9f4157, 0x08e9a220, 0x1ebbd8c9, 0x0888e931, 0x1ed740e7, 0x0827dc07, 0x1ef178a4, 
	0xe7437f95, 0xebb30cdb, 0xe807131d, 0xeacd7d6d, 0xe8d2f7c8, 0xe9ef48ab, 0xe9a6e6da, 0xe918bbab, 
	0xe3c74d0e, 0x0f15ae9c, 0xe36ab4df, 0x0e63374d, 0xe312850c, 0x0dae8805, 0xe2becb2f, 0x0cf7bca2, 
	0x07c67e5f, 0x1f0a7efc, 0x0764d3f9, 0x1f2252f7, 0x0702e09b, 0x1f38f3ac, 0x06a0a809, 0x1f4e603b, 
	0xea8296cb, 0xe84a20de, 0xeb65bb64, 0xe783bff0, 0xec5005d7, 0xe6c5ddb6, 0xed4124da, 0xe610bc11, 
	0xe26f9431, 0x0c3ef153, 0xe224ec49, 0x0b844298, 0xe1dedefb, 0x0ac7cd3b, 0xe19d7714, 0x0a09ae4a, 
	0x063e2e0f, 0x1f6297d0, 0x05db7678, 0x1f7599a4, 0x05788511, 0x1f8764fa, 0x05155dac, 0x1f97f925, 
	0xee38c4c6, 0xe56499d7, 0xef368fb3, 0xe4c1b2c1, 0xf03a2d92, 0xe4283f54, 0xf1434452, 0xe39874cb, 
	0xe160bea9, 0x094a0317, 0xe128bf19, 0x0888e931, 0xe0f58104, 0x07c67e5f, 0xe0c70c54, 0x0702e09b, 
	0x04b2041c, 0x1fa7557f, 0x044e7c34, 0x1fb57972, 0x03eac9cb, 0x1fc26471, 0x0386f0b9, 0x1fce15fd, 
	0xf25177fb, 0xe312850c, 0xf3646ace, 0xe2969e8c, 0xf47bbd68, 0xe224ec49, 0xf5970edf, 0xe1bd95b5, 
	0xe09d6830, 0x063e2e0f, 0xe0789b06, 0x05788511, 0xe058aa81, 0x04b2041c, 0xe03d9b8f, 0x03eac9cb, 
	0x0322f4d8, 0x1fd88da4, 0x02beda01, 0x1fe1cafd, 0x025aa412, 0x1fe9cdad, 0x01f656e8, 0x1ff09566, 
	0xf6b5fce9, 0xe160bea9, 0xf7d823f9, 0xe10e875c, 0xf8fd1f65, 0xe0c70c54, 0xfa248988, 0xe08a665c, 
	0xe027725c, 0x0322f4d8, 0xe0163253, 0x025aa412, 0xe009de1d, 0x0191f65f, 0xe002779f, 0x00c90ab0, 
	0x0191f65f, 0x1ff621e3, 0x012d8657, 0x1ffa72f0, 0x00c90ab0, 0x1ffd8861, 0x00648748, 0x1fff6217, 
	0xfb4dfbe4, 0xe058aa81, 0xfc790f47, 0xe031ea03, 0xfda55bee, 0xe0163253, 0xfed279a9, 0xe0058d10
};

const int twidTab64[4*6 + 16*6] = {
	0x20000000, 0x00000000, 0x16a09e66, 0x16a09e66, 0x00000000, 0x20000000, 0xe95f619a, 0x16a09e66, 
	0x20000000, 0x00000000, 0x1d906bcf, 0x0c3ef153, 0x16a09e66, 0x16a09e66, 0x0c3ef153, 0x1d906bcf, 
	0x20000000, 0x00000000, 0x0c3ef153, 0x1d906bcf, 0xe95f619a, 0x16a09e66, 0xe26f9431, 0xf3c10ead, 

	0x20000000, 0x00000000, 0x1f6297d0, 0x063e2e0f, 0x1d906bcf, 0x0c3ef153, 0x1a9b6629, 0x11c73b3a, 
	0x20000000, 0x00000000, 0x1fd88da4, 0x0322f4d8, 0x1f6297d0, 0x063e2e0f, 0x1e9f4157, 0x094a0317, 
	0x20000000, 0x00000000, 0x1e9f4157, 0x094a0317, 0x1a9b6629, 0x11c73b3a, 0x144cf325, 0x18bc806b, 
	0x16a09e66, 0x16a09e66, 0x11c73b3a, 0x1a9b6629, 0x0c3ef153, 0x1d906bcf, 0x063e2e0f, 0x1f6297d0, 
	0x1d906bcf, 0x0c3ef153, 0x1c38b2f2, 0x0f15ae9c, 0x1a9b6629, 0x11c73b3a, 0x18bc806b, 0x144cf325, 
	0x0c3ef153, 0x1d906bcf, 0x0322f4d8, 0x1fd88da4, 0xf9c1d1f1, 0x1f6297d0, 0xf0ea5164, 0x1c38b2f2, 
	0x00000000, 0x20000000, 0xf9c1d1f1, 0x1f6297d0, 0xf3c10ead, 0x1d906bcf, 0xee38c4c6, 0x1a9b6629, 
	0x16a09e66, 0x16a09e66, 0x144cf325, 0x18bc806b, 0x11c73b3a, 0x1a9b6629, 0x0f15ae9c, 0x1c38b2f2, 
	0xe95f619a, 0x16a09e66, 0xe3c74d0e, 0x0f15ae9c, 0xe09d6830, 0x063e2e0f, 0xe027725c, 0xfcdd0b28, 
	0xe95f619a, 0x16a09e66, 0xe56499d7, 0x11c73b3a, 0xe26f9431, 0x0c3ef153, 0xe09d6830, 0x063e2e0f, 
	0x0c3ef153, 0x1d906bcf, 0x094a0317, 0x1e9f4157, 0x063e2e0f, 0x1f6297d0, 0x0322f4d8, 0x1fd88da4, 
	0xe26f9431, 0xf3c10ead, 0xe7437f95, 0xebb30cdb, 0xee38c4c6, 0xe56499d7, 0xf6b5fce9, 0xe160bea9
};

#else

/* 
 *  Q30 for 128 and 1024 
 *
 * for (i = 0; i < num/4; i++) {
 *   angle = (i + 0.125) * M_PI / num;
 *   x = cos(angle) * (1 << 30);
 *   x = sin(angle) * (1 << 30);
 * 
 *   angle = (num/2 - 1 - i + 0.125) * M_PI / num;
 *   x = cos(angle) * (1 << 30);
 *   x = sin(angle) * (1 << 30);
 * }
 */
const int cossintab[128 + 1024] = {
	/* 128 */
	0x3fffec43, 0x003243f1, 0x015fd4d2, 0x3ffc38d1, 0x3ff9c13a, 0x01c454f5, 0x02f1b755, 0x3feea776, 
	0x3fe9b8a9, 0x03562038, 0x0483259d, 0x3fd73a4a, 0x3fcfd50b, 0x04e767c5, 0x0613e1c5, 0x3fb5f4ea, 
	0x3fac1a5b, 0x0677edbb, 0x07a3adff, 0x3f8adc77, 0x3f7e8e1e, 0x08077457, 0x09324ca7, 0x3f55f796, 
	0x3f473759, 0x0995bdfd, 0x0abf8043, 0x3f174e70, 0x3f061e95, 0x0b228d42, 0x0c4b0b94, 0x3eceeaad, 
	0x3ebb4ddb, 0x0cada4f5, 0x0dd4b19a, 0x3e7cd778, 0x3e66d0b4, 0x0e36c82a, 0x0f5c35a3, 0x3e212179, 
	0x3e08b42a, 0x0fbdba40, 0x10e15b4e, 0x3dbbd6d4, 0x3da106bd, 0x11423ef0, 0x1263e699, 0x3d4d0728, 
	0x3d2fd86c, 0x12c41a4f, 0x13e39be9, 0x3cd4c38b, 0x3cb53aaa, 0x144310dd, 0x15604013, 0x3c531e88, 
	0x3c314060, 0x15bee78c, 0x16d99864, 0x3bc82c1f, 0x3ba3fde7, 0x173763c9, 0x184f6aab, 0x3b3401bb, 
	0x3b0d8909, 0x18ac4b87, 0x19c17d44, 0x3a96b636, 0x3a6df8f8, 0x1a1d6544, 0x1b2f971e, 0x39f061d2, 
	0x39c5664f, 0x1b8a7815, 0x1c997fc4, 0x39411e33, 0x3913eb0e, 0x1cf34baf, 0x1dfeff67, 0x38890663, 
	0x3859a292, 0x1e57a86d, 0x1f5fdee6, 0x37c836c2, 0x3796a996, 0x1fb7575c, 0x20bbe7d8, 0x36fecd0e, 
	0x36cb1e2a, 0x21122240, 0x2212e492, 0x362ce855, 0x35f71fb1, 0x2267d3a0, 0x2364a02e, 0x3552a8f4, 
	0x351acedd, 0x23b836ca, 0x24b0e699, 0x34703095, 0x34364da6, 0x250317df, 0x25f78497, 0x3385a222, 
	0x3349bf48, 0x264843d9, 0x273847c8, 0x329321c7, 0x32554840, 0x27878893, 0x2872feb6, 0x3198d4ea, 
	0x31590e3e, 0x28c0b4d2, 0x29a778db, 0x3096e223, 0x30553828, 0x29f3984c, 0x2ad586a3, 0x2f8d713a, 
	0x2f49ee0f, 0x2b2003ac, 0x2bfcf97c, 0x2e7cab1c, 0x2e37592c, 0x2c45c8a0, 0x2d1da3d5, 0x2d64b9da, 
	/* 1024 */
	0x3fffffb1, 0x0006487f, 0x002bfb74, 0x3ffff0e3, 0x3fffe705, 0x00388c6e, 0x005e3f4c, 0x3fffba9b, 
	0x3fffa6de, 0x006ad03b, 0x009082ea, 0x3fff5cd8, 0x3fff3f3c, 0x009d13c5, 0x00c2c62f, 0x3ffed79b, 
	0x3ffeb021, 0x00cf56ef, 0x00f508fc, 0x3ffe2ae5, 0x3ffdf98c, 0x01019998, 0x01274b31, 0x3ffd56b5, 
	0x3ffd1b7e, 0x0133dba3, 0x01598cb1, 0x3ffc5b0c, 0x3ffc15f7, 0x01661cf0, 0x018bcd5b, 0x3ffb37ec, 
	0x3ffae8f9, 0x01985d60, 0x01be0d11, 0x3ff9ed53, 0x3ff99483, 0x01ca9cd4, 0x01f04bb4, 0x3ff87b44, 
	0x3ff81896, 0x01fcdb2e, 0x02228924, 0x3ff6e1bf, 0x3ff67534, 0x022f184d, 0x0254c544, 0x3ff520c5, 
	0x3ff4aa5d, 0x02615414, 0x0286fff3, 0x3ff33858, 0x3ff2b813, 0x02938e62, 0x02b93914, 0x3ff12878, 
	0x3ff09e56, 0x02c5c71a, 0x02eb7086, 0x3feef126, 0x3fee5d28, 0x02f7fe1c, 0x031da62b, 0x3fec9265, 
	0x3febf48b, 0x032a3349, 0x034fd9e5, 0x3fea0c35, 0x3fe96480, 0x035c6682, 0x03820b93, 0x3fe75e98, 
	0x3fe6ad08, 0x038e97a9, 0x03b43b17, 0x3fe48990, 0x3fe3ce26, 0x03c0c69e, 0x03e66852, 0x3fe18d1f, 
	0x3fe0c7da, 0x03f2f342, 0x04189326, 0x3fde6945, 0x3fdd9a27, 0x04251d77, 0x044abb73, 0x3fdb1e06, 
	0x3fda450f, 0x0457451d, 0x047ce11a, 0x3fd7ab64, 0x3fd6c894, 0x04896a16, 0x04af03fc, 0x3fd4115f, 
	0x3fd324b7, 0x04bb8c42, 0x04e123fa, 0x3fd04ffc, 0x3fcf597c, 0x04edab83, 0x051340f6, 0x3fcc673b, 
	0x3fcb66e4, 0x051fc7b9, 0x05455ad1, 0x3fc8571f, 0x3fc74cf3, 0x0551e0c7, 0x0577716b, 0x3fc41fac, 
	0x3fc30baa, 0x0583f68c, 0x05a984a6, 0x3fbfc0e3, 0x3fbea30c, 0x05b608eb, 0x05db9463, 0x3fbb3ac7, 
	0x3fba131b, 0x05e817c3, 0x060da083, 0x3fb68d5b, 0x3fb55bdc, 0x061a22f7, 0x063fa8e7, 0x3fb1b8a2, 
	0x3fb07d50, 0x064c2a67, 0x0671ad71, 0x3facbc9f, 0x3fab777b, 0x067e2df5, 0x06a3ae00, 0x3fa79954, 
	0x3fa64a5f, 0x06b02d81, 0x06d5aa77, 0x3fa24ec6, 0x3fa0f600, 0x06e228ee, 0x0707a2b7, 0x3f9cdcf7, 
	0x3f9b7a62, 0x0714201b, 0x073996a1, 0x3f9743eb, 0x3f95d787, 0x074612eb, 0x076b8616, 0x3f9183a5, 
	0x3f900d72, 0x0778013d, 0x079d70f7, 0x3f8b9c28, 0x3f8a1c29, 0x07a9eaf5, 0x07cf5726, 0x3f858d79, 
	0x3f8403ae, 0x07dbcff2, 0x08013883, 0x3f7f579b, 0x3f7dc405, 0x080db016, 0x083314f1, 0x3f78fa92, 
	0x3f775d31, 0x083f8b43, 0x0864ec4f, 0x3f727661, 0x3f70cf38, 0x08716159, 0x0896be80, 0x3f6bcb0e, 
	0x3f6a1a1c, 0x08a3323a, 0x08c88b65, 0x3f64f89b, 0x3f633de2, 0x08d4fdc6, 0x08fa52de, 0x3f5dff0e, 
	0x3f5c3a8f, 0x0906c3e0, 0x092c14ce, 0x3f56de6a, 0x3f551026, 0x09388469, 0x095dd116, 0x3f4f96b4, 
	0x3f4dbeac, 0x096a3f42, 0x098f8796, 0x3f4827f0, 0x3f464626, 0x099bf44c, 0x09c13831, 0x3f409223, 
	0x3f3ea697, 0x09cda368, 0x09f2e2c7, 0x3f38d552, 0x3f36e006, 0x09ff4c78, 0x0a24873a, 0x3f30f181, 
	0x3f2ef276, 0x0a30ef5e, 0x0a56256c, 0x3f28e6b6, 0x3f26ddec, 0x0a628bfa, 0x0a87bd3d, 0x3f20b4f5, 
	0x3f1ea26e, 0x0a94222f, 0x0ab94e8f, 0x3f185c43, 0x3f164001, 0x0ac5b1dc, 0x0aead944, 0x3f0fdca5, 
	0x3f0db6a9, 0x0af73ae5, 0x0b1c5d3d, 0x3f073621, 0x3f05066d, 0x0b28bd2a, 0x0b4dda5c, 0x3efe68bc, 
	0x3efc2f50, 0x0b5a388d, 0x0b7f5081, 0x3ef5747b, 0x3ef3315a, 0x0b8bacf0, 0x0bb0bf8f, 0x3eec5965, 
	0x3eea0c8e, 0x0bbd1a33, 0x0be22766, 0x3ee3177e, 0x3ee0c0f4, 0x0bee8038, 0x0c1387e9, 0x3ed9aecc, 
	0x3ed74e91, 0x0c1fdee1, 0x0c44e0f9, 0x3ed01f55, 0x3ecdb56a, 0x0c513610, 0x0c763278, 0x3ec66920, 
	0x3ec3f585, 0x0c8285a5, 0x0ca77c47, 0x3ebc8c31, 0x3eba0ee9, 0x0cb3cd84, 0x0cd8be47, 0x3eb2888f, 
	0x3eb0019c, 0x0ce50d8c, 0x0d09f85b, 0x3ea85e41, 0x3ea5cda3, 0x0d1645a0, 0x0d3b2a64, 0x3e9e0d4c, 
	0x3e9b7306, 0x0d4775a1, 0x0d6c5443, 0x3e9395b7, 0x3e90f1ca, 0x0d789d71, 0x0d9d75db, 0x3e88f788, 
	0x3e8649f5, 0x0da9bcf2, 0x0dce8f0d, 0x3e7e32c6, 0x3e7b7b90, 0x0ddad406, 0x0dff9fba, 0x3e734778, 
	0x3e70869f, 0x0e0be28e, 0x0e30a7c5, 0x3e6835a4, 0x3e656b2b, 0x0e3ce86b, 0x0e61a70f, 0x3e5cfd51, 
	0x3e5a2939, 0x0e6de580, 0x0e929d7a, 0x3e519e86, 0x3e4ec0d1, 0x0e9ed9af, 0x0ec38ae8, 0x3e46194a, 
	0x3e4331fa, 0x0ecfc4d9, 0x0ef46f3b, 0x3e3a6da4, 0x3e377cbb, 0x0f00a6df, 0x0f254a53, 0x3e2e9b9c, 
	0x3e2ba11b, 0x0f317fa5, 0x0f561c15, 0x3e22a338, 0x3e1f9f21, 0x0f624f0c, 0x0f86e460, 0x3e168480, 
	0x3e1376d5, 0x0f9314f5, 0x0fb7a317, 0x3e0a3f7b, 0x3e07283f, 0x0fc3d143, 0x0fe8581d, 0x3dfdd432, 
	0x3dfab365, 0x0ff483d7, 0x10190352, 0x3df142ab, 0x3dee1851, 0x10252c94, 0x1049a49a, 0x3de48aef, 
	0x3de15708, 0x1055cb5b, 0x107a3bd5, 0x3dd7ad05, 0x3dd46f94, 0x1086600e, 0x10aac8e6, 0x3dcaa8f5, 
	0x3dc761fc, 0x10b6ea90, 0x10db4baf, 0x3dbd7ec7, 0x3dba2e48, 0x10e76ac3, 0x110bc413, 0x3db02e84, 
	0x3dacd481, 0x1117e088, 0x113c31f3, 0x3da2b834, 0x3d9f54af, 0x11484bc2, 0x116c9531, 0x3d951bde, 
	0x3d91aed9, 0x1178ac53, 0x119cedaf, 0x3d87598c, 0x3d83e309, 0x11a9021d, 0x11cd3b50, 0x3d797145, 
	0x3d75f147, 0x11d94d02, 0x11fd7df6, 0x3d6b6313, 0x3d67d99b, 0x12098ce5, 0x122db583, 0x3d5d2efe, 
	0x3d599c0e, 0x1239c1a7, 0x125de1da, 0x3d4ed50f, 0x3d4b38aa, 0x1269eb2b, 0x128e02dc, 0x3d40554e, 
	0x3d3caf76, 0x129a0954, 0x12be186c, 0x3d31afc5, 0x3d2e007c, 0x12ca1c03, 0x12ee226c, 0x3d22e47c, 
	0x3d1f2bc5, 0x12fa231b, 0x131e20c0, 0x3d13f37e, 0x3d10315a, 0x132a1e7e, 0x134e1348, 0x3d04dcd2, 
	0x3d011145, 0x135a0e0e, 0x137df9e7, 0x3cf5a082, 0x3cf1cb8e, 0x1389f1af, 0x13add481, 0x3ce63e98, 
	0x3ce2603f, 0x13b9c943, 0x13dda2f7, 0x3cd6b71e, 0x3cd2cf62, 0x13e994ab, 0x140d652c, 0x3cc70a1c, 
	0x3cc318ff, 0x141953cb, 0x143d1b02, 0x3cb7379c, 0x3cb33d22, 0x14490685, 0x146cc45c, 0x3ca73fa9, 
	0x3ca33bd3, 0x1478acbc, 0x149c611d, 0x3c97224c, 0x3c93151d, 0x14a84652, 0x14cbf127, 0x3c86df8e, 
	0x3c82c909, 0x14d7d32a, 0x14fb745e, 0x3c76777b, 0x3c7257a2, 0x15075327, 0x152aeaa3, 0x3c65ea1c, 
	0x3c61c0f1, 0x1536c62b, 0x155a53d9, 0x3c55377b, 0x3c510501, 0x15662c18, 0x1589afe3, 0x3c445fa2, 
	0x3c4023dd, 0x159584d3, 0x15b8fea4, 0x3c33629d, 0x3c2f1d8e, 0x15c4d03e, 0x15e83fff, 0x3c224075, 
	0x3c1df21f, 0x15f40e3a, 0x161773d6, 0x3c10f935, 0x3c0ca19b, 0x16233eac, 0x16469a0d, 0x3bff8ce8, 
	0x3bfb2c0c, 0x16526176, 0x1675b286, 0x3bedfb99, 0x3be9917e, 0x1681767c, 0x16a4bd25, 0x3bdc4552, 
	0x3bd7d1fa, 0x16b07d9f, 0x16d3b9cc, 0x3bca6a1d, 0x3bc5ed8d, 0x16df76c3, 0x1702a85e, 0x3bb86a08, 
	0x3bb3e440, 0x170e61cc, 0x173188be, 0x3ba6451b, 0x3ba1b620, 0x173d3e9b, 0x17605ad0, 0x3b93fb63, 
	0x3b8f6337, 0x176c0d15, 0x178f1e76, 0x3b818ceb, 0x3b7ceb90, 0x179acd1c, 0x17bdd394, 0x3b6ef9be, 
	0x3b6a4f38, 0x17c97e93, 0x17ec7a0d, 0x3b5c41e8, 0x3b578e39, 0x17f8215e, 0x181b11c4, 0x3b496574, 
	0x3b44a8a0, 0x1826b561, 0x18499a9d, 0x3b36646e, 0x3b319e77, 0x18553a7d, 0x1878147a, 0x3b233ee1, 
	0x3b1e6fca, 0x1883b097, 0x18a67f3f, 0x3b0ff4d9, 0x3b0b1ca6, 0x18b21791, 0x18d4dad0, 0x3afc8663, 
	0x3af7a516, 0x18e06f50, 0x1903270f, 0x3ae8f38b, 0x3ae40926, 0x190eb7b7, 0x193163e1, 0x3ad53c5b, 
	0x3ad048e3, 0x193cf0a9, 0x195f9128, 0x3ac160e1, 0x3abc6458, 0x196b1a09, 0x198daec8, 0x3aad6129, 
	0x3aa85b92, 0x199933bb, 0x19bbbca6, 0x3a993d3e, 0x3a942e9d, 0x19c73da3, 0x19e9baa3, 0x3a84f52f, 
	0x3a7fdd86, 0x19f537a4, 0x1a17a8a5, 0x3a708906, 0x3a6b6859, 0x1a2321a2, 0x1a45868e, 0x3a5bf8d1, 
	0x3a56cf23, 0x1a50fb81, 0x1a735442, 0x3a47449c, 0x3a4211f0, 0x1a7ec524, 0x1aa111a6, 0x3a326c74, 
	0x3a2d30cd, 0x1aac7e6f, 0x1acebe9d, 0x3a1d7066, 0x3a182bc8, 0x1ada2746, 0x1afc5b0a, 0x3a08507f, 
	0x3a0302ed, 0x1b07bf8c, 0x1b29e6d2, 0x39f30ccc, 0x39edb649, 0x1b354727, 0x1b5761d8, 0x39dda55a, 
	0x39d845e9, 0x1b62bdf8, 0x1b84cc01, 0x39c81a36, 0x39c2b1da, 0x1b9023e5, 0x1bb22530, 0x39b26b6d, 
	0x39acfa2b, 0x1bbd78d2, 0x1bdf6d4a, 0x399c990d, 0x39971ee7, 0x1beabca1, 0x1c0ca432, 0x3986a324, 
	0x3981201e, 0x1c17ef39, 0x1c39c9cd, 0x397089bf, 0x396afddc, 0x1c45107c, 0x1c66ddfe, 0x395a4ceb, 
	0x3954b82e, 0x1c72204f, 0x1c93e0ab, 0x3943ecb6, 0x393e4f23, 0x1c9f1e96, 0x1cc0d1b6, 0x392d692f, 
	0x3927c2c9, 0x1ccc0b35, 0x1cedb106, 0x3916c262, 0x3911132d, 0x1cf8e611, 0x1d1a7e7d, 0x38fff85e, 
	0x38fa405e, 0x1d25af0d, 0x1d473a00, 0x38e90b31, 0x38e34a69, 0x1d52660f, 0x1d73e374, 0x38d1fae9, 
	0x38cc315d, 0x1d7f0afb, 0x1da07abc, 0x38bac795, 0x38b4f547, 0x1dab9db5, 0x1dccffbf, 0x38a37142, 
	0x389d9637, 0x1dd81e21, 0x1df9725f, 0x388bf7ff, 0x3886143b, 0x1e048c24, 0x1e25d282, 0x38745bdb, 
	0x386e6f60, 0x1e30e7a4, 0x1e52200c, 0x385c9ce3, 0x3856a7b6, 0x1e5d3084, 0x1e7e5ae2, 0x3844bb28, 
	0x383ebd4c, 0x1e8966a8, 0x1eaa82e9, 0x382cb6b7, 0x3826b030, 0x1eb589f7, 0x1ed69805, 0x38148f9f, 
	0x380e8071, 0x1ee19a54, 0x1f029a1c, 0x37fc45ef, 0x37f62e1d, 0x1f0d97a5, 0x1f2e8911, 0x37e3d9b7, 
	0x37ddb945, 0x1f3981ce, 0x1f5a64cb, 0x37cb4b04, 0x37c521f6, 0x1f6558b5, 0x1f862d2d, 0x37b299e7, 
	0x37ac6841, 0x1f911c3d, 0x1fb1e21d, 0x3799c66f, 0x37938c34, 0x1fbccc4d, 0x1fdd8381, 0x3780d0aa, 
	0x377a8ddf, 0x1fe868c8, 0x2009113c, 0x3767b8a9, 0x37616d51, 0x2013f196, 0x20348b35, 0x374e7e7b, 
	0x37482a9a, 0x203f6699, 0x205ff14f, 0x3735222f, 0x372ec5c9, 0x206ac7b8, 0x208b4372, 0x371ba3d4, 
	0x37153eee, 0x209614d9, 0x20b68181, 0x3702037c, 0x36fb9618, 0x20c14ddf, 0x20e1ab63, 0x36e84135, 
	0x36e1cb58, 0x20ec72b1, 0x210cc0fc, 0x36ce5d10, 0x36c7debd, 0x21178334, 0x2137c232, 0x36b4571b, 
	0x36add058, 0x21427f4d, 0x2162aeea, 0x369a2f69, 0x3693a038, 0x216d66e2, 0x218d870b, 0x367fe608, 
	0x36794e6e, 0x219839d8, 0x21b84a79, 0x36657b08, 0x365edb09, 0x21c2f815, 0x21e2f91a, 0x364aee7b, 
	0x3644461b, 0x21eda17f, 0x220d92d4, 0x36304070, 0x36298fb4, 0x221835fb, 0x2238178d, 0x361570f8, 
	0x360eb7e3, 0x2242b56f, 0x22628729, 0x35fa8023, 0x35f3beba, 0x226d1fc1, 0x228ce191, 0x35df6e03, 
	0x35d8a449, 0x229774d7, 0x22b726a8, 0x35c43aa7, 0x35bd68a1, 0x22c1b496, 0x22e15655, 0x35a8e621, 
	0x35a20bd3, 0x22ebdee5, 0x230b707e, 0x358d7081, 0x35868def, 0x2315f3a8, 0x23357509, 0x3571d9d9, 
	0x356aef08, 0x233ff2c8, 0x235f63dc, 0x35562239, 0x354f2f2c, 0x2369dc29, 0x23893cdd, 0x353a49b2, 
	0x35334e6f, 0x2393afb2, 0x23b2fff3, 0x351e5056, 0x35174ce0, 0x23bd6d48, 0x23dcad03, 0x35023636, 
	0x34fb2a92, 0x23e714d3, 0x240643f4, 0x34e5fb63, 0x34dee795, 0x2410a639, 0x242fc4ad, 0x34c99fef, 
	0x34c283fb, 0x243a215f, 0x24592f13, 0x34ad23eb, 0x34a5ffd5, 0x2463862c, 0x2482830d, 0x34908768, 
	0x34895b36, 0x248cd487, 0x24abc082, 0x3473ca79, 0x346c962f, 0x24b60c57, 0x24d4e757, 0x3456ed2f, 
	0x344fb0d1, 0x24df2d81, 0x24fdf775, 0x3439ef9c, 0x3432ab2e, 0x250837ed, 0x2526f0c1, 0x341cd1d2, 
	0x34158559, 0x25312b81, 0x254fd323, 0x33ff93e2, 0x33f83f62, 0x255a0823, 0x25789e80, 0x33e235df, 
	0x33dad95e, 0x2582cdbc, 0x25a152c0, 0x33c4b7db, 0x33bd535c, 0x25ab7c30, 0x25c9efca, 0x33a719e8, 
	0x339fad70, 0x25d41369, 0x25f27584, 0x33895c18, 0x3381e7ac, 0x25fc934b, 0x261ae3d6, 0x336b7e7e, 
	0x33640223, 0x2624fbbf, 0x26433aa7, 0x334d812d, 0x3345fce6, 0x264d4cac, 0x266b79dd, 0x332f6435, 
	0x3327d808, 0x267585f8, 0x2693a161, 0x331127ab, 0x3309939c, 0x269da78b, 0x26bbb119, 0x32f2cba1, 
	0x32eb2fb5, 0x26c5b14c, 0x26e3a8ec, 0x32d45029, 0x32ccac64, 0x26eda322, 0x270b88c2, 0x32b5b557, 
	0x32ae09be, 0x27157cf5, 0x27335082, 0x3296fb3d, 0x328f47d5, 0x273d3eac, 0x275b0014, 0x327821ee, 
	0x327066bc, 0x2764e82f, 0x27829760, 0x3259297d, 0x32516686, 0x278c7965, 0x27aa164c, 0x323a11fe, 
	0x32324746, 0x27b3f235, 0x27d17cc1, 0x321adb83, 0x3213090f, 0x27db5288, 0x27f8caa5, 0x31fb8620, 
	0x31f3abf5, 0x28029a45, 0x281fffe2, 0x31dc11e8, 0x31d4300b, 0x2829c954, 0x28471c5e, 0x31bc7eee, 
	0x31b49564, 0x2850df9d, 0x286e2002, 0x319ccd46, 0x3194dc14, 0x2877dd07, 0x28950ab6, 0x317cfd04, 
	0x3175042e, 0x289ec17a, 0x28bbdc61, 0x315d0e3b, 0x31550dc6, 0x28c58cdf, 0x28e294eb, 0x313d00ff, 
	0x3134f8f1, 0x28ec3f1e, 0x2909343e, 0x311cd564, 0x3114c5c0, 0x2912d81f, 0x292fba40, 0x30fc8b7d, 
	0x30f47449, 0x293957c9, 0x295626da, 0x30dc235e, 0x30d404a0, 0x295fbe06, 0x297c79f5, 0x30bb9d1c, 
	0x30b376d8, 0x29860abd, 0x29a2b378, 0x309af8ca, 0x3092cb05, 0x29ac3dd7, 0x29c8d34d, 0x307a367c, 
	0x3072013c, 0x29d2573c, 0x29eed95b, 0x30595648, 0x30511991, 0x29f856d5, 0x2a14c58b, 0x30385840, 
	0x30301418, 0x2a1e3c8a, 0x2a3a97c7, 0x30173c7a, 0x300ef0e5, 0x2a440844, 0x2a604ff5, 0x2ff6030a, 
	0x2fedb00d, 0x2a69b9ec, 0x2a85ee00, 0x2fd4ac04, 0x2fcc51a5, 0x2a8f516b, 0x2aab71d0, 0x2fb3377c, 
	0x2faad5c1, 0x2ab4cea9, 0x2ad0db4e, 0x2f91a589, 0x2f893c75, 0x2ada318e, 0x2af62a63, 0x2f6ff63d, 
	0x2f6785d7, 0x2aff7a05, 0x2b1b5ef8, 0x2f4e29af, 0x2f45b1fb, 0x2b24a7f6, 0x2b4078f5, 0x2f2c3ff2, 
	0x2f23c0f6, 0x2b49bb4a, 0x2b657844, 0x2f0a391d, 0x2f01b2de, 0x2b6eb3ea, 0x2b8a5cce, 0x2ee81543, 
	0x2edf87c6, 0x2b9391c0, 0x2baf267d, 0x2ec5d479, 0x2ebd3fc4, 0x2bb854b4, 0x2bd3d53a, 0x2ea376d6, 
	0x2e9adaee, 0x2bdcfcb0, 0x2bf868ed, 0x2e80fc6e, 0x2e785958, 0x2c01899e, 0x2c1ce181, 0x2e5e6556, 
	0x2e55bb17, 0x2c25fb66, 0x2c413edf, 0x2e3bb1a4, 0x2e330042, 0x2c4a51f3, 0x2c6580f1, 0x2e18e16d, 
	0x2e1028ed, 0x2c6e8d2e, 0x2c89a79f, 0x2df5f4c7, 0x2ded352f, 0x2c92ad01, 0x2cadb2d5, 0x2dd2ebc7, 
	0x2dca251c, 0x2cb6b155, 0x2cd1a27b, 0x2dafc683, 0x2da6f8ca, 0x2cda9a14, 0x2cf5767c, 0x2d8c8510, 
	0x2d83b04f, 0x2cfe6728, 0x2d192ec1, 0x2d692784, 0x2d604bc0, 0x2d22187a, 0x2d3ccb34, 0x2d45adf6
};

const int twidTab512[8*6 + 32*6 + 128*6] = {
	0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x3b20d79e, 0x187de2a6, 
	0x3ec52f9f, 0x0c7c5c1e, 0x3536cc52, 0x238e7673, 0x2d413ccc, 0x2d413ccc, 0x3b20d79e, 0x187de2a6, 
	0x187de2a6, 0x3b20d79e, 0x187de2a6, 0x3b20d79e, 0x3536cc52, 0x238e7673, 0xf383a3e2, 0x3ec52f9f, 
	0x00000000, 0x40000000, 0x2d413ccc, 0x2d413ccc, 0xd2bec334, 0x2d413ccc, 0xe7821d5a, 0x3b20d79e, 
	0x238e7673, 0x3536cc52, 0xc13ad061, 0x0c7c5c1e, 0xd2bec334, 0x2d413ccc, 0x187de2a6, 0x3b20d79e, 
	0xc4df2862, 0xe7821d5a, 0xc4df2862, 0x187de2a6, 0x0c7c5c1e, 0x3ec52f9f, 0xdc71898d, 0xcac933ae, 

	0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x3fb11b47, 0x0645e9af, 
	0x3fec43c6, 0x0323ecbe, 0x3f4eaafe, 0x09640837, 0x3ec52f9f, 0x0c7c5c1e, 0x3fb11b47, 0x0645e9af, 
	0x3d3e82ad, 0x1294062e, 0x3d3e82ad, 0x1294062e, 0x3f4eaafe, 0x09640837, 0x39daf5e8, 0x1b5d1009, 
	0x3b20d79e, 0x187de2a6, 0x3ec52f9f, 0x0c7c5c1e, 0x3536cc52, 0x238e7673, 0x387165e3, 0x1e2b5d38, 
	0x3e14fdf7, 0x0f8cfcbd, 0x2f6bbe44, 0x2afad269, 0x3536cc52, 0x238e7673, 0x3d3e82ad, 0x1294062e, 
	0x2899e64a, 0x317900d6, 0x317900d6, 0x2899e64a, 0x3c424209, 0x158f9a75, 0x20e70f32, 0x36e5068a, 
	0x2d413ccc, 0x2d413ccc, 0x3b20d79e, 0x187de2a6, 0x187de2a6, 0x3b20d79e, 0x2899e64a, 0x317900d6, 
	0x39daf5e8, 0x1b5d1009, 0x0f8cfcbd, 0x3e14fdf7, 0x238e7673, 0x3536cc52, 0x387165e3, 0x1e2b5d38, 
	0x0645e9af, 0x3fb11b47, 0x1e2b5d38, 0x387165e3, 0x36e5068a, 0x20e70f32, 0xfcdc1342, 0x3fec43c6, 
	0x187de2a6, 0x3b20d79e, 0x3536cc52, 0x238e7673, 0xf383a3e2, 0x3ec52f9f, 0x1294062e, 0x3d3e82ad, 
	0x3367c08f, 0x261feff9, 0xea70658b, 0x3c424209, 0x0c7c5c1e, 0x3ec52f9f, 0x317900d6, 0x2899e64a, 
	0xe1d4a2c8, 0x387165e3, 0x0645e9af, 0x3fb11b47, 0x2f6bbe44, 0x2afad269, 0xd9e01007, 0x3367c08f, 
	0x00000000, 0x40000000, 0x2d413ccc, 0x2d413ccc, 0xd2bec334, 0x2d413ccc, 0xf9ba1651, 0x3fb11b47, 
	0x2afad269, 0x2f6bbe44, 0xcc983f71, 0x261feff9, 0xf383a3e2, 0x3ec52f9f, 0x2899e64a, 0x317900d6, 
	0xc78e9a1d, 0x1e2b5d38, 0xed6bf9d2, 0x3d3e82ad, 0x261feff9, 0x3367c08f, 0xc3bdbdf7, 0x158f9a75, 
	0xe7821d5a, 0x3b20d79e, 0x238e7673, 0x3536cc52, 0xc13ad061, 0x0c7c5c1e, 0xe1d4a2c8, 0x387165e3, 
	0x20e70f32, 0x36e5068a, 0xc013bc3a, 0x0323ecbe, 0xdc71898d, 0x3536cc52, 0x1e2b5d38, 0x387165e3, 
	0xc04ee4b9, 0xf9ba1651, 0xd76619b6, 0x317900d6, 0x1b5d1009, 0x39daf5e8, 0xc1eb0209, 0xf0730343, 
	0xd2bec334, 0x2d413ccc, 0x187de2a6, 0x3b20d79e, 0xc4df2862, 0xe7821d5a, 0xce86ff2a, 0x2899e64a, 
	0x158f9a75, 0x3c424209, 0xc91af976, 0xdf18f0ce, 0xcac933ae, 0x238e7673, 0x1294062e, 0x3d3e82ad, 
	0xce86ff2a, 0xd76619b6, 0xc78e9a1d, 0x1e2b5d38, 0x0f8cfcbd, 0x3e14fdf7, 0xd5052d97, 0xd09441bc, 
	0xc4df2862, 0x187de2a6, 0x0c7c5c1e, 0x3ec52f9f, 0xdc71898d, 0xcac933ae, 0xc2c17d53, 0x1294062e, 
	0x09640837, 0x3f4eaafe, 0xe4a2eff7, 0xc6250a18, 0xc13ad061, 0x0c7c5c1e, 0x0645e9af, 0x3fb11b47, 
	0xed6bf9d2, 0xc2c17d53, 0xc04ee4b9, 0x0645e9af, 0x0323ecbe, 0x3fec43c6, 0xf69bf7c9, 0xc0b15502, 

	0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x3ffb10c1, 0x0192155f, 
	0x3ffec42d, 0x00c90e8f, 0x3ff4e5df, 0x025b0cae, 0x3fec43c6, 0x0323ecbe, 0x3ffb10c1, 0x0192155f, 
	0x3fd39b5a, 0x04b54824, 0x3fd39b5a, 0x04b54824, 0x3ff4e5df, 0x025b0cae, 0x3f9c2bfa, 0x070de171, 
	0x3fb11b47, 0x0645e9af, 0x3fec43c6, 0x0323ecbe, 0x3f4eaafe, 0x09640837, 0x3f84c8e1, 0x07d59395, 
	0x3fe12acb, 0x03ecadcf, 0x3eeb3347, 0x0bb6ecef, 0x3f4eaafe, 0x09640837, 0x3fd39b5a, 0x04b54824, 
	0x3e71e758, 0x0e05c135, 0x3f0ec9f4, 0x0af10a22, 0x3fc395f9, 0x057db402, 0x3de2f147, 0x104fb80e, 
	0x3ec52f9f, 0x0c7c5c1e, 0x3fb11b47, 0x0645e9af, 0x3d3e82ad, 0x1294062e, 0x3e71e758, 0x0e05c135, 
	0x3f9c2bfa, 0x070de171, 0x3c84d496, 0x14d1e242, 0x3e14fdf7, 0x0f8cfcbd, 0x3f84c8e1, 0x07d59395, 
	0x3bb6276d, 0x17088530, 0x3dae81ce, 0x1111d262, 0x3f6af2e3, 0x089cf867, 0x3ad2c2e7, 0x19372a63, 
	0x3d3e82ad, 0x1294062e, 0x3f4eaafe, 0x09640837, 0x39daf5e8, 0x1b5d1009, 0x3cc511d8, 0x14135c94, 
	0x3f2ff249, 0x0a2abb58, 0x38cf1669, 0x1d79775b, 0x3c424209, 0x158f9a75, 0x3f0ec9f4, 0x0af10a22, 
	0x37af8158, 0x1f8ba4db, 0x3bb6276d, 0x17088530, 0x3eeb3347, 0x0bb6ecef, 0x367c9a7d, 0x2192e09a, 
	0x3b20d79e, 0x187de2a6, 0x3ec52f9f, 0x0c7c5c1e, 0x3536cc52, 0x238e7673, 0x3a8269a2, 0x19ef7943, 
	0x3e9cc076, 0x0d415012, 0x33de87de, 0x257db64b, 0x39daf5e8, 0x1b5d1009, 0x3e71e758, 0x0e05c135, 
	0x32744493, 0x275ff452, 0x392a9642, 0x1cc66e99, 0x3e44a5ee, 0x0ec9a7f2, 0x30f8801f, 0x29348937, 
	0x387165e3, 0x1e2b5d38, 0x3e14fdf7, 0x0f8cfcbd, 0x2f6bbe44, 0x2afad269, 0x37af8158, 0x1f8ba4db, 
	0x3de2f147, 0x104fb80e, 0x2dce88a9, 0x2cb2324b, 0x36e5068a, 0x20e70f32, 0x3dae81ce, 0x1111d262, 
	0x2c216eaa, 0x2e5a106f, 0x361214b0, 0x223d66a8, 0x3d77b191, 0x11d3443f, 0x2a650525, 0x2ff1d9c6, 
	0x3536cc52, 0x238e7673, 0x3d3e82ad, 0x1294062e, 0x2899e64a, 0x317900d6, 0x34534f40, 0x24da0a99, 
	0x3d02f756, 0x135410c2, 0x26c0b162, 0x32eefde9, 0x3367c08f, 0x261feff9, 0x3cc511d8, 0x14135c94, 
	0x24da0a99, 0x34534f40, 0x32744493, 0x275ff452, 0x3c84d496, 0x14d1e242, 0x22e69ac7, 0x35a5793c, 
	0x317900d6, 0x2899e64a, 0x3c424209, 0x158f9a75, 0x20e70f32, 0x36e5068a, 0x30761c17, 0x29cd9577, 
	0x3bfd5cc4, 0x164c7ddd, 0x1edc1952, 0x3811884c, 0x2f6bbe44, 0x2afad269, 0x3bb6276d, 0x17088530, 
	0x1cc66e99, 0x392a9642, 0x2e5a106f, 0x2c216eaa, 0x3b6ca4c4, 0x17c3a931, 0x1aa6c82b, 0x3a2fcee8, 
	0x2d413ccc, 0x2d413ccc, 0x3b20d79e, 0x187de2a6, 0x187de2a6, 0x3b20d79e, 0x2c216eaa, 0x2e5a106f, 
	0x3ad2c2e7, 0x19372a63, 0x164c7ddd, 0x3bfd5cc4, 0x2afad269, 0x2f6bbe44, 0x3a8269a2, 0x19ef7943, 
	0x14135c94, 0x3cc511d8, 0x29cd9577, 0x30761c17, 0x3a2fcee8, 0x1aa6c82b, 0x11d3443f, 0x3d77b191, 
	0x2899e64a, 0x317900d6, 0x39daf5e8, 0x1b5d1009, 0x0f8cfcbd, 0x3e14fdf7, 0x275ff452, 0x32744493, 
	0x3983e1e7, 0x1c1249d8, 0x0d415012, 0x3e9cc076, 0x261feff9, 0x3367c08f, 0x392a9642, 0x1cc66e99, 
	0x0af10a22, 0x3f0ec9f4, 0x24da0a99, 0x34534f40, 0x38cf1669, 0x1d79775b, 0x089cf867, 0x3f6af2e3, 
	0x238e7673, 0x3536cc52, 0x387165e3, 0x1e2b5d38, 0x0645e9af, 0x3fb11b47, 0x223d66a8, 0x361214b0, 
	0x3811884c, 0x1edc1952, 0x03ecadcf, 0x3fe12acb, 0x20e70f32, 0x36e5068a, 0x37af8158, 0x1f8ba4db, 
	0x0192155f, 0x3ffb10c1, 0x1f8ba4db, 0x37af8158, 0x374b54ce, 0x2039f90e, 0xff36f171, 0x3ffec42d, 
	0x1e2b5d38, 0x387165e3, 0x36e5068a, 0x20e70f32, 0xfcdc1342, 0x3fec43c6, 0x1cc66e99, 0x392a9642, 
	0x367c9a7d, 0x2192e09a, 0xfa824bfe, 0x3fc395f9, 0x1b5d1009, 0x39daf5e8, 0x361214b0, 0x223d66a8, 
	0xf82a6c6b, 0x3f84c8e1, 0x19ef7943, 0x3a8269a2, 0x35a5793c, 0x22e69ac7, 0xf5d544a8, 0x3f2ff249, 
	0x187de2a6, 0x3b20d79e, 0x3536cc52, 0x238e7673, 0xf383a3e2, 0x3ec52f9f, 0x17088530, 0x3bb6276d, 
	0x34c61236, 0x2434f332, 0xf136580e, 0x3e44a5ee, 0x158f9a75, 0x3c424209, 0x34534f40, 0x24da0a99, 
	0xeeee2d9e, 0x3dae81ce, 0x14135c94, 0x3cc511d8, 0x33de87de, 0x257db64b, 0xecabef3e, 0x3d02f756, 
	0x1294062e, 0x3d3e82ad, 0x3367c08f, 0x261feff9, 0xea70658b, 0x3c424209, 0x1111d262, 0x3dae81ce, 
	0x32eefde9, 0x26c0b162, 0xe83c56cf, 0x3b6ca4c4, 0x0f8cfcbd, 0x3e14fdf7, 0x32744493, 0x275ff452, 
	0xe61086bd, 0x3a8269a2, 0x0e05c135, 0x3e71e758, 0x31f79947, 0x27fdb2a6, 0xe3edb628, 0x3983e1e7, 
	0x0c7c5c1e, 0x3ec52f9f, 0x317900d6, 0x2899e64a, 0xe1d4a2c8, 0x387165e3, 0x0af10a22, 0x3f0ec9f4, 
	0x30f8801f, 0x29348937, 0xdfc606f2, 0x374b54ce, 0x09640837, 0x3f4eaafe, 0x30761c17, 0x29cd9577, 
	0xddc29958, 0x361214b0, 0x07d59395, 0x3f84c8e1, 0x2ff1d9c6, 0x2a650525, 0xdbcb0cce, 0x34c61236, 
	0x0645e9af, 0x3fb11b47, 0x2f6bbe44, 0x2afad269, 0xd9e01007, 0x3367c08f, 0x04b54824, 0x3fd39b5a, 
	0x2ee3cebe, 0x2b8ef77c, 0xd8024d5a, 0x31f79947, 0x0323ecbe, 0x3fec43c6, 0x2e5a106f, 0x2c216eaa, 
	0xd6326a89, 0x30761c17, 0x0192155f, 0x3ffb10c1, 0x2dce88a9, 0x2cb2324b, 0xd4710884, 0x2ee3cebe, 
	0x00000000, 0x40000000, 0x2d413ccc, 0x2d413ccc, 0xd2bec334, 0x2d413ccc, 0xfe6deaa1, 0x3ffb10c1, 
	0x2cb2324b, 0x2dce88a9, 0xd11c3142, 0x2b8ef77c, 0xfcdc1342, 0x3fec43c6, 0x2c216eaa, 0x2e5a106f, 
	0xcf89e3e9, 0x29cd9577, 0xfb4ab7dc, 0x3fd39b5a, 0x2b8ef77c, 0x2ee3cebe, 0xce0866b9, 0x27fdb2a6, 
	0xf9ba1651, 0x3fb11b47, 0x2afad269, 0x2f6bbe44, 0xcc983f71, 0x261feff9, 0xf82a6c6b, 0x3f84c8e1, 
	0x2a650525, 0x2ff1d9c6, 0xcb39edca, 0x2434f332, 0xf69bf7c9, 0x3f4eaafe, 0x29cd9577, 0x30761c17, 
	0xc9edeb50, 0x223d66a8, 0xf50ef5de, 0x3f0ec9f4, 0x29348937, 0x30f8801f, 0xc8b4ab32, 0x2039f90e, 
	0xf383a3e2, 0x3ec52f9f, 0x2899e64a, 0x317900d6, 0xc78e9a1d, 0x1e2b5d38, 0xf1fa3ecb, 0x3e71e758, 
	0x27fdb2a6, 0x31f79947, 0xc67c1e19, 0x1c1249d8, 0xf0730343, 0x3e14fdf7, 0x275ff452, 0x32744493, 
	0xc57d965e, 0x19ef7943, 0xeeee2d9e, 0x3dae81ce, 0x26c0b162, 0x32eefde9, 0xc4935b3c, 0x17c3a931, 
	0xed6bf9d2, 0x3d3e82ad, 0x261feff9, 0x3367c08f, 0xc3bdbdf7, 0x158f9a75, 0xebeca36c, 0x3cc511d8, 
	0x257db64b, 0x33de87de, 0xc2fd08aa, 0x135410c2, 0xea70658b, 0x3c424209, 0x24da0a99, 0x34534f40, 
	0xc2517e32, 0x1111d262, 0xe8f77ad0, 0x3bb6276d, 0x2434f332, 0x34c61236, 0xc1bb5a12, 0x0ec9a7f2, 
	0xe7821d5a, 0x3b20d79e, 0x238e7673, 0x3536cc52, 0xc13ad061, 0x0c7c5c1e, 0xe61086bd, 0x3a8269a2, 
	0x22e69ac7, 0x35a5793c, 0xc0d00db7, 0x0a2abb58, 0xe4a2eff7, 0x39daf5e8, 0x223d66a8, 0x361214b0, 
	0xc07b371f, 0x07d59395, 0xe3399167, 0x392a9642, 0x2192e09a, 0x367c9a7d, 0xc03c6a07, 0x057db402, 
	0xe1d4a2c8, 0x387165e3, 0x20e70f32, 0x36e5068a, 0xc013bc3a, 0x0323ecbe, 0xe0745b25, 0x37af8158, 
	0x2039f90e, 0x374b54ce, 0xc0013bd3, 0x00c90e8f, 0xdf18f0ce, 0x36e5068a, 0x1f8ba4db, 0x37af8158, 
	0xc004ef3f, 0xfe6deaa1, 0xddc29958, 0x361214b0, 0x1edc1952, 0x3811884c, 0xc01ed535, 0xfc135231, 
	0xdc71898d, 0x3536cc52, 0x1e2b5d38, 0x387165e3, 0xc04ee4b9, 0xf9ba1651, 0xdb25f567, 0x34534f40, 
	0x1d79775b, 0x38cf1669, 0xc0950d1d, 0xf7630799, 0xd9e01007, 0x3367c08f, 0x1cc66e99, 0x392a9642, 
	0xc0f1360c, 0xf50ef5de, 0xd8a00bae, 0x32744493, 0x1c1249d8, 0x3983e1e7, 0xc1633f8a, 0xf2beafee, 
	0xd76619b6, 0x317900d6, 0x1b5d1009, 0x39daf5e8, 0xc1eb0209, 0xf0730343, 0xd6326a89, 0x30761c17, 
	0x1aa6c82b, 0x3a2fcee8, 0xc2884e6f, 0xee2cbbc1, 0xd5052d97, 0x2f6bbe44, 0x19ef7943, 0x3a8269a2, 
	0xc33aee28, 0xebeca36c, 0xd3de9156, 0x2e5a106f, 0x19372a63, 0x3ad2c2e7, 0xc402a33c, 0xe9b38223, 
	0xd2bec334, 0x2d413ccc, 0x187de2a6, 0x3b20d79e, 0xc4df2862, 0xe7821d5a, 0xd1a5ef91, 0x2c216eaa, 
	0x17c3a931, 0x3b6ca4c4, 0xc5d03118, 0xe55937d5, 0xd09441bc, 0x2afad269, 0x17088530, 0x3bb6276d, 
	0xc6d569be, 0xe3399167, 0xcf89e3e9, 0x29cd9577, 0x164c7ddd, 0x3bfd5cc4, 0xc7ee77b4, 0xe123e6ae, 
	0xce86ff2a, 0x2899e64a, 0x158f9a75, 0x3c424209, 0xc91af976, 0xdf18f0ce, 0xcd8bbb6d, 0x275ff452, 
	0x14d1e242, 0x3c84d496, 0xca5a86c4, 0xdd196539, 0xcc983f71, 0x261feff9, 0x14135c94, 0x3cc511d8, 
	0xcbacb0c0, 0xdb25f567, 0xcbacb0c0, 0x24da0a99, 0x135410c2, 0x3d02f756, 0xcd110217, 0xd93f4e9e, 
	0xcac933ae, 0x238e7673, 0x1294062e, 0x3d3e82ad, 0xce86ff2a, 0xd76619b6, 0xc9edeb50, 0x223d66a8, 
	0x11d3443f, 0x3d77b191, 0xd00e263a, 0xd59afadb, 0xc91af976, 0x20e70f32, 0x1111d262, 0x3dae81ce, 
	0xd1a5ef91, 0xd3de9156, 0xc8507ea8, 0x1f8ba4db, 0x104fb80e, 0x3de2f147, 0xd34dcdb5, 0xd2317757, 
	0xc78e9a1d, 0x1e2b5d38, 0x0f8cfcbd, 0x3e14fdf7, 0xd5052d97, 0xd09441bc, 0xc6d569be, 0x1cc66e99, 
	0x0ec9a7f2, 0x3e44a5ee, 0xd6cb76c9, 0xcf077fe1, 0xc6250a18, 0x1b5d1009, 0x0e05c135, 0x3e71e758, 
	0xd8a00bae, 0xcd8bbb6d, 0xc57d965e, 0x19ef7943, 0x0d415012, 0x3e9cc076, 0xda8249b5, 0xcc217822, 
	0xc4df2862, 0x187de2a6, 0x0c7c5c1e, 0x3ec52f9f, 0xdc71898d, 0xcac933ae, 0xc449d893, 0x17088530, 
	0x0bb6ecef, 0x3eeb3347, 0xde6d1f66, 0xc9836583, 0xc3bdbdf7, 0x158f9a75, 0x0af10a22, 0x3f0ec9f4, 
	0xe0745b25, 0xc8507ea8, 0xc33aee28, 0x14135c94, 0x0a2abb58, 0x3f2ff249, 0xe28688a5, 0xc730e997, 
	0xc2c17d53, 0x1294062e, 0x09640837, 0x3f4eaafe, 0xe4a2eff7, 0xc6250a18, 0xc2517e32, 0x1111d262, 
	0x089cf867, 0x3f6af2e3, 0xe6c8d59d, 0xc52d3d19, 0xc1eb0209, 0x0f8cfcbd, 0x07d59395, 0x3f84c8e1, 
	0xe8f77ad0, 0xc449d893, 0xc18e18a8, 0x0e05c135, 0x070de171, 0x3f9c2bfa, 0xeb2e1dbe, 0xc37b2b6a, 
	0xc13ad061, 0x0c7c5c1e, 0x0645e9af, 0x3fb11b47, 0xed6bf9d2, 0xc2c17d53, 0xc0f1360c, 0x0af10a22, 
	0x057db402, 0x3fc395f9, 0xefb047f2, 0xc21d0eb9, 0xc0b15502, 0x09640837, 0x04b54824, 0x3fd39b5a, 
	0xf1fa3ecb, 0xc18e18a8, 0xc07b371f, 0x07d59395, 0x03ecadcf, 0x3fe12acb, 0xf4491311, 0xc114ccb9, 
	0xc04ee4b9, 0x0645e9af, 0x0323ecbe, 0x3fec43c6, 0xf69bf7c9, 0xc0b15502, 0xc02c64a6, 0x04b54824, 
	0x025b0cae, 0x3ff4e5df, 0xf8f21e8f, 0xc063d406, 0xc013bc3a, 0x0323ecbe, 0x0192155f, 0x3ffb10c1, 
	0xfb4ab7dc, 0xc02c64a6, 0xc004ef3f, 0x0192155f, 0x00c90e8f, 0x3ffec42d, 0xfda4f352, 0xc00b1a21
};

const int twidTab64[4*6 + 16*6] = {
	0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x2d413ccc, 0x2d413ccc, 
	0x3b20d79e, 0x187de2a6, 0x187de2a6, 0x3b20d79e, 0x00000000, 0x40000000, 0x2d413ccc, 0x2d413ccc, 
	0xd2bec334, 0x2d413ccc, 0xd2bec334, 0x2d413ccc, 0x187de2a6, 0x3b20d79e, 0xc4df2862, 0xe7821d5a, 

	0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000, 0x3ec52f9f, 0x0c7c5c1e, 
	0x3fb11b47, 0x0645e9af, 0x3d3e82ad, 0x1294062e, 0x3b20d79e, 0x187de2a6, 0x3ec52f9f, 0x0c7c5c1e, 
	0x3536cc52, 0x238e7673, 0x3536cc52, 0x238e7673, 0x3d3e82ad, 0x1294062e, 0x2899e64a, 0x317900d6, 
	0x2d413ccc, 0x2d413ccc, 0x3b20d79e, 0x187de2a6, 0x187de2a6, 0x3b20d79e, 0x238e7673, 0x3536cc52, 
	0x387165e3, 0x1e2b5d38, 0x0645e9af, 0x3fb11b47, 0x187de2a6, 0x3b20d79e, 0x3536cc52, 0x238e7673, 
	0xf383a3e2, 0x3ec52f9f, 0x0c7c5c1e, 0x3ec52f9f, 0x317900d6, 0x2899e64a, 0xe1d4a2c8, 0x387165e3, 
	0x00000000, 0x40000000, 0x2d413ccc, 0x2d413ccc, 0xd2bec334, 0x2d413ccc, 0xf383a3e2, 0x3ec52f9f, 
	0x2899e64a, 0x317900d6, 0xc78e9a1d, 0x1e2b5d38, 0xe7821d5a, 0x3b20d79e, 0x238e7673, 0x3536cc52, 
	0xc13ad061, 0x0c7c5c1e, 0xdc71898d, 0x3536cc52, 0x1e2b5d38, 0x387165e3, 0xc04ee4b9, 0xf9ba1651, 
	0xd2bec334, 0x2d413ccc, 0x187de2a6, 0x3b20d79e, 0xc4df2862, 0xe7821d5a, 0xcac933ae, 0x238e7673, 
	0x1294062e, 0x3d3e82ad, 0xce86ff2a, 0xd76619b6, 0xc4df2862, 0x187de2a6, 0x0c7c5c1e, 0x3ec52f9f, 
	0xdc71898d, 0xcac933ae, 0xc13ad061, 0x0c7c5c1e, 0x0645e9af, 0x3fb11b47, 0xed6bf9d2, 0xc2c17d53 
};
#endif  //ARMV5E

const int ShortWindowSine[FRAME_LEN_SHORT/2] ={  
	0x00c97fff, 0x025b7ffa, 0x03ed7ff1, 0x057f7fe2, 0x07117fce, 0x08a27fb5, 0x0a337f98, 0x0bc47f75, 
	0x0d547f4e, 0x0ee47f22, 0x10737ef0, 0x12017eba, 0x138f7e7f, 0x151c7e3f, 0x16a87dfb, 0x18337db1, 
	0x19be7d63, 0x1b477d0f, 0x1cd07cb7, 0x1e577c5a, 0x1fdd7bf9, 0x21627b92, 0x22e57b27, 0x24677ab7, 
	0x25e87a42, 0x276879c9, 0x28e5794a, 0x2a6278c8, 0x2bdc7840, 0x2d5577b4, 0x2ecc7723, 0x3042768e, 
	0x31b575f4, 0x33277556, 0x349774b3, 0x3604740b, 0x3770735f, 0x38d972af, 0x3a4071fa, 0x3ba57141, 
	0x3d087083, 0x3e686fc2, 0x3fc66efb, 0x41216e31, 0x427a6d62, 0x43d16c8f, 0x45246bb8, 0x46756add, 
	0x47c469fd, 0x490f691a, 0x4a586832, 0x4b9e6747, 0x4ce16657, 0x4e216564, 0x4f5e646c, 0x50986371, 
	0x51cf6272, 0x5303616f, 0x54336068, 0x55605f5e, 0x568a5e50, 0x57b15d3e, 0x58d45c29, 0x59f45b10
};

const int LongWindowKBD[FRAME_LEN_LONG/2]={  
	0x000a7fff, 0x000e7fff, 0x00127fff, 0x00157fff, 0x00197fff, 0x001c7fff, 0x00207fff, 0x00237fff, 
	0x00267fff, 0x002a7fff, 0x002d7fff, 0x00307fff, 0x00347fff, 0x00387fff, 0x003b7fff, 0x003f7fff, 
	0x00437fff, 0x00477fff, 0x004b7fff, 0x004f7fff, 0x00537fff, 0x00577fff, 0x005b7fff, 0x00607fff, 
	0x00647fff, 0x00697fff, 0x006d7fff, 0x00727fff, 0x00777fff, 0x007c7fff, 0x00817fff, 0x00867fff, 
	0x008b7fff, 0x00917fff, 0x00967fff, 0x009c7fff, 0x00a17fff, 0x00a77fff, 0x00ad7fff, 0x00b37fff, 
	0x00b97fff, 0x00bf7fff, 0x00c67fff, 0x00cc7fff, 0x00d37fff, 0x00da7fff, 0x00e07fff, 0x00e77fff, 
	0x00ee7fff, 0x00f57fff, 0x00fd7fff, 0x01047fff, 0x010c7fff, 0x01137fff, 0x011b7fff, 0x01237fff, 
	0x012b7fff, 0x01337fff, 0x013c7ffe, 0x01447ffe, 0x014d7ffe, 0x01567ffe, 0x015f7ffe, 0x01687ffe, 
	0x01717ffe, 0x017a7ffe, 0x01837ffe, 0x018d7ffe, 0x01977ffd, 0x01a17ffd, 0x01ab7ffd, 0x01b57ffd, 
	0x01bf7ffd, 0x01ca7ffd, 0x01d47ffd, 0x01df7ffc, 0x01ea7ffc, 0x01f57ffc, 0x02007ffc, 0x020c7ffc, 
	0x02177ffc, 0x02237ffb, 0x022f7ffb, 0x023b7ffb, 0x02477ffb, 0x02537ffb, 0x02607ffa, 0x026d7ffa, 
	0x027a7ffa, 0x02877ffa, 0x02947ff9, 0x02a17ff9, 0x02af7ff9, 0x02bc7ff9, 0x02ca7ff8, 0x02d87ff8, 
	0x02e77ff8, 0x02f57ff7, 0x03047ff7, 0x03127ff7, 0x03217ff6, 0x03317ff6, 0x03407ff5, 0x034f7ff5, 
	0x035f7ff5, 0x036f7ff4, 0x037f7ff4, 0x038f7ff3, 0x03a07ff3, 0x03b07ff2, 0x03c17ff2, 0x03d27ff1, 
	0x03e37ff1, 0x03f57ff0, 0x04067ff0, 0x04187fef, 0x042a7fef, 0x043c7fee, 0x044f7fed, 0x04617fed, 
	0x04747fec, 0x04877feb, 0x049a7feb, 0x04ae7fea, 0x04c17fe9, 0x04d57fe9, 0x04e97fe8, 0x04fd7fe7, 
	0x05127fe6, 0x05277fe5, 0x053b7fe5, 0x05507fe4, 0x05667fe3, 0x057b7fe2, 0x05917fe1, 0x05a77fe0, 
	0x05bd7fdf, 0x05d37fde, 0x05ea7fdd, 0x06017fdc, 0x06187fdb, 0x062f7fda, 0x06467fd9, 0x065e7fd7, 
	0x06767fd6, 0x068e7fd5, 0x06a67fd4, 0x06bf7fd2, 0x06d87fd1, 0x06f17fd0, 0x070a7fce, 0x07237fcd, 
	0x073d7fcc, 0x07577fca, 0x07717fc9, 0x078c7fc7, 0x07a67fc5, 0x07c17fc4, 0x07dc7fc2, 0x07f77fc0, 
	0x08137fbf, 0x082f7fbd, 0x084b7fbb, 0x08677fb9, 0x08847fb7, 0x08a07fb6, 0x08bd7fb4, 0x08da7fb2, 
	0x08f87faf, 0x09167fad, 0x09347fab, 0x09527fa9, 0x09707fa7, 0x098f7fa5, 0x09ae7fa2, 0x09cd7fa0, 
	0x09ec7f9d, 0x0a0c7f9b, 0x0a2c7f98, 0x0a4c7f96, 0x0a6c7f93, 0x0a8d7f91, 0x0aae7f8e, 0x0acf7f8b, 
	0x0af07f88, 0x0b127f85, 0x0b337f82, 0x0b557f7f, 0x0b787f7c, 0x0b9a7f79, 0x0bbd7f76, 0x0be07f73, 
	0x0c047f6f, 0x0c277f6c, 0x0c4b7f69, 0x0c6f7f65, 0x0c937f61, 0x0cb87f5e, 0x0cdd7f5a, 0x0d027f56, 
	0x0d277f53, 0x0d4d7f4f, 0x0d737f4b, 0x0d997f47, 0x0dbf7f43, 0x0de67f3e, 0x0e0c7f3a, 0x0e347f36, 
	0x0e5b7f31, 0x0e837f2d, 0x0eaa7f28, 0x0ed37f24, 0x0efb7f1f, 0x0f237f1a, 0x0f4c7f15, 0x0f757f10, 
	0x0f9f7f0b, 0x0fc87f06, 0x0ff27f01, 0x101c7efb, 0x10477ef6, 0x10717ef0, 0x109c7eeb, 0x10c87ee5, 
	0x10f37edf, 0x111f7eda, 0x114a7ed4, 0x11777ece, 0x11a37ec7, 0x11d07ec1, 0x11fd7ebb, 0x122a7eb4, 
	0x12577eae, 0x12857ea7, 0x12b37ea0, 0x12e17e9a, 0x130f7e93, 0x133e7e8c, 0x136d7e84, 0x139c7e7d, 
	0x13cc7e76, 0x13fb7e6e, 0x142b7e67, 0x145b7e5f, 0x148c7e57, 0x14bc7e4f, 0x14ed7e47, 0x151e7e3f, 
	0x15507e37, 0x15817e2e, 0x15b37e26, 0x15e57e1d, 0x16187e14, 0x164a7e0b, 0x167d7e02, 0x16b07df9, 
	0x16e47df0, 0x17177de6, 0x174b7ddd, 0x177f7dd3, 0x17b37dc9, 0x17e87dbf, 0x181d7db5, 0x18527dab, 
	0x18877da1, 0x18bc7d96, 0x18f27d8c, 0x19287d81, 0x195e7d76, 0x19957d6b, 0x19cb7d60, 0x1a027d54, 
	0x1a397d49, 0x1a717d3d, 0x1aa87d31, 0x1ae07d26, 0x1b187d19, 0x1b507d0d, 0x1b897d01, 0x1bc27cf4, 
	0x1bfb7ce8, 0x1c347cdb, 0x1c6d7cce, 0x1ca77cc1, 0x1ce17cb3, 0x1d1b7ca6, 0x1d557c98, 0x1d8f7c8a, 
	0x1dca7c7c, 0x1e057c6e, 0x1e407c60, 0x1e7b7c51, 0x1eb77c43, 0x1ef37c34, 0x1f2f7c25, 0x1f6b7c16, 
	0x1fa77c06, 0x1fe47bf7, 0x20217be7, 0x205e7bd7, 0x209b7bc7, 0x20d87bb7, 0x21167ba6, 0x21547b96, 
	0x21927b85, 0x21d07b74, 0x220e7b63, 0x224d7b52, 0x228c7b40, 0x22cb7b2e, 0x230a7b1c, 0x23497b0a, 
	0x23897af8, 0x23c87ae6, 0x24087ad3, 0x24487ac0, 0x24897aad, 0x24c97a9a, 0x250a7a86, 0x254b7a73, 
	0x258c7a5f, 0x25cd7a4b, 0x260e7a36, 0x26507a22, 0x26917a0d, 0x26d379f8, 0x271579e3, 0x275779ce, 
	0x279a79b8, 0x27dc79a3, 0x281f798d, 0x28627977, 0x28a57960, 0x28e8794a, 0x292b7933, 0x296f791c, 
	0x29b27905, 0x29f678ed, 0x2a3a78d6, 0x2a7e78be, 0x2ac278a6, 0x2b07788d, 0x2b4b7875, 0x2b90785c, 
	0x2bd47843, 0x2c19782a, 0x2c5e7810, 0x2ca477f7, 0x2ce977dd, 0x2d2e77c3, 0x2d7477a8, 0x2dba778e, 
	0x2dff7773, 0x2e457758, 0x2e8b773d, 0x2ed27721, 0x2f187706, 0x2f5e76ea, 0x2fa576cd, 0x2fec76b1, 
	0x30327694, 0x30797677, 0x30c0765a, 0x3107763d, 0x314e761f, 0x31967601, 0x31dd75e3, 0x322575c5, 
	0x326c75a6, 0x32b47588, 0x32fc7569, 0x33447549, 0x338c752a, 0x33d4750a, 0x341c74ea, 0x346474ca, 
	0x34ac74a9, 0x34f57488, 0x353d7467, 0x35857446, 0x35ce7424, 0x36177403, 0x365f73e1, 0x36a873be, 
	0x36f1739c, 0x373a7379, 0x37837356, 0x37cc7333, 0x3815730f, 0x385e72ec, 0x38a772c8, 0x38f172a3, 
	0x393a727f, 0x3983725a, 0x39cd7235, 0x3a167210, 0x3a6071ea, 0x3aa971c4, 0x3af3719e, 0x3b3c7178, 
	0x3b867151, 0x3bd0712b, 0x3c197104, 0x3c6370dc, 0x3cad70b5, 0x3cf7708d, 0x3d407065, 0x3d8a703c, 
	0x3dd47014, 0x3e1e6feb, 0x3e686fc2, 0x3eb16f98, 0x3efb6f6f, 0x3f456f45, 0x3f8f6f1b, 0x3fd96ef0, 
	0x40236ec6, 0x406d6e9b, 0x40b66e70, 0x41006e44, 0x414a6e19, 0x41946ded, 0x41de6dc1, 0x42286d94, 
	0x42716d68, 0x42bb6d3b, 0x43056d0d, 0x434f6ce0, 0x43986cb2, 0x43e26c84, 0x442c6c56, 0x44756c28, 
	0x44bf6bf9, 0x45086bca, 0x45526b9b, 0x459b6b6b, 0x45e56b3c, 0x462e6b0c, 0x46786adb, 0x46c16aab, 
	0x470a6a7a, 0x47536a49, 0x479c6a18, 0x47e569e7, 0x482e69b5, 0x48776983, 0x48c06951, 0x4909691e, 
	0x495268ec, 0x499b68b9, 0x49e36885, 0x4a2c6852, 0x4a74681e, 0x4abd67ea, 0x4b0567b6, 0x4b4d6782, 
	0x4b95674d, 0x4bde6718, 0x4c2666e3, 0x4c6d66ae, 0x4cb56678, 0x4cfd6642, 0x4d45660c, 0x4d8c65d6, 
	0x4dd4659f, 0x4e1b6568, 0x4e626531, 0x4ea964fa, 0x4ef064c3, 0x4f37648b, 0x4f7e6453, 0x4fc5641b, 
	0x500b63e2, 0x505263aa, 0x50986371, 0x50df6338, 0x512562fe, 0x516b62c5, 0x51b1628b, 0x51f66251, 
	0x523c6217, 0x528161dc, 0x52c761a2, 0x530c6167, 0x5351612c, 0x539660f1, 0x53db60b5, 0x54206079, 
	0x5464603d, 0x54a96001, 0x54ed5fc5, 0x55315f88, 0x55755f4b, 0x55b95f0e, 0x55fc5ed1, 0x56405e94, 
	0x56835e56, 0x56c75e18, 0x570a5dda, 0x574d5d9c, 0x578f5d5e, 0x57d25d1f, 0x58145ce0, 0x58565ca1, 
	0x58995c62, 0x58da5c23, 0x591c5be3, 0x595e5ba4, 0x599f5b64, 0x59e05b24, 0x5a215ae3, 0x5a625aa3
};


/*
  form factor
*/
/* sqrt(((i+(1<<(FF_SQRT_BITS-2)+0.5)/2^31) */
const Word32 formfac_sqrttable[96] = {
  0x000407f8, 0x000417b9, 0x0004273f, 0x0004368c, 0x000445a1, 0x00045483, 0x00046332, 0x000471b0,
  0x00048000, 0x00048e22, 0x00049c1a, 0x0004a9e7, 0x0004b78c, 0x0004c50a, 0x0004d263, 0x0004df96,
  0x0004eca7, 0x0004f995, 0x00050662, 0x0005130e, 0x00051f9c, 0x00052c0a, 0x0005385b, 0x00054490,
  0x000550a8, 0x00055ca5, 0x00056888, 0x00057450, 0x00058000, 0x00058b96, 0x00059715, 0x0005a27c,
  0x0005adcc, 0x0005b906, 0x0005c42b, 0x0005cf39, 0x0005da33, 0x0005e519, 0x0005efea, 0x0005faa8,
  0x00060552, 0x00060fea, 0x00061a70, 0x000624e3, 0x00062f45, 0x00063996, 0x000643d5, 0x00064e04,
  0x00065823, 0x00066231, 0x00066c30, 0x0006761f, 0x00068000, 0x000689d1, 0x00069393, 0x00069d47,
  0x0006a6ed, 0x0006b085, 0x0006ba10, 0x0006c38d, 0x0006ccfc, 0x0006d65f, 0x0006dfb5, 0x0006e8fe,
  0x0006f23b, 0x0006fb6c, 0x00070490, 0x00070da9, 0x000716b6, 0x00071fb8, 0x000728ae, 0x00073199,
  0x00073a79, 0x0007434e, 0x00074c19, 0x000754d9, 0x00075d8e, 0x0007663a, 0x00076edb, 0x00077772,
  0x00078000, 0x00078883, 0x000790fd, 0x0007996e, 0x0007a1d5, 0x0007aa33, 0x0007b288, 0x0007bad4,
  0x0007c318, 0x0007cb52, 0x0007d384, 0x0007dbad, 0x0007e3ce, 0x0007ebe6, 0x0007f3f6, 0x0007fbfe
};



/*!
  \name    quantizer and inverse quantizer tables

  \brief   these tables are used for the non
           linear quantizer and inverse quantizer
           
*/
const Word32 mTab_3_4[512] = {
	0x4c1bf829, 0x4c3880de, 0x4c550603, 0x4c71879c, 
	0x4c8e05aa, 0x4caa8030, 0x4cc6f72f, 0x4ce36aab, 
	0x4cffdaa4, 0x4d1c471d, 0x4d38b019, 0x4d55159a, 
	0x4d7177a1, 0x4d8dd631, 0x4daa314b, 0x4dc688f3, 
	0x4de2dd2a, 0x4dff2df2, 0x4e1b7b4d, 0x4e37c53d, 
	0x4e540bc5, 0x4e704ee6, 0x4e8c8ea3, 0x4ea8cafd, 
	0x4ec503f7, 0x4ee13992, 0x4efd6bd0, 0x4f199ab4, 
	0x4f35c640, 0x4f51ee75, 0x4f6e1356, 0x4f8a34e4, 
	0x4fa65321, 0x4fc26e10, 0x4fde85b2, 0x4ffa9a0a, 
	0x5016ab18, 0x5032b8e0, 0x504ec362, 0x506acaa1, 
	0x5086cea0, 0x50a2cf5e, 0x50becce0, 0x50dac725, 
	0x50f6be31, 0x5112b205, 0x512ea2a3, 0x514a900d, 
	0x51667a45, 0x5182614c, 0x519e4524, 0x51ba25cf, 
	0x51d60350, 0x51f1dda7, 0x520db4d6, 0x522988e0, 
	0x524559c6, 0x52612789, 0x527cf22d, 0x5298b9b1, 
	0x52b47e19, 0x52d03f65, 0x52ebfd98, 0x5307b8b4, 
	0x532370b9, 0x533f25aa, 0x535ad789, 0x53768656, 
	0x53923215, 0x53addac6, 0x53c9806b, 0x53e52306, 
	0x5400c298, 0x541c5f24, 0x5437f8ab, 0x54538f2e, 
	0x546f22af, 0x548ab330, 0x54a640b3, 0x54c1cb38, 
	0x54dd52c2, 0x54f8d753, 0x551458eb, 0x552fd78d, 
	0x554b5339, 0x5566cbf3, 0x558241bb, 0x559db492, 
	0x55b9247b, 0x55d49177, 0x55effb87, 0x560b62ad, 
	0x5626c6eb, 0x56422842, 0x565d86b4, 0x5678e242, 
	0x56943aee, 0x56af90b9, 0x56cae3a4, 0x56e633b2, 
	0x570180e4, 0x571ccb3b, 0x573812b8, 0x5753575e, 
	0x576e992e, 0x5789d829, 0x57a51450, 0x57c04da6, 
	0x57db842b, 0x57f6b7e1, 0x5811e8c9, 0x582d16e6, 
	0x58484238, 0x58636ac0, 0x587e9081, 0x5899b37c, 
	0x58b4d3b1, 0x58cff123, 0x58eb0bd3, 0x590623c2, 
	0x592138f2, 0x593c4b63, 0x59575b19, 0x59726812, 
	0x598d7253, 0x59a879da, 0x59c37eab, 0x59de80c6, 
	0x59f9802d, 0x5a147ce0, 0x5a2f76e2, 0x5a4a6e34, 
	0x5a6562d6, 0x5a8054cb, 0x5a9b4414, 0x5ab630b2, 
	0x5ad11aa6, 0x5aec01f1, 0x5b06e696, 0x5b21c895, 
	0x5b3ca7ef, 0x5b5784a6, 0x5b725ebc, 0x5b8d3631, 
	0x5ba80b06, 0x5bc2dd3e, 0x5bddacd9, 0x5bf879d8, 
	0x5c13443d, 0x5c2e0c09, 0x5c48d13e, 0x5c6393dc, 
	0x5c7e53e5, 0x5c99115a, 0x5cb3cc3c, 0x5cce848d, 
	0x5ce93a4e, 0x5d03ed80, 0x5d1e9e24, 0x5d394c3b, 
	0x5d53f7c7, 0x5d6ea0c9, 0x5d894742, 0x5da3eb33, 
	0x5dbe8c9e, 0x5dd92b84, 0x5df3c7e5, 0x5e0e61c3, 
	0x5e28f920, 0x5e438dfc, 0x5e5e2059, 0x5e78b037, 
	0x5e933d99, 0x5eadc87e, 0x5ec850e9, 0x5ee2d6da, 
	0x5efd5a53, 0x5f17db54, 0x5f3259e0, 0x5f4cd5f6, 
	0x5f674f99, 0x5f81c6c8, 0x5f9c3b87, 0x5fb6add4, 
	0x5fd11db3, 0x5feb8b23, 0x6005f626, 0x60205ebd, 
	0x603ac4e9, 0x605528ac, 0x606f8a05, 0x6089e8f7, 
	0x60a44583, 0x60be9fa9, 0x60d8f76b, 0x60f34cca, 
	0x610d9fc7, 0x6127f062, 0x61423e9e, 0x615c8a7a, 
	0x6176d3f9, 0x61911b1b, 0x61ab5fe1, 0x61c5a24d, 
	0x61dfe25f, 0x61fa2018, 0x62145b7a, 0x622e9485, 
	0x6248cb3b, 0x6262ff9d, 0x627d31ab, 0x62976167, 
	0x62b18ed1, 0x62cbb9eb, 0x62e5e2b6, 0x63000933, 
	0x631a2d62, 0x63344f45, 0x634e6edd, 0x63688c2b, 
	0x6382a730, 0x639cbfec, 0x63b6d661, 0x63d0ea90, 
	0x63eafc7a, 0x64050c1f, 0x641f1982, 0x643924a2, 
	0x64532d80, 0x646d341f, 0x6487387e, 0x64a13a9e, 
	0x64bb3a81, 0x64d53828, 0x64ef3393, 0x65092cc4, 
	0x652323bb, 0x653d1879, 0x65570b00, 0x6570fb50, 
	0x658ae96b, 0x65a4d550, 0x65bebf01, 0x65d8a680, 
	0x65f28bcc, 0x660c6ee8, 0x66264fd3, 0x66402e8f, 
	0x665a0b1c, 0x6673e57d, 0x668dbdb0, 0x66a793b8, 
	0x66c16795, 0x66db3949, 0x66f508d4, 0x670ed636, 
	0x6728a172, 0x67426a87, 0x675c3177, 0x6775f643, 
	0x678fb8eb, 0x67a97971, 0x67c337d5, 0x67dcf418, 
	0x67f6ae3b, 0x6810663f, 0x682a1c25, 0x6843cfed, 
	0x685d8199, 0x68773129, 0x6890de9f, 0x68aa89fa, 
	0x68c4333d, 0x68ddda67, 0x68f77f7a, 0x69112277, 
	0x692ac35e, 0x69446230, 0x695dfeee, 0x6977999a, 
	0x69913232, 0x69aac8ba, 0x69c45d31, 0x69ddef98, 
	0x69f77ff0, 0x6a110e3a, 0x6a2a9a77, 0x6a4424a8, 
	0x6a5daccc, 0x6a7732e6, 0x6a90b6f6, 0x6aaa38fd, 
	0x6ac3b8fb, 0x6add36f2, 0x6af6b2e2, 0x6b102ccd, 
	0x6b29a4b2, 0x6b431a92, 0x6b5c8e6f, 0x6b76004a, 
	0x6b8f7022, 0x6ba8ddf9, 0x6bc249d0, 0x6bdbb3a7, 
	0x6bf51b80, 0x6c0e815a, 0x6c27e537, 0x6c414718, 
	0x6c5aa6fd, 0x6c7404e7, 0x6c8d60d7, 0x6ca6bace, 
	0x6cc012cc, 0x6cd968d2, 0x6cf2bce1, 0x6d0c0ef9, 
	0x6d255f1d, 0x6d3ead4b, 0x6d57f985, 0x6d7143cc, 
	0x6d8a8c21, 0x6da3d283, 0x6dbd16f5, 0x6dd65976, 
	0x6def9a08, 0x6e08d8ab, 0x6e221560, 0x6e3b5027, 
	0x6e548902, 0x6e6dbff1, 0x6e86f4f5, 0x6ea0280e, 
	0x6eb9593e, 0x6ed28885, 0x6eebb5e3, 0x6f04e15a, 
	0x6f1e0aea, 0x6f373294, 0x6f505859, 0x6f697c39, 
	0x6f829e35, 0x6f9bbe4e, 0x6fb4dc85, 0x6fcdf8d9, 
	0x6fe7134d, 0x70002be0, 0x70194293, 0x70325767, 
	0x704b6a5d, 0x70647b76, 0x707d8ab1, 0x70969811, 
	0x70afa394, 0x70c8ad3d, 0x70e1b50c, 0x70fabb01, 
	0x7113bf1d, 0x712cc161, 0x7145c1ce, 0x715ec064, 
	0x7177bd24, 0x7190b80f, 0x71a9b124, 0x71c2a866, 
	0x71db9dd4, 0x71f49170, 0x720d8339, 0x72267331, 
	0x723f6159, 0x72584db0, 0x72713838, 0x728a20f1, 
	0x72a307db, 0x72bbecf9, 0x72d4d049, 0x72edb1ce, 
	0x73069187, 0x731f6f75, 0x73384b98, 0x735125f3, 
	0x7369fe84, 0x7382d54d, 0x739baa4e, 0x73b47d89, 
	0x73cd4efd, 0x73e61eab, 0x73feec94, 0x7417b8b8, 
	0x74308319, 0x74494bb6, 0x74621291, 0x747ad7aa, 
	0x74939b02, 0x74ac5c98, 0x74c51c6f, 0x74ddda86, 
	0x74f696de, 0x750f5178, 0x75280a54, 0x7540c174, 
	0x755976d7, 0x75722a7e, 0x758adc69, 0x75a38c9b, 
	0x75bc3b12, 0x75d4e7cf, 0x75ed92d4, 0x76063c21, 
	0x761ee3b6, 0x76378994, 0x76502dbc, 0x7668d02e, 
	0x768170eb, 0x769a0ff3, 0x76b2ad47, 0x76cb48e7, 
	0x76e3e2d5, 0x76fc7b10, 0x7715119a, 0x772da673, 
	0x7746399b, 0x775ecb13, 0x77775adc, 0x778fe8f6, 
	0x77a87561, 0x77c1001f, 0x77d98930, 0x77f21095, 
	0x780a964d, 0x78231a5b, 0x783b9cbd, 0x78541d75, 
	0x786c9c84, 0x788519e9, 0x789d95a6, 0x78b60fbb, 
	0x78ce8828, 0x78e6feef, 0x78ff740f, 0x7917e78a, 
	0x7930595f, 0x7948c990, 0x7961381d, 0x7979a506, 
	0x7992104c, 0x79aa79f0, 0x79c2e1f1, 0x79db4852, 
	0x79f3ad11, 0x7a0c1031, 0x7a2471b0, 0x7a3cd191, 
	0x7a552fd3, 0x7a6d8c76, 0x7a85e77d, 0x7a9e40e6, 
	0x7ab698b2, 0x7aceeee3, 0x7ae74378, 0x7aff9673, 
	0x7b17e7d2, 0x7b303799, 0x7b4885c5, 0x7b60d259, 
	0x7b791d55, 0x7b9166b9, 0x7ba9ae86, 0x7bc1f4bc, 
	0x7bda395c, 0x7bf27c66, 0x7c0abddb, 0x7c22fdbb, 
	0x7c3b3c07, 0x7c5378c0, 0x7c6bb3e5, 0x7c83ed78, 
	0x7c9c2579, 0x7cb45be9, 0x7ccc90c7, 0x7ce4c414, 
	0x7cfcf5d2, 0x7d152600, 0x7d2d549f, 0x7d4581b0, 
	0x7d5dad32, 0x7d75d727, 0x7d8dff8f, 0x7da6266a, 
	0x7dbe4bba, 0x7dd66f7d, 0x7dee91b6, 0x7e06b264, 
	0x7e1ed188, 0x7e36ef22, 0x7e4f0b34, 0x7e6725bd, 
	0x7e7f3ebd, 0x7e975636, 0x7eaf6c28, 0x7ec78093, 
	0x7edf9378, 0x7ef7a4d7, 0x7f0fb4b1, 0x7f27c307, 
	0x7f3fcfd8, 0x7f57db25, 0x7f6fe4ef, 0x7f87ed36, 
	0x7f9ff3fb, 0x7fb7f93e, 0x7fcffcff, 0x7fe7ff40
};

const Word32 mTab_4_3[512]={
	0x32cbfd4a, 0x32eddd70, 0x330fc339, 0x3331aea3, 
	0x33539fac, 0x33759652, 0x33979294, 0x33b99470, 
	0x33db9be4, 0x33fda8ed, 0x341fbb8b, 0x3441d3bb, 
	0x3463f17c, 0x348614cc, 0x34a83da8, 0x34ca6c10, 
	0x34eca001, 0x350ed979, 0x35311877, 0x35535cfa, 
	0x3575a6fe, 0x3597f683, 0x35ba4b87, 0x35dca607, 
	0x35ff0603, 0x36216b78, 0x3643d665, 0x366646c7, 
	0x3688bc9e, 0x36ab37e8, 0x36cdb8a2, 0x36f03ecb, 
	0x3712ca62, 0x37355b64, 0x3757f1d1, 0x377a8da5, 
	0x379d2ee0, 0x37bfd580, 0x37e28184, 0x380532e8, 
	0x3827e9ad, 0x384aa5d0, 0x386d674f, 0x38902e2a, 
	0x38b2fa5d, 0x38d5cbe9, 0x38f8a2ca, 0x391b7eff, 
	0x393e6088, 0x39614761, 0x3984338a, 0x39a72501, 
	0x39ca1bc4, 0x39ed17d1, 0x3a101928, 0x3a331fc6, 
	0x3a562baa, 0x3a793cd2, 0x3a9c533d, 0x3abf6ee9, 
	0x3ae28fd5, 0x3b05b5ff, 0x3b28e165, 0x3b4c1206, 
	0x3b6f47e0, 0x3b9282f2, 0x3bb5c33a, 0x3bd908b7, 
	0x3bfc5368, 0x3c1fa349, 0x3c42f85b, 0x3c66529c, 
	0x3c89b209, 0x3cad16a2, 0x3cd08065, 0x3cf3ef51, 
	0x3d176364, 0x3d3adc9c, 0x3d5e5af8, 0x3d81de77, 
	0x3da56717, 0x3dc8f4d6, 0x3dec87b4, 0x3e101fae, 
	0x3e33bcc3, 0x3e575ef2, 0x3e7b063a, 0x3e9eb298, 
	0x3ec2640c, 0x3ee61a93, 0x3f09d62d, 0x3f2d96d8, 
	0x3f515c93, 0x3f75275b, 0x3f98f731, 0x3fbccc11, 
	0x3fe0a5fc, 0x400484ef, 0x402868ea, 0x404c51e9, 
	0x40703fee, 0x409432f5, 0x40b82afd, 0x40dc2806, 
	0x41002a0d, 0x41243111, 0x41483d12, 0x416c4e0d, 
	0x41906401, 0x41b47eed, 0x41d89ecf, 0x41fcc3a7, 
	0x4220ed72, 0x42451c30, 0x42694fde, 0x428d887d, 
	0x42b1c609, 0x42d60883, 0x42fa4fe8, 0x431e9c37, 
	0x4342ed70, 0x43674390, 0x438b9e96, 0x43affe82, 
	0x43d46351, 0x43f8cd03, 0x441d3b95, 0x4441af08, 
	0x44662758, 0x448aa487, 0x44af2690, 0x44d3ad75, 
	0x44f83933, 0x451cc9c8, 0x45415f35, 0x4565f977, 
	0x458a988d, 0x45af3c76, 0x45d3e531, 0x45f892bc, 
	0x461d4516, 0x4641fc3e, 0x4666b832, 0x468b78f2, 
	0x46b03e7c, 0x46d508cf, 0x46f9d7e9, 0x471eabca, 
	0x47438470, 0x476861d9, 0x478d4406, 0x47b22af3, 
	0x47d716a1, 0x47fc070e, 0x4820fc39, 0x4845f620, 
	0x486af4c3, 0x488ff820, 0x48b50035, 0x48da0d03, 
	0x48ff1e87, 0x492434c0, 0x49494fad, 0x496e6f4d, 
	0x4993939f, 0x49b8bca2, 0x49ddea54, 0x4a031cb4, 
	0x4a2853c1, 0x4a4d8f7a, 0x4a72cfde, 0x4a9814eb, 
	0x4abd5ea1, 0x4ae2acfd, 0x4b080000, 0x4b2d57a8, 
	0x4b52b3f3, 0x4b7814e1, 0x4b9d7a70, 0x4bc2e49f, 
	0x4be8536e, 0x4c0dc6db, 0x4c333ee4, 0x4c58bb89, 
	0x4c7e3cc9, 0x4ca3c2a2, 0x4cc94d14, 0x4ceedc1c, 
	0x4d146fbb, 0x4d3a07ef, 0x4d5fa4b6, 0x4d854611, 
	0x4daaebfd, 0x4dd09679, 0x4df64585, 0x4e1bf91f, 
	0x4e41b146, 0x4e676dfa, 0x4e8d2f38, 0x4eb2f501, 
	0x4ed8bf52, 0x4efe8e2b, 0x4f24618a, 0x4f4a3970, 
	0x4f7015d9, 0x4f95f6c6, 0x4fbbdc36, 0x4fe1c626, 
	0x5007b497, 0x502da787, 0x50539ef5, 0x50799ae1, 
	0x509f9b48, 0x50c5a02a, 0x50eba985, 0x5111b75a, 
	0x5137c9a6, 0x515de069, 0x5183fba2, 0x51aa1b4f, 
	0x51d03f70, 0x51f66803, 0x521c9508, 0x5242c67d, 
	0x5268fc62, 0x528f36b5, 0x52b57575, 0x52dbb8a2, 
	0x5302003a, 0x53284c3c, 0x534e9ca8, 0x5374f17c, 
	0x539b4ab7, 0x53c1a858, 0x53e80a5f, 0x540e70ca, 
	0x5434db98, 0x545b4ac8, 0x5481be5a, 0x54a8364b, 
	0x54ceb29c, 0x54f5334c, 0x551bb858, 0x554241c1, 
	0x5568cf85, 0x558f61a3, 0x55b5f81b, 0x55dc92eb, 
	0x56033212, 0x5629d590, 0x56507d63, 0x5677298a, 
	0x569dda05, 0x56c48ed3, 0x56eb47f2, 0x57120562, 
	0x5738c721, 0x575f8d2f, 0x5786578a, 0x57ad2633, 
	0x57d3f927, 0x57fad066, 0x5821abef, 0x58488bc0, 
	0x586f6fda, 0x5896583b, 0x58bd44e2, 0x58e435ce, 
	0x590b2aff, 0x59322473, 0x59592229, 0x59802420, 
	0x59a72a59, 0x59ce34d0, 0x59f54387, 0x5a1c567b, 
	0x5a436dac, 0x5a6a8919, 0x5a91a8c1, 0x5ab8cca3, 
	0x5adff4be, 0x5b072111, 0x5b2e519c, 0x5b55865e, 
	0x5b7cbf54, 0x5ba3fc80, 0x5bcb3ddf, 0x5bf28371, 
	0x5c19cd35, 0x5c411b2a, 0x5c686d4f, 0x5c8fc3a4, 
	0x5cb71e27, 0x5cde7cd7, 0x5d05dfb4, 0x5d2d46bd, 
	0x5d54b1f0, 0x5d7c214e, 0x5da394d4, 0x5dcb0c83, 
	0x5df28859, 0x5e1a0856, 0x5e418c78, 0x5e6914be, 
	0x5e90a129, 0x5eb831b7, 0x5edfc667, 0x5f075f38, 
	0x5f2efc29, 0x5f569d3a, 0x5f7e426a, 0x5fa5ebb7, 
	0x5fcd9921, 0x5ff54aa8, 0x601d004a, 0x6044ba06, 
	0x606c77dc, 0x609439ca, 0x60bbffd0, 0x60e3c9ee, 
	0x610b9821, 0x61336a6a, 0x615b40c8, 0x61831b39, 
	0x61aaf9bd, 0x61d2dc53, 0x61fac2fa, 0x6222adb2, 
	0x624a9c79, 0x62728f4f, 0x629a8633, 0x62c28123, 
	0x62ea8020, 0x63128329, 0x633a8a3c, 0x63629559, 
	0x638aa47f, 0x63b2b7ad, 0x63dacee2, 0x6402ea1e, 
	0x642b0960, 0x64532ca6, 0x647b53f1, 0x64a37f3f, 
	0x64cbae8f, 0x64f3e1e2, 0x651c1935, 0x65445488, 
	0x656c93db, 0x6594d72c, 0x65bd1e7b, 0x65e569c7, 
	0x660db90f, 0x66360c53, 0x665e6391, 0x6686bec9, 
	0x66af1dfa, 0x66d78123, 0x66ffe844, 0x6728535b, 
	0x6750c268, 0x6779356b, 0x67a1ac62, 0x67ca274c, 
	0x67f2a629, 0x681b28f9, 0x6843afb9, 0x686c3a6a, 
	0x6894c90b, 0x68bd5b9b, 0x68e5f219, 0x690e8c84, 
	0x69372add, 0x695fcd21, 0x69887350, 0x69b11d6a, 
	0x69d9cb6d, 0x6a027d5a, 0x6a2b332f, 0x6a53eceb, 
	0x6a7caa8d, 0x6aa56c16, 0x6ace3184, 0x6af6fad6, 
	0x6b1fc80c, 0x6b489925, 0x6b716e20, 0x6b9a46fd, 
	0x6bc323bb, 0x6bec0458, 0x6c14e8d5, 0x6c3dd130, 
	0x6c66bd69, 0x6c8fad80, 0x6cb8a172, 0x6ce19940, 
	0x6d0a94e9, 0x6d33946d, 0x6d5c97ca, 0x6d859eff, 
	0x6daeaa0d, 0x6dd7b8f1, 0x6e00cbad, 0x6e29e23e, 
	0x6e52fca4, 0x6e7c1adf, 0x6ea53cee, 0x6ece62cf, 
	0x6ef78c83, 0x6f20ba09, 0x6f49eb5f, 0x6f732085, 
	0x6f9c597b, 0x6fc59640, 0x6feed6d3, 0x70181b33, 
	0x70416360, 0x706aaf59, 0x7093ff1d, 0x70bd52ab, 
	0x70e6aa04, 0x71100525, 0x7139640f, 0x7162c6c1, 
	0x718c2d3a, 0x71b5977a, 0x71df057f, 0x72087749, 
	0x7231ecd8, 0x725b662a, 0x7284e33f, 0x72ae6417, 
	0x72d7e8b0, 0x7301710a, 0x732afd24, 0x73548cfe, 
	0x737e2097, 0x73a7b7ee, 0x73d15303, 0x73faf1d5, 
	0x74249462, 0x744e3aac, 0x7477e4b0, 0x74a1926e, 
	0x74cb43e6, 0x74f4f917, 0x751eb201, 0x75486ea1, 
	0x75722ef9, 0x759bf307, 0x75c5baca, 0x75ef8642, 
	0x7619556f, 0x7643284f, 0x766cfee2, 0x7696d928, 
	0x76c0b71f, 0x76ea98c7, 0x77147e20, 0x773e6728, 
	0x776853df, 0x77924445, 0x77bc3858, 0x77e63019, 
	0x78102b85, 0x783a2a9e, 0x78642d62, 0x788e33d1, 
	0x78b83de9, 0x78e24bab, 0x790c5d15, 0x79367228, 
	0x79608ae1, 0x798aa742, 0x79b4c748, 0x79deeaf4, 
	0x7a091245, 0x7a333d3a, 0x7a5d6bd2, 0x7a879e0e, 
	0x7ab1d3ec, 0x7adc0d6b, 0x7b064a8c, 0x7b308b4d, 
	0x7b5acfae, 0x7b8517ae, 0x7baf634c, 0x7bd9b289, 
	0x7c040563, 0x7c2e5bda, 0x7c58b5ec, 0x7c83139b, 
	0x7cad74e4, 0x7cd7d9c7, 0x7d024244, 0x7d2cae5a, 
	0x7d571e09, 0x7d81914f, 0x7dac082d, 0x7dd682a1, 
	0x7e0100ac, 0x7e2b824b, 0x7e560780, 0x7e809048, 
	0x7eab1ca5, 0x7ed5ac94, 0x7f004015, 0x7f2ad729, 
	0x7f5571cd, 0x7f801003, 0x7faab1c8, 0x7fd5571d
};


const Word32 invSBF[24] = {
  0x3FFD34FC, 0x2D3F8000, 0x24F18C7E, 0x1FFE9A7E, 
  0x1C9DF10C, 0x1A1F851A, 0x182FE994, 0x169FC000, 
  0x15542AAA, 0x143C31C2, 0x134B1B6C, 0x127920BE, 
  0x11BF2FCC, 0x111A749E, 0x1085FC42, 0x0FFFA7BE, 
  0x0F855818, 0x0F14EE56, 0x0EAE6A78, 0x0E4EF886, 
  0x0DF69880, 0x0DA49568, 0x0D578542, 0x0D101D0C
};

const Word16 pow2tominusNover16[17] = {
  0x7fff, 0x7a93, 0x7560, 0x7066,
  0x6ba2, 0x6712, 0x62b4, 0x5e84,
  0x5a82, 0x56ac, 0x52ff, 0x4f7b,
  0x4c1c, 0x48e2, 0x45cb, 0x42d5,
  0x4000
};

const Word16 sideInfoTabLong[MAX_SFB_LONG + 1] = {
  9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 9, 9, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 
  14, 14, 14
};

const Word16 sideInfoTabShort[MAX_SFB_SHORT + 1] = {
  7, 7, 7, 7, 7, 7, 7, 10, 10, 
  10, 10, 10, 10, 10, 13, 13
};

Word32 specExpMantTableComb_enc[4][14] =
{
  {0x40000000,  0x50a28be6,  0x6597fa95,  0x40000000, 
   0x50a28be6,  0x6597fa95,  0x40000000,  0x50a28be6, 
   0x6597fa95,  0x40000000,  0x50a28be6,  0x6597fa95, 
   0x40000000,  0x50a28be6}, 

  {0x4c1bf829,  0x5fe4435e,  0x78d0df9c,  0x4c1bf829, 
   0x5fe4435e,  0x78d0df9c,  0x4c1bf829,  0x5fe4435e, 
   0x78d0df9c,  0x4c1bf829,  0x5fe4435e,  0x78d0df9c, 
   0x4c1bf829,  0x5fe4435e}, 

  {0x5a82799a,  0x7208f81d,  0x47d66b0f,  0x5a82799a, 
   0x7208f81d,  0x47d66b0f,  0x5a82799a,  0x7208f81d, 
   0x47d66b0f,  0x5a82799a,  0x7208f81d,  0x47d66b0f, 
   0x5a82799a,  0x7208f81d}, 

  {0x6ba27e65,  0x43ce3e4b,  0x556e0424,  0x6ba27e65, 
   0x43ce3e4b,  0x556e0424,  0x6ba27e65,  0x43ce3e4b, 
   0x556e0424,  0x6ba27e65,  0x43ce3e4b,  0x556e0424, 
   0x6ba27e65,  0x43ce3e4b}
};

const  UWord8 specExpTableComb_enc[4][14] =
{
  {1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18},
  {1, 2, 3, 5, 6, 7, 9, 10, 11, 13, 14, 15, 17, 18},
  {1, 2, 4, 5, 6, 8, 9, 10, 12, 13, 14, 16, 17, 18},
  {1, 3, 4, 5, 7, 8, 9, 11, 12, 13, 15, 16, 17, 19}
};

const Word16 quantBorders[4][4] = {
  /* pow(1.0-0.4054, 4/3)/16 * pow(2, (0..3)/4) */
  {0x0400, 0x0ee7, 0x1c86, 0x2c0d},
  /* pow(2.0-0.4054, 4/3)/16 * pow(2, (0..3)/4) */
  {0x04c2, 0x11b9, 0x21eb, 0x3463},
  /* pow(3.0-0.4054, 4/3)/16 * pow(2, (0..3)/4) */
  {0x05a8, 0x1514, 0x2856, 0x3e4c},
  /* pow(4.0-0.4054, 4/3)/16 * pow(2, (0..3)/4) */
  {0x06ba, 0x1911, 0x2ff8, 0x4a16},
};

const Word16 quantRecon[4][3] = {
  {0x0800, 0x1429, 0x229d},
  {0x0983, 0x17f9, 0x292a},
  {0x0b50, 0x1c82, 0x30f4},
  {0x0d74, 0x21e7, 0x3a37},
};

const int sampRateTab[NUM_SAMPLE_RATES] = {
    96000, 88200, 64000, 48000, 44100, 32000, 
	24000, 22050, 16000, 12000, 11025,  8000
};


const int	rates[8] = {		
	160, 240, 320, 400, 480, 560, 640, 0
};

const int BandwithCoefTab[8][NUM_SAMPLE_RATES] = {
	{ 7000,  7000,  4666,  3500,  3500,  2800,  2800,  2800,  2800,  2000,  2000,  2000},
	{12000, 12000,  8000,  6000,  6000,  6000,  4000,  4000,  4000,  3000,  3000,  3000},
	{18000, 18000, 12000,  9000,  9000,  9000,  7000,  7000,  7000,  5000,  5000,  5000},
	{20000, 20000, 16000, 12000, 12000, 12000,  9000,  9000,  9000,  6000,  6000,  6000},
	{20000, 20000, 18666, 14000, 14000, 14000, 10000, 10000, 10000,  7000,  7000,  7000},
	{20000, 20000, 20000, 16000, 16000, 16000, 12000, 12000, 12000,  8000,  8000,  8000},
	{20000, 20000, 20000, 20000, 20000, 20000, 15000, 15000, 15000, 10000, 10000, 10000},
	{20000, 20000, 20000, 20000, 20000, 20000, 20000, 20000, 20000, 20000, 20000, 20000}
};


/* total number of scale factor bands in one window */
const UWord8 sfBandTotalShort[NUM_SAMPLE_RATES] = {
    12, 12, 12, 14, 14, 14, 15, 15, 15, 15, 15, 15
};

const UWord8 sfBandTotalLong[NUM_SAMPLE_RATES] = {
    41, 41, 47, 49, 49, 51, 47, 47, 43, 43, 43, 40
};

/* scale factor band tables */
const int sfBandTabShortOffset[NUM_SAMPLE_RATES] = {0, 0, 0, 13, 13, 13, 28, 28, 44, 44, 44, 60};

const short sfBandTabShort[76] = {
	/* short block 64, 88, 96 kHz [13]  */
	0,   4,   8,  12,  16,  20,  24,  32,  40,  48,  64,  92, 128,

	/* short block 32, 44, 48 kHz [15]  */
	0,   4,   8,  12,  16,  20,  28,  36,  44,  56,  68,  80,  96, 112, 128,

	/* short block 22, 24 kHz [16]  */
	0,   4,   8,  12,  16,  20,  24,  28,  36,  44,  52,  64,  76,  92, 108, 128,

	/* short block 11, 12, 16 kHz [16] */
	0,   4,   8,  12,  16,  20,  24,  28,  32,  40,  48,  60,  72,  88, 108, 128,

	/* short block 8 kHz [16] */
	0,   4,   8,  12,  16,  20,  24,  28,  36,  44,  52,  60,  72,  88, 108, 128
};

const int sfBandTabLongOffset[NUM_SAMPLE_RATES] = {0, 0, 42, 90, 90, 140, 192, 192, 240, 240, 240, 284};

const short sfBandTabLong[325] = {
	/* long block 88, 96 kHz [42]  */
	  0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  44,  48,   52,
	 56,  64,  72,  80,  88,  96, 108, 120, 132, 144, 156, 172, 188,  212,
	240, 276, 320, 384, 448, 512, 576, 640, 704, 768, 832, 896, 960, 1024,

	/* long block 64 kHz [48]  */
	  0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  44,  48,  52,  56,   64,
	 72,  80,  88, 100, 112, 124, 140, 156, 172, 192, 216, 240, 268, 304, 344,  384,
	424, 464, 504, 544, 584, 624, 664, 704, 744, 784, 824, 864, 904, 944, 984, 1024,

	/* long block 44, 48 kHz [50] */
	  0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  48,  56,  64,  72,   80,  88,
	 96, 108, 120, 132, 144, 160, 176, 196, 216, 240, 264, 292, 320, 352, 384,  416, 448,
	480, 512, 544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 1024,

	/* long block 32 kHz [52] */
	  0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  48,  56,  64,  72,   80,  88,  96,
	108, 120, 132, 144, 160, 176, 196, 216, 240, 264, 292, 320, 352, 384, 416,  448, 480, 512,
	544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 960, 992, 1024,

	/* long block 22, 24 kHz [48] */
	  0,   4,   8,  12,  16,  20,  24,  28,  32,  36,  40,  44,  52,  60,  68,   76,
	 84,  92, 100, 108, 116, 124, 136, 148, 160, 172, 188, 204, 220, 240, 260,  284,
	308, 336, 364, 396, 432, 468, 508, 552, 600, 652, 704, 768, 832, 896, 960, 1024,

	/* long block 11, 12, 16 kHz [44] */
	  0,   8,  16,  24,  32,  40,  48,  56,  64,  72,  80,  88, 100,  112, 124,
	136, 148, 160, 172, 184, 196, 212, 228, 244, 260, 280, 300, 320,  344, 368,
	396, 424, 456, 492, 532, 572, 616, 664, 716, 772, 832, 896, 960, 1024,

	/* long block 8 kHz [41]  */
	  0,  12,  24,  36,  48,  60,  72,  84,  96, 108, 120, 132,  144, 156,
	172, 188, 204, 220, 236, 252, 268, 288, 308, 328, 348, 372,  396, 420,
	448, 476, 508, 544, 580, 620, 664, 712, 764, 820, 880, 944, 1024
};

/*
  these tables are used only for counting and 
  are stored in packed format
*/
const UWord16 huff_ltab1_2[3][3][3][3]=
{
  {
    {
      {0x0b09,0x0907,0x0b09},
      {0x0a08,0x0706,0x0a08},
      {0x0b09,0x0908,0x0b09}
    },
    {
      {0x0a08,0x0706,0x0a07},
      {0x0706,0x0505,0x0706},
      {0x0907,0x0706,0x0a08}
    },
    {
      {0x0b09,0x0907,0x0b08},
      {0x0908,0x0706,0x0908},
      {0x0b09,0x0907,0x0b09}
    }
  },
  {
    {
      {0x0908,0x0706,0x0907},
      {0x0706,0x0505,0x0706},
      {0x0907,0x0706,0x0908}
    },
    {
      {0x0706,0x0505,0x0706},
      {0x0505,0x0103,0x0505},
      {0x0706,0x0505,0x0706}
    },
    {
      {0x0908,0x0706,0x0907},
      {0x0706,0x0505,0x0706},
      {0x0908,0x0706,0x0908}
    }
  },
  {
    {
      {0x0b09,0x0907,0x0b09},
      {0x0908,0x0706,0x0908},
      {0x0b08,0x0907,0x0b09}
    },
    {
      {0x0a08,0x0706,0x0907},
      {0x0706,0x0504,0x0706},
      {0x0908,0x0706,0x0a07}
    },
    {
      {0x0b09,0x0907,0x0b09},
      {0x0a07,0x0706,0x0908},
      {0x0b09,0x0907,0x0b09}
    }
  }
};


const UWord16 huff_ltab3_4[3][3][3][3]=
{
  {
    {
      {0x0104,0x0405,0x0808},
      {0x0405,0x0504,0x0808},
      {0x0909,0x0908,0x0a0b}
    },
    {
      {0x0405,0x0605,0x0908},
      {0x0605,0x0604,0x0908},
      {0x0908,0x0907,0x0a0a}
    },
    {
      {0x0909,0x0a08,0x0d0b},
      {0x0908,0x0908,0x0b0a},
      {0x0b0b,0x0a0a,0x0c0b}
    }
  },
  {
    {
      {0x0404,0x0605,0x0a08},
      {0x0604,0x0704,0x0a08},
      {0x0a08,0x0a08,0x0c0a}
    },
    {
      {0x0504,0x0704,0x0b08},
      {0x0604,0x0704,0x0a07},
      {0x0908,0x0907,0x0b09}
    },
    {
      {0x0908,0x0a08,0x0d0a},
      {0x0807,0x0907,0x0c09},
      {0x0a0a,0x0b09,0x0c0a}
    }
  },
  {
    {
      {0x0808,0x0a08,0x0f0b},
      {0x0908,0x0b07,0x0f0a},
      {0x0d0b,0x0e0a,0x100c}
    },
    {
      {0x0808,0x0a07,0x0e0a},
      {0x0907,0x0a07,0x0e09},
      {0x0c0a,0x0c09,0x0f0b}
    },
    {
      {0x0b0b,0x0c0a,0x100c},
      {0x0a0a,0x0b09,0x0f0b},
      {0x0c0b,0x0c0a,0x0f0b}
    }
  }
};

const UWord16 huff_ltab5_6[9][9]=
{
  {0x0d0b,0x0c0a,0x0b09,0x0b09,0x0a09,0x0b09,0x0b09,0x0c0a,0x0d0b},
  {0x0c0a,0x0b09,0x0a08,0x0907,0x0807,0x0907,0x0a08,0x0b09,0x0c0a},
  {0x0c09,0x0a08,0x0906,0x0806,0x0706,0x0806,0x0906,0x0a08,0x0b09},
  {0x0b09,0x0907,0x0806,0x0504,0x0404,0x0504,0x0806,0x0907,0x0b09},
  {0x0a09,0x0807,0x0706,0x0404,0x0104,0x0404,0x0706,0x0807,0x0b09},
  {0x0b09,0x0907,0x0806,0x0504,0x0404,0x0504,0x0806,0x0907,0x0b09},
  {0x0b09,0x0a08,0x0906,0x0806,0x0706,0x0806,0x0906,0x0a08,0x0b09},
  {0x0c0a,0x0b09,0x0a08,0x0907,0x0807,0x0907,0x0a07,0x0b08,0x0c0a},
  {0x0d0b,0x0c0a,0x0c09,0x0b09,0x0a09,0x0a09,0x0b09,0x0c0a,0x0d0b}
};

const UWord16 huff_ltab7_8[8][8]=
{
  {0x0105,0x0304,0x0605,0x0706,0x0807,0x0908,0x0a09,0x0b0a},
  {0x0304,0x0403,0x0604,0x0705,0x0806,0x0807,0x0907,0x0908},
  {0x0605,0x0604,0x0704,0x0805,0x0806,0x0907,0x0907,0x0a08},
  {0x0706,0x0705,0x0805,0x0806,0x0906,0x0907,0x0a08,0x0a08},
  {0x0807,0x0806,0x0906,0x0906,0x0a07,0x0a07,0x0a08,0x0b09},
  {0x0908,0x0807,0x0906,0x0907,0x0a07,0x0a08,0x0b08,0x0b0a},
  {0x0a09,0x0907,0x0907,0x0a08,0x0a08,0x0b08,0x0c09,0x0c09},
  {0x0b0a,0x0a08,0x0a08,0x0a08,0x0b09,0x0b09,0x0c09,0x0c0a}
};

const UWord16 huff_ltab9_10[13][13]=
{
  {0x0106,0x0305,0x0606,0x0806,0x0907,0x0a08,0x0a09,0x0b0a,0x0b0a,0x0c0a,0x0c0b,0x0d0b,0x0d0c},
  {0x0305,0x0404,0x0604,0x0705,0x0806,0x0807,0x0907,0x0a08,0x0a08,0x0a09,0x0b0a,0x0c0a,0x0c0b},
  {0x0606,0x0604,0x0705,0x0805,0x0806,0x0906,0x0a07,0x0a08,0x0a08,0x0b09,0x0c09,0x0c0a,0x0c0a},
  {0x0806,0x0705,0x0805,0x0905,0x0906,0x0a07,0x0a07,0x0b08,0x0b08,0x0b09,0x0c09,0x0c0a,0x0d0a},
  {0x0907,0x0806,0x0906,0x0906,0x0a06,0x0a07,0x0b07,0x0b08,0x0b08,0x0c09,0x0c09,0x0c0a,0x0d0a},
  {0x0a08,0x0907,0x0906,0x0a07,0x0b07,0x0b07,0x0b08,0x0c08,0x0b08,0x0c09,0x0c0a,0x0d0a,0x0d0b},
  {0x0b09,0x0907,0x0a07,0x0b07,0x0b07,0x0b08,0x0c08,0x0c09,0x0c09,0x0c09,0x0d0a,0x0d0a,0x0d0b},
  {0x0b09,0x0a08,0x0a08,0x0b08,0x0b08,0x0c08,0x0c09,0x0d09,0x0d09,0x0d0a,0x0d0a,0x0d0b,0x0d0b},
  {0x0b09,0x0a08,0x0a08,0x0b08,0x0b08,0x0b08,0x0c09,0x0c09,0x0d0a,0x0d0a,0x0e0a,0x0d0b,0x0e0b},
  {0x0b0a,0x0a09,0x0b09,0x0b09,0x0c09,0x0c09,0x0c09,0x0c0a,0x0d0a,0x0d0a,0x0e0b,0x0e0b,0x0e0c},
  {0x0c0a,0x0b09,0x0b09,0x0c09,0x0c09,0x0c0a,0x0d0a,0x0d0a,0x0d0a,0x0e0b,0x0e0b,0x0e0b,0x0f0c},
  {0x0c0b,0x0b0a,0x0c09,0x0c0a,0x0c0a,0x0d0a,0x0d0a,0x0d0a,0x0d0b,0x0e0b,0x0e0b,0x0f0b,0x0f0c},
  {0x0d0b,0x0c0a,0x0c0a,0x0c0a,0x0d0a,0x0d0a,0x0d0a,0x0d0b,0x0e0b,0x0e0c,0x0e0c,0x0e0c,0x0f0c}
};

const UWord16 huff_ltab11[17][17]=
{
  {0x0004,0x0005,0x0006,0x0007,0x0008,0x0008,0x0009,0x000a,0x000a,0x000a,0x000b,0x000b,0x000c,0x000b,0x000c,0x000c,0x000a},
  {0x0005,0x0004,0x0005,0x0006,0x0007,0x0007,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000b,0x0008},
  {0x0006,0x0005,0x0005,0x0006,0x0007,0x0007,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0007,0x0006,0x0006,0x0006,0x0007,0x0007,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0008,0x0007,0x0007,0x0007,0x0007,0x0008,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0008,0x0007,0x0007,0x0007,0x0007,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0009,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x0009,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x0008},
  {0x000a,0x0009,0x0008,0x0008,0x0009,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x0008},
  {0x000a,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x0008},
  {0x000b,0x0009,0x0009,0x0009,0x0009,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000a,0x000b,0x000b,0x0008},
  {0x000b,0x000a,0x0009,0x0009,0x000a,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x0008},
  {0x000b,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x0009},
  {0x000b,0x000a,0x0009,0x0009,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x000b,0x0009},
  {0x000b,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x000b,0x0009},
  {0x000c,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000a,0x000b,0x000b,0x000b,0x000b,0x000b,0x000b,0x000c,0x000c,0x0009},
  {0x0009,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0009,0x0005}
};

const UWord16 huff_ltabscf[121]=
{
  0x0012,
  0x0012,
  0x0012,
  0x0012,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0012,
  0x0013,
  0x0012,
  0x0011,
  0x0011,
  0x0010,
  0x0011,
  0x0010,
  0x0010,
  0x0010,
  0x0010,
  0x000f,
  0x000f,
  0x000e,
  0x000e,
  0x000e,
  0x000e,
  0x000e,
  0x000e,
  0x000d,
  0x000d,
  0x000c,
  0x000c,
  0x000c,
  0x000b,
  0x000c,
  0x000b,
  0x000a,
  0x000a,
  0x000a,
  0x0009,
  0x0009,
  0x0008,
  0x0008,
  0x0008,
  0x0007,
  0x0006,
  0x0006,
  0x0005,
  0x0004,
  0x0003,
  0x0001,
  0x0004,
  0x0004,
  0x0005,
  0x0006,
  0x0006,
  0x0007,
  0x0007,
  0x0008,
  0x0008,
  0x0009,
  0x0009,
  0x000a,
  0x000a,
  0x000a,
  0x000b,
  0x000b,
  0x000b,
  0x000b,
  0x000c,
  0x000c,
  0x000d,
  0x000d,
  0x000d,
  0x000e,
  0x000e,
  0x0010,
  0x000f,
  0x0010,
  0x000f,
  0x0012,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013,
  0x0013
};


const UWord16 huff_ctab1[3][3][3][3]=
{
  {
    {
      {0x07f8,0x01f1,0x07fd},
      {0x03f5,0x0068,0x03f0},
      {0x07f7,0x01ec,0x07f5}
    },
    {
      {0x03f1,0x0072,0x03f4},
      {0x0074,0x0011,0x0076},
      {0x01eb,0x006c,0x03f6}
    },
    {
      {0x07fc,0x01e1,0x07f1},
      {0x01f0,0x0061,0x01f6},
      {0x07f2,0x01ea,0x07fb}
    }
  },
  {
    {
      {0x01f2,0x0069,0x01ed},
      {0x0077,0x0017,0x006f},
      {0x01e6,0x0064,0x01e5}
    },
    {
      {0x0067,0x0015,0x0062},
      {0x0012,0x0000,0x0014},
      {0x0065,0x0016,0x006d}
    },
    {
      {0x01e9,0x0063,0x01e4},
      {0x006b,0x0013,0x0071},
      {0x01e3,0x0070,0x01f3}
    }
  },
  {
    {
      {0x07fe,0x01e7,0x07f3},
      {0x01ef,0x0060,0x01ee},
      {0x07f0,0x01e2,0x07fa}
    },
    {
      {0x03f3,0x006a,0x01e8},
      {0x0075,0x0010,0x0073},
      {0x01f4,0x006e,0x03f7}
    },
    {
      {0x07f6,0x01e0,0x07f9},
      {0x03f2,0x0066,0x01f5},
      {0x07ff,0x01f7,0x07f4}
    }
  }
};

const UWord16 huff_ctab2[3][3][3][3]=
{
  {
    {
      {0x01f3,0x006f,0x01fd},
      {0x00eb,0x0023,0x00ea},
      {0x01f7,0x00e8,0x01fa}
    },
    {
      {0x00f2,0x002d,0x0070},
      {0x0020,0x0006,0x002b},
      {0x006e,0x0028,0x00e9}
    },
    {
      {0x01f9,0x0066,0x00f8},
      {0x00e7,0x001b,0x00f1},
      {0x01f4,0x006b,0x01f5}
    }
  },
  {
    {
      {0x00ec,0x002a,0x006c},
      {0x002c,0x000a,0x0027},
      {0x0067,0x001a,0x00f5}
    },
    {
      {0x0024,0x0008,0x001f},
      {0x0009,0x0000,0x0007},
      {0x001d,0x000b,0x0030}
    },
    {
      {0x00ef,0x001c,0x0064},
      {0x001e,0x000c,0x0029},
      {0x00f3,0x002f,0x00f0}
    }
  },
  {
    {
      {0x01fc,0x0071,0x01f2},
      {0x00f4,0x0021,0x00e6},
      {0x00f7,0x0068,0x01f8}
    },
    {
      {0x00ee,0x0022,0x0065},
      {0x0031,0x0002,0x0026},
      {0x00ed,0x0025,0x006a}
    },
    {
      {0x01fb,0x0072,0x01fe},
      {0x0069,0x002e,0x00f6},
      {0x01ff,0x006d,0x01f6}
    }
  }
};

const UWord16 huff_ctab3[3][3][3][3]=
{
  {
    {
      {0x0000,0x0009,0x00ef},
      {0x000b,0x0019,0x00f0},
      {0x01eb,0x01e6,0x03f2}
    },
    {
      {0x000a,0x0035,0x01ef},
      {0x0034,0x0037,0x01e9},
      {0x01ed,0x01e7,0x03f3}
    },
    {
      {0x01ee,0x03ed,0x1ffa},
      {0x01ec,0x01f2,0x07f9},
      {0x07f8,0x03f8,0x0ff8}
    }
  },
  {
    {
      {0x0008,0x0038,0x03f6},
      {0x0036,0x0075,0x03f1},
      {0x03eb,0x03ec,0x0ff4}
    },
    {
      {0x0018,0x0076,0x07f4},
      {0x0039,0x0074,0x03ef},
      {0x01f3,0x01f4,0x07f6}
    },
    {
      {0x01e8,0x03ea,0x1ffc},
      {0x00f2,0x01f1,0x0ffb},
      {0x03f5,0x07f3,0x0ffc}
    }
  },
  {
    {
      {0x00ee,0x03f7,0x7ffe},
      {0x01f0,0x07f5,0x7ffd},
      {0x1ffb,0x3ffa,0xffff}
    },
    {
      {0x00f1,0x03f0,0x3ffc},
      {0x01ea,0x03ee,0x3ffb},
      {0x0ff6,0x0ffa,0x7ffc}
    },
    {
      {0x07f2,0x0ff5,0xfffe},
      {0x03f4,0x07f7,0x7ffb},
      {0x0ff7,0x0ff9,0x7ffa}
    }
  }
};

const UWord16 huff_ctab4[3][3][3][3]=
{
  {
    {
      {0x0007,0x0016,0x00f6},
      {0x0018,0x0008,0x00ef},
      {0x01ef,0x00f3,0x07f8}
    },
    {
      {0x0019,0x0017,0x00ed},
      {0x0015,0x0001,0x00e2},
      {0x00f0,0x0070,0x03f0}
    },
    {
      {0x01ee,0x00f1,0x07fa},
      {0x00ee,0x00e4,0x03f2},
      {0x07f6,0x03ef,0x07fd}
    }
  },
  {
    {
      {0x0005,0x0014,0x00f2},
      {0x0009,0x0004,0x00e5},
      {0x00f4,0x00e8,0x03f4}
    },
    {
      {0x0006,0x0002,0x00e7},
      {0x0003,0x0000,0x006b},
      {0x00e3,0x0069,0x01f3}
    },
    {
      {0x00eb,0x00e6,0x03f6},
      {0x006e,0x006a,0x01f4},
      {0x03ec,0x01f0,0x03f9}
    }
  },
  {
    {
      {0x00f5,0x00ec,0x07fb},
      {0x00ea,0x006f,0x03f7},
      {0x07f9,0x03f3,0x0fff}
    },
    {
      {0x00e9,0x006d,0x03f8},
      {0x006c,0x0068,0x01f5},
      {0x03ee,0x01f2,0x07f4}
    },
    {
      {0x07f7,0x03f1,0x0ffe},
      {0x03ed,0x01f1,0x07f5},
      {0x07fe,0x03f5,0x07fc}
    }
  }
};
const UWord16 huff_ctab5[9][9]=
{
  {0x1fff,0x0ff7,0x07f4,0x07e8,0x03f1,0x07ee,0x07f9,0x0ff8,0x1ffd},
  {0x0ffd,0x07f1,0x03e8,0x01e8,0x00f0,0x01ec,0x03ee,0x07f2,0x0ffa},
  {0x0ff4,0x03ef,0x01f2,0x00e8,0x0070,0x00ec,0x01f0,0x03ea,0x07f3},
  {0x07eb,0x01eb,0x00ea,0x001a,0x0008,0x0019,0x00ee,0x01ef,0x07ed},
  {0x03f0,0x00f2,0x0073,0x000b,0x0000,0x000a,0x0071,0x00f3,0x07e9},
  {0x07ef,0x01ee,0x00ef,0x0018,0x0009,0x001b,0x00eb,0x01e9,0x07ec},
  {0x07f6,0x03eb,0x01f3,0x00ed,0x0072,0x00e9,0x01f1,0x03ed,0x07f7},
  {0x0ff6,0x07f0,0x03e9,0x01ed,0x00f1,0x01ea,0x03ec,0x07f8,0x0ff9},
  {0x1ffc,0x0ffc,0x0ff5,0x07ea,0x03f3,0x03f2,0x07f5,0x0ffb,0x1ffe}
};

const UWord16 huff_ctab6[9][9]=
{
  {0x07fe,0x03fd,0x01f1,0x01eb,0x01f4,0x01ea,0x01f0,0x03fc,0x07fd},
  {0x03f6,0x01e5,0x00ea,0x006c,0x0071,0x0068,0x00f0,0x01e6,0x03f7},
  {0x01f3,0x00ef,0x0032,0x0027,0x0028,0x0026,0x0031,0x00eb,0x01f7},
  {0x01e8,0x006f,0x002e,0x0008,0x0004,0x0006,0x0029,0x006b,0x01ee},
  {0x01ef,0x0072,0x002d,0x0002,0x0000,0x0003,0x002f,0x0073,0x01fa},
  {0x01e7,0x006e,0x002b,0x0007,0x0001,0x0005,0x002c,0x006d,0x01ec},
  {0x01f9,0x00ee,0x0030,0x0024,0x002a,0x0025,0x0033,0x00ec,0x01f2},
  {0x03f8,0x01e4,0x00ed,0x006a,0x0070,0x0069,0x0074,0x00f1,0x03fa},
  {0x07ff,0x03f9,0x01f6,0x01ed,0x01f8,0x01e9,0x01f5,0x03fb,0x07fc}
};

const UWord16 huff_ctab7[8][8]=
{
  {0x0000,0x0005,0x0037,0x0074,0x00f2,0x01eb,0x03ed,0x07f7},
  {0x0004,0x000c,0x0035,0x0071,0x00ec,0x00ee,0x01ee,0x01f5},
  {0x0036,0x0034,0x0072,0x00ea,0x00f1,0x01e9,0x01f3,0x03f5},
  {0x0073,0x0070,0x00eb,0x00f0,0x01f1,0x01f0,0x03ec,0x03fa},
  {0x00f3,0x00ed,0x01e8,0x01ef,0x03ef,0x03f1,0x03f9,0x07fb},
  {0x01ed,0x00ef,0x01ea,0x01f2,0x03f3,0x03f8,0x07f9,0x07fc},
  {0x03ee,0x01ec,0x01f4,0x03f4,0x03f7,0x07f8,0x0ffd,0x0ffe},
  {0x07f6,0x03f0,0x03f2,0x03f6,0x07fa,0x07fd,0x0ffc,0x0fff}
};

const UWord16 huff_ctab8[8][8]=
{
  {0x000e,0x0005,0x0010,0x0030,0x006f,0x00f1,0x01fa,0x03fe},
  {0x0003,0x0000,0x0004,0x0012,0x002c,0x006a,0x0075,0x00f8},
  {0x000f,0x0002,0x0006,0x0014,0x002e,0x0069,0x0072,0x00f5},
  {0x002f,0x0011,0x0013,0x002a,0x0032,0x006c,0x00ec,0x00fa},
  {0x0071,0x002b,0x002d,0x0031,0x006d,0x0070,0x00f2,0x01f9},
  {0x00ef,0x0068,0x0033,0x006b,0x006e,0x00ee,0x00f9,0x03fc},
  {0x01f8,0x0074,0x0073,0x00ed,0x00f0,0x00f6,0x01f6,0x01fd},
  {0x03fd,0x00f3,0x00f4,0x00f7,0x01f7,0x01fb,0x01fc,0x03ff}
};

const UWord16 huff_ctab9[13][13]=
{
  {0x0000,0x0005,0x0037,0x00e7,0x01de,0x03ce,0x03d9,0x07c8,0x07cd,0x0fc8,0x0fdd,0x1fe4,0x1fec},
  {0x0004,0x000c,0x0035,0x0072,0x00ea,0x00ed,0x01e2,0x03d1,0x03d3,0x03e0,0x07d8,0x0fcf,0x0fd5},
  {0x0036,0x0034,0x0071,0x00e8,0x00ec,0x01e1,0x03cf,0x03dd,0x03db,0x07d0,0x0fc7,0x0fd4,0x0fe4},
  {0x00e6,0x0070,0x00e9,0x01dd,0x01e3,0x03d2,0x03dc,0x07cc,0x07ca,0x07de,0x0fd8,0x0fea,0x1fdb},
  {0x01df,0x00eb,0x01dc,0x01e6,0x03d5,0x03de,0x07cb,0x07dd,0x07dc,0x0fcd,0x0fe2,0x0fe7,0x1fe1},
  {0x03d0,0x01e0,0x01e4,0x03d6,0x07c5,0x07d1,0x07db,0x0fd2,0x07e0,0x0fd9,0x0feb,0x1fe3,0x1fe9},
  {0x07c4,0x01e5,0x03d7,0x07c6,0x07cf,0x07da,0x0fcb,0x0fda,0x0fe3,0x0fe9,0x1fe6,0x1ff3,0x1ff7},
  {0x07d3,0x03d8,0x03e1,0x07d4,0x07d9,0x0fd3,0x0fde,0x1fdd,0x1fd9,0x1fe2,0x1fea,0x1ff1,0x1ff6},
  {0x07d2,0x03d4,0x03da,0x07c7,0x07d7,0x07e2,0x0fce,0x0fdb,0x1fd8,0x1fee,0x3ff0,0x1ff4,0x3ff2},
  {0x07e1,0x03df,0x07c9,0x07d6,0x0fca,0x0fd0,0x0fe5,0x0fe6,0x1feb,0x1fef,0x3ff3,0x3ff4,0x3ff5},
  {0x0fe0,0x07ce,0x07d5,0x0fc6,0x0fd1,0x0fe1,0x1fe0,0x1fe8,0x1ff0,0x3ff1,0x3ff8,0x3ff6,0x7ffc},
  {0x0fe8,0x07df,0x0fc9,0x0fd7,0x0fdc,0x1fdc,0x1fdf,0x1fed,0x1ff5,0x3ff9,0x3ffb,0x7ffd,0x7ffe},
  {0x1fe7,0x0fcc,0x0fd6,0x0fdf,0x1fde,0x1fda,0x1fe5,0x1ff2,0x3ffa,0x3ff7,0x3ffc,0x3ffd,0x7fff}
};

const UWord16 huff_ctab10[13][13]=
{
  {0x0022,0x0008,0x001d,0x0026,0x005f,0x00d3,0x01cf,0x03d0,0x03d7,0x03ed,0x07f0,0x07f6,0x0ffd},
  {0x0007,0x0000,0x0001,0x0009,0x0020,0x0054,0x0060,0x00d5,0x00dc,0x01d4,0x03cd,0x03de,0x07e7},
  {0x001c,0x0002,0x0006,0x000c,0x001e,0x0028,0x005b,0x00cd,0x00d9,0x01ce,0x01dc,0x03d9,0x03f1},
  {0x0025,0x000b,0x000a,0x000d,0x0024,0x0057,0x0061,0x00cc,0x00dd,0x01cc,0x01de,0x03d3,0x03e7},
  {0x005d,0x0021,0x001f,0x0023,0x0027,0x0059,0x0064,0x00d8,0x00df,0x01d2,0x01e2,0x03dd,0x03ee},
  {0x00d1,0x0055,0x0029,0x0056,0x0058,0x0062,0x00ce,0x00e0,0x00e2,0x01da,0x03d4,0x03e3,0x07eb},
  {0x01c9,0x005e,0x005a,0x005c,0x0063,0x00ca,0x00da,0x01c7,0x01ca,0x01e0,0x03db,0x03e8,0x07ec},
  {0x01e3,0x00d2,0x00cb,0x00d0,0x00d7,0x00db,0x01c6,0x01d5,0x01d8,0x03ca,0x03da,0x07ea,0x07f1},
  {0x01e1,0x00d4,0x00cf,0x00d6,0x00de,0x00e1,0x01d0,0x01d6,0x03d1,0x03d5,0x03f2,0x07ee,0x07fb},
  {0x03e9,0x01cd,0x01c8,0x01cb,0x01d1,0x01d7,0x01df,0x03cf,0x03e0,0x03ef,0x07e6,0x07f8,0x0ffa},
  {0x03eb,0x01dd,0x01d3,0x01d9,0x01db,0x03d2,0x03cc,0x03dc,0x03ea,0x07ed,0x07f3,0x07f9,0x0ff9},
  {0x07f2,0x03ce,0x01e4,0x03cb,0x03d8,0x03d6,0x03e2,0x03e5,0x07e8,0x07f4,0x07f5,0x07f7,0x0ffb},
  {0x07fa,0x03ec,0x03df,0x03e1,0x03e4,0x03e6,0x03f0,0x07e9,0x07ef,0x0ff8,0x0ffe,0x0ffc,0x0fff}
};

const UWord16 huff_ctab11[17][17]=
{
  {0x0000,0x0006,0x0019,0x003d,0x009c,0x00c6,0x01a7,0x0390,0x03c2,0x03df,0x07e6,0x07f3,0x0ffb,0x07ec,0x0ffa,0x0ffe,0x038e},
  {0x0005,0x0001,0x0008,0x0014,0x0037,0x0042,0x0092,0x00af,0x0191,0x01a5,0x01b5,0x039e,0x03c0,0x03a2,0x03cd,0x07d6,0x00ae},
  {0x0017,0x0007,0x0009,0x0018,0x0039,0x0040,0x008e,0x00a3,0x00b8,0x0199,0x01ac,0x01c1,0x03b1,0x0396,0x03be,0x03ca,0x009d},
  {0x003c,0x0015,0x0016,0x001a,0x003b,0x0044,0x0091,0x00a5,0x00be,0x0196,0x01ae,0x01b9,0x03a1,0x0391,0x03a5,0x03d5,0x0094},
  {0x009a,0x0036,0x0038,0x003a,0x0041,0x008c,0x009b,0x00b0,0x00c3,0x019e,0x01ab,0x01bc,0x039f,0x038f,0x03a9,0x03cf,0x0093},
  {0x00bf,0x003e,0x003f,0x0043,0x0045,0x009e,0x00a7,0x00b9,0x0194,0x01a2,0x01ba,0x01c3,0x03a6,0x03a7,0x03bb,0x03d4,0x009f},
  {0x01a0,0x008f,0x008d,0x0090,0x0098,0x00a6,0x00b6,0x00c4,0x019f,0x01af,0x01bf,0x0399,0x03bf,0x03b4,0x03c9,0x03e7,0x00a8},
  {0x01b6,0x00ab,0x00a4,0x00aa,0x00b2,0x00c2,0x00c5,0x0198,0x01a4,0x01b8,0x038c,0x03a4,0x03c4,0x03c6,0x03dd,0x03e8,0x00ad},
  {0x03af,0x0192,0x00bd,0x00bc,0x018e,0x0197,0x019a,0x01a3,0x01b1,0x038d,0x0398,0x03b7,0x03d3,0x03d1,0x03db,0x07dd,0x00b4},
  {0x03de,0x01a9,0x019b,0x019c,0x01a1,0x01aa,0x01ad,0x01b3,0x038b,0x03b2,0x03b8,0x03ce,0x03e1,0x03e0,0x07d2,0x07e5,0x00b7},
  {0x07e3,0x01bb,0x01a8,0x01a6,0x01b0,0x01b2,0x01b7,0x039b,0x039a,0x03ba,0x03b5,0x03d6,0x07d7,0x03e4,0x07d8,0x07ea,0x00ba},
  {0x07e8,0x03a0,0x01bd,0x01b4,0x038a,0x01c4,0x0392,0x03aa,0x03b0,0x03bc,0x03d7,0x07d4,0x07dc,0x07db,0x07d5,0x07f0,0x00c1},
  {0x07fb,0x03c8,0x03a3,0x0395,0x039d,0x03ac,0x03ae,0x03c5,0x03d8,0x03e2,0x03e6,0x07e4,0x07e7,0x07e0,0x07e9,0x07f7,0x0190},
  {0x07f2,0x0393,0x01be,0x01c0,0x0394,0x0397,0x03ad,0x03c3,0x03c1,0x03d2,0x07da,0x07d9,0x07df,0x07eb,0x07f4,0x07fa,0x0195},
  {0x07f8,0x03bd,0x039c,0x03ab,0x03a8,0x03b3,0x03b9,0x03d0,0x03e3,0x03e5,0x07e2,0x07de,0x07ed,0x07f1,0x07f9,0x07fc,0x0193},
  {0x0ffd,0x03dc,0x03b6,0x03c7,0x03cc,0x03cb,0x03d9,0x03da,0x07d3,0x07e1,0x07ee,0x07ef,0x07f5,0x07f6,0x0ffc,0x0fff,0x019d},
  {0x01c2,0x00b5,0x00a1,0x0096,0x0097,0x0095,0x0099,0x00a0,0x00a2,0x00ac,0x00a9,0x00b1,0x00b3,0x00bb,0x00c0,0x018f,0x0004}
};

const UWord32 huff_ctabscf[121]=
{
  0x0003ffe8,
  0x0003ffe6,
  0x0003ffe7,
  0x0003ffe5,
  0x0007fff5,
  0x0007fff1,
  0x0007ffed,
  0x0007fff6,
  0x0007ffee,
  0x0007ffef,
  0x0007fff0,
  0x0007fffc,
  0x0007fffd,
  0x0007ffff,
  0x0007fffe,
  0x0007fff7,
  0x0007fff8,
  0x0007fffb,
  0x0007fff9,
  0x0003ffe4,
  0x0007fffa,
  0x0003ffe3,
  0x0001ffef,
  0x0001fff0,
  0x0000fff5,
  0x0001ffee,
  0x0000fff2,
  0x0000fff3,
  0x0000fff4,
  0x0000fff1,
  0x00007ff6,
  0x00007ff7,
  0x00003ff9,
  0x00003ff5,
  0x00003ff7,
  0x00003ff3,
  0x00003ff6,
  0x00003ff2,
  0x00001ff7,
  0x00001ff5,
  0x00000ff9,
  0x00000ff7,
  0x00000ff6,
  0x000007f9,
  0x00000ff4,
  0x000007f8,
  0x000003f9,
  0x000003f7,
  0x000003f5,
  0x000001f8,
  0x000001f7,
  0x000000fa,
  0x000000f8,
  0x000000f6,
  0x00000079,
  0x0000003a,
  0x00000038,
  0x0000001a,
  0x0000000b,
  0x00000004,
  0x00000000,
  0x0000000a,
  0x0000000c,
  0x0000001b,
  0x00000039,
  0x0000003b,
  0x00000078,
  0x0000007a,
  0x000000f7,
  0x000000f9,
  0x000001f6,
  0x000001f9,
  0x000003f4,
  0x000003f6,
  0x000003f8,
  0x000007f5,
  0x000007f4,
  0x000007f6,
  0x000007f7,
  0x00000ff5,
  0x00000ff8,
  0x00001ff4,
  0x00001ff6,
  0x00001ff8,
  0x00003ff8,
  0x00003ff4,
  0x0000fff0,
  0x00007ff4,
  0x0000fff6,
  0x00007ff5,
  0x0003ffe2,
  0x0007ffd9,
  0x0007ffda,
  0x0007ffdb,
  0x0007ffdc,
  0x0007ffdd,
  0x0007ffde,
  0x0007ffd8,
  0x0007ffd2,
  0x0007ffd3,
  0x0007ffd4,
  0x0007ffd5,
  0x0007ffd6,
  0x0007fff2,
  0x0007ffdf,
  0x0007ffe7,
  0x0007ffe8,
  0x0007ffe9,
  0x0007ffea,
  0x0007ffeb,
  0x0007ffe6,
  0x0007ffe0,
  0x0007ffe1,
  0x0007ffe2,
  0x0007ffe3,
  0x0007ffe4,
  0x0007ffe5,
  0x0007ffd7,
  0x0007ffec,
  0x0007fff4,
  0x0007fff3
};

const Word32 m_log2_table[INT_BITS] = {
  0x00000000,0x4ae00d00,0x2934f080,0x15c01a3f, 
  0x0b31fb80,0x05aeb4e0,0x02dcf2d0,0x016fe50c, 
  0x00b84e23,0x005c3e10,0x002e24ca,0x001713d6,
  0x000b8a47,0x0005c53b,0x0002e2a3,0x00017153,
  0x0000b8aa,0x00005c55,0x00002e2b,0x00001715,
  0x00000b8b,0x000005c5,0x000002e3,0x00000171, 
  0x000000b9,0x0000005c,0x0000002e,0x00000017,
  0x0000000c,0x00000006,0x00000003,0x00000001
};


/*
  3 bit resolution
*/
const Word32 tnsCoeff3[8] =
{
  0x81f1d1d4,
  0x9126147c,
  0xadb922f7,
  0xd438af09,
  0x00000000,
  0x37898087,
  0x64130dfa,
  0x7cca6ffb,
};

const Word32 tnsCoeff3Borders[8] =
{
  0x80000000,  /* -4 */
  0x87b826de,  /* -3 */
  0x9df24153,  /* -2 */
  0xbfffffe5,  /* -1 */
  0xe9c5e578,  /*  0 */
  0x1c7b90f0,  /*  1 */
  0x4fce83aa,  /*  2 */
  0x7352f2c4,  /*  3 */
};


/*
  4 bit resolution
*/

const Word32 tnsCoeff4[16] =
{
  0x808bc84b,
  0x84e2e57d,
  0x8d6b49fb,
  0x99da9207,
  0xa9c45707,
  0xbc9dde78,
  0xd1c2d4fc,
  0xe87ae539,
  0x00000000,
  0x1a9cd9c0,
  0x340ff23b,
  0x4b3c8bf7,
  0x5f1f5e80,
  0x6ed9eb84,
  0x79bc3880,
  0x7f4c7e89
};

const Word32 tnsCoeff4Borders[16]=
{
  0x80000000,  /* -8 */
  0x822defef,  /* -7 */
  0x88a4bfe5,  /* -6 */
  0x932c159c,  /* -5 */
  0xa16827c1,  /* -4 */
  0xb2dcde26,  /* -3 */
  0xc6f20b91,  /* -2 */
  0xdcf89c64,  /* -1 */
  0xf4308ce1,  /*  0 */
  0x0d613054,  /*  1 */
  0x278dde80,  /*  2 */
  0x4000001b,  /*  3 */
  0x55a6127c,  /*  4 */
  0x678dde8f,  /*  5 */
  0x74ef0ed8,  /*  6 */
  0x7d33f0db   /*  7 */
};


const unsigned char bitrevTab[17 + 129] = 
{
/* 64 */
0x01, 0x08, 0x02, 0x04, 0x03, 0x0c, 0x05, 0x0a, 0x07, 0x0e, 0x0b, 0x0d, 0x00, 0x06, 0x09, 0x0f,
0x00,

/* 512 */
0x01, 0x40, 0x02, 0x20, 0x03, 0x60, 0x04, 0x10, 0x05, 0x50, 0x06, 0x30, 0x07, 0x70, 0x09, 0x48,
0x0a, 0x28, 0x0b, 0x68, 0x0c, 0x18, 0x0d, 0x58, 0x0e, 0x38, 0x0f, 0x78, 0x11, 0x44, 0x12, 0x24,
0x13, 0x64, 0x15, 0x54, 0x16, 0x34, 0x17, 0x74, 0x19, 0x4c, 0x1a, 0x2c, 0x1b, 0x6c, 0x1d, 0x5c,
0x1e, 0x3c, 0x1f, 0x7c, 0x21, 0x42, 0x23, 0x62, 0x25, 0x52, 0x26, 0x32, 0x27, 0x72, 0x29, 0x4a,
0x2b, 0x6a, 0x2d, 0x5a, 0x2e, 0x3a, 0x2f, 0x7a, 0x31, 0x46, 0x33, 0x66, 0x35, 0x56, 0x37, 0x76,
0x39, 0x4e, 0x3b, 0x6e, 0x3d, 0x5e, 0x3f, 0x7e, 0x43, 0x61, 0x45, 0x51, 0x47, 0x71, 0x4b, 0x69,
0x4d, 0x59, 0x4f, 0x79, 0x53, 0x65, 0x57, 0x75, 0x5b, 0x6d, 0x5f, 0x7d, 0x67, 0x73, 0x6f, 0x7b,
0x00, 0x08, 0x14, 0x1c, 0x22, 0x2a, 0x36, 0x3e, 0x41, 0x49, 0x55, 0x5d, 0x63, 0x6b, 0x77, 0x7f,
0x00,
};