
# Introduction

Wayland is an object oriented display protocol, which features request
and events. Requests can be seen as method calls on certain objects,
whereas events can be seen as signals of an object. This makes the
Wayland protocol a perfect candidate for a C++ binding.

The goal of this library is to create such a C++ binding for Wayland
using the most modern C++ technology currently available, providing
an easy to use C++ API to Wayland.

# Requirements

You need to have a recent version of scons, since this library uses
scons as its build system. Furthermore, a recent C++ Compiler with
C++11 support, such as GCC or clang, is required. Apart from the
Wayland libraries, there are no further library requirements.

The documentation is autogenerated using Doxygen, therefore doxygen as
well as graphviz is required.

# Building

To build the library, execute scons in the root directory of the
repository. You can install it with "scons install".

To build the example programs, execute scons in the example directory.
If you did not install the library earlier, use the following commands
to run the example programs from the root directory of the repository:

    $ LD_LIBRARY_PATH=src example/opengles
    $ LD_LIBRARY_PATH=src example/shm

Make sure you have a Wayland compositor running.

To build the documentation, execute doxygen in the root directory of
the repository. The resulting documentation can then be found in the
"doc" directory.

# Usage

In the following, it is assumed that the reader is familiar with basic
Wayland concepts and the latest version of the C++ programming language.

Each interface is represented by a class. E.g. the wl_registry
interface is represented by the registry_t class.

An instance of a class is a wrapper for a Wayland object (a wl_proxy
pointer). If a copy is made of a particualr instance, both instances
refer to the same Wayland object. The underlying Wayland object is
destroyed once there are no copies of this object left. Only a few
classes are non-copyable, namely display_t and egl_window_t.

A request to an object of a specific interface corresponds to a method
in this class. E.g. to marshal the create_pool request on an wl_shm
interface, the create_pool() method of an instance of shm_t has to be
called:

    shm_t shm;
    int fd;
    int32_t size;
    // ... insert initialization of the above here ...
    shm_pool_t shm_pool = shm.create_pool(fd, size);

Some methods return newly created instances of other classes. In this
example an instance of the class shm_pool_t is returned.

Events are implemented using function objects. To react to an event, a
function object with the correct signature has to be assigned to
it. These can not only be static functions, but also member functions
or closures. E.g. to react to global events from the registry using a
lambda expression, one could write:

    registry.on_global() = [] (uint32_t name, std::string interface,
                               uint32_t version)
      { std::cout << interface << " v" << version << std::endl; };

An example for using member functions can be found under
example/opengles.cpp or example/shm.cpp.

The Wayland protocol uses arrays in some of its events and requests.
Since these arrays can have arbitrary content, they are not directly
mapped to a std::vector. Instead there is a new type array_t, which
can converted to and from a std::vectory with an user specified type.
For example:

    keyboard.on_enter() = [] (uint32_t serial, surface_t surface,
                              array_t keys)
      { std::vector<uint32_t> vec = keys; };

