/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Dimension;
import javax.tv.xlet.XletContext;
import org.davic.resources.ResourceClient;
import org.davic.resources.ResourceProxy;
import org.davic.resources.ResourceServer;
import org.davic.resources.ResourceStatusListener;
import org.havi.ui.HEventMulticaster;
import org.havi.ui.HPermissionDeniedException;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.event.HScreenConfigurationEvent;
import org.havi.ui.event.HScreenConfigurationListener;
import org.havi.ui.event.HScreenDeviceReleasedEvent;
import org.havi.ui.event.HScreenDeviceReservedEvent;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public class HScreenDevice
implements ResourceProxy,
ResourceServer {
    private HScreenConfigurationListener hscl = null;
    private ResourceStatusListener listener = null;
    private XletContext context = null;
    private ResourceClient client = null;

    HScreenDevice() {
    }

    public String getIDstring() {
        return "HAVi Screen Device";
    }

    public void addScreenConfigurationListener(HScreenConfigurationListener hscl) {
        this.hscl = HEventMulticaster.add(this.hscl, hscl);
    }

    public void addScreenConfigurationListener(HScreenConfigurationListener hscl, HScreenConfigTemplate hsct) {
        this.hscl = HEventMulticaster.add(this.hscl, hscl, hsct);
    }

    public void removeScreenConfigurationListener(HScreenConfigurationListener hscl) {
        this.hscl = HEventMulticaster.remove(this.hscl, hscl);
    }

    public Dimension getScreenAspectRatio() {
        Logger.unimplemented(HScreenDevice.class.getName(), "getScreenAspectRatio");
        return new Dimension(16, 9);
    }

    public boolean reserveDevice(ResourceClient client) {
        if (this.client == client) {
            return true;
        }
        if (this.client != null && !this.client.requestRelease(this, null)) {
            return false;
        }
        this.context = BDJXletContext.getCurrentContext();
        this.client = client;
        if (this.listener != null) {
            this.listener.statusChanged(new HScreenDeviceReservedEvent(client));
        }
        return true;
    }

    public void releaseDevice() {
        if (this.context != BDJXletContext.getCurrentContext()) {
            return;
        }
        if (this.listener != null) {
            this.listener.statusChanged(new HScreenDeviceReleasedEvent(this.client));
        }
        this.context = null;
        this.client = null;
    }

    @Override
    public ResourceClient getClient() {
        return this.client;
    }

    @Override
    public void addResourceStatusEventListener(ResourceStatusListener listener) {
        this.listener = HEventMulticaster.add(this.listener, listener);
    }

    @Override
    public void removeResourceStatusEventListener(ResourceStatusListener listener) {
        this.listener = HEventMulticaster.remove(this.listener, listener);
    }

    protected void reportScreenConfigurationEvent(HScreenConfigurationEvent evt) {
        if (this.hscl != null) {
            this.hscl.report(evt);
        }
    }

    protected void testRight() throws HPermissionDeniedException {
        if (this.context != BDJXletContext.getCurrentContext()) {
            throw new HPermissionDeniedException();
        }
    }
}

