/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import net.engio.mbassy.listener.Handler;

public class ToggleBlacklistAction
extends AbstractAction {
    private final FlatSVGIcon enabledIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/list-check.svg");
    private final FlatSVGIcon disabledIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/list-check.svg");
    private boolean blacklist_is_on;

    public ToggleBlacklistAction() {
        this.disabledIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> Color.RED));
        this.blacklist_is_on = ApplicationConfiguration.getConfiguration().getBoolean("blacklist.is_on", false);
        this.setupState();
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.blacklist_is_on = ApplicationConfiguration.getConfiguration().getBoolean("blacklist.is_on", false);
            this.setupState();
        });
    }

    private void setupState() {
        if (this.blacklist_is_on) {
            this.putValue("Name", "Blacklist ausschalten");
            this.putValue("ShortDescription", "Blacklist ausschalten");
            this.putValue("SmallIcon", this.enabledIcon);
        } else {
            this.putValue("Name", "Blacklist einschalten");
            this.putValue("ShortDescription", "Blacklist einschalten");
            this.putValue("SmallIcon", this.disabledIcon);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.blacklist_is_on = !this.blacklist_is_on;
        ApplicationConfiguration.getConfiguration().setProperty("blacklist.is_on", (Object)this.blacklist_is_on);
        Daten.getInstance().getListeBlacklist().filterListe();
        MessageBus.getMessageBus().publishAsync((Object)new BlacklistChangedEvent());
    }
}

