=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::SlidesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeSlidesCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my %params = @_;
    my $api_client = AsposeSlidesCloud::ApiClient->new(@_);

    bless { api_client => $api_client }, $class;
}


#
# copy_file
#
# Copy file
# 
# @param string $src_path Source file path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $dest_path Destination file path (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to copy (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to copy',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_file' } = { 
    	summary => 'Copy file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub copy_file {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling copy_file");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling copy_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# copy_folder
#
# Copy folder
# 
# @param string $src_path Source folder path e.g. &#39;/src&#39; (required)
# @param string $dest_path Destination folder path e.g. &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source folder path e.g. &#39;/src&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path e.g. &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_folder' } = { 
    	summary => 'Copy folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub copy_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling copy_folder");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling copy_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# create_folder
#
# Create the folder
# 
# @param string $path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path to create e.g. &#39;folder_1/folder_2/&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_folder' } = { 
    	summary => 'Create the folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub create_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling create_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_chart_category
#
# Delete a category from a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $category_index Category index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category_index' => {
        data_type => 'int',
        description => 'Category index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_chart_category' } = { 
    	summary => 'Delete a category from a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub delete_chart_category {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_chart_category");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_chart_category");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_chart_category");
    }

    # verify the required parameter 'category_index' is set
    unless (exists $args{'category_index'}) {
      croak("Missing the required parameter 'category_index' when calling delete_chart_category");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories/{categoryIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'category_index'}) {
        my $_base_variable = "{" . "categoryIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'category_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# delete_chart_data_point
#
# Delete a data point from a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param int $point_index Data point index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'point_index' => {
        data_type => 'int',
        description => 'Data point index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_chart_data_point' } = { 
    	summary => 'Delete a data point from a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub delete_chart_data_point {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_chart_data_point");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_chart_data_point");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_chart_data_point");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling delete_chart_data_point");
    }

    # verify the required parameter 'point_index' is set
    unless (exists $args{'point_index'}) {
      croak("Missing the required parameter 'point_index' when calling delete_chart_data_point");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints/{pointIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'point_index'}) {
        my $_base_variable = "{" . "pointIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'point_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# delete_chart_series
#
# Delete a series from a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param int $series_index Series index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_chart_series' } = { 
    	summary => 'Delete a series from a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub delete_chart_series {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_chart_series");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_chart_series");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_chart_series");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling delete_chart_series");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# delete_file
#
# Delete file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to delete (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to delete',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_file' } = { 
    	summary => 'Delete file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_folder
#
# Delete folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param boolean $recursive Enable to delete folders, subfolders and files (optional, default to false)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'recursive' => {
        data_type => 'boolean',
        description => 'Enable to delete folders, subfolders and files',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_folder' } = { 
    	summary => 'Delete folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'recursive'} && defined $args{'recursive'}) {
        $query_params->{'recursive'} = $self->{api_client}->to_boolean_query_value($args{'recursive'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_notes_slide
#
# Remove notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide' } = { 
    	summary => 'Remove notes slide.',
        params => $params,
        returns => 'Slide',
        };
}
# @return Slide
#
sub delete_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slide', $response);
    return $_response_object;
}

#
# delete_notes_slide_paragraph
#
# Remove a paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide_paragraph' } = { 
    	summary => 'Remove a paragraph.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_notes_slide_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_notes_slide_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_notes_slide_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_notes_slide_paragraphs
#
# Remove a range of paragraphs.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $paragraphs The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraphs' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide_paragraphs' } = { 
    	summary => 'Remove a range of paragraphs.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_notes_slide_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_notes_slide_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'paragraphs'} && defined $args{'paragraphs'}) {
        $query_params->{'paragraphs'} = $self->{api_client}->to_query_value($args{'paragraphs'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_notes_slide_portion
#
# Remove a portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide_portion' } = { 
    	summary => 'Remove a portion.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_notes_slide_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_notes_slide_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_notes_slide_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling delete_notes_slide_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_notes_slide_portions
#
# Remove a range of portions.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $portions The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portions' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide_portions' } = { 
    	summary => 'Remove a range of portions.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_notes_slide_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_notes_slide_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_notes_slide_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'portions'} && defined $args{'portions'}) {
        $query_params->{'portions'} = $self->{api_client}->to_query_value($args{'portions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_notes_slide_shape
#
# Remove a shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide_shape' } = { 
    	summary => 'Remove a shape.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_notes_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_notes_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_notes_slide_shapes
#
# Remove a range of shapes.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shapes' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide_shapes' } = { 
    	summary => 'Remove a range of shapes.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_notes_slide_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide_shapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_paragraph
#
# Remove a paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_paragraph' } = { 
    	summary => 'Remove a paragraph.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_paragraphs
#
# Remove a range of paragraphs.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $paragraphs The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraphs' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_paragraphs' } = { 
    	summary => 'Remove a range of paragraphs.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'paragraphs'} && defined $args{'paragraphs'}) {
        $query_params->{'paragraphs'} = $self->{api_client}->to_query_value($args{'paragraphs'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_portion
#
# Remove a portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_portion' } = { 
    	summary => 'Remove a portion.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling delete_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_portions
#
# Remove a range of portions.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $portions The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portions' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_portions' } = { 
    	summary => 'Remove a range of portions.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'portions'} && defined $args{'portions'}) {
        $query_params->{'portions'} = $self->{api_client}->to_query_value($args{'portions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_section
#
# Delete a presentation section.
# 
# @param string $name Document name. (required)
# @param int $section_index Section index. (required)
# @param boolean $with_slides True to delete the slides related to the deleted section; move them to the remaining sections otherwise. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'Section index.',
        required => '1',
    },
    'with_slides' => {
        data_type => 'boolean',
        description => 'True to delete the slides related to the deleted section; move them to the remaining sections otherwise.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_section' } = { 
    	summary => 'Delete a presentation section.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub delete_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_section");
    }

    # verify the required parameter 'section_index' is set
    unless (exists $args{'section_index'}) {
      croak("Missing the required parameter 'section_index' when calling delete_section");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections/{sectionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_slides'} && defined $args{'with_slides'}) {
        $query_params->{'withSlides'} = $self->{api_client}->to_boolean_query_value($args{'with_slides'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'section_index'}) {
        my $_base_variable = "{" . "sectionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'section_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# delete_sections
#
# Delete presentation sections.
# 
# @param string $name Document name. (required)
# @param string $sections The indices of the sections to be deleted; delete all by default. (optional)
# @param boolean $with_slides True to delete the slides related to the deleted sections; move them to the remaining sections otherwise. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sections' => {
        data_type => 'string',
        description => 'The indices of the sections to be deleted; delete all by default.',
        required => '0',
    },
    'with_slides' => {
        data_type => 'boolean',
        description => 'True to delete the slides related to the deleted sections; move them to the remaining sections otherwise.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_sections' } = { 
    	summary => 'Delete presentation sections.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub delete_sections {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_sections");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'sections'} && defined $args{'sections'}) {
        $query_params->{'sections'} = $self->{api_client}->to_query_value($args{'sections'});
    }

    # query params
    if (exists $args{'with_slides'} && defined $args{'with_slides'}) {
        $query_params->{'withSlides'} = $self->{api_client}->to_boolean_query_value($args{'with_slides'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# delete_animation
#
# Remove animation from a slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation' } = { 
    	summary => 'Remove animation from a slide.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_animation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_slide_animation
#
# Remove animation from a slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_animation' } = { 
    	summary => 'Remove animation from a slide.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_slide_animation {
    warnings::warnif("deprecated", "delete_slide_animation is deprecated, use delete_animation instead");
  
    return delete_animation(@_);
}

#
# delete_animation_effect
#
# Remove an effect from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_effect' } = { 
    	summary => 'Remove an effect from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_animation_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_animation_effect");
    }

    # verify the required parameter 'effect_index' is set
    unless (exists $args{'effect_index'}) {
      croak("Missing the required parameter 'effect_index' when calling delete_slide_animation_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/mainSequence/{effectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'effect_index'}) {
        my $_base_variable = "{" . "effectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'effect_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_slide_animation_effect
#
# Remove an effect from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_animation_effect' } = { 
    	summary => 'Remove an effect from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_slide_animation_effect {
    warnings::warnif("deprecated", "delete_slide_animation_effect is deprecated, use delete_animation_effect instead");
  
    return delete_animation_effect(@_);
}

#
# delete_animation_interactive_sequence
#
# Remove an interactive sequence from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index The index of an interactive sequence to be deleted. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The index of an interactive sequence to be deleted.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_interactive_sequence' } = { 
    	summary => 'Remove an interactive sequence from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_interactive_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling delete_slide_animation_interactive_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_slide_animation_interactive_sequence
#
# Remove an interactive sequence from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index The index of an interactive sequence to be deleted. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The index of an interactive sequence to be deleted.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_animation_interactive_sequence' } = { 
    	summary => 'Remove an interactive sequence from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_slide_animation_interactive_sequence {
    warnings::warnif("deprecated", "delete_slide_animation_interactive_sequence is deprecated, use delete_animation_interactive_sequence instead");
  
    return delete_animation_interactive_sequence(@_);
}

#
# delete_animation_interactive_sequence_effect
#
# Remove an effect from slide animation interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index Interactive sequence index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'Interactive sequence index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_interactive_sequence_effect' } = { 
    	summary => 'Remove an effect from slide animation interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_interactive_sequence_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling delete_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'effect_index' is set
    unless (exists $args{'effect_index'}) {
      croak("Missing the required parameter 'effect_index' when calling delete_slide_animation_interactive_sequence_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'effect_index'}) {
        my $_base_variable = "{" . "effectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'effect_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_slide_animation_interactive_sequence_effect
#
# Remove an effect from slide animation interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index Interactive sequence index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'Interactive sequence index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_animation_interactive_sequence_effect' } = { 
    	summary => 'Remove an effect from slide animation interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_slide_animation_interactive_sequence_effect {
    warnings::warnif("deprecated", "delete_slide_animation_interactive_sequence_effect is deprecated, use delete_animation_interactive_sequence_effect instead");
  
    return delete_animation_interactive_sequence_effect(@_);
}

#
# delete_animation_interactive_sequences
#
# Clear all interactive sequences from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_interactive_sequences' } = { 
    	summary => 'Clear all interactive sequences from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_interactive_sequences {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_animation_interactive_sequences");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_animation_interactive_sequences");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_slide_animation_interactive_sequences
#
# Clear all interactive sequences from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_animation_interactive_sequences' } = { 
    	summary => 'Clear all interactive sequences from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_slide_animation_interactive_sequences {
    warnings::warnif("deprecated", "delete_slide_animation_interactive_sequences is deprecated, use delete_animation_interactive_sequences instead");
  
    return delete_animation_interactive_sequences(@_);
}

#
# delete_animation_main_sequence
#
# Clear main sequence in slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_main_sequence' } = { 
    	summary => 'Clear main sequence in slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_main_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_animation_main_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_animation_main_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/mainSequence';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_slide_animation_main_sequence
#
# Clear main sequence in slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_animation_main_sequence' } = { 
    	summary => 'Clear main sequence in slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_slide_animation_main_sequence {
    warnings::warnif("deprecated", "delete_slide_animation_main_sequence is deprecated, use delete_animation_main_sequence instead");
  
    return delete_animation_main_sequence(@_);
}

#
# delete_slide
#
# Delete a presentation slide by index.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide' } = { 
    	summary => 'Delete a presentation slide by index.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub delete_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_by_index");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_by_index");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# delete_slide_by_index
#
# Delete a presentation slide by index.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_by_index' } = { 
    	summary => 'Delete a presentation slide by index.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub delete_slide_by_index {
    warnings::warnif("deprecated", "delete_slide_by_index is deprecated, use delete_slide instead");
  
    return delete_slide(@_);
}

#
# delete_shape
#
# Remove a shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_shape' } = { 
    	summary => 'Remove a shape.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_slide_shape
#
# Remove a shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_shape' } = { 
    	summary => 'Remove a shape.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_slide_shape {
    warnings::warnif("deprecated", "delete_slide_shape is deprecated, use delete_shape instead");
  
    return delete_shape(@_);
}

#
# delete_shapes
#
# Remove a range of shapes.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shapes' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_shapes' } = { 
    	summary => 'Remove a range of shapes.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_shapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_slide_shapes
#
# Remove a range of shapes.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shapes' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_shapes' } = { 
    	summary => 'Remove a range of shapes.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_slide_shapes {
    warnings::warnif("deprecated", "delete_slide_shapes is deprecated, use delete_shapes instead");
  
    return delete_shapes(@_);
}

#
# delete_subshape
#
# Remove a shape (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_subshape' } = { 
    	summary => 'Remove a shape (for smart art and group shapes).',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_subshape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_subshape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_subshape");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_slide_subshape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_slide_subshape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_slide_subshape
#
# Remove a shape (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_subshape' } = { 
    	summary => 'Remove a shape (for smart art and group shapes).',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_slide_subshape {
    warnings::warnif("deprecated", "delete_slide_subshape is deprecated, use delete_subshape instead");
  
    return delete_subshape(@_);
}

#
# delete_subshapes
#
# Remove a range of shapes (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param string $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shapes' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_subshapes' } = { 
    	summary => 'Remove a range of shapes (for smart art and group shapes).',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_subshapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_subshapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_subshapes");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_slide_subshapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_slide_subshapes
#
# Remove a range of shapes (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param string $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shapes' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_subshapes' } = { 
    	summary => 'Remove a range of shapes (for smart art and group shapes).',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_slide_subshapes {
    warnings::warnif("deprecated", "delete_slide_subshapes is deprecated, use delete_subshapes instead");
  
    return delete_subshapes(@_);
}

#
# delete_slides
#
# Delete presentation slides.
# 
# @param string $name Document name. (required)
# @param string $slides The indices of the slides to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slides' => {
        data_type => 'string',
        description => 'The indices of the slides to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slides' } = { 
    	summary => 'Delete presentation slides.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub delete_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slides_clean_slides_list");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'slides'} && defined $args{'slides'}) {
        $query_params->{'slides'} = $self->{api_client}->to_query_value($args{'slides'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# delete_slides_clean_slides_list
#
# Delete presentation slides.
# 
# @param string $name Document name. (required)
# @param string $slides The indices of the slides to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slides' => {
        data_type => 'string',
        description => 'The indices of the slides to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slides_clean_slides_list' } = { 
    	summary => 'Delete presentation slides.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub delete_slides_clean_slides_list {
    warnings::warnif("deprecated", "delete_slides_clean_slides_list is deprecated, use delete_slides instead");
  
    return delete_slides(@_);
}

#
# delete_document_properties
#
# Clean document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_document_properties' } = { 
    	summary => 'Clean document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub delete_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slides_document_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# delete_slides_document_properties
#
# Clean document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slides_document_properties' } = { 
    	summary => 'Clean document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub delete_slides_document_properties {
    warnings::warnif("deprecated", "delete_slides_document_properties is deprecated, use delete_document_properties instead");
  
    return delete_document_properties(@_);
}

#
# delete_document_property
#
# Delete document property.
# 
# @param string $name Document name. (required)
# @param string $property_name The property name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_document_property' } = { 
    	summary => 'Delete document property.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub delete_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slides_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'} && $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling delete_slides_document_property");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties/{propertyName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# delete_slides_document_property
#
# Delete document property.
# 
# @param string $name Document name. (required)
# @param string $property_name The property name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slides_document_property' } = { 
    	summary => 'Delete document property.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub delete_slides_document_property {
    warnings::warnif("deprecated", "delete_slides_document_property is deprecated, use delete_document_property instead");
  
    return delete_document_property(@_);
}

#
# delete_background
#
# Remove background from a slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_background' } = { 
    	summary => 'Remove background from a slide.',
        params => $params,
        returns => 'SlideBackground',
        };
}
# @return SlideBackground
#
sub delete_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slides_slide_background");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slides_slide_background");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/background';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideBackground', $response);
    return $_response_object;
}

#
# delete_slides_slide_background
#
# Remove background from a slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slides_slide_background' } = { 
    	summary => 'Remove background from a slide.',
        params => $params,
        returns => 'SlideBackground',
        };
}
# @return SlideBackground
#
sub delete_slides_slide_background {
    warnings::warnif("deprecated", "delete_slides_slide_background is deprecated, use delete_background instead");
  
    return delete_background(@_);
}

#
# delete_subshape_paragraph
#
# Remove a paragraph (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_subshape_paragraph' } = { 
    	summary => 'Remove a paragraph (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_subshape_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_subshape_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_subshape_paragraph");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_subshape_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_subshape_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_subshape_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_subshape_paragraphs
#
# Remove a range of paragraphs (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $paragraphs The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraphs' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_subshape_paragraphs' } = { 
    	summary => 'Remove a range of paragraphs (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_subshape_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_subshape_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_subshape_paragraphs");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_subshape_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_subshape_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'paragraphs'} && defined $args{'paragraphs'}) {
        $query_params->{'paragraphs'} = $self->{api_client}->to_query_value($args{'paragraphs'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_subshape_portion
#
# Remove a portion (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_subshape_portion' } = { 
    	summary => 'Remove a portion (for smart art and group shapes).',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_subshape_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_subshape_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_subshape_portion");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_subshape_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_subshape_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_subshape_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling delete_subshape_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_subshape_portions
#
# Remove a range of portions (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $portions The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portions' => {
        data_type => 'string',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_subshape_portions' } = { 
    	summary => 'Remove a range of portions (for smart art and group shapes).',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_subshape_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_subshape_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_subshape_portions");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_subshape_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_subshape_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_subshape_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'portions'} && defined $args{'portions'}) {
        $query_params->{'portions'} = $self->{api_client}->to_query_value($args{'portions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# download_file
#
# Download file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to download (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to download',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_file' } = { 
    	summary => 'Download file',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling download_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_disc_usage
#
# Get disc usage
# 
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_disc_usage' } = { 
    	summary => 'Get disc usage',
        params => $params,
        returns => 'DiscUsage',
        };
}
# @return DiscUsage
#
sub get_disc_usage {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/storage/disc';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DiscUsage', $response);
    return $_response_object;
}

#
# get_file_versions
#
# Get file versions
# 
# @param string $path File path e.g. &#39;/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_file_versions' } = { 
    	summary => 'Get file versions',
        params => $params,
        returns => 'FileVersions',
        };
}
# @return FileVersions
#
sub get_file_versions {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_file_versions");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/version/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FileVersions', $response);
    return $_response_object;
}

#
# get_files_list
#
# Get all files and folders within a folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_files_list' } = { 
    	summary => 'Get all files and folders within a folder',
        params => $params,
        returns => 'FilesList',
        };
}
# @return FilesList
#
sub get_files_list {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_files_list");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesList', $response);
    return $_response_object;
}

#
# get_layout_slide
#
# Read presentation layoutSlide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_layout_slide' } = { 
    	summary => 'Read presentation layoutSlide info.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub get_layout_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_layout_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_layout_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides/{slideIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlide', $response);
    return $_response_object;
}

#
# get_layout_slides
#
# Read presentation layoutSlides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_layout_slides' } = { 
    	summary => 'Read presentation layoutSlides info.',
        params => $params,
        returns => 'LayoutSlides',
        };
}
# @return LayoutSlides
#
sub get_layout_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_layout_slides_list");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlides', $response);
    return $_response_object;
}

#
# get_layout_slides_list
#
# Read presentation layoutSlides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_layout_slides_list' } = { 
    	summary => 'Read presentation layoutSlides info.',
        params => $params,
        returns => 'LayoutSlides',
        };
}
# @return LayoutSlides
#
sub get_layout_slides_list {
    warnings::warnif("deprecated", "get_layout_slides_list is deprecated, use get_layout_slides instead");
  
    return get_layout_slides(@_);
}

#
# get_master_slide
#
# Read presentation masterSlide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_master_slide' } = { 
    	summary => 'Read presentation masterSlide info.',
        params => $params,
        returns => 'MasterSlide',
        };
}
# @return MasterSlide
#
sub get_master_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_master_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_master_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides/{slideIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlide', $response);
    return $_response_object;
}

#
# get_master_slides
#
# Read presentation masterSlides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_master_slides' } = { 
    	summary => 'Read presentation masterSlides info.',
        params => $params,
        returns => 'MasterSlides',
        };
}
# @return MasterSlides
#
sub get_master_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_master_slides_list");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlides', $response);
    return $_response_object;
}

#
# get_master_slides_list
#
# Read presentation masterSlides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_master_slides_list' } = { 
    	summary => 'Read presentation masterSlides info.',
        params => $params,
        returns => 'MasterSlides',
        };
}
# @return MasterSlides
#
sub get_master_slides_list {
    warnings::warnif("deprecated", "get_master_slides_list is deprecated, use get_master_slides instead");
  
    return get_master_slides(@_);
}

#
# get_notes_slide
#
# Read notes slide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide' } = { 
    	summary => 'Read notes slide info.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub get_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlide', $response);
    return $_response_object;
}

#
# notes_slide_exists
#
# Get info whether a notes slide exists.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'notes_slide_exists' } = { 
    	summary => 'Get info whether a notes slide exists.',
        params => $params,
        returns => 'EntityExists',
        };
}
# @return EntityExists
#
sub notes_slide_exists {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_exists");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_exists");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/exist';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('EntityExists', $response);
    return $_response_object;
}

#
# get_notes_slide_exists
#
# Get info whether a notes slide exists.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_exists' } = { 
    	summary => 'Get info whether a notes slide exists.',
        params => $params,
        returns => 'EntityExists',
        };
}
# @return EntityExists
#
sub get_notes_slide_exists {
    warnings::warnif("deprecated", "get_notes_slide_exists is deprecated, use notes_slide_exists instead");
  
    return notes_slide_exists(@_);
}

#
# get_notes_slide_header_footer
#
# Get header/footer info for the notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_header_footer' } = { 
    	summary => 'Get header/footer info for the notes slide.',
        params => $params,
        returns => 'NotesSlideHeaderFooter',
        };
}
# @return NotesSlideHeaderFooter
#
sub get_notes_slide_header_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_header_footer");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_header_footer");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/headerFooter';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlideHeaderFooter', $response);
    return $_response_object;
}

#
# get_notes_slide_shape
#
# Read slide shape info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_shape' } = { 
    	summary => 'Read slide shape info.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_notes_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_notes_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# get_notes_slide_paragraph
#
# Read shape paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_paragraph' } = { 
    	summary => 'Read shape paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_notes_slide_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_shape_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_shape_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_notes_slide_shape_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_notes_slide_shape_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_notes_slide_shape_paragraph
#
# Read shape paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_shape_paragraph' } = { 
    	summary => 'Read shape paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_notes_slide_shape_paragraph {
    warnings::warnif("deprecated", "get_notes_slide_shape_paragraph is deprecated, use get_notes_slide_paragraph instead");
  
    return get_notes_slide_paragraph(@_);
}

#
# get_notes_slide_paragraphs
#
# Read shape paragraphs info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_paragraphs' } = { 
    	summary => 'Read shape paragraphs info.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_notes_slide_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_shape_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_shape_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_notes_slide_shape_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# get_notes_slide_shape_paragraphs
#
# Read shape paragraphs info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_shape_paragraphs' } = { 
    	summary => 'Read shape paragraphs info.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_notes_slide_shape_paragraphs {
    warnings::warnif("deprecated", "get_notes_slide_shape_paragraphs is deprecated, use get_notes_slide_paragraphs instead");
  
    return get_notes_slide_paragraphs(@_);
}

#
# get_notes_slide_portion
#
# Read paragraph portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_portion' } = { 
    	summary => 'Read paragraph portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_notes_slide_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_shape_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_shape_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_notes_slide_shape_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_notes_slide_shape_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_notes_slide_shape_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_notes_slide_shape_portion
#
# Read paragraph portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_shape_portion' } = { 
    	summary => 'Read paragraph portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_notes_slide_shape_portion {
    warnings::warnif("deprecated", "get_notes_slide_shape_portion is deprecated, use get_notes_slide_portion instead");
  
    return get_notes_slide_portion(@_);
}

#
# get_notes_slide_portions
#
# Read paragraph portions info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_portions' } = { 
    	summary => 'Read paragraph portions info.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_notes_slide_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_shape_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_shape_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_notes_slide_shape_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_notes_slide_shape_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# get_notes_slide_shape_portions
#
# Read paragraph portions info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_shape_portions' } = { 
    	summary => 'Read paragraph portions info.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_notes_slide_shape_portions {
    warnings::warnif("deprecated", "get_notes_slide_shape_portions is deprecated, use get_notes_slide_portions instead");
  
    return get_notes_slide_portions(@_);
}

#
# get_notes_slide_shapes
#
# Read slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_shapes' } = { 
    	summary => 'Read slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_notes_slide_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_shapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# download_notes_slide
#
# Convert notes slide to the specified image format.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width Output file width. (optional)
# @param int $height Output file height. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_notes_slide' } = { 
    	summary => 'Convert notes slide to the specified image format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_with_format");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_with_format");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling get_notes_slide_with_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/{format}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_notes_slide_with_format
#
# Convert notes slide to the specified image format.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width Output file width. (optional)
# @param int $height Output file height. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_with_format' } = { 
    	summary => 'Convert notes slide to the specified image format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub get_notes_slide_with_format {
    warnings::warnif("deprecated", "get_notes_slide_with_format is deprecated, use download_notes_slide instead");
  
    return download_notes_slide(@_);
}

#
# get_portion
#
# Read paragraph portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_portion' } = { 
    	summary => 'Read paragraph portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_paragraph_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_paragraph_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_paragraph_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_paragraph_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_paragraph_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_paragraph_portion
#
# Read paragraph portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraph_portion' } = { 
    	summary => 'Read paragraph portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_paragraph_portion {
    warnings::warnif("deprecated", "get_paragraph_portion is deprecated, use get_portion instead");
  
    return get_portion(@_);
}

#
# get_portions
#
# Read paragraph portions info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_portions' } = { 
    	summary => 'Read paragraph portions info.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_paragraph_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_paragraph_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_paragraph_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_paragraph_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# get_paragraph_portions
#
# Read paragraph portions info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraph_portions' } = { 
    	summary => 'Read paragraph portions info.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_paragraph_portions {
    warnings::warnif("deprecated", "get_paragraph_portions is deprecated, use get_portions instead");
  
    return get_portions(@_);
}

#
# get_sections
#
# Read presentation sections info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_sections' } = { 
    	summary => 'Read presentation sections info.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub get_sections {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_sections");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# get_animation
#
# Read slide animation effects.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. If specified, only effects related to that shape are returned. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index. If specified, only effects related to that shape are returned.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_animation' } = { 
    	summary => 'Read slide animation effects.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub get_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_animation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_index'} && defined $args{'shape_index'}) {
        $query_params->{'shapeIndex'} = $self->{api_client}->to_query_value($args{'shape_index'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# get_slide_animation
#
# Read slide animation effects.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. If specified, only effects related to that shape are returned. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index. If specified, only effects related to that shape are returned.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_animation' } = { 
    	summary => 'Read slide animation effects.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub get_slide_animation {
    warnings::warnif("deprecated", "get_slide_animation is deprecated, use get_animation instead");
  
    return get_animation(@_);
}

#
# get_slide_header_footer
#
# Get footer info for the slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_header_footer' } = { 
    	summary => 'Get footer info for the slide.',
        params => $params,
        returns => 'HeaderFooter',
        };
}
# @return HeaderFooter
#
sub get_slide_header_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_header_footer");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_header_footer");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/headerFooter';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HeaderFooter', $response);
    return $_response_object;
}

#
# get_shape
#
# Read slide shape info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_shape' } = { 
    	summary => 'Read slide shape info.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# get_slide_shape
#
# Read slide shape info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_shape' } = { 
    	summary => 'Read slide shape info.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_slide_shape {
    warnings::warnif("deprecated", "get_slide_shape is deprecated, use get_shape instead");
  
    return get_shape(@_);
}

#
# get_paragraph
#
# Read shape paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraph' } = { 
    	summary => 'Read shape paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_shape_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_shape_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_slide_shape_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_slide_shape_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_slide_shape_paragraph
#
# Read shape paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_shape_paragraph' } = { 
    	summary => 'Read shape paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_slide_shape_paragraph {
    warnings::warnif("deprecated", "get_slide_shape_paragraph is deprecated, use get_paragraph instead");
  
    return get_paragraph(@_);
}

#
# get_paragraphs
#
# Read shape paragraphs info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraphs' } = { 
    	summary => 'Read shape paragraphs info.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_shape_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_shape_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_slide_shape_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# get_slide_shape_paragraphs
#
# Read shape paragraphs info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_shape_paragraphs' } = { 
    	summary => 'Read shape paragraphs info.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_slide_shape_paragraphs {
    warnings::warnif("deprecated", "get_slide_shape_paragraphs is deprecated, use get_paragraphs instead");
  
    return get_paragraphs(@_);
}

#
# get_shapes
#
# Read slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_shapes' } = { 
    	summary => 'Read slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_shapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# get_slide_shapes
#
# Read slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_shapes' } = { 
    	summary => 'Read slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_slide_shapes {
    warnings::warnif("deprecated", "get_slide_shapes is deprecated, use get_shapes instead");
  
    return get_shapes(@_);
}

#
# get_subshape
#
# Read slide shape info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape' } = { 
    	summary => 'Read slide shape info (for smart art and group shapes).',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_subshape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_subshape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_subshape");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_slide_subshape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_slide_subshape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# get_slide_subshape
#
# Read slide shape info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_subshape' } = { 
    	summary => 'Read slide shape info (for smart art and group shapes).',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_slide_subshape {
    warnings::warnif("deprecated", "get_slide_subshape is deprecated, use get_subshape instead");
  
    return get_subshape(@_);
}

#
# get_subshape_paragraph
#
# Read shape paragraph info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape_paragraph' } = { 
    	summary => 'Read shape paragraph info (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_subshape_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_subshape_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_subshape_paragraph");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_slide_subshape_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_slide_subshape_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_slide_subshape_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_slide_subshape_paragraph
#
# Read shape paragraph info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_subshape_paragraph' } = { 
    	summary => 'Read shape paragraph info (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_slide_subshape_paragraph {
    warnings::warnif("deprecated", "get_slide_subshape_paragraph is deprecated, use get_subshape_paragraph instead");
  
    return get_subshape_paragraph(@_);
}

#
# get_subshape_paragraphs
#
# Read shape paragraphs info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape_paragraphs' } = { 
    	summary => 'Read shape paragraphs info (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_subshape_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_subshape_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_subshape_paragraphs");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_slide_subshape_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_slide_subshape_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# get_slide_subshape_paragraphs
#
# Read shape paragraphs info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_subshape_paragraphs' } = { 
    	summary => 'Read shape paragraphs info (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_slide_subshape_paragraphs {
    warnings::warnif("deprecated", "get_slide_subshape_paragraphs is deprecated, use get_subshape_paragraphs instead");
  
    return get_subshape_paragraphs(@_);
}

#
# get_subshapes
#
# Read slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path (for smart art and group shapes). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path (for smart art and group shapes).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshapes' } = { 
    	summary => 'Read slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_subshapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_subshapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_subshapes");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_slide_subshapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# get_slide_subshapes
#
# Read slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path (for smart art and group shapes). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path (for smart art and group shapes).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_subshapes' } = { 
    	summary => 'Read slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_slide_subshapes {
    warnings::warnif("deprecated", "get_slide_subshapes is deprecated, use get_subshapes instead");
  
    return get_subshapes(@_);
}

#
# get_api_info
#
# Get API info.
# 
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_api_info' } = { 
    	summary => 'Get API info.',
        params => $params,
        returns => 'ApiInfo',
        };
}
# @return ApiInfo
#
sub get_api_info {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/info';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ApiInfo', $response);
    return $_response_object;
}

#
# get_slides_api_info
#
# Get API info.
# 
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_slides_api_info' } = { 
    	summary => 'Get API info.',
        params => $params,
        returns => 'ApiInfo',
        };
}
# @return ApiInfo
#
sub get_slides_api_info {
    warnings::warnif("deprecated", "get_slides_api_info is deprecated, use get_api_info instead");
  
    return get_api_info(@_);
}

#
# get_presentation
#
# Read presentation info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Documentstorage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Documentstorage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_presentation' } = { 
    	summary => 'Read presentation info.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub get_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_document");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# get_slides_document
#
# Read presentation info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Documentstorage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Documentstorage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_document' } = { 
    	summary => 'Read presentation info.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub get_slides_document {
    warnings::warnif("deprecated", "get_slides_document is deprecated, use get_presentation instead");
  
    return get_presentation(@_);
}

#
# get_document_properties
#
# Read presentation document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_document_properties' } = { 
    	summary => 'Read presentation document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub get_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_document_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# get_slides_document_properties
#
# Read presentation document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_document_properties' } = { 
    	summary => 'Read presentation document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub get_slides_document_properties {
    warnings::warnif("deprecated", "get_slides_document_properties is deprecated, use get_document_properties instead");
  
    return get_document_properties(@_);
}

#
# get_document_property
#
# Read presentation document property.
# 
# @param string $name Document name. (required)
# @param string $property_name The property name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_document_property' } = { 
    	summary => 'Read presentation document property.',
        params => $params,
        returns => 'DocumentProperty',
        };
}
# @return DocumentProperty
#
sub get_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'} && $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling get_slides_document_property");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties/{propertyName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperty', $response);
    return $_response_object;
}

#
# get_slides_document_property
#
# Read presentation document property.
# 
# @param string $name Document name. (required)
# @param string $property_name The property name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_document_property' } = { 
    	summary => 'Read presentation document property.',
        params => $params,
        returns => 'DocumentProperty',
        };
}
# @return DocumentProperty
#
sub get_slides_document_property {
    warnings::warnif("deprecated", "get_slides_document_property is deprecated, use get_document_property instead");
  
    return get_document_property(@_);
}

#
# download_image_default_format
#
# Get image binary data.
# 
# @param string $name Document name. (required)
# @param int $index Image index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image_default_format' } = { 
    	summary => 'Get image binary data.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image_default_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_image_with_default_format");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling get_slides_image_with_default_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/{index}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_slides_image_with_default_format
#
# Get image binary data.
# 
# @param string $name Document name. (required)
# @param int $index Image index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_image_with_default_format' } = { 
    	summary => 'Get image binary data.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub get_slides_image_with_default_format {
    warnings::warnif("deprecated", "get_slides_image_with_default_format is deprecated, use download_image_default_format instead");
  
    return download_image_default_format(@_);
}

#
# download_image
#
# Get image in specified format.
# 
# @param string $name Document name. (required)
# @param int $index Image index. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image' } = { 
    	summary => 'Get image in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_image_with_format");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling get_slides_image_with_format");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling get_slides_image_with_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/{index}/{format}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_slides_image_with_format
#
# Get image in specified format.
# 
# @param string $name Document name. (required)
# @param int $index Image index. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_image_with_format' } = { 
    	summary => 'Get image in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub get_slides_image_with_format {
    warnings::warnif("deprecated", "get_slides_image_with_format is deprecated, use download_image instead");
  
    return download_image(@_);
}

#
# get_presentation_images
#
# Read presentation images info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_presentation_images' } = { 
    	summary => 'Read presentation images info.',
        params => $params,
        returns => 'Images',
        };
}
# @return Images
#
sub get_presentation_images {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_images");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Images', $response);
    return $_response_object;
}

#
# get_slides_images
#
# Read presentation images info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_images' } = { 
    	summary => 'Read presentation images info.',
        params => $params,
        returns => 'Images',
        };
}
# @return Images
#
sub get_slides_images {
    warnings::warnif("deprecated", "get_slides_images is deprecated, use get_presentation_images instead");
  
    return get_presentation_images(@_);
}

#
# get_placeholder
#
# Read slide placeholder info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $placeholder_index Placeholder index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'placeholder_index' => {
        data_type => 'int',
        description => 'Placeholder index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_placeholder' } = { 
    	summary => 'Read slide placeholder info.',
        params => $params,
        returns => 'Placeholder',
        };
}
# @return Placeholder
#
sub get_placeholder {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_placeholder");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_placeholder");
    }

    # verify the required parameter 'placeholder_index' is set
    unless (exists $args{'placeholder_index'}) {
      croak("Missing the required parameter 'placeholder_index' when calling get_slides_placeholder");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/placeholders/{placeholderIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'placeholder_index'}) {
        my $_base_variable = "{" . "placeholderIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'placeholder_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Placeholder', $response);
    return $_response_object;
}

#
# get_slides_placeholder
#
# Read slide placeholder info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $placeholder_index Placeholder index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'placeholder_index' => {
        data_type => 'int',
        description => 'Placeholder index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_placeholder' } = { 
    	summary => 'Read slide placeholder info.',
        params => $params,
        returns => 'Placeholder',
        };
}
# @return Placeholder
#
sub get_slides_placeholder {
    warnings::warnif("deprecated", "get_slides_placeholder is deprecated, use get_placeholder instead");
  
    return get_placeholder(@_);
}

#
# get_placeholders
#
# Read slide placeholders info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_placeholders' } = { 
    	summary => 'Read slide placeholders info.',
        params => $params,
        returns => 'Placeholders',
        };
}
# @return Placeholders
#
sub get_placeholders {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_placeholders");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_placeholders");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/placeholders';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Placeholders', $response);
    return $_response_object;
}

#
# get_slides_placeholders
#
# Read slide placeholders info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_placeholders' } = { 
    	summary => 'Read slide placeholders info.',
        params => $params,
        returns => 'Placeholders',
        };
}
# @return Placeholders
#
sub get_slides_placeholders {
    warnings::warnif("deprecated", "get_slides_placeholders is deprecated, use get_placeholders instead");
  
    return get_placeholders(@_);
}

#
# get_presentation_text_items
#
# Extract presentation text items.
# 
# @param string $name Document name. (required)
# @param boolean $with_empty True to incude empty items. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'with_empty' => {
        data_type => 'boolean',
        description => 'True to incude empty items.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_presentation_text_items' } = { 
    	summary => 'Extract presentation text items.',
        params => $params,
        returns => 'TextItems',
        };
}
# @return TextItems
#
sub get_presentation_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_presentation_text_items");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_empty'} && defined $args{'with_empty'}) {
        $query_params->{'withEmpty'} = $self->{api_client}->to_boolean_query_value($args{'with_empty'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItems', $response);
    return $_response_object;
}

#
# get_slides_presentation_text_items
#
# Extract presentation text items.
# 
# @param string $name Document name. (required)
# @param boolean $with_empty True to incude empty items. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'with_empty' => {
        data_type => 'boolean',
        description => 'True to incude empty items.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_presentation_text_items' } = { 
    	summary => 'Extract presentation text items.',
        params => $params,
        returns => 'TextItems',
        };
}
# @return TextItems
#
sub get_slides_presentation_text_items {
    warnings::warnif("deprecated", "get_slides_presentation_text_items is deprecated, use get_presentation_text_items instead");
  
    return get_presentation_text_items(@_);
}

#
# get_protection_properties
#
# Read presentation protection properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_protection_properties' } = { 
    	summary => 'Read presentation protection properties.',
        params => $params,
        returns => 'ProtectionProperties',
        };
}
# @return ProtectionProperties
#
sub get_protection_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_protection_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/protectionProperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ProtectionProperties', $response);
    return $_response_object;
}

#
# get_slides_protection_properties
#
# Read presentation protection properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_protection_properties' } = { 
    	summary => 'Read presentation protection properties.',
        params => $params,
        returns => 'ProtectionProperties',
        };
}
# @return ProtectionProperties
#
sub get_slides_protection_properties {
    warnings::warnif("deprecated", "get_slides_protection_properties is deprecated, use get_protection_properties instead");
  
    return get_protection_properties(@_);
}

#
# get_slide
#
# Read presentation slide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide' } = { 
    	summary => 'Read presentation slide info.',
        params => $params,
        returns => 'Slide',
        };
}
# @return Slide
#
sub get_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slide', $response);
    return $_response_object;
}

#
# get_slides_slide
#
# Read presentation slide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slide' } = { 
    	summary => 'Read presentation slide info.',
        params => $params,
        returns => 'Slide',
        };
}
# @return Slide
#
sub get_slides_slide {
    warnings::warnif("deprecated", "get_slides_slide is deprecated, use get_slide instead");
  
    return get_slide(@_);
}

#
# get_background
#
# Read slide background info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_background' } = { 
    	summary => 'Read slide background info.',
        params => $params,
        returns => 'SlideBackground',
        };
}
# @return SlideBackground
#
sub get_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slide_background");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_slide_background");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/background';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideBackground', $response);
    return $_response_object;
}

#
# get_slides_slide_background
#
# Read slide background info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slide_background' } = { 
    	summary => 'Read slide background info.',
        params => $params,
        returns => 'SlideBackground',
        };
}
# @return SlideBackground
#
sub get_slides_slide_background {
    warnings::warnif("deprecated", "get_slides_slide_background is deprecated, use get_background instead");
  
    return get_background(@_);
}

#
# get_comments
#
# Read presentation slide comments.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_comments' } = { 
    	summary => 'Read presentation slide comments.',
        params => $params,
        returns => 'SlideComments',
        };
}
# @return SlideComments
#
sub get_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slide_comments");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_slide_comments");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/comments';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideComments', $response);
    return $_response_object;
}

#
# get_slides_slide_comments
#
# Read presentation slide comments.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slide_comments' } = { 
    	summary => 'Read presentation slide comments.',
        params => $params,
        returns => 'SlideComments',
        };
}
# @return SlideComments
#
sub get_slides_slide_comments {
    warnings::warnif("deprecated", "get_slides_slide_comments is deprecated, use get_comments instead");
  
    return get_comments(@_);
}

#
# get_slide_images
#
# Read slide images info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_images' } = { 
    	summary => 'Read slide images info.',
        params => $params,
        returns => 'Images',
        };
}
# @return Images
#
sub get_slide_images {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slide_images");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_slide_images");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/images';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Images', $response);
    return $_response_object;
}

#
# get_slides_slide_images
#
# Read slide images info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slide_images' } = { 
    	summary => 'Read slide images info.',
        params => $params,
        returns => 'Images',
        };
}
# @return Images
#
sub get_slides_slide_images {
    warnings::warnif("deprecated", "get_slides_slide_images is deprecated, use get_slide_images instead");
  
    return get_slide_images(@_);
}

#
# get_slide_properties
#
# Read presentation slide properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_properties' } = { 
    	summary => 'Read presentation slide properties.',
        params => $params,
        returns => 'SlideProperties',
        };
}
# @return SlideProperties
#
sub get_slide_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slide_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slideProperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideProperties', $response);
    return $_response_object;
}

#
# get_slides_slide_properties
#
# Read presentation slide properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slide_properties' } = { 
    	summary => 'Read presentation slide properties.',
        params => $params,
        returns => 'SlideProperties',
        };
}
# @return SlideProperties
#
sub get_slides_slide_properties {
    warnings::warnif("deprecated", "get_slides_slide_properties is deprecated, use get_slide_properties instead");
  
    return get_slide_properties(@_);
}

#
# get_slide_text_items
#
# Extract slide text items.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param boolean $with_empty True to include empty items. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'with_empty' => {
        data_type => 'boolean',
        description => 'True to include empty items.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_text_items' } = { 
    	summary => 'Extract slide text items.',
        params => $params,
        returns => 'TextItems',
        };
}
# @return TextItems
#
sub get_slide_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slide_text_items");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_slide_text_items");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_empty'} && defined $args{'with_empty'}) {
        $query_params->{'withEmpty'} = $self->{api_client}->to_boolean_query_value($args{'with_empty'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItems', $response);
    return $_response_object;
}

#
# get_slides_slide_text_items
#
# Extract slide text items.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param boolean $with_empty True to include empty items. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'with_empty' => {
        data_type => 'boolean',
        description => 'True to include empty items.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slide_text_items' } = { 
    	summary => 'Extract slide text items.',
        params => $params,
        returns => 'TextItems',
        };
}
# @return TextItems
#
sub get_slides_slide_text_items {
    warnings::warnif("deprecated", "get_slides_slide_text_items is deprecated, use get_slide_text_items instead");
  
    return get_slide_text_items(@_);
}

#
# get_slides
#
# Read presentation slides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides' } = { 
    	summary => 'Read presentation slides info.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub get_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_slides_list");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# get_slides_slides_list
#
# Read presentation slides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_slides_list' } = { 
    	summary => 'Read presentation slides info.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub get_slides_slides_list {
    warnings::warnif("deprecated", "get_slides_slides_list is deprecated, use get_slides instead");
  
    return get_slides(@_);
}

#
# get_theme
#
# Read slide theme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_theme' } = { 
    	summary => 'Read slide theme info.',
        params => $params,
        returns => 'Theme',
        };
}
# @return Theme
#
sub get_theme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_theme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_theme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Theme', $response);
    return $_response_object;
}

#
# get_slides_theme
#
# Read slide theme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_theme' } = { 
    	summary => 'Read slide theme info.',
        params => $params,
        returns => 'Theme',
        };
}
# @return Theme
#
sub get_slides_theme {
    warnings::warnif("deprecated", "get_slides_theme is deprecated, use get_theme instead");
  
    return get_theme(@_);
}

#
# get_color_scheme
#
# Read slide theme color scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_color_scheme' } = { 
    	summary => 'Read slide theme color scheme info.',
        params => $params,
        returns => 'ColorScheme',
        };
}
# @return ColorScheme
#
sub get_color_scheme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_theme_color_scheme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_theme_color_scheme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme/colorScheme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColorScheme', $response);
    return $_response_object;
}

#
# get_slides_theme_color_scheme
#
# Read slide theme color scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_theme_color_scheme' } = { 
    	summary => 'Read slide theme color scheme info.',
        params => $params,
        returns => 'ColorScheme',
        };
}
# @return ColorScheme
#
sub get_slides_theme_color_scheme {
    warnings::warnif("deprecated", "get_slides_theme_color_scheme is deprecated, use get_color_scheme instead");
  
    return get_color_scheme(@_);
}

#
# get_font_scheme
#
# Read slide theme font scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_font_scheme' } = { 
    	summary => 'Read slide theme font scheme info.',
        params => $params,
        returns => 'FontScheme',
        };
}
# @return FontScheme
#
sub get_font_scheme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_theme_font_scheme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_theme_font_scheme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme/fontScheme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontScheme', $response);
    return $_response_object;
}

#
# get_slides_theme_font_scheme
#
# Read slide theme font scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_theme_font_scheme' } = { 
    	summary => 'Read slide theme font scheme info.',
        params => $params,
        returns => 'FontScheme',
        };
}
# @return FontScheme
#
sub get_slides_theme_font_scheme {
    warnings::warnif("deprecated", "get_slides_theme_font_scheme is deprecated, use get_font_scheme instead");
  
    return get_font_scheme(@_);
}

#
# get_format_scheme
#
# Read slide theme format scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_format_scheme' } = { 
    	summary => 'Read slide theme format scheme info.',
        params => $params,
        returns => 'FormatScheme',
        };
}
# @return FormatScheme
#
sub get_format_scheme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_theme_format_scheme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slides_theme_format_scheme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme/formatScheme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FormatScheme', $response);
    return $_response_object;
}

#
# get_slides_theme_format_scheme
#
# Read slide theme format scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_theme_format_scheme' } = { 
    	summary => 'Read slide theme format scheme info.',
        params => $params,
        returns => 'FormatScheme',
        };
}
# @return FormatScheme
#
sub get_slides_theme_format_scheme {
    warnings::warnif("deprecated", "get_slides_theme_format_scheme is deprecated, use get_format_scheme instead");
  
    return get_format_scheme(@_);
}

#
# get_view_properties
#
# Read presentation document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_view_properties' } = { 
    	summary => 'Read presentation document properties.',
        params => $params,
        returns => 'ViewProperties',
        };
}
# @return ViewProperties
#
sub get_view_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides_view_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/viewProperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ViewProperties', $response);
    return $_response_object;
}

#
# get_slides_view_properties
#
# Read presentation document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides_view_properties' } = { 
    	summary => 'Read presentation document properties.',
        params => $params,
        returns => 'ViewProperties',
        };
}
# @return ViewProperties
#
sub get_slides_view_properties {
    warnings::warnif("deprecated", "get_slides_view_properties is deprecated, use get_view_properties instead");
  
    return get_view_properties(@_);
}

#
# get_subshape_portion
#
# Read paragraph portion info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape_portion' } = { 
    	summary => 'Read paragraph portion info (for smart art and group shapes).',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_subshape_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_subshape_paragraph_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_subshape_paragraph_portion");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_subshape_paragraph_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_subshape_paragraph_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_subshape_paragraph_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_subshape_paragraph_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_subshape_paragraph_portion
#
# Read paragraph portion info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape_paragraph_portion' } = { 
    	summary => 'Read paragraph portion info (for smart art and group shapes).',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_subshape_paragraph_portion {
    warnings::warnif("deprecated", "get_subshape_paragraph_portion is deprecated, use get_subshape_portion instead");
  
    return get_subshape_portion(@_);
}

#
# get_subshape_portions
#
# Read paragraph portions info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape_portions' } = { 
    	summary => 'Read paragraph portions info (for smart art and group shapes).',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_subshape_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_subshape_paragraph_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_subshape_paragraph_portions");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_subshape_paragraph_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_subshape_paragraph_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_subshape_paragraph_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# get_subshape_paragraph_portions
#
# Read paragraph portions info (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_subshape_paragraph_portions' } = { 
    	summary => 'Read paragraph portions info (for smart art and group shapes).',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_subshape_paragraph_portions {
    warnings::warnif("deprecated", "get_subshape_paragraph_portions is deprecated, use get_subshape_portions instead");
  
    return get_subshape_portions(@_);
}

#
# move_file
#
# Move file
# 
# @param string $src_path Source file path e.g. &#39;/src.ext&#39; (required)
# @param string $dest_path Destination file path e.g. &#39;/dest.ext&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to move (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/src.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path e.g. &#39;/dest.ext&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to move',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_file' } = { 
    	summary => 'Move file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub move_file {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling move_file");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling move_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# move_folder
#
# Move folder
# 
# @param string $src_path Folder path to move e.g. &#39;/folder&#39; (required)
# @param string $dest_path Destination folder path to move to e.g &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Folder path to move e.g. &#39;/folder&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path to move to e.g &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_folder' } = { 
    	summary => 'Move folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub move_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling move_folder");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling move_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# object_exists
#
# Check if file or folder exists
# 
# @param string $path File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'object_exists' } = { 
    	summary => 'Check if file or folder exists',
        params => $params,
        returns => 'ObjectExist',
        };
}
# @return ObjectExist
#
sub object_exists {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling object_exists");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/exist/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ObjectExist', $response);
    return $_response_object;
}

#
# create_paragraph
#
# Creates new paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_paragraph' } = { 
    	summary => 'Creates new paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub create_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_new_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_new_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_add_new_paragraph");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_add_new_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# post_add_new_paragraph
#
# Creates new paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_new_paragraph' } = { 
    	summary => 'Creates new paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub post_add_new_paragraph {
    warnings::warnif("deprecated", "post_add_new_paragraph is deprecated, use create_paragraph instead");
  
    return create_paragraph(@_);
}

#
# create_portion
#
# Creates new portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_portion' } = { 
    	summary => 'Creates new portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub create_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_new_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_new_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_add_new_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling post_add_new_portion");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_add_new_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# post_add_new_portion
#
# Creates new portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_new_portion' } = { 
    	summary => 'Creates new portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub post_add_new_portion {
    warnings::warnif("deprecated", "post_add_new_portion is deprecated, use create_portion instead");
  
    return create_portion(@_);
}

#
# create_shape
#
# Create new shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param ShapeBase $dto Shape DTO. (optional)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '0',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_shape' } = { 
    	summary => 'Create new shape.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub create_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_new_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_new_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_to_clone'} && defined $args{'shape_to_clone'}) {
        $query_params->{'shapeToClone'} = $self->{api_client}->to_query_value($args{'shape_to_clone'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# post_add_new_shape
#
# Create new shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param ShapeBase $dto Shape DTO. (optional)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '0',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_new_shape' } = { 
    	summary => 'Create new shape.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub post_add_new_shape {
    warnings::warnif("deprecated", "post_add_new_shape is deprecated, use create_shape instead");
  
    return create_shape(@_);
}

#
# create_subshape
#
# Create new shape (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param ShapeBase $dto Shape DTO. (optional)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '0',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_subshape' } = { 
    	summary => 'Create new shape (for smart art and group shapes).',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub create_subshape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_new_subshape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_new_subshape");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling post_add_new_subshape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_to_clone'} && defined $args{'shape_to_clone'}) {
        $query_params->{'shapeToClone'} = $self->{api_client}->to_query_value($args{'shape_to_clone'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# post_add_new_subshape
#
# Create new shape (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param ShapeBase $dto Shape DTO. (optional)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '0',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_new_subshape' } = { 
    	summary => 'Create new shape (for smart art and group shapes).',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub post_add_new_subshape {
    warnings::warnif("deprecated", "post_add_new_subshape is deprecated, use create_subshape instead");
  
    return create_subshape(@_);
}

#
# create_subshape_paragraph
#
# Creates new paragraph (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_subshape_paragraph' } = { 
    	summary => 'Creates new paragraph (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub create_subshape_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_new_subshape_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_new_subshape_paragraph");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling post_add_new_subshape_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_add_new_subshape_paragraph");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_add_new_subshape_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# post_add_new_subshape_paragraph
#
# Creates new paragraph (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_new_subshape_paragraph' } = { 
    	summary => 'Creates new paragraph (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub post_add_new_subshape_paragraph {
    warnings::warnif("deprecated", "post_add_new_subshape_paragraph is deprecated, use create_subshape_paragraph instead");
  
    return create_subshape_paragraph(@_);
}

#
# create_subshape_portion
#
# Creates new portion (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_subshape_portion' } = { 
    	summary => 'Creates new portion (for smart art and group shapes).',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub create_subshape_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_new_subshape_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_new_subshape_portion");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling post_add_new_subshape_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_add_new_subshape_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling post_add_new_subshape_portion");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_add_new_subshape_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# post_add_new_subshape_portion
#
# Creates new portion (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_new_subshape_portion' } = { 
    	summary => 'Creates new portion (for smart art and group shapes).',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub post_add_new_subshape_portion {
    warnings::warnif("deprecated", "post_add_new_subshape_portion is deprecated, use create_subshape_portion instead");
  
    return create_subshape_portion(@_);
}

#
# create_notes_slide
#
# Add new notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param NotesSlide $dto A NotesSlide object with notes slide data. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'NotesSlide',
        description => 'A NotesSlide object with notes slide data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_notes_slide' } = { 
    	summary => 'Add new notes slide.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub create_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_add_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_add_notes_slide");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_add_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlide', $response);
    return $_response_object;
}

#
# post_add_notes_slide
#
# Add new notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param NotesSlide $dto A NotesSlide object with notes slide data. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'NotesSlide',
        description => 'A NotesSlide object with notes slide data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_add_notes_slide' } = { 
    	summary => 'Add new notes slide.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub post_add_notes_slide {
    warnings::warnif("deprecated", "post_add_notes_slide is deprecated, use create_notes_slide instead");
  
    return create_notes_slide(@_);
}

#
# align_shapes
#
# Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $alignment_type Alignment type that will be applied to the shapes. (required)
# @param boolean $align_to_slide If true, shapes will be aligned relative to the slide edges. (optional, default to false)
# @param string $shapes Shapes indexes. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'alignment_type' => {
        data_type => 'string',
        description => 'Alignment type that will be applied to the shapes.',
        required => '1',
    },
    'align_to_slide' => {
        data_type => 'boolean',
        description => 'If true, shapes will be aligned relative to the slide edges.',
        required => '0',
    },
    'shapes' => {
        data_type => 'string',
        description => 'Shapes indexes.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'align_shapes' } = { 
    	summary => 'Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub align_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_align_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_align_shapes");
    }

    # verify the required parameter 'alignment_type' is set
    unless (exists $args{'alignment_type'} && $args{'alignment_type'}) {
      croak("Missing the required parameter 'alignment_type' when calling post_align_shapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/align/{alignmentType}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'align_to_slide'} && defined $args{'align_to_slide'}) {
        $query_params->{'alignToSlide'} = $self->{api_client}->to_boolean_query_value($args{'align_to_slide'});
    }

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'alignment_type'}) {
        my $_base_variable = "{" . "alignmentType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'alignment_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# post_align_shapes
#
# Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $alignment_type Alignment type that will be applied to the shapes. (required)
# @param boolean $align_to_slide If true, shapes will be aligned relative to the slide edges. (optional, default to false)
# @param string $shapes Shapes indexes. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'alignment_type' => {
        data_type => 'string',
        description => 'Alignment type that will be applied to the shapes.',
        required => '1',
    },
    'align_to_slide' => {
        data_type => 'boolean',
        description => 'If true, shapes will be aligned relative to the slide edges.',
        required => '0',
    },
    'shapes' => {
        data_type => 'string',
        description => 'Shapes indexes.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_align_shapes' } = { 
    	summary => 'Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub post_align_shapes {
    warnings::warnif("deprecated", "post_align_shapes is deprecated, use align_shapes instead");
  
    return align_shapes(@_);
}

#
# create_chart_category
#
# Add a new category to a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param ChartCategory $category Category DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category' => {
        data_type => 'ChartCategory',
        description => 'Category DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_chart_category' } = { 
    	summary => 'Add a new category to a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub create_chart_category {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_chart_category");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_chart_category");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_chart_category");
    }

    # verify the required parameter 'category' is set
    unless (exists $args{'category'} && $args{'category'}) {
      croak("Missing the required parameter 'category' when calling post_chart_category");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'category'}) {
        $_body_data = $args{'category'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# post_chart_category
#
# Add a new category to a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param ChartCategory $category Category DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category' => {
        data_type => 'ChartCategory',
        description => 'Category DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_chart_category' } = { 
    	summary => 'Add a new category to a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub post_chart_category {
    warnings::warnif("deprecated", "post_chart_category is deprecated, use create_chart_category instead");
  
    return create_chart_category(@_);
}

#
# create_chart_data_point
#
# Add a new data point to a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param DataPoint $data_point Data point DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'data_point' => {
        data_type => 'DataPoint',
        description => 'Data point DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_chart_data_point' } = { 
    	summary => 'Add a new data point to a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub create_chart_data_point {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_chart_data_point");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_chart_data_point");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_chart_data_point");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling post_chart_data_point");
    }

    # verify the required parameter 'data_point' is set
    unless (exists $args{'data_point'} && $args{'data_point'}) {
      croak("Missing the required parameter 'data_point' when calling post_chart_data_point");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'data_point'}) {
        $_body_data = $args{'data_point'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# post_chart_data_point
#
# Add a new data point to a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param DataPoint $data_point Data point DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'data_point' => {
        data_type => 'DataPoint',
        description => 'Data point DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_chart_data_point' } = { 
    	summary => 'Add a new data point to a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub post_chart_data_point {
    warnings::warnif("deprecated", "post_chart_data_point is deprecated, use create_chart_data_point instead");
  
    return create_chart_data_point(@_);
}

#
# create_chart_series
#
# Add a new series to a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param Series $series Series DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series' => {
        data_type => 'Series',
        description => 'Series DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_chart_series' } = { 
    	summary => 'Add a new series to a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub create_chart_series {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_chart_series");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_chart_series");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_chart_series");
    }

    # verify the required parameter 'series' is set
    unless (exists $args{'series'} && $args{'series'}) {
      croak("Missing the required parameter 'series' when calling post_chart_series");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'series'}) {
        $_body_data = $args{'series'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# post_chart_series
#
# Add a new series to a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param Series $series Series DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series' => {
        data_type => 'Series',
        description => 'Series DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_chart_series' } = { 
    	summary => 'Add a new series to a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub post_chart_series {
    warnings::warnif("deprecated", "post_chart_series is deprecated, use create_chart_series instead");
  
    return create_chart_series(@_);
}

#
# copy_layout_slide
#
# Copy layoutSlide from source presentation.
# 
# @param string $name Document name. (required)
# @param string $clone_from Name of the document to clone layoutSlide from. (required)
# @param int $clone_from_position Position of cloned layout slide. (required)
# @param string $clone_from_password Password for the document to clone layoutSlide from. (optional)
# @param string $clone_from_storage Storage of the document to clone layoutSlide from. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'clone_from' => {
        data_type => 'string',
        description => 'Name of the document to clone layoutSlide from.',
        required => '1',
    },
    'clone_from_position' => {
        data_type => 'int',
        description => 'Position of cloned layout slide.',
        required => '1',
    },
    'clone_from_password' => {
        data_type => 'string',
        description => 'Password for the document to clone layoutSlide from.',
        required => '0',
    },
    'clone_from_storage' => {
        data_type => 'string',
        description => 'Storage of the document to clone layoutSlide from.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_layout_slide' } = { 
    	summary => 'Copy layoutSlide from source presentation.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub copy_layout_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_copy_layout_slide_from_source_presentation");
    }

    # verify the required parameter 'clone_from' is set
    unless (exists $args{'clone_from'} && $args{'clone_from'}) {
      croak("Missing the required parameter 'clone_from' when calling post_copy_layout_slide_from_source_presentation");
    }

    # verify the required parameter 'clone_from_position' is set
    unless (exists $args{'clone_from_position'}) {
      croak("Missing the required parameter 'clone_from_position' when calling post_copy_layout_slide_from_source_presentation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'clone_from'} && defined $args{'clone_from'}) {
        $query_params->{'cloneFrom'} = $self->{api_client}->to_query_value($args{'clone_from'});
    }

    # query params
    if (exists $args{'clone_from_position'} && defined $args{'clone_from_position'}) {
        $query_params->{'cloneFromPosition'} = $self->{api_client}->to_query_value($args{'clone_from_position'});
    }

    # query params
    if (exists $args{'clone_from_storage'} && defined $args{'clone_from_storage'}) {
        $query_params->{'cloneFromStorage'} = $self->{api_client}->to_query_value($args{'clone_from_storage'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'clone_from_password'}) {
        $header_params->{':cloneFromPassword'} = $self->{api_client}->to_header_value($args{'clone_from_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlide', $response);
    return $_response_object;
}

#
# post_copy_layout_slide_from_source_presentation
#
# Copy layoutSlide from source presentation.
# 
# @param string $name Document name. (required)
# @param string $clone_from Name of the document to clone layoutSlide from. (required)
# @param int $clone_from_position Position of cloned layout slide. (required)
# @param string $clone_from_password Password for the document to clone layoutSlide from. (optional)
# @param string $clone_from_storage Storage of the document to clone layoutSlide from. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'clone_from' => {
        data_type => 'string',
        description => 'Name of the document to clone layoutSlide from.',
        required => '1',
    },
    'clone_from_position' => {
        data_type => 'int',
        description => 'Position of cloned layout slide.',
        required => '1',
    },
    'clone_from_password' => {
        data_type => 'string',
        description => 'Password for the document to clone layoutSlide from.',
        required => '0',
    },
    'clone_from_storage' => {
        data_type => 'string',
        description => 'Storage of the document to clone layoutSlide from.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_copy_layout_slide_from_source_presentation' } = { 
    	summary => 'Copy layoutSlide from source presentation.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub post_copy_layout_slide_from_source_presentation {
    warnings::warnif("deprecated", "post_copy_layout_slide_from_source_presentation is deprecated, use copy_layout_slide instead");
  
    return copy_layout_slide(@_);
}

#
# copy_master_slide
#
# Copy masterSlide from source presentation.
# 
# @param string $name Document name. (required)
# @param string $clone_from Name of the document to clone masterSlide from. (required)
# @param int $clone_from_position Position of cloned master slide. (required)
# @param string $clone_from_password Password for the document to clone masterSlide from. (optional)
# @param string $clone_from_storage Storage of the document to clone masterSlide from. (optional)
# @param boolean $apply_to_all True to apply cloned master slide to every existing slide. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'clone_from' => {
        data_type => 'string',
        description => 'Name of the document to clone masterSlide from.',
        required => '1',
    },
    'clone_from_position' => {
        data_type => 'int',
        description => 'Position of cloned master slide.',
        required => '1',
    },
    'clone_from_password' => {
        data_type => 'string',
        description => 'Password for the document to clone masterSlide from.',
        required => '0',
    },
    'clone_from_storage' => {
        data_type => 'string',
        description => 'Storage of the document to clone masterSlide from.',
        required => '0',
    },
    'apply_to_all' => {
        data_type => 'boolean',
        description => 'True to apply cloned master slide to every existing slide.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_master_slide' } = { 
    	summary => 'Copy masterSlide from source presentation.',
        params => $params,
        returns => 'MasterSlide',
        };
}
# @return MasterSlide
#
sub copy_master_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_copy_master_slide_from_source_presentation");
    }

    # verify the required parameter 'clone_from' is set
    unless (exists $args{'clone_from'} && $args{'clone_from'}) {
      croak("Missing the required parameter 'clone_from' when calling post_copy_master_slide_from_source_presentation");
    }

    # verify the required parameter 'clone_from_position' is set
    unless (exists $args{'clone_from_position'}) {
      croak("Missing the required parameter 'clone_from_position' when calling post_copy_master_slide_from_source_presentation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'clone_from'} && defined $args{'clone_from'}) {
        $query_params->{'cloneFrom'} = $self->{api_client}->to_query_value($args{'clone_from'});
    }

    # query params
    if (exists $args{'clone_from_position'} && defined $args{'clone_from_position'}) {
        $query_params->{'cloneFromPosition'} = $self->{api_client}->to_query_value($args{'clone_from_position'});
    }

    # query params
    if (exists $args{'clone_from_storage'} && defined $args{'clone_from_storage'}) {
        $query_params->{'cloneFromStorage'} = $self->{api_client}->to_query_value($args{'clone_from_storage'});
    }

    # query params
    if (exists $args{'apply_to_all'} && defined $args{'apply_to_all'}) {
        $query_params->{'applyToAll'} = $self->{api_client}->to_boolean_query_value($args{'apply_to_all'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'clone_from_password'}) {
        $header_params->{':cloneFromPassword'} = $self->{api_client}->to_header_value($args{'clone_from_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlide', $response);
    return $_response_object;
}

#
# post_copy_master_slide_from_source_presentation
#
# Copy masterSlide from source presentation.
# 
# @param string $name Document name. (required)
# @param string $clone_from Name of the document to clone masterSlide from. (required)
# @param int $clone_from_position Position of cloned master slide. (required)
# @param string $clone_from_password Password for the document to clone masterSlide from. (optional)
# @param string $clone_from_storage Storage of the document to clone masterSlide from. (optional)
# @param boolean $apply_to_all True to apply cloned master slide to every existing slide. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'clone_from' => {
        data_type => 'string',
        description => 'Name of the document to clone masterSlide from.',
        required => '1',
    },
    'clone_from_position' => {
        data_type => 'int',
        description => 'Position of cloned master slide.',
        required => '1',
    },
    'clone_from_password' => {
        data_type => 'string',
        description => 'Password for the document to clone masterSlide from.',
        required => '0',
    },
    'clone_from_storage' => {
        data_type => 'string',
        description => 'Storage of the document to clone masterSlide from.',
        required => '0',
    },
    'apply_to_all' => {
        data_type => 'boolean',
        description => 'True to apply cloned master slide to every existing slide.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_copy_master_slide_from_source_presentation' } = { 
    	summary => 'Copy masterSlide from source presentation.',
        params => $params,
        returns => 'MasterSlide',
        };
}
# @return MasterSlide
#
sub post_copy_master_slide_from_source_presentation {
    warnings::warnif("deprecated", "post_copy_master_slide_from_source_presentation is deprecated, use copy_master_slide instead");
  
    return copy_master_slide(@_);
}

#
# download_image_default_format_online
#
# Get image binary data.
# 
# @param File $document Document data. (required)
# @param int $index Image index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image_default_format_online' } = { 
    	summary => 'Get image binary data.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image_default_format_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_export_image_with_default_format");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling post_export_image_with_default_format");
    }

    # parse inputs
    my $_resource_path = '/slides/images/{index}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_image_with_default_format
#
# Get image binary data.
# 
# @param File $document Document data. (required)
# @param int $index Image index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_image_with_default_format' } = { 
    	summary => 'Get image binary data.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_image_with_default_format {
    warnings::warnif("deprecated", "post_export_image_with_default_format is deprecated, use download_image_default_format_online instead");
  
    return download_image_default_format_online(@_);
}

#
# download_image_online
#
# Get image in specified format.
# 
# @param File $document Document data. (required)
# @param int $index Image index. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image_online' } = { 
    	summary => 'Get image in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_export_image_with_format");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling post_export_image_with_format");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_export_image_with_format");
    }

    # parse inputs
    my $_resource_path = '/slides/images/{index}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_image_with_format
#
# Get image in specified format.
# 
# @param File $document Document data. (required)
# @param int $index Image index. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_image_with_format' } = { 
    	summary => 'Get image in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_image_with_format {
    warnings::warnif("deprecated", "post_export_image_with_format is deprecated, use download_image_online instead");
  
    return download_image_online(@_);
}

#
# download_images_online
#
# Get all presentation images in specified format. 
# 
# @param File $document Document data. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images_online' } = { 
    	summary => 'Get all presentation images in specified format. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_export_images_from_request_with_format");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_export_images_from_request_with_format");
    }

    # parse inputs
    my $_resource_path = '/slides/images/download/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_images_from_request_with_format
#
# Get all presentation images in specified format. 
# 
# @param File $document Document data. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_images_from_request_with_format' } = { 
    	summary => 'Get all presentation images in specified format. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_images_from_request_with_format {
    warnings::warnif("deprecated", "post_export_images_from_request_with_format is deprecated, use download_images_online instead");
  
    return download_images_online(@_);
}

#
# download_images_default_format
#
# Get all presentation images.
# 
# @param string $name  (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images_default_format' } = { 
    	summary => 'Get all presentation images.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images_default_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_export_images_with_default_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/download';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_images_with_default_format
#
# Get all presentation images.
# 
# @param string $name  (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_images_with_default_format' } = { 
    	summary => 'Get all presentation images.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_images_with_default_format {
    warnings::warnif("deprecated", "post_export_images_with_default_format is deprecated, use download_images_default_format instead");
  
    return download_images_default_format(@_);
}

#
# download_images
#
# Get all presentation images in specified format.
# 
# @param string $name  (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images' } = { 
    	summary => 'Get all presentation images in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_export_images_with_format");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_export_images_with_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/download/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_images_with_format
#
# Get all presentation images in specified format.
# 
# @param string $name  (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_images_with_format' } = { 
    	summary => 'Get all presentation images in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_images_with_format {
    warnings::warnif("deprecated", "post_export_images_with_format is deprecated, use download_images instead");
  
    return download_images(@_);
}

#
# download_shape_online
#
# Render shape to specified picture format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_shape_online' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_shape_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_export_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_export_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_export_shape");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_export_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_shape
#
# Render shape to specified picture format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_shape {
    warnings::warnif("deprecated", "post_export_shape is deprecated, use download_shape_online instead");
  
    return download_shape_online(@_);
}

#
# download_slide_online
#
# Save a slide to a specified format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width Output file width; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height Output file height; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_slide_online' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_export_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_export_slide");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_export_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_export_slide
#
# Save a slide to a specified format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width Output file width; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height Output file height; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_export_slide' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_export_slide {
    warnings::warnif("deprecated", "post_export_slide is deprecated, use download_slide_online instead");
  
    return download_slide_online(@_);
}

#
# get_notes_slide_online
#
# Read notes slide info.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_online' } = { 
    	summary => 'Read notes slide info.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub get_notes_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_get_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_get_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/notesSlide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlide', $response);
    return $_response_object;
}

#
# post_get_notes_slide
#
# Read notes slide info.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_get_notes_slide' } = { 
    	summary => 'Read notes slide info.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub post_get_notes_slide {
    warnings::warnif("deprecated", "post_get_notes_slide is deprecated, use get_notes_slide_online instead");
  
    return get_notes_slide_online(@_);
}

#
# notes_slide_exists_online
#
# Get info whether a notes slide exists.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'notes_slide_exists_online' } = { 
    	summary => 'Get info whether a notes slide exists.',
        params => $params,
        returns => 'EntityExists',
        };
}
# @return EntityExists
#
sub notes_slide_exists_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_get_notes_slide_exists");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_get_notes_slide_exists");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/notesSlide/exist';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('EntityExists', $response);
    return $_response_object;
}

#
# post_get_notes_slide_exists
#
# Get info whether a notes slide exists.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_get_notes_slide_exists' } = { 
    	summary => 'Get info whether a notes slide exists.',
        params => $params,
        returns => 'EntityExists',
        };
}
# @return EntityExists
#
sub post_get_notes_slide_exists {
    warnings::warnif("deprecated", "post_get_notes_slide_exists is deprecated, use notes_slide_exists_online instead");
  
    return notes_slide_exists_online(@_);
}

#
# download_notes_slide_online
#
# Convert notes slide to the specified image format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width Output file width. (optional)
# @param int $height Output file height. (optional)
# @param string $password Document password. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_notes_slide_online' } = { 
    	summary => 'Convert notes slide to the specified image format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_notes_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_get_notes_slide_with_format");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_get_notes_slide_with_format");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_get_notes_slide_with_format");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/notesSlide/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_get_notes_slide_with_format
#
# Convert notes slide to the specified image format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width Output file width. (optional)
# @param int $height Output file height. (optional)
# @param string $password Document password. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_get_notes_slide_with_format' } = { 
    	summary => 'Convert notes slide to the specified image format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_get_notes_slide_with_format {
    warnings::warnif("deprecated", "post_get_notes_slide_with_format is deprecated, use download_notes_slide_online instead");
  
    return download_notes_slide_online(@_);
}

#
# download_images_default_format_online
#
# Get all presentation images.
# 
# @param File $document Document data. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images_default_format_online' } = { 
    	summary => 'Get all presentation images.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images_default_format_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_images_from_request_with_default_format");
    }

    # parse inputs
    my $_resource_path = '/slides/images/download';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_images_from_request_with_default_format
#
# Get all presentation images.
# 
# @param File $document Document data. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_images_from_request_with_default_format' } = { 
    	summary => 'Get all presentation images.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_images_from_request_with_default_format {
    warnings::warnif("deprecated", "post_images_from_request_with_default_format is deprecated, use download_images_default_format_online instead");
  
    return download_images_default_format_online(@_);
}

#
# create_notes_slide_paragraph
#
# Creates new paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_notes_slide_paragraph' } = { 
    	summary => 'Creates new paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub create_notes_slide_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_notes_slide_add_new_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_notes_slide_add_new_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_notes_slide_add_new_paragraph");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_notes_slide_add_new_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# post_notes_slide_add_new_paragraph
#
# Creates new paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_notes_slide_add_new_paragraph' } = { 
    	summary => 'Creates new paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub post_notes_slide_add_new_paragraph {
    warnings::warnif("deprecated", "post_notes_slide_add_new_paragraph is deprecated, use create_notes_slide_paragraph instead");
  
    return create_notes_slide_paragraph(@_);
}

#
# create_notes_slide_portion
#
# Creates new portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_notes_slide_portion' } = { 
    	summary => 'Creates new portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub create_notes_slide_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_notes_slide_add_new_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_notes_slide_add_new_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_notes_slide_add_new_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling post_notes_slide_add_new_portion");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_notes_slide_add_new_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# post_notes_slide_add_new_portion
#
# Creates new portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_notes_slide_add_new_portion' } = { 
    	summary => 'Creates new portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub post_notes_slide_add_new_portion {
    warnings::warnif("deprecated", "post_notes_slide_add_new_portion is deprecated, use create_notes_slide_portion instead");
  
    return create_notes_slide_portion(@_);
}

#
# create_notes_slide_shape
#
# Create new shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param ShapeBase $dto Shape DTO. (required)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '1',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_notes_slide_shape' } = { 
    	summary => 'Create new shape.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub create_notes_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_notes_slide_add_new_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_notes_slide_add_new_shape");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling post_notes_slide_add_new_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_to_clone'} && defined $args{'shape_to_clone'}) {
        $query_params->{'shapeToClone'} = $self->{api_client}->to_query_value($args{'shape_to_clone'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# post_notes_slide_add_new_shape
#
# Create new shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param ShapeBase $dto Shape DTO. (required)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '1',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_notes_slide_add_new_shape' } = { 
    	summary => 'Create new shape.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub post_notes_slide_add_new_shape {
    warnings::warnif("deprecated", "post_notes_slide_add_new_shape is deprecated, use create_notes_slide_shape instead");
  
    return create_notes_slide_shape(@_);
}

#
# download_notes_slide_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_notes_slide_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_notes_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_notes_slide_shape_save_as");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_notes_slide_shape_save_as");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_notes_slide_shape_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_notes_slide_shape_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_notes_slide_shape_save_as
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_notes_slide_shape_save_as' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_notes_slide_shape_save_as {
    warnings::warnif("deprecated", "post_notes_slide_shape_save_as is deprecated, use download_notes_slide_shape instead");
  
    return download_notes_slide_shape(@_);
}

#
# merge
#
# Merge the presentation with other presentations specified in the request parameter.
# 
# @param string $name Document name. (required)
# @param PresentationsMergeRequest $request PresentationsMergeRequest with a list of presentations to merge. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'request' => {
        data_type => 'PresentationsMergeRequest',
        description => 'PresentationsMergeRequest with a list of presentations to merge.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'merge' } = { 
    	summary => 'Merge the presentation with other presentations specified in the request parameter.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_presentation_merge");
    }

    # verify the required parameter 'request' is set
    unless (exists $args{'request'} && $args{'request'}) {
      croak("Missing the required parameter 'request' when calling post_presentation_merge");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# post_presentation_merge
#
# Merge the presentation with other presentations specified in the request parameter.
# 
# @param string $name Document name. (required)
# @param PresentationsMergeRequest $request PresentationsMergeRequest with a list of presentations to merge. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'request' => {
        data_type => 'PresentationsMergeRequest',
        description => 'PresentationsMergeRequest with a list of presentations to merge.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_presentation_merge' } = { 
    	summary => 'Merge the presentation with other presentations specified in the request parameter.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub post_presentation_merge {
    warnings::warnif("deprecated", "post_presentation_merge is deprecated, use merge instead");
  
    return merge(@_);
}

#
# replace_presentation_text_online
#
# Replace text with a new value.
# 
# @param File $document Document data. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_presentation_text_online' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_presentation_text_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_presentation_replace_text");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling post_presentation_replace_text");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling post_presentation_replace_text");
    }

    # parse inputs
    my $_resource_path = '/slides/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_presentation_replace_text
#
# Replace text with a new value.
# 
# @param File $document Document data. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_presentation_replace_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_presentation_replace_text {
    warnings::warnif("deprecated", "post_presentation_replace_text is deprecated, use replace_presentation_text_online instead");
  
    return replace_presentation_text_online(@_);
}

#
# split_online
#
# Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. 
# 
# @param File $document Document data. (required)
# @param string $format ExportFormat (required)
# @param int $width Slide width. (optional)
# @param int $height Slide height. (optional)
# @param int $from The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation. (optional)
# @param int $to The last slide number for splitting, if is not specified splitting ends at the last slide of the document. (optional)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'ExportFormat',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Slide width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Slide height.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'The last slide number for splitting, if is not specified splitting ends at the last slide of the document.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'split_online' } = { 
    	summary => 'Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub split_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_presentation_split");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_presentation_split");
    }

    # parse inputs
    my $_resource_path = '/slides/split/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'from'} && defined $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if (exists $args{'to'} && defined $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_presentation_split
#
# Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. 
# 
# @param File $document Document data. (required)
# @param string $format ExportFormat (required)
# @param int $width Slide width. (optional)
# @param int $height Slide height. (optional)
# @param int $from The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation. (optional)
# @param int $to The last slide number for splitting, if is not specified splitting ends at the last slide of the document. (optional)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'ExportFormat',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Slide width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Slide height.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'The last slide number for splitting, if is not specified splitting ends at the last slide of the document.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_presentation_split' } = { 
    	summary => 'Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_presentation_split {
    warnings::warnif("deprecated", "post_presentation_split is deprecated, use split_online instead");
  
    return split_online(@_);
}

#
# create_section
#
# Create a section starting at a specified slide index.
# 
# @param string $name Document name. (required)
# @param string $section_name Section name. (required)
# @param int $slide_index Slide index (one-based). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_name' => {
        data_type => 'string',
        description => 'Section name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index (one-based).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_section' } = { 
    	summary => 'Create a section starting at a specified slide index.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub create_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_section");
    }

    # verify the required parameter 'section_name' is set
    unless (exists $args{'section_name'} && $args{'section_name'}) {
      croak("Missing the required parameter 'section_name' when calling post_section");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_section");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'section_name'} && defined $args{'section_name'}) {
        $query_params->{'sectionName'} = $self->{api_client}->to_query_value($args{'section_name'});
    }

    # query params
    if (exists $args{'slide_index'} && defined $args{'slide_index'}) {
        $query_params->{'slideIndex'} = $self->{api_client}->to_query_value($args{'slide_index'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# post_section
#
# Create a section starting at a specified slide index.
# 
# @param string $name Document name. (required)
# @param string $section_name Section name. (required)
# @param int $slide_index Slide index (one-based). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_name' => {
        data_type => 'string',
        description => 'Section name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index (one-based).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_section' } = { 
    	summary => 'Create a section starting at a specified slide index.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub post_section {
    warnings::warnif("deprecated", "post_section is deprecated, use create_section instead");
  
    return create_section(@_);
}

#
# move_section
#
# Move presentation section to a specified position.
# 
# @param string $name Document name. (required)
# @param int $section_index The position of the section to be reordered. (required)
# @param int $new_position The new position of the reordered section. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'The position of the section to be reordered.',
        required => '1',
    },
    'new_position' => {
        data_type => 'int',
        description => 'The new position of the reordered section.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_section' } = { 
    	summary => 'Move presentation section to a specified position.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub move_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_section_move");
    }

    # verify the required parameter 'section_index' is set
    unless (exists $args{'section_index'}) {
      croak("Missing the required parameter 'section_index' when calling post_section_move");
    }

    # verify the required parameter 'new_position' is set
    unless (exists $args{'new_position'}) {
      croak("Missing the required parameter 'new_position' when calling post_section_move");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections/{sectionIndex}/move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'new_position'} && defined $args{'new_position'}) {
        $query_params->{'newPosition'} = $self->{api_client}->to_query_value($args{'new_position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'section_index'}) {
        my $_base_variable = "{" . "sectionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'section_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# post_section_move
#
# Move presentation section to a specified position.
# 
# @param string $name Document name. (required)
# @param int $section_index The position of the section to be reordered. (required)
# @param int $new_position The new position of the reordered section. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'The position of the section to be reordered.',
        required => '1',
    },
    'new_position' => {
        data_type => 'int',
        description => 'The new position of the reordered section.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_section_move' } = { 
    	summary => 'Move presentation section to a specified position.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub post_section_move {
    warnings::warnif("deprecated", "post_section_move is deprecated, use move_section instead");
  
    return move_section(@_);
}

#
# download_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_shape_save_as");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_shape_save_as");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_shape_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_shape_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_shape_save_as
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_shape_save_as' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_shape_save_as {
    warnings::warnif("deprecated", "post_shape_save_as is deprecated, use download_shape instead");
  
    return download_shape(@_);
}

#
# create_animation_effect
#
# Add an effect to slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_animation_effect' } = { 
    	summary => 'Add an effect to slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_animation_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slide_animation_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slide_animation_effect");
    }

    # verify the required parameter 'effect' is set
    unless (exists $args{'effect'} && $args{'effect'}) {
      croak("Missing the required parameter 'effect' when calling post_slide_animation_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/mainSequence';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'effect'}) {
        $_body_data = $args{'effect'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# post_slide_animation_effect
#
# Add an effect to slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slide_animation_effect' } = { 
    	summary => 'Add an effect to slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub post_slide_animation_effect {
    warnings::warnif("deprecated", "post_slide_animation_effect is deprecated, use create_animation_effect instead");
  
    return create_animation_effect(@_);
}

#
# create_animation_interactive_sequence
#
# Set slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param InteractiveSequence $sequence Animation sequence DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence' => {
        data_type => 'InteractiveSequence',
        description => 'Animation sequence DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_animation_interactive_sequence' } = { 
    	summary => 'Set slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_animation_interactive_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'sequence' is set
    unless (exists $args{'sequence'} && $args{'sequence'}) {
      croak("Missing the required parameter 'sequence' when calling post_slide_animation_interactive_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'sequence'}) {
        $_body_data = $args{'sequence'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# post_slide_animation_interactive_sequence
#
# Set slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param InteractiveSequence $sequence Animation sequence DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence' => {
        data_type => 'InteractiveSequence',
        description => 'Animation sequence DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slide_animation_interactive_sequence' } = { 
    	summary => 'Set slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub post_slide_animation_interactive_sequence {
    warnings::warnif("deprecated", "post_slide_animation_interactive_sequence is deprecated, use create_animation_interactive_sequence instead");
  
    return create_animation_interactive_sequence(@_);
}

#
# create_animation_interactive_sequence_effect
#
# Add an animation effect to a slide interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index The position of the interactive sequence. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The position of the interactive sequence.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_animation_interactive_sequence_effect' } = { 
    	summary => 'Add an animation effect to a slide interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_animation_interactive_sequence_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling post_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'effect' is set
    unless (exists $args{'effect'} && $args{'effect'}) {
      croak("Missing the required parameter 'effect' when calling post_slide_animation_interactive_sequence_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'effect'}) {
        $_body_data = $args{'effect'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# post_slide_animation_interactive_sequence_effect
#
# Add an animation effect to a slide interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index The position of the interactive sequence. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The position of the interactive sequence.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slide_animation_interactive_sequence_effect' } = { 
    	summary => 'Add an animation effect to a slide interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub post_slide_animation_interactive_sequence_effect {
    warnings::warnif("deprecated", "post_slide_animation_interactive_sequence_effect is deprecated, use create_animation_interactive_sequence_effect instead");
  
    return create_animation_interactive_sequence_effect(@_);
}

#
# replace_slide_text_online
#
# Replace slide text with a new value.
# 
# @param File $document Document data. (required)
# @param int $slide_index Index of target slide. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Index of target slide.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_slide_text_online' } = { 
    	summary => 'Replace slide text with a new value.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_slide_text_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_slide_replace_text");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slide_replace_text");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling post_slide_replace_text");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling post_slide_replace_text");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_slide_replace_text
#
# Replace slide text with a new value.
# 
# @param File $document Document data. (required)
# @param int $slide_index Index of target slide. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Index of target slide.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slide_replace_text' } = { 
    	summary => 'Replace slide text with a new value.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_slide_replace_text {
    warnings::warnif("deprecated", "post_slide_replace_text is deprecated, use replace_slide_text_online instead");
  
    return replace_slide_text_online(@_);
}

#
# download_slide
#
# Save a slide to a specified format.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param ExportOptions $options Export options. (optional)
# @param int $width Output file width; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height Output file height; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_slide' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slide_save_as");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slide_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_slide_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_slide_save_as
#
# Save a slide to a specified format.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param ExportOptions $options Export options. (optional)
# @param int $width Output file width; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height Output file height; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slide_save_as' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_slide_save_as {
    warnings::warnif("deprecated", "post_slide_save_as is deprecated, use download_slide instead");
  
    return download_slide(@_);
}

#
# create_slide
#
# Create a slide.
# 
# @param string $name Document name. (required)
# @param string $layout_alias Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index (optional)
# @param int $position The target position at which to create the slide. Add to the end by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'layout_alias' => {
        data_type => 'string',
        description => 'Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'The target position at which to create the slide. Add to the end by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_slide' } = { 
    	summary => 'Create a slide.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub create_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_add");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'layout_alias'} && defined $args{'layout_alias'}) {
        $query_params->{'layoutAlias'} = $self->{api_client}->to_query_value($args{'layout_alias'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# post_slides_add
#
# Create a slide.
# 
# @param string $name Document name. (required)
# @param string $layout_alias Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index (optional)
# @param int $position The target position at which to create the slide. Add to the end by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'layout_alias' => {
        data_type => 'string',
        description => 'Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'The target position at which to create the slide. Add to the end by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_add' } = { 
    	summary => 'Create a slide.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub post_slides_add {
    warnings::warnif("deprecated", "post_slides_add is deprecated, use create_slide instead");
  
    return create_slide(@_);
}

#
# convert
#
# Convert presentation from request content to format specified.
# 
# @param File $document Document data. (required)
# @param string $format Export format. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'convert' } = { 
    	summary => 'Convert presentation from request content to format specified.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub convert {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling post_slides_convert");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_slides_convert");
    }

    # parse inputs
    my $_resource_path = '/slides/convert/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_slides_convert
#
# Convert presentation from request content to format specified.
# 
# @param File $document Document data. (required)
# @param string $format Export format. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_convert' } = { 
    	summary => 'Convert presentation from request content to format specified.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_slides_convert {
    warnings::warnif("deprecated", "post_slides_convert is deprecated, use convert instead");
  
    return convert(@_);
}

#
# copy_slide
#
# Copy a slide from the current or another presentation.
# 
# @param string $name Document name. (required)
# @param int $slide_to_copy The index of the slide to be copied from the source presentation. (required)
# @param int $position The target position at which to copy the slide. Copy to the end by default. (optional)
# @param string $source Name of the document to copy a slide from. (optional)
# @param string $source_password Password for the document to copy a slide from. (optional)
# @param string $source_storage Template storage name. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_to_copy' => {
        data_type => 'int',
        description => 'The index of the slide to be copied from the source presentation.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'The target position at which to copy the slide. Copy to the end by default.',
        required => '0',
    },
    'source' => {
        data_type => 'string',
        description => 'Name of the document to copy a slide from.',
        required => '0',
    },
    'source_password' => {
        data_type => 'string',
        description => 'Password for the document to copy a slide from.',
        required => '0',
    },
    'source_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_slide' } = { 
    	summary => 'Copy a slide from the current or another presentation.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub copy_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_copy");
    }

    # verify the required parameter 'slide_to_copy' is set
    unless (exists $args{'slide_to_copy'}) {
      croak("Missing the required parameter 'slide_to_copy' when calling post_slides_copy");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'slide_to_copy'} && defined $args{'slide_to_copy'}) {
        $query_params->{'slideToCopy'} = $self->{api_client}->to_query_value($args{'slide_to_copy'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'source'} && defined $args{'source'}) {
        $query_params->{'source'} = $self->{api_client}->to_query_value($args{'source'});
    }

    # query params
    if (exists $args{'source_storage'} && defined $args{'source_storage'}) {
        $query_params->{'sourceStorage'} = $self->{api_client}->to_query_value($args{'source_storage'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'source_password'}) {
        $header_params->{':sourcePassword'} = $self->{api_client}->to_header_value($args{'source_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# post_slides_copy
#
# Copy a slide from the current or another presentation.
# 
# @param string $name Document name. (required)
# @param int $slide_to_copy The index of the slide to be copied from the source presentation. (required)
# @param int $position The target position at which to copy the slide. Copy to the end by default. (optional)
# @param string $source Name of the document to copy a slide from. (optional)
# @param string $source_password Password for the document to copy a slide from. (optional)
# @param string $source_storage Template storage name. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_to_copy' => {
        data_type => 'int',
        description => 'The index of the slide to be copied from the source presentation.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'The target position at which to copy the slide. Copy to the end by default.',
        required => '0',
    },
    'source' => {
        data_type => 'string',
        description => 'Name of the document to copy a slide from.',
        required => '0',
    },
    'source_password' => {
        data_type => 'string',
        description => 'Password for the document to copy a slide from.',
        required => '0',
    },
    'source_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_copy' } = { 
    	summary => 'Copy a slide from the current or another presentation.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub post_slides_copy {
    warnings::warnif("deprecated", "post_slides_copy is deprecated, use copy_slide instead");
  
    return copy_slide(@_);
}

#
# create_presentation
#
# Create a presentation.
# 
# @param string $name Document name. (required)
# @param File $data Document input data. (optional)
# @param string $input_password The password for input document. (optional)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'data' => {
        data_type => 'File',
        description => 'Document input data.',
        required => '0',
    },
    'input_password' => {
        data_type => 'string',
        description => 'The password for input document.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_presentation' } = { 
    	summary => 'Create a presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub create_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_document");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'input_password'}) {
        $header_params->{':inputPassword'} = $self->{api_client}->to_header_value($args{'input_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'data'} ) {
        $_body_data = $args{'data'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# post_slides_document
#
# Create a presentation.
# 
# @param string $name Document name. (required)
# @param File $data Document input data. (optional)
# @param string $input_password The password for input document. (optional)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'data' => {
        data_type => 'File',
        description => 'Document input data.',
        required => '0',
    },
    'input_password' => {
        data_type => 'string',
        description => 'The password for input document.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_document' } = { 
    	summary => 'Create a presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub post_slides_document {
    warnings::warnif("deprecated", "post_slides_document is deprecated, use create_presentation instead");
  
    return create_presentation(@_);
}

#
# import_from_html
#
# Create presentation document from html.
# 
# @param string $name Document name. (required)
# @param string $html HTML data. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'html' => {
        data_type => 'string',
        description => 'HTML data.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'import_from_html' } = { 
    	summary => 'Create presentation document from html.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub import_from_html {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_document_from_html");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromHtml';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'html'}) {
        $_body_data = $args{'html'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# post_slides_document_from_html
#
# Create presentation document from html.
# 
# @param string $name Document name. (required)
# @param string $html HTML data. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'html' => {
        data_type => 'string',
        description => 'HTML data.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_document_from_html' } = { 
    	summary => 'Create presentation document from html.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub post_slides_document_from_html {
    warnings::warnif("deprecated", "post_slides_document_from_html is deprecated, use import_from_html instead");
  
    return import_from_html(@_);
}

#
# import_from_pdf
#
# Create presentation document from pdf or append pdf to an existing presentation.
# 
# @param string $name Document name. (required)
# @param File $pdf PDF data. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'pdf' => {
        data_type => 'File',
        description => 'PDF data.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'import_from_pdf' } = { 
    	summary => 'Create presentation document from pdf or append pdf to an existing presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub import_from_pdf {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_document_from_pdf");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromPdf';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'pdf'} ) {
        $_body_data = $args{'pdf'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# post_slides_document_from_pdf
#
# Create presentation document from pdf or append pdf to an existing presentation.
# 
# @param string $name Document name. (required)
# @param File $pdf PDF data. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'pdf' => {
        data_type => 'File',
        description => 'PDF data.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_document_from_pdf' } = { 
    	summary => 'Create presentation document from pdf or append pdf to an existing presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub post_slides_document_from_pdf {
    warnings::warnif("deprecated", "post_slides_document_from_pdf is deprecated, use import_from_pdf instead");
  
    return import_from_pdf(@_);
}

#
# create_presentation_from_source
#
# Create a presentation from an existing source.
# 
# @param string $name Document name. (required)
# @param string $source_path Template file path. (optional)
# @param string $source_password Template file password. (optional)
# @param string $source_storage Template storage name. (optional)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'source_path' => {
        data_type => 'string',
        description => 'Template file path.',
        required => '0',
    },
    'source_password' => {
        data_type => 'string',
        description => 'Template file password.',
        required => '0',
    },
    'source_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_presentation_from_source' } = { 
    	summary => 'Create a presentation from an existing source.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub create_presentation_from_source {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_document_from_source");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromSource';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'source_path'} && defined $args{'source_path'}) {
        $query_params->{'sourcePath'} = $self->{api_client}->to_query_value($args{'source_path'});
    }

    # query params
    if (exists $args{'source_storage'} && defined $args{'source_storage'}) {
        $query_params->{'sourceStorage'} = $self->{api_client}->to_query_value($args{'source_storage'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'source_password'}) {
        $header_params->{':sourcePassword'} = $self->{api_client}->to_header_value($args{'source_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# post_slides_document_from_source
#
# Create a presentation from an existing source.
# 
# @param string $name Document name. (required)
# @param string $source_path Template file path. (optional)
# @param string $source_password Template file password. (optional)
# @param string $source_storage Template storage name. (optional)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'source_path' => {
        data_type => 'string',
        description => 'Template file path.',
        required => '0',
    },
    'source_password' => {
        data_type => 'string',
        description => 'Template file password.',
        required => '0',
    },
    'source_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_document_from_source' } = { 
    	summary => 'Create a presentation from an existing source.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub post_slides_document_from_source {
    warnings::warnif("deprecated", "post_slides_document_from_source is deprecated, use create_presentation_from_source instead");
  
    return create_presentation_from_source(@_);
}

#
# create_presentation_from_template
#
# Create a presentation.
# 
# @param string $name Document name. (required)
# @param string $template_path Template file path. (required)
# @param string $data Document input data. (optional)
# @param string $template_password Template file password. (optional)
# @param string $template_storage Template storage name. (optional)
# @param boolean $is_image_data_embedded True if image data is embedded. (optional, default to false)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'template_path' => {
        data_type => 'string',
        description => 'Template file path.',
        required => '1',
    },
    'data' => {
        data_type => 'string',
        description => 'Document input data.',
        required => '0',
    },
    'template_password' => {
        data_type => 'string',
        description => 'Template file password.',
        required => '0',
    },
    'template_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'is_image_data_embedded' => {
        data_type => 'boolean',
        description => 'True if image data is embedded.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_presentation_from_template' } = { 
    	summary => 'Create a presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub create_presentation_from_template {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_document_from_template");
    }

    # verify the required parameter 'template_path' is set
    unless (exists $args{'template_path'} && $args{'template_path'}) {
      croak("Missing the required parameter 'template_path' when calling post_slides_document_from_template");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromTemplate';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'template_path'} && defined $args{'template_path'}) {
        $query_params->{'templatePath'} = $self->{api_client}->to_query_value($args{'template_path'});
    }

    # query params
    if (exists $args{'template_storage'} && defined $args{'template_storage'}) {
        $query_params->{'templateStorage'} = $self->{api_client}->to_query_value($args{'template_storage'});
    }

    # query params
    if (exists $args{'is_image_data_embedded'} && defined $args{'is_image_data_embedded'}) {
        $query_params->{'isImageDataEmbedded'} = $self->{api_client}->to_boolean_query_value($args{'is_image_data_embedded'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'template_password'}) {
        $header_params->{':templatePassword'} = $self->{api_client}->to_header_value($args{'template_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'data'}) {
        $_body_data = $args{'data'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# post_slides_document_from_template
#
# Create a presentation.
# 
# @param string $name Document name. (required)
# @param string $template_path Template file path. (required)
# @param string $data Document input data. (optional)
# @param string $template_password Template file password. (optional)
# @param string $template_storage Template storage name. (optional)
# @param boolean $is_image_data_embedded True if image data is embedded. (optional, default to false)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'template_path' => {
        data_type => 'string',
        description => 'Template file path.',
        required => '1',
    },
    'data' => {
        data_type => 'string',
        description => 'Document input data.',
        required => '0',
    },
    'template_password' => {
        data_type => 'string',
        description => 'Template file password.',
        required => '0',
    },
    'template_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'is_image_data_embedded' => {
        data_type => 'boolean',
        description => 'True if image data is embedded.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_document_from_template' } = { 
    	summary => 'Create a presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub post_slides_document_from_template {
    warnings::warnif("deprecated", "post_slides_document_from_template is deprecated, use create_presentation_from_template instead");
  
    return create_presentation_from_template(@_);
}

#
# merge_online
#
# Merges the presentation with other presentations or some of their slides specified in the request parameter. Returns result file in the response. 
# 
# @param ARRAY[string] $files Files to merge (optional)
# @param OrderedMergeRequest $request Merge request. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to merge',
        required => '0',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'Merge request.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'merge_online' } = { 
    	summary => 'Merges the presentation with other presentations or some of their slides specified in the request parameter. Returns result file in the response. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub merge_online {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files;
    if ( exists $args{'files'}) {
        $files = $args{'files'};
    }

    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_slides_merge
#
# Merges the presentation with other presentations or some of their slides specified in the request parameter. Returns result file in the response. 
# 
# @param ARRAY[string] $files Files to merge (optional)
# @param OrderedMergeRequest $request Merge request. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to merge',
        required => '0',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'Merge request.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_merge' } = { 
    	summary => 'Merges the presentation with other presentations or some of their slides specified in the request parameter. Returns result file in the response. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_slides_merge {
    warnings::warnif("deprecated", "post_slides_merge is deprecated, use merge_online instead");
  
    return merge_online(@_);
}

#
# pipeline
#
# Performs slides pipeline.
# 
# @param Pipeline $pipeline A Pipeline object. (required)
# @param ARRAY[string] $files Files to upload with the pipeline (optional)
{
    my $params = {
    'pipeline' => {
        data_type => 'Pipeline',
        description => 'A Pipeline object.',
        required => '1',
    },
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to upload with the pipeline',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'pipeline' } = { 
    	summary => 'Performs slides pipeline.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub pipeline {
    my ($self, %args) = @_;

    # verify the required parameter 'pipeline' is set
    unless (exists $args{'pipeline'} && $args{'pipeline'}) {
      croak("Missing the required parameter 'pipeline' when calling post_slides_pipeline");
    }

    # parse inputs
    my $_resource_path = '/slides/pipeline';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    my $_body_data;
    my $files;
    if ( exists $args{'files'}) {
        $files = $args{'files'};
    }

    # body params
    if ( exists $args{'pipeline'}) {
        $_body_data = $args{'pipeline'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_slides_pipeline
#
# Performs slides pipeline.
# 
# @param Pipeline $pipeline A Pipeline object. (required)
# @param ARRAY[string] $files Files to upload with the pipeline (optional)
{
    my $params = {
    'pipeline' => {
        data_type => 'Pipeline',
        description => 'A Pipeline object.',
        required => '1',
    },
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to upload with the pipeline',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_pipeline' } = { 
    	summary => 'Performs slides pipeline.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_slides_pipeline {
    warnings::warnif("deprecated", "post_slides_pipeline is deprecated, use pipeline instead");
  
    return pipeline(@_);
}

#
# replace_presentation_text
#
# Replace text with a new value.
# 
# @param string $name Document name. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_presentation_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'DocumentReplaceResult',
        };
}
# @return DocumentReplaceResult
#
sub replace_presentation_text {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_presentation_replace_text");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling post_slides_presentation_replace_text");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling post_slides_presentation_replace_text");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentReplaceResult', $response);
    return $_response_object;
}

#
# post_slides_presentation_replace_text
#
# Replace text with a new value.
# 
# @param string $name Document name. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_presentation_replace_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'DocumentReplaceResult',
        };
}
# @return DocumentReplaceResult
#
sub post_slides_presentation_replace_text {
    warnings::warnif("deprecated", "post_slides_presentation_replace_text is deprecated, use replace_presentation_text instead");
  
    return replace_presentation_text(@_);
}

#
# move_slide
#
# Reorder presentation slide position.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param int $new_position The new position of the reordered slide. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'new_position' => {
        data_type => 'int',
        description => 'The new position of the reordered slide.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_slide' } = { 
    	summary => 'Reorder presentation slide position.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub move_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_reorder");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slides_reorder");
    }

    # verify the required parameter 'new_position' is set
    unless (exists $args{'new_position'}) {
      croak("Missing the required parameter 'new_position' when calling post_slides_reorder");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'new_position'} && defined $args{'new_position'}) {
        $query_params->{'newPosition'} = $self->{api_client}->to_query_value($args{'new_position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# post_slides_reorder
#
# Reorder presentation slide position.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param int $new_position The new position of the reordered slide. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'new_position' => {
        data_type => 'int',
        description => 'The new position of the reordered slide.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_reorder' } = { 
    	summary => 'Reorder presentation slide position.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub post_slides_reorder {
    warnings::warnif("deprecated", "post_slides_reorder is deprecated, use move_slide instead");
  
    return move_slide(@_);
}

#
# reorder_slides
#
# Reorder presentation slides positions.
# 
# @param string $name Document name. (required)
# @param string $old_positions A comma separated array of positions of slides to be reordered. (optional)
# @param string $new_positions A comma separated array of new slide positions. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_positions' => {
        data_type => 'string',
        description => 'A comma separated array of positions of slides to be reordered.',
        required => '0',
    },
    'new_positions' => {
        data_type => 'string',
        description => 'A comma separated array of new slide positions.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'reorder_slides' } = { 
    	summary => 'Reorder presentation slides positions.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub reorder_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_reorder_many");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/reorder';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_positions'} && defined $args{'old_positions'}) {
        $query_params->{'oldPositions'} = $self->{api_client}->to_query_value($args{'old_positions'});
    }

    # query params
    if (exists $args{'new_positions'} && defined $args{'new_positions'}) {
        $query_params->{'newPositions'} = $self->{api_client}->to_query_value($args{'new_positions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# post_slides_reorder_many
#
# Reorder presentation slides positions.
# 
# @param string $name Document name. (required)
# @param string $old_positions A comma separated array of positions of slides to be reordered. (optional)
# @param string $new_positions A comma separated array of new slide positions. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_positions' => {
        data_type => 'string',
        description => 'A comma separated array of positions of slides to be reordered.',
        required => '0',
    },
    'new_positions' => {
        data_type => 'string',
        description => 'A comma separated array of new slide positions.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_reorder_many' } = { 
    	summary => 'Reorder presentation slides positions.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub post_slides_reorder_many {
    warnings::warnif("deprecated", "post_slides_reorder_many is deprecated, use reorder_slides instead");
  
    return reorder_slides(@_);
}

#
# download_presentation
#
# Save a presentation to a specified format.
# 
# @param string $name Document name. (required)
# @param string $format Export format. (required)
# @param ExportOptions $options Export options. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_presentation' } = { 
    	summary => 'Save a presentation to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_slides_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_slides_save_as
#
# Save a presentation to a specified format.
# 
# @param string $name Document name. (required)
# @param string $format Export format. (required)
# @param ExportOptions $options Export options. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_save_as' } = { 
    	summary => 'Save a presentation to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_slides_save_as {
    warnings::warnif("deprecated", "post_slides_save_as is deprecated, use download_presentation instead");
  
    return download_presentation(@_);
}

#
# set_document_properties
#
# Set document properties.
# 
# @param string $name Document name. (required)
# @param DocumentProperties $properties New properties. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'properties' => {
        data_type => 'DocumentProperties',
        description => 'New properties.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'set_document_properties' } = { 
    	summary => 'Set document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub set_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_set_document_properties");
    }

    # verify the required parameter 'properties' is set
    unless (exists $args{'properties'} && $args{'properties'}) {
      croak("Missing the required parameter 'properties' when calling post_slides_set_document_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'properties'}) {
        $_body_data = $args{'properties'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# post_slides_set_document_properties
#
# Set document properties.
# 
# @param string $name Document name. (required)
# @param DocumentProperties $properties New properties. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'properties' => {
        data_type => 'DocumentProperties',
        description => 'New properties.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_set_document_properties' } = { 
    	summary => 'Set document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub post_slides_set_document_properties {
    warnings::warnif("deprecated", "post_slides_set_document_properties is deprecated, use set_document_properties instead");
  
    return set_document_properties(@_);
}

#
# replace_slide_text
#
# Replace text with a new value.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_slide_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'SlideReplaceResult',
        };
}
# @return SlideReplaceResult
#
sub replace_slide_text {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_slide_replace_text");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_slides_slide_replace_text");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling post_slides_slide_replace_text");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling post_slides_slide_replace_text");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideReplaceResult', $response);
    return $_response_object;
}

#
# post_slides_slide_replace_text
#
# Replace text with a new value.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_slide_replace_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'SlideReplaceResult',
        };
}
# @return SlideReplaceResult
#
sub post_slides_slide_replace_text {
    warnings::warnif("deprecated", "post_slides_slide_replace_text is deprecated, use replace_slide_text instead");
  
    return replace_slide_text(@_);
}

#
# split
#
# Splitting presentations. Create one image per slide.
# 
# @param string $name Document name. (required)
# @param ExportOptions $options Export options. (optional)
# @param string $format Export format. Default value is jpeg. (optional, default to 0)
# @param int $width The width of created images. (optional)
# @param int $height The height of created images. (optional)
# @param int $from The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation. (optional)
# @param int $to The last slide number for splitting, if is not specified splitting ends at the last slide of the document. (optional)
# @param string $dest_folder Folder on storage where images are going to be uploaded. If not specified then images are uploaded to same folder as presentation. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format. Default value is jpeg.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of created images.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of created images.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'The last slide number for splitting, if is not specified splitting ends at the last slide of the document.',
        required => '0',
    },
    'dest_folder' => {
        data_type => 'string',
        description => 'Folder on storage where images are going to be uploaded. If not specified then images are uploaded to same folder as presentation.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'split' } = { 
    	summary => 'Splitting presentations. Create one image per slide.',
        params => $params,
        returns => 'SplitDocumentResult',
        };
}
# @return SplitDocumentResult
#
sub split {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_slides_split");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/split';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'format'} && defined $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'from'} && defined $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if (exists $args{'to'} && defined $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if (exists $args{'dest_folder'} && defined $args{'dest_folder'}) {
        $query_params->{'destFolder'} = $self->{api_client}->to_query_value($args{'dest_folder'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SplitDocumentResult', $response);
    return $_response_object;
}

#
# post_slides_split
#
# Splitting presentations. Create one image per slide.
# 
# @param string $name Document name. (required)
# @param ExportOptions $options Export options. (optional)
# @param string $format Export format. Default value is jpeg. (optional, default to 0)
# @param int $width The width of created images. (optional)
# @param int $height The height of created images. (optional)
# @param int $from The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation. (optional)
# @param int $to The last slide number for splitting, if is not specified splitting ends at the last slide of the document. (optional)
# @param string $dest_folder Folder on storage where images are going to be uploaded. If not specified then images are uploaded to same folder as presentation. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format. Default value is jpeg.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of created images.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of created images.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'The last slide number for splitting, if is not specified splitting ends at the last slide of the document.',
        required => '0',
    },
    'dest_folder' => {
        data_type => 'string',
        description => 'Folder on storage where images are going to be uploaded. If not specified then images are uploaded to same folder as presentation.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_slides_split' } = { 
    	summary => 'Splitting presentations. Create one image per slide.',
        params => $params,
        returns => 'SplitDocumentResult',
        };
}
# @return SplitDocumentResult
#
sub post_slides_split {
    warnings::warnif("deprecated", "post_slides_split is deprecated, use split instead");
  
    return split(@_);
}

#
# download_subshape
#
# Render shape to specified picture format (for smart art and group shapes).
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_subshape' } = { 
    	summary => 'Render shape to specified picture format (for smart art and group shapes).',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_subshape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_subshape_save_as");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling post_subshape_save_as");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling post_subshape_save_as");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling post_subshape_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_subshape_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_subshape_save_as
#
# Render shape to specified picture format (for smart art and group shapes).
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_subshape_save_as' } = { 
    	summary => 'Render shape to specified picture format (for smart art and group shapes).',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_subshape_save_as {
    warnings::warnif("deprecated", "post_subshape_save_as is deprecated, use download_subshape instead");
  
    return download_subshape(@_);
}

#
# update_chart_category
#
# Update a chart category.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $category_index Category index. (required)
# @param ChartCategory $category Category DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category_index' => {
        data_type => 'int',
        description => 'Category index.',
        required => '1',
    },
    'category' => {
        data_type => 'ChartCategory',
        description => 'Category DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_chart_category' } = { 
    	summary => 'Update a chart category.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub update_chart_category {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_chart_category");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_chart_category");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_chart_category");
    }

    # verify the required parameter 'category_index' is set
    unless (exists $args{'category_index'}) {
      croak("Missing the required parameter 'category_index' when calling put_chart_category");
    }

    # verify the required parameter 'category' is set
    unless (exists $args{'category'} && $args{'category'}) {
      croak("Missing the required parameter 'category' when calling put_chart_category");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories/{categoryIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'category_index'}) {
        my $_base_variable = "{" . "categoryIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'category_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'category'}) {
        $_body_data = $args{'category'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# put_chart_category
#
# Update a chart category.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $category_index Category index. (required)
# @param ChartCategory $category Category DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category_index' => {
        data_type => 'int',
        description => 'Category index.',
        required => '1',
    },
    'category' => {
        data_type => 'ChartCategory',
        description => 'Category DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_chart_category' } = { 
    	summary => 'Update a chart category.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub put_chart_category {
    warnings::warnif("deprecated", "put_chart_category is deprecated, use update_chart_category instead");
  
    return update_chart_category(@_);
}

#
# update_chart_data_point
#
# Update a data point in a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param int $point_index Data point index. (required)
# @param DataPoint $data_point Data point DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'point_index' => {
        data_type => 'int',
        description => 'Data point index.',
        required => '1',
    },
    'data_point' => {
        data_type => 'DataPoint',
        description => 'Data point DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_chart_data_point' } = { 
    	summary => 'Update a data point in a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub update_chart_data_point {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_chart_data_point");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_chart_data_point");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_chart_data_point");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling put_chart_data_point");
    }

    # verify the required parameter 'point_index' is set
    unless (exists $args{'point_index'}) {
      croak("Missing the required parameter 'point_index' when calling put_chart_data_point");
    }

    # verify the required parameter 'data_point' is set
    unless (exists $args{'data_point'} && $args{'data_point'}) {
      croak("Missing the required parameter 'data_point' when calling put_chart_data_point");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints/{pointIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'point_index'}) {
        my $_base_variable = "{" . "pointIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'point_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'data_point'}) {
        $_body_data = $args{'data_point'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# put_chart_data_point
#
# Update a data point in a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param int $point_index Data point index. (required)
# @param DataPoint $data_point Data point DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'point_index' => {
        data_type => 'int',
        description => 'Data point index.',
        required => '1',
    },
    'data_point' => {
        data_type => 'DataPoint',
        description => 'Data point DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_chart_data_point' } = { 
    	summary => 'Update a data point in a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub put_chart_data_point {
    warnings::warnif("deprecated", "put_chart_data_point is deprecated, use update_chart_data_point instead");
  
    return update_chart_data_point(@_);
}

#
# update_chart_series
#
# Update a series in a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param int $series_index Series index. (required)
# @param Series $series Series DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'series' => {
        data_type => 'Series',
        description => 'Series DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_chart_series' } = { 
    	summary => 'Update a series in a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub update_chart_series {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_chart_series");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_chart_series");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_chart_series");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling put_chart_series");
    }

    # verify the required parameter 'series' is set
    unless (exists $args{'series'} && $args{'series'}) {
      croak("Missing the required parameter 'series' when calling put_chart_series");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'series'}) {
        $_body_data = $args{'series'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# put_chart_series
#
# Update a series in a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param int $series_index Series index. (required)
# @param Series $series Series DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'series' => {
        data_type => 'Series',
        description => 'Series DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_chart_series' } = { 
    	summary => 'Update a series in a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub put_chart_series {
    warnings::warnif("deprecated", "put_chart_series is deprecated, use update_chart_series instead");
  
    return update_chart_series(@_);
}

#
# save_shape_online
#
# Render shape to specified picture format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Path to save result. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_shape_online' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_shape_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling put_export_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_export_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_export_shape");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling put_export_shape");
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling put_export_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# put_export_shape
#
# Render shape to specified picture format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Path to save result. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_export_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub put_export_shape {
    warnings::warnif("deprecated", "put_export_shape is deprecated, use save_shape_online instead");
  
    return save_shape_online(@_);
}

#
# save_slide_online
#
# Save a slide to a specified format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param string $out_path Path to save result. (required)
# @param int $width Output file width; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height Output file height; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_slide_online' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling put_export_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_export_slide");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling put_export_slide");
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling put_export_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# put_export_slide
#
# Save a slide to a specified format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param string $out_path Path to save result. (required)
# @param int $width Output file width; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height Output file height; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'Output file width; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Output file height; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_export_slide' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub put_export_slide {
    warnings::warnif("deprecated", "put_export_slide is deprecated, use save_slide_online instead");
  
    return save_slide_online(@_);
}

#
# update_layout_slide
#
# Update a layoutSlide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param LayoutSlide $slide_dto Slide update data. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'slide_dto' => {
        data_type => 'LayoutSlide',
        description => 'Slide update data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_layout_slide' } = { 
    	summary => 'Update a layoutSlide.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub update_layout_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_layout_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_layout_slide");
    }

    # verify the required parameter 'slide_dto' is set
    unless (exists $args{'slide_dto'} && $args{'slide_dto'}) {
      croak("Missing the required parameter 'slide_dto' when calling put_layout_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides/{slideIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'slide_dto'}) {
        $_body_data = $args{'slide_dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlide', $response);
    return $_response_object;
}

#
# put_layout_slide
#
# Update a layoutSlide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param LayoutSlide $slide_dto Slide update data. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'slide_dto' => {
        data_type => 'LayoutSlide',
        description => 'Slide update data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_layout_slide' } = { 
    	summary => 'Update a layoutSlide.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub put_layout_slide {
    warnings::warnif("deprecated", "put_layout_slide is deprecated, use update_layout_slide instead");
  
    return update_layout_slide(@_);
}

#
# set_notes_slide_header_footer
#
# Set header/footer the notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param NotesSlideHeaderFooter $dto Header/footer to set. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'NotesSlideHeaderFooter',
        description => 'Header/footer to set.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'set_notes_slide_header_footer' } = { 
    	summary => 'Set header/footer the notes slide.',
        params => $params,
        returns => 'NotesSlideHeaderFooter',
        };
}
# @return NotesSlideHeaderFooter
#
sub set_notes_slide_header_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_notes_slide_header_footer");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_notes_slide_header_footer");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling put_notes_slide_header_footer");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/headerFooter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlideHeaderFooter', $response);
    return $_response_object;
}

#
# put_notes_slide_header_footer
#
# Set header/footer the notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param NotesSlideHeaderFooter $dto Header/footer to set. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'NotesSlideHeaderFooter',
        description => 'Header/footer to set.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_notes_slide_header_footer' } = { 
    	summary => 'Set header/footer the notes slide.',
        params => $params,
        returns => 'NotesSlideHeaderFooter',
        };
}
# @return NotesSlideHeaderFooter
#
sub put_notes_slide_header_footer {
    warnings::warnif("deprecated", "put_notes_slide_header_footer is deprecated, use set_notes_slide_header_footer instead");
  
    return set_notes_slide_header_footer(@_);
}

#
# save_notes_slide_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Output path. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Output path.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_notes_slide_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_notes_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_notes_slide_shape_save_as");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_notes_slide_shape_save_as");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_notes_slide_shape_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling put_notes_slide_shape_save_as");
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling put_notes_slide_shape_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/shapes/{shapeIndex}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# put_notes_slide_shape_save_as
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Output path. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Output path.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_notes_slide_shape_save_as' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub put_notes_slide_shape_save_as {
    warnings::warnif("deprecated", "put_notes_slide_shape_save_as is deprecated, use save_notes_slide_shape instead");
  
    return save_notes_slide_shape(@_);
}

#
# ordered_merge
#
# Merge the presentation with other presentations or some of their slides specified in the request parameter.
# 
# @param string $name Document name. (required)
# @param OrderedMergeRequest $request OrderedMergeRequest with a list of presentations and slide indices to merge. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'OrderedMergeRequest with a list of presentations and slide indices to merge.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'ordered_merge' } = { 
    	summary => 'Merge the presentation with other presentations or some of their slides specified in the request parameter.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub ordered_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_presentation_merge");
    }

    # verify the required parameter 'request' is set
    unless (exists $args{'request'} && $args{'request'}) {
      croak("Missing the required parameter 'request' when calling put_presentation_merge");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/merge';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# put_presentation_merge
#
# Merge the presentation with other presentations or some of their slides specified in the request parameter.
# 
# @param string $name Document name. (required)
# @param OrderedMergeRequest $request OrderedMergeRequest with a list of presentations and slide indices to merge. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'OrderedMergeRequest with a list of presentations and slide indices to merge.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_presentation_merge' } = { 
    	summary => 'Merge the presentation with other presentations or some of their slides specified in the request parameter.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub put_presentation_merge {
    warnings::warnif("deprecated", "put_presentation_merge is deprecated, use ordered_merge instead");
  
    return ordered_merge(@_);
}

#
# split_and_save_online
#
# Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. 
# 
# @param File $document Document data. (required)
# @param string $format ExportFormat (required)
# @param string $dest_folder Folder on storage where images are going to be uploaded. If not specified then images are uploaded to the root folder. (optional, default to )
# @param int $width Slide width. (optional)
# @param int $height Slide height. (optional)
# @param int $from The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation. (optional)
# @param int $to The last slide number for splitting, if is not specified splitting ends at the last slide of the document. (optional)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'ExportFormat',
        required => '1',
    },
    'dest_folder' => {
        data_type => 'string',
        description => 'Folder on storage where images are going to be uploaded. If not specified then images are uploaded to the root folder.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'Slide width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Slide height.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'The last slide number for splitting, if is not specified splitting ends at the last slide of the document.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'split_and_save_online' } = { 
    	summary => 'Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. ',
        params => $params,
        returns => 'SplitDocumentResult',
        };
}
# @return SplitDocumentResult
#
sub split_and_save_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling put_presentation_split");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling put_presentation_split");
    }

    # parse inputs
    my $_resource_path = '/slides/split/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'dest_folder'} && defined $args{'dest_folder'}) {
        $query_params->{'destFolder'} = $self->{api_client}->to_query_value($args{'dest_folder'});
    }

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'from'} && defined $args{'from'}) {
        $query_params->{'from'} = $self->{api_client}->to_query_value($args{'from'});
    }

    # query params
    if (exists $args{'to'} && defined $args{'to'}) {
        $query_params->{'to'} = $self->{api_client}->to_query_value($args{'to'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # form params
    if ( exists $args{'document'} ) {
        $_body_data = $args{'document'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SplitDocumentResult', $response);
    return $_response_object;
}

#
# put_presentation_split
#
# Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. 
# 
# @param File $document Document data. (required)
# @param string $format ExportFormat (required)
# @param string $dest_folder Folder on storage where images are going to be uploaded. If not specified then images are uploaded to the root folder. (optional, default to )
# @param int $width Slide width. (optional)
# @param int $height Slide height. (optional)
# @param int $from The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation. (optional)
# @param int $to The last slide number for splitting, if is not specified splitting ends at the last slide of the document. (optional)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'ExportFormat',
        required => '1',
    },
    'dest_folder' => {
        data_type => 'string',
        description => 'Folder on storage where images are going to be uploaded. If not specified then images are uploaded to the root folder.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'Slide width.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'Slide height.',
        required => '0',
    },
    'from' => {
        data_type => 'int',
        description => 'The start slide number for splitting, if is not specified splitting starts from the first slide of the presentation.',
        required => '0',
    },
    'to' => {
        data_type => 'int',
        description => 'The last slide number for splitting, if is not specified splitting ends at the last slide of the document.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_presentation_split' } = { 
    	summary => 'Splits PowerPoint presentation slides from the specified range into separate files and exports them in the specified file format. If the range is not provided all slides will be processed. ',
        params => $params,
        returns => 'SplitDocumentResult',
        };
}
# @return SplitDocumentResult
#
sub put_presentation_split {
    warnings::warnif("deprecated", "put_presentation_split is deprecated, use split_and_save_online instead");
  
    return split_and_save_online(@_);
}

#
# update_section
#
# Update section name.
# 
# @param string $name Document name. (required)
# @param int $section_index The position of the section to be updated. (required)
# @param string $section_name Section name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'The position of the section to be updated.',
        required => '1',
    },
    'section_name' => {
        data_type => 'string',
        description => 'Section name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_section' } = { 
    	summary => 'Update section name.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub update_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_section");
    }

    # verify the required parameter 'section_index' is set
    unless (exists $args{'section_index'}) {
      croak("Missing the required parameter 'section_index' when calling put_section");
    }

    # verify the required parameter 'section_name' is set
    unless (exists $args{'section_name'} && $args{'section_name'}) {
      croak("Missing the required parameter 'section_name' when calling put_section");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections/{sectionIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'section_name'} && defined $args{'section_name'}) {
        $query_params->{'sectionName'} = $self->{api_client}->to_query_value($args{'section_name'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'section_index'}) {
        my $_base_variable = "{" . "sectionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'section_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# put_section
#
# Update section name.
# 
# @param string $name Document name. (required)
# @param int $section_index The position of the section to be updated. (required)
# @param string $section_name Section name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'The position of the section to be updated.',
        required => '1',
    },
    'section_name' => {
        data_type => 'string',
        description => 'Section name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_section' } = { 
    	summary => 'Update section name.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub put_section {
    warnings::warnif("deprecated", "put_section is deprecated, use update_section instead");
  
    return update_section(@_);
}

#
# set_sections
#
# Replace existing presentation sections with the ones provided in the sections DTO.
# 
# @param string $name Document name. (required)
# @param Sections $sections Sections DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sections' => {
        data_type => 'Sections',
        description => 'Sections DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'set_sections' } = { 
    	summary => 'Replace existing presentation sections with the ones provided in the sections DTO.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub set_sections {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_sections");
    }

    # verify the required parameter 'sections' is set
    unless (exists $args{'sections'} && $args{'sections'}) {
      croak("Missing the required parameter 'sections' when calling put_sections");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'sections'}) {
        $_body_data = $args{'sections'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# put_sections
#
# Replace existing presentation sections with the ones provided in the sections DTO.
# 
# @param string $name Document name. (required)
# @param Sections $sections Sections DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sections' => {
        data_type => 'Sections',
        description => 'Sections DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_sections' } = { 
    	summary => 'Replace existing presentation sections with the ones provided in the sections DTO.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub put_sections {
    warnings::warnif("deprecated", "put_sections is deprecated, use set_sections instead");
  
    return set_sections(@_);
}

#
# update_portion
#
# Update portion properties.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param Portion $dto Portion DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_portion' } = { 
    	summary => 'Update portion properties.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub update_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_set_paragraph_portion_properties");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_set_paragraph_portion_properties");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_set_paragraph_portion_properties");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling put_set_paragraph_portion_properties");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling put_set_paragraph_portion_properties");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling put_set_paragraph_portion_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# put_set_paragraph_portion_properties
#
# Update portion properties.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param Portion $dto Portion DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_set_paragraph_portion_properties' } = { 
    	summary => 'Update portion properties.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub put_set_paragraph_portion_properties {
    warnings::warnif("deprecated", "put_set_paragraph_portion_properties is deprecated, use update_portion instead");
  
    return update_portion(@_);
}

#
# update_paragraph
#
# Update paragraph properties.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_paragraph' } = { 
    	summary => 'Update paragraph properties.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub update_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_set_paragraph_properties");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_set_paragraph_properties");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_set_paragraph_properties");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling put_set_paragraph_properties");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling put_set_paragraph_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# put_set_paragraph_properties
#
# Update paragraph properties.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_set_paragraph_properties' } = { 
    	summary => 'Update paragraph properties.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub put_set_paragraph_properties {
    warnings::warnif("deprecated", "put_set_paragraph_properties is deprecated, use update_paragraph instead");
  
    return update_paragraph(@_);
}

#
# update_subshape_portion
#
# Update portion properties (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param Portion $dto Portion DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_subshape_portion' } = { 
    	summary => 'Update portion properties (for smart art and group shapes).',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub update_subshape_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_set_subshape_paragraph_portion_properties");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_set_subshape_paragraph_portion_properties");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling put_set_subshape_paragraph_portion_properties");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_set_subshape_paragraph_portion_properties");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling put_set_subshape_paragraph_portion_properties");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling put_set_subshape_paragraph_portion_properties");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling put_set_subshape_paragraph_portion_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# put_set_subshape_paragraph_portion_properties
#
# Update portion properties (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param Portion $dto Portion DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_set_subshape_paragraph_portion_properties' } = { 
    	summary => 'Update portion properties (for smart art and group shapes).',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub put_set_subshape_paragraph_portion_properties {
    warnings::warnif("deprecated", "put_set_subshape_paragraph_portion_properties is deprecated, use update_subshape_portion instead");
  
    return update_subshape_portion(@_);
}

#
# update_subshape_paragraph
#
# Update paragraph properties (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'update_subshape_paragraph' } = { 
    	summary => 'Update paragraph properties (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub update_subshape_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_set_subshape_paragraph_properties");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_set_subshape_paragraph_properties");
    }

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling put_set_subshape_paragraph_properties");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_set_subshape_paragraph_properties");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling put_set_subshape_paragraph_properties");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling put_set_subshape_paragraph_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# put_set_subshape_paragraph_properties
#
# Update paragraph properties (for smart art and group shapes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $path Shape path. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'path' => {
        data_type => 'string',
        description => 'Shape path.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_set_subshape_paragraph_properties' } = { 
    	summary => 'Update paragraph properties (for smart art and group shapes).',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub put_set_subshape_paragraph_properties {
    warnings::warnif("deprecated", "put_set_subshape_paragraph_properties is deprecated, use update_subshape_paragraph instead");
  
    return update_subshape_paragraph(@_);
}

#
# save_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Output path. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Output path.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_shape_save_as");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_shape_save_as");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling put_shape_save_as");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling put_shape_save_as");
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling put_shape_save_as");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# put_shape_save_as
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Output path. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Output path.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'put_shape_save_as' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub put_shape_save_as {
    warnings::warnif("deprecated", "put_shape_save_as is deprecated, use save_shape instead");
  
    return save_shape(@_);
}

#
# set_animation
#
# Set slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param SlideAnimation $animation Animation DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'animation' => {
        data_type => 'SlideAnimation',
        description => 'Animation DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'set_animation' } = { 
    	summary => 'Set slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub set_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling put_slide_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling put_slide_animation");
    }

    # verify the required parameter 'animation' is set
    unless (exists $args{'animation'} && $args{'animation'}) {
      croak("Missing the required parameter 'animation' when calling put_slide_animation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files;
    # body params
    if ( exists $args{'animation'}) {
        $_body_data = $args{'animation'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# put_slide_animation
#
# Set slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param SlideAnimation $animation Animation DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'animation' => {
        data_type => 'SlideAnimation',
        description => 'Animation DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'stor