/*
 * Decompiled with CFR 0.152.
 */
package jcckit.data;

import jcckit.data.DataContainer;
import jcckit.data.DataElement;
import jcckit.data.DataEventType;

public class DataEvent {
    private final DataContainer _container;
    private final DataEventType _type;
    private final int _index;
    private final DataElement _deletedElement;

    private DataEvent(DataContainer dataContainer, DataEventType dataEventType, int n, DataElement dataElement) {
        this._container = dataContainer;
        this._type = dataEventType;
        this._index = n;
        this._deletedElement = dataElement;
    }

    public static final DataEvent createAddEvent(DataContainer dataContainer) {
        return new DataEvent(dataContainer, DataEventType.ELEMENT_ADDED, dataContainer.getNumberOfElements() - 1, null);
    }

    public static final DataEvent createInsertEvent(DataContainer dataContainer, int n) {
        return new DataEvent(dataContainer, DataEventType.ELEMENT_INSERTED, n, null);
    }

    public static final DataEvent createReplaceEvent(DataContainer dataContainer, int n, DataElement dataElement) {
        return new DataEvent(dataContainer, DataEventType.ELEMENT_REPLACED, n, dataElement);
    }

    public static final DataEvent createRemoveEvent(DataContainer dataContainer, int n, DataElement dataElement) {
        return new DataEvent(dataContainer, DataEventType.ELEMENT_REMOVED, n, dataElement);
    }

    public DataContainer getContainer() {
        return this._container;
    }

    public DataEventType getType() {
        return this._type;
    }

    public int getIndex() {
        return this._index;
    }

    public DataElement getDeletedElement() {
        return this._deletedElement;
    }
}

