#====================================================
#   Copyright 2015 SAP SE or an SAP affiliate company
#====================================================
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#   While not a requirement of the license, if you do modify this file, we
#   would appreciate hearing about it. Please email
#   sqlany_interfaces@sybase.com
#
#====================================================

# The %info hash was automatically generated by
# DBI::DBD::Metadata::write_getinfo_pm v2.008696.

package DBD::SQLAnywhere::GetInfo;

use strict;
use DBD::SQLAnywhere;

# Beware: not officially documented interfaces...
# use DBI::Const::GetInfoType qw(%GetInfoType);
# use DBI::Const::GetInfoReturn qw(%GetInfoReturnTypes %GetInfoReturnValues);

my $sql_driver = 'SQLAnywhere';
my $sql_ver_fmt = '%02d.%02d.%04d';   # ODBC version string: ##.##.#####
my $sql_driver_ver = sprintf $sql_ver_fmt, split (/\./, "$DBD::SQLAnywhere::VERSION.0");

my @Keywords = qw(
add
aes_decrypt
all
alter
and
any
as
asc
attach
backup
begin
between
bigint
binary
bit
bottom
break
by
call
capability
cascade
case
cast
char
char_convert
character
check
checkpoint
close
comment
commit
compressed
conflict
connect
constraint
contains
continue
convert
create
cross
cube
current
current_timestamp
current_user
cursor
date
dbspace
deallocate
dec
decimal
declare
default
delete
deleting
desc
detach
distinct
do
double
drop
dynamic
else
elseif
encrypted
end
endif
escape
except
exception
exec
execute
existing
exists
externlogin
fetch
first
float
for
force
foreign
forward
from
full
goto
grant
group
having
holdlock
identified
if
in
index
inner
inout
insensitive
insert
inserting
install
instead
integer
integrated
intersect
into
iq
is
isolation
join
kerberos
key
lateral
left
like
lock
login
long
match
membership
merge
message
mode
modify
natural
nchar
new
no
noholdlock
not
notify
null
numeric
nvarchar
of
off
on
open
openstring
option
options
or
order
others
out
outer
over
passthrough
precision
prepare
primary
print
privileges
proc
procedure
publication
raiserror
readtext
real
reference
references
refresh
release
remote
remove
rename
reorganize
resource
restore
restrict
return
revoke
right
rollback
rollup
save
savepoint
scroll
select
sensitive
session
set
setuser
share
smallint
some
sqlcode
sqlstate
start
stop
subtrans
subtransaction
synchronize
table
temporary
then
time
timestamp
tinyint
to
top
trigger
truncate
tsequal
unbounded
union
unique
uniqueidentifier
unknown
unsigned
update
updating
user
using
validate
values
varbinary
varbit
varchar
variable
varying
view
wait
waitfor
when
where
while
window
with
within
work
writetext
xml
);


sub sql_keywords
{
    return( join ',', @Keywords );
}

sub sql_data_source_name
{
    my $dbh = shift;
    return( "dbi:$sql_driver:" . $dbh->{Name} );
}

sub quick_query
{
    my( $dbh, $query ) = @_;
    my $row = $dbh->selectrow_arrayref( $query );
    return( defined( $row ) ? $row->[0] : undef );
}

sub sql_user_name
{
    return( &quick_query( $_[0], q(select current_user) ) );
}

sub server_name
{
    return( &quick_query( $_[0], q(select property('name')) ) );
}

sub database_name
{
    return( &quick_query( $_[0], q(select db_property('name')) ) );
}

sub conn_charset
{
    return( &quick_query( $_[0], q(select connection_property('charset')) ) );
}

sub dbms_name
{
    # We do this dynamically in case it is an IQ server
    return( &quick_query( $_[0], q(select property('productname')) ) );
}

sub product_version
{
    my $verstr = &quick_query( $_[0], q(select property('productversion')) );
    if( !defined( $verstr ) ) {
	return( undef );
    }

    my @vernums = split( /\./, $verstr );
    return( sprintf( "%02d.%02s.%04d Build %d", $vernums[0], $vernums[1], $vernums[2], $vernums[3] ) );
}

our %info = (
      1 => 0x0,                            	# SQL_ACTIVE_STATEMENTS
      2 => \&sql_data_source_name,       	# SQL_DATA_SOURCE_NAME
      3 => '',                       		# SQL_DRIVER_HDBC
      4 => '',                       		# SQL_DRIVER_HENV
      5 => undef,                        	# SQL_DRIVER_HSTMT
      6 => $INC{'DBD/SQLAnywhere.pm'},   	# SQL_DRIVER_NAME
      7 => $sql_driver_ver,              	# SQL_DRIVER_VER
      8 => 0xbf,                          	# SQL_FETCH_DIRECTION
      9 => 0x2,                            	# SQL_ODBC_API_CONFORMANCE
     11 => 'Y',                          	# SQL_ROW_UPDATES
     12 => 0x1,                            	# SQL_ODBC_SAG_CLI_CONFORMANCE
     13 => \&server_name, 		 	# SQL_SERVER_NAME
     14 => '~',                          	# SQL_SEARCH_PATTERN_ESCAPE
     15 => 0x2,                            	# SQL_ODBC_SQL_CONFORMANCE
     16 => \&database_name,		 	# SQL_DATABASE_NAME
     17 => \&dbms_name,                  	# SQL_DBMS_NAME
     18 => \&product_version,            	# SQL_DBMS_VER
     19 => 'N',                          	# SQL_ACCESSIBLE_TABLES
     21 => 'Y',                          	# SQL_PROCEDURES
     22 => 0x0,                            	# SQL_CONCAT_NULL_BEHAVIOR
     23 => 0x2,                            	# SQL_CURSOR_COMMIT_BEHAVIOR
     24 => 0x2,                            	# SQL_CURSOR_ROLLBACK_BEHAVIOR
     25 => 'N',                          	# SQL_DATA_SOURCE_READ_ONLY
     26 => 0x1,                            	# SQL_DEFAULT_TXN_ISOLATION
     27 => 'Y',                          	# SQL_EXPRESSIONS_IN_ORDERBY
     28 => 0x4,                            	# SQL_IDENTIFIER_CASE
     29 => '"',                          	# SQL_IDENTIFIER_QUOTE_CHAR
     30 => 0x80,                          	# SQL_MAX_COLUMN_NAME_LEN
     31 => 0x80,                          	# SQL_MAX_CURSOR_NAME_LEN
     32 => 0x80,                          	# SQL_MAX_SCHEMA_NAME_LEN
     33 => 0x80,                          	# SQL_MAX_PROCEDURE_NAME_LEN
     34 => 0x0,                            	# SQL_MAX_CATALOG_NAME_LEN
     35 => 0x80,                          	# SQL_MAX_TABLE_NAME_LEN
     36 => 'Y',                          	# SQL_MULT_RESULT_SETS
     37 => 'Y',                          	# SQL_MULTIPLE_ACTIVE_TXN
     38 => 'F',                          	# SQL_OUTER_JOINS
     39 => 'Creator',                    	# SQL_SCHEMA_TERM
     40 => 'Procedure',                  	# SQL_PROCEDURE_TERM
     41 => '',                           	# SQL_CATALOG_NAME_SEPARATOR
     42 => '',                           	# SQL_CATALOG_TERM
     43 => 0xf,                           	# SQL_SCROLL_CONCURRENCY
     44 => 0x1f,                           	# SQL_SCROLL_OPTIONS
     45 => 'Table',                      	# SQL_TABLE_TERM
     46 => 0x3,                            	# SQL_TXN_CAPABLE
     47 => \&sql_user_name,              	# SQL_USER_NAME
     48 => 0x3,                            	# SQL_CONVERT_FUNCTIONS
     49 => 0xffffff,                     	# SQL_NUMERIC_FUNCTIONS
     50 => 0xffffff,                     	# SQL_STRING_FUNCTIONS
     51 => 0x7,                            	# SQL_SYSTEM_FUNCTIONS
     52 => 0x1f9fff,                      	# SQL_TIMEDATE_FUNCTIONS
     53 => 0xe47fff,                     	# SQL_CONVERT_BIGINT
     54 => 0x1e40f01,                     	# SQL_CONVERT_BINARY
     55 => 0xe47fff,                     	# SQL_CONVERT_BIT
     56 => 0x1e7ffff,                     	# SQL_CONVERT_CHAR
     57 => 0xe68f01,                     	# SQL_CONVERT_DATE
     58 => 0xe47fff,                     	# SQL_CONVERT_DECIMAL
     59 => 0xe47fff,                     	# SQL_CONVERT_DOUBLE
     60 => 0xe47fff,                     	# SQL_CONVERT_FLOAT
     61 => 0xe47fff,                     	# SQL_CONVERT_INTEGER
     62 => 0x1e7ffff,                     	# SQL_CONVERT_LONGVARCHAR
     63 => 0xe47fff,                     	# SQL_CONVERT_NUMERIC
     64 => 0xe47fff,                     	# SQL_CONVERT_REAL
     65 => 0xe47fff,                     	# SQL_CONVERT_SMALLINT
     66 => 0xe70f01,                     	# SQL_CONVERT_TIME
     67 => 0xe78f01,                     	# SQL_CONVERT_TIMESTAMP
     68 => 0xe47fff,                     	# SQL_CONVERT_TINYINT
     69 => 0x1e40f01,                     	# SQL_CONVERT_VARBINARY
     70 => 0x1e7ffff,                     	# SQL_CONVERT_VARCHAR
     71 => 0x1e40f01,                     	# SQL_CONVERT_LONGVARBINARY
     72 => 0xf,                           	# SQL_TXN_ISOLATION_OPTION
     73 => 'Y',                          	# SQL_INTEGRITY
     74 => 0x2,                            	# SQL_CORRELATION_NAME
     75 => 0x1,                            	# SQL_NON_NULLABLE_COLUMNS
     76 => undef,                        	# SQL_DRIVER_HLIB
     77 => '03.52',                      	# SQL_DRIVER_ODBC_VER
     78 => 0x3,                            	# SQL_LOCK_TYPES
     79 => 0x1f,                           	# SQL_POS_OPERATIONS
     80 => 0x7,                            	# SQL_POSITIONED_STATEMENTS
     81 => 0xf,                           	# SQL_GETDATA_EXTENSIONS
     82 => 0x5a,                           	# SQL_BOOKMARK_PERSISTENCE
     83 => 0x4,                            	# SQL_STATIC_SENSITIVITY
     84 => 0x0,                            	# SQL_FILE_USAGE
     85 => 0x1,                            	# SQL_NULL_COLLATION
     86 => 0x3,                            	# SQL_ALTER_TABLE
     87 => 'Y',                          	# SQL_COLUMN_ALIAS
     88 => 0x2,                            	# SQL_GROUP_BY
     89 => \&sql_keywords,               	# SQL_KEYWORDS
     90 => 'N',                          	# SQL_ORDER_BY_COLUMNS_IN_SELECT
     91 => 0x1f,                           	# SQL_SCHEMA_USAGE
     92 => 0x0,                            	# SQL_CATALOG_USAGE
     93 => 0x4,                            	# SQL_QUOTED_IDENTIFIER_CASE
     94 => '@$#',                        	# SQL_SPECIAL_CHARACTERS
     95 => 0x1f,                           	# SQL_SUBQUERIES
     96 => 0x3,                            	# SQL_UNION
     97 => 0x0,                            	# SQL_MAX_COLUMNS_IN_GROUP_BY
     98 => 0x0,                            	# SQL_MAX_COLUMNS_IN_INDEX
     99 => 0x0,                            	# SQL_MAX_COLUMNS_IN_ORDER_BY
    100 => 0x0,                            	# SQL_MAX_COLUMNS_IN_SELECT
    101 => 0x0,                            	# SQL_MAX_COLUMNS_IN_TABLE
    102 => 0x0,                            	# SQL_MAX_INDEX_SIZE
    103 => 'Y',                          	# SQL_MAX_ROW_SIZE_INCLUDES_LONG
    104 => 0x7fffffff,                   	# SQL_MAX_ROW_SIZE
    105 => 0x0,                            	# SQL_MAX_STATEMENT_LEN
    106 => 0x0,                            	# SQL_MAX_TABLES_IN_SELECT
    107 => 0x80,                          	# SQL_MAX_USER_NAME_LEN
    108 => 0x0,                            	# SQL_MAX_CHAR_LITERAL_LEN
    109 => 0x0,                            	# SQL_TIMEDATE_ADD_INTERVALS
    110 => 0x0,                            	# SQL_TIMEDATE_DIFF_INTERVALS
    111 => 'N',                          	# SQL_NEED_LONG_DATA_LEN
    112 => 0x0,                            	# SQL_MAX_BINARY_LITERAL_LEN
    113 => 'Y',                          	# SQL_LIKE_ESCAPE_CLAUSE
    114 => 0x0,                            	# SQL_CATALOG_LOCATION
    115 => 0x7f,                          	# SQL_OJ_CAPABILITIES
    116 => 0x0,                            	# SQL_ACTIVE_ENVIRONMENTS
    117 => 0x0,                            	# SQL_ALTER_DOMAIN
    118 => 0x1,                            	# SQL_SQL_CONFORMANCE
    119 => 0x7,                            	# SQL_DATETIME_LITERALS
    120 => 0x6,                            	# SQL_BATCH_ROW_COUNT
    121 => 0x7,                            	# SQL_BATCH_SUPPORT
    122 => 0x1e7ffff,                     	# SQL_CONVERT_WCHAR
    123 => 0x0,                            	# SQL_CONVERT_INTERVAL_DAY_TIME
    124 => 0x0,                            	# SQL_CONVERT_INTERVAL_YEAR_MONTH
    125 => 0x1e7ffff,                     	# SQL_CONVERT_WLONGVARCHAR
    126 => 0x1e7ffff,                     	# SQL_CONVERT_WVARCHAR
    127 => 0x0,                            	# SQL_CREATE_ASSERTION
    128 => 0x0,                            	# SQL_CREATE_CHARACTER_SET
    129 => 0x0,                            	# SQL_CREATE_COLLATION
    130 => 0x7,                            	# SQL_CREATE_DOMAIN
    131 => 0x3,                            	# SQL_CREATE_SCHEMA
    132 => 0x161d,                         	# SQL_CREATE_TABLE
    133 => 0x0,                            	# SQL_CREATE_TRANSLATION
    134 => 0x3,                            	# SQL_CREATE_VIEW
    136 => 0x0,                            	# SQL_DROP_ASSERTION
    137 => 0x0,                            	# SQL_DROP_CHARACTER_SET
    138 => 0x0,                            	# SQL_DROP_COLLATION
    139 => 0x1,                            	# SQL_DROP_DOMAIN
    140 => 0x0,                            	# SQL_DROP_SCHEMA
    141 => 0x7,                            	# SQL_DROP_TABLE
    142 => 0x0,                            	# SQL_DROP_TRANSLATION
    143 => 0x1,                            	# SQL_DROP_VIEW
    144 => 0x1ffc7,                       	# SQL_DYNAMIC_CURSOR_ATTRIBUTES1
    145 => 0x2073,                         	# SQL_DYNAMIC_CURSOR_ATTRIBUTES2
    146 => 0x1ffc1,                       	# SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1
    147 => 0x2003,                         	# SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2
    148 => 0x3,                            	# SQL_INDEX_KEYWORDS
    149 => 0x0,                            	# SQL_INFO_SCHEMA_VIEWS
    150 => 0xfffcf,                      	# SQL_KEYSET_CURSOR_ATTRIBUTES1
    151 => 0x204f,                         	# SQL_KEYSET_CURSOR_ATTRIBUTES2
    152 => 0x3,                            	# SQL_ODBC_INTERFACE_CONFORMANCE
    153 => 0x1,                            	# SQL_PARAM_ARRAY_ROW_COUNTS
    154 => 0x1,                            	# SQL_PARAM_ARRAY_SELECTS
    155 => 0x7,                            	# SQL_SQL92_DATETIME_FUNCTIONS
    156 => 0xf,                           	# SQL_SQL92_FOREIGN_KEY_DELETE_RULE
    157 => 0xf,                           	# SQL_SQL92_FOREIGN_KEY_UPDATE_RULE
    158 => 0x1610,                         	# SQL_SQL92_GRANT
    159 => 0x0,                            	# SQL_SQL92_NUMERIC_VALUE_FUNCTIONS
    160 => 0x2e07,                        	# SQL_SQL92_PREDICATES
    161 => 0x152,                          	# SQL_SQL92_RELATIONAL_JOIN_OPERATORS
    162 => 0x5800,                        	# SQL_SQL92_REVOKE
    163 => 0x0,                            	# SQL_SQL92_ROW_VALUE_CONSTRUCTOR
    164 => 0xef,                          	# SQL_SQL92_STRING_FUNCTIONS
    165 => 0xf,                           	# SQL_SQL92_VALUE_EXPRESSIONS
    166 => 0x3,                            	# SQL_STANDARD_CLI_CONFORMANCE
    167 => 0xfffcf,                      	# SQL_STATIC_CURSOR_ATTRIBUTES1
    168 => 0x2063,                         	# SQL_STATIC_CURSOR_ATTRIBUTES2
    169 => 0x40,                           	# SQL_AGGREGATE_FUNCTIONS
    170 => 0x3,                            	# SQL_DDL_INDEX
    172 => 0x7,                            	# SQL_INSERT_STATEMENT
    173 => 0x1e40f01,                     	# SQL_CONVERT_GUID
  10000 => 0x7cb,                         	# SQL_XOPEN_CLI_YEAR
  10001 => 0x2,                            	# SQL_CURSOR_SENSITIVITY
  10002 => 'N',                          	# SQL_DESCRIBE_PARAMETER
  10003 => 'N',                          	# SQL_CATALOG_NAME
  10004 => \&conn_charset,               	# SQL_COLLATION_SEQ
  10005 => 0x80,                          	# SQL_MAX_IDENTIFIER_LEN
  10021 => 0x0,                            	# SQL_ASYNC_MODE
  10022 => 0x0,                            	# SQL_MAX_ASYNC_CONCURRENT_STATEMENTS
);

1;

__END__
