/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.CasioType2MakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasioType2MakernoteDescriptor
extends TagDescriptor<CasioType2MakernoteDirectory> {
    public CasioType2MakernoteDescriptor(@NotNull CasioType2MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 2: {
                return this.getThumbnailDimensionsDescription();
            }
            case 3: {
                return this.getThumbnailSizeDescription();
            }
            case 4: {
                return this.getThumbnailOffsetDescription();
            }
            case 8: {
                return this.getQualityModeDescription();
            }
            case 9: {
                return this.getImageSizeDescription();
            }
            case 13: {
                return this.getFocusMode1Description();
            }
            case 20: {
                return this.getIsoSensitivityDescription();
            }
            case 25: {
                return this.getWhiteBalance1Description();
            }
            case 29: {
                return this.getFocalLengthDescription();
            }
            case 31: {
                return this.getSaturationDescription();
            }
            case 32: {
                return this.getContrastDescription();
            }
            case 33: {
                return this.getSharpnessDescription();
            }
            case 3584: {
                return this.getPrintImageMatchingInfoDescription();
            }
            case 8192: {
                return this.getCasioPreviewThumbnailDescription();
            }
            case 8209: {
                return this.getWhiteBalanceBiasDescription();
            }
            case 8210: {
                return this.getWhiteBalance2Description();
            }
            case 8226: {
                return this.getObjectDistanceDescription();
            }
            case 8244: {
                return this.getFlashDistanceDescription();
            }
            case 12288: {
                return this.getRecordModeDescription();
            }
            case 12289: {
                return this.getSelfTimerDescription();
            }
            case 12290: {
                return this.getQualityDescription();
            }
            case 12291: {
                return this.getFocusMode2Description();
            }
            case 12294: {
                return this.getTimeZoneDescription();
            }
            case 12295: {
                return this.getBestShotModeDescription();
            }
            case 12308: {
                return this.getCcdIsoSensitivityDescription();
            }
            case 12309: {
                return this.getColourModeDescription();
            }
            case 12310: {
                return this.getEnhancementDescription();
            }
            case 12311: {
                return this.getFilterDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getFilterDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12311);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getEnhancementDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12310);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getColourModeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12309);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getCcdIsoSensitivityDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12308);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getBestShotModeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12295);
        if (value == null) {
            return null;
        }
        switch (value) {
            default: 
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getTimeZoneDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(12294);
    }

    @Nullable
    public String getFocusMode2Description() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12291);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Fixation";
            }
            case 6: {
                return "Multi-Area Focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12290);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 3: {
                return "Fine";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSelfTimerDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12289);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Off";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getRecordModeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(12288);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "Normal";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashDistanceDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(8244);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getObjectDistanceDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(8226);
        if (value == null) {
            return null;
        }
        return Integer.toString(value) + " mm";
    }

    @Nullable
    public String getWhiteBalance2Description() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(8210);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Manual";
            }
            case 1: {
                return "Auto";
            }
            case 4: {
                return "Flash";
            }
            case 12: {
                return "Flash";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceBiasDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(8209);
    }

    @Nullable
    public String getCasioPreviewThumbnailDescription() {
        byte[] bytes = ((CasioType2MakernoteDirectory)this._directory).getByteArray(8192);
        if (bytes == null) {
            return null;
        }
        return "<" + bytes.length + " bytes of image data>";
    }

    @Nullable
    public String getPrintImageMatchingInfoDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(3584);
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(33);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "Normal";
            }
            case 2: {
                return "+1";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(32);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "Normal";
            }
            case 2: {
                return "+1";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(31);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "Normal";
            }
            case 2: {
                return "+1";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocalLengthDescription() {
        Double value = ((CasioType2MakernoteDirectory)this._directory).getDoubleObject(29);
        if (value == null) {
            return null;
        }
        return Double.toString(value / 10.0) + " mm";
    }

    @Nullable
    public String getWhiteBalance1Description() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(25);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Shade";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Florescent";
            }
            case 5: {
                return "Manual";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getIsoSensitivityDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(20);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 3: {
                return "50";
            }
            case 4: {
                return "64";
            }
            case 6: {
                return "100";
            }
            case 9: {
                return "200";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusMode1Description() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(13);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Macro";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getImageSizeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(9);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "640 x 480 pixels";
            }
            case 4: {
                return "1600 x 1200 pixels";
            }
            case 5: {
                return "2048 x 1536 pixels";
            }
            case 20: {
                return "2288 x 1712 pixels";
            }
            case 21: {
                return "2592 x 1944 pixels";
            }
            case 22: {
                return "2304 x 1728 pixels";
            }
            case 36: {
                return "3008 x 2008 pixels";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityModeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(8);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Fine";
            }
            case 2: {
                return "Super Fine";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getThumbnailOffsetDescription() {
        return ((CasioType2MakernoteDirectory)this._directory).getString(4);
    }

    @Nullable
    public String getThumbnailSizeDescription() {
        Integer value = ((CasioType2MakernoteDirectory)this._directory).getInteger(3);
        if (value == null) {
            return null;
        }
        return Integer.toString(value) + " bytes";
    }

    @Nullable
    public String getThumbnailDimensionsDescription() {
        int[] dimensions = ((CasioType2MakernoteDirectory)this._directory).getIntArray(2);
        if (dimensions == null || dimensions.length != 2) {
            return ((CasioType2MakernoteDirectory)this._directory).getString(2);
        }
        return dimensions[0] + " x " + dimensions[1] + " pixels";
    }
}

