/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.vorbis.VorbisComments;
import org.gagravarr.vorbis.VorbisPacket;

public class TestVorbisComments
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testVORBIS.ogg");
    }

    public void testRead() throws IOException {
        OggFile ogg = new OggFile(this.getTestFile());
        OggPacketReader r = ogg.getPacketReader();
        r.getNextPacket();
        VorbisPacket p = VorbisPacket.create(r.getNextPacket());
        TestVorbisComments.assertEquals(VorbisComments.class, p.getClass());
        VorbisComments c = (VorbisComments)p;
        TestVorbisComments.assertEquals((String)"Xiph.Org libVorbis I 20070622", (String)c.getVendor());
        TestVorbisComments.assertEquals((int)7, (int)c.getAllComments().size());
        TestVorbisComments.assertEquals((String)"Test Title", (String)c.getTitle());
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("TiTlE").size());
        TestVorbisComments.assertEquals((String)"Test Title", (String)c.getComments("tItLe").get(0));
        TestVorbisComments.assertEquals((String)"Test Artist", (String)c.getArtist());
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("ArTiSt").size());
        TestVorbisComments.assertEquals((String)"Test Artist", (String)c.getComments("aRTiST").get(0));
        TestVorbisComments.assertEquals((String)"Test Genre", (String)c.getGenre());
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("GEnRE").size());
        TestVorbisComments.assertEquals((String)"Test Genre", (String)c.getComments("genRE").get(0));
        TestVorbisComments.assertEquals((String)"Test Album", (String)c.getAlbum());
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("alBUm").size());
        TestVorbisComments.assertEquals((String)"Test Album", (String)c.getComments("ALbUM").get(0));
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("DAte").size());
        TestVorbisComments.assertEquals((String)"2010-01-26", (String)c.getComments("dAtE").get(0));
        TestVorbisComments.assertEquals((int)2, (int)c.getComments("COmmENT").size());
        TestVorbisComments.assertEquals((String)"Test Comment", (String)c.getComments("COMMent").get(0));
        TestVorbisComments.assertEquals((String)"Another Test Comment", (String)c.getComments("COMMent").get(1));
    }

    public void testModify() throws IOException {
        VorbisComments c = new VorbisComments();
        TestVorbisComments.assertEquals((int)0, (int)c.getComments("a").size());
        TestVorbisComments.assertEquals((int)0, (int)c.getAllComments().size());
        TestVorbisComments.assertEquals(null, (String)c.getAlbum());
        c.addComment("a", "1");
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("a").size());
        TestVorbisComments.assertEquals((String)"1", (String)c.getComments("a").get(0));
        c.addComment("A", "2");
        c.addComment("a", "3");
        TestVorbisComments.assertEquals((int)3, (int)c.getComments("A").size());
        TestVorbisComments.assertEquals((String)"1", (String)c.getComments("a").get(0));
        TestVorbisComments.assertEquals((String)"2", (String)c.getComments("a").get(1));
        TestVorbisComments.assertEquals((String)"3", (String)c.getComments("a").get(2));
        c.setComments("a", new ArrayList<String>());
        TestVorbisComments.assertEquals((int)0, (int)c.getComments("a").size());
        c.addComment("a", "F");
        TestVorbisComments.assertEquals((int)1, (int)c.getComments("a").size());
        TestVorbisComments.assertEquals((String)"F", (String)c.getComments("a").get(0));
        c.removeComments("A");
        TestVorbisComments.assertEquals((int)0, (int)c.getComments("a").size());
        TestVorbisComments.assertEquals((int)0, (int)c.getAllComments().size());
    }

    public void testWrite() throws IOException {
        VorbisComments c = new VorbisComments();
        c.setVendor("A1");
        c.addComment("b", "c2a");
        c.addComment("B", "c2b");
        c.addComment("1", "c1");
        OggPacket p = c.write();
        TestVorbisComments.assertEquals((int)44, (int)p.getData().length);
        TestVorbisComments.assertEquals((int)3, (int)p.getData()[0]);
        TestVorbisComments.assertEquals((int)118, (int)p.getData()[1]);
        TestVorbisComments.assertEquals((int)111, (int)p.getData()[2]);
        TestVorbisComments.assertEquals((int)114, (int)p.getData()[3]);
        TestVorbisComments.assertEquals((int)98, (int)p.getData()[4]);
        TestVorbisComments.assertEquals((int)105, (int)p.getData()[5]);
        TestVorbisComments.assertEquals((int)115, (int)p.getData()[6]);
        TestVorbisComments.assertEquals((int)2, (int)p.getData()[7]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[8]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[9]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[10]);
        TestVorbisComments.assertEquals((int)65, (int)p.getData()[11]);
        TestVorbisComments.assertEquals((int)49, (int)p.getData()[12]);
        TestVorbisComments.assertEquals((int)3, (int)p.getData()[13]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[14]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[15]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[16]);
        TestVorbisComments.assertEquals((int)4, (int)p.getData()[17]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[18]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[19]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[20]);
        TestVorbisComments.assertEquals((int)49, (int)p.getData()[21]);
        TestVorbisComments.assertEquals((int)61, (int)p.getData()[22]);
        TestVorbisComments.assertEquals((int)99, (int)p.getData()[23]);
        TestVorbisComments.assertEquals((int)49, (int)p.getData()[24]);
        TestVorbisComments.assertEquals((int)5, (int)p.getData()[25]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[26]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[27]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[28]);
        TestVorbisComments.assertEquals((int)98, (int)p.getData()[29]);
        TestVorbisComments.assertEquals((int)61, (int)p.getData()[30]);
        TestVorbisComments.assertEquals((int)99, (int)p.getData()[31]);
        TestVorbisComments.assertEquals((int)50, (int)p.getData()[32]);
        TestVorbisComments.assertEquals((int)97, (int)p.getData()[33]);
        TestVorbisComments.assertEquals((int)5, (int)p.getData()[34]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[35]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[36]);
        TestVorbisComments.assertEquals((int)0, (int)p.getData()[37]);
        TestVorbisComments.assertEquals((int)98, (int)p.getData()[38]);
        TestVorbisComments.assertEquals((int)61, (int)p.getData()[39]);
        TestVorbisComments.assertEquals((int)99, (int)p.getData()[40]);
        TestVorbisComments.assertEquals((int)50, (int)p.getData()[41]);
        TestVorbisComments.assertEquals((int)98, (int)p.getData()[42]);
        TestVorbisComments.assertEquals((int)1, (int)p.getData()[43]);
    }
}

