# Generated by default/object.tt
package Paws::SecurityHub::ActionRemoteIpDetails;
  use Moose;
  has City => (is => 'ro', isa => 'Paws::SecurityHub::City');
  has Country => (is => 'ro', isa => 'Paws::SecurityHub::Country');
  has GeoLocation => (is => 'ro', isa => 'Paws::SecurityHub::GeoLocation');
  has IpAddressV4 => (is => 'ro', isa => 'Str');
  has Organization => (is => 'ro', isa => 'Paws::SecurityHub::IpOrganizationDetails');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::ActionRemoteIpDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::ActionRemoteIpDetails object:

  $service_obj->Method(Att1 => { City => $value, ..., Organization => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::ActionRemoteIpDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->City

=head1 DESCRIPTION

For C<AwsApiAction>, C<NetworkConnectionAction>, and
C<PortProbeAction>, C<RemoteIpDetails> provides information about the
remote IP address that was involved in the action.

=head1 ATTRIBUTES


=head2 City => L<Paws::SecurityHub::City>

The city where the remote IP address is located.


=head2 Country => L<Paws::SecurityHub::Country>

The country where the remote IP address is located.


=head2 GeoLocation => L<Paws::SecurityHub::GeoLocation>

The coordinates of the location of the remote IP address.


=head2 IpAddressV4 => Str

The IP address.


=head2 Organization => L<Paws::SecurityHub::IpOrganizationDetails>

The internet service provider (ISP) organization associated with the
remote IP address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

