/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.gcc.GccLinker;
import net.sf.antcontrib.cpptasks.parser.CParser;
import net.sf.antcontrib.cpptasks.parser.Parser;
import org.apache.tools.ant.types.Environment;

public final class WindresResourceCompiler
extends CommandLineCompiler {
    private static final WindresResourceCompiler instance = new WindresResourceCompiler(false, null);

    public static WindresResourceCompiler getInstance() {
        return instance;
    }

    private WindresResourceCompiler(boolean newEnvironment, Environment env) {
        super("windres", null, new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".o", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        if (debug) {
            args.addElement("-D_DEBUG");
        } else {
            args.addElement("-DNDEBUG");
        }
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new WindresResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    protected Parser createParser(File source) {
        return new CParser();
    }

    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return "-I" + includeDir;
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String outputFileName = this.getOutputFileNames(filename, null)[0];
            return "-o" + outputFileName;
        }
        return filename;
    }

    public Linker getLinker(LinkType type) {
        return GccLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return Short.MAX_VALUE;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        return arg1.length() + arg2.length() + 2;
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }

    public String getIdentifier() {
        return "GNU windres";
    }
}

