use utf8;
package App::Yath::Schema::SQLite::Resource;
our $VERSION = '2.000004'; # TRIAL

package
    App::Yath::Schema::Result::Resource;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY ANY PART OF THIS FILE

use strict;
use warnings;

use parent 'App::Yath::Schema::ResultBase';
__PACKAGE__->load_components(
  "InflateColumn::DateTime",
  "InflateColumn::Serializer",
  "InflateColumn::Serializer::JSON",
);
__PACKAGE__->table("resources");
__PACKAGE__->add_columns(
  "event_uuid",
  { data_type => "uuid", is_nullable => 0 },
  "resource_id",
  { data_type => "integer", is_auto_increment => 1, is_nullable => 0 },
  "resource_type_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 0 },
  "run_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 0 },
  "host_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 1 },
  "stamp",
  { data_type => "datetime", is_nullable => 0, size => 6 },
  "resource_ord",
  { data_type => "integer", is_nullable => 0 },
  "data",
  { data_type => "json", is_nullable => 0 },
);
__PACKAGE__->set_primary_key("resource_id");
__PACKAGE__->add_unique_constraint("run_id_resource_ord_unique", ["run_id", "resource_ord"]);
__PACKAGE__->belongs_to(
  "host",
  "App::Yath::Schema::Result::Host",
  { host_id => "host_id" },
  {
    is_deferrable => 0,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "NO ACTION",
  },
);
__PACKAGE__->belongs_to(
  "resource_type",
  "App::Yath::Schema::Result::ResourceType",
  { resource_type_id => "resource_type_id" },
  { is_deferrable => 0, on_delete => "CASCADE", on_update => "NO ACTION" },
);
__PACKAGE__->belongs_to(
  "run",
  "App::Yath::Schema::Result::Run",
  { run_id => "run_id" },
  { is_deferrable => 0, on_delete => "CASCADE", on_update => "NO ACTION" },
);


# Created by DBIx::Class::Schema::Loader v0.07052 @ 2024-08-01 07:24:11
# DO NOT MODIFY ANY PART OF THIS FILE

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Yath::Schema::SQLite::Resource - Autogenerated result class for Resource in SQLite.

=head1 SEE ALSO

L<App::Yath::Schema::Overlay::Resource> - Where methods that are not
auto-generated are defined.

=head1 SOURCE

The source code repository for Test2-Harness can be found at
L<http://github.com/Test-More/Test2-Harness/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright Chad Granum E<lt>exodist7@gmail.comE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See L<http://dev.perl.org/licenses/>

=cut
