/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class GraphvizVersionFinder {
    private final File dotExe;

    public GraphvizVersionFinder(File file) {
        this.dotExe = file;
    }

    public GraphvizVersion getVersion() {
        String string = this.dotVersion();
        if (string.contains("2.34.0")) {
            return GraphvizVersion.V2_34_0;
        }
        return GraphvizVersion.COMMON;
    }

    public String dotVersion() {
        String[] stringArray = this.getCommandLine();
        ProcessRunner processRunner = new ProcessRunner(stringArray);
        ProcessState processState = processRunner.run(null, null);
        if (processState != ProcessState.TERMINATED_OK) {
            return "?";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(processRunner.getOut())) {
            stringBuilder.append(processRunner.getOut());
        }
        if (StringUtils.isNotEmpty(processRunner.getError())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(processRunner.getError());
        }
        return stringBuilder.toString().replace('\n', ' ').trim();
    }

    private String[] getCommandLine() {
        return new String[]{this.dotExe.getAbsolutePath(), "-V"};
    }
}

