use 5.006;
use strict;
use warnings;
use Module::Build;

# Generate also README.md
# Testing: ./Build.PL; ./Build distmeta
# (alternatively we could override ACTION_distmeta, but this seems nicer)
my $class = Module::Build->subclass(
    class => 'MEKK::Module::Build',
    code => q{
        sub do_create_readme {
            my $self = shift;
            $self->SUPER::do_create_readme;  # Default
            my $docfile = $self->_main_docfile or return;  # Warning already emitted
            require Pod::Readme; require Pod::Markdown;
            $self->log_info("Creating README.md\n");
            my $parser = Pod::Readme->new(
                input_file => $docfile,
                translate_to_file => 'README.md',
                translation_class => 'Pod::Markdown');
            $parser->run;
            $self->_add_to_manifest('MANIFEST', 'README.md');
        }
    }
   );

my $builder = $class->new(
    module_name         => 'Passwd::Keyring::PWSafe3',
    license             => 'perl',
    dynamic_config      => 1,

    build_requires => {
        'Module::Build' => '0.36',
        'Test::More' => 0,
        'Test::Pod::Coverage' => '1.0',
        'Pod::Readme' => '1.001002',
        'Pod::Markdown' => '2.0',
    },
    configure_requires => {
        'Module::Build' => '0.36',
    },
    requires => {
        'perl' => 5.009002, # pack(W) in Crypt::PWSafe3, http://search.cpan.org/~rgarcia/perl-5.9.2/pod/perl592delta.pod#Packing_and_UTF-8_strings
        'Crypt::PWSafe3' => '1.15', # 1.07 fixes huge performance problems, 1.11 fixes pack errors reported when password expire is set (I have such in my tests) but has quirks fixed in 1.12, 1.15 fixes corner-case tempfile problems
        'Bytes::Random::Secure' => '0.09', # performance fix works only when this module is present, without it PWSafe3 is very slow
        'Term::ReadKey' => 0, # for interactive password prompts
        'File::HomeDir' => 0,
    },
    recommends => {
        'Math::Random::ISAAC::XS' => 0,  # makes Bytes::Random::Secure faster
    },

    share_dir => {
        dist => [ 'example' ],
    },

    create_makefile_pl => 'traditional',
    add_to_cleanup      => [ 'Passwd-Keyring-PWSafe3-*' ],

    create_readme       => 1,
    dist_author         => q{Marcin Kasperski <Marcin.Kasperski@mekk.waw.pl>},
    dist_version_from   => 'lib/Passwd/Keyring/PWSafe3.pm',
    meta_merge => {
        keywords => [ qw/ passwords security secure-storage keyring KDE PWSafe3 / ],
        resources => {
            license    => 'http://dev.perl.org/licenses/',
            homepage   => 'https://helixteamhub.cloud/mekk/projects/perl/repositories/keyring-pwsafe3',
            repository => 'https://helixteamhub.cloud/mekk/projects/perl/repositories/keyring-pwsafe3',
            bugtracker => 'https://helixteamhub.cloud/mekk/projects/perl/issues',
        },
    },
);

$builder->create_build_script();
