# Generated by default/object.tt
package Paws::DMS::ReplicationTaskIndividualAssessment;
  use Moose;
  has IndividualAssessmentName => (is => 'ro', isa => 'Str');
  has ReplicationTaskAssessmentRunArn => (is => 'ro', isa => 'Str');
  has ReplicationTaskIndividualAssessmentArn => (is => 'ro', isa => 'Str');
  has ReplicationTaskIndividualAssessmentStartDate => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::ReplicationTaskIndividualAssessment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::ReplicationTaskIndividualAssessment object:

  $service_obj->Method(Att1 => { IndividualAssessmentName => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::ReplicationTaskIndividualAssessment object:

  $result = $service_obj->Method(...);
  $result->Att1->IndividualAssessmentName

=head1 DESCRIPTION

Provides information that describes an individual assessment from a
premigration assessment run.

=head1 ATTRIBUTES


=head2 IndividualAssessmentName => Str

Name of this individual assessment.


=head2 ReplicationTaskAssessmentRunArn => Str

ARN of the premigration assessment run that is created to run this
individual assessment.


=head2 ReplicationTaskIndividualAssessmentArn => Str

Amazon Resource Name (ARN) of this individual assessment.


=head2 ReplicationTaskIndividualAssessmentStartDate => Str

Date when this individual assessment was started as part of running the
C<StartReplicationTaskAssessmentRun> operation.


=head2 Status => Str

Individual assessment status.

This status can have one of the following values:

=over

=item *

C<"cancelled">

=item *

C<"error">

=item *

C<"failed">

=item *

C<"passed">

=item *

C<"pending">

=item *

C<"running">

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

