# This Makefile.PL for Win32-Daemon was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use Config qw(%Config);
require Win32;

# Sorry, we can't support cygwin right now. We'd love for you to fix the
# compilation problems and submit a PR to get it back, though!!
unless ($^O eq "MSWin32") { # || $^O eq "cygwin") {
    die "OS unsupported\n";
}

my %xsbuild = (
    XS => { 'Daemon.xs' => 'Daemon.cpp', },
    OBJECT  => 'CCallbackList$(OBJ_EXT) CCallbackTimer$(OBJ_EXT) constant$(OBJ_EXT) CWinStation$(OBJ_EXT) Daemon$(OBJ_EXT) ServiceThread$(OBJ_EXT)',
);
$xsbuild{NO_META} = 1 if eval { ExtUtils::MakeMaker->VERSION('6.10_03') };
$xsbuild{INC} .= ' -EHsc' if $Config{'cc'} =~ /^cl/i;

sub MY::xs_c {
    '
.xs.cpp:
	$(PERL) -I$(PERL_ARCHLIB) -I$(PERL_LIB) $(XSUBPP) $(XSPROTOARG) $(XSUBPPARGS) $*.xs >xstmp.c && $(MV) xstmp.c $*.cpp
';
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Extension enabling Win32 Perl scripts to run as a true Win32 service.",
  "AUTHOR" => "Dave Roth <daveroth\@cpan.org>",
  "BUILD_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "Win32" => 0
  },
  "DISTNAME" => "Win32-Daemon",
  "LICENSE" => "perl",
  "NAME" => "Win32::Daemon",
  "PREREQ_PM" => {
    "Exporter" => 0,
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Test::More" => "0.88"
  },
  "VERSION" => 20181025,
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %xsbuild,
);

my %FallbackPrereqs = (
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "Test::More" => "0.88",
  "XSLoader" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
