#!/usr/bin/env perl

use Amazon::API qw{param_n get_api_service};
use Data::Dumper;

my $attributes
  = { Attributes => [ { Name => 'VisibilityTimeout', Value => '100' } ] };

my @sqs_attributes = Amazon::API::param_n($attributes);

my $tags
  = { Tag =>
    [ { Key => 'Name', Value => 'foo' }, { Key => 'Env', Value => 'dev' }, ]
  };

my @sqs_tags = Amazon::API::param_n($tags);

print Dumper( [ 'QueueName=foo', @sqs_attributes, @sqs_tags ] );

my $queues = Amazon::API->new(
  { service     => 'sqs',
    http_method => 'GET',
    debug       => $ENV{DEBUG},
  }
)->invoke_api('ListQueues');

print Dumper( [$queues] );

my $sqs = get_api_service( 'sqs', debug => $ENV{DEBUG} );

my $response
  = $sqs->CreateQueue( [ 'QueueName=foo', @sqs_attributes, @sqs_tags ] );

print Dumper( [$response] );

my $queue_url = $response->{CreateQueueResult}->{QueueUrl};

print Dumper(
  [ $sqs->GetQueueAttributes(
      { QueueUrl => $queue_url, AttributeNames => 'All' }
    )
  ]
);

1;
