#!/usr/bin/perl

package eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RespondToFeedbackRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackRequestType

=head1 DESCRIPTION

Enables users to reply to feedback left by the other
party in the transaction and/or follow up on the
feedback left for the other party.
You cannot use the API for mutual feedback withdrawal,
even though this functionality is available on the eBay site.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::FeedbackResponseCodeType;


my @gaProperties = ( [ 'FeedbackID', 'xs:string', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ResponseText', 'xs:string', '', '', '' ]
	, [ 'ResponseType', 'ns:FeedbackResponseCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::FeedbackResponseCodeType', '' ]
	, [ 'TargetUserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFeedbackID()

ID that uniquely identifies the feedback.
FeedbackIDs can be retrieved by using
GetFeedback. Required if ItemID is not
specified.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setFeedbackID {
  my $self = shift;
  $self->{'FeedbackID'} = shift
}

=head2 getFeedbackID()

#    Returns: 'xs:string'

=cut

sub getFeedbackID {
  my $self = shift;
  return $self->{'FeedbackID'};
}


=head2 setItemID()

Unique identifier of an item to which the
feedback is attached. Required if FeedbackID is
not provided.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setResponseText()

Textual comment that the user who is
subject of feedback may leave in response or
rebuttal to the feedback. Alternatively, when
the  ResponseType is FollowUp, this value
contains the text of the follow-up comment. Max
length is 125 for the Taiwan site.

MaxLength: 80

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setResponseText {
  my $self = shift;
  $self->{'ResponseText'} = shift
}

=head2 getResponseText()

#    Returns: 'xs:string'

=cut

sub getResponseText {
  my $self = shift;
  return $self->{'ResponseText'};
}


=head2 setResponseType()

Specifies whether the response is a reply
or a follow-up.

  RequiredInput: Yes
#    Argument: 'ns:FeedbackResponseCodeType'

=cut

sub setResponseType {
  my $self = shift;
  $self->{'ResponseType'} = shift
}

=head2 getResponseType()

#    Returns: 'ns:FeedbackResponseCodeType'

=cut

sub getResponseType {
  my $self = shift;
  return $self->{'ResponseType'};
}


=head2 setTargetUserID()

User who left the feedback that is being
replied to or followed up on.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut

sub setTargetUserID {
  my $self = shift;
  $self->{'TargetUserID'} = shift
}

=head2 getTargetUserID()

#    Returns: 'ns:UserIDType'

=cut

sub getTargetUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TargetUserID'
		,'eBay::API::XML::DataType::UserIDType');
}


=head2 setTransactionID()

Unique identifier for a purchase from an
eBay Stores Inventory or basic fixed price
listing. If TransactionID is specified, ItemID
must also be specified.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
