use strict;
use warnings;
use Test::More;
use Digest::Keccak qw(keccak_224 keccak_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Keccak->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            keccak_224_hex($data), $digest,
            "keccak_224_hex: $len bits of $msg"
        );
        ok(
            keccak_224($data) eq pack('H*', $digest),
            "keccak_224: $len bits of $msg"
        );
    }

    my $md = Digest::Keccak->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|F71837502BA8E10837BDD8D365ADB85591895602FC552B48B7390ABD
00|860E3EC314C5CBF19C1A4314E9EA8CB85CECD18BD850B42F5C6F2A07
C0|6B22CDDBD1366F7B8DB2026AEE8A0AFA86B323AED7AA270AD928D1C5
C0|2B695A6FD92A2B3F3CE9CFCA617D22C9BB52815DD59A9719B01BAD25
80|BFA0740D2F2EDCDEE2DB3F66F04FB8179967D3FB5981644D9D084BD7
48|E4384016D64610D75E0A5D73821A02D524F847A25A571B5940CD6450
50|A0FB02F1D41BC09CC4B3E85B15BE85E3B3C2D43EB36DD616C640D7CA
98|C00ECD3072762C82D08F8F76FECF38BE23075F9C5663D06A9184BD0B
CC|A9CAB59EB40A10B246290F2D6086E32E3689FAF1D26B470C899F2802
9800|5720E4308A3EA6F412A9E22AC3846579150BCCEB8F1E20836DA610B4
9D40|5B464B1929CBB8FA7C2036D3F3ADFEB885257E5EA65610B31D57C3DD
AA80|E534929C710AEF8D794993A5603AB8DCE13F90261DA0F20B76C606A9
9830|548C76FF8FEB36FD7AE767F442F0AF32461A72ECBB70F7624C465BAF
5030|F06E9C525F7D0AF9AD7DA2BECDE216B8EE5C24BD05DB8EEAEE4AB17D
4D24|C31A82A1E34BCFB48A9E16FA2F33D9BEC1BF919111E1ACB36F947069
CBDE|7A33EC1EFD89305E9ED7F71AA2DAF5595C35CF71129F50AB8E789282
41FB|615BA367AFDC35AAC397BC7EB5D58D106A734B24986D5D978FEFD62C
4FF400|94D5B162A324674454BBADB377375DA15C3BE74225D346010AE557A9
FD0440|898CB38D96598F42BDD1D1644420F65D99085D8AE129DAD9FA00EBC7
424D00|E8E7B4D902425DAEFC1050D6239D501E596F80749BF3E3FB12E8F757
3FDEE0|BF40E4D1A33A719FABC2AC4D8010649B6B3228B5279BAA91F7A8B59C
335768|72F0D82FBDF5D0705E3DCC9E1B3BA0A2ECF76A63FBFA077B0D962A35
051E7C|74C70F1985CDDE1185564A210B77499C30BD72472E306A004E7686F5
717F8C|D71BDEFD0EC94933643140CBAFC622F7A156DB7FEA5878A839FBDAA6
1F877C|6F9D2898EFD096BAAAAAB2E97482DDB6389B8E6CAA964B7A0E347E13
EB35CF80|09260888DADDDA3BF29487346A4DF10FAFD72D40E420AC8DF94E8438
B406C480|FD9A92C593AECCAA94BEACD310B83F88B3E67E7BDB825BAEF311B8AB
CEE88040|10F444B9E23743B29D8000F0118257D6E2BD986C3BB11BCD40FC1496
C584DB70|5A5F498AD3B0016DAE1AA51D31033B1477B449D9F7E48CEB7AD20471
53587BC8|E7B462FE88FE41B20C5E11D2125D1788383CC5C0EC7E9E8AEF1A7532
69A305B0|CC782A50B955801EFA399A4499A582D49B8636BCC5AD376694B4F3F2
C9375ECE|3C4B7B7AFBE979DF4D87EEEC8E6D15B6B0D97EDD9EDF9A01739A0C7B
C1ECFDFC|E405869DA1464A705700A3CBCE131AABEEBA9C8D2FE6576B21BCBE16
8D73E8A280|B39D6BC02265FBCA1AD221F084AFF3CDFF13E11B515E65562ABD3E39
06F2522080|651ECCB5C0F55F97D33C817BCC7CDCF0C508A042D1E7E5D10180AF41
3EF6C36F20|0C3D280A84F9C8E7BD6EEE3524A8C87889A691928AE3D14D355B9C24
0127A1D340|50EAE81AAD60BD33821398B7E4F03645BC64D2A9E4B2265ADA63FE93
6A6AB6C210|AFCDBC12717B1AEB4321FC753B7396550D3E8E67A91B73437EE5C0F8
AF3175E160|54C71FA8BC7F884D4BA65788F7F815BA1EBDE20D4331582BD071B258
B66609ED86|7903AF4F749DFB59995F8DB4F77F23ECB05710BA8C58DBBA713240C1
21F134AC57|5573DA2B02216A860389A581F6E9FB8D805E9E02F6FA911701EEE298
3DC2AADFFC80|51C4D2A09822C7D0D0B675E5E0BB695D58D3DD041A7E98FAD79F8504
9202736D2240|9DF739B384C6A34C3CC28EF9BC133D39D318697A5ED7BFAB42705AD8
F219BD629820|BD2D06E2B0F56A8D8343F8C4CF075B917E3B422E748A99F7DC080248
F3511EE2C4B0|698DD0FD85BC581A5CE04DC35E49C4874F3C49C51B1EA8823577ABCB
3ECAB6BF7720|6BA99B770B148B5BF74ACCF2FD0DCA926D268144FFCA209173393808
CD62F688F498|17DD2CB98F577FED70751FD6DEBEBF32C65B9DDF89482A3A8885C7F2
C2CBAA33A9F8|A29E7ED06A08AA7107DA0E0BB0F05A7F733FCBCFCFE7189C3F4C4FA8
C6F50BB74E29|163C9060163AA66B8B7C0CFAA65D934BFF219BCBC267187CABA0042F
79F1B4CCC62A00|BB54D988BBF70789AC15966BBB5F5E839D515451F07064B3700D8C1D
