# Generated by default/object.tt
package Paws::SSMIncidents::IncidentRecordSource;
  use Moose;
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest'], required => 1);
  has InvokedBy => (is => 'ro', isa => 'Str', request_name => 'invokedBy', traits => ['NameInRequest']);
  has ResourceArn => (is => 'ro', isa => 'Str', request_name => 'resourceArn', traits => ['NameInRequest']);
  has Source => (is => 'ro', isa => 'Str', request_name => 'source', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::IncidentRecordSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::IncidentRecordSource object:

  $service_obj->Method(Att1 => { CreatedBy => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::IncidentRecordSource object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedBy

=head1 DESCRIPTION

Details about how the incident record was created and when.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreatedBy => Str

The principal that started the incident.


=head2 InvokedBy => Str

The principal the assumed the role specified of the C<createdBy>.


=head2 ResourceArn => Str

The resource that caused the incident to be created.


=head2 B<REQUIRED> Source => Str

The service that started the incident. This can be manually created
from Incident Manager, automatically created using an AWS CloudWatch
alarm, or Amazon EventBridge event.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

