/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UImageSvg
implements UShape {
    private final String svg;

    public UImageSvg(String string) {
        if (string.startsWith("<?xml")) {
            int n = string.indexOf("<svg");
            string = string.substring(n);
        }
        this.svg = string;
    }

    public final String getSvg() {
        if (this.svg.startsWith("<svg")) {
            int n = this.svg.indexOf(">");
            return "<svg>" + this.svg.substring(n + 1);
        }
        return this.svg;
    }

    private int getData(String string) {
        Pattern pattern = Pattern.compile("(?i)" + string + "\\W+(\\d+)");
        Matcher matcher = pattern.matcher(this.svg);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return Integer.parseInt(string2);
        }
        throw new IllegalStateException("Cannot find " + string);
    }

    public int getHeight() {
        return this.getData("height");
    }

    public int getWidth() {
        return this.getData("width");
    }
}

