use strict;
use warnings;
use Test::More;
use File::Find;
use Path::Tiny;


#search all modules as file paths
my @modules;
sub wanted {
    $File::Find::name=~ m#SLUB/LZA/.+\.(pm|t)$# && -f $_ && push @modules, $File::Find::name;
}
find(\&wanted, "lib/", "t/");

foreach my $module (@modules) {
    my $content = path( $module )->slurp;
    if ($content =~ m/^use diagnostics;/m) {
        fail("module $module has 'use diagnostics;', but should only be used for debugging. It could be enabled via 'perl -Mdiagnostics=-traceonly my_script.pl'");
    } else {
        pass("module $module is fine.");
    }
}
done_testing();
1;
