# Generated by default/object.tt
package Paws::CloudWatchEvents::SageMakerPipelineParameters;
  use Moose;
  has PipelineParameterList => (is => 'ro', isa => 'ArrayRef[Paws::CloudWatchEvents::SageMakerPipelineParameter]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::SageMakerPipelineParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::SageMakerPipelineParameters object:

  $service_obj->Method(Att1 => { PipelineParameterList => $value, ..., PipelineParameterList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::SageMakerPipelineParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->PipelineParameterList

=head1 DESCRIPTION

These are custom parameters to use when the target is a SageMaker Model
Building Pipeline that starts based on EventBridge events.

=head1 ATTRIBUTES


=head2 PipelineParameterList => ArrayRef[L<Paws::CloudWatchEvents::SageMakerPipelineParameter>]

List of Parameter names and values for SageMaker Model Building
Pipeline execution.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

