use strict;
use warnings;
use Test::More tests => 68;
use Digest::BMW qw(bmw_512 bmw_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BMW->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(bmw_512_hex($data), $digest, "bmw_512_hex: $len bits of $msg");
        ok(
            bmw_512($data) eq pack('H*', $digest),
            "bmw_512: $len bits of $msg"
        );
    }

    my $md = Digest::BMW->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|6A725655C42BC8A2A20549DD5A233A6A2BEB01616975851FD122504E604B46AF7D96697D0B6333DB1D1709D6DF328D2A6C786551B0CCE2255E8C7332B4819C0E
00|467580F28CA0F052181805B17CD70998FB24A44B6979FDD4E8C69DAAB7791E8BEEA6F5770221A44E9A11AB12DE629C81DE1EEED02937F3A08397F3D45D8822F6
C0|8C5A6EC6C210B5CD8EBC74CBE8DEA276B26683D0A754C89F9696E4D2CA4F817369E30EA98920E81FAE47C5770F32481B4EEB536A9D8D6F397878595AD1E385BB
C0|711E9E1B4F5780C38B88A87C5DFC179DA440AEFA82241C098FD0460766E76805D7ADB8B07F986BA4E1B9A696F0CD31E92807938A6110A34C0A3A9F6D6EDF929D
80|4CF796D2ECD9C118B2FCF39E900CE650A66A2CB5434B8F47B2E48EA33004DAC1B8AD2131CDA4A33B3F08C0FD7FE4BD1796AE2995A61AD023257F80C9FA186F4C
48|A578381AC0F30A676110590A68646F0700B3A673CA706EA60B4DA3479CFA6F7DC7B0C8586B9D6CFAC0E72F8E85308995823C3E0139FD8D2BF2422554949A5AFD
50|B397E58D6F0AD402F6AA3D19C7B99A05BA95BAE25EC8E3298CA9F822FCB6F1CE4F0B502B29100011CD53B031E38D124F68BAA15AD032D51BCD275A15556F39DF
98|866B68E2CB4ED67E8C67F1BD726AB8B7B22193CE29F41472F22368BB15978A462AC05B6D6EECB0E31E54EA1AA3E3E52C843D9E10FDFAC7826885334C00F135AB
CC|0309CD7A44E6022671E84C43CDB92F613931D1C6B71467C039034B1263C2BF92203E27604BC53FCEA9C2DF3B10862C9B6FB6E8C617754EF49A2B80F51C74ACD3
9800|1BAA70070395668A8D673D13C1D8A9AFD7E351688B9B39995355D4F9D8586C02C885F609542CC866F28B6B0369A54D1D6EF19F80B366F6B8710354ADCE037267
9D40|1B87C0ADA6269B234BC6346E72C11F5702026383FEDC203653E02FFA3889AB2C48C9F3A1D8812D184C9B29B98C5100179694C40EBF0E8189726096CB2DBDAB0B
AA80|BD215EF42F99580C6003FF46729B4E5F68697B3CD9DE514492CE148497290CA34F2001548006076048EA2D5C55C3468D0C99104DB8D0D146BC87577E99A3B480
9830|AFD673D046942F18C28853D77BBA01D3C2DF8EDD5AF151740CF0D1A7AC5D3C1D118C69F304252FBD49E926E47FA3AB1A57CD22547C87D6CA20C7BC68ADF34BD4
5030|B931A4DDC7A7DB986C2BE42BBC4DD2BD1796D108C5B5280746029FFC7DB815D55AC0E4EED7BF811208EA81CA5374A11B1C17D4DE62DEC7ABB18E603D176523A0
4D24|E761A712C471335B8C8C8ECB7BBD4AD3C09FAB4C58F1CDD880F3D971633283DCC678FE001A9B4E2159DFB9057F57E1CFF571734026EA271D868A3091C4D5FD1A
CBDE|EF52418920EE702483C657E64AC68392D29EEB1A3CD407D48773477296D289804BF9ABC0F51A0AE9C06D235EDFC083C9607C1DC9355841F47841AAA6367F9885
41FB|1FD4AC6551D39EF27B5F1F886D7A3A72EC60E0AE2966649C3701952F29B2DBF858AB6E18101D038BBF019299C7FE5F62A4BC3973E089EF929AAF25B9A8BB7D39
4FF400|46859CFFEEAA9B28E91BA4C86BC9F21E4CD26139E632A09DF4F95489D8CBD479A6B24F277C27170EA2F417A6893A1B5F026F8144628E1D7E15F1C334A857EFB8
FD0440|24C01394677A70383CEEEF512A889562289BA38F1533CE72ED52D5AB05686D7C22A55CFA340A1D9A262E590B345CBE6734321AB980FCD37F272367F49EA08903
424D00|B1C092B3945D2692272E3C6D9B80DA4F8199D7EFFE47B5F4FCC2370EE03A5FE8F9D0E3295F1E0FC8B5D41093927981EE9025F30D1E349C2DC311EB26D0E3E122
3FDEE0|C2024D61EA57F3190FB87D703823613F689D20C1A19DC27813C3B331AB3ACE7B20D0DCDD95F86EC3F3FE5C34B92451121C1E6592F7EC5FAD7A8CF86C6FB8D9AE
335768|0D0B9053F8C1BA149E3841243F70910AB2F3A68040786AD2BCF896781695CFD5ABF13D2FF518455D026310EA62598DC695C2A63190015542FC1C30F92640E81B
051E7C|B7D5E57E6B891DBB22D7BDFBD9CBF5C096F2DEB85FF9BA96496E2BF461B6E93878B55D63699787B7C322EFEEAED0CEB67CACE9E73A77F11ADE70BDDAAAE7E142
717F8C|5EEEDE9F88748F82138D4F174105FA209CE5A5BC8046D43AB4F6FCDC442DAE82358D994C9BF7879E3D88CF629199A032F243629B57D16A959071D95273F0A747
1F877C|8987D458CF27D4C1B1DDD115FE5C15A67AF431561812B1D2028C3AF0A52FB8F7334205CBE003CEAB1446261550870EEA6921C2315D750F9C49AD7877590A9BDE
EB35CF80|1881B71919DDD4862560CF512F1EE491AD8FC9CA08064BF418F2FD7B65E32314188AD6D777C87AF8DE0CBEBC7C94204C7E4B11D48F120631D73EE28EC4E3C9A4
B406C480|3E8D852E1C4B693D7A376FF4141A2C88294857C9BC9D27E95B21F643E4B41AF766FAA45A62E2630601427E3918BD5C94AE5E31B110DB31A05DB3DC2B8BA10311
CEE88040|15B5C4262A8740E5FD7E8073DD6A778A9CA7AECBBF296200E904BE44C73265C2449E3EF2F74938AC77F610B9D43CA1DE0374061C4B8F9899E69D0105C1F01A25
C584DB70|C5FBB44FA7A97FA43B7490B6A16F73561ED9850C8EBAC1115F85BC81C940E4CCEB002C47245394BDFCEB07A5147DC6B864B78B2A1BB0902617BBB44E3A55C4F8
53587BC8|980DDE262F1C2B3211AB639D360C57AFA91A5F693A58090B4137006C2630908A02E91F23AF5D885232EB8018BAFBAFAD68C1D73ACADA14923CC974631BEE70EA
69A305B0|AF9096EA2A31E5DE9B0E7502E1D3FA8E0B74438167E2A42B9FA7260E3CC9DE784804E4F02FEB3692D9E17EBE53612376231B6D8EFA2826220FFBBA9EC192974A
C9375ECE|44D5D4CC2BA271AC58FCC1137D9E5922197159775F1056CFE37864463DAE4D99F67EE4625032E0723D4773B83CD12A1102EEC7B6547A3C30F90CDBA9D99861AE
C1ECFDFC|5A443348F0B3330CBA5060B16EF21D5597ECDD597603B3E86999099C5595BE38F726D10090472DAF5EA77315B6BA62B2507A7C08A1B6786DCB30148DD1517882
8D73E8A280|766975B71189FA8798400569A04A5048C7B9E6F2ECE8689511165FFC8AD1E85176556237FE8DC6765010421A1AABA62BEBF51BCDADC8094BFBA75D9F224DB2F1
06F2522080|0322BCBA0612D15DB706DC85ED6376628A83FCC43023F8DC03A588FF7A463658D562CF9395BF6629470F49D1069F17C9137C4FD37E349E4E07A9BE4EDEF5D049
3EF6C36F20|6DF998A62AB331F68B3DD1121566CD7810DAFD01A1A49CDC9A14B5A84EE3DCC727C6DB9B79873C5DE8D163A39768FDE896A2AF133F1F5D497FE248FD339D77B7
0127A1D340|0925AE71AC645ADFC7489B0636E2CE50C4C1293FF2F35FD23217E34D701FD56EDF8C70563D0C73A8D51BAC87A2EF2332A503EEE35096BE9D8026761180A2E32C
6A6AB6C210|A125449119D45E1E1DD809A788616048BC213211EB26B71CF6B9EFA5CA6D98C54984348FA69FC214FBB6786A5CE9C0A9169CE111F6636DFC7E2AA9F2E1CAD535
AF3175E160|57616A66A461E20A312D04516CC18F858FBB807BEF87C698F138420639C1455E78B0E06F4549CADFEA1C2B3DCB39CFA196FA0E989D84C2EAD9AC346E1121DEA6
B66609ED86|216606114B59D5976525FE584A4C1DCB9E195A74F44127F51027352ADEC395C231CAED10613EDA012FAEF022FEF5FC4A1BF13E84F264202BB6D2FCF29AF3297F
21F134AC57|C1ABFEF8AC91FDC20900045A226EA8D5FF2E3E5D0F00CC9194D19F65460755587F72492E5D5F5A30AE63F95E9DFEE6F07051A8E9856E701451BE1CC58D320E3D
3DC2AADFFC80|ADD1425AAC75267308FE38C0D2B3DE6700D02019EF11CC49C403A395DD1BF5333D6FA20C45DE46B408A85465E2F1D9290E93781AF6A84A348DED5B184DF40951
9202736D2240|C76E4816F77E067DBE23CE3E24D6EB486B24A7376EDBD02BFE427FE0BA28F603AFC804F6DE97E448F83792B53E945C281DC5BD1B622BA0B7F1DB6F62FEC27D4D
F219BD629820|DF89F9748ECC0340BACD56AD2854FE0E0B9A4ED7D24BF081A2BCFE48F6B8974BFEE5ACDDD9045E9A13029EDE9D552672EFC551F0378EB5B434BE57D9B4C46146
F3511EE2C4B0|99EC8D0CAE73E1D9C794F53B3DAAECACC249F6292395AE030D81F35FB0BB3864606753C1C92E7E16EA23A3ACD29845E9586C03E4FA5E722091011F80499EA803
3ECAB6BF7720|E6EFD789A5F1786CF0A4BFFFDF79904E329A43AF3A24F87D10A6F94C1D0820B8901DA6DD354F7ED7CDA2FE73BB8895817E966BE738CF217FF2EC27A6FC07624B
CD62F688F498|69D3C3C19105365BA68102A4EA264E67C333B32E05D4D2BDDB43F445431294F2C4DB1107B144E4A5B74217C80250502DF3F5077B60374EC21DFD916FEB45F10E
C2CBAA33A9F8|10874B0407BB34E40C30FD373DC5E603F4AFB344277524DF0AE1C934B256BB19B07A1A898958966702B3FE7C02D11DD898D202C5729141154619A6AF9168ED0F
C6F50BB74E29|B1EC7BD5A91DE2480BEE26C93A84E38030E2B2BC469B7D4A8D91D32CCB889805436739DCB5A14B1D4C0811EE2A0D9A667C0FBA00F48800F39AEBE8D7DA7EDF1C
79F1B4CCC62A00|EED12A66FA690E22961D73D9F1DDBA38BE5A82DF3861CA5089789875A669BB882B99DF83C416A72AF113DFBFB9EE2C75785621383855557C39A5373D22DA05D9
