# Generated by default/object.tt
package Paws::LookoutMetrics::DimensionValueContribution;
  use Moose;
  has ContributionScore => (is => 'ro', isa => 'Num');
  has DimensionValue => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::DimensionValueContribution

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::DimensionValueContribution object:

  $service_obj->Method(Att1 => { ContributionScore => $value, ..., DimensionValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::DimensionValueContribution object:

  $result = $service_obj->Method(...);
  $result->Att1->ContributionScore

=head1 DESCRIPTION

The severity of a value of a dimension that contributed to an anomaly.

=head1 ATTRIBUTES


=head2 ContributionScore => Num

The severity score of the value.


=head2 DimensionValue => Str

The value of the dimension.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

