package Daje::Workflow::Client::Activity;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;
use v5.40;


# NAME
# ====
#
# Daje::Client::Activity - Create a client
#
# SYNOPSIS
# ========
#
#     use Daje::Client::Activity;
#
# DESCRIPTION
# ===========
#
# Daje::Client::Activity is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Daje::Database::Model::Users;
use Daje::Database::Model::Companies;
use Daje::Database::Model::CompaniesUsers;
use Daje::Workflow::Database::Model::Workflow;
use Daje::Workflow::Database::Model::Context;

our $VERSION = "0.03";

sub create_client($self) {
    try {
        $self->model->insert_history("New client will be created", "Daje::Workflow::Client::Activity");
        my $wfl = Daje::Workflow::Database::Model::Workflow->new(db => $self->db);
        my $user_pkey = $self->add_user($wfl);
        if ($self->error->has_error() ==0 ) {
            my $companies_pkey = $self->add_company($wfl);
            if ($self->error->has_error() ==0 ) {
                $self->add_companies_users($companies_pkey, $user_pkey);
                $self->model->insert_history("New client created", "Daje::Workflow::Client::Activity");
            }
        }
    } catch ($e) {
        $self->error->add_error("Adding client failed due to : '$e'");
    };

    return 1;
}

sub add_companies_users($self, $companies_pkey, $users_pkey) {
    my $data->{companies_fkey} = $companies_pkey;
    $data->{users_fkey} = $users_pkey;
    my $result = Daje::Database::Model::CompaniesUsers->new(
        db => $self->db
    )->insert_companies_users(
        $data
    );
    $self->error->add_error($result->{error})
        if exists $result->{error} and $result->{result} == 0;
}

sub add_company($self, $wfl) {
    my $company = $self->context->{context}->{company};
    my $workflow->{name} = "companies";
    $workflow->{state} = "company_active";

    my $workflow_pkey = $wfl->save($workflow);
    $company->{workflow_fkey} = $workflow_pkey;

    my $company_obj = Daje::Database::Model::Companies->new(
        db => $self->db
    );
    my $result = $company_obj->insert_companies($company);
    $self->error->add_error($result->{error})
        if exists $result->{error} and $result->{result} == 0;
    if ($self->error->has_error() == 0) {
        $company->{companies_pkey} = $result->{data}->{companies_pkey};

        my $context->{context} = $company;
        $context->{workflow_fkey} = $workflow_pkey;

        Daje::Workflow::Database::Model::Context->new(
            db            => $self->db,
            workflow_pkey => $workflow_pkey
        )->save(
            $context
        );
    }

    return $result->{data}->{companies_pkey};
}

sub add_user($self, $wfl) {
    my $user = $self->context()->{context}->{user};

    my $user_obj = Daje::Database::Model::Users->new(
        db => $self->db
    );
    my $existing_user = $user_obj->load_users_userid($user->{userid});

    return $existing_user->{data}->{users_pkey} # User exists
        unless exists $existing_user->{data}->{users_pkey}
            and $existing_user->{data}->{users_pkey} > 0;

    my $workflow->{name} = "users";
    $workflow->{state} = "confirmationMail";

    my $workflow_pkey = $wfl->save($workflow);
    $user->{workflow_fkey} = $workflow_pkey;

    my $result = $user_obj->insert_users($user);
    $self->error->add_error($result->{error})
        if exists $result->{error} and $result->{result} == 0;

    if ($self->error->has_error() == 0) {
        $user->{users_pkey} = $result->{data}->{users_pkey};

        my $context->{context} = $user;
        $context->{context}->{mail}->{to} = $user->{userid};
        $context->{context}->{mail}->{template} = "ConfirmEmail";
        $context->{context}->{mail}->{users_pkey} = $result->{data}->{users_pkey};
        $context->{workflow_fkey} = $workflow_pkey;

        Daje::Workflow::Database::Model::Context->new(
            db            => $self->db,
            workflow_pkey => $workflow_pkey,
        )->save(
            $context
        );
    }

    return $result->{data}->{users_pkey};
}

1;
__END__




#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Client::Activity - Create a client



=head1 SYNOPSIS


    use Daje::Client::Activity;



=head1 DESCRIPTION


Daje::Client::Activity is ...



=head1 REQUIRES

L<Daje::Client::Create> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 create_client($self)

 create_client($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

