######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 10
package Geo::Location::TimeZone::K;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 142.5 to 157.5
	"10" => {
		# Grid 10:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"169" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,3",
				"p" => [[142.502258300781,-82.5],[142.502258300781,-90],[142.5,-90],[142.5,-82.5],[142.502258300781,-82.5],],
			},
		},
		# Grid 10:-5 ; 1 records
		"-5" => {
			"170" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,3",
				"p" => [[142.5,-67.5],[142.502258300781,-67.5],[142.502258300781,-82.5],[142.5,-82.5],[142.5,-67.5],],
			},
		},
		# Grid 10:-4 ; 1 records
		"-4" => {
			"171" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,3",
				"p" => [[142.502258300781,-52.5],[142.502258300781,-67.5],[142.5,-67.5],[142.5,-52.5],[142.502258300781,-52.5],],
			},
		},
		# Grid 10:-3 ; 2 records
		"-3" => {
			"def_z1" => "147.3333333,-42.9166667,Australia/Hobart",
			"def_z0" => "144.9666667,-37.8166667,Australia/Melbourne",
			"def_z2" => "143.8666667,-39.9333333,Australia/Currie",
			"172" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,3",
				"p" => [[142.5,-38.0686111450195],[142.5,-38.3780672722922],[142.502258300781,-38.3765296936035],[142.502258300781,-52.5],[142.5,-52.5],[142.5,-37.5],[142.5,-38.0686111450195],],
			},
		},
		# Grid 10:-2 ; 2 records
		"-2" => {
			"def_z1" => "149.131389,-35.282778,Australia/Canberra",
			"def_z0" => "153.0166667,-27.5,Australia/Brisbane",
			"def_z2" => "151.2166667,-33.8833333,Australia/Sydney",
			"1" => {
				"z" => "Australia/Queensland",
				"c" => "GPL - BORDER INCOMPLETE",
				"s" => "custom.10X-2.qld-nsw.border",
				"p" => [[142.5,-29],[148.9,-29],[154,-29],[154,-22.5],[142.5,-22.5],[142.5,-29],],
			},
		},
		# Grid 10:-1 ; 2 records
		"-1" => {
			"def_z1" => "147.1925,-9.4647222,Pacific/Port_Moresby",
			"def_z0" => "149.033333,-20.45,Australia/Lindeman",
			"270" => {
				"z" => "Etc/GMT+11",
				"c" => "ESRI",
				"s" => "17,2",
				"p" => [[157.5,-9.19105295509456],[155.264402735125,-7.5],[157.5,-7.5],[157.5,-22.5],[157.5,-9.19105295509456],],
			},
		},
		# Grid 10:0 ; 1 records
		"0" => {
			"271" => {
				"z" => "Pacific/Truk",
				"c" => "ESRI",
				"s" => "17,2",
				"p" => [[157.5,-7.5],[155.264402735125,-7.5],[155,-7.30000019073486],[157.5,-5.73940746861938],[157.5,-0.0227278313049381],[142.5,-0.0020661664822671],[142.5,7.5],[157.5,7.5],[157.5,-7.5],],
			},
		},
		# Grid 10:1 ; 3 records
		"1" => {
			"def_z1" => "145.75,15.183,Pacific/Saipan",
			"def_z0" => "144.5,13.5,Pacific/Guam",
			"164" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[142.5,22.5],[142.5,19.2308883666992],[142.501007080078,19.2308883666992],[142.501007080078,12],[142.5,12],[142.5,22.5],[145.877456665039,22.5],[142.5,22.5],],
			},
			"272" => {
				"z" => "Etc/GMT+11",
				"c" => "ESRI",
				"s" => "17,2",
				"p" => [[157.5,7.5],[142.5,7.5],[142.5,12],[157.5,12],[157.5,22.5],[157.5,7.5],],
			},
		},
		# Grid 10:2 ; 1 records
		"2" => {
			"165" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[142.501007080078,37.5],[142.501007080078,28.6482677459717],[142.5,28.6482627104833],[142.5,22.5],[142.5,37.5],[145.877456665039,37.5],[142.501007080078,37.5],],
			},
		},
		# Grid 10:3 ; 3 records
		"3" => {
			"def_z" => "Etc/GMT+11",
			"166" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,2",
				"p" => [[142.5,46.0306663513184],[142.5,45.4947180824585],[145.529205322266,44.4486618041992],[145.676528930664,43.536548614502],[145.877456665039,43.3836669921875],[145.857940673828,43.3195495605469],[145.846878051758,43.283203125],[145.545486450195,43.1172218322754],[144.869522094727,42.9269027709961],[144.777770996094,42.9255523681641],[144.463592529297,42.9308242797852],[144.324981689453,42.998046875],[144.0244140625,42.9213790893555],[143.892761230469,42.8491592407227],[143.595520019531,42.6197128295898],[143.373840332031,42.3616638183594],[143.329681396484,42.2816619873047],[143.316925048828,42.0427703857422],[143.246337890625,41.9252700805664],[142.943023681641,42.1066589355469],[142.501007080078,42.2537269592285],[142.501007080078,37.5],[142.5,37.5],[142.5,42.6830520629883],[142.5,46.0306663513184],],
			},
			"414" => {
				"z" => "Etc/GMT+12",
				"c" => "ESRI",
				"s" => "28,1",
				"p" => [[157.5,52.5],[157.5,51.3887500693749],[157.357177734375,51.334716796875],[157.256652832031,51.2297134399414],[157.141662597656,51.1922149658203],[156.951080322266,51.0602722167969],[156.824676513672,51.0122146606445],[156.81884765625,50.9797134399414],[156.693023681641,50.8913803100586],[156.645538330078,50.8888854980469],[156.745513916016,50.9877700805664],[156.746063232422,51.0744400024414],[156.701629638672,51.0983276367188],[156.7080078125,51.1844329833984],[156.673583984375,51.2294311523438],[156.551361083984,51.2738800048828],[156.518035888672,51.3227691650391],[156.516387939453,51.4166641235352],[156.472747802734,51.5136108398438],[156.491912841797,51.9316635131836],[156.424682617188,52.2091598510742],[156.288517349356,52.5],[156.350811458623,52.5],[156.365509033203,52.4952697753906],[156.369964599609,52.4424896240234],[156.422165291477,52.5],[155.544128417969,52.5],[157.5,52.5],],
			},
		},
		# Grid 10:4 ; 2 records
		"4" => {
			"def_z" => "Etc/GMT+11",
			"415" => {
				"z" => "Etc/GMT+12",
				"c" => "ESRI",
				"s" => "28,1",
				"p" => [[157.5,67.5],[157.5,52.5],[156.288517349356,52.5],[156.277465820312,52.5236053466797],[156.350811458623,52.5],[156.422165291477,52.5],[156.441070556641,52.5208282470703],[156.364959716797,52.5166625976562],[156.260803222656,52.5672149658203],[156.103302001953,52.8491592407227],[156.085784912109,53.097770690918],[155.91943359375,53.8374938964844],[155.940795898438,53.8469390869141],[155.699401855469,54.5124969482422],[155.544128417969,55.3036041259766],[155.618286132812,55.6213760375977],[155.646087646484,55.9119338989258],[155.698577880859,56.065544128418],[155.759979248047,56.1061019897461],[155.736083984375,56.1369400024414],[155.940795898438,56.6336059570312],[156.104400634766,56.8152694702148],[156.168853759766,56.8352661132812],[156.074676513672,56.7599945068359],[156.063293457031,56.714714050293],[156.19775390625,56.8169403076172],[156.19970703125,56.8566589355469],[156.454406738281,56.9572143554688],[156.547210693359,57.1074981689453],[156.679412841797,57.0424957275391],[156.719421386719,57.0841598510742],[156.695251464844,57.1086044311523],[156.977752685547,57.414436340332],[156.980529785156,57.5277709960938],[156.935516357422,57.6405487060547],[156.845520019531,57.7255477905273],[156.748840332031,57.7283248901367],[156.786926269531,57.7636108398438],[156.984954833984,57.8536071777344],[157.048858642578,57.8002700805664],[157.174407958984,57.7719345092773],[157.406372070312,57.7849960327148],[157.5,57.8245807776156],[157.5,60.5836029052734],[157.5,67.5],],
			},
		},
		# Grid 10:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT+11",
			"156" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[142.5,82.5],[142.519409179688,82.5],[142.519409179688,77.6881713867188],[142.5,77.6883130719085],[142.5,67.5],[142.5,82.5],],
			},
		},
		# Grid 10:6 ; 1 records
		"6" => {
			"157" => {
				"z" => "Etc/GMT+9",
				"c" => "ESRI",
				"s" => "12,1",
				"p" => [[142.5,90],[142.519409179688,90],[142.519409179688,82.5],[142.5,82.5],[142.5,90],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
