# Generated by default/object.tt
package Paws::DynamoDB::BatchStatementRequest;
  use Moose;
  has ConsistentRead => (is => 'ro', isa => 'Bool');
  has Parameters => (is => 'ro', isa => 'ArrayRef[Paws::DynamoDB::AttributeValue]');
  has Statement => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::DynamoDB::BatchStatementRequest

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DynamoDB::BatchStatementRequest object:

  $service_obj->Method(Att1 => { ConsistentRead => $value, ..., Statement => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DynamoDB::BatchStatementRequest object:

  $result = $service_obj->Method(...);
  $result->Att1->ConsistentRead

=head1 DESCRIPTION

A PartiQL batch statement request.

=head1 ATTRIBUTES


=head2 ConsistentRead => Bool

The read consistency of the PartiQL batch request.


=head2 Parameters => ArrayRef[L<Paws::DynamoDB::AttributeValue>]

The parameters associated with a PartiQL statement in the batch
request.


=head2 B<REQUIRED> Statement => Str

A valid PartiQL statement.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DynamoDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

