# Generated by default/object.tt
package Paws::GreengrassV2::LambdaExecutionParameters;
  use Moose;
  has EnvironmentVariables => (is => 'ro', isa => 'Paws::GreengrassV2::LambdaEnvironmentVariables', request_name => 'environmentVariables', traits => ['NameInRequest']);
  has EventSources => (is => 'ro', isa => 'ArrayRef[Paws::GreengrassV2::LambdaEventSource]', request_name => 'eventSources', traits => ['NameInRequest']);
  has ExecArgs => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'execArgs', traits => ['NameInRequest']);
  has InputPayloadEncodingType => (is => 'ro', isa => 'Str', request_name => 'inputPayloadEncodingType', traits => ['NameInRequest']);
  has LinuxProcessParams => (is => 'ro', isa => 'Paws::GreengrassV2::LambdaLinuxProcessParams', request_name => 'linuxProcessParams', traits => ['NameInRequest']);
  has MaxIdleTimeInSeconds => (is => 'ro', isa => 'Int', request_name => 'maxIdleTimeInSeconds', traits => ['NameInRequest']);
  has MaxInstancesCount => (is => 'ro', isa => 'Int', request_name => 'maxInstancesCount', traits => ['NameInRequest']);
  has MaxQueueSize => (is => 'ro', isa => 'Int', request_name => 'maxQueueSize', traits => ['NameInRequest']);
  has Pinned => (is => 'ro', isa => 'Bool', request_name => 'pinned', traits => ['NameInRequest']);
  has StatusTimeoutInSeconds => (is => 'ro', isa => 'Int', request_name => 'statusTimeoutInSeconds', traits => ['NameInRequest']);
  has TimeoutInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeoutInSeconds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::LambdaExecutionParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::LambdaExecutionParameters object:

  $service_obj->Method(Att1 => { EnvironmentVariables => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::LambdaExecutionParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->EnvironmentVariables

=head1 DESCRIPTION

Contains parameters for a Lambda function that runs on AWS IoT
Greengrass.

=head1 ATTRIBUTES


=head2 EnvironmentVariables => L<Paws::GreengrassV2::LambdaEnvironmentVariables>

The map of environment variables that are available to the Lambda
function when it runs.


=head2 EventSources => ArrayRef[L<Paws::GreengrassV2::LambdaEventSource>]

The list of event sources to which to subscribe to receive work
messages. The Lambda function runs when it receives a message from an
event source. You can subscribe this function to local
publish/subscribe messages and AWS IoT Core MQTT messages.


=head2 ExecArgs => ArrayRef[Str|Undef]

The list of arguments to pass to the Lambda function when it runs.


=head2 InputPayloadEncodingType => Str

The encoding type that the Lambda function supports.

Default: C<json>


=head2 LinuxProcessParams => L<Paws::GreengrassV2::LambdaLinuxProcessParams>

The parameters for the Linux process that contains the Lambda function.


=head2 MaxIdleTimeInSeconds => Int

The maximum amount of time in seconds that a non-pinned Lambda function
can idle before the AWS IoT Greengrass Core software stops its process.


=head2 MaxInstancesCount => Int

The maximum number of instances that a non-pinned Lambda function can
run at the same time.


=head2 MaxQueueSize => Int

The maximum size of the message queue for the Lambda function
component. The AWS IoT Greengrass core stores messages in a FIFO
(first-in-first-out) queue until it can run the Lambda function to
consume each message.


=head2 Pinned => Bool

Whether or not the Lambda function is pinned, or long-lived.

=over

=item *

A pinned Lambda function starts when AWS IoT Greengrass starts and
keeps running in its own container.

=item *

A non-pinned Lambda function starts only when it receives a work item
and exists after it idles for C<maxIdleTimeInSeconds>. If the function
has multiple work items, the AWS IoT Greengrass Core software creates
multiple instances of the function.

=back

Default: C<true>


=head2 StatusTimeoutInSeconds => Int

The interval in seconds at which a pinned (also known as long-lived)
Lambda function component sends status updates to the Lambda manager
component.


=head2 TimeoutInSeconds => Int

The maximum amount of time in seconds that the Lambda function can
process a work item.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

