# Generated by default/object.tt
package Paws::SSMContacts::ChannelTargetInfo;
  use Moose;
  has ContactChannelId => (is => 'ro', isa => 'Str', required => 1);
  has RetryIntervalInMinutes => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::ChannelTargetInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::ChannelTargetInfo object:

  $service_obj->Method(Att1 => { ContactChannelId => $value, ..., RetryIntervalInMinutes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::ChannelTargetInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactChannelId

=head1 DESCRIPTION

Information about the contact channel that Incident Manager uses to
engage the contact.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContactChannelId => Str

The Amazon Resource Name (ARN) of the contact channel.


=head2 RetryIntervalInMinutes => Int

The number of minutes to wait to retry sending engagement in the case
the engagement initially fails.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

