# Generated by default/object.tt
package Paws::AuditManager::ControlComment;
  use Moose;
  has AuthorName => (is => 'ro', isa => 'Str', request_name => 'authorName', traits => ['NameInRequest']);
  has CommentBody => (is => 'ro', isa => 'Str', request_name => 'commentBody', traits => ['NameInRequest']);
  has PostedDate => (is => 'ro', isa => 'Str', request_name => 'postedDate', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::ControlComment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::ControlComment object:

  $service_obj->Method(Att1 => { AuthorName => $value, ..., PostedDate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::ControlComment object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorName

=head1 DESCRIPTION

A comment posted by a user on a control. This includes the author's
name, the comment text, and a timestamp.

=head1 ATTRIBUTES


=head2 AuthorName => Str

The name of the user who authored the comment.


=head2 CommentBody => Str

The body text of a control comment.


=head2 PostedDate => Str

The time when the comment was posted.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

