/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday;

import de.jollyday.CalendarHierarchy;
import de.jollyday.Holiday;
import de.jollyday.HolidayCalendar;
import de.jollyday.configuration.ConfigurationProviderManager;
import de.jollyday.util.CalendarUtil;
import de.jollyday.util.ClassLoadingUtil;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HolidayManager {
    private static final Logger LOG = Logger.getLogger(HolidayManager.class.getName());
    private static final String MANAGER_IMPL_CLASS_PREFIX = "manager.impl";
    private static boolean managerCachingEnabled = true;
    private static final Map<String, HolidayManager> MANAGER_CHACHE = new HashMap<String, HolidayManager>();
    private Map<String, Set<Holiday>> holidaysPerYear = new HashMap<String, Set<Holiday>>();
    private Properties properties = new Properties();
    protected CalendarUtil calendarUtil = new CalendarUtil();
    private static ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();
    private static ConfigurationProviderManager configurationProviderManager = new ConfigurationProviderManager();

    public static final HolidayManager getInstance() {
        return HolidayManager.getInstance((String)null);
    }

    public static final HolidayManager getInstance(Properties properties) {
        return HolidayManager.getInstance((String)null, properties);
    }

    public static final HolidayManager getInstance(HolidayCalendar c) {
        return HolidayManager.getInstance(c.getId());
    }

    public static final HolidayManager getInstance(HolidayCalendar c, Properties properties) {
        return HolidayManager.getInstance(c.getId(), properties);
    }

    public static final HolidayManager getInstance(String calendar) {
        return HolidayManager.getInstance(calendar, null);
    }

    public static final HolidayManager getInstance(String calendar, Properties properties) {
        HolidayManager m;
        String calendarName = HolidayManager.prepareCalendarName(calendar);
        HolidayManager holidayManager = m = HolidayManager.isManagerCachingEnabled() ? HolidayManager.getFromCache(calendarName) : null;
        if (m == null) {
            m = HolidayManager.createManager(calendarName, properties);
        }
        return m;
    }

    public static final HolidayManager getInstance(URL url) {
        return HolidayManager.getInstance(url, null);
    }

    public static final HolidayManager getInstance(URL url, Properties properties) {
        HolidayManager m;
        if (url == null) {
            throw new NullPointerException("Missing URL.");
        }
        HolidayManager holidayManager = m = HolidayManager.isManagerCachingEnabled() ? HolidayManager.getFromCache(url.toString()) : null;
        if (m == null) {
            m = HolidayManager.createManager(url, properties);
        }
        return m;
    }

    private static HolidayManager createManager(String calendar, Properties properties) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Creating HolidayManager for calendar '" + calendar + "'. Caching enabled: " + HolidayManager.isManagerCachingEnabled());
        }
        Properties props = configurationProviderManager.getConfigurationProperties(properties);
        String managerImplClassName = HolidayManager.readManagerImplClassName(calendar, props);
        HolidayManager m = HolidayManager.instantiateManagerImpl(managerImplClassName);
        m.setProperties(props);
        m.init(calendar);
        if (HolidayManager.isManagerCachingEnabled()) {
            HolidayManager.putToCache(calendar, m);
        }
        return m;
    }

    private static String readManagerImplClassName(String calendar, Properties props) {
        String managerImplClassName = null;
        if (calendar != null && props.containsKey("manager.impl." + calendar)) {
            managerImplClassName = props.getProperty("manager.impl." + calendar);
        } else if (props.containsKey(MANAGER_IMPL_CLASS_PREFIX)) {
            managerImplClassName = props.getProperty(MANAGER_IMPL_CLASS_PREFIX);
        } else {
            throw new IllegalStateException("Missing configuration 'manager.impl'. Cannot create manager.");
        }
        return managerImplClassName;
    }

    private static HolidayManager instantiateManagerImpl(String managerImplClassName) {
        try {
            Class<?> managerImplClass = classLoadingUtil.loadClass(managerImplClassName);
            Object managerImplObject = managerImplClass.newInstance();
            return (HolidayManager)HolidayManager.class.cast(managerImplObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create manager class " + managerImplClassName, e);
        }
    }

    private static HolidayManager createManager(URL url, Properties properties) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Creating HolidayManager for URL '" + url + "'. Caching enabled: " + HolidayManager.isManagerCachingEnabled());
        }
        Properties props = configurationProviderManager.getConfigurationProperties(properties);
        String managerImplClassName = HolidayManager.readManagerImplClassName(null, props);
        HolidayManager m = HolidayManager.instantiateManagerImpl(managerImplClassName);
        m.setProperties(props);
        m.init(url);
        if (HolidayManager.isManagerCachingEnabled()) {
            HolidayManager.putToCache(url.toString(), m);
        }
        return m;
    }

    private static String prepareCalendarName(String calendar) {
        calendar = calendar == null || "".equals(calendar.trim()) ? Locale.getDefault().getCountry().toLowerCase() : calendar.trim().toLowerCase();
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putToCache(String country, HolidayManager manager) {
        Map<String, HolidayManager> map = MANAGER_CHACHE;
        synchronized (map) {
            MANAGER_CHACHE.put(country, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HolidayManager getFromCache(String country) {
        Map<String, HolidayManager> map = MANAGER_CHACHE;
        synchronized (map) {
            return MANAGER_CHACHE.get(country);
        }
    }

    public static void setManagerCachingEnabled(boolean managerCachingEnabled) {
        HolidayManager.managerCachingEnabled = managerCachingEnabled;
    }

    public static boolean isManagerCachingEnabled() {
        return managerCachingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearManagerCache() {
        Map<String, HolidayManager> map = MANAGER_CHACHE;
        synchronized (map) {
            MANAGER_CHACHE.clear();
        }
    }

    public boolean isHoliday(Calendar c, String ... args) {
        return this.isHoliday(this.calendarUtil.create(c), args);
    }

    public boolean isHoliday(LocalDate c, String ... args) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(c.getYear());
        for (String arg : args) {
            keyBuilder.append("_");
            keyBuilder.append(arg);
        }
        String key = keyBuilder.toString();
        if (!this.holidaysPerYear.containsKey(key)) {
            Set<Holiday> holidays = this.getHolidays(c.getYear(), args);
            this.holidaysPerYear.put(key, holidays);
        }
        return this.calendarUtil.contains(this.holidaysPerYear.get(key), c);
    }

    public static Set<String> getSupportedCalendarCodes() {
        HashSet<String> supportedCalendars = new HashSet<String>();
        for (HolidayCalendar c : HolidayCalendar.values()) {
            supportedCalendars.add(c.getId());
        }
        return supportedCalendars;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public abstract Set<Holiday> getHolidays(int var1, String ... var2);

    public abstract Set<Holiday> getHolidays(ReadableInterval var1, String ... var2);

    public abstract void init(String var1);

    public abstract void init(URL var1);

    public abstract CalendarHierarchy getCalendarHierarchy();
}

