/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ess;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;

public class ContentHints
extends ASN1Encodable {
    private DERUTF8String contentDescription;
    private DERObjectIdentifier contentType;

    public static ContentHints getInstance(Object object) {
        if (object == null || object instanceof ContentHints) {
            return (ContentHints)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ContentHints((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'ContentHints' factory : " + object.getClass().getName() + ".");
    }

    private ContentHints(ASN1Sequence aSN1Sequence) {
        DEREncodable dEREncodable = aSN1Sequence.getObjectAt(0);
        if (dEREncodable.getDERObject() instanceof DERUTF8String) {
            this.contentDescription = DERUTF8String.getInstance(dEREncodable);
            this.contentType = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        } else {
            this.contentType = DERObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        }
    }

    public ContentHints(DERObjectIdentifier dERObjectIdentifier) {
        this.contentType = dERObjectIdentifier;
        this.contentDescription = null;
    }

    public ContentHints(DERObjectIdentifier dERObjectIdentifier, DERUTF8String dERUTF8String) {
        this.contentType = dERObjectIdentifier;
        this.contentDescription = dERUTF8String;
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DERUTF8String getContentDescription() {
        return this.contentDescription;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.contentDescription != null) {
            aSN1EncodableVector.add(this.contentDescription);
        }
        aSN1EncodableVector.add(this.contentType);
        return new DERSequence(aSN1EncodableVector);
    }
}

