#!/usr/bin/perl -w

use strict;

my $n;
use Test::More tests => ($n = 42) * 6 + 4;
use lib "t/lib";
use Test::FloatNear;

BEGIN { use_ok("MPEG::Audio::Frame") };

my $s = 0;
for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "MPEG1");
	ok($frame->layer3, "layer III");
	ok(!$frame->broken, "frame is not broken");
	is($frame->sample, 44100, "sample rate");
	is($frame->length, length("$frame"), "actual length eq calculated length");
	$s += $frame->seconds;
}

is_near($s, 1.09714285714, "total length");

is(MPEG::Audio::Frame->read(*DATA), undef, "nothing left on __DATA__");
ok(eof(DATA), "eof(DATA)")

__DATA__
P  
dS	 plO1  
  `@(    /@pu Y{>з bpoPM+7.8rĀ 
  A{U3[kU *T
xFDȶ:۔%csiKŧnPZHchJ05JP4%	EUaYRtR 	Q+ a)$IcV]@Hk6zx*&#	}5=ΰK
gb7K.v^vE&c9ޣTva:XdpTfT$7 Fn\2Gi!Hܧ6C(gL]-cPC3&Pf BzZV"'etmxvi
0AR Lk)II*B#ť'|4eeNMN$OgqS5L@ۻ`l4d9ov0%IT	DXTIW-_j:4YG6$iQU6j   nˈJL̼صaGa0
(R  PY 3 اe=c*`WY44u!*
3"q
.vPݗ  sMu>7ÅiRT$n#

"7zz]XSaQiq!Ad'[L"_%"
v/RkܗjUD;>7/R
R 	Ni)9vr1Jx=<2P
U5uLo>4j*r51E(c5_tC:%k3f-51{Ub&yM?N8n<H/; ۩(4
q+n܌E%t]!񹋤Y]b( A5&_Z8]4%%&|R 
R	*5r0>QK1"REUt᧿Uq0-a(^u(Vltr
MICP0R.,ER%l24*2tj8f	t$!eeC 8`.pUaz'fvƔلeo7)t?u彦p E,h0!yRP 	Gi³ ڕW'jDDd
W%4M쁡3#k+]Rp)MjS7mOǿV67MX18	P
w;[sm4VyULyYC-gt{dC OAD
a8:2_Cs1 JR H>*ñ
SYч1 OqHgFHj1L9j2c"G$֖ f~
1d`4k!ߕ4f~cvQwf;Ń+
T!. іKKi_Xv1sPe)jF[a
ݞVع)Burq*L 8eZë
ġ:[RLTk)ACje)*3frNLqػtRzddRr@}lB	|*UeMXdg0(P(rĦ)dĂ 8J9z&F9gGcײ	fU=\Ojip n9i!B@R8 b\eGRGobSl!46gPRʔTkIA=+*LnM2YIRV}LlJ,eh?PNбgSm2a	T=
S\`I=^Sb,
}e̠W}cˍ/spRXince R7<IRe%sSxm^g{
SpXE L:h47eE  V R+ 
<V	O3   tKb
MAx-S 5L`P<Dfd1It	*ͦQۈ&Da**B2ɶfP+&2-|=at+Hi C+WD|`H+:<
l
A{Jd$ql/rp"		DcF [EС' 0T:NR*HN9 3Ԉb05Ӊkc{Y!ӝ 92bS	
Lyd:
aC&oط&
qsB硸6)LA0 ]~BWX.܍ʋ8l;	),[\Yf2j* &@d@%` *
VBL a힐[)Dc垀.$ RL CC-
Pka~4AcIH,16$#?
AZO>C.H#䶎?.ˣ̹1![
P0$FS9=,iٍW|#ǽth$n[nk.fEvQfXM)zp71E
=IXfN˼lkӨRʈT)It)(_Mri*+KI5JY{H!YC$}P~;@1	eH!K35,_RZOK
  Ja1itl!`aZj5~V<zԒU*CٸP0ԁRd31kyr*RÙlJB)ԕWDQChbk%ZzlݘM|5RʀLkIIJi@i(71E+kr/Z"U⑁pbG_8݊jQ ':[ET2AJd#}"4w#5uid9oujG,#E,q9dU+gw^hlZ|֚hdQPWʂK5͚e?IcF?94Y?bܻ<,'W꿊iGbssҸjHBp`
S~R#XJkiAF)m)Q۽ݵֵULPY͕Z³LM=1,bH*8~jIv[6E/Mյ =dԎ?C@-2SH2;up*0P-4j2(yB֝qPS-S;mV{RoMYam`&=UgՠXIci\KlRlC= % :R.tHII)
|Ip+F@,@^mDbʱ-;le1_VDPc	'V$ȌHL-0r ,ɣ[UaX&䌀X<I۳M7!bA%P}S_MV\PAt}c8y0 !9|3ʪ
ȱ'M
,4R0,HiIAhi)M+"F ddU̢s8nuoW,@ܮԊ$CU%#5> ("rSKgZt_ne(aDGRCɞaRg(]Mk%UTeb*rJߙQZ?T!h7C$gh_eNVZ!fՃyYfR=dFiAkm):/62ľYL
:\qJtCPݤ*lrܔpS\|h{tܩ2CJ>BZ:L.ݭ5_o	$׺Z'`қSdYL GE]IQLcqNI?A&^Pp !կ-|ךSؙ"#UqURDJkIII()Ca.aa
Le{K
ZH0NkRvaSM{D/PaZ'R>Z)lV"ejX%u1zM3FcR,2w AQA^iMHv,J{r$EzY1w4sya)s|ARclm7QDkmMWYBYف$,~V<RQʀFIAE))ojua$~Q5FZ@XScxyȇLԕ^jtULsbך^'`Zܐ^ؔ;AV7^	i~U2Ņwɶٮʢ;~Wu_Jk@SHUqh$Q;;. S6-ILN1*4Xh8$dRR\DkIAD)U(eJ`A-0/skuֱOb9DCo=8ËkKZ5^tg{;jx!jdc|H{1I3q#[ΰ"]C/5LlS\ζNЬv%)J|%")l* w*1Z')wsM(!⁃b0{1ReTHIIF)m)\agkW!dzQ	Yҍ%VZJIѐ,%q{?>jcykc-T\)3󣚷c[}ڧn 1{1!iQb`ru5)
=V˹d
	`	\\4pcqqٻj4{OU
oRqFiIG(i(rqX4;D;A2u8&ZzC*g/kf%`ZCWZ7k +YK*vEkESvgdYڡE,d"L1o|z+
!u諧-\:u{h7mga)ZiB&t#IeHRzPHiA]i(h["GKu_W:j
 b2.v[\(
ing{y[MɧPK<eF$ fl9]bO[HTey:
}\b
^fF6e^|g#A\al	Q@LpX=Y0Au8c2!W̽Ră(FiII)V ~T`0|)L6, 8,Ʋ7O1f7)@`dg<ZfڭɡtXM+&Hg`BmF`19?ݥ
a_ߢ[JC=q
aS>*aH;:@S4U'<yJvi[4':$dRď $HiC3 ұ$S/ph`pȍ5  ς
|a<yE@g0   =-oRG=<b,<:x%arSODVe;5&\@s\8UG  +ƺY55Rj@2;gH (
wjwSʡjlfRĀ |FG#j̱x 1r%{hPˁ)jFZ
%_Ή=I9Jα)1 Z=!)E2]q:F:x-#4t*?
F.z,l43V*;_#0 .S7rvrj2F'}يLUs籟+gR{ 
HC3 hYשf:cR(vwqXA2%TݡmԁT- w>bkK5;$00Md$% <XWf=gV"${9Kw]FXoWZkt+Y(m!:u򅅆qͻh	xSj(aZ;Ο̼έ$HF,P#Xǣk(Rq<H 	O((C9zYV[; Rw8$.5GK<LV,A %3]ZܗȦg :YcƺbU*)
5
$B 12gڇ&bF Նi` e*Rʰw]6"b0"_*,[4ʽ}a[(s*j&	8_bR||DiI|'(GwJGǰ |yJe
bX>tgM0',9чUF	&8l:\\Ų׏!mnp2^ a!"8Cӱ0
`+ƱۢRk_nYZD3iӜ5-xT0LNpa+j9/mB#9'qRā 
,D 	ᓧ3 
51	:ҙ;//K-J1zfH-,D|*fkzv6PaKp*SZUIUvjIz,L)\*y|(BH|bqHźLrz|Wa@C!*E  _0aFР H_XRHӁLXb*@
Y"t0])Rz<: 	HBE,ѕ6PI 8Z`D`Q+(81$
ъ22! )@0X#v@  a   jxۇm6w<^d5:i<<p۝	waQDDDIJ%ZﺨKAlG_Qdg(4RĂ &g1 U90@q0
	DP՘W,@ :44̈a021@dr(,h((:/*2RÀ(	R!-L#(a{Zb
C,y\uKquZt\!l
,S9\1oEa#z03Xb	e_R]" X7 B(d@	 ֆ%*bTXA1hIp$	ƺdr CN5I4`BɎ."G
$mp2RzRiPP+ag.3h#L(:o-tbtm!ќ`g۶!"N<5#'C.0"<9:6ãw2!s*R%̀   4  #0CsZo8	㫧^s"
6rbL;!Unhgj%0#CD!@¹V_.ULAME3.89 (beta)UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUR7       4   UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULAME3.89 (beta)UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUURĕ       4   UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULAME3.89 (beta)UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUR       4   UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULAME3.89 (beta)UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUR       4   UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUULAME3.89 (beta)UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUR       4   UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUR       4   UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
