# Contributing to This Distribution

First off - thank you for taking the time to contribute!
Your help makes this project better for everyone.

## Code of Conduct

Please note that this project follows the [Contributor Covenant 3.0][].

By participating, you are expected to uphold this code.

---

Contributor Quick-Start
-----------------------

1.  Pick your lane!

    -   Dist::Zilla users: branch from `main`

    -   Non-DZil users: branch from `build/main` (latest artifacts)
        or `build/release` (CPAN-shipped artifacts)

2.  Set up your environment!

    -   DZil lane:

        ```shell
        dzil authordeps --missing | cpanm
        dzil listdeps  --missing | cpanm
        ```

    -   Non-DZil lane:

        ```shell
        cpanm --with-develop --installdeps .
        ```

2.  Build & test!

    -   DZil: `dzil build && dzil test --all`

    -   Non-DZil: `prove -l`

4.  Edit only the right files!

    Source: `lib/`, `bin/`, `t/`, and `*.c` sources

    Do *not* edit: `README.md` (generated from POD),
    `Makefile.PL`, or any other auto-generated artifacts!

5.  Wrap it up!

    -   Add an entry to `Changes`

    -   Commit with a clear message

    -   Push branch and open PR (DZil: `main`, Non-DZil: `build/main`)

## Common Pitfalls (skip ahead if you want detailed instructions)

*   **Editing generated artifacts**

    Touching `README.md`, `Makefile.PL`, `META.*` in a working branch
    instead of the POD or source files that produce them.

*   **Branching from the wrong lane**

    Starting DZil work from `build/main` or `build/release`,
    or starting non-DZil work from `main` -- yields merge conflicts
    and lost changes.

*   **Missing deps for the chosen lane**

    Forgetting `dzil authordeps` / `listdeps` in DZil lane,
    or skipping `--with-develop` in non-DZil lane.

*   **Cross-lane commits**

    Mixing DZil-built changes with edits to generated files
    in a single commit -- reviewers can't tell what was hand-written.

*   **Untracked `Changes` entry**

    Forgetting to add a Changes entry before PR, so release notes
    have to be back-filled.

*   **Stale build artifacts**

    Not cleaning between builds, leading to "it works here" bugs.
    (For DZil: `dzil clean`; for non-DZil: `git clean --force -dx`.)

*   **Manual artifact edits**

    Fixing a typo in the built tree instead of in the source,
    so it reappears on the next build.

---

## Branch & PR Guidelines

-   **Pull Requests preferred** over patches; please base them on a
    feature or bugfix branch, not `main`.
    *Never* commit directly to `main`; that branch is also only
    updated by maintainers.

    Example branch names: `feature/foo`, `bugfix/issue-123`

-   **Which branch you start with** is a little unusual and depends on
    whether you are using Dist::Zilla or not.

    -   DZil users branch from `main`

    -   Non-DZil users branch from either:

        -   `build/main`: current build artifacts, not necessarily
            released to CPAN

        -   `build/release`: artifacts released to CPAN

        This is so changes can be reviewed *exactly* as they'll appear
        with generated artifacts.

-   **Do not edit auto-generated files** (`README.md`, `Makefile.PL,`
    etc.) directly. Always make changes in the source they're generated
    from.

-   Keep commits focused and messages descriptive.

-   Add an entry for each change in `Changes`.

-   Significant changes? Open an issue or contact the maintainer before
    starting work.

## Development Workflows

This project supports **two** contributor setups:

### 1.  Dist::Zilla (Full Authoring Environment)

If you have [Dist::Zilla](https://metacpan.org/pod/Dist::Zilla)
installed with the required plugins:

1.  Install dependencies:

    ```shell
    dzil authordeps --missing | cpanm
    dzil listdeps --missing | cpanm
    ```

    Build and test:

    ```shell
    dzil build
    dzil test --all
    ```

2.  Make changes in the source files.
    Don't touch the automatically-generated-from-POD `README.md`
    or `Makefile.PL`.

    POD lives alongside the code it documents. There's no need to update
    the README as that is automatically generated from the main module.

    Key source files:

    -   `lib`: Perl modules
    -   `bin`: executable scripts
    -   `t`:   unit tests
    -   `oslogwrapper.c`: C source used to wrap macOS libraries

3.  Update `Changes` and push your branch to Codeberg.

### 2.  Non-Dist::Zilla (Generated Artifacts Only)

If you don't use DZil, you should work from the CPAN tarball.
*If you know what you're doing*, you can work from a branch of
`build/main` or `build/release` that contains generated files
(`Makefile.PL`, etc.). Those branches are for build artifacts, so
there's no need to regenerate them locally.

Remember that the `main` branch is only updated by maintainers.

1.  Install dependencies from the included `cpanfile`. Note that
    the `Makefile.PL` will already be there

    ```shell
    cpanm --with-develop --installdeps .
    ```

2.  Run the test suite:

    ```shell
    prove -l
    ```

3.  Make changes directly in the working tree.

4.  Update `Changes` and commit normally.


### Submitting Your Contribution

1.  Push your branch to your fork.

2.  Open a Pull Request against the `main` branch if using Dist::Zilla,
    or `build/main` if not.

---

Reporting Bugs
--------------

Use the bug tracker listed in the distribution metadata (also in the
*SUPPORT* section of the POD and the README document).
Please include:

-   Steps to reproduce

-   Expected vs. actual behavior

-   Your Perl version and your operating system platform version

-   Installation method -- `cpan` or `cpanm` command or CPAN tarball.
    If working directly from a branch, note whether Dist::Zilla was
    used.

---

Thanks again for contributing!

[Contributor Covenant 3.0]: <https://www.contributor-covenant.org/version/3/0/code_of_conduct/>
