package Acme::MetaSyntactic::planets;
use strict;
use Acme::MetaSyntactic::Locale;
our @ISA = qw( Acme::MetaSyntactic::Locale );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::planets - The planets theme

=head1 DESCRIPTION

The nine planets of our solar system.

The status of the newly discovered Kuiper belt object (2003 UB313) is
still not determined (and therefore, not officially named), and hence,
not classified as a planet.

Pluto is not a planet any more.

=head1 CONTRIBUTOR

Abigail

=head1 CHANGES

=over 4

=item *

2012-05-07

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-08-28

Updated to remove Pluto in Acme-MetaSyntactic version 0.89.

=item *

2006-05-15

Updated to 42 languages by Abigail in Acme-MetaSyntactic version 0.74.

=item *

2006-05-08

Made multilingual in Acme-MetaSyntactic version 0.73.

=item *

2006-02-27

Introduced in Acme-MetaSyntactic version 0.63.

=item *

2005-10-27

Submitted by Abigail.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::Locale>.

=cut

__DATA__
# default
en
# names af
Mercurius Venus Aarde Mars Jupiter Saturnus Uranus Neptunus
# names als
Merkur Venus Erde Mars Jupiter Saturn Uranus Neptun
# names bs
Merkur Venera Zemlja Mars Jupiter Saturn Uran Neptun
# names ca
Mercuri Venus Terra Mart Jupiter Saturn Ura Neptu
# names da
Merkur Venus Jorden Mars Jupiter Saturn Uranus Neptun
# names de
Merkur Venus Erde Mars Jupiter Saturn Uranus Neptun
# names en
Mercury Venus Earth Mars Jupiter Saturn Uranus Neptune
# names eo
Merkuro Venuso Tero Marso Jupitero Saturno Urano Neptuno
# names es
Mercurio Venus Tierra Marte Jupiter Saturno Urano Neptuno
# names et
Merkuur Veenus Maa Marss Jupiter Saturn Neptuun Uraan
# names eu
Mercurius Artizar Lurra Mars Jupiter Saturno Uranus Neptuno
# names fi
Merkurius Venus Maa Mars Jupiter Saturnus Uranus Neptunus
# names fr
Mercure Venus Terre Mars Jupiter Saturne Uranus Neptune
# names fur
Mercuri Bielestele Tiere Mart Gjiove Saturni Nettun Uran
# names gl
Mercurio Venus Terra Marte Xupiter Saturno Urano Neptuno
# names hr
Merkur Venera Zemlja Mars Jupiter Saturn Uran Neptun
# names hu
Merkur Venusz Fold Mars Jupiter Szaturnusz Uranusz Neptunusz
# names ia
Mercurio Venus Terra Marte Jupiter Saturno Urano Neptuno
# names id
Merkurius Venus Bumi Mars Jupiter Saturnus Neptunus Uranus
# names it
Mercurio Venere Terra Marte Giove Saturno Uranio Nettuno
# names ku
Tir Gelawej Erd Behram Bercis Keywan Uranus Neptun
# names kw
Mergher Gwener Norvys Meurth Yow Sadorn Ouranos Nevyon
# names la
Mercurius Venus Terra Mars Iuppiter Saturnus Uranus Neptunus
# names lb
Merkur Venus Aerd Mars Jupiter Saturn Uranus Neptun
# names lt
Merkurijus Venera Zeme Marsas Jupiteris Saturnas Uranas Neptunas
# names ms
Utarid Zuhrah Bumi Marikh Musytari Zuhal Uranus Neptun
# names mt
Merkurju Venere Dinja Marte Gove Saturnu Uranju Nettunu
# names nap
Mercurio Venere Terra Marte Giove Saturno Urano Nettuno
# names nds
Merkur Venus Eer Mars Jupiter Saturn Uranus Neptun
# names nl
Mercurius Venus Aarde Mars Jupiter Saturnus Uranus Neptunus
# names nn
Merkur Venus Jorda Mars Jupiter Saturn Uranus Neptun
# names no
Merkur Venus Jorden Mars Jupiter Saturn Uranus Neptun
# names nrm
Mertchure Venus Terre Mars Jupiter Saturne Uranus Nepteune
# names pam
Mercury Venus Yatu Jupiter Saturn Uranus Neptune
# names pl
Merkury Wenus Ziemia Mars Jowisz Saturn Uran Neptun
# names pt
Mercurio Venus Terre Marte Jupiter Saturno Urano Netuno
# names ro
Mercur Venus Pamant Marte Jupiter Saturn Uranus Neptun
# names scn
Mercuriu Veniri Terra Marti Giovi Saturnu Uranu Nettunu
# names sh
Merkur Venera Zemlja Mars Jupiter Saturn Uran Neptun
# names sv
Merkurius Venus Jorden Mars Jupiter Saturnus Uranus Neptunus
# names tl
Merkuryo Venus Daigdig Marte Jupiter Saturno Urano Neptuno
# names tpi
Makuri Vinas Graun Mas Jupita Saten Yuranas Neptun
# names tr
Merkur Venus Yer Mars Jupiter Saturn Uranus Neptun
