# Generated by default/object.tt
package Paws::Firehose::HttpEndpointRequestConfiguration;
  use Moose;
  has CommonAttributes => (is => 'ro', isa => 'ArrayRef[Paws::Firehose::HttpEndpointCommonAttribute]');
  has ContentEncoding => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Firehose::HttpEndpointRequestConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Firehose::HttpEndpointRequestConfiguration object:

  $service_obj->Method(Att1 => { CommonAttributes => $value, ..., ContentEncoding => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Firehose::HttpEndpointRequestConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CommonAttributes

=head1 DESCRIPTION

The configuration of the HTTP endpoint request.

=head1 ATTRIBUTES


=head2 CommonAttributes => ArrayRef[L<Paws::Firehose::HttpEndpointCommonAttribute>]

Describes the metadata sent to the HTTP endpoint destination.


=head2 ContentEncoding => Str

Kinesis Data Firehose uses the content encoding to compress the body of
a request before sending the request to the destination. For more
information, see Content-Encoding
(https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding)
in MDN Web Docs, the official Mozilla documentation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Firehose>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

