#!/usr/bin/perl

package eBay::API::XML::DataType::ProductListingDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ProductListingDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ProductListingDetailsType

=head1 DESCRIPTION

Contains product information that can be included in a listing.
Applicable for listings that use eBay's Pre-filled Item Information feature.
See the Developer's Guide for details on working with Pre-filled Item Information.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ProductListingDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Copyright', 'xs:string', '1', '', '' ]
	, [ 'IncludePrefilledItemInformation', 'xs:boolean', '', '', '' ]
	, [ 'IncludeStockPhotoURL', 'xs:boolean', '', '', '' ]
	, [ 'ProductID', 'xs:string', '', '', '' ]
	, [ 'StockPhotoURL', 'xs:anyURI', '', '', '' ]
	, [ 'UseStockPhotoURLAsGallery', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCopyright()

Copyright statement indicating the source of the product information. This information will be
included in the listing with Pre-filled Item Information. Your application should also display
the copyright statement when rendering the Pre-filled Item Information.
If more than one copyright statement is applicable, they can be presented to the
user in alphabetical order. Returned as HTML.
Output only.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCopyright {
  my $self = shift;
  $self->{'Copyright'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCopyright()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCopyright {
  my $self = shift;
  return $self->_getDataTypeArray('Copyright');
}


=head2 setIncludePrefilledItemInformation()

If true, specifies that the listing should include additional information about the product,
such as a publisher's description or film credits. Such information is hosted through the eBay site
and cannot be edited. If true, Item.Description is optional in item-listing requests.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setIncludePrefilledItemInformation {
  my $self = shift;
  $self->{'IncludePrefilledItemInformation'} = shift
}

=head2 isIncludePrefilledItemInformation()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isIncludePrefilledItemInformation {
  my $self = shift;
  return $self->{'IncludePrefilledItemInformation'};
}


=head2 setIncludeStockPhotoURL()

If true, indicates that the item listing includes the stock photo.
To use an eBay stock photo in an item listing, set IncludeStockPhotoURL to true.
If a stock photo is available, it is used at the top of the View Item page and in
the Item Specifics section of the listing. If you also include Item.PictureDetails.PictureURL,
the stock photo only appears in the Item Specifics section of the listing. Other pictures
you specify by using Item.PictureDetails.PictureURL appear in a separate section of the listing.
If you use Item.ExternalProductID instead of Item.ProductListingDetails,
eBay sets IncludeStockPhotoURL to true (and you cannot set it to false).
In GetItem, the URL of the stock photo will be returned in StockPhotoURL.
If you set IncludeStockPhotoURL to false, the stock photo does not appear in the listing at all.<br>
<br>
<span class="tablenote"><b>Note:</b>
As of 02-20-2008, the following sites offer free Gallery:
US (site ID 0), Parts & Accessories Category on US Motors (site ID 100),
CA (site ID 2), CAFR (site ID 210), FR (site ID 71) and NL (site ID 146).
Additionally, ES (site ID 186) and IT (site ID 101) offer free Gallery as of 03-03-2008.
<br><br>On these sites, eBay selects a Gallery thumbnail from image
URLs included in the request (i.e. either GalleryURL or the first PictureURL),
using selection rules that consider which of these URLs has been specified and
whether an eBay stock photo exists for the item. Also, eBay
selects an image regardless of whether you have specified either GalleryType or GalleryURL.
A Gallery fee will only apply if you have set GalleryType to Plus or Featured (as basic
Gallery is free).<br>
<br>
Along with these changes, IncludeStockPhotoURL will be used in the request.
In some cases, if IncludeStockPhotoURL is set to false, no image will be generated 
for the Gallery. A common example of this occurrence is when only GalleryURL has been
set in the request (i.e., no PictureURL elements are defined).
In this case, eBay will not use a stock photo, even if it is available.
See "Using Gallery Features on Sites with Free Gallery" 
in the eBay Web Services Guide for complete information.</span>
<br>
<br>
To be considered for eBay Express, in most cases a listing must include a picture or a gallery URL.
You can choose to use the eBay stock photo for this purpose.
See the eBay Web Services Guide links below for complete information.<br>
<br>
Not applicable to Half.com.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=Pictures
Title: Introduction to Pictures in Item Listings
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=GalleryFeaturesSitesWithFreeGallery
For: complete details on how eBay selects a gallery thumbnail.
Title: Using Gallery Features on Sites with Free Gallery
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPictureRequired
Title: Specify a Picture for Express and eBay


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setIncludeStockPhotoURL {
  my $self = shift;
  $self->{'IncludeStockPhotoURL'} = shift
}

=head2 isIncludeStockPhotoURL()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isIncludeStockPhotoURL {
  my $self = shift;
  return $self->{'IncludeStockPhotoURL'};
}


=head2 setProductID()

Applicable when ProductListingDetails is used. Unique identifier for
the product. See the Developer's Guide for information about determining product IDs.
If the primary and secondary categories are both catalog-enabled, this ID should correspond to the primary
category (not the secondary category).
In item-listing requests, if you pass in an old product ID, eBay will
list the item with the latest version of the product and the latest product ID, and the call
will return a warning indicating that the data has changed.
To list an item with Pre-filled Item Information by
using an ISBN, EAN, or UPC value, use ExternalProductID (defined on AddItem) instead.
Either ExternalProductID (for an ISBN, UPC, EAN or eBay product ID)
or Item.ProductListingDetails.ProductID (for an eBay product ID) can be specified
in AddItem requests, but not both.
<br>
<br>
As of mid-2008, some sites (such as eBay US, Germany, Austria, and Switzerland) are 
updating, replacing, deleting, or merging some products (as a result of migrating from one
catalog data provider to another). If you use an older product ID that has been 
deleted (and that has not been mapped to a new product), the request will fail.

MaxLength: 4000

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setProductID {
  my $self = shift;
  $self->{'ProductID'} = shift
}

=head2 getProductID()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getProductID {
  my $self = shift;
  return $self->{'ProductID'};
}


=head2 setStockPhotoURL()

Fully qualified URL for a standard image (if any) that is associated with the product.
A seller includes the stock photo in the listing
by setting IncludeStockPhotoURL.

#    Argument: 'xs:anyURI'

=cut

sub setStockPhotoURL {
  my $self = shift;
  $self->{'StockPhotoURL'} = shift
}

=head2 getStockPhotoURL()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:anyURI'

=cut

sub getStockPhotoURL {
  my $self = shift;
  return $self->{'StockPhotoURL'};
}


=head2 setUseStockPhotoURLAsGallery()

If true, indicates that the stock photo for an item (if available) is
used as the gallery thumbnail. When listing an item, IncludeStockPhotoURL
must also be true and Item.PictureDetails.GalleryType must be passed in with a value of Gallery
or Gallery Featured (but not both). Passing in Item.PictureDetails.GalleryURL takes precedence
over UseStockPhotoURLAsGallery. See the
eBay Web Services Guide for additional validation rules for pictures.
<br>
<br>
<span class="tablenote"><b>Note:</b>
As of 02-20-2008, the following sites offer free Gallery:
US (site ID 0), Parts & Accessories Category on US Motors (site ID 100),
CA (site ID 2), CAFR (site ID 210), FR (site ID 71) and NL (site ID 146).
Additionally, ES (site ID 186) and IT (site ID 101) offer free Gallery as of 03-03-2008.
<br><br>On these sites, eBay selects a Gallery thumbnail from image
URLs included in the request (i.e. either GalleryURL or the first PictureURL),
using selection rules that consider which of these URLs has been specified and
whether an eBay stock photo exists for the item. Also, eBay
selects an image regardless of whether you have specified either GalleryType or GalleryURL.
A Gallery fee will only apply if you have set GalleryType to Plus or Featured (as basic
Gallery is free).<br>
<br>
Along with these changes, UseStockPhotoURLAsGallery will be used in the request.
In some cases, if UseStockPhotoURLAsGallery is set to false, no image will be
generated for the Gallery. A common example of this occurrence is when only
GalleryURL has been set in the request (i.e., no PictureURL elements are defined).
In this case, eBay will not use a stock photo, even if it is available.
See "Using Gallery Features on Sites with Free Gallery" in the
eBay Web Services Guide for complete information.
</span>
<br>
<br>
To be considered for eBay Express, in most cases a listing must include a picture or a gallery URL.
You can choose to use the eBay stock photo for this purpose.
See "Working with eBay Express Listings" in the eBay Web Services Guide.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=GalleryFeaturesSitesWithFreeGallery
For: complete details on how eBay selects a gallery thumbnail.
Title: Using Gallery Features on Sites with Free Gallery
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=Pictures
Title: Introduction to Pictures in Item Listings
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ExpressPictureRequired
Title: Specify a Picture for Express and eBay


  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setUseStockPhotoURLAsGallery {
  my $self = shift;
  $self->{'UseStockPhotoURLAsGallery'} = shift
}

=head2 isUseStockPhotoURLAsGallery()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isUseStockPhotoURLAsGallery {
  my $self = shift;
  return $self->{'UseStockPhotoURLAsGallery'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
