/* DMThreadsPage.c generated by valac 0.36.4, the Vala compiler
 * generated from DMThreadsPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include <gio/gio.h>
#include "CbUtils.h"
#include "CbTypes.h"
#include <cairo.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;
typedef struct _DMThreadsPagePrivate DMThreadsPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_START_CONVERSATION_ENTRY (start_conversation_entry_get_type ())
#define START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntry))
#define START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))
#define IS_START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_START_CONVERSATION_ENTRY))
#define IS_START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_START_CONVERSATION_ENTRY))
#define START_CONVERSATION_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))

typedef struct _StartConversationEntry StartConversationEntry;
typedef struct _StartConversationEntryClass StartConversationEntryClass;

#define TYPE_DM_MANAGER (dm_manager_get_type ())
#define DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_MANAGER, DMManager))
#define DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_MANAGER, DMManagerClass))
#define IS_DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_MANAGER))
#define IS_DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_MANAGER))
#define DM_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_MANAGER, DMManagerClass))

typedef struct _DMManager DMManager;
typedef struct _DMManagerClass DMManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DM_THREAD (dm_thread_get_type ())
#define DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD, DMThread))
#define DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD, DMThreadClass))
#define IS_DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD))
#define IS_DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD))
#define DM_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD, DMThreadClass))

typedef struct _DMThread DMThread;
typedef struct _DMThreadClass DMThreadClass;

#define TYPE_DM_THREAD_ENTRY (dm_thread_entry_get_type ())
#define DM_THREAD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD_ENTRY, DMThreadEntry))
#define DM_THREAD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD_ENTRY, DMThreadEntryClass))
#define IS_DM_THREAD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD_ENTRY))
#define IS_DM_THREAD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD_ENTRY))
#define DM_THREAD_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD_ENTRY, DMThreadEntryClass))

typedef struct _DMThreadEntry DMThreadEntry;
typedef struct _DMThreadEntryClass DMThreadEntryClass;
typedef struct _DMThreadEntryPrivate DMThreadEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _Block17Data Block17Data;
typedef struct _DMThreadPrivate DMThreadPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _Block18Data Block18Data;

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;
typedef struct _DMPagePrivate DMPagePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DMThreadsPage {
	ScrollWidget parent_instance;
	DMThreadsPagePrivate * priv;
	Account* account;
};

struct _DMThreadsPageClass {
	ScrollWidgetClass parent_class;
};

struct _DMThreadsPagePrivate {
	gboolean initialized;
	gint _unread_count;
	MainWindow* main_window;
	gint _id;
	BadgeRadioButton* radio_button;
	StartConversationEntry* start_conversation_entry;
	GtkListBox* thread_list;
	GtkListBox* top_list;
	GtkListBoxRow* progress_row;
	DMManager* manager;
};

struct _DMThreadEntry {
	GtkListBoxRow parent_instance;
	DMThreadEntryPrivate * priv;
	gint64 user_id;
};

struct _DMThreadEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block17Data {
	int _ref_count_;
	DMThreadsPage* self;
	DMThread* thread;
	DMThreadEntry* row;
};

struct _DMThread {
	GObject parent_instance;
	DMThreadPrivate * priv;
	CbUserIdentity user;
	gint64 last_message_id;
	gchar* last_message;
	gint unread_count;
	gchar* notification_id;
	cairo_surface_t* avatar_surface;
};

struct _DMThreadClass {
	GObjectClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block18Data {
	int _ref_count_;
	DMThreadsPage* self;
	gboolean was_empty;
};

struct _DMPage {
	GtkBox parent_instance;
	DMPagePrivate * priv;
	Account* account;
	gint64 user_id;
};

struct _DMPageClass {
	GtkBoxClass parent_class;
};


static gpointer dm_threads_page_parent_class = NULL;
static IPageIface * dm_threads_page_ipage_parent_iface = NULL;
static CbMessageReceiverInterface * dm_threads_page_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType dm_threads_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType start_conversation_entry_get_type (void) G_GNUC_CONST;
GType dm_manager_get_type (void) G_GNUC_CONST;
#define DM_THREADS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_THREADS_PAGE, DMThreadsPagePrivate))
enum  {
	DM_THREADS_PAGE_DUMMY_PROPERTY,
	DM_THREADS_PAGE_UNREAD_COUNT,
	DM_THREADS_PAGE_WINDOW,
	DM_THREADS_PAGE_ID
};
DMThreadsPage* dm_threads_page_new (gint id, Account* account);
DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
DMManager* dm_manager_new_for_account (Account* account);
DMManager* dm_manager_construct_for_account (GType object_type, Account* account);
GType dm_thread_get_type (void) G_GNUC_CONST;
static void dm_threads_page_dm_received_cb (DMThreadsPage* self, DMThread* thread, const gchar* text, gboolean initial);
static void _dm_threads_page_dm_received_cb_dm_manager_message_received (DMManager* _sender, DMThread* thread, const gchar* text, gboolean initial, gpointer self);
static void dm_threads_page_thread_changed_cb (DMThreadsPage* self, DMThread* thread);
static void _dm_threads_page_thread_changed_cb_dm_manager_thread_changed (DMManager* _sender, DMThread* thread, gpointer self);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static void __lambda105_ (DMThreadsPage* self, GtkListBoxRow* row);
void start_conversation_entry_reveal (StartConversationEntry* self);
static void ___lambda105__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda106_ (DMThreadsPage* self, GtkListBoxRow* row);
GType dm_thread_entry_get_type (void) G_GNUC_CONST;
gboolean dm_manager_has_thread (DMManager* self, gint64 user_id);
gchar* dm_manager_reset_notification_id (DMManager* self, gint64 user_id);
#define DM_PAGE_KEY_SENDER_ID 0
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda106__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
StartConversationEntry* start_conversation_entry_new (Account* account);
StartConversationEntry* start_conversation_entry_construct (GType object_type, Account* account);
static void __lambda107_ (DMThreadsPage* self, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url);
gint dm_threads_page_get_unread_count (DMThreadsPage* self);
gint dm_manager_reset_unread_count (DMManager* self, gint64 user_id);
void dm_threads_page_set_unread_count (DMThreadsPage* self, gint value);
#define DM_PAGE_KEY_SCREEN_NAME 1
#define DM_PAGE_KEY_USER_NAME 2
#define DM_PAGE_KEY_AVATAR_URL 3
static void ___lambda107__start_conversation_entry_start (StartConversationEntry* _sender, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url, gpointer self);
GListModel* dm_manager_get_threads_model (DMManager* self);
static GtkWidget* dm_threads_page_thread_widget_func (DMThreadsPage* self, GObject* item);
static GtkWidget* _dm_threads_page_thread_widget_func_gtk_list_box_create_widget_func (GObject* item, gpointer self);
void dm_manager_load_cached_threads (DMManager* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
DMThreadEntry* dm_thread_entry_new (gint64 user_id);
DMThreadEntry* dm_thread_entry_construct (GType object_type, gint64 user_id);
void dm_thread_entry_set_screen_name (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_name (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_last_message (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_unread_count (DMThreadEntry* self, gint value);
void dm_thread_load_avatar (DMThread* self, Account* account, gint scale_factor, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_thread_load_avatar_finish (DMThread* self, GAsyncResult* _res_);
static void __lambda108_ (Block17Data* _data17_);
void dm_thread_entry_set_avatar (DMThreadEntry* self, cairo_surface_t* value);
static void ___lambda108__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static gboolean dm_threads_page_user_id_visible (DMThreadsPage* self, gint64 sender_id);
static void dm_threads_page_notify_new_dm (DMThreadsPage* self, DMThread* thread, const gchar* msg_text);
static void dm_threads_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
void dm_manager_insert_message (DMManager* self, JsonObject* dm_obj);
static void dm_threads_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
gboolean dm_manager_get_empty (DMManager* self);
void dm_manager_load_newest_dms (DMManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_manager_load_newest_dms_finish (DMManager* self, GAsyncResult* _res_);
static void ___lambda109_ (Block18Data* _data18_);
static void ____lambda109__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void dm_threads_page_real_on_leave (IPage* base);
void start_conversation_entry_unreveal (StartConversationEntry* self);
gboolean settings_notify_new_dms (void);
gchar* notification_manager_send_dm (NotificationManager* self, gint64 sender_id, const gchar* existing_id, const gchar* summary, const gchar* text);
static void dm_threads_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static GtkRadioButton* dm_threads_page_real_get_radio_button (IPage* base);
gint main_window_get_cur_page_id (MainWindow* self);
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType dm_page_get_type (void) G_GNUC_CONST;
static gchar* dm_threads_page_real_get_title (IPage* base);
void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id);
gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id);
static gboolean dm_threads_page_top_list_keynav_failed_cb (DMThreadsPage* self, GtkDirectionType direction);
static gboolean _dm_threads_page_top_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static gboolean dm_threads_page_thread_list_keynav_failed_cb (DMThreadsPage* self, GtkDirectionType direction);
static gboolean _dm_threads_page_thread_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
void badge_radio_button_set_show_badge (BadgeRadioButton* self, gboolean value);
static void dm_threads_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_dm_threads_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_dm_threads_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _dm_threads_page_dm_received_cb_dm_manager_message_received (DMManager* _sender, DMThread* thread, const gchar* text, gboolean initial, gpointer self) {
	dm_threads_page_dm_received_cb ((DMThreadsPage*) self, thread, text, initial);
}


static void _dm_threads_page_thread_changed_cb_dm_manager_thread_changed (DMManager* _sender, DMThread* thread, gpointer self) {
	dm_threads_page_thread_changed_cb ((DMThreadsPage*) self, thread);
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void __lambda105_ (DMThreadsPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_START_CONVERSATION_ENTRY)) {
		GtkListBoxRow* _tmp1_;
		_tmp1_ = row;
		start_conversation_entry_reveal (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_START_CONVERSATION_ENTRY, StartConversationEntry));
	}
}


static void ___lambda105__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda105_ ((DMThreadsPage*) self, row);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda106_ (DMThreadsPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DM_THREAD_ENTRY)) {
		DMThreadEntry* entry = NULL;
		GtkListBoxRow* _tmp1_;
		DMThreadEntry* _tmp2_;
		DMManager* _tmp3_;
		DMThreadEntry* _tmp4_;
		gint64 _tmp5_;
		gboolean _tmp6_;
		CbBundle* bundle = NULL;
		CbBundle* _tmp14_;
		CbBundle* _tmp15_;
		DMThreadEntry* _tmp16_;
		gint64 _tmp17_;
		MainWindow* _tmp18_;
		MainWidget* _tmp19_;
		CbBundle* _tmp20_;
		_tmp1_ = row;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DM_THREAD_ENTRY, DMThreadEntry));
		entry = _tmp2_;
		_tmp3_ = self->priv->manager;
		_tmp4_ = entry;
		_tmp5_ = _tmp4_->user_id;
		_tmp6_ = dm_manager_has_thread (_tmp3_, _tmp5_);
		if (_tmp6_) {
			gchar* notification_id = NULL;
			DMManager* _tmp7_;
			DMThreadEntry* _tmp8_;
			gint64 _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp7_ = self->priv->manager;
			_tmp8_ = entry;
			_tmp9_ = _tmp8_->user_id;
			_tmp10_ = dm_manager_reset_notification_id (_tmp7_, _tmp9_);
			notification_id = _tmp10_;
			_tmp11_ = notification_id;
			if (_tmp11_ != NULL) {
				GApplication* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = g_application_get_default ();
				_tmp13_ = notification_id;
				g_application_withdraw_notification (_tmp12_, _tmp13_);
			}
			_g_free0 (notification_id);
		}
		_tmp14_ = cb_bundle_new ();
		bundle = _tmp14_;
		_tmp15_ = bundle;
		_tmp16_ = entry;
		_tmp17_ = _tmp16_->user_id;
		cb_bundle_put_int64 (_tmp15_, DM_PAGE_KEY_SENDER_ID, _tmp17_);
		_tmp18_ = self->priv->main_window;
		_tmp19_ = _tmp18_->main_widget;
		_tmp20_ = bundle;
		main_widget_switch_page (_tmp19_, (gint) PAGE_DM, _tmp20_);
		_g_object_unref0 (bundle);
		_g_object_unref0 (entry);
	} else {
		g_warning ("DMThreadsPage.vala:80: activated row is not a DMThreadEntry");
	}
}


static void ___lambda106__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda106_ ((DMThreadsPage*) self, row);
}


static void __lambda107_ (DMThreadsPage* self, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url) {
	DMManager* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp8_;
	gint64 _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	MainWindow* _tmp13_;
	MainWidget* _tmp14_;
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = user_id;
	_tmp2_ = dm_manager_has_thread (_tmp0_, _tmp1_);
	if (_tmp2_) {
		gint _tmp3_;
		gint _tmp4_;
		DMManager* _tmp5_;
		gint64 _tmp6_;
		gint _tmp7_;
		_tmp3_ = dm_threads_page_get_unread_count (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->manager;
		_tmp6_ = user_id;
		_tmp7_ = dm_manager_reset_unread_count (_tmp5_, _tmp6_);
		dm_threads_page_set_unread_count (self, _tmp4_ - _tmp7_);
	}
	_tmp8_ = cb_bundle_new ();
	bundle = _tmp8_;
	_tmp9_ = user_id;
	cb_bundle_put_int64 (bundle, DM_PAGE_KEY_SENDER_ID, _tmp9_);
	_tmp10_ = screen_name;
	cb_bundle_put_string (bundle, DM_PAGE_KEY_SCREEN_NAME, _tmp10_);
	_tmp11_ = name;
	cb_bundle_put_string (bundle, DM_PAGE_KEY_USER_NAME, _tmp11_);
	_tmp12_ = avatar_url;
	cb_bundle_put_string (bundle, DM_PAGE_KEY_AVATAR_URL, _tmp12_);
	_tmp13_ = self->priv->main_window;
	_tmp14_ = _tmp13_->main_widget;
	main_widget_switch_page (_tmp14_, (gint) PAGE_DM, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda107__start_conversation_entry_start (StartConversationEntry* _sender, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url, gpointer self) {
	__lambda107_ ((DMThreadsPage*) self, user_id, screen_name, name, avatar_url);
}


static GtkWidget* _dm_threads_page_thread_widget_func_gtk_list_box_create_widget_func (GObject* item, gpointer self) {
	GtkWidget* result;
	result = dm_threads_page_thread_widget_func ((DMThreadsPage*) self, item);
	return result;
}


DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account) {
	DMThreadsPage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	Account* _tmp2_;
	DMManager* _tmp3_;
	DMManager* _tmp4_;
	DMManager* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	Account* _tmp9_;
	StartConversationEntry* _tmp10_;
	StartConversationEntry* _tmp11_;
	GtkListBox* _tmp12_;
	DMManager* _tmp13_;
	GListModel* _tmp14_;
	GListModel* _tmp15_;
	GtkListBox* _tmp16_;
	StartConversationEntry* _tmp17_;
	DMManager* _tmp18_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (DMThreadsPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = account;
	_tmp3_ = dm_manager_new_for_account (_tmp2_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp3_;
	_tmp4_ = self->priv->manager;
	g_signal_connect_object (_tmp4_, "message-received", (GCallback) _dm_threads_page_dm_received_cb_dm_manager_message_received, self, 0);
	_tmp5_ = self->priv->manager;
	g_signal_connect_object (_tmp5_, "thread-changed", (GCallback) _dm_threads_page_thread_changed_cb_dm_manager_thread_changed, self, 0);
	_tmp6_ = self->priv->thread_list;
	gtk_list_box_set_header_func (_tmp6_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp7_ = self->priv->top_list;
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) ___lambda105__gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->thread_list;
	g_signal_connect_object (_tmp8_, "row-activated", (GCallback) ___lambda106__gtk_list_box_row_activated, self, 0);
	_tmp9_ = account;
	_tmp10_ = start_conversation_entry_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->start_conversation_entry);
	self->priv->start_conversation_entry = _tmp10_;
	_tmp11_ = self->priv->start_conversation_entry;
	g_signal_connect_object (_tmp11_, "start", (GCallback) ___lambda107__start_conversation_entry_start, self, 0);
	_tmp12_ = self->priv->thread_list;
	_tmp13_ = self->priv->manager;
	_tmp14_ = dm_manager_get_threads_model (_tmp13_);
	_tmp15_ = _tmp14_;
	cb_utils_bind_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), _tmp15_, _dm_threads_page_thread_widget_func_gtk_list_box_create_widget_func, self);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->top_list;
	_tmp17_ = self->priv->start_conversation_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->manager;
	dm_manager_load_cached_threads (_tmp18_);
	return self;
}


DMThreadsPage* dm_threads_page_new (gint id, Account* account) {
	return dm_threads_page_construct (TYPE_DM_THREADS_PAGE, id, account);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->row);
		_g_object_unref0 (_data17_->thread);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static void __lambda108_ (Block17Data* _data17_) {
	DMThreadsPage* self;
	cairo_surface_t* _tmp0_;
	self = _data17_->self;
	_tmp0_ = _data17_->thread->avatar_surface;
	dm_thread_entry_set_avatar (_data17_->row, _tmp0_);
}


static void ___lambda108__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda108_ (self);
	block17_data_unref (self);
}


static GtkWidget* dm_threads_page_thread_widget_func (DMThreadsPage* self, GObject* item) {
	GtkWidget* result = NULL;
	Block17Data* _data17_;
	GObject* _tmp0_;
	DMThread* _tmp1_;
	CbUserIdentity _tmp2_;
	gint64 _tmp3_;
	DMThreadEntry* _tmp4_;
	CbUserIdentity _tmp5_;
	const gchar* _tmp6_;
	CbUserIdentity _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	Account* _tmp11_;
	gint _tmp12_;
	GtkWidget* _tmp13_;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	g_return_val_if_fail (G_IS_OBJECT (item), NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = item;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DM_THREAD, DMThread));
	_data17_->thread = _tmp1_;
	_tmp2_ = _data17_->thread->user;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = dm_thread_entry_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_data17_->row = _tmp4_;
	_tmp5_ = _data17_->thread->user;
	_tmp6_ = _tmp5_.screen_name;
	dm_thread_entry_set_screen_name (_data17_->row, _tmp6_);
	_tmp7_ = _data17_->thread->user;
	_tmp8_ = _tmp7_.user_name;
	dm_thread_entry_set_name (_data17_->row, _tmp8_);
	_tmp9_ = _data17_->thread->last_message;
	dm_thread_entry_set_last_message (_data17_->row, _tmp9_);
	_tmp10_ = _data17_->thread->unread_count;
	dm_thread_entry_set_unread_count (_data17_->row, _tmp10_);
	_tmp11_ = self->account;
	_tmp12_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	dm_thread_load_avatar (_data17_->thread, _tmp11_, _tmp12_, ___lambda108__gasync_ready_callback, block17_data_ref (_data17_));
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data17_->row, gtk_widget_get_type (), GtkWidget));
	result = _tmp13_;
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


static void dm_threads_page_dm_received_cb (DMThreadsPage* self, DMThread* thread, const gchar* text, gboolean initial) {
	DMThread* _tmp0_;
	CbUserIdentity _tmp1_;
	gint64 _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	DMThread* _tmp5_;
	CbUserIdentity _tmp6_;
	gint64 _tmp7_;
	Account* _tmp8_;
	gint64 _tmp9_;
	gboolean _tmp16_;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (IS_DM_THREAD (thread));
	g_return_if_fail (text != NULL);
	_tmp0_ = thread;
	_tmp1_ = _tmp0_->user;
	_tmp2_ = _tmp1_.id;
	_tmp3_ = self->account;
	_tmp4_ = _tmp3_->id;
	_vala_assert (_tmp2_ != _tmp4_, "thread.user.id != account.id");
	_tmp5_ = thread;
	_tmp6_ = _tmp5_->user;
	_tmp7_ = _tmp6_.id;
	_tmp8_ = self->account;
	_tmp9_ = _tmp8_->id;
	if (_tmp7_ != _tmp9_) {
		DMThread* _tmp10_;
		CbUserIdentity _tmp11_;
		gint64 _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = thread;
		_tmp11_ = _tmp10_->user;
		_tmp12_ = _tmp11_.id;
		_tmp13_ = dm_threads_page_user_id_visible (self, _tmp12_);
		if (!_tmp13_) {
			gint _tmp14_;
			gint _tmp15_;
			_tmp14_ = dm_threads_page_get_unread_count (self);
			_tmp15_ = _tmp14_;
			dm_threads_page_set_unread_count (self, _tmp15_ + 1);
			g_debug ("DMThreadsPage.vala:125: Increasing global unread count by 1");
		}
	}
	_tmp16_ = initial;
	if (!_tmp16_) {
		DMThread* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = thread;
		_tmp18_ = text;
		dm_threads_page_notify_new_dm (self, _tmp17_, _tmp18_);
	}
}


static void dm_threads_page_thread_changed_cb (DMThreadsPage* self, DMThread* thread) {
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (IS_DM_THREAD (thread));
	_tmp0_ = self->priv->thread_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* w = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = w;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_DM_THREAD_ENTRY)) {
					DMThreadEntry* entry = NULL;
					GtkWidget* _tmp4_;
					DMThreadEntry* _tmp5_;
					DMThreadEntry* _tmp6_;
					gint64 _tmp7_;
					DMThread* _tmp8_;
					CbUserIdentity _tmp9_;
					gint64 _tmp10_;
					_tmp4_ = w;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DM_THREAD_ENTRY, DMThreadEntry));
					entry = _tmp5_;
					_tmp6_ = entry;
					_tmp7_ = _tmp6_->user_id;
					_tmp8_ = thread;
					_tmp9_ = _tmp8_->user;
					_tmp10_ = _tmp9_.id;
					if (_tmp7_ == _tmp10_) {
						DMThreadEntry* _tmp11_;
						DMThread* _tmp12_;
						const gchar* _tmp13_;
						DMThreadEntry* _tmp14_;
						DMThread* _tmp15_;
						gint _tmp16_;
						_tmp11_ = entry;
						_tmp12_ = thread;
						_tmp13_ = _tmp12_->last_message;
						dm_thread_entry_set_last_message (_tmp11_, _tmp13_);
						_tmp14_ = entry;
						_tmp15_ = thread;
						_tmp16_ = _tmp15_->unread_count;
						dm_thread_entry_set_unread_count (_tmp14_, _tmp16_);
						_g_object_unref0 (entry);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (entry);
				}
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void dm_threads_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	DMThreadsPage * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_DIRECT_MESSAGE) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonObject* _tmp4_;
		DMManager* _tmp5_;
		JsonObject* _tmp6_;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "direct_message");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = self->priv->manager;
		_tmp6_ = obj;
		dm_manager_insert_message (_tmp5_, _tmp6_);
		_json_object_unref0 (obj);
	}
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data18_->self;
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static void ___lambda109_ (Block18Data* _data18_) {
	DMThreadsPage* self;
	gboolean _tmp0_;
	self = _data18_->self;
	_tmp0_ = _data18_->was_empty;
	if (_tmp0_) {
		GtkListBoxRow* _tmp1_;
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GList* _tmp6_;
		_tmp1_ = self->priv->progress_row;
		if (_tmp1_ != NULL) {
			GtkListBox* _tmp2_;
			GtkListBoxRow* _tmp3_;
			_tmp2_ = self->priv->thread_list;
			_tmp3_ = self->priv->progress_row;
			gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (self->priv->progress_row);
			self->priv->progress_row = NULL;
		}
		_tmp4_ = self->priv->top_list;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
		_tmp5_ = self->priv->thread_list;
		_tmp6_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer));
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp6_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp7_;
				GtkWidget* w = NULL;
				_tmp7_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp7_;
				{
					GtkWidget* _tmp8_;
					_tmp8_ = w;
					gtk_widget_show (_tmp8_);
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
	}
}


static void ____lambda109__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda109_ (self);
	block18_data_unref (self);
}


static void dm_threads_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	DMThreadsPage * self;
	GNetworkMonitor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = g_network_monitor_get_network_available (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->initialized;
	if (!_tmp2_) {
		Block18Data* _data18_;
		DMManager* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		DMManager* _tmp20_;
		_data18_ = g_slice_new0 (Block18Data);
		_data18_->_ref_count_ = 1;
		_data18_->self = g_object_ref (self);
		_tmp3_ = self->priv->manager;
		_tmp4_ = dm_manager_get_empty (_tmp3_);
		_tmp5_ = _tmp4_;
		_data18_->was_empty = _tmp5_;
		_tmp6_ = _data18_->was_empty;
		if (_tmp6_) {
			GtkListBox* _tmp7_;
			GtkListBoxRow* _tmp8_;
			GtkSpinner* spinner = NULL;
			GtkSpinner* _tmp9_;
			GtkSpinner* _tmp10_;
			GtkSpinner* _tmp11_;
			GtkSpinner* _tmp12_;
			GtkSpinner* _tmp13_;
			GtkListBoxRow* _tmp14_;
			GtkSpinner* _tmp15_;
			GtkListBoxRow* _tmp16_;
			GtkListBoxRow* _tmp17_;
			GtkListBox* _tmp18_;
			GtkListBoxRow* _tmp19_;
			_tmp7_ = self->priv->top_list;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
			_tmp8_ = (GtkListBoxRow*) gtk_list_box_row_new ();
			g_object_ref_sink (_tmp8_);
			_g_object_unref0 (self->priv->progress_row);
			self->priv->progress_row = _tmp8_;
			_tmp9_ = (GtkSpinner*) gtk_spinner_new ();
			g_object_ref_sink (_tmp9_);
			spinner = _tmp9_;
			_tmp10_ = spinner;
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), 16, 16);
			_tmp11_ = spinner;
			g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), "margin", 12, NULL);
			_tmp12_ = spinner;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp13_ = spinner;
			gtk_spinner_start (_tmp13_);
			_tmp14_ = self->priv->progress_row;
			_tmp15_ = spinner;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
			_tmp16_ = self->priv->progress_row;
			gtk_list_box_row_set_activatable (_tmp16_, FALSE);
			_tmp17_ = self->priv->progress_row;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp18_ = self->priv->thread_list;
			_tmp19_ = self->priv->progress_row;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (spinner);
		}
		_tmp20_ = self->priv->manager;
		dm_manager_load_newest_dms (_tmp20_, ____lambda109__gasync_ready_callback, block18_data_ref (_data18_));
		self->priv->initialized = TRUE;
		block18_data_unref (_data18_);
		_data18_ = NULL;
	}
}


static void dm_threads_page_real_on_leave (IPage* base) {
	DMThreadsPage * self;
	StartConversationEntry* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->start_conversation_entry;
	start_conversation_entry_unreveal (_tmp0_);
}


static void dm_threads_page_notify_new_dm (DMThreadsPage* self, DMThread* thread, const gchar* msg_text) {
	gboolean _tmp0_;
	gchar* sender_screen_name = NULL;
	DMThread* _tmp1_;
	CbUserIdentity _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gint64 sender_id = 0LL;
	DMThread* _tmp5_;
	CbUserIdentity _tmp6_;
	gint64 _tmp7_;
	gchar* summary = NULL;
	gchar* text = NULL;
	DMThread* _tmp8_;
	const gchar* _tmp9_;
	DMThread* _tmp23_;
	Account* _tmp24_;
	NotificationManager* _tmp25_;
	gint64 _tmp26_;
	DMThread* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (IS_DM_THREAD (thread));
	g_return_if_fail (msg_text != NULL);
	_tmp0_ = settings_notify_new_dms ();
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = thread;
	_tmp2_ = _tmp1_->user;
	_tmp3_ = _tmp2_.screen_name;
	_tmp4_ = g_strdup (_tmp3_);
	sender_screen_name = _tmp4_;
	_tmp5_ = thread;
	_tmp6_ = _tmp5_->user;
	_tmp7_ = _tmp6_.id;
	sender_id = _tmp7_;
	_tmp8_ = thread;
	_tmp9_ = _tmp8_->notification_id;
	if (_tmp9_ != NULL) {
		DMThread* _tmp10_;
		gint _tmp11_;
		DMThread* _tmp12_;
		gint _tmp13_;
		DMThread* _tmp14_;
		CbUserIdentity _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp10_ = thread;
		_tmp11_ = _tmp10_->unread_count;
		_tmp12_ = thread;
		_tmp13_ = _tmp12_->unread_count;
		_tmp14_ = thread;
		_tmp15_ = _tmp14_->user;
		_tmp16_ = _tmp15_.user_name;
		_tmp17_ = g_strdup_printf (ngettext ("%d new Message from %s", "%d new Messages from %s", (gulong) _tmp11_), _tmp13_, _tmp16_);
		_g_free0 (summary);
		summary = _tmp17_;
		_tmp18_ = g_strdup ("");
		_g_free0 (text);
		text = _tmp18_;
	} else {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = sender_screen_name;
		_tmp20_ = g_strdup_printf (_ ("New direct message from %s"), _tmp19_);
		_g_free0 (summary);
		summary = _tmp20_;
		_tmp21_ = msg_text;
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (text);
		text = _tmp22_;
	}
	_tmp23_ = thread;
	_tmp24_ = self->account;
	_tmp25_ = _tmp24_->notifications;
	_tmp26_ = sender_id;
	_tmp27_ = thread;
	_tmp28_ = _tmp27_->notification_id;
	_tmp29_ = summary;
	_tmp30_ = text;
	_tmp31_ = notification_manager_send_dm (_tmp25_, _tmp26_, _tmp28_, _tmp29_, _tmp30_);
	_g_free0 (_tmp23_->notification_id);
	_tmp23_->notification_id = _tmp31_;
	_g_free0 (text);
	_g_free0 (summary);
	_g_free0 (sender_screen_name);
}


static void dm_threads_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	DMThreadsPage * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "corebird-dms-symbolic", _ ("Direct Messages"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = _tmp1_;
}


static GtkRadioButton* dm_threads_page_real_get_radio_button (IPage* base) {
	DMThreadsPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


static gboolean dm_threads_page_user_id_visible (DMThreadsPage* self, gint64 sender_id) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), FALSE);
	_tmp1_ = self->priv->main_window;
	_tmp2_ = main_window_get_cur_page_id (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((gint) PAGE_DM)) {
		MainWindow* _tmp4_;
		IPage* _tmp5_;
		DMPage* _tmp6_;
		gint64 _tmp7_;
		gint64 _tmp8_;
		_tmp4_ = self->priv->main_window;
		_tmp5_ = main_window_get_page (_tmp4_, (gint) PAGE_DM);
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DM_PAGE, DMPage);
		_tmp7_ = _tmp6_->user_id;
		_tmp8_ = sender_id;
		_tmp0_ = _tmp7_ == _tmp8_;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* dm_threads_page_real_get_title (IPage* base) {
	DMThreadsPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = g_strdup (_ ("Direct Messages"));
	result = _tmp0_;
	return result;
}


void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id) {
	gint unread_count = 0;
	DMManager* _tmp0_;
	gint64 _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->manager;
	_tmp1_ = user_id;
	_tmp2_ = dm_manager_reset_unread_count (_tmp0_, _tmp1_);
	unread_count = _tmp2_;
	_tmp3_ = dm_threads_page_get_unread_count (self);
	_tmp4_ = _tmp3_;
	dm_threads_page_set_unread_count (self, _tmp4_ - unread_count);
	g_debug ("DMThreadsPage.vala:241: unread_count -= %d", unread_count);
}


gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id) {
	gchar* result = NULL;
	DMManager* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	gchar* id = NULL;
	DMManager* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = user_id;
	_tmp2_ = dm_manager_has_thread (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		gint64 _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = user_id;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		g_warning ("DMThreadsPage.vala:246: No thread for user id %s", _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->manager;
	_tmp7_ = user_id;
	_tmp8_ = dm_manager_reset_notification_id (_tmp6_, _tmp7_);
	id = _tmp8_;
	result = id;
	return result;
}


static gboolean dm_threads_page_top_list_keynav_failed_cb (DMThreadsPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_DOWN) {
		GtkListBox* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->thread_list;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_;
			GtkDirectionType _tmp5_;
			_tmp4_ = self->priv->thread_list;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _dm_threads_page_top_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = dm_threads_page_top_list_keynav_failed_cb ((DMThreadsPage*) self, direction);
	return result;
}


static gboolean dm_threads_page_thread_list_keynav_failed_cb (DMThreadsPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_UP) {
		GtkListBox* _tmp1_;
		GtkDirectionType _tmp2_;
		_tmp1_ = self->priv->top_list;
		_tmp2_ = direction;
		gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _dm_threads_page_thread_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = dm_threads_page_thread_list_keynav_failed_cb ((DMThreadsPage*) self, direction);
	return result;
}


gint dm_threads_page_get_unread_count (DMThreadsPage* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), 0);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


void dm_threads_page_set_unread_count (DMThreadsPage* self, gint value) {
	gint _tmp0_;
	BadgeRadioButton* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = value;
	self->priv->_unread_count = _tmp0_;
	_tmp1_ = self->priv->radio_button;
	_tmp2_ = self->priv->_unread_count;
	badge_radio_button_set_show_badge (_tmp1_, _tmp2_ > 0);
	g_object_notify ((GObject *) self, "unread-count");
}


static void dm_threads_page_real_set_window (IPage* base, MainWindow* value) {
	DMThreadsPage* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static gint dm_threads_page_real_get_id (IPage* base) {
	gint result;
	DMThreadsPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_id (IPage* base, gint value) {
	DMThreadsPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	if (dm_threads_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify ((GObject *) self, "id");
	}
}


static void dm_threads_page_class_init (DMThreadsPageClass * klass) {
	gint DMThreadsPage_private_offset;
	dm_threads_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMThreadsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_threads_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_threads_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_threads_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	DMThreadsPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-threads-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thread_list", FALSE, DMThreadsPage_private_offset + G_STRUCT_OFFSET (DMThreadsPagePrivate, thread_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "top_list", FALSE, DMThreadsPage_private_offset + G_STRUCT_OFFSET (DMThreadsPagePrivate, top_list));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "top_list_keynav_failed_cb", G_CALLBACK(_dm_threads_page_top_list_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "thread_list_keynav_failed_cb", G_CALLBACK(_dm_threads_page_thread_list_keynav_failed_cb_gtk_widget_keynav_failed));
}


static void dm_threads_page_ipage_interface_init (IPageIface * iface) {
	dm_threads_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) dm_threads_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) dm_threads_page_real_on_leave;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) dm_threads_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) dm_threads_page_real_get_radio_button;
	iface->get_title = (gchar* (*) (IPage *)) dm_threads_page_real_get_title;
	iface->set_window = dm_threads_page_real_set_window;
	iface->get_id = dm_threads_page_real_get_id;
	iface->set_id = dm_threads_page_real_set_id;
}


static void dm_threads_page_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	dm_threads_page_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) dm_threads_page_real_stream_message_received;
}


static void dm_threads_page_instance_init (DMThreadsPage * self) {
	self->priv = DM_THREADS_PAGE_GET_PRIVATE (self);
	self->priv->initialized = FALSE;
	self->priv->_unread_count = 0;
	self->priv->progress_row = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_threads_page_finalize (GObject * obj) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->start_conversation_entry);
	_g_object_unref0 (self->priv->thread_list);
	_g_object_unref0 (self->priv->top_list);
	_g_object_unref0 (self->priv->progress_row);
	_g_object_unref0 (self->priv->manager);
	G_OBJECT_CLASS (dm_threads_page_parent_class)->finalize (obj);
}


GType dm_threads_page_get_type (void) {
	static volatile gsize dm_threads_page_type_id__volatile = 0;
	if (g_once_init_enter (&dm_threads_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMThreadsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_threads_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMThreadsPage), 0, (GInstanceInitFunc) dm_threads_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) dm_threads_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) dm_threads_page_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_threads_page_type_id;
		dm_threads_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "DMThreadsPage", &g_define_type_info, 0);
		g_type_add_interface_static (dm_threads_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (dm_threads_page_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&dm_threads_page_type_id__volatile, dm_threads_page_type_id);
	}
	return dm_threads_page_type_id__volatile;
}


static void _vala_dm_threads_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	switch (property_id) {
		case DM_THREADS_PAGE_UNREAD_COUNT:
		g_value_set_int (value, dm_threads_page_get_unread_count (self));
		break;
		case DM_THREADS_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_threads_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	switch (property_id) {
		case DM_THREADS_PAGE_UNREAD_COUNT:
		dm_threads_page_set_unread_count (self, g_value_get_int (value));
		break;
		case DM_THREADS_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



