/* HomeTimeline.c generated by valac 0.36.4, the Vala compiler
 * generated from HomeTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbUserStream.h"
#include <json-glib/json-glib.h>
#include "rest/oauth-proxy.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTweet.h"
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;
typedef struct _HomeTimelinePrivate HomeTimelinePrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, CbBundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _HomeTimeline {
	DefaultTimeline parent_instance;
	HomeTimelinePrivate * priv;
};

struct _HomeTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer home_timeline_parent_class = NULL;
static CbMessageReceiverInterface * home_timeline_cb_message_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
enum  {
	HOME_TIMELINE_DUMMY_PROPERTY,
	HOME_TIMELINE_FUNCTION
};
HomeTimeline* home_timeline_new (gint id, Account* account);
HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
static void home_timeline_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t);
gboolean account_is_blocked (Account* self, gint64 user_id);
gboolean account_is_muted (Account* self, gint64 user_id);
gboolean account_filter_matches (Account* self, CbTweet* t);
gboolean settings_auto_scroll_on_new_tweets (void);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
gint settings_get_tweet_stack_count (void);
gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
static gchar* home_timeline_real_get_title (DefaultTimeline* base);
static void home_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account) {
	HomeTimeline * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	TweetListBox* _tmp2_;
	Account* _tmp3_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (HomeTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	return self;
}


HomeTimeline* home_timeline_new (gint id, Account* account) {
	return home_timeline_construct (TYPE_HOME_TIMELINE, id, account);
}


static void home_timeline_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	HomeTimeline * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_TWEET) {
		JsonNode* _tmp1_;
		_tmp1_ = root;
		home_timeline_add_tweet (self, _tmp1_);
	} else {
		CbStreamMessageType _tmp2_;
		_tmp2_ = type;
		if (_tmp2_ == CB_STREAM_MESSAGE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_;
			JsonObject* _tmp4_;
			JsonObject* _tmp5_;
			JsonObject* _tmp6_;
			gint64 _tmp7_;
			gint64 _tmp8_;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			CbStreamMessageType _tmp9_;
			_tmp9_ = type;
			if (_tmp9_ == CB_STREAM_MESSAGE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_;
				JsonObject* _tmp11_;
				JsonObject* _tmp12_;
				gint64 _tmp13_;
				gint64 source_id = 0LL;
				JsonNode* _tmp14_;
				JsonObject* _tmp15_;
				JsonObject* _tmp16_;
				gint64 _tmp17_;
				gint64 _tmp18_;
				Account* _tmp19_;
				gint64 _tmp20_;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = root;
				_tmp15_ = json_node_get_object (_tmp14_);
				_tmp16_ = json_object_get_object_member (_tmp15_, "source");
				_tmp17_ = json_object_get_int_member (_tmp16_, "id");
				source_id = _tmp17_;
				_tmp18_ = source_id;
				_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
				_tmp20_ = _tmp19_->id;
				if (_tmp18_ == _tmp20_) {
					gint64 _tmp21_;
					_tmp21_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp21_, TRUE);
				}
			} else {
				CbStreamMessageType _tmp22_;
				_tmp22_ = type;
				if (_tmp22_ == CB_STREAM_MESSAGE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp23_;
					JsonObject* _tmp24_;
					JsonObject* _tmp25_;
					gint64 _tmp26_;
					gint64 source_id = 0LL;
					JsonNode* _tmp27_;
					JsonObject* _tmp28_;
					JsonObject* _tmp29_;
					gint64 _tmp30_;
					gint64 _tmp31_;
					Account* _tmp32_;
					gint64 _tmp33_;
					_tmp23_ = root;
					_tmp24_ = json_node_get_object (_tmp23_);
					_tmp25_ = json_object_get_object_member (_tmp24_, "target_object");
					_tmp26_ = json_object_get_int_member (_tmp25_, "id");
					id = _tmp26_;
					_tmp27_ = root;
					_tmp28_ = json_node_get_object (_tmp27_);
					_tmp29_ = json_object_get_object_member (_tmp28_, "source");
					_tmp30_ = json_object_get_int_member (_tmp29_, "id");
					source_id = _tmp30_;
					_tmp31_ = source_id;
					_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
					_tmp33_ = _tmp32_->id;
					if (_tmp31_ == _tmp33_) {
						gint64 _tmp34_;
						_tmp34_ = id;
						default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp34_, FALSE);
					}
				} else {
					CbStreamMessageType _tmp35_;
					_tmp35_ = type;
					if (_tmp35_ == CB_STREAM_MESSAGE_EVENT_BLOCK) {
						gint64 user_id = 0LL;
						JsonNode* _tmp36_;
						JsonObject* _tmp37_;
						JsonObject* _tmp38_;
						gint64 _tmp39_;
						gint64 _tmp40_;
						_tmp36_ = root;
						_tmp37_ = json_node_get_object (_tmp36_);
						_tmp38_ = json_object_get_object_member (_tmp37_, "target");
						_tmp39_ = json_object_get_int_member (_tmp38_, "id");
						user_id = _tmp39_;
						_tmp40_ = user_id;
						home_timeline_hide_tweets_from (self, _tmp40_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
					} else {
						CbStreamMessageType _tmp41_;
						_tmp41_ = type;
						if (_tmp41_ == CB_STREAM_MESSAGE_EVENT_UNBLOCK) {
							gint64 user_id = 0LL;
							JsonNode* _tmp42_;
							JsonObject* _tmp43_;
							JsonObject* _tmp44_;
							gint64 _tmp45_;
							gint64 _tmp46_;
							_tmp42_ = root;
							_tmp43_ = json_node_get_object (_tmp42_);
							_tmp44_ = json_object_get_object_member (_tmp43_, "target");
							_tmp45_ = json_object_get_int_member (_tmp44_, "id");
							user_id = _tmp45_;
							_tmp46_ = user_id;
							home_timeline_show_tweets_from (self, _tmp46_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
						} else {
							CbStreamMessageType _tmp47_;
							_tmp47_ = type;
							if (_tmp47_ == CB_STREAM_MESSAGE_EVENT_MUTE) {
								gint64 user_id = 0LL;
								JsonNode* _tmp48_;
								JsonObject* _tmp49_;
								JsonObject* _tmp50_;
								gint64 _tmp51_;
								gint64 _tmp52_;
								_tmp48_ = root;
								_tmp49_ = json_node_get_object (_tmp48_);
								_tmp50_ = json_object_get_object_member (_tmp49_, "target");
								_tmp51_ = json_object_get_int_member (_tmp50_, "id");
								user_id = _tmp51_;
								_tmp52_ = user_id;
								home_timeline_hide_tweets_from (self, _tmp52_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
							} else {
								CbStreamMessageType _tmp53_;
								_tmp53_ = type;
								if (_tmp53_ == CB_STREAM_MESSAGE_EVENT_UNMUTE) {
									gint64 user_id = 0LL;
									JsonNode* _tmp54_;
									JsonObject* _tmp55_;
									JsonObject* _tmp56_;
									gint64 _tmp57_;
									gint64 _tmp58_;
									_tmp54_ = root;
									_tmp55_ = json_node_get_object (_tmp54_);
									_tmp56_ = json_object_get_object_member (_tmp55_, "target");
									_tmp57_ = json_object_get_int_member (_tmp56_, "id");
									user_id = _tmp57_;
									_tmp58_ = user_id;
									home_timeline_show_tweets_from (self, _tmp58_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
								}
							}
						}
					}
				}
			}
		}
	}
}


static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	CbTweet* t = NULL;
	CbTweet* _tmp1_;
	CbTweet* _tmp2_;
	JsonNode* _tmp3_;
	Account* _tmp4_;
	gint64 _tmp5_;
	GDateTime* _tmp6_;
	CbTweet* _tmp7_;
	CbMiniTweet* _tmp8_;
	Account* _tmp54_;
	CbTweet* _tmp55_;
	gboolean _tmp56_;
	gboolean auto_scroll = FALSE;
	gboolean _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	CbTweet* _tmp61_;
	CbMiniTweet _tmp62_;
	CbUserIdentity _tmp63_;
	gint64 _tmp64_;
	Account* _tmp65_;
	gint64 _tmp66_;
	CbTweet* _tmp86_;
	gboolean _tmp87_ = FALSE;
	TweetListBox* _tmp88_;
	GtkWidget* _tmp89_;
	GtkWidget* _tmp90_;
	gboolean _tmp91_;
	gboolean focused = FALSE;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_;
	gboolean should_focus = FALSE;
	TweetListBox* _tmp101_;
	CbTweetModel* _tmp102_;
	CbTweet* _tmp103_;
	CbTweet* _tmp104_;
	gboolean _tmp105_;
	gboolean _tmp113_;
	CbTweet* _tmp117_;
	gboolean _tmp118_;
	gint stack_size = 0;
	gint _tmp119_;
	gboolean _tmp120_ = FALSE;
	CbTweet* _tmp121_;
	gint64 _tmp122_;
	Account* _tmp123_;
	gint64 _tmp124_;
	gboolean _tmp126_ = FALSE;
	gint _tmp127_;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	g_return_if_fail (obj != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = cb_tweet_new ();
	t = _tmp1_;
	_tmp2_ = t;
	_tmp3_ = obj;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp5_ = _tmp4_->id;
	_tmp6_ = now;
	cb_tweet_load_from_json (_tmp2_, _tmp3_, _tmp5_, _tmp6_);
	_tmp7_ = t;
	_tmp8_ = _tmp7_->retweeted_tweet;
	if (_tmp8_ != NULL) {
		CbTweet* _tmp9_;
		CbTweet* _tmp10_;
		CbTweetState _tmp11_;
		Account* _tmp12_;
		CbTweet* _tmp13_;
		CbMiniTweet _tmp14_;
		CbUserIdentity _tmp15_;
		gint64 _tmp16_;
		gboolean _tmp17_;
		Account* _tmp19_;
		CbTweet* _tmp20_;
		CbMiniTweet* _tmp21_;
		CbUserIdentity _tmp22_;
		gint64 _tmp23_;
		gboolean _tmp24_;
		Account* _tmp26_;
		CbTweet* _tmp27_;
		CbMiniTweet _tmp28_;
		CbUserIdentity _tmp29_;
		gint64 _tmp30_;
		gboolean _tmp31_;
		Account* _tmp33_;
		CbTweet* _tmp34_;
		CbMiniTweet* _tmp35_;
		CbUserIdentity _tmp36_;
		gint64 _tmp37_;
		gboolean _tmp38_;
		_tmp9_ = t;
		_tmp10_ = t;
		_tmp11_ = default_timeline_get_rt_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp10_);
		cb_tweet_set_flag (_tmp9_, (guint) _tmp11_);
		_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp13_ = t;
		_tmp14_ = _tmp13_->source_tweet;
		_tmp15_ = _tmp14_.author;
		_tmp16_ = _tmp15_.id;
		_tmp17_ = account_is_blocked (_tmp12_, _tmp16_);
		if (_tmp17_) {
			CbTweet* _tmp18_;
			_tmp18_ = t;
			cb_tweet_set_flag (_tmp18_, (guint) CB_TWEET_STATE_HIDDEN_RETWEETER_BLOCKED);
		}
		_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp20_ = t;
		_tmp21_ = _tmp20_->retweeted_tweet;
		_tmp22_ = (*_tmp21_).author;
		_tmp23_ = _tmp22_.id;
		_tmp24_ = account_is_blocked (_tmp19_, _tmp23_);
		if (_tmp24_) {
			CbTweet* _tmp25_;
			_tmp25_ = t;
			cb_tweet_set_flag (_tmp25_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
		}
		_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp27_ = t;
		_tmp28_ = _tmp27_->source_tweet;
		_tmp29_ = _tmp28_.author;
		_tmp30_ = _tmp29_.id;
		_tmp31_ = account_is_muted (_tmp26_, _tmp30_);
		if (_tmp31_) {
			CbTweet* _tmp32_;
			_tmp32_ = t;
			cb_tweet_set_flag (_tmp32_, (guint) CB_TWEET_STATE_HIDDEN_RETWEETER_MUTED);
		}
		_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp34_ = t;
		_tmp35_ = _tmp34_->retweeted_tweet;
		_tmp36_ = (*_tmp35_).author;
		_tmp37_ = _tmp36_.id;
		_tmp38_ = account_is_muted (_tmp33_, _tmp37_);
		if (_tmp38_) {
			CbTweet* _tmp39_;
			_tmp39_ = t;
			cb_tweet_set_flag (_tmp39_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		}
	} else {
		Account* _tmp40_;
		CbTweet* _tmp41_;
		CbMiniTweet _tmp42_;
		CbUserIdentity _tmp43_;
		gint64 _tmp44_;
		gboolean _tmp45_;
		Account* _tmp47_;
		CbTweet* _tmp48_;
		CbMiniTweet _tmp49_;
		CbUserIdentity _tmp50_;
		gint64 _tmp51_;
		gboolean _tmp52_;
		_tmp40_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp41_ = t;
		_tmp42_ = _tmp41_->source_tweet;
		_tmp43_ = _tmp42_.author;
		_tmp44_ = _tmp43_.id;
		_tmp45_ = account_is_blocked (_tmp40_, _tmp44_);
		if (_tmp45_) {
			CbTweet* _tmp46_;
			_tmp46_ = t;
			cb_tweet_set_flag (_tmp46_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
		}
		_tmp47_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp48_ = t;
		_tmp49_ = _tmp48_->source_tweet;
		_tmp50_ = _tmp49_.author;
		_tmp51_ = _tmp50_.id;
		_tmp52_ = account_is_muted (_tmp47_, _tmp51_);
		if (_tmp52_) {
			CbTweet* _tmp53_;
			_tmp53_ = t;
			cb_tweet_set_flag (_tmp53_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		}
	}
	_tmp54_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp55_ = t;
	_tmp56_ = account_filter_matches (_tmp54_, _tmp55_);
	if (_tmp56_) {
		CbTweet* _tmp57_;
		_tmp57_ = t;
		cb_tweet_set_flag (_tmp57_, (guint) CB_TWEET_STATE_HIDDEN_FILTERED);
	}
	_tmp58_ = settings_auto_scroll_on_new_tweets ();
	auto_scroll = _tmp58_;
	_tmp61_ = t;
	_tmp62_ = _tmp61_->source_tweet;
	_tmp63_ = _tmp62_.author;
	_tmp64_ = _tmp63_.id;
	_tmp65_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp66_ = _tmp65_->id;
	if (_tmp64_ == _tmp66_) {
		_tmp60_ = TRUE;
	} else {
		gboolean _tmp67_ = FALSE;
		CbTweet* _tmp68_;
		CbMiniTweet* _tmp69_;
		_tmp68_ = t;
		_tmp69_ = _tmp68_->retweeted_tweet;
		if (_tmp69_ != NULL) {
			CbTweet* _tmp70_;
			CbMiniTweet* _tmp71_;
			CbUserIdentity _tmp72_;
			gint64 _tmp73_;
			Account* _tmp74_;
			gint64 _tmp75_;
			_tmp70_ = t;
			_tmp71_ = _tmp70_->retweeted_tweet;
			_tmp72_ = (*_tmp71_).author;
			_tmp73_ = _tmp72_.id;
			_tmp74_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp75_ = _tmp74_->id;
			_tmp67_ = _tmp73_ == _tmp75_;
		} else {
			_tmp67_ = FALSE;
		}
		_tmp60_ = _tmp67_;
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_;
		gboolean _tmp79_;
		_tmp78_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp79_ = _tmp78_;
		if (_tmp79_) {
			MainWindow* _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			_tmp80_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->main_window;
			_tmp81_ = main_window_get_cur_page_id (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp84_ = _tmp83_;
			_tmp77_ = _tmp82_ == _tmp84_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			gboolean _tmp85_;
			_tmp85_ = auto_scroll;
			_tmp76_ = _tmp85_;
		} else {
			_tmp76_ = FALSE;
		}
		_tmp59_ = _tmp76_;
	}
	_tmp86_ = t;
	cb_tweet_set_seen (_tmp86_, _tmp59_);
	_tmp88_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp89_ = tweet_list_box_get_first_visible_row (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = _tmp90_ != NULL;
	_g_object_unref0 (_tmp90_);
	if (_tmp91_) {
		TweetListBox* _tmp92_;
		GtkWidget* _tmp93_;
		GtkWidget* _tmp94_;
		gboolean _tmp95_;
		gboolean _tmp96_;
		_tmp92_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp93_ = tweet_list_box_get_first_visible_row (_tmp92_);
		_tmp94_ = _tmp93_;
		g_object_get (_tmp94_, "is-focus", &_tmp95_, NULL);
		_tmp96_ = _tmp95_;
		_tmp87_ = _tmp96_;
		_g_object_unref0 (_tmp94_);
	} else {
		_tmp87_ = FALSE;
	}
	focused = _tmp87_;
	_tmp98_ = focused;
	if (_tmp98_) {
		gboolean _tmp99_;
		gboolean _tmp100_;
		_tmp99_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp100_ = _tmp99_;
		_tmp97_ = _tmp100_;
	} else {
		_tmp97_ = FALSE;
	}
	should_focus = _tmp97_;
	_tmp101_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp102_ = _tmp101_->model;
	_tmp103_ = t;
	cb_tweet_model_add (_tmp102_, _tmp103_);
	_tmp104_ = t;
	_tmp105_ = cb_tweet_is_hidden (_tmp104_);
	if (!_tmp105_) {
		gboolean _tmp106_;
		CbTweet* _tmp108_;
		gboolean _tmp109_;
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
		_tmp106_ = auto_scroll;
		if (_tmp106_) {
			CbTweet* _tmp107_;
			_tmp107_ = t;
			default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp107_);
		}
		_tmp108_ = t;
		_tmp109_ = cb_tweet_get_seen (_tmp108_);
		if (!_tmp109_) {
			gint _tmp110_;
			gint _tmp111_;
			_tmp110_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp111_ = _tmp110_;
			default_timeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp111_ + 1);
		}
	} else {
		CbTweet* _tmp112_;
		_tmp112_ = t;
		cb_tweet_set_seen (_tmp112_, TRUE);
	}
	_tmp113_ = should_focus;
	if (_tmp113_) {
		TweetListBox* _tmp114_;
		GtkWidget* _tmp115_;
		GtkWidget* _tmp116_;
		_tmp114_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp115_ = tweet_list_box_get_first_visible_row (_tmp114_);
		_tmp116_ = _tmp115_;
		gtk_widget_grab_focus (_tmp116_);
		_g_object_unref0 (_tmp116_);
	}
	_tmp117_ = t;
	_tmp118_ = cb_tweet_is_hidden (_tmp117_);
	if (_tmp118_) {
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp119_ = settings_get_tweet_stack_count ();
	stack_size = _tmp119_;
	_tmp121_ = t;
	_tmp122_ = cb_tweet_get_user_id (_tmp121_);
	_tmp123_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp124_ = _tmp123_->id;
	if (_tmp122_ == _tmp124_) {
		_tmp120_ = TRUE;
	} else {
		gboolean _tmp125_;
		_tmp125_ = auto_scroll;
		_tmp120_ = _tmp125_;
	}
	if (_tmp120_) {
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp127_ = stack_size;
	if (_tmp127_ == 1) {
		gboolean _tmp128_;
		_tmp128_ = auto_scroll;
		_tmp126_ = !_tmp128_;
	} else {
		_tmp126_ = FALSE;
	}
	if (_tmp126_) {
		gchar* summary = NULL;
		gchar* _tmp129_;
		CbTweet* _tmp130_;
		CbMiniTweet* _tmp131_;
		gchar* id_suffix = NULL;
		CbTweet* _tmp146_;
		gint64 _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		gchar* _tmp151_;
		CbTweet* _tmp152_;
		Account* _tmp153_;
		NotificationManager* _tmp154_;
		const gchar* _tmp155_;
		CbTweet* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
		const gchar* _tmp159_;
		gchar* _tmp160_;
		_tmp129_ = g_strdup ("");
		summary = _tmp129_;
		_tmp130_ = t;
		_tmp131_ = _tmp130_->retweeted_tweet;
		if (_tmp131_ != NULL) {
			CbTweet* _tmp132_;
			CbMiniTweet _tmp133_;
			CbUserIdentity _tmp134_;
			const gchar* _tmp135_;
			CbTweet* _tmp136_;
			CbMiniTweet* _tmp137_;
			CbUserIdentity _tmp138_;
			const gchar* _tmp139_;
			gchar* _tmp140_;
			_tmp132_ = t;
			_tmp133_ = _tmp132_->source_tweet;
			_tmp134_ = _tmp133_.author;
			_tmp135_ = _tmp134_.user_name;
			_tmp136_ = t;
			_tmp137_ = _tmp136_->retweeted_tweet;
			_tmp138_ = (*_tmp137_).author;
			_tmp139_ = _tmp138_.user_name;
			_tmp140_ = g_strdup_printf (_ ("%s retweeted %s"), _tmp135_, _tmp139_);
			_g_free0 (summary);
			summary = _tmp140_;
		} else {
			CbTweet* _tmp141_;
			CbMiniTweet _tmp142_;
			CbUserIdentity _tmp143_;
			const gchar* _tmp144_;
			gchar* _tmp145_;
			_tmp141_ = t;
			_tmp142_ = _tmp141_->source_tweet;
			_tmp143_ = _tmp142_.author;
			_tmp144_ = _tmp143_.user_name;
			_tmp145_ = g_strdup_printf (_ ("%s tweeted"), _tmp144_);
			_g_free0 (summary);
			summary = _tmp145_;
		}
		_tmp146_ = t;
		_tmp147_ = _tmp146_->id;
		_tmp148_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = g_strdup_printf ("tweet-%s", _tmp149_);
		_tmp151_ = _tmp150_;
		_g_free0 (_tmp149_);
		id_suffix = _tmp151_;
		_tmp152_ = t;
		_tmp153_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp154_ = _tmp153_->notifications;
		_tmp155_ = summary;
		_tmp156_ = t;
		_tmp157_ = cb_tweet_get_real_text (_tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = id_suffix;
		_tmp160_ = notification_manager_send (_tmp154_, _tmp155_, _tmp158_, _tmp159_);
		_g_free0 (_tmp152_->notification_id);
		_tmp152_->notification_id = _tmp160_;
		_g_free0 (_tmp158_);
		_g_free0 (id_suffix);
		_g_free0 (summary);
	} else {
		gboolean _tmp161_ = FALSE;
		gboolean _tmp162_ = FALSE;
		gint _tmp163_;
		_tmp163_ = stack_size;
		if (_tmp163_ != 0) {
			gint _tmp164_;
			gint _tmp165_;
			gint _tmp166_;
			_tmp164_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp165_ = _tmp164_;
			_tmp166_ = stack_size;
			_tmp162_ = (_tmp165_ % _tmp166_) == 0;
		} else {
			_tmp162_ = FALSE;
		}
		if (_tmp162_) {
			gint _tmp167_;
			gint _tmp168_;
			_tmp167_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp168_ = _tmp167_;
			_tmp161_ = _tmp168_ > 0;
		} else {
			_tmp161_ = FALSE;
		}
		if (_tmp161_) {
			gchar* summary = NULL;
			gint _tmp169_;
			gint _tmp170_;
			gint _tmp171_;
			gint _tmp172_;
			gchar* _tmp173_;
			Account* _tmp174_;
			NotificationManager* _tmp175_;
			const gchar* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			_tmp169_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp170_ = _tmp169_;
			_tmp171_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp172_ = _tmp171_;
			_tmp173_ = g_strdup_printf (ngettext ("%d new Tweet!", "%d new Tweets!", (gulong) _tmp170_), _tmp172_);
			summary = _tmp173_;
			_tmp174_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp175_ = _tmp174_->notifications;
			_tmp176_ = summary;
			_tmp177_ = notification_manager_send (_tmp175_, _tmp176_, "", NULL);
			_tmp178_ = _tmp177_;
			_g_free0 (_tmp178_);
			_g_free0 (summary);
		}
	}
	_g_object_unref0 (t);
	_g_date_time_unref0 (now);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	CbTweetModel* tm = NULL;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	CbTweetModel* _tmp2_;
	gint64 _tmp3_;
	CbTweetState _tmp4_;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CB_TYPE_TWEET_MODEL, CbTweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	cb_tweet_model_toggle_flag_on_user_tweets (tm, _tmp3_, _tmp4_, TRUE);
	_g_object_unref0 (tm);
}


void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	CbTweetModel* tm = NULL;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	CbTweetModel* _tmp2_;
	gint64 _tmp3_;
	CbTweetState _tmp4_;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CB_TYPE_TWEET_MODEL, CbTweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	cb_tweet_model_toggle_flag_on_user_tweets (tm, _tmp3_, _tmp4_, FALSE);
	_g_object_unref0 (tm);
}


void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	CbTweetModel* tm = NULL;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	CbTweetModel* _tmp2_;
	gint64 _tmp3_;
	CbTweetState _tmp4_;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CB_TYPE_TWEET_MODEL, CbTweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	cb_tweet_model_toggle_flag_on_user_retweets (tm, _tmp3_, _tmp4_, TRUE);
	_g_object_unref0 (tm);
}


void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	CbTweetModel* tm = NULL;
	TweetListBox* _tmp0_;
	CbTweetModel* _tmp1_;
	CbTweetModel* _tmp2_;
	gint64 _tmp3_;
	CbTweetState _tmp4_;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CB_TYPE_TWEET_MODEL, CbTweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	cb_tweet_model_toggle_flag_on_user_retweets (tm, _tmp3_, _tmp4_, FALSE);
	_g_object_unref0 (tm);
}


static gchar* home_timeline_real_get_title (DefaultTimeline* base) {
	HomeTimeline * self;
	gchar* result = NULL;
	Account* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp1_ = _tmp0_->screen_name;
	_tmp2_ = g_strconcat ("@", _tmp1_, NULL);
	result = _tmp2_;
	return result;
}


static void home_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group) {
	HomeTimeline * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "corebird-user-home-symbolic", _ ("Home"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button = _tmp1_;
}


static const gchar* home_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	HomeTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	result = "1.1/statuses/home_timeline.json";
	return result;
}


static void home_timeline_class_init (HomeTimelineClass * klass) {
	home_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->get_title = (gchar* (*) (DefaultTimeline *)) home_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->create_radio_button = (void (*) (DefaultTimeline *, GtkRadioButton*)) home_timeline_real_create_radio_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = home_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_home_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HOME_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void home_timeline_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	home_timeline_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) home_timeline_real_stream_message_received;
}


static void home_timeline_instance_init (HomeTimeline * self) {
}


GType home_timeline_get_type (void) {
	static volatile gsize home_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&home_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HomeTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) home_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HomeTimeline), 0, (GInstanceInitFunc) home_timeline_instance_init, NULL };
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) home_timeline_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType home_timeline_type_id;
		home_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "HomeTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (home_timeline_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&home_timeline_type_id__volatile, home_timeline_type_id);
	}
	return home_timeline_type_id__volatile;
}


static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HOME_TIMELINE, HomeTimeline);
	switch (property_id) {
		case HOME_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



