/* UserListDialog.c generated by valac 0.36.4, the Vala compiler
 * generated from UserListDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "rest/rest-proxy-call.h"
#include "CbBundle.h"
#include <gio/gio.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <json-glib/json-glib.h>
#include <pango/pango.h>


#define TYPE_TWITTER_LIST (twitter_list_get_type ())
typedef struct _TwitterList TwitterList;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_LIST_DIALOG (user_list_dialog_get_type ())
#define USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_DIALOG, UserListDialog))
#define USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_DIALOG, UserListDialogClass))
#define IS_USER_LIST_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_DIALOG))
#define IS_USER_LIST_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_DIALOG))
#define USER_LIST_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_DIALOG, UserListDialogClass))

typedef struct _UserListDialog UserListDialog;
typedef struct _UserListDialogClass UserListDialogClass;
typedef struct _UserListDialogPrivate UserListDialogPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LIST_USER_ENTRY (list_user_entry_get_type ())
#define LIST_USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_USER_ENTRY, ListUserEntry))
#define LIST_USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_USER_ENTRY, ListUserEntryClass))
#define IS_LIST_USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_USER_ENTRY))
#define IS_LIST_USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_USER_ENTRY))
#define LIST_USER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_USER_ENTRY, ListUserEntryClass))

typedef struct _ListUserEntry ListUserEntry;
typedef struct _ListUserEntryClass ListUserEntryClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_LISTS_PAGE (lists_page_get_type ())
#define LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISTS_PAGE, ListsPage))
#define LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISTS_PAGE, ListsPageClass))
#define IS_LISTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISTS_PAGE))
#define IS_LISTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISTS_PAGE))
#define LISTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISTS_PAGE, ListsPageClass))

typedef struct _ListsPage ListsPage;
typedef struct _ListsPageClass ListsPageClass;
typedef struct _Block69Data Block69Data;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_PAGE (page_get_type ())
typedef struct _ListUserEntryPrivate ListUserEntryPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block70Data Block70Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block71Data Block71Data;
typedef struct _Block72Data Block72Data;

struct _TwitterList {
	gint64 id;
	gchar* name;
	gchar* description;
	gchar* mode;
	guint n_members;
};

struct _UserListDialog {
	GtkDialog parent_instance;
	UserListDialogPrivate * priv;
};

struct _UserListDialogClass {
	GtkDialogClass parent_class;
};

struct _UserListDialogPrivate {
	Account* account;
	MainWindow* main_window;
	GtkListBox* list_list_box;
	GtkLabel* placeholder_label;
	gint64 user_id;
};

struct _Block69Data {
	int _ref_count_;
	UserListDialog* self;
	ListsPage* lists_page;
	RestProxyCall* call;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _ListUserEntry {
	GtkListBoxRow parent_instance;
	ListUserEntryPrivate * priv;
	gint64 id;
	gboolean changed;
};

struct _ListUserEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block70Data {
	int _ref_count_;
	UserListDialog* self;
	gint64 id;
};

struct _Block71Data {
	int _ref_count_;
	UserListDialog* self;
	RestProxyCall* call;
};

struct _Block72Data {
	int _ref_count_;
	UserListDialog* self;
	RestProxyCall* call;
};

struct _ListUserEntryPrivate {
	GtkCheckButton* added_checkbox;
};


static gpointer user_list_dialog_parent_class = NULL;
static gpointer list_user_entry_parent_class = NULL;

GType twitter_list_get_type (void) G_GNUC_CONST;
TwitterList* twitter_list_dup (const TwitterList* self);
void twitter_list_free (TwitterList* self);
void twitter_list_copy (const TwitterList* self, TwitterList* dest);
void twitter_list_destroy (TwitterList* self);
GType user_list_dialog_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define USER_LIST_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_LIST_DIALOG, UserListDialogPrivate))
enum  {
	USER_LIST_DIALOG_DUMMY_PROPERTY
};
UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id);
UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static void __lambda113_ (UserListDialog* self, GtkListBoxRow* row);
GType list_user_entry_get_type (void) G_GNUC_CONST;
void list_user_entry_toggle (ListUserEntry* self);
static void ___lambda113__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
void user_list_dialog_load_lists (UserListDialog* self);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType lists_page_get_type (void) G_GNUC_CONST;
static Block69Data* block69_data_ref (Block69Data* _data69_);
static void block69_data_unref (void * _userdata_);
GType ipage_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType page_get_type (void) G_GNUC_CONST;
void lists_page_get_user_lists (ListsPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
TwitterList* lists_page_get_user_lists_finish (ListsPage* self, GAsyncResult* _res_, int* result_length1);
static void __lambda115_ (Block69Data* _data69_, GObject* obj, GAsyncResult* res);
ListUserEntry* list_user_entry_new (const gchar* list_name, const gchar* description);
ListUserEntry* list_user_entry_construct (GType object_type, const gchar* list_name, const gchar* description);
void list_user_entry_disable (ListUserEntry* self);
static void _vala_TwitterList_array_free (TwitterList * array, gint array_length);
static void ___lambda115__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda116_ (Block69Data* _data69_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void __lambda117_ (UserListDialog* self, JsonArray* arr, guint index, JsonNode* node);
static Block70Data* block70_data_ref (Block70Data* _data70_);
static void block70_data_unref (void * _userdata_);
static void __lambda118_ (Block70Data* _data70_, GtkWidget* w);
void list_user_entry_check (ListUserEntry* self);
void list_user_entry_enable (ListUserEntry* self);
static void ___lambda118__gtk_callback (GtkWidget* widget, gpointer self);
static void ___lambda117__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda116__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void user_list_dialog_real_response (GtkDialog* base, gint response_id);
gboolean list_user_entry_get_active (ListUserEntry* self);
static void user_list_dialog_add_user (UserListDialog* self, gint64 list_id);
static void user_list_dialog_remove_user (UserListDialog* self, gint64 list_id);
static Block71Data* block71_data_ref (Block71Data* _data71_);
static void block71_data_unref (void * _userdata_);
static void __lambda119_ (Block71Data* _data71_, GObject* o, GAsyncResult* res);
static void ___lambda119__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block72Data* block72_data_ref (Block72Data* _data72_);
static void block72_data_unref (void * _userdata_);
static void __lambda120_ (Block72Data* _data72_, GObject* o, GAsyncResult* res);
static void ___lambda120__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void user_list_dialog_finalize (GObject * obj);
#define LIST_USER_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIST_USER_ENTRY, ListUserEntryPrivate))
enum  {
	LIST_USER_ENTRY_DUMMY_PROPERTY,
	LIST_USER_ENTRY_ACTIVE
};
static void __lambda114_ (ListUserEntry* self);
static void ___lambda114__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void list_user_entry_finalize (GObject * obj);
static void _vala_list_user_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


void twitter_list_copy (const TwitterList* self, TwitterList* dest) {
	gint64 _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	guint _tmp7_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
	_tmp3_ = (*self).description;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp4_;
	_tmp5_ = (*self).mode;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).mode);
	(*dest).mode = _tmp6_;
	_tmp7_ = (*self).n_members;
	(*dest).n_members = _tmp7_;
}


void twitter_list_destroy (TwitterList* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mode);
}


TwitterList* twitter_list_dup (const TwitterList* self) {
	TwitterList* dup;
	dup = g_new0 (TwitterList, 1);
	twitter_list_copy (self, dup);
	return dup;
}


void twitter_list_free (TwitterList* self) {
	twitter_list_destroy (self);
	g_free (self);
}


GType twitter_list_get_type (void) {
	static volatile gsize twitter_list_type_id__volatile = 0;
	if (g_once_init_enter (&twitter_list_type_id__volatile)) {
		GType twitter_list_type_id;
		twitter_list_type_id = g_boxed_type_register_static ("TwitterList", (GBoxedCopyFunc) twitter_list_dup, (GBoxedFreeFunc) twitter_list_free);
		g_once_init_leave (&twitter_list_type_id__volatile, twitter_list_type_id);
	}
	return twitter_list_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void __lambda113_ (UserListDialog* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_USER_ENTRY)) {
		g_warning ("UserListDialog.vala:60: Row != ListUserEntry!");
		return;
	}
	_tmp1_ = row;
	list_user_entry_toggle (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_USER_ENTRY, ListUserEntry));
}


static void ___lambda113__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda113_ ((UserListDialog*) self, row);
}


UserListDialog* user_list_dialog_construct (GType object_type, MainWindow* parent, Account* account, gint64 user_id) {
	UserListDialog * self = NULL;
	gint _tmp0_ = 0;
	GtkSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	MainWindow* _tmp4_;
	gint64 _tmp5_;
	Account* _tmp6_;
	MainWindow* _tmp7_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkLabel* _tmp18_;
	GtkListBox* _tmp19_;
	GtkLabel* _tmp20_;
	g_return_val_if_fail (IS_MAIN_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp1_ = gtk_settings_get_default ();
	g_object_get (_tmp1_, "gtk-dialogs-use-header", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	self = (UserListDialog*) g_object_new (object_type, "use-header-bar", _tmp0_, NULL);
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _ ("Add to or Remove User From List"));
	_tmp4_ = parent;
	self->priv->main_window = _tmp4_;
	_tmp5_ = user_id;
	self->priv->user_id = _tmp5_;
	_tmp6_ = account;
	self->priv->account = _tmp6_;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp7_ = parent;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 250, 200);
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), _ ("Save"), (gint) GTK_RESPONSE_OK);
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
	_tmp8_ = (GtkBox*) gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp9_ = _g_object_ref0 (_tmp8_);
	content_box = _tmp9_;
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (content_box, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp10_);
	scroller = _tmp10_;
	_tmp11_ = self->priv->list_list_box;
	gtk_list_box_set_selection_mode (_tmp11_, GTK_SELECTION_NONE);
	_tmp12_ = self->priv->list_list_box;
	gtk_list_box_set_header_func (_tmp12_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp13_ = self->priv->list_list_box;
	g_signal_connect_object (_tmp13_, "row-activated", (GCallback) ___lambda113__gtk_list_box_row_activated, self, 0);
	_tmp14_ = self->priv->list_list_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	gtk_box_pack_start (content_box, G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("You have no lists."));
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->placeholder_label);
	self->priv->placeholder_label = _tmp15_;
	_tmp16_ = self->priv->placeholder_label;
	_tmp17_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp17_, "dim-label");
	_tmp18_ = self->priv->placeholder_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	_tmp19_ = self->priv->list_list_box;
	_tmp20_ = self->priv->placeholder_label;
	gtk_list_box_set_placeholder (_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 400, 200);
	_g_object_unref0 (scroller);
	_g_object_unref0 (content_box);
	return self;
}


UserListDialog* user_list_dialog_new (MainWindow* parent, Account* account, gint64 user_id) {
	return user_list_dialog_construct (TYPE_USER_LIST_DIALOG, parent, account, user_id);
}


static Block69Data* block69_data_ref (Block69Data* _data69_) {
	g_atomic_int_inc (&_data69_->_ref_count_);
	return _data69_;
}


static void block69_data_unref (void * _userdata_) {
	Block69Data* _data69_;
	_data69_ = (Block69Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data69_->_ref_count_)) {
		UserListDialog* self;
		self = _data69_->self;
		_g_object_unref0 (_data69_->call);
		_g_object_unref0 (_data69_->lists_page);
		_g_object_unref0 (self);
		g_slice_free (Block69Data, _data69_);
	}
}


static void _vala_TwitterList_array_free (TwitterList * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			twitter_list_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void __lambda115_ (Block69Data* _data69_, GObject* obj, GAsyncResult* res) {
	UserListDialog* self;
	TwitterList* lists = NULL;
	GAsyncResult* _tmp0_;
	gint _tmp1_;
	TwitterList* _tmp2_;
	gint lists_length1;
	gint _lists_size_;
	TwitterList* _tmp3_;
	gint _tmp3__length1;
	self = _data69_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp2_ = lists_page_get_user_lists_finish (_data69_->lists_page, _tmp0_, &_tmp1_);
	lists = _tmp2_;
	lists_length1 = _tmp1_;
	_lists_size_ = lists_length1;
	_tmp3_ = lists;
	_tmp3__length1 = lists_length1;
	{
		TwitterList* list_collection = NULL;
		gint list_collection_length1 = 0;
		gint _list_collection_size_ = 0;
		gint list_it = 0;
		list_collection = _tmp3_;
		list_collection_length1 = _tmp3__length1;
		for (list_it = 0; list_it < _tmp3__length1; list_it = list_it + 1) {
			TwitterList list = {0};
			list = list_collection[list_it];
			{
				ListUserEntry* l = NULL;
				TwitterList _tmp4_;
				const gchar* _tmp5_;
				TwitterList _tmp6_;
				const gchar* _tmp7_;
				ListUserEntry* _tmp8_;
				ListUserEntry* _tmp9_;
				TwitterList _tmp10_;
				gint64 _tmp11_;
				TwitterList _tmp12_;
				guint _tmp13_;
				GtkListBox* _tmp15_;
				ListUserEntry* _tmp16_;
				_tmp4_ = list;
				_tmp5_ = _tmp4_.name;
				_tmp6_ = list;
				_tmp7_ = _tmp6_.description;
				_tmp8_ = list_user_entry_new (_tmp5_, _tmp7_);
				g_object_ref_sink (_tmp8_);
				l = _tmp8_;
				_tmp9_ = l;
				_tmp10_ = list;
				_tmp11_ = _tmp10_.id;
				_tmp9_->id = _tmp11_;
				_tmp12_ = list;
				_tmp13_ = _tmp12_.n_members;
				if (_tmp13_ >= ((guint) 500)) {
					ListUserEntry* _tmp14_;
					_tmp14_ = l;
					list_user_entry_disable (_tmp14_);
				}
				_tmp15_ = self->priv->list_list_box;
				_tmp16_ = l;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (l);
			}
		}
	}
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	lists = (_vala_TwitterList_array_free (lists, lists_length1), NULL);
}


static void ___lambda115__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda115_ (self, source_object, res);
	block69_data_unref (self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static Block70Data* block70_data_ref (Block70Data* _data70_) {
	g_atomic_int_inc (&_data70_->_ref_count_);
	return _data70_;
}


static void block70_data_unref (void * _userdata_) {
	Block70Data* _data70_;
	_data70_ = (Block70Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data70_->_ref_count_)) {
		UserListDialog* self;
		self = _data70_->self;
		_g_object_unref0 (self);
		g_slice_free (Block70Data, _data70_);
	}
}


static void __lambda118_ (Block70Data* _data70_, GtkWidget* w) {
	UserListDialog* self;
	ListUserEntry* lue = NULL;
	GtkWidget* _tmp0_;
	ListUserEntry* _tmp1_;
	ListUserEntry* _tmp2_;
	gint64 _tmp3_;
	self = _data70_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIST_USER_ENTRY, ListUserEntry));
	lue = _tmp1_;
	_tmp2_ = lue;
	_tmp3_ = _tmp2_->id;
	if (_tmp3_ == _data70_->id) {
		ListUserEntry* _tmp4_;
		ListUserEntry* _tmp5_;
		_tmp4_ = lue;
		list_user_entry_check (_tmp4_);
		_tmp5_ = lue;
		list_user_entry_enable (_tmp5_);
	}
	_g_object_unref0 (lue);
}


static void ___lambda118__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda118_ (self, widget);
}


static void __lambda117_ (UserListDialog* self, JsonArray* arr, guint index, JsonNode* node) {
	Block70Data* _data70_;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	gint64 _tmp2_;
	GtkListBox* _tmp3_;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_data70_ = g_slice_new0 (Block70Data);
	_data70_->_ref_count_ = 1;
	_data70_->self = g_object_ref (self);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = json_object_get_int_member (_tmp1_, "id");
	_data70_->id = _tmp2_;
	_tmp3_ = self->priv->list_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), ___lambda118__gtk_callback, _data70_);
	block70_data_unref (_data70_);
	_data70_ = NULL;
}


static void ___lambda117__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda117_ ((UserListDialog*) self, array, index_, element_node);
}


static void __lambda116_ (Block69Data* _data69_, GObject* o, GAsyncResult* res) {
	UserListDialog* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_;
	JsonObject* root = NULL;
	JsonParser* _tmp9_;
	JsonNode* _tmp10_;
	JsonObject* _tmp11_;
	JsonObject* _tmp12_;
	JsonArray* list_arr = NULL;
	JsonObject* _tmp13_;
	JsonArray* _tmp14_;
	JsonArray* _tmp15_;
	JsonArray* _tmp16_;
	GError * _inner_error_ = NULL;
	self = _data69_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data69_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch89_g_error;
		}
	}
	goto __finally89;
	__catch89_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data69_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 99, "UserListDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
		return;
	}
	__finally89:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		JsonParser* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = parser;
		_tmp6_ = rest_proxy_call_get_payload (_data69_->call);
		json_parser_load_from_data (_tmp5_, _tmp6_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch90_g_error;
		}
	}
	goto __finally90;
	__catch90_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("UserListDialog.vala:106: %s", _tmp8_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally90:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = parser;
	_tmp10_ = json_parser_get_root (_tmp9_);
	_tmp11_ = json_node_get_object (_tmp10_);
	_tmp12_ = _json_object_ref0 (_tmp11_);
	root = _tmp12_;
	_tmp13_ = root;
	_tmp14_ = json_object_get_array_member (_tmp13_, "lists");
	_tmp15_ = _json_array_ref0 (_tmp14_);
	list_arr = _tmp15_;
	_tmp16_ = list_arr;
	json_array_foreach_element (_tmp16_, ___lambda117__json_array_foreach, self);
	_json_array_unref0 (list_arr);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
}


static void ___lambda116__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda116_ (self, source_object, res);
	block69_data_unref (self);
}


void user_list_dialog_load_lists (UserListDialog* self) {
	Block69Data* _data69_;
	MainWindow* _tmp0_;
	IPage* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (IS_USER_LIST_DIALOG (self));
	_data69_ = g_slice_new0 (Block69Data);
	_data69_->_ref_count_ = 1;
	_data69_->self = g_object_ref (self);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = main_window_get_page (_tmp0_, (gint) PAGE_LISTS);
	_data69_->lists_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LISTS_PAGE, ListsPage);
	lists_page_get_user_lists (_data69_->lists_page, ___lambda115__gasync_ready_callback, block69_data_ref (_data69_));
	_tmp2_ = self->priv->account;
	_tmp3_ = _tmp2_->proxy;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data69_->call = _tmp4_;
	rest_proxy_call_set_function (_data69_->call, "1.1/lists/memberships.json");
	_tmp5_ = self->priv->user_id;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	rest_proxy_call_add_param (_data69_->call, "user_id", _tmp7_);
	_g_free0 (_tmp7_);
	rest_proxy_call_add_param (_data69_->call, "filter_to_owned_lists", "true");
	rest_proxy_call_invoke_async (_data69_->call, NULL, ___lambda116__gasync_ready_callback, block69_data_ref (_data69_));
	block69_data_unref (_data69_);
	_data69_ = NULL;
}


static void user_list_dialog_real_response (GtkDialog* base, gint response_id) {
	UserListDialog * self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_LIST_DIALOG, UserListDialog);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CANCEL)) {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	} else {
		gint _tmp1_;
		_tmp1_ = response_id;
		if (_tmp1_ == ((gint) GTK_RESPONSE_OK)) {
			GList* list_entries = NULL;
			GtkListBox* _tmp2_;
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp2_ = self->priv->list_list_box;
			_tmp3_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
			list_entries = _tmp3_;
			_tmp4_ = list_entries;
			{
				GList* w_collection = NULL;
				GList* w_it = NULL;
				w_collection = _tmp4_;
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					GtkWidget* _tmp5_;
					GtkWidget* w = NULL;
					_tmp5_ = _g_object_ref0 ((GtkWidget*) w_it->data);
					w = _tmp5_;
					{
						ListUserEntry* lue = NULL;
						GtkWidget* _tmp6_;
						ListUserEntry* _tmp7_;
						ListUserEntry* _tmp8_;
						gboolean _tmp9_;
						_tmp6_ = w;
						_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_LIST_USER_ENTRY, ListUserEntry));
						lue = _tmp7_;
						_tmp8_ = lue;
						_tmp9_ = _tmp8_->changed;
						if (_tmp9_) {
							ListUserEntry* _tmp10_;
							gboolean _tmp11_;
							gboolean _tmp12_;
							g_debug ("UserListDialog.vala:133: VALUE CHANGED");
							_tmp10_ = lue;
							_tmp11_ = list_user_entry_get_active (_tmp10_);
							_tmp12_ = _tmp11_;
							if (_tmp12_) {
								ListUserEntry* _tmp13_;
								gint64 _tmp14_;
								_tmp13_ = lue;
								_tmp14_ = _tmp13_->id;
								user_list_dialog_add_user (self, _tmp14_);
							} else {
								ListUserEntry* _tmp15_;
								gint64 _tmp16_;
								_tmp15_ = lue;
								_tmp16_ = _tmp15_->id;
								user_list_dialog_remove_user (self, _tmp16_);
							}
						}
						_g_object_unref0 (lue);
						_g_object_unref0 (w);
					}
				}
			}
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			_g_list_free0 (list_entries);
		}
	}
}


static Block71Data* block71_data_ref (Block71Data* _data71_) {
	g_atomic_int_inc (&_data71_->_ref_count_);
	return _data71_;
}


static void block71_data_unref (void * _userdata_) {
	Block71Data* _data71_;
	_data71_ = (Block71Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data71_->_ref_count_)) {
		UserListDialog* self;
		self = _data71_->self;
		_g_object_unref0 (_data71_->call);
		_g_object_unref0 (self);
		g_slice_free (Block71Data, _data71_);
	}
}


static void __lambda119_ (Block71Data* _data71_, GObject* o, GAsyncResult* res) {
	UserListDialog* self;
	GError * _inner_error_ = NULL;
	self = _data71_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data71_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch91_g_error;
		}
	}
	goto __finally91;
	__catch91_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data71_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 158, "UserListDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally91:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda119__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda119_ (self, source_object, res);
	block71_data_unref (self);
}


static void user_list_dialog_add_user (UserListDialog* self, gint64 list_id) {
	Block71Data* _data71_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (IS_USER_LIST_DIALOG (self));
	_data71_ = g_slice_new0 (Block71Data);
	_data71_->_ref_count_ = 1;
	_data71_->self = g_object_ref (self);
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data71_->call = _tmp2_;
	rest_proxy_call_set_function (_data71_->call, "1.1/lists/members/create.json");
	rest_proxy_call_set_method (_data71_->call, "POST");
	_tmp3_ = list_id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data71_->call, "list_id", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->user_id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	rest_proxy_call_add_param (_data71_->call, "user_id", _tmp8_);
	_g_free0 (_tmp8_);
	rest_proxy_call_invoke_async (_data71_->call, NULL, ___lambda119__gasync_ready_callback, block71_data_ref (_data71_));
	block71_data_unref (_data71_);
	_data71_ = NULL;
}


static Block72Data* block72_data_ref (Block72Data* _data72_) {
	g_atomic_int_inc (&_data72_->_ref_count_);
	return _data72_;
}


static void block72_data_unref (void * _userdata_) {
	Block72Data* _data72_;
	_data72_ = (Block72Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data72_->_ref_count_)) {
		UserListDialog* self;
		self = _data72_->self;
		_g_object_unref0 (_data72_->call);
		_g_object_unref0 (self);
		g_slice_free (Block72Data, _data72_);
	}
}


static void __lambda120_ (Block72Data* _data72_, GObject* o, GAsyncResult* res) {
	UserListDialog* self;
	GError * _inner_error_ = NULL;
	self = _data72_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data72_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch92_g_error;
		}
	}
	goto __finally92;
	__catch92_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data72_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 174, "UserListDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally92:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda120__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda120_ (self, source_object, res);
	block72_data_unref (self);
}


static void user_list_dialog_remove_user (UserListDialog* self, gint64 list_id) {
	Block72Data* _data72_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (IS_USER_LIST_DIALOG (self));
	_data72_ = g_slice_new0 (Block72Data);
	_data72_->_ref_count_ = 1;
	_data72_->self = g_object_ref (self);
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data72_->call = _tmp2_;
	rest_proxy_call_set_function (_data72_->call, "1.1/lists/members/destroy.json");
	rest_proxy_call_set_method (_data72_->call, "POST");
	_tmp3_ = list_id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data72_->call, "list_id", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->user_id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	rest_proxy_call_add_param (_data72_->call, "user_id", _tmp8_);
	_g_free0 (_tmp8_);
	rest_proxy_call_invoke_async (_data72_->call, NULL, ___lambda120__gasync_ready_callback, block72_data_ref (_data72_));
	block72_data_unref (_data72_);
	_data72_ = NULL;
}


static void user_list_dialog_class_init (UserListDialogClass * klass) {
	user_list_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserListDialogPrivate));
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog *, gint)) user_list_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = user_list_dialog_finalize;
}


static void user_list_dialog_instance_init (UserListDialog * self) {
	GtkListBox* _tmp0_;
	self->priv = USER_LIST_DIALOG_GET_PRIVATE (self);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->list_list_box = _tmp0_;
}


static void user_list_dialog_finalize (GObject * obj) {
	UserListDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LIST_DIALOG, UserListDialog);
	_g_object_unref0 (self->priv->list_list_box);
	_g_object_unref0 (self->priv->placeholder_label);
	G_OBJECT_CLASS (user_list_dialog_parent_class)->finalize (obj);
}


GType user_list_dialog_get_type (void) {
	static volatile gsize user_list_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&user_list_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserListDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_list_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserListDialog), 0, (GInstanceInitFunc) user_list_dialog_instance_init, NULL };
		GType user_list_dialog_type_id;
		user_list_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "UserListDialog", &g_define_type_info, 0);
		g_once_init_leave (&user_list_dialog_type_id__volatile, user_list_dialog_type_id);
	}
	return user_list_dialog_type_id__volatile;
}


static void __lambda114_ (ListUserEntry* self) {
	gboolean _tmp0_;
	_tmp0_ = self->changed;
	self->changed = !_tmp0_;
}


static void ___lambda114__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda114_ ((ListUserEntry*) self);
}


ListUserEntry* list_user_entry_construct (GType object_type, const gchar* list_name, const gchar* description) {
	ListUserEntry * self = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkCheckButton* _tmp1_;
	GtkCheckButton* _tmp2_;
	GtkCheckButton* _tmp3_;
	GtkBox* box2 = NULL;
	GtkBox* _tmp4_;
	GtkLabel* label = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* desc_label = NULL;
	const gchar* _tmp12_;
	GtkLabel* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkCheckButton* _tmp15_;
	g_return_val_if_fail (list_name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (ListUserEntry*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget), "margin", 6, NULL);
	_tmp1_ = self->priv->added_checkbox;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp2_ = self->priv->added_checkbox;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp3_ = self->priv->added_checkbox;
	gtk_box_pack_start (box, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp4_);
	box2 = _tmp4_;
	_tmp5_ = list_name;
	_tmp6_ = g_strconcat ("<b>", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "</b>", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	label = _tmp11_;
	gtk_label_set_use_markup (label, TRUE);
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (label, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	gtk_box_pack_start (box2, G_TYPE_CHECK_INSTANCE_CAST (label, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp12_ = description;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	desc_label = _tmp13_;
	_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (desc_label, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp14_, "dim-label");
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (desc_label, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	gtk_label_set_ellipsize (desc_label, PANGO_ELLIPSIZE_END);
	gtk_box_pack_start (box2, G_TYPE_CHECK_INSTANCE_CAST (desc_label, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	gtk_box_pack_start (box, G_TYPE_CHECK_INSTANCE_CAST (box2, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->added_checkbox;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) ___lambda114__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (desc_label);
	_g_object_unref0 (label);
	_g_object_unref0 (box2);
	_g_object_unref0 (box);
	return self;
}


ListUserEntry* list_user_entry_new (const gchar* list_name, const gchar* description) {
	return list_user_entry_construct (TYPE_LIST_USER_ENTRY, list_name, description);
}


void list_user_entry_check (ListUserEntry* self) {
	GtkCheckButton* _tmp0_;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	self->changed = FALSE;
}


void list_user_entry_toggle (ListUserEntry* self) {
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	_tmp1_ = self->priv->added_checkbox;
	_tmp2_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), !_tmp3_);
}


void list_user_entry_disable (ListUserEntry* self) {
	GtkCheckButton* _tmp0_;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
}


void list_user_entry_enable (ListUserEntry* self) {
	GtkCheckButton* _tmp0_;
	g_return_if_fail (IS_LIST_USER_ENTRY (self));
	_tmp0_ = self->priv->added_checkbox;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


gboolean list_user_entry_get_active (ListUserEntry* self) {
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (IS_LIST_USER_ENTRY (self), FALSE);
	_tmp0_ = self->priv->added_checkbox;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void list_user_entry_class_init (ListUserEntryClass * klass) {
	list_user_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListUserEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_list_user_entry_get_property;
	G_OBJECT_CLASS (klass)->finalize = list_user_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_USER_ENTRY_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void list_user_entry_instance_init (ListUserEntry * self) {
	GtkCheckButton* _tmp0_;
	self->priv = LIST_USER_ENTRY_GET_PRIVATE (self);
	self->changed = FALSE;
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->added_checkbox = _tmp0_;
}


static void list_user_entry_finalize (GObject * obj) {
	ListUserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_USER_ENTRY, ListUserEntry);
	_g_object_unref0 (self->priv->added_checkbox);
	G_OBJECT_CLASS (list_user_entry_parent_class)->finalize (obj);
}


GType list_user_entry_get_type (void) {
	static volatile gsize list_user_entry_type_id__volatile = 0;
	if (g_once_init_enter (&list_user_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListUserEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_user_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListUserEntry), 0, (GInstanceInitFunc) list_user_entry_instance_init, NULL };
		GType list_user_entry_type_id;
		list_user_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ListUserEntry", &g_define_type_info, 0);
		g_once_init_leave (&list_user_entry_type_id__volatile, list_user_entry_type_id);
	}
	return list_user_entry_type_id__volatile;
}


static void _vala_list_user_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListUserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_USER_ENTRY, ListUserEntry);
	switch (property_id) {
		case LIST_USER_ENTRY_ACTIVE:
		g_value_set_boolean (value, list_user_entry_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



