with Sinfo.Nodes; use Sinfo.Nodes;

package Einfo.Entities is

   --  This package is automatically generated.

   --  Type hierarchy for entities
   --
   --  Entity_Kind
   --     Void_Or_Type_Kind
   --        E_Void
   --        Type_Kind
   --           Elementary_Kind
   --              Scalar_Kind
   --                 Discrete_Kind
   --                    Enumeration_Kind
   --                       E_Enumeration_Type
   --                       E_Enumeration_Subtype
   --                    Integer_Kind
   --                       Signed_Integer_Kind
   --                          E_Signed_Integer_Type
   --                          E_Signed_Integer_Subtype
   --                       Modular_Integer_Kind
   --                          E_Modular_Integer_Type
   --                          E_Modular_Integer_Subtype
   --                 Real_Kind
   --                    Fixed_Point_Kind
   --                       Ordinary_Fixed_Point_Kind
   --                          E_Ordinary_Fixed_Point_Type
   --                          E_Ordinary_Fixed_Point_Subtype
   --                       Decimal_Fixed_Point_Kind
   --                          E_Decimal_Fixed_Point_Type
   --                          E_Decimal_Fixed_Point_Subtype
   --                    Float_Kind
   --                       E_Floating_Point_Type
   --                       E_Floating_Point_Subtype
   --              end Scalar_Kind
   --              Access_Kind
   --                 E_Access_Type
   --                 E_Access_Subtype
   --                 E_Access_Attribute_Type
   --                 E_Allocator_Type
   --                 E_General_Access_Type
   --                 Access_Subprogram_Kind
   --                    E_Access_Subprogram_Type
   --                    Access_Protected_Kind
   --                       E_Access_Protected_Subprogram_Type
   --                       E_Anonymous_Access_Protected_Subprogram_Type
   --                    E_Anonymous_Access_Subprogram_Type
   --                 E_Anonymous_Access_Type
   --           end Elementary_Kind
   --           Composite_Kind
   --              Aggregate_Kind
   --                 Array_Kind
   --                    E_Array_Type
   --                    E_Array_Subtype
   --                    E_String_Literal_Subtype
   --                 Class_Wide_Kind
   --                    E_Class_Wide_Type
   --                    E_Class_Wide_Subtype
   --                 E_Record_Type
   --                 E_Record_Subtype
   --              Incomplete_Or_Private_Kind
   --                 Private_Kind
   --                    E_Record_Type_With_Private
   --                    E_Record_Subtype_With_Private
   --                    E_Private_Type
   --                    E_Private_Subtype
   --                    E_Limited_Private_Type
   --                    E_Limited_Private_Subtype
   --                 Incomplete_Kind
   --                    E_Incomplete_Type
   --                    E_Incomplete_Subtype
   --              Concurrent_Kind
   --                 Task_Kind
   --                    E_Task_Type
   --                    E_Task_Subtype
   --                 Protected_Kind
   --                    E_Protected_Type
   --                    E_Protected_Subtype
   --           end Composite_Kind
   --           E_Exception_Type
   --           E_Subprogram_Type
   --        end Type_Kind
   --     end Void_Or_Type_Kind
   --     Exception_Or_Object_Kind
   --        Object_Kind
   --           Record_Field_Kind
   --              E_Component
   --              E_Discriminant
   --           Allocatable_Kind
   --              Constant_Or_Variable_Kind
   --                 E_Constant
   --                 E_Variable
   --              E_Loop_Parameter
   --           Formal_Kind
   --              E_Out_Parameter
   --              E_In_Out_Parameter
   --              E_In_Parameter
   --           Formal_Object_Kind
   --              E_Generic_In_Out_Parameter
   --              E_Generic_In_Parameter
   --        E_Exception
   --     end Exception_Or_Object_Kind
   --     Named_Kind
   --        E_Named_Integer
   --        E_Named_Real
   --     Overloadable_Kind
   --        E_Enumeration_Literal
   --        Subprogram_Kind
   --           E_Function
   --           E_Operator
   --           E_Procedure
   --        E_Abstract_State
   --        E_Entry
   --     E_Entry_Family
   --     E_Block
   --     E_Entry_Index_Parameter
   --     Generic_Unit_Kind
   --        Generic_Subprogram_Kind
   --           E_Generic_Function
   --           E_Generic_Procedure
   --        E_Generic_Package
   --     E_Label
   --     E_Loop
   --     E_Return_Statement
   --     E_Package
   --     E_Package_Body
   --     Concurrent_Body_Kind
   --        E_Protected_Body
   --        E_Task_Body
   --     E_Subprogram_Body
   --  end Entity_Kind
   --
   --  End type hierarchy for entities

   type Entity_Kind is -- 77 Entity_Kinds
     (E_Void,
      E_Enumeration_Type,
      E_Enumeration_Subtype,
      E_Signed_Integer_Type,
      E_Signed_Integer_Subtype,
      E_Modular_Integer_Type,
      E_Modular_Integer_Subtype,
      E_Ordinary_Fixed_Point_Type,
      E_Ordinary_Fixed_Point_Subtype,
      E_Decimal_Fixed_Point_Type,
      E_Decimal_Fixed_Point_Subtype,
      E_Floating_Point_Type,
      E_Floating_Point_Subtype,
      E_Access_Type,
      E_Access_Subtype,
      E_Access_Attribute_Type,
      E_Allocator_Type,
      E_General_Access_Type,
      E_Access_Subprogram_Type,
      E_Access_Protected_Subprogram_Type,
      E_Anonymous_Access_Protected_Subprogram_Type,
      E_Anonymous_Access_Subprogram_Type,
      E_Anonymous_Access_Type,
      E_Array_Type,
      E_Array_Subtype,
      E_String_Literal_Subtype,
      E_Class_Wide_Type,
      E_Class_Wide_Subtype,
      E_Record_Type,
      E_Record_Subtype,
      E_Record_Type_With_Private,
      E_Record_Subtype_With_Private,
      E_Private_Type,
      E_Private_Subtype,
      E_Limited_Private_Type,
      E_Limited_Private_Subtype,
      E_Incomplete_Type,
      E_Incomplete_Subtype,
      E_Task_Type,
      E_Task_Subtype,
      E_Protected_Type,
      E_Protected_Subtype,
      E_Exception_Type,
      E_Subprogram_Type,
      E_Component,
      E_Discriminant,
      E_Constant,
      E_Variable,
      E_Loop_Parameter,
      E_Out_Parameter,
      E_In_Out_Parameter,
      E_In_Parameter,
      E_Generic_In_Out_Parameter,
      E_Generic_In_Parameter,
      E_Exception,
      E_Named_Integer,
      E_Named_Real,
      E_Enumeration_Literal,
      E_Function,
      E_Operator,
      E_Procedure,
      E_Abstract_State,
      E_Entry,
      E_Entry_Family,
      E_Block,
      E_Entry_Index_Parameter,
      E_Generic_Function,
      E_Generic_Procedure,
      E_Generic_Package,
      E_Label,
      E_Loop,
      E_Return_Statement,
      E_Package,
      E_Package_Body,
      E_Protected_Body,
      E_Task_Body,
      E_Subprogram_Body
     ) with Size => 8; -- Entity_Kind

   function Ekind (N : Entity_Id) return Entity_Kind with Inline, Pre =>
      N in N_Entity_Id;
   function K (N : Entity_Id) return Entity_Kind renames Ekind;
   --  Shorthand for use in predicates and preconditions below
   --  There is no procedure Set_Ekind here.
   --  See Mutate_Ekind in Atree.

   --  Subtypes of Entity_Kind for each abstract type:

   pragma Style_Checks ("M200");
   subtype Void_Or_Type_Kind is Entity_Kind range
     E_Void .. E_Subprogram_Type;
      --  E_Void
      --  E_Enumeration_Type
      --  E_Enumeration_Subtype
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
      --  E_Floating_Point_Type
      --  E_Floating_Point_Subtype
      --  E_Access_Type
      --  E_Access_Subtype
      --  E_Access_Attribute_Type
      --  E_Allocator_Type
      --  E_General_Access_Type
      --  E_Access_Subprogram_Type
      --  E_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Subprogram_Type
      --  E_Anonymous_Access_Type
      --  E_Array_Type
      --  E_Array_Subtype
      --  E_String_Literal_Subtype
      --  E_Class_Wide_Type
      --  E_Class_Wide_Subtype
      --  E_Record_Type
      --  E_Record_Subtype
      --  E_Record_Type_With_Private
      --  E_Record_Subtype_With_Private
      --  E_Private_Type
      --  E_Private_Subtype
      --  E_Limited_Private_Type
      --  E_Limited_Private_Subtype
      --  E_Incomplete_Type
      --  E_Incomplete_Subtype
      --  E_Task_Type
      --  E_Task_Subtype
      --  E_Protected_Type
      --  E_Protected_Subtype
      --  E_Exception_Type
      --  E_Subprogram_Type
   subtype Type_Kind is Void_Or_Type_Kind range
     E_Enumeration_Type .. E_Subprogram_Type;
      --  E_Enumeration_Type
      --  E_Enumeration_Subtype
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
      --  E_Floating_Point_Type
      --  E_Floating_Point_Subtype
      --  E_Access_Type
      --  E_Access_Subtype
      --  E_Access_Attribute_Type
      --  E_Allocator_Type
      --  E_General_Access_Type
      --  E_Access_Subprogram_Type
      --  E_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Subprogram_Type
      --  E_Anonymous_Access_Type
      --  E_Array_Type
      --  E_Array_Subtype
      --  E_String_Literal_Subtype
      --  E_Class_Wide_Type
      --  E_Class_Wide_Subtype
      --  E_Record_Type
      --  E_Record_Subtype
      --  E_Record_Type_With_Private
      --  E_Record_Subtype_With_Private
      --  E_Private_Type
      --  E_Private_Subtype
      --  E_Limited_Private_Type
      --  E_Limited_Private_Subtype
      --  E_Incomplete_Type
      --  E_Incomplete_Subtype
      --  E_Task_Type
      --  E_Task_Subtype
      --  E_Protected_Type
      --  E_Protected_Subtype
      --  E_Exception_Type
      --  E_Subprogram_Type
   subtype Elementary_Kind is Type_Kind range
     E_Enumeration_Type .. E_Anonymous_Access_Type;
      --  E_Enumeration_Type
      --  E_Enumeration_Subtype
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
      --  E_Floating_Point_Type
      --  E_Floating_Point_Subtype
      --  E_Access_Type
      --  E_Access_Subtype
      --  E_Access_Attribute_Type
      --  E_Allocator_Type
      --  E_General_Access_Type
      --  E_Access_Subprogram_Type
      --  E_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Subprogram_Type
      --  E_Anonymous_Access_Type
   subtype Scalar_Kind is Elementary_Kind range
     E_Enumeration_Type .. E_Floating_Point_Subtype;
      --  E_Enumeration_Type
      --  E_Enumeration_Subtype
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
      --  E_Floating_Point_Type
      --  E_Floating_Point_Subtype
   subtype Discrete_Kind is Scalar_Kind range
     E_Enumeration_Type .. E_Modular_Integer_Subtype;
      --  E_Enumeration_Type
      --  E_Enumeration_Subtype
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
   subtype Enumeration_Kind is Discrete_Kind range
     E_Enumeration_Type .. E_Enumeration_Subtype;
      --  E_Enumeration_Type
      --  E_Enumeration_Subtype
   subtype Integer_Kind is Discrete_Kind range
     E_Signed_Integer_Type .. E_Modular_Integer_Subtype;
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
   subtype Signed_Integer_Kind is Integer_Kind range
     E_Signed_Integer_Type .. E_Signed_Integer_Subtype;
      --  E_Signed_Integer_Type
      --  E_Signed_Integer_Subtype
   subtype Modular_Integer_Kind is Integer_Kind range
     E_Modular_Integer_Type .. E_Modular_Integer_Subtype;
      --  E_Modular_Integer_Type
      --  E_Modular_Integer_Subtype
   subtype Real_Kind is Scalar_Kind range
     E_Ordinary_Fixed_Point_Type .. E_Floating_Point_Subtype;
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
      --  E_Floating_Point_Type
      --  E_Floating_Point_Subtype
   subtype Fixed_Point_Kind is Real_Kind range
     E_Ordinary_Fixed_Point_Type .. E_Decimal_Fixed_Point_Subtype;
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
   subtype Ordinary_Fixed_Point_Kind is Fixed_Point_Kind range
     E_Ordinary_Fixed_Point_Type .. E_Ordinary_Fixed_Point_Subtype;
      --  E_Ordinary_Fixed_Point_Type
      --  E_Ordinary_Fixed_Point_Subtype
   subtype Decimal_Fixed_Point_Kind is Fixed_Point_Kind range
     E_Decimal_Fixed_Point_Type .. E_Decimal_Fixed_Point_Subtype;
      --  E_Decimal_Fixed_Point_Type
      --  E_Decimal_Fixed_Point_Subtype
   subtype Float_Kind is Real_Kind range
     E_Floating_Point_Type .. E_Floating_Point_Subtype;
      --  E_Floating_Point_Type
      --  E_Floating_Point_Subtype
   subtype Access_Kind is Elementary_Kind range
     E_Access_Type .. E_Anonymous_Access_Type;
      --  E_Access_Type
      --  E_Access_Subtype
      --  E_Access_Attribute_Type
      --  E_Allocator_Type
      --  E_General_Access_Type
      --  E_Access_Subprogram_Type
      --  E_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Subprogram_Type
      --  E_Anonymous_Access_Type
   subtype Access_Subprogram_Kind is Access_Kind range
     E_Access_Subprogram_Type .. E_Anonymous_Access_Subprogram_Type;
      --  E_Access_Subprogram_Type
      --  E_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Subprogram_Type
   subtype Access_Protected_Kind is Access_Subprogram_Kind range
     E_Access_Protected_Subprogram_Type .. E_Anonymous_Access_Protected_Subprogram_Type;
      --  E_Access_Protected_Subprogram_Type
      --  E_Anonymous_Access_Protected_Subprogram_Type
   subtype Composite_Kind is Type_Kind range
     E_Array_Type .. E_Protected_Subtype;
      --  E_Array_Type
      --  E_Array_Subtype
      --  E_String_Literal_Subtype
      --  E_Class_Wide_Type
      --  E_Class_Wide_Subtype
      --  E_Record_Type
      --  E_Record_Subtype
      --  E_Record_Type_With_Private
      --  E_Record_Subtype_With_Private
      --  E_Private_Type
      --  E_Private_Subtype
      --  E_Limited_Private_Type
      --  E_Limited_Private_Subtype
      --  E_Incomplete_Type
      --  E_Incomplete_Subtype
      --  E_Task_Type
      --  E_Task_Subtype
      --  E_Protected_Type
      --  E_Protected_Subtype
   subtype Aggregate_Kind is Composite_Kind range
     E_Array_Type .. E_Record_Subtype;
      --  E_Array_Type
      --  E_Array_Subtype
      --  E_String_Literal_Subtype
      --  E_Class_Wide_Type
      --  E_Class_Wide_Subtype
      --  E_Record_Type
      --  E_Record_Subtype
   subtype Array_Kind is Aggregate_Kind range
     E_Array_Type .. E_String_Literal_Subtype;
      --  E_Array_Type
      --  E_Array_Subtype
      --  E_String_Literal_Subtype
   subtype Class_Wide_Kind is Aggregate_Kind range
     E_Class_Wide_Type .. E_Class_Wide_Subtype;
      --  E_Class_Wide_Type
      --  E_Class_Wide_Subtype
   subtype Incomplete_Or_Private_Kind is Composite_Kind range
     E_Record_Type_With_Private .. E_Incomplete_Subtype;
      --  E_Record_Type_With_Private
      --  E_Record_Subtype_With_Private
      --  E_Private_Type
      --  E_Private_Subtype
      --  E_Limited_Private_Type
      --  E_Limited_Private_Subtype
      --  E_Incomplete_Type
      --  E_Incomplete_Subtype
   subtype Private_Kind is Incomplete_Or_Private_Kind range
     E_Record_Type_With_Private .. E_Limited_Private_Subtype;
      --  E_Record_Type_With_Private
      --  E_Record_Subtype_With_Private
      --  E_Private_Type
      --  E_Private_Subtype
      --  E_Limited_Private_Type
      --  E_Limited_Private_Subtype
   subtype Incomplete_Kind is Incomplete_Or_Private_Kind range
     E_Incomplete_Type .. E_Incomplete_Subtype;
      --  E_Incomplete_Type
      --  E_Incomplete_Subtype
   subtype Concurrent_Kind is Composite_Kind range
     E_Task_Type .. E_Protected_Subtype;
      --  E_Task_Type
      --  E_Task_Subtype
      --  E_Protected_Type
      --  E_Protected_Subtype
   subtype Task_Kind is Concurrent_Kind range
     E_Task_Type .. E_Task_Subtype;
      --  E_Task_Type
      --  E_Task_Subtype
   subtype Protected_Kind is Concurrent_Kind range
     E_Protected_Type .. E_Protected_Subtype;
      --  E_Protected_Type
      --  E_Protected_Subtype
   subtype Exception_Or_Object_Kind is Entity_Kind range
     E_Component .. E_Exception;
      --  E_Component
      --  E_Discriminant
      --  E_Constant
      --  E_Variable
      --  E_Loop_Parameter
      --  E_Out_Parameter
      --  E_In_Out_Parameter
      --  E_In_Parameter
      --  E_Generic_In_Out_Parameter
      --  E_Generic_In_Parameter
      --  E_Exception
   subtype Object_Kind is Exception_Or_Object_Kind range
     E_Component .. E_Generic_In_Parameter;
      --  E_Component
      --  E_Discriminant
      --  E_Constant
      --  E_Variable
      --  E_Loop_Parameter
      --  E_Out_Parameter
      --  E_In_Out_Parameter
      --  E_In_Parameter
      --  E_Generic_In_Out_Parameter
      --  E_Generic_In_Parameter
   subtype Record_Field_Kind is Object_Kind range
     E_Component .. E_Discriminant;
      --  E_Component
      --  E_Discriminant
   subtype Allocatable_Kind is Object_Kind range
     E_Constant .. E_Loop_Parameter;
      --  E_Constant
      --  E_Variable
      --  E_Loop_Parameter
   subtype Constant_Or_Variable_Kind is Allocatable_Kind range
     E_Constant .. E_Variable;
      --  E_Constant
      --  E_Variable
   subtype Formal_Kind is Object_Kind range
     E_Out_Parameter .. E_In_Parameter;
      --  E_Out_Parameter
      --  E_In_Out_Parameter
      --  E_In_Parameter
   subtype Formal_Object_Kind is Object_Kind range
     E_Generic_In_Out_Parameter .. E_Generic_In_Parameter;
      --  E_Generic_In_Out_Parameter
      --  E_Generic_In_Parameter
   subtype Named_Kind is Entity_Kind range
     E_Named_Integer .. E_Named_Real;
      --  E_Named_Integer
      --  E_Named_Real
   subtype Overloadable_Kind is Entity_Kind range
     E_Enumeration_Literal .. E_Entry;
      --  E_Enumeration_Literal
      --  E_Function
      --  E_Operator
      --  E_Procedure
      --  E_Abstract_State
      --  E_Entry
   subtype Subprogram_Kind is Overloadable_Kind range
     E_Function .. E_Procedure;
      --  E_Function
      --  E_Operator
      --  E_Procedure
   subtype Generic_Unit_Kind is Entity_Kind range
     E_Generic_Function .. E_Generic_Package;
      --  E_Generic_Function
      --  E_Generic_Procedure
      --  E_Generic_Package
   subtype Generic_Subprogram_Kind is Generic_Unit_Kind range
     E_Generic_Function .. E_Generic_Procedure;
      --  E_Generic_Function
      --  E_Generic_Procedure
   subtype Concurrent_Body_Kind is Entity_Kind range
     E_Protected_Body .. E_Task_Body;
      --  E_Protected_Body
      --  E_Task_Body

   --  Subtypes of Entity_Id with specified Entity_Kind.
   --  These may be used in place of Entity_Id for better documentation,
   --  and if assertions are enabled, for run-time checking.

   subtype Void_Or_Type_Kind_Id is
     Entity_Id with Predicate =>
       K (Void_Or_Type_Kind_Id) in Void_Or_Type_Kind;
   subtype E_Void_Id is
     Void_Or_Type_Kind_Id with Predicate =>
       K (E_Void_Id) in E_Void;
   subtype Type_Kind_Id is
     Void_Or_Type_Kind_Id with Predicate =>
       K (Type_Kind_Id) in Type_Kind;
   subtype Elementary_Kind_Id is
     Type_Kind_Id with Predicate =>
       K (Elementary_Kind_Id) in Elementary_Kind;
   subtype Scalar_Kind_Id is
     Elementary_Kind_Id with Predicate =>
       K (Scalar_Kind_Id) in Scalar_Kind;
   subtype Discrete_Kind_Id is
     Scalar_Kind_Id with Predicate =>
       K (Discrete_Kind_Id) in Discrete_Kind;
   subtype Enumeration_Kind_Id is
     Discrete_Kind_Id with Predicate =>
       K (Enumeration_Kind_Id) in Enumeration_Kind;
   subtype E_Enumeration_Type_Id is
     Enumeration_Kind_Id with Predicate =>
       K (E_Enumeration_Type_Id) in E_Enumeration_Type;
   subtype E_Enumeration_Subtype_Id is
     Enumeration_Kind_Id with Predicate =>
       K (E_Enumeration_Subtype_Id) in E_Enumeration_Subtype;
   subtype Integer_Kind_Id is
     Discrete_Kind_Id with Predicate =>
       K (Integer_Kind_Id) in Integer_Kind;
   subtype Signed_Integer_Kind_Id is
     Integer_Kind_Id with Predicate =>
       K (Signed_Integer_Kind_Id) in Signed_Integer_Kind;
   subtype E_Signed_Integer_Type_Id is
     Signed_Integer_Kind_Id with Predicate =>
       K (E_Signed_Integer_Type_Id) in E_Signed_Integer_Type;
   subtype E_Signed_Integer_Subtype_Id is
     Signed_Integer_Kind_Id with Predicate =>
       K (E_Signed_Integer_Subtype_Id) in E_Signed_Integer_Subtype;
   subtype Modular_Integer_Kind_Id is
     Integer_Kind_Id with Predicate =>
       K (Modular_Integer_Kind_Id) in Modular_Integer_Kind;
   subtype E_Modular_Integer_Type_Id is
     Modular_Integer_Kind_Id with Predicate =>
       K (E_Modular_Integer_Type_Id) in E_Modular_Integer_Type;
   subtype E_Modular_Integer_Subtype_Id is
     Modular_Integer_Kind_Id with Predicate =>
       K (E_Modular_Integer_Subtype_Id) in E_Modular_Integer_Subtype;
   subtype Real_Kind_Id is
     Scalar_Kind_Id with Predicate =>
       K (Real_Kind_Id) in Real_Kind;
   subtype Fixed_Point_Kind_Id is
     Real_Kind_Id with Predicate =>
       K (Fixed_Point_Kind_Id) in Fixed_Point_Kind;
   subtype Ordinary_Fixed_Point_Kind_Id is
     Fixed_Point_Kind_Id with Predicate =>
       K (Ordinary_Fixed_Point_Kind_Id) in Ordinary_Fixed_Point_Kind;
   subtype E_Ordinary_Fixed_Point_Type_Id is
     Ordinary_Fixed_Point_Kind_Id with Predicate =>
       K (E_Ordinary_Fixed_Point_Type_Id) in E_Ordinary_Fixed_Point_Type;
   subtype E_Ordinary_Fixed_Point_Subtype_Id is
     Ordinary_Fixed_Point_Kind_Id with Predicate =>
       K (E_Ordinary_Fixed_Point_Subtype_Id) in E_Ordinary_Fixed_Point_Subtype;
   subtype Decimal_Fixed_Point_Kind_Id is
     Fixed_Point_Kind_Id with Predicate =>
       K (Decimal_Fixed_Point_Kind_Id) in Decimal_Fixed_Point_Kind;
   subtype E_Decimal_Fixed_Point_Type_Id is
     Decimal_Fixed_Point_Kind_Id with Predicate =>
       K (E_Decimal_Fixed_Point_Type_Id) in E_Decimal_Fixed_Point_Type;
   subtype E_Decimal_Fixed_Point_Subtype_Id is
     Decimal_Fixed_Point_Kind_Id with Predicate =>
       K (E_Decimal_Fixed_Point_Subtype_Id) in E_Decimal_Fixed_Point_Subtype;
   subtype Float_Kind_Id is
     Real_Kind_Id with Predicate =>
       K (Float_Kind_Id) in Float_Kind;
   subtype E_Floating_Point_Type_Id is
     Float_Kind_Id with Predicate =>
       K (E_Floating_Point_Type_Id) in E_Floating_Point_Type;
   subtype E_Floating_Point_Subtype_Id is
     Float_Kind_Id with Predicate =>
       K (E_Floating_Point_Subtype_Id) in E_Floating_Point_Subtype;
   subtype Access_Kind_Id is
     Elementary_Kind_Id with Predicate =>
       K (Access_Kind_Id) in Access_Kind;
   subtype E_Access_Type_Id is
     Access_Kind_Id with Predicate =>
       K (E_Access_Type_Id) in E_Access_Type;
   subtype E_Access_Subtype_Id is
     Access_Kind_Id with Predicate =>
       K (E_Access_Subtype_Id) in E_Access_Subtype;
   subtype E_Access_Attribute_Type_Id is
     Access_Kind_Id with Predicate =>
       K (E_Access_Attribute_Type_Id) in E_Access_Attribute_Type;
   subtype E_Allocator_Type_Id is
     Access_Kind_Id with Predicate =>
       K (E_Allocator_Type_Id) in E_Allocator_Type;
   subtype E_General_Access_Type_Id is
     Access_Kind_Id with Predicate =>
       K (E_General_Access_Type_Id) in E_General_Access_Type;
   subtype Access_Subprogram_Kind_Id is
     Access_Kind_Id with Predicate =>
       K (Access_Subprogram_Kind_Id) in Access_Subprogram_Kind;
   subtype E_Access_Subprogram_Type_Id is
     Access_Subprogram_Kind_Id with Predicate =>
       K (E_Access_Subprogram_Type_Id) in E_Access_Subprogram_Type;
   subtype Access_Protected_Kind_Id is
     Access_Subprogram_Kind_Id with Predicate =>
       K (Access_Protected_Kind_Id) in Access_Protected_Kind;
   subtype E_Access_Protected_Subprogram_Type_Id is
     Access_Protected_Kind_Id with Predicate =>
       K (E_Access_Protected_Subprogram_Type_Id) in E_Access_Protected_Subprogram_Type;
   subtype E_Anonymous_Access_Protected_Subprogram_Type_Id is
     Access_Protected_Kind_Id with Predicate =>
       K (E_Anonymous_Access_Protected_Subprogram_Type_Id) in E_Anonymous_Access_Protected_Subprogram_Type;
   subtype E_Anonymous_Access_Subprogram_Type_Id is
     Access_Subprogram_Kind_Id with Predicate =>
       K (E_Anonymous_Access_Subprogram_Type_Id) in E_Anonymous_Access_Subprogram_Type;
   subtype E_Anonymous_Access_Type_Id is
     Access_Kind_Id with Predicate =>
       K (E_Anonymous_Access_Type_Id) in E_Anonymous_Access_Type;
   subtype Composite_Kind_Id is
     Type_Kind_Id with Predicate =>
       K (Composite_Kind_Id) in Composite_Kind;
   subtype Aggregate_Kind_Id is
     Composite_Kind_Id with Predicate =>
       K (Aggregate_Kind_Id) in Aggregate_Kind;
   subtype Array_Kind_Id is
     Aggregate_Kind_Id with Predicate =>
       K (Array_Kind_Id) in Array_Kind;
   subtype E_Array_Type_Id is
     Array_Kind_Id with Predicate =>
       K (E_Array_Type_Id) in E_Array_Type;
   subtype E_Array_Subtype_Id is
     Array_Kind_Id with Predicate =>
       K (E_Array_Subtype_Id) in E_Array_Subtype;
   subtype E_String_Literal_Subtype_Id is
     Array_Kind_Id with Predicate =>
       K (E_String_Literal_Subtype_Id) in E_String_Literal_Subtype;
   subtype Class_Wide_Kind_Id is
     Aggregate_Kind_Id with Predicate =>
       K (Class_Wide_Kind_Id) in Class_Wide_Kind;
   subtype E_Class_Wide_Type_Id is
     Class_Wide_Kind_Id with Predicate =>
       K (E_Class_Wide_Type_Id) in E_Class_Wide_Type;
   subtype E_Class_Wide_Subtype_Id is
     Class_Wide_Kind_Id with Predicate =>
       K (E_Class_Wide_Subtype_Id) in E_Class_Wide_Subtype;
   subtype E_Record_Type_Id is
     Aggregate_Kind_Id with Predicate =>
       K (E_Record_Type_Id) in E_Record_Type;
   subtype E_Record_Subtype_Id is
     Aggregate_Kind_Id with Predicate =>
       K (E_Record_Subtype_Id) in E_Record_Subtype;
   subtype Incomplete_Or_Private_Kind_Id is
     Composite_Kind_Id with Predicate =>
       K (Incomplete_Or_Private_Kind_Id) in Incomplete_Or_Private_Kind;
   subtype Private_Kind_Id is
     Incomplete_Or_Private_Kind_Id with Predicate =>
       K (Private_Kind_Id) in Private_Kind;
   subtype E_Record_Type_With_Private_Id is
     Private_Kind_Id with Predicate =>
       K (E_Record_Type_With_Private_Id) in E_Record_Type_With_Private;
   subtype E_Record_Subtype_With_Private_Id is
     Private_Kind_Id with Predicate =>
       K (E_Record_Subtype_With_Private_Id) in E_Record_Subtype_With_Private;
   subtype E_Private_Type_Id is
     Private_Kind_Id with Predicate =>
       K (E_Private_Type_Id) in E_Private_Type;
   subtype E_Private_Subtype_Id is
     Private_Kind_Id with Predicate =>
       K (E_Private_Subtype_Id) in E_Private_Subtype;
   subtype E_Limited_Private_Type_Id is
     Private_Kind_Id with Predicate =>
       K (E_Limited_Private_Type_Id) in E_Limited_Private_Type;
   subtype E_Limited_Private_Subtype_Id is
     Private_Kind_Id with Predicate =>
       K (E_Limited_Private_Subtype_Id) in E_Limited_Private_Subtype;
   subtype Incomplete_Kind_Id is
     Incomplete_Or_Private_Kind_Id with Predicate =>
       K (Incomplete_Kind_Id) in Incomplete_Kind;
   subtype E_Incomplete_Type_Id is
     Incomplete_Kind_Id with Predicate =>
       K (E_Incomplete_Type_Id) in E_Incomplete_Type;
   subtype E_Incomplete_Subtype_Id is
     Incomplete_Kind_Id with Predicate =>
       K (E_Incomplete_Subtype_Id) in E_Incomplete_Subtype;
   subtype Concurrent_Kind_Id is
     Composite_Kind_Id with Predicate =>
       K (Concurrent_Kind_Id) in Concurrent_Kind;
   subtype Task_Kind_Id is
     Concurrent_Kind_Id with Predicate =>
       K (Task_Kind_Id) in Task_Kind;
   subtype E_Task_Type_Id is
     Task_Kind_Id with Predicate =>
       K (E_Task_Type_Id) in E_Task_Type;
   subtype E_Task_Subtype_Id is
     Task_Kind_Id with Predicate =>
       K (E_Task_Subtype_Id) in E_Task_Subtype;
   subtype Protected_Kind_Id is
     Concurrent_Kind_Id with Predicate =>
       K (Protected_Kind_Id) in Protected_Kind;
   subtype E_Protected_Type_Id is
     Protected_Kind_Id with Predicate =>
       K (E_Protected_Type_Id) in E_Protected_Type;
   subtype E_Protected_Subtype_Id is
     Protected_Kind_Id with Predicate =>
       K (E_Protected_Subtype_Id) in E_Protected_Subtype;
   subtype E_Exception_Type_Id is
     Type_Kind_Id with Predicate =>
       K (E_Exception_Type_Id) in E_Exception_Type;
   subtype E_Subprogram_Type_Id is
     Type_Kind_Id with Predicate =>
       K (E_Subprogram_Type_Id) in E_Subprogram_Type;
   subtype Exception_Or_Object_Kind_Id is
     Entity_Id with Predicate =>
       K (Exception_Or_Object_Kind_Id) in Exception_Or_Object_Kind;
   subtype Object_Kind_Id is
     Exception_Or_Object_Kind_Id with Predicate =>
       K (Object_Kind_Id) in Object_Kind;
   subtype Record_Field_Kind_Id is
     Object_Kind_Id with Predicate =>
       K (Record_Field_Kind_Id) in Record_Field_Kind;
   subtype E_Component_Id is
     Record_Field_Kind_Id with Predicate =>
       K (E_Component_Id) in E_Component;
   subtype E_Discriminant_Id is
     Record_Field_Kind_Id with Predicate =>
       K (E_Discriminant_Id) in E_Discriminant;
   subtype Allocatable_Kind_Id is
     Object_Kind_Id with Predicate =>
       K (Allocatable_Kind_Id) in Allocatable_Kind;
   subtype Constant_Or_Variable_Kind_Id is
     Allocatable_Kind_Id with Predicate =>
       K (Constant_Or_Variable_Kind_Id) in Constant_Or_Variable_Kind;
   subtype E_Constant_Id is
     Constant_Or_Variable_Kind_Id with Predicate =>
       K (E_Constant_Id) in E_Constant;
   subtype E_Variable_Id is
     Constant_Or_Variable_Kind_Id with Predicate =>
       K (E_Variable_Id) in E_Variable;
   subtype E_Loop_Parameter_Id is
     Allocatable_Kind_Id with Predicate =>
       K (E_Loop_Parameter_Id) in E_Loop_Parameter;
   subtype Formal_Kind_Id is
     Object_Kind_Id with Predicate =>
       K (Formal_Kind_Id) in Formal_Kind;
   subtype E_Out_Parameter_Id is
     Formal_Kind_Id with Predicate =>
       K (E_Out_Parameter_Id) in E_Out_Parameter;
   subtype E_In_Out_Parameter_Id is
     Formal_Kind_Id with Predicate =>
       K (E_In_Out_Parameter_Id) in E_In_Out_Parameter;
   subtype E_In_Parameter_Id is
     Formal_Kind_Id with Predicate =>
       K (E_In_Parameter_Id) in E_In_Parameter;
   subtype Formal_Object_Kind_Id is
     Object_Kind_Id with Predicate =>
       K (Formal_Object_Kind_Id) in Formal_Object_Kind;
   subtype E_Generic_In_Out_Parameter_Id is
     Formal_Object_Kind_Id with Predicate =>
       K (E_Generic_In_Out_Parameter_Id) in E_Generic_In_Out_Parameter;
   subtype E_Generic_In_Parameter_Id is
     Formal_Object_Kind_Id with Predicate =>
       K (E_Generic_In_Parameter_Id) in E_Generic_In_Parameter;
   subtype E_Exception_Id is
     Exception_Or_Object_Kind_Id with Predicate =>
       K (E_Exception_Id) in E_Exception;
   subtype Named_Kind_Id is
     Entity_Id with Predicate =>
       K (Named_Kind_Id) in Named_Kind;
   subtype E_Named_Integer_Id is
     Named_Kind_Id with Predicate =>
       K (E_Named_Integer_Id) in E_Named_Integer;
   subtype E_Named_Real_Id is
     Named_Kind_Id with Predicate =>
       K (E_Named_Real_Id) in E_Named_Real;
   subtype Overloadable_Kind_Id is
     Entity_Id with Predicate =>
       K (Overloadable_Kind_Id) in Overloadable_Kind;
   subtype E_Enumeration_Literal_Id is
     Overloadable_Kind_Id with Predicate =>
       K (E_Enumeration_Literal_Id) in E_Enumeration_Literal;
   subtype Subprogram_Kind_Id is
     Overloadable_Kind_Id with Predicate =>
       K (Subprogram_Kind_Id) in Subprogram_Kind;
   subtype E_Function_Id is
     Subprogram_Kind_Id with Predicate =>
       K (E_Function_Id) in E_Function;
   subtype E_Operator_Id is
     Subprogram_Kind_Id with Predicate =>
       K (E_Operator_Id) in E_Operator;
   subtype E_Procedure_Id is
     Subprogram_Kind_Id with Predicate =>
       K (E_Procedure_Id) in E_Procedure;
   subtype E_Abstract_State_Id is
     Overloadable_Kind_Id with Predicate =>
       K (E_Abstract_State_Id) in E_Abstract_State;
   subtype E_Entry_Id is
     Overloadable_Kind_Id with Predicate =>
       K (E_Entry_Id) in E_Entry;
   subtype E_Entry_Family_Id is
     Entity_Id with Predicate =>
       K (E_Entry_Family_Id) in E_Entry_Family;
   subtype E_Block_Id is
     Entity_Id with Predicate =>
       K (E_Block_Id) in E_Block;
   subtype E_Entry_Index_Parameter_Id is
     Entity_Id with Predicate =>
       K (E_Entry_Index_Parameter_Id) in E_Entry_Index_Parameter;
   subtype Generic_Unit_Kind_Id is
     Entity_Id with Predicate =>
       K (Generic_Unit_Kind_Id) in Generic_Unit_Kind;
   subtype Generic_Subprogram_Kind_Id is
     Generic_Unit_Kind_Id with Predicate =>
       K (Generic_Subprogram_Kind_Id) in Generic_Subprogram_Kind;
   subtype E_Generic_Function_Id is
     Generic_Subprogram_Kind_Id with Predicate =>
       K (E_Generic_Function_Id) in E_Generic_Function;
   subtype E_Generic_Procedure_Id is
     Generic_Subprogram_Kind_Id with Predicate =>
       K (E_Generic_Procedure_Id) in E_Generic_Procedure;
   subtype E_Generic_Package_Id is
     Generic_Unit_Kind_Id with Predicate =>
       K (E_Generic_Package_Id) in E_Generic_Package;
   subtype E_Label_Id is
     Entity_Id with Predicate =>
       K (E_Label_Id) in E_Label;
   subtype E_Loop_Id is
     Entity_Id with Predicate =>
       K (E_Loop_Id) in E_Loop;
   subtype E_Return_Statement_Id is
     Entity_Id with Predicate =>
       K (E_Return_Statement_Id) in E_Return_Statement;
   subtype E_Package_Id is
     Entity_Id with Predicate =>
       K (E_Package_Id) in E_Package;
   subtype E_Package_Body_Id is
     Entity_Id with Predicate =>
       K (E_Package_Body_Id) in E_Package_Body;
   subtype Concurrent_Body_Kind_Id is
     Entity_Id with Predicate =>
       K (Concurrent_Body_Kind_Id) in Concurrent_Body_Kind;
   subtype E_Protected_Body_Id is
     Concurrent_Body_Kind_Id with Predicate =>
       K (E_Protected_Body_Id) in E_Protected_Body;
   subtype E_Task_Body_Id is
     Concurrent_Body_Kind_Id with Predicate =>
       K (E_Task_Body_Id) in E_Task_Body;
   subtype E_Subprogram_Body_Id is
     Entity_Id with Predicate =>
       K (E_Subprogram_Body_Id) in E_Subprogram_Body;

   --  Union types (nonhierarchical subtypes of Entity_Id)

   subtype Anonymous_Access_Kind is
     Entity_Kind with Predicate =>
       Anonymous_Access_Kind in
          E_Anonymous_Access_Protected_Subprogram_Type
          | E_Anonymous_Access_Subprogram_Type
          | E_Anonymous_Access_Type;
   subtype Anonymous_Access_Kind_Id is
     Entity_Id with Predicate =>
       K (Anonymous_Access_Kind_Id) in Anonymous_Access_Kind;
   subtype Assignable_Kind is
     Entity_Kind with Predicate =>
       Assignable_Kind in
          E_Variable
          | E_Out_Parameter
          | E_In_Out_Parameter;
   subtype Assignable_Kind_Id is
     Entity_Id with Predicate =>
       K (Assignable_Kind_Id) in Assignable_Kind;
   subtype Digits_Kind is
     Entity_Kind with Predicate =>
       Digits_Kind in
          Decimal_Fixed_Point_Kind
          | Float_Kind;
   subtype Digits_Kind_Id is
     Entity_Id with Predicate =>
       K (Digits_Kind_Id) in Digits_Kind;
   subtype Discrete_Or_Fixed_Point_Kind is
     Entity_Kind with Predicate =>
       Discrete_Or_Fixed_Point_Kind in
          Discrete_Kind
          | Fixed_Point_Kind;
   subtype Discrete_Or_Fixed_Point_Kind_Id is
     Entity_Id with Predicate =>
       K (Discrete_Or_Fixed_Point_Kind_Id) in Discrete_Or_Fixed_Point_Kind;
   subtype Entry_Kind is
     Entity_Kind with Predicate =>
       Entry_Kind in
          E_Entry
          | E_Entry_Family;
   subtype Entry_Kind_Id is
     Entity_Id with Predicate =>
       K (Entry_Kind_Id) in Entry_Kind;
   subtype Evaluable_Kind is
     Entity_Kind with Predicate =>
       Evaluable_Kind in
          Exception_Or_Object_Kind
          | E_Enumeration_Literal
          | E_Label
          | Subprogram_Kind;
   subtype Evaluable_Kind_Id is
     Entity_Id with Predicate =>
       K (Evaluable_Kind_Id) in Evaluable_Kind;
   subtype Global_Name_Kind is
     Entity_Kind with Predicate =>
       Global_Name_Kind in
          Constant_Or_Variable_Kind
          | E_Exception
          | E_Package
          | Subprogram_Kind;
   subtype Global_Name_Kind_Id is
     Entity_Id with Predicate =>
       K (Global_Name_Kind_Id) in Global_Name_Kind;
   subtype Named_Access_Kind is
     Entity_Kind with Predicate =>
       Named_Access_Kind in
          E_Access_Type
          | E_Access_Subtype
          | E_Access_Attribute_Type
          | E_Allocator_Type
          | E_General_Access_Type
          | E_Access_Subprogram_Type
          | E_Access_Protected_Subprogram_Type;
   subtype Named_Access_Kind_Id is
     Entity_Id with Predicate =>
       K (Named_Access_Kind_Id) in Named_Access_Kind;
   subtype Numeric_Kind is
     Entity_Kind with Predicate =>
       Numeric_Kind in
          Integer_Kind
          | Fixed_Point_Kind
          | Float_Kind;
   subtype Numeric_Kind_Id is
     Entity_Id with Predicate =>
       K (Numeric_Kind_Id) in Numeric_Kind;
   subtype Record_Kind is
     Entity_Kind with Predicate =>
       Record_Kind in
          E_Class_Wide_Type
          | E_Class_Wide_Subtype
          | E_Record_Type
          | E_Record_Subtype
          | E_Record_Type_With_Private
          | E_Record_Subtype_With_Private;
   subtype Record_Kind_Id is
     Entity_Id with Predicate =>
       K (Record_Kind_Id) in Record_Kind;
   subtype Subprogram_Type_Or_Kind is
     Entity_Kind with Predicate =>
       Subprogram_Type_Or_Kind in
          Subprogram_Kind
          | E_Subprogram_Body
          | E_Subprogram_Type;
   subtype Subprogram_Type_Or_Kind_Id is
     Entity_Id with Predicate =>
       K (Subprogram_Type_Or_Kind_Id) in Subprogram_Type_Or_Kind;

   --  Optional subtypes of Entity_Id. These allow Empty.

   subtype Opt_Void_Or_Type_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Void_Or_Type_Kind_Id = Empty or else
       Opt_Void_Or_Type_Kind_Id in Void_Or_Type_Kind_Id;
   subtype Opt_E_Void_Id is
     Entity_Id with Predicate =>
       Opt_E_Void_Id = Empty or else
       Opt_E_Void_Id in E_Void_Id;
   subtype Opt_Type_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Type_Kind_Id = Empty or else
       Opt_Type_Kind_Id in Type_Kind_Id;
   subtype Opt_Elementary_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Elementary_Kind_Id = Empty or else
       Opt_Elementary_Kind_Id in Elementary_Kind_Id;
   subtype Opt_Scalar_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Scalar_Kind_Id = Empty or else
       Opt_Scalar_Kind_Id in Scalar_Kind_Id;
   subtype Opt_Discrete_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Discrete_Kind_Id = Empty or else
       Opt_Discrete_Kind_Id in Discrete_Kind_Id;
   subtype Opt_Enumeration_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Enumeration_Kind_Id = Empty or else
       Opt_Enumeration_Kind_Id in Enumeration_Kind_Id;
   subtype Opt_E_Enumeration_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Enumeration_Type_Id = Empty or else
       Opt_E_Enumeration_Type_Id in E_Enumeration_Type_Id;
   subtype Opt_E_Enumeration_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Enumeration_Subtype_Id = Empty or else
       Opt_E_Enumeration_Subtype_Id in E_Enumeration_Subtype_Id;
   subtype Opt_Integer_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Integer_Kind_Id = Empty or else
       Opt_Integer_Kind_Id in Integer_Kind_Id;
   subtype Opt_Signed_Integer_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Signed_Integer_Kind_Id = Empty or else
       Opt_Signed_Integer_Kind_Id in Signed_Integer_Kind_Id;
   subtype Opt_E_Signed_Integer_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Signed_Integer_Type_Id = Empty or else
       Opt_E_Signed_Integer_Type_Id in E_Signed_Integer_Type_Id;
   subtype Opt_E_Signed_Integer_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Signed_Integer_Subtype_Id = Empty or else
       Opt_E_Signed_Integer_Subtype_Id in E_Signed_Integer_Subtype_Id;
   subtype Opt_Modular_Integer_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Modular_Integer_Kind_Id = Empty or else
       Opt_Modular_Integer_Kind_Id in Modular_Integer_Kind_Id;
   subtype Opt_E_Modular_Integer_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Modular_Integer_Type_Id = Empty or else
       Opt_E_Modular_Integer_Type_Id in E_Modular_Integer_Type_Id;
   subtype Opt_E_Modular_Integer_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Modular_Integer_Subtype_Id = Empty or else
       Opt_E_Modular_Integer_Subtype_Id in E_Modular_Integer_Subtype_Id;
   subtype Opt_Real_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Real_Kind_Id = Empty or else
       Opt_Real_Kind_Id in Real_Kind_Id;
   subtype Opt_Fixed_Point_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Fixed_Point_Kind_Id = Empty or else
       Opt_Fixed_Point_Kind_Id in Fixed_Point_Kind_Id;
   subtype Opt_Ordinary_Fixed_Point_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Ordinary_Fixed_Point_Kind_Id = Empty or else
       Opt_Ordinary_Fixed_Point_Kind_Id in Ordinary_Fixed_Point_Kind_Id;
   subtype Opt_E_Ordinary_Fixed_Point_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Ordinary_Fixed_Point_Type_Id = Empty or else
       Opt_E_Ordinary_Fixed_Point_Type_Id in E_Ordinary_Fixed_Point_Type_Id;
   subtype Opt_E_Ordinary_Fixed_Point_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Ordinary_Fixed_Point_Subtype_Id = Empty or else
       Opt_E_Ordinary_Fixed_Point_Subtype_Id in E_Ordinary_Fixed_Point_Subtype_Id;
   subtype Opt_Decimal_Fixed_Point_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Decimal_Fixed_Point_Kind_Id = Empty or else
       Opt_Decimal_Fixed_Point_Kind_Id in Decimal_Fixed_Point_Kind_Id;
   subtype Opt_E_Decimal_Fixed_Point_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Decimal_Fixed_Point_Type_Id = Empty or else
       Opt_E_Decimal_Fixed_Point_Type_Id in E_Decimal_Fixed_Point_Type_Id;
   subtype Opt_E_Decimal_Fixed_Point_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Decimal_Fixed_Point_Subtype_Id = Empty or else
       Opt_E_Decimal_Fixed_Point_Subtype_Id in E_Decimal_Fixed_Point_Subtype_Id;
   subtype Opt_Float_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Float_Kind_Id = Empty or else
       Opt_Float_Kind_Id in Float_Kind_Id;
   subtype Opt_E_Floating_Point_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Floating_Point_Type_Id = Empty or else
       Opt_E_Floating_Point_Type_Id in E_Floating_Point_Type_Id;
   subtype Opt_E_Floating_Point_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Floating_Point_Subtype_Id = Empty or else
       Opt_E_Floating_Point_Subtype_Id in E_Floating_Point_Subtype_Id;
   subtype Opt_Access_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Access_Kind_Id = Empty or else
       Opt_Access_Kind_Id in Access_Kind_Id;
   subtype Opt_E_Access_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Access_Type_Id = Empty or else
       Opt_E_Access_Type_Id in E_Access_Type_Id;
   subtype Opt_E_Access_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Access_Subtype_Id = Empty or else
       Opt_E_Access_Subtype_Id in E_Access_Subtype_Id;
   subtype Opt_E_Access_Attribute_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Access_Attribute_Type_Id = Empty or else
       Opt_E_Access_Attribute_Type_Id in E_Access_Attribute_Type_Id;
   subtype Opt_E_Allocator_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Allocator_Type_Id = Empty or else
       Opt_E_Allocator_Type_Id in E_Allocator_Type_Id;
   subtype Opt_E_General_Access_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_General_Access_Type_Id = Empty or else
       Opt_E_General_Access_Type_Id in E_General_Access_Type_Id;
   subtype Opt_Access_Subprogram_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Access_Subprogram_Kind_Id = Empty or else
       Opt_Access_Subprogram_Kind_Id in Access_Subprogram_Kind_Id;
   subtype Opt_E_Access_Subprogram_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Access_Subprogram_Type_Id = Empty or else
       Opt_E_Access_Subprogram_Type_Id in E_Access_Subprogram_Type_Id;
   subtype Opt_Access_Protected_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Access_Protected_Kind_Id = Empty or else
       Opt_Access_Protected_Kind_Id in Access_Protected_Kind_Id;
   subtype Opt_E_Access_Protected_Subprogram_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Access_Protected_Subprogram_Type_Id = Empty or else
       Opt_E_Access_Protected_Subprogram_Type_Id in E_Access_Protected_Subprogram_Type_Id;
   subtype Opt_E_Anonymous_Access_Protected_Subprogram_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Anonymous_Access_Protected_Subprogram_Type_Id = Empty or else
       Opt_E_Anonymous_Access_Protected_Subprogram_Type_Id in E_Anonymous_Access_Protected_Subprogram_Type_Id;
   subtype Opt_E_Anonymous_Access_Subprogram_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Anonymous_Access_Subprogram_Type_Id = Empty or else
       Opt_E_Anonymous_Access_Subprogram_Type_Id in E_Anonymous_Access_Subprogram_Type_Id;
   subtype Opt_E_Anonymous_Access_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Anonymous_Access_Type_Id = Empty or else
       Opt_E_Anonymous_Access_Type_Id in E_Anonymous_Access_Type_Id;
   subtype Opt_Composite_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Composite_Kind_Id = Empty or else
       Opt_Composite_Kind_Id in Composite_Kind_Id;
   subtype Opt_Aggregate_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Aggregate_Kind_Id = Empty or else
       Opt_Aggregate_Kind_Id in Aggregate_Kind_Id;
   subtype Opt_Array_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Array_Kind_Id = Empty or else
       Opt_Array_Kind_Id in Array_Kind_Id;
   subtype Opt_E_Array_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Array_Type_Id = Empty or else
       Opt_E_Array_Type_Id in E_Array_Type_Id;
   subtype Opt_E_Array_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Array_Subtype_Id = Empty or else
       Opt_E_Array_Subtype_Id in E_Array_Subtype_Id;
   subtype Opt_E_String_Literal_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_String_Literal_Subtype_Id = Empty or else
       Opt_E_String_Literal_Subtype_Id in E_String_Literal_Subtype_Id;
   subtype Opt_Class_Wide_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Class_Wide_Kind_Id = Empty or else
       Opt_Class_Wide_Kind_Id in Class_Wide_Kind_Id;
   subtype Opt_E_Class_Wide_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Class_Wide_Type_Id = Empty or else
       Opt_E_Class_Wide_Type_Id in E_Class_Wide_Type_Id;
   subtype Opt_E_Class_Wide_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Class_Wide_Subtype_Id = Empty or else
       Opt_E_Class_Wide_Subtype_Id in E_Class_Wide_Subtype_Id;
   subtype Opt_E_Record_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Record_Type_Id = Empty or else
       Opt_E_Record_Type_Id in E_Record_Type_Id;
   subtype Opt_E_Record_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Record_Subtype_Id = Empty or else
       Opt_E_Record_Subtype_Id in E_Record_Subtype_Id;
   subtype Opt_Incomplete_Or_Private_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Incomplete_Or_Private_Kind_Id = Empty or else
       Opt_Incomplete_Or_Private_Kind_Id in Incomplete_Or_Private_Kind_Id;
   subtype Opt_Private_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Private_Kind_Id = Empty or else
       Opt_Private_Kind_Id in Private_Kind_Id;
   subtype Opt_E_Record_Type_With_Private_Id is
     Entity_Id with Predicate =>
       Opt_E_Record_Type_With_Private_Id = Empty or else
       Opt_E_Record_Type_With_Private_Id in E_Record_Type_With_Private_Id;
   subtype Opt_E_Record_Subtype_With_Private_Id is
     Entity_Id with Predicate =>
       Opt_E_Record_Subtype_With_Private_Id = Empty or else
       Opt_E_Record_Subtype_With_Private_Id in E_Record_Subtype_With_Private_Id;
   subtype Opt_E_Private_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Private_Type_Id = Empty or else
       Opt_E_Private_Type_Id in E_Private_Type_Id;
   subtype Opt_E_Private_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Private_Subtype_Id = Empty or else
       Opt_E_Private_Subtype_Id in E_Private_Subtype_Id;
   subtype Opt_E_Limited_Private_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Limited_Private_Type_Id = Empty or else
       Opt_E_Limited_Private_Type_Id in E_Limited_Private_Type_Id;
   subtype Opt_E_Limited_Private_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Limited_Private_Subtype_Id = Empty or else
       Opt_E_Limited_Private_Subtype_Id in E_Limited_Private_Subtype_Id;
   subtype Opt_Incomplete_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Incomplete_Kind_Id = Empty or else
       Opt_Incomplete_Kind_Id in Incomplete_Kind_Id;
   subtype Opt_E_Incomplete_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Incomplete_Type_Id = Empty or else
       Opt_E_Incomplete_Type_Id in E_Incomplete_Type_Id;
   subtype Opt_E_Incomplete_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Incomplete_Subtype_Id = Empty or else
       Opt_E_Incomplete_Subtype_Id in E_Incomplete_Subtype_Id;
   subtype Opt_Concurrent_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Concurrent_Kind_Id = Empty or else
       Opt_Concurrent_Kind_Id in Concurrent_Kind_Id;
   subtype Opt_Task_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Task_Kind_Id = Empty or else
       Opt_Task_Kind_Id in Task_Kind_Id;
   subtype Opt_E_Task_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Task_Type_Id = Empty or else
       Opt_E_Task_Type_Id in E_Task_Type_Id;
   subtype Opt_E_Task_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Task_Subtype_Id = Empty or else
       Opt_E_Task_Subtype_Id in E_Task_Subtype_Id;
   subtype Opt_Protected_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Protected_Kind_Id = Empty or else
       Opt_Protected_Kind_Id in Protected_Kind_Id;
   subtype Opt_E_Protected_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Protected_Type_Id = Empty or else
       Opt_E_Protected_Type_Id in E_Protected_Type_Id;
   subtype Opt_E_Protected_Subtype_Id is
     Entity_Id with Predicate =>
       Opt_E_Protected_Subtype_Id = Empty or else
       Opt_E_Protected_Subtype_Id in E_Protected_Subtype_Id;
   subtype Opt_E_Exception_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Exception_Type_Id = Empty or else
       Opt_E_Exception_Type_Id in E_Exception_Type_Id;
   subtype Opt_E_Subprogram_Type_Id is
     Entity_Id with Predicate =>
       Opt_E_Subprogram_Type_Id = Empty or else
       Opt_E_Subprogram_Type_Id in E_Subprogram_Type_Id;
   subtype Opt_Exception_Or_Object_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Exception_Or_Object_Kind_Id = Empty or else
       Opt_Exception_Or_Object_Kind_Id in Exception_Or_Object_Kind_Id;
   subtype Opt_Object_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Object_Kind_Id = Empty or else
       Opt_Object_Kind_Id in Object_Kind_Id;
   subtype Opt_Record_Field_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Record_Field_Kind_Id = Empty or else
       Opt_Record_Field_Kind_Id in Record_Field_Kind_Id;
   subtype Opt_E_Component_Id is
     Entity_Id with Predicate =>
       Opt_E_Component_Id = Empty or else
       Opt_E_Component_Id in E_Component_Id;
   subtype Opt_E_Discriminant_Id is
     Entity_Id with Predicate =>
       Opt_E_Discriminant_Id = Empty or else
       Opt_E_Discriminant_Id in E_Discriminant_Id;
   subtype Opt_Allocatable_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Allocatable_Kind_Id = Empty or else
       Opt_Allocatable_Kind_Id in Allocatable_Kind_Id;
   subtype Opt_Constant_Or_Variable_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Constant_Or_Variable_Kind_Id = Empty or else
       Opt_Constant_Or_Variable_Kind_Id in Constant_Or_Variable_Kind_Id;
   subtype Opt_E_Constant_Id is
     Entity_Id with Predicate =>
       Opt_E_Constant_Id = Empty or else
       Opt_E_Constant_Id in E_Constant_Id;
   subtype Opt_E_Variable_Id is
     Entity_Id with Predicate =>
       Opt_E_Variable_Id = Empty or else
       Opt_E_Variable_Id in E_Variable_Id;
   subtype Opt_E_Loop_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_Loop_Parameter_Id = Empty or else
       Opt_E_Loop_Parameter_Id in E_Loop_Parameter_Id;
   subtype Opt_Formal_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Formal_Kind_Id = Empty or else
       Opt_Formal_Kind_Id in Formal_Kind_Id;
   subtype Opt_E_Out_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_Out_Parameter_Id = Empty or else
       Opt_E_Out_Parameter_Id in E_Out_Parameter_Id;
   subtype Opt_E_In_Out_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_In_Out_Parameter_Id = Empty or else
       Opt_E_In_Out_Parameter_Id in E_In_Out_Parameter_Id;
   subtype Opt_E_In_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_In_Parameter_Id = Empty or else
       Opt_E_In_Parameter_Id in E_In_Parameter_Id;
   subtype Opt_Formal_Object_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Formal_Object_Kind_Id = Empty or else
       Opt_Formal_Object_Kind_Id in Formal_Object_Kind_Id;
   subtype Opt_E_Generic_In_Out_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_Generic_In_Out_Parameter_Id = Empty or else
       Opt_E_Generic_In_Out_Parameter_Id in E_Generic_In_Out_Parameter_Id;
   subtype Opt_E_Generic_In_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_Generic_In_Parameter_Id = Empty or else
       Opt_E_Generic_In_Parameter_Id in E_Generic_In_Parameter_Id;
   subtype Opt_E_Exception_Id is
     Entity_Id with Predicate =>
       Opt_E_Exception_Id = Empty or else
       Opt_E_Exception_Id in E_Exception_Id;
   subtype Opt_Named_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Named_Kind_Id = Empty or else
       Opt_Named_Kind_Id in Named_Kind_Id;
   subtype Opt_E_Named_Integer_Id is
     Entity_Id with Predicate =>
       Opt_E_Named_Integer_Id = Empty or else
       Opt_E_Named_Integer_Id in E_Named_Integer_Id;
   subtype Opt_E_Named_Real_Id is
     Entity_Id with Predicate =>
       Opt_E_Named_Real_Id = Empty or else
       Opt_E_Named_Real_Id in E_Named_Real_Id;
   subtype Opt_Overloadable_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Overloadable_Kind_Id = Empty or else
       Opt_Overloadable_Kind_Id in Overloadable_Kind_Id;
   subtype Opt_E_Enumeration_Literal_Id is
     Entity_Id with Predicate =>
       Opt_E_Enumeration_Literal_Id = Empty or else
       Opt_E_Enumeration_Literal_Id in E_Enumeration_Literal_Id;
   subtype Opt_Subprogram_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Subprogram_Kind_Id = Empty or else
       Opt_Subprogram_Kind_Id in Subprogram_Kind_Id;
   subtype Opt_E_Function_Id is
     Entity_Id with Predicate =>
       Opt_E_Function_Id = Empty or else
       Opt_E_Function_Id in E_Function_Id;
   subtype Opt_E_Operator_Id is
     Entity_Id with Predicate =>
       Opt_E_Operator_Id = Empty or else
       Opt_E_Operator_Id in E_Operator_Id;
   subtype Opt_E_Procedure_Id is
     Entity_Id with Predicate =>
       Opt_E_Procedure_Id = Empty or else
       Opt_E_Procedure_Id in E_Procedure_Id;
   subtype Opt_E_Abstract_State_Id is
     Entity_Id with Predicate =>
       Opt_E_Abstract_State_Id = Empty or else
       Opt_E_Abstract_State_Id in E_Abstract_State_Id;
   subtype Opt_E_Entry_Id is
     Entity_Id with Predicate =>
       Opt_E_Entry_Id = Empty or else
       Opt_E_Entry_Id in E_Entry_Id;
   subtype Opt_E_Entry_Family_Id is
     Entity_Id with Predicate =>
       Opt_E_Entry_Family_Id = Empty or else
       Opt_E_Entry_Family_Id in E_Entry_Family_Id;
   subtype Opt_E_Block_Id is
     Entity_Id with Predicate =>
       Opt_E_Block_Id = Empty or else
       Opt_E_Block_Id in E_Block_Id;
   subtype Opt_E_Entry_Index_Parameter_Id is
     Entity_Id with Predicate =>
       Opt_E_Entry_Index_Parameter_Id = Empty or else
       Opt_E_Entry_Index_Parameter_Id in E_Entry_Index_Parameter_Id;
   subtype Opt_Generic_Unit_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Generic_Unit_Kind_Id = Empty or else
       Opt_Generic_Unit_Kind_Id in Generic_Unit_Kind_Id;
   subtype Opt_Generic_Subprogram_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Generic_Subprogram_Kind_Id = Empty or else
       Opt_Generic_Subprogram_Kind_Id in Generic_Subprogram_Kind_Id;
   subtype Opt_E_Generic_Function_Id is
     Entity_Id with Predicate =>
       Opt_E_Generic_Function_Id = Empty or else
       Opt_E_Generic_Function_Id in E_Generic_Function_Id;
   subtype Opt_E_Generic_Procedure_Id is
     Entity_Id with Predicate =>
       Opt_E_Generic_Procedure_Id = Empty or else
       Opt_E_Generic_Procedure_Id in E_Generic_Procedure_Id;
   subtype Opt_E_Generic_Package_Id is
     Entity_Id with Predicate =>
       Opt_E_Generic_Package_Id = Empty or else
       Opt_E_Generic_Package_Id in E_Generic_Package_Id;
   subtype Opt_E_Label_Id is
     Entity_Id with Predicate =>
       Opt_E_Label_Id = Empty or else
       Opt_E_Label_Id in E_Label_Id;
   subtype Opt_E_Loop_Id is
     Entity_Id with Predicate =>
       Opt_E_Loop_Id = Empty or else
       Opt_E_Loop_Id in E_Loop_Id;
   subtype Opt_E_Return_Statement_Id is
     Entity_Id with Predicate =>
       Opt_E_Return_Statement_Id = Empty or else
       Opt_E_Return_Statement_Id in E_Return_Statement_Id;
   subtype Opt_E_Package_Id is
     Entity_Id with Predicate =>
       Opt_E_Package_Id = Empty or else
       Opt_E_Package_Id in E_Package_Id;
   subtype Opt_E_Package_Body_Id is
     Entity_Id with Predicate =>
       Opt_E_Package_Body_Id = Empty or else
       Opt_E_Package_Body_Id in E_Package_Body_Id;
   subtype Opt_Concurrent_Body_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Concurrent_Body_Kind_Id = Empty or else
       Opt_Concurrent_Body_Kind_Id in Concurrent_Body_Kind_Id;
   subtype Opt_E_Protected_Body_Id is
     Entity_Id with Predicate =>
       Opt_E_Protected_Body_Id = Empty or else
       Opt_E_Protected_Body_Id in E_Protected_Body_Id;
   subtype Opt_E_Task_Body_Id is
     Entity_Id with Predicate =>
       Opt_E_Task_Body_Id = Empty or else
       Opt_E_Task_Body_Id in E_Task_Body_Id;
   subtype Opt_E_Subprogram_Body_Id is
     Entity_Id with Predicate =>
       Opt_E_Subprogram_Body_Id = Empty or else
       Opt_E_Subprogram_Body_Id in E_Subprogram_Body_Id;

   --  Optional union types:

   subtype Opt_Anonymous_Access_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Anonymous_Access_Kind_Id = Empty or else
       Opt_Anonymous_Access_Kind_Id in Anonymous_Access_Kind_Id;
   subtype Opt_Assignable_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Assignable_Kind_Id = Empty or else
       Opt_Assignable_Kind_Id in Assignable_Kind_Id;
   subtype Opt_Digits_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Digits_Kind_Id = Empty or else
       Opt_Digits_Kind_Id in Digits_Kind_Id;
   subtype Opt_Discrete_Or_Fixed_Point_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Discrete_Or_Fixed_Point_Kind_Id = Empty or else
       Opt_Discrete_Or_Fixed_Point_Kind_Id in Discrete_Or_Fixed_Point_Kind_Id;
   subtype Opt_Entry_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Entry_Kind_Id = Empty or else
       Opt_Entry_Kind_Id in Entry_Kind_Id;
   subtype Opt_Evaluable_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Evaluable_Kind_Id = Empty or else
       Opt_Evaluable_Kind_Id in Evaluable_Kind_Id;
   subtype Opt_Global_Name_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Global_Name_Kind_Id = Empty or else
       Opt_Global_Name_Kind_Id in Global_Name_Kind_Id;
   subtype Opt_Named_Access_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Named_Access_Kind_Id = Empty or else
       Opt_Named_Access_Kind_Id in Named_Access_Kind_Id;
   subtype Opt_Numeric_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Numeric_Kind_Id = Empty or else
       Opt_Numeric_Kind_Id in Numeric_Kind_Id;
   subtype Opt_Record_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Record_Kind_Id = Empty or else
       Opt_Record_Kind_Id in Record_Kind_Id;
   subtype Opt_Subprogram_Type_Or_Kind_Id is
     Entity_Id with Predicate =>
       Opt_Subprogram_Type_Or_Kind_Id = Empty or else
       Opt_Subprogram_Type_Or_Kind_Id in Subprogram_Type_Or_Kind_Id;

   subtype Flag is Boolean;

   --  Getters and setters for fields

   --  Ekind getter is above

   function Basic_Convention (N : Entity_Id) return Convention_Id with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Basic_Convention (N : Entity_Id; Val : Convention_Id) with Inline, Pre =>
      N in N_Entity_Id;

   function Abstract_States (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Generic_Package_Id
         | E_Package_Id;
   procedure Set_Abstract_States (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Generic_Package_Id
         | E_Package_Id;

   function Accept_Address (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Accept_Address (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Entry_Id
         | E_Entry_Family_Id;

   function Access_Disp_Table (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id;
   procedure Set_Access_Disp_Table (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id;

   function Access_Disp_Table_Elab_Flag (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id;
   procedure Set_Access_Disp_Table_Elab_Flag (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id;

   function Access_Subprogram_Wrapper (N : E_Subprogram_Type_Id) return Node_Id with Inline;
   procedure Set_Access_Subprogram_Wrapper (N : E_Subprogram_Type_Id; Val : Node_Id) with Inline;

   function Activation_Record_Component (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Allocatable_Kind_Id
         | Formal_Kind_Id;
   procedure Set_Activation_Record_Component (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Allocatable_Kind_Id
         | Formal_Kind_Id;

   function Actual_Subtype (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Formal_Kind_Id
         | E_Generic_In_Out_Parameter_Id;
   procedure Set_Actual_Subtype (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Formal_Kind_Id
         | E_Generic_In_Out_Parameter_Id;

   function Address_Taken (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Address_Taken (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Alignment (N : Entity_Id) return Unat with Inline, Pre =>
      N in E_Void_Id
         | Allocatable_Kind_Id
         | Formal_Kind_Id
         | Type_Kind_Id
         | E_Enumeration_Literal_Id
         | E_Exception_Id;
   procedure Set_Alignment (N : Entity_Id; Val : Unat) with Inline, Pre =>
      N in E_Void_Id
         | Allocatable_Kind_Id
         | Formal_Kind_Id
         | Type_Kind_Id
         | E_Enumeration_Literal_Id
         | E_Exception_Id;

   function Anonymous_Designated_Type (N : E_Variable_Id) return Node_Id with Inline;
   procedure Set_Anonymous_Designated_Type (N : E_Variable_Id; Val : Node_Id) with Inline;

   function Anonymous_Masters (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Package_Id
         | E_Subprogram_Body_Id;
   procedure Set_Anonymous_Masters (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Package_Id
         | E_Subprogram_Body_Id;

   function Anonymous_Object (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id;
   procedure Set_Anonymous_Object (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id;

   function Associated_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Associated_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in N_Entity_Id;

   function Associated_Formal_Package (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Package_Id;
   procedure Set_Associated_Formal_Package (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Package_Id;

   function Associated_Node_For_Itype (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id
         | E_Procedure_Id;
   procedure Set_Associated_Node_For_Itype (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id
         | E_Procedure_Id;

   function Associated_Storage_Pool (N : Access_Kind_Id) return Node_Id with Inline;
   procedure Set_Associated_Storage_Pool (N : Access_Kind_Id; Val : Node_Id) with Inline;

   function Barrier_Function (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Barrier_Function (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Entry_Id
         | E_Entry_Family_Id;

   function BIP_Initialization_Call (N : Constant_Or_Variable_Kind_Id) return Node_Id with Inline;
   procedure Set_BIP_Initialization_Call (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) with Inline;

   function Block_Node (N : E_Block_Id) return Node_Id with Inline;
   procedure Set_Block_Node (N : E_Block_Id; Val : Node_Id) with Inline;

   function Body_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Generic_Package_Id
         | E_Package_Id;
   procedure Set_Body_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Generic_Package_Id
         | E_Package_Id;

   function Body_Needed_For_Inlining (N : E_Package_Id) return Flag with Inline;
   procedure Set_Body_Needed_For_Inlining (N : E_Package_Id; Val : Flag := True) with Inline;

   function Body_Needed_For_SAL (N : Entity_Id) return Flag with Inline, Pre =>
      N in Subprogram_Kind_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;
   procedure Set_Body_Needed_For_SAL (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Subprogram_Kind_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;

   function Body_References (N : E_Abstract_State_Id) return Elist_Id with Inline;
   procedure Set_Body_References (N : E_Abstract_State_Id; Val : Elist_Id) with Inline;

   function C_Pass_By_Copy (N : Entity_Id) return Flag with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_C_Pass_By_Copy (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Can_Never_Be_Null (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Can_Never_Be_Null (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Can_Use_Internal_Rep (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Can_Use_Internal_Rep (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Checks_May_Be_Suppressed (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Checks_May_Be_Suppressed (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Class_Postconditions (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Class_Postconditions (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Class_Preconditions (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Class_Preconditions (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Class_Preconditions_Subprogram (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Class_Preconditions_Subprogram (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Class_Wide_Type (N : Type_Kind_Id) return Node_Id with Inline;
   procedure Set_Class_Wide_Type (N : Type_Kind_Id; Val : Node_Id) with Inline;

   function Cloned_Subtype (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Class_Wide_Subtype_Id
         | E_Record_Subtype_Id;
   procedure Set_Cloned_Subtype (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Class_Wide_Subtype_Id
         | E_Record_Subtype_Id;

   function Component_Alignment (N : Entity_Id) return Component_Alignment_Kind with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Component_Alignment (N : Entity_Id; Val : Component_Alignment_Kind) with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Component_Bit_Offset (N : Record_Field_Kind_Id) return Uint with Inline;
   procedure Set_Component_Bit_Offset (N : Record_Field_Kind_Id; Val : Uint) with Inline;

   function Component_Clause (N : Record_Field_Kind_Id) return Node_Id with Inline;
   procedure Set_Component_Clause (N : Record_Field_Kind_Id; Val : Node_Id) with Inline;

   function Component_Size (N : Array_Kind_Id) return Uint with Inline;
   procedure Set_Component_Size (N : Array_Kind_Id; Val : Uint) with Inline;

   function Component_Type (N : Array_Kind_Id) return Node_Id with Inline;
   procedure Set_Component_Type (N : Array_Kind_Id; Val : Node_Id) with Inline;

   function Contract (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Task_Body_Id
         | E_Subprogram_Body_Id;
   procedure Set_Contract (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Task_Body_Id
         | E_Subprogram_Body_Id;

   function Contract_Wrapper (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Contract_Wrapper (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Entry_Id
         | E_Entry_Family_Id;

   function Corresponding_Concurrent_Type (N : E_Record_Type_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Concurrent_Type (N : E_Record_Type_Id; Val : Node_Id) with Inline;

   function Corresponding_Discriminant (N : E_Discriminant_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Discriminant (N : E_Discriminant_Id; Val : Node_Id) with Inline;

   function Corresponding_Equality (N : E_Function_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Equality (N : E_Function_Id; Val : Node_Id) with Inline;

   function Corresponding_Function (N : E_Procedure_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Function (N : E_Procedure_Id; Val : Node_Id) with Inline;

   function Corresponding_Procedure (N : E_Function_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Procedure (N : E_Function_Id; Val : Node_Id) with Inline;

   function Corresponding_Record_Component (N : Record_Field_Kind_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Record_Component (N : Record_Field_Kind_Id; Val : Node_Id) with Inline;

   function Corresponding_Record_Type (N : Concurrent_Kind_Id) return Node_Id with Inline;
   procedure Set_Corresponding_Record_Type (N : Concurrent_Kind_Id; Val : Node_Id) with Inline;

   function Corresponding_Remote_Type (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Class_Wide_Type_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Corresponding_Remote_Type (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Class_Wide_Type_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function CR_Discriminant (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Discriminant_Id;
   procedure Set_CR_Discriminant (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Discriminant_Id;

   function Current_Use_Clause (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Type_Kind_Id
         | E_Package_Id;
   procedure Set_Current_Use_Clause (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Type_Kind_Id
         | E_Package_Id;

   function Current_Value (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Object_Kind_Id;
   procedure Set_Current_Value (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Object_Kind_Id;

   function Debug_Info_Off (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Debug_Info_Off (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Debug_Renaming_Link (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Variable_Id;
   procedure Set_Debug_Renaming_Link (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Variable_Id;

   function Default_Aspect_Component_Value (N : Array_Kind_Id) return Node_Id with Inline;
   procedure Set_Default_Aspect_Component_Value (N : Array_Kind_Id; Val : Node_Id) with Inline;

   function Default_Aspect_Value (N : Scalar_Kind_Id) return Node_Id with Inline;
   procedure Set_Default_Aspect_Value (N : Scalar_Kind_Id; Val : Node_Id) with Inline;

   function Default_Expr_Function (N : Formal_Kind_Id) return Node_Id with Inline;
   procedure Set_Default_Expr_Function (N : Formal_Kind_Id; Val : Node_Id) with Inline;

   function Default_Expressions_Processed (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Default_Expressions_Processed (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Default_Value (N : Formal_Kind_Id) return Node_Id with Inline;
   procedure Set_Default_Value (N : Formal_Kind_Id; Val : Node_Id) with Inline;

   function Delay_Cleanups (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Delay_Cleanups (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Delay_Subprogram_Descriptors (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Delay_Subprogram_Descriptors (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Delta_Value (N : Fixed_Point_Kind_Id) return Ureal with Inline;
   procedure Set_Delta_Value (N : Fixed_Point_Kind_Id; Val : Ureal) with Inline;

   function Dependent_Instances (N : E_Package_Id) return Elist_Id with Inline;
   procedure Set_Dependent_Instances (N : E_Package_Id; Val : Elist_Id) with Inline;

   function Depends_On_Private (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Depends_On_Private (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Derived_Type_Link (N : Type_Kind_Id) return Node_Id with Inline;
   procedure Set_Derived_Type_Link (N : Type_Kind_Id; Val : Node_Id) with Inline;

   function Digits_Value (N : Entity_Id) return Upos with Inline, Pre =>
      N in Decimal_Fixed_Point_Kind_Id
         | Float_Kind_Id;
   procedure Set_Digits_Value (N : Entity_Id; Val : Upos) with Inline, Pre =>
      N in Decimal_Fixed_Point_Kind_Id
         | Float_Kind_Id;

   function Predicated_Parent (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Array_Subtype_Id
         | E_Record_Subtype_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Predicated_Parent (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Array_Subtype_Id
         | E_Record_Subtype_Id
         | E_Record_Subtype_With_Private_Id;

   function Predicates_Ignored (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Predicates_Ignored (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Direct_Primitive_Operations (N : Type_Kind_Id) return Elist_Id with Inline;
   procedure Set_Direct_Primitive_Operations (N : Type_Kind_Id; Val : Elist_Id) with Inline;

   function Directly_Designated_Type (N : Access_Kind_Id) return Node_Id with Inline;
   procedure Set_Directly_Designated_Type (N : Access_Kind_Id; Val : Node_Id) with Inline;

   function Disable_Controlled (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Disable_Controlled (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Discard_Names (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Discard_Names (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Discriminal (N : E_Discriminant_Id) return Node_Id with Inline;
   procedure Set_Discriminal (N : E_Discriminant_Id; Val : Node_Id) with Inline;

   function Discriminal_Link (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | E_In_Parameter_Id;
   procedure Set_Discriminal_Link (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | E_In_Parameter_Id;

   function Discriminant_Checking_Func (N : E_Component_Id) return Node_Id with Inline;
   procedure Set_Discriminant_Checking_Func (N : E_Component_Id; Val : Node_Id) with Inline;

   function Discriminant_Constraint (N : Composite_Kind_Id) return Elist_Id with Inline;
   procedure Set_Discriminant_Constraint (N : Composite_Kind_Id; Val : Elist_Id) with Inline;

   function Discriminant_Default_Value (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Discriminant_Id
         | E_In_Parameter_Id;
   procedure Set_Discriminant_Default_Value (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Discriminant_Id
         | E_In_Parameter_Id;

   function Discriminant_Number (N : Entity_Id) return Upos with Inline, Pre =>
      N in E_Void_Id
         | E_Discriminant_Id;
   procedure Set_Discriminant_Number (N : Entity_Id; Val : Upos) with Inline, Pre =>
      N in E_Void_Id
         | E_Discriminant_Id;

   function Dispatch_Table_Wrappers (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id;
   procedure Set_Dispatch_Table_Wrappers (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id;

   function Dynamic_Call_Helper (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Dynamic_Call_Helper (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function DT_Entry_Count (N : E_Component_Id) return Uint with Inline;
   procedure Set_DT_Entry_Count (N : E_Component_Id; Val : Uint) with Inline;

   function DT_Offset_To_Top_Func (N : E_Component_Id) return Node_Id with Inline;
   procedure Set_DT_Offset_To_Top_Func (N : E_Component_Id; Val : Node_Id) with Inline;

   function DT_Position (N : Entity_Id) return Uint with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_DT_Position (N : Entity_Id; Val : Uint) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function DTC_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_DTC_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Elaborate_Body_Desirable (N : E_Package_Id) return Flag with Inline;
   procedure Set_Elaborate_Body_Desirable (N : E_Package_Id; Val : Flag := True) with Inline;

   function Elaboration_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;
   procedure Set_Elaboration_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;

   function Elaboration_Entity_Required (N : Entity_Id) return Flag with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;
   procedure Set_Elaboration_Entity_Required (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;

   function Encapsulating_State (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | E_Abstract_State_Id;
   procedure Set_Encapsulating_State (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | E_Abstract_State_Id;

   function Enclosing_Scope (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Label_Id;
   procedure Set_Enclosing_Scope (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Label_Id;

   function Entry_Accepted (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Entry_Accepted (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Entry_Id
         | E_Entry_Family_Id;

   function Entry_Bodies_Array (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Protected_Kind_Id;
   procedure Set_Entry_Bodies_Array (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Protected_Kind_Id;

   function Entry_Cancel_Parameter (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Block_Id;
   procedure Set_Entry_Cancel_Parameter (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Block_Id;

   function Entry_Component (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Formal_Kind_Id
         | Formal_Object_Kind_Id;
   procedure Set_Entry_Component (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Formal_Kind_Id
         | Formal_Object_Kind_Id;

   function Entry_Formal (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id;
   procedure Set_Entry_Formal (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id;

   function Entry_Index_Constant (N : E_Entry_Index_Parameter_Id) return Node_Id with Inline;
   procedure Set_Entry_Index_Constant (N : E_Entry_Index_Parameter_Id; Val : Node_Id) with Inline;

   function Entry_Max_Queue_Lengths_Array (N : E_Protected_Type_Id) return Node_Id with Inline;
   procedure Set_Entry_Max_Queue_Lengths_Array (N : E_Protected_Type_Id; Val : Node_Id) with Inline;

   function Entry_Parameters_Type (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Entry_Parameters_Type (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;

   function Enum_Pos_To_Rep (N : E_Enumeration_Type_Id) return Node_Id with Inline;
   procedure Set_Enum_Pos_To_Rep (N : E_Enumeration_Type_Id; Val : Node_Id) with Inline;

   function Enumeration_Pos (N : E_Enumeration_Literal_Id) return Unat with Inline;
   procedure Set_Enumeration_Pos (N : E_Enumeration_Literal_Id; Val : Unat) with Inline;

   function Enumeration_Rep (N : E_Enumeration_Literal_Id) return Valid_Uint with Inline;
   procedure Set_Enumeration_Rep (N : E_Enumeration_Literal_Id; Val : Valid_Uint) with Inline;

   function Enumeration_Rep_Expr (N : E_Enumeration_Literal_Id) return Node_Id with Inline;
   procedure Set_Enumeration_Rep_Expr (N : E_Enumeration_Literal_Id; Val : Node_Id) with Inline;

   function Equivalent_Type (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Access_Subprogram_Type_Id
         | Access_Protected_Kind_Id
         | Class_Wide_Kind_Id
         | E_Exception_Type_Id;
   procedure Set_Equivalent_Type (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Access_Subprogram_Type_Id
         | Access_Protected_Kind_Id
         | Class_Wide_Kind_Id
         | E_Exception_Type_Id;

   function Esize (N : Entity_Id) return Uint with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id
         | Allocatable_Kind_Id
         | Formal_Kind_Id
         | Formal_Object_Kind_Id
         | Type_Kind_Id
         | E_Enumeration_Literal_Id
         | E_Exception_Id;
   procedure Set_Esize (N : Entity_Id; Val : Uint) with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id
         | Allocatable_Kind_Id
         | Formal_Kind_Id
         | Formal_Object_Kind_Id
         | Type_Kind_Id
         | E_Enumeration_Literal_Id
         | E_Exception_Id;

   function Extra_Accessibility (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Formal_Kind_Id;
   procedure Set_Extra_Accessibility (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Formal_Kind_Id;

   function Extra_Accessibility_Of_Result (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Subprogram_Type_Id
         | E_Function_Id
         | E_Operator_Id;
   procedure Set_Extra_Accessibility_Of_Result (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Subprogram_Type_Id
         | E_Function_Id
         | E_Operator_Id;

   function Extra_Constrained (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Variable_Id
         | Formal_Kind_Id;
   procedure Set_Extra_Constrained (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Variable_Id
         | Formal_Kind_Id;

   function Extra_Formal (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Formal_Kind_Id;
   procedure Set_Extra_Formal (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Formal_Kind_Id;

   function Extra_Formals (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Subprogram_Type_Id
         | Overloadable_Kind_Id
         | E_Entry_Family_Id
         | E_Subprogram_Body_Id;
   procedure Set_Extra_Formals (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Subprogram_Type_Id
         | Overloadable_Kind_Id
         | E_Entry_Family_Id
         | E_Subprogram_Body_Id;

   function Finalization_Master (N : Access_Kind_Id) return Node_Id with Inline;
   procedure Set_Finalization_Master (N : Access_Kind_Id; Val : Node_Id) with Inline;

   function Finalize_Storage_Only (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Finalize_Storage_Only (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Finalizer (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Package_Id
         | E_Package_Body_Id;
   procedure Set_Finalizer (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Package_Id
         | E_Package_Body_Id;

   function First_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Enumeration_Type_Id
         | Signed_Integer_Kind_Id
         | E_General_Access_Type_Id
         | E_Array_Type_Id
         | E_Array_Subtype_Id
         | Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | Incomplete_Or_Private_Kind_Id
         | Concurrent_Kind_Id
         | E_Subprogram_Type_Id
         | Subprogram_Kind_Id
         | E_Abstract_State_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | Generic_Unit_Kind_Id
         | E_Loop_Id
         | E_Return_Statement_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Task_Body_Id
         | E_Subprogram_Body_Id;
   procedure Set_First_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Enumeration_Type_Id
         | Signed_Integer_Kind_Id
         | E_General_Access_Type_Id
         | E_Array_Type_Id
         | E_Array_Subtype_Id
         | Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | Incomplete_Or_Private_Kind_Id
         | Concurrent_Kind_Id
         | E_Subprogram_Type_Id
         | Subprogram_Kind_Id
         | E_Abstract_State_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | Generic_Unit_Kind_Id
         | E_Loop_Id
         | E_Return_Statement_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Task_Body_Id
         | E_Subprogram_Body_Id;

   function First_Exit_Statement (N : E_Loop_Id) return Node_Id with Inline;
   procedure Set_First_Exit_Statement (N : E_Loop_Id; Val : Node_Id) with Inline;

   function First_Index (N : Array_Kind_Id) return Node_Id with Inline;
   procedure Set_First_Index (N : Array_Kind_Id; Val : Node_Id) with Inline;

   function First_Literal (N : Enumeration_Kind_Id) return Node_Id with Inline;
   procedure Set_First_Literal (N : Enumeration_Kind_Id; Val : Node_Id) with Inline;

   function First_Private_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Concurrent_Kind_Id
         | E_Generic_Package_Id
         | E_Package_Id;
   procedure Set_First_Private_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Concurrent_Kind_Id
         | E_Generic_Package_Id
         | E_Package_Id;

   function First_Rep_Item (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_First_Rep_Item (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in N_Entity_Id;

   function Freeze_Node (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Freeze_Node (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in N_Entity_Id;

   function From_Limited_With (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_From_Limited_With (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Full_View (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Constant_Id
         | Type_Kind_Id;
   procedure Set_Full_View (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Constant_Id
         | Type_Kind_Id;

   function Generic_Homonym (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Generic_Package_Id;
   procedure Set_Generic_Homonym (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Generic_Package_Id;

   function Generic_Renamings (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | E_Package_Id;
   procedure Set_Generic_Renamings (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | E_Package_Id;

   function Handler_Records (N : Entity_Id) return List_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | E_Package_Id
         | E_Package_Body_Id;
   procedure Set_Handler_Records (N : Entity_Id; Val : List_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | E_Package_Id
         | E_Package_Body_Id;

   function Has_Aliased_Components (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Aliased_Components (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Alignment_Clause (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Alignment_Clause (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_All_Calls_Remote (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_All_Calls_Remote (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Atomic_Components (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Atomic_Components (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Biased_Representation (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Biased_Representation (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Completion (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Completion (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Completion_In_Body (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Completion_In_Body (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Complex_Representation (N : Entity_Id) return Flag with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Has_Complex_Representation (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Has_Component_Size_Clause (N : Array_Kind_Id) return Flag with Inline;
   procedure Set_Has_Component_Size_Clause (N : Array_Kind_Id; Val : Flag := True) with Inline;

   function Has_Constrained_Partial_View (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Constrained_Partial_View (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Contiguous_Rep (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Contiguous_Rep (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Controlled_Component (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Controlled_Component (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Controlling_Result (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Controlling_Result (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Convention_Pragma (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Convention_Pragma (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Default_Aspect (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Default_Aspect (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Delayed_Aspects (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Delayed_Aspects (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Delayed_Freeze (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Delayed_Freeze (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Delayed_Rep_Aspects (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Delayed_Rep_Aspects (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Discriminants (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Discriminants (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Dispatch_Table (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Dispatch_Table (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Dynamic_Predicate_Aspect (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Dynamic_Predicate_Aspect (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Enumeration_Rep_Clause (N : Enumeration_Kind_Id) return Flag with Inline;
   procedure Set_Has_Enumeration_Rep_Clause (N : Enumeration_Kind_Id; Val : Flag := True) with Inline;

   function Has_Exit (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Exit (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Expanded_Contract (N : Subprogram_Kind_Id) return Flag with Inline;
   procedure Set_Has_Expanded_Contract (N : Subprogram_Kind_Id; Val : Flag := True) with Inline;

   function Has_Forward_Instantiation (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Forward_Instantiation (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Fully_Qualified_Name (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Fully_Qualified_Name (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Gigi_Rep_Item (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Gigi_Rep_Item (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Homonym (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Homonym (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Implicit_Dereference (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Implicit_Dereference (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Independent_Components (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Independent_Components (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Inheritable_Invariants (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Inheritable_Invariants (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Inherited_DIC (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Inherited_DIC (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Inherited_Invariants (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Inherited_Invariants (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Initial_Value (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Variable_Id
         | Formal_Kind_Id;
   procedure Set_Has_Initial_Value (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Variable_Id
         | Formal_Kind_Id;

   function Has_Loop_Entry_Attributes (N : E_Loop_Id) return Flag with Inline;
   procedure Set_Has_Loop_Entry_Attributes (N : E_Loop_Id; Val : Flag := True) with Inline;

   function Has_Machine_Radix_Clause (N : Decimal_Fixed_Point_Kind_Id) return Flag with Inline;
   procedure Set_Has_Machine_Radix_Clause (N : Decimal_Fixed_Point_Kind_Id; Val : Flag := True) with Inline;

   function Has_Master_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Master_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Missing_Return (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Generic_Function_Id;
   procedure Set_Has_Missing_Return (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Generic_Function_Id;

   function Has_Nested_Block_With_Handler (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Nested_Block_With_Handler (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Nested_Subprogram (N : Subprogram_Kind_Id) return Flag with Inline;
   procedure Set_Has_Nested_Subprogram (N : Subprogram_Kind_Id; Val : Flag := True) with Inline;

   function Has_Non_Standard_Rep (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Non_Standard_Rep (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Object_Size_Clause (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Object_Size_Clause (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Out_Or_In_Out_Parameter (N : Entity_Id) return Flag with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Subprogram_Kind_Id;
   procedure Set_Has_Out_Or_In_Out_Parameter (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Subprogram_Kind_Id;

   function Has_Own_DIC (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Own_DIC (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Own_Invariants (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Own_Invariants (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Partial_Visible_Refinement (N : E_Abstract_State_Id) return Flag with Inline;
   procedure Set_Has_Partial_Visible_Refinement (N : E_Abstract_State_Id; Val : Flag := True) with Inline;

   function Has_Per_Object_Constraint (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Per_Object_Constraint (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Controlled (N : Access_Kind_Id) return Flag with Inline;
   procedure Set_Has_Pragma_Controlled (N : Access_Kind_Id; Val : Flag := True) with Inline;

   function Has_Pragma_Elaborate_Body (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Elaborate_Body (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Inline (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Inline (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Inline_Always (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Inline_Always (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_No_Inline (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_No_Inline (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Ordered (N : Enumeration_Kind_Id) return Flag with Inline;
   procedure Set_Has_Pragma_Ordered (N : Enumeration_Kind_Id; Val : Flag := True) with Inline;

   function Has_Pragma_Pack (N : Entity_Id) return Flag with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Has_Pragma_Pack (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Has_Pragma_Preelab_Init (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Preelab_Init (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Pure (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Pure (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Pure_Function (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Pure_Function (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Thread_Local_Storage (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Thread_Local_Storage (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Unmodified (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Unmodified (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Unreferenced (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Unreferenced (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Pragma_Unreferenced_Objects (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Pragma_Unreferenced_Objects (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Pragma_Unused (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Pragma_Unused (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Predicates (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id;
   procedure Set_Has_Predicates (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id;

   function Has_Primitive_Operations (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Primitive_Operations (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Private_Ancestor (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Private_Ancestor (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Private_Declaration (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Private_Declaration (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Private_Extension (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Private_Extension (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Protected (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Protected (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Qualified_Name (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Qualified_Name (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_RACW (N : E_Package_Id) return Flag with Inline;
   procedure Set_Has_RACW (N : E_Package_Id; Val : Flag := True) with Inline;

   function Has_Record_Rep_Clause (N : Entity_Id) return Flag with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Has_Record_Rep_Clause (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Has_Recursive_Call (N : Subprogram_Kind_Id) return Flag with Inline;
   procedure Set_Has_Recursive_Call (N : Subprogram_Kind_Id; Val : Flag := True) with Inline;

   function Has_Shift_Operator (N : Integer_Kind_Id) return Flag with Inline;
   procedure Set_Has_Shift_Operator (N : Integer_Kind_Id; Val : Flag := True) with Inline;

   function Has_Size_Clause (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Size_Clause (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Small_Clause (N : Ordinary_Fixed_Point_Kind_Id) return Flag with Inline;
   procedure Set_Has_Small_Clause (N : Ordinary_Fixed_Point_Kind_Id; Val : Flag := True) with Inline;

   function Has_Specified_Layout (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Specified_Layout (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Specified_Stream_Input (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Specified_Stream_Input (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Specified_Stream_Output (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Specified_Stream_Output (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Specified_Stream_Read (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Specified_Stream_Read (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Specified_Stream_Write (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Specified_Stream_Write (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Static_Discriminants (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id;
   procedure Set_Has_Static_Discriminants (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id;

   function Has_Static_Predicate (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Static_Predicate (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Static_Predicate_Aspect (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Static_Predicate_Aspect (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Storage_Size_Clause (N : Entity_Id) return Flag with Inline, Pre =>
      N in Access_Kind_Id
         | Task_Kind_Id;
   procedure Set_Has_Storage_Size_Clause (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Access_Kind_Id
         | Task_Kind_Id;

   function Has_Stream_Size_Clause (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Stream_Size_Clause (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Task (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Task (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Timing_Event (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Timing_Event (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Thunks (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Thunks (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Unchecked_Union (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Unchecked_Union (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Unknown_Discriminants (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Has_Unknown_Discriminants (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Has_Visible_Refinement (N : E_Abstract_State_Id) return Flag with Inline;
   procedure Set_Has_Visible_Refinement (N : E_Abstract_State_Id; Val : Flag := True) with Inline;

   function Has_Volatile_Components (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Volatile_Components (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Xref_Entry (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Xref_Entry (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Has_Yield_Aspect (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Has_Yield_Aspect (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Hiding_Loop_Variable (N : E_Variable_Id) return Node_Id with Inline;
   procedure Set_Hiding_Loop_Variable (N : E_Variable_Id; Val : Node_Id) with Inline;

   function Hidden_In_Formal_Instance (N : E_Package_Id) return Elist_Id with Inline;
   procedure Set_Hidden_In_Formal_Instance (N : E_Package_Id; Val : Elist_Id) with Inline;

   function Homonym (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Homonym (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in N_Entity_Id;

   function Ignored_Class_Postconditions (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Ignored_Class_Postconditions (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Ignored_Class_Preconditions (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Ignored_Class_Preconditions (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Ignore_SPARK_Mode_Pragmas (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | Concurrent_Body_Kind_Id
         | E_Subprogram_Body_Id;
   procedure Set_Ignore_SPARK_Mode_Pragmas (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | Concurrent_Body_Kind_Id
         | E_Subprogram_Body_Id;

   function Import_Pragma (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Import_Pragma (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Incomplete_Actuals (N : E_Package_Id) return Elist_Id with Inline;
   procedure Set_Incomplete_Actuals (N : E_Package_Id; Val : Elist_Id) with Inline;

   function Indirect_Call_Wrapper (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Indirect_Call_Wrapper (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function In_Package_Body (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_In_Package_Body (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function In_Private_Part (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_In_Private_Part (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function In_Use (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_In_Use (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Initialization_Statements (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id;
   procedure Set_Initialization_Statements (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id;

   function Inner_Instances (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;
   procedure Set_Inner_Instances (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;

   function Interface_Alias (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Interface_Alias (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Interface_Name (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id
         | Allocatable_Kind_Id
         | Type_Kind_Id
         | E_Enumeration_Literal_Id
         | Subprogram_Kind_Id
         | E_Exception_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Subprogram_Body_Id;
   procedure Set_Interface_Name (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id
         | Allocatable_Kind_Id
         | Type_Kind_Id
         | E_Enumeration_Literal_Id
         | Subprogram_Kind_Id
         | E_Exception_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Subprogram_Body_Id;

   function Interfaces (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Interfaces (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Is_Abstract_Subprogram (N : Overloadable_Kind_Id) return Flag with Inline;
   procedure Set_Is_Abstract_Subprogram (N : Overloadable_Kind_Id; Val : Flag := True) with Inline;

   function Is_Abstract_Type (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Abstract_Type (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Access_Constant (N : Access_Kind_Id) return Flag with Inline;
   procedure Set_Is_Access_Constant (N : Access_Kind_Id; Val : Flag := True) with Inline;

   function Is_Activation_Record (N : E_In_Parameter_Id) return Flag with Inline;
   procedure Set_Is_Activation_Record (N : E_In_Parameter_Id; Val : Flag := True) with Inline;

   function Is_Actual_Subtype (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Actual_Subtype (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Ada_2005_Only (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Ada_2005_Only (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Ada_2012_Only (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Ada_2012_Only (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Ada_2022_Only (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Ada_2022_Only (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Aliased (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Aliased (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Asynchronous (N : Entity_Id) return Flag with Inline, Pre =>
      N in Type_Kind_Id
         | E_Procedure_Id;
   procedure Set_Is_Asynchronous (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Type_Kind_Id
         | E_Procedure_Id;

   function Is_Atomic (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Atomic (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Bit_Packed_Array (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Bit_Packed_Array (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Called (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Package_Id;
   procedure Set_Is_Called (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Package_Id;

   function Is_Character_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Character_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Checked_Ghost_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Checked_Ghost_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Child_Unit (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Child_Unit (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Class_Wide_Equivalent_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Class_Wide_Equivalent_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Class_Wide_Wrapper (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Class_Wide_Wrapper (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Compilation_Unit (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Compilation_Unit (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Completely_Hidden (N : E_Discriminant_Id) return Flag with Inline;
   procedure Set_Is_Completely_Hidden (N : E_Discriminant_Id; Val : Flag := True) with Inline;

   function Is_Concurrent_Record_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Concurrent_Record_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Constr_Subt_For_U_Nominal (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Constr_Subt_For_U_Nominal (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Constr_Subt_For_UN_Aliased (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Constr_Subt_For_UN_Aliased (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Constrained (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Constrained (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Constructor (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Constructor (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Controlled_Active (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Controlled_Active (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Controlling_Formal (N : Formal_Kind_Id) return Flag with Inline;
   procedure Set_Is_Controlling_Formal (N : Formal_Kind_Id; Val : Flag := True) with Inline;

   function Is_CPP_Class (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_CPP_Class (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_CUDA_Kernel (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_CUDA_Kernel (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Descendant_Of_Address (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Descendant_Of_Address (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_DIC_Procedure (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_DIC_Procedure (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Discrim_SO_Function (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Discrim_SO_Function (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Discriminant_Check_Function (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Discriminant_Check_Function (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Dispatch_Table_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Dispatch_Table_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Dispatch_Table_Wrapper (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Dispatch_Table_Wrapper (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Dispatching_Operation (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Dispatching_Operation (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Elaboration_Checks_OK_Id (N : Entity_Id) return Flag with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Task_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;
   procedure Set_Is_Elaboration_Checks_OK_Id (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Task_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;

   function Is_Elaboration_Warnings_OK_Id (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Task_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;
   procedure Set_Is_Elaboration_Warnings_OK_Id (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Task_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id;

   function Is_Eliminated (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Eliminated (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Entry_Formal (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Entry_Formal (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Entry_Wrapper (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Entry_Wrapper (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Exception_Handler (N : E_Block_Id) return Flag with Inline;
   procedure Set_Is_Exception_Handler (N : E_Block_Id; Val : Flag := True) with Inline;

   function Is_Exported (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Exported (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Finalized_Transient (N : Allocatable_Kind_Id) return Flag with Inline;
   procedure Set_Is_Finalized_Transient (N : Allocatable_Kind_Id; Val : Flag := True) with Inline;

   function Is_First_Subtype (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_First_Subtype (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Fixed_Lower_Bound_Array_Subtype (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Fixed_Lower_Bound_Array_Subtype (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Fixed_Lower_Bound_Index_Subtype (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Fixed_Lower_Bound_Index_Subtype (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Formal_Subprogram (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Formal_Subprogram (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Frozen (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Frozen (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Generic_Actual_Subprogram (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Generic_Actual_Subprogram (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Generic_Actual_Type (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Generic_Actual_Type (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Generic_Instance (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Generic_Instance (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Generic_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Generic_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Hidden (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Hidden (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Hidden_Non_Overridden_Subpgm (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Hidden_Non_Overridden_Subpgm (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Hidden_Open_Scope (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Hidden_Open_Scope (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Ignored_Ghost_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Ignored_Ghost_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Ignored_Transient (N : Allocatable_Kind_Id) return Flag with Inline;
   procedure Set_Is_Ignored_Transient (N : Allocatable_Kind_Id; Val : Flag := True) with Inline;

   function Is_Immediately_Visible (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Immediately_Visible (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Implementation_Defined (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Implementation_Defined (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Imported (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Imported (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Independent (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Independent (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Initial_Condition_Procedure (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Initial_Condition_Procedure (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Inlined (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Inlined (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Inlined_Always (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Inlined_Always (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Instantiated (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Instantiated (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Interface (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Interface (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Internal (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Internal (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Interrupt_Handler (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Interrupt_Handler (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Intrinsic_Subprogram (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Intrinsic_Subprogram (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Invariant_Procedure (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Invariant_Procedure (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Itype (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Itype (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Known_Non_Null (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Known_Non_Null (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Known_Null (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Known_Null (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Known_Valid (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Known_Valid (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Limited_Composite (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Limited_Composite (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Limited_Interface (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Limited_Interface (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Limited_Record (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Limited_Record (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Local_Anonymous_Access (N : Access_Kind_Id) return Flag with Inline;
   procedure Set_Is_Local_Anonymous_Access (N : Access_Kind_Id; Val : Flag := True) with Inline;

   function Is_Loop_Parameter (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Loop_Parameter (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Machine_Code_Subprogram (N : Subprogram_Kind_Id) return Flag with Inline;
   procedure Set_Is_Machine_Code_Subprogram (N : Subprogram_Kind_Id; Val : Flag := True) with Inline;

   function Is_Non_Static_Subtype (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Non_Static_Subtype (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Null_Init_Proc (N : E_Procedure_Id) return Flag with Inline;
   procedure Set_Is_Null_Init_Proc (N : E_Procedure_Id; Val : Flag := True) with Inline;

   function Is_Obsolescent (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Obsolescent (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Only_Out_Parameter (N : Formal_Kind_Id) return Flag with Inline;
   procedure Set_Is_Only_Out_Parameter (N : Formal_Kind_Id; Val : Flag := True) with Inline;

   function Is_Package_Body_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Package_Body_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Packed (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Packed (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Packed_Array_Impl_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Packed_Array_Impl_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Param_Block_Component_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Void_Id
         | Access_Kind_Id;
   procedure Set_Is_Param_Block_Component_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Void_Id
         | Access_Kind_Id;

   function Is_Partial_Invariant_Procedure (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Partial_Invariant_Procedure (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Potentially_Use_Visible (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Potentially_Use_Visible (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Predicate_Function (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Predicate_Function (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Preelaborated (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Preelaborated (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Primitive (N : Entity_Id) return Flag with Inline, Pre =>
      N in Overloadable_Kind_Id
         | Generic_Subprogram_Kind_Id;
   procedure Set_Is_Primitive (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Overloadable_Kind_Id
         | Generic_Subprogram_Kind_Id;

   function Is_Primitive_Wrapper (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Primitive_Wrapper (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Private_Composite (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Private_Composite (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Private_Descendant (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Private_Descendant (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Private_Primitive (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Is_Private_Primitive (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Is_Public (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Public (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Pure (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Pure (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Pure_Unit_Access_Type (N : Access_Kind_Id) return Flag with Inline;
   procedure Set_Is_Pure_Unit_Access_Type (N : Access_Kind_Id; Val : Flag := True) with Inline;

   function Is_RACW_Stub_Type (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_RACW_Stub_Type (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Raised (N : E_Exception_Id) return Flag with Inline;
   procedure Set_Is_Raised (N : E_Exception_Id; Val : Flag := True) with Inline;

   function Is_Remote_Call_Interface (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Remote_Call_Interface (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Remote_Types (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Remote_Types (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Renaming_Of_Object (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Renaming_Of_Object (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Return_Object (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Return_Object (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Safe_To_Reevaluate (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Safe_To_Reevaluate (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Shared_Passive (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Shared_Passive (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Static_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Static_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Statically_Allocated (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Statically_Allocated (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Tag (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Tag (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Tagged_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Tagged_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Thunk (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Thunk (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Trivial_Subprogram (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Trivial_Subprogram (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_True_Constant (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_True_Constant (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Unchecked_Union (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Unchecked_Union (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Underlying_Full_View (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Underlying_Full_View (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Underlying_Record_View (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Underlying_Record_View (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Unimplemented (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Unimplemented (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Unsigned_Type (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Is_Unsigned_Type (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Is_Uplevel_Referenced_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Uplevel_Referenced_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Valued_Procedure (N : E_Procedure_Id) return Flag with Inline;
   procedure Set_Is_Valued_Procedure (N : E_Procedure_Id; Val : Flag := True) with Inline;

   function Is_Visible_Formal (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Visible_Formal (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Visible_Lib_Unit (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Visible_Lib_Unit (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Volatile_Type (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Volatile_Type (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Volatile_Object (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Volatile_Object (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Volatile_Full_Access (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Volatile_Full_Access (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Is_Wrapper (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Is_Wrapper (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Itype_Printed (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Itype_Printed (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Kill_Elaboration_Checks (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Kill_Elaboration_Checks (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Kill_Range_Checks (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Kill_Range_Checks (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Known_To_Have_Preelab_Init (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Known_To_Have_Preelab_Init (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Last_Aggregate_Assignment (N : Constant_Or_Variable_Kind_Id) return Node_Id with Inline;
   procedure Set_Last_Aggregate_Assignment (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) with Inline;

   function Last_Assignment (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Variable_Id
         | E_Out_Parameter_Id
         | E_In_Out_Parameter_Id;
   procedure Set_Last_Assignment (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Variable_Id
         | E_Out_Parameter_Id
         | E_In_Out_Parameter_Id;

   function Last_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | Incomplete_Or_Private_Kind_Id
         | Concurrent_Kind_Id
         | E_Subprogram_Type_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | Generic_Unit_Kind_Id
         | E_Loop_Id
         | E_Return_Statement_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Subprogram_Body_Id;
   procedure Set_Last_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | Incomplete_Or_Private_Kind_Id
         | Concurrent_Kind_Id
         | E_Subprogram_Type_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | Generic_Unit_Kind_Id
         | E_Loop_Id
         | E_Return_Statement_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Subprogram_Body_Id;

   function Limited_View (N : E_Package_Id) return Node_Id with Inline;
   procedure Set_Limited_View (N : E_Package_Id; Val : Node_Id) with Inline;

   function Linker_Section_Pragma (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Allocatable_Kind_Id
         | Formal_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id;
   procedure Set_Linker_Section_Pragma (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Allocatable_Kind_Id
         | Formal_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id;

   function Lit_Hash (N : Enumeration_Kind_Id) return Node_Id with Inline;
   procedure Set_Lit_Hash (N : Enumeration_Kind_Id; Val : Node_Id) with Inline;

   function Lit_Indexes (N : Enumeration_Kind_Id) return Node_Id with Inline;
   procedure Set_Lit_Indexes (N : Enumeration_Kind_Id; Val : Node_Id) with Inline;

   function Lit_Strings (N : Enumeration_Kind_Id) return Node_Id with Inline;
   procedure Set_Lit_Strings (N : Enumeration_Kind_Id; Val : Node_Id) with Inline;

   function Low_Bound_Tested (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Low_Bound_Tested (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function LSP_Subprogram (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Operator_Id
         | E_Procedure_Id;
   procedure Set_LSP_Subprogram (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Operator_Id
         | E_Procedure_Id;

   function Machine_Radix_10 (N : Decimal_Fixed_Point_Kind_Id) return Flag with Inline;
   procedure Set_Machine_Radix_10 (N : Decimal_Fixed_Point_Kind_Id; Val : Flag := True) with Inline;

   function Master_Id (N : Access_Kind_Id) return Node_Id with Inline;
   procedure Set_Master_Id (N : Access_Kind_Id; Val : Node_Id) with Inline;

   function Materialize_Entity (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Materialize_Entity (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function May_Inherit_Delayed_Rep_Aspects (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_May_Inherit_Delayed_Rep_Aspects (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Mechanism (N : Entity_Id) return Mechanism_Type with Inline, Pre =>
      N in Formal_Kind_Id
         | E_Function_Id;
   procedure Set_Mechanism (N : Entity_Id; Val : Mechanism_Type) with Inline, Pre =>
      N in Formal_Kind_Id
         | E_Function_Id;

   function Minimum_Accessibility (N : Formal_Kind_Id) return Node_Id with Inline;
   procedure Set_Minimum_Accessibility (N : Formal_Kind_Id; Val : Node_Id) with Inline;

   function Modulus (N : Modular_Integer_Kind_Id) return Uint with Inline;
   procedure Set_Modulus (N : Modular_Integer_Kind_Id; Val : Uint) with Inline;

   function Must_Be_On_Byte_Boundary (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Must_Be_On_Byte_Boundary (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Must_Have_Preelab_Init (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Must_Have_Preelab_Init (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Needs_Activation_Record (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Needs_Activation_Record (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Needs_Debug_Info (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Needs_Debug_Info (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Needs_No_Actuals (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Subprogram_Type_Id
         | Overloadable_Kind_Id
         | E_Entry_Family_Id;
   procedure Set_Needs_No_Actuals (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Subprogram_Type_Id
         | Overloadable_Kind_Id
         | E_Entry_Family_Id;

   function Never_Set_In_Source (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Never_Set_In_Source (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Next_Inlined_Subprogram (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | Generic_Subprogram_Kind_Id;
   procedure Set_Next_Inlined_Subprogram (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Function_Id
         | E_Procedure_Id
         | Generic_Subprogram_Kind_Id;

   function No_Dynamic_Predicate_On_Actual (N : Discrete_Kind_Id) return Flag with Inline;
   procedure Set_No_Dynamic_Predicate_On_Actual (N : Discrete_Kind_Id; Val : Flag := True) with Inline;

   function No_Pool_Assigned (N : Access_Kind_Id) return Flag with Inline;
   procedure Set_No_Pool_Assigned (N : Access_Kind_Id; Val : Flag := True) with Inline;

   function No_Predicate_On_Actual (N : Discrete_Kind_Id) return Flag with Inline;
   procedure Set_No_Predicate_On_Actual (N : Discrete_Kind_Id; Val : Flag := True) with Inline;

   function No_Reordering (N : Entity_Id) return Flag with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_No_Reordering (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function No_Return (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_No_Return (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function No_Strict_Aliasing (N : Access_Kind_Id) return Flag with Inline;
   procedure Set_No_Strict_Aliasing (N : Access_Kind_Id; Val : Flag := True) with Inline;

   function No_Tagged_Streams_Pragma (N : Type_Kind_Id) return Node_Id with Inline;
   procedure Set_No_Tagged_Streams_Pragma (N : Type_Kind_Id; Val : Node_Id) with Inline;

   function Non_Binary_Modulus (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Non_Binary_Modulus (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Non_Limited_View (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | Incomplete_Kind_Id
         | E_Abstract_State_Id;
   procedure Set_Non_Limited_View (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | Incomplete_Kind_Id
         | E_Abstract_State_Id;

   function Nonzero_Is_True (N : Enumeration_Kind_Id) return Flag with Inline;
   procedure Set_Nonzero_Is_True (N : Enumeration_Kind_Id; Val : Flag := True) with Inline;

   function Normalized_First_Bit (N : Record_Field_Kind_Id) return Uint with Inline;
   procedure Set_Normalized_First_Bit (N : Record_Field_Kind_Id; Val : Uint) with Inline;

   function Normalized_Position (N : Record_Field_Kind_Id) return Uint with Inline;
   procedure Set_Normalized_Position (N : Record_Field_Kind_Id; Val : Uint) with Inline;

   function OK_To_Rename (N : E_Variable_Id) return Flag with Inline;
   procedure Set_OK_To_Rename (N : E_Variable_Id; Val : Flag := True) with Inline;

   function Optimize_Alignment_Space (N : Entity_Id) return Flag with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Type_Kind_Id;
   procedure Set_Optimize_Alignment_Space (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Type_Kind_Id;

   function Optimize_Alignment_Time (N : Entity_Id) return Flag with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Type_Kind_Id;
   procedure Set_Optimize_Alignment_Time (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Constant_Or_Variable_Kind_Id
         | Type_Kind_Id;

   function Original_Access_Type (N : E_Access_Subprogram_Type_Id) return Node_Id with Inline;
   procedure Set_Original_Access_Type (N : E_Access_Subprogram_Type_Id; Val : Node_Id) with Inline;

   function Original_Array_Type (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Modular_Integer_Kind_Id
         | Array_Kind_Id;
   procedure Set_Original_Array_Type (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Modular_Integer_Kind_Id
         | Array_Kind_Id;

   function Original_Protected_Subprogram (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Original_Protected_Subprogram (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Original_Record_Component (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id;
   procedure Set_Original_Record_Component (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Record_Field_Kind_Id;

   function Overlays_Constant (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Overlays_Constant (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Overridden_Operation (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Subprogram_Kind_Id
         | Generic_Subprogram_Kind_Id;
   procedure Set_Overridden_Operation (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Subprogram_Kind_Id
         | Generic_Subprogram_Kind_Id;

   function Package_Instantiation (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Generic_Package_Id
         | E_Package_Id;
   procedure Set_Package_Instantiation (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Generic_Package_Id
         | E_Package_Id;

   function Packed_Array_Impl_Type (N : Array_Kind_Id) return Node_Id with Inline;
   procedure Set_Packed_Array_Impl_Type (N : Array_Kind_Id; Val : Node_Id) with Inline;

   function Parent_Subtype (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Parent_Subtype (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Part_Of_Constituents (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in E_Variable_Id
         | E_Abstract_State_Id;
   procedure Set_Part_Of_Constituents (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in E_Variable_Id
         | E_Abstract_State_Id;

   function Part_Of_References (N : E_Variable_Id) return Elist_Id with Inline;
   procedure Set_Part_Of_References (N : E_Variable_Id; Val : Elist_Id) with Inline;

   function Partial_View_Has_Unknown_Discr (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Partial_View_Has_Unknown_Discr (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Pending_Access_Types (N : Type_Kind_Id) return Elist_Id with Inline;
   procedure Set_Pending_Access_Types (N : Type_Kind_Id; Val : Elist_Id) with Inline;

   function Postconditions_Proc (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Postconditions_Proc (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;

   function Predicate_Expression (N : E_Function_Id) return Node_Id with Inline;
   procedure Set_Predicate_Expression (N : E_Function_Id; Val : Node_Id) with Inline;

   function Prev_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Prev_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in N_Entity_Id;

   function Prival (N : E_Component_Id) return Node_Id with Inline;
   procedure Set_Prival (N : E_Component_Id; Val : Node_Id) with Inline;

   function Prival_Link (N : Constant_Or_Variable_Kind_Id) return Node_Id with Inline;
   procedure Set_Prival_Link (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) with Inline;

   function Private_Dependents (N : Incomplete_Or_Private_Kind_Id) return Elist_Id with Inline;
   procedure Set_Private_Dependents (N : Incomplete_Or_Private_Kind_Id; Val : Elist_Id) with Inline;

   function Protected_Body_Subprogram (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Protected_Body_Subprogram (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id;

   function Protected_Formal (N : Formal_Kind_Id) return Node_Id with Inline;
   procedure Set_Protected_Formal (N : Formal_Kind_Id; Val : Node_Id) with Inline;

   function Protected_Subprogram (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Protected_Subprogram (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Protection_Object (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Protection_Object (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;

   function Reachable (N : E_Label_Id) return Flag with Inline;
   procedure Set_Reachable (N : E_Label_Id; Val : Flag := True) with Inline;

   function Receiving_Entry (N : E_Procedure_Id) return Node_Id with Inline;
   procedure Set_Receiving_Entry (N : E_Procedure_Id; Val : Node_Id) with Inline;

   function Referenced (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Referenced (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Referenced_As_LHS (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Referenced_As_LHS (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Referenced_As_Out_Parameter (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Referenced_As_Out_Parameter (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Refinement_Constituents (N : E_Abstract_State_Id) return Elist_Id with Inline;
   procedure Set_Refinement_Constituents (N : E_Abstract_State_Id; Val : Elist_Id) with Inline;

   function Register_Exception_Call (N : E_Exception_Id) return Node_Id with Inline;
   procedure Set_Register_Exception_Call (N : E_Exception_Id; Val : Node_Id) with Inline;

   function Related_Array_Object (N : Array_Kind_Id) return Node_Id with Inline;
   procedure Set_Related_Array_Object (N : Array_Kind_Id; Val : Node_Id) with Inline;

   function Related_Expression (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Allocatable_Kind_Id
         | Type_Kind_Id
         | E_Function_Id;
   procedure Set_Related_Expression (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Allocatable_Kind_Id
         | Type_Kind_Id
         | E_Function_Id;

   function Related_Instance (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Package_Id
         | E_Package_Body_Id;
   procedure Set_Related_Instance (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Package_Id
         | E_Package_Body_Id;

   function Related_Type (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Component_Id
         | Constant_Or_Variable_Kind_Id;
   procedure Set_Related_Type (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Component_Id
         | Constant_Or_Variable_Kind_Id;

   function Relative_Deadline_Variable (N : Task_Kind_Id) return Node_Id with Inline;
   procedure Set_Relative_Deadline_Variable (N : Task_Kind_Id; Val : Node_Id) with Inline;

   function Renamed_In_Spec (N : E_Package_Id) return Flag with Inline;
   procedure Set_Renamed_In_Spec (N : E_Package_Id; Val : Flag := True) with Inline;

   function Renamed_Or_Alias (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Object_Kind_Id
         | Named_Kind_Id
         | Type_Kind_Id
         | Overloadable_Kind_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | E_Exception_Id
         | Generic_Unit_Kind_Id
         | E_Label_Id
         | E_Loop_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Subprogram_Body_Id;
   procedure Set_Renamed_Or_Alias (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Object_Kind_Id
         | Named_Kind_Id
         | Type_Kind_Id
         | Overloadable_Kind_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | E_Exception_Id
         | Generic_Unit_Kind_Id
         | E_Label_Id
         | E_Loop_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Subprogram_Body_Id;

   function Requires_Overriding (N : Overloadable_Kind_Id) return Flag with Inline;
   procedure Set_Requires_Overriding (N : Overloadable_Kind_Id; Val : Flag := True) with Inline;

   function Return_Applies_To (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Block_Id
         | E_Return_Statement_Id;
   procedure Set_Return_Applies_To (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Block_Id
         | E_Return_Statement_Id;

   function Return_Present (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Return_Present (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Return_Statement (N : Constant_Or_Variable_Kind_Id) return Node_Id with Inline;
   procedure Set_Return_Statement (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) with Inline;

   function Returns_By_Ref (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Returns_By_Ref (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Reverse_Bit_Order (N : Entity_Id) return Flag with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Reverse_Bit_Order (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Reverse_Storage_Order (N : Entity_Id) return Flag with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_Reverse_Storage_Order (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Rewritten_For_C (N : E_Function_Id) return Flag with Inline;
   procedure Set_Rewritten_For_C (N : E_Function_Id; Val : Flag := True) with Inline;

   function RM_Size (N : Entity_Id) return Uint with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id;
   procedure Set_RM_Size (N : Entity_Id; Val : Uint) with Inline, Pre =>
      N in E_Void_Id
         | Type_Kind_Id;

   function Scalar_Range (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Scalar_Kind_Id
         | E_Class_Wide_Type_Id
         | E_Private_Type_Id
         | E_Limited_Private_Type_Id
         | E_Incomplete_Type_Id;
   procedure Set_Scalar_Range (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Scalar_Kind_Id
         | E_Class_Wide_Type_Id
         | E_Private_Type_Id
         | E_Limited_Private_Type_Id
         | E_Incomplete_Type_Id;

   function Scale_Value (N : Entity_Id) return Uint with Inline, Pre =>
      N in E_Void_Id
         | Decimal_Fixed_Point_Kind_Id;
   procedure Set_Scale_Value (N : Entity_Id; Val : Uint) with Inline, Pre =>
      N in E_Void_Id
         | Decimal_Fixed_Point_Kind_Id;

   function Scope_Depth_Value (N : Entity_Id) return Unat with Inline, Pre =>
      N in E_Void_Id
         | E_Private_Type_Id
         | E_Private_Subtype_Id
         | E_Limited_Private_Type_Id
         | E_Limited_Private_Subtype_Id
         | Concurrent_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | Generic_Unit_Kind_Id
         | E_Loop_Id
         | E_Return_Statement_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Subprogram_Body_Id;
   procedure Set_Scope_Depth_Value (N : Entity_Id; Val : Unat) with Inline, Pre =>
      N in E_Void_Id
         | E_Private_Type_Id
         | E_Private_Subtype_Id
         | E_Limited_Private_Type_Id
         | E_Limited_Private_Subtype_Id
         | Concurrent_Kind_Id
         | Subprogram_Kind_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | E_Block_Id
         | Generic_Unit_Kind_Id
         | E_Loop_Id
         | E_Return_Statement_Id
         | E_Package_Id
         | E_Package_Body_Id
         | E_Subprogram_Body_Id;

   function Sec_Stack_Needed_For_Return (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Sec_Stack_Needed_For_Return (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Shared_Var_Procs_Instance (N : E_Variable_Id) return Node_Id with Inline;
   procedure Set_Shared_Var_Procs_Instance (N : E_Variable_Id; Val : Node_Id) with Inline;

   function Size_Check_Code (N : Constant_Or_Variable_Kind_Id) return Node_Id with Inline;
   procedure Set_Size_Check_Code (N : Constant_Or_Variable_Kind_Id; Val : Node_Id) with Inline;

   function Size_Depends_On_Discriminant (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Size_Depends_On_Discriminant (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Size_Known_At_Compile_Time (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Size_Known_At_Compile_Time (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Small_Value (N : Fixed_Point_Kind_Id) return Ureal with Inline;
   procedure Set_Small_Value (N : Fixed_Point_Kind_Id; Val : Ureal) with Inline;

   function SPARK_Aux_Pragma (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id
         | E_Generic_Package_Id
         | E_Package_Id
         | E_Package_Body_Id;
   procedure Set_SPARK_Aux_Pragma (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id
         | E_Generic_Package_Id
         | E_Package_Id
         | E_Package_Body_Id;

   function SPARK_Aux_Pragma_Inherited (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id
         | E_Generic_Package_Id
         | E_Package_Id
         | E_Package_Body_Id;
   procedure Set_SPARK_Aux_Pragma_Inherited (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Task_Type_Id
         | E_Protected_Type_Id
         | E_Generic_Package_Id
         | E_Package_Id
         | E_Package_Body_Id;

   function SPARK_Pragma (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id
         | E_Abstract_State_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | Concurrent_Body_Kind_Id
         | E_Subprogram_Body_Id;
   procedure Set_SPARK_Pragma (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id
         | E_Abstract_State_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | Concurrent_Body_Kind_Id
         | E_Subprogram_Body_Id;

   function SPARK_Pragma_Inherited (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id
         | E_Abstract_State_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | Concurrent_Body_Kind_Id
         | E_Subprogram_Body_Id;
   procedure Set_SPARK_Pragma_Inherited (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Void_Id
         | Constant_Or_Variable_Kind_Id
         | Type_Kind_Id
         | Subprogram_Kind_Id
         | E_Abstract_State_Id
         | E_Entry_Id
         | E_Entry_Family_Id
         | Generic_Unit_Kind_Id
         | E_Package_Id
         | E_Package_Body_Id
         | Concurrent_Body_Kind_Id
         | E_Subprogram_Body_Id;

   function Spec_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Formal_Kind_Id
         | E_Package_Body_Id;
   procedure Set_Spec_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Formal_Kind_Id
         | E_Package_Body_Id;

   function SSO_Set_High_By_Default (N : Entity_Id) return Flag with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_SSO_Set_High_By_Default (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function SSO_Set_Low_By_Default (N : Entity_Id) return Flag with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;
   procedure Set_SSO_Set_Low_By_Default (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in Aggregate_Kind_Id
         | E_Record_Type_With_Private_Id
         | E_Record_Subtype_With_Private_Id;

   function Static_Call_Helper (N : Subprogram_Kind_Id) return Node_Id with Inline;
   procedure Set_Static_Call_Helper (N : Subprogram_Kind_Id; Val : Node_Id) with Inline;

   function Static_Discrete_Predicate (N : Discrete_Kind_Id) return List_Id with Inline;
   procedure Set_Static_Discrete_Predicate (N : Discrete_Kind_Id; Val : List_Id) with Inline;

   function Static_Elaboration_Desired (N : E_Package_Id) return Flag with Inline;
   procedure Set_Static_Elaboration_Desired (N : E_Package_Id; Val : Flag := True) with Inline;

   function Static_Initialization (N : E_Procedure_Id) return Node_Id with Inline;
   procedure Set_Static_Initialization (N : E_Procedure_Id; Val : Node_Id) with Inline;

   function Static_Real_Or_String_Predicate (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Real_Kind_Id
         | E_Array_Type_Id
         | E_Array_Subtype_Id;
   procedure Set_Static_Real_Or_String_Predicate (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Real_Kind_Id
         | E_Array_Type_Id
         | E_Array_Subtype_Id;

   function Status_Flag_Or_Transient_Decl (N : Allocatable_Kind_Id) return Node_Id with Inline;
   procedure Set_Status_Flag_Or_Transient_Decl (N : Allocatable_Kind_Id; Val : Node_Id) with Inline;

   function Storage_Size_Variable (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in Access_Kind_Id
         | Task_Kind_Id;
   procedure Set_Storage_Size_Variable (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in Access_Kind_Id
         | Task_Kind_Id;

   function Stored_Constraint (N : Entity_Id) return Elist_Id with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | Incomplete_Or_Private_Kind_Id
         | Concurrent_Kind_Id;
   procedure Set_Stored_Constraint (N : Entity_Id; Val : Elist_Id) with Inline, Pre =>
      N in Class_Wide_Kind_Id
         | E_Record_Type_Id
         | E_Record_Subtype_Id
         | Incomplete_Or_Private_Kind_Id
         | Concurrent_Kind_Id;

   function Stores_Attribute_Old_Prefix (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Stores_Attribute_Old_Prefix (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Strict_Alignment (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Strict_Alignment (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function String_Literal_Length (N : E_String_Literal_Subtype_Id) return Unat with Inline;
   procedure Set_String_Literal_Length (N : E_String_Literal_Subtype_Id; Val : Unat) with Inline;

   function String_Literal_Low_Bound (N : E_String_Literal_Subtype_Id) return Node_Id with Inline;
   procedure Set_String_Literal_Low_Bound (N : E_String_Literal_Subtype_Id; Val : Node_Id) with Inline;

   function Subprograms_For_Type (N : Type_Kind_Id) return Elist_Id with Inline;
   procedure Set_Subprograms_For_Type (N : Type_Kind_Id; Val : Elist_Id) with Inline;

   function Subps_Index (N : Subprogram_Kind_Id) return Unat with Inline;
   procedure Set_Subps_Index (N : Subprogram_Kind_Id; Val : Unat) with Inline;

   function Suppress_Elaboration_Warnings (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Suppress_Elaboration_Warnings (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Suppress_Initialization (N : Entity_Id) return Flag with Inline, Pre =>
      N in E_Variable_Id
         | Type_Kind_Id;
   procedure Set_Suppress_Initialization (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in E_Variable_Id
         | Type_Kind_Id;

   function Suppress_Style_Checks (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Suppress_Style_Checks (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Suppress_Value_Tracking_On_Call (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Suppress_Value_Tracking_On_Call (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Task_Body_Procedure (N : Task_Kind_Id) return Node_Id with Inline;
   procedure Set_Task_Body_Procedure (N : Task_Kind_Id; Val : Node_Id) with Inline;

   function Thunk_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Thunk_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Treat_As_Volatile (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Treat_As_Volatile (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Underlying_Full_View (N : Private_Kind_Id) return Node_Id with Inline;
   procedure Set_Underlying_Full_View (N : Private_Kind_Id; Val : Node_Id) with Inline;

   function Underlying_Record_View (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id;
   procedure Set_Underlying_Record_View (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Record_Type_Id
         | E_Record_Subtype_Id
         | E_Record_Type_With_Private_Id;

   function Universal_Aliasing (N : Type_Kind_Id) return Flag with Inline;
   procedure Set_Universal_Aliasing (N : Type_Kind_Id; Val : Flag := True) with Inline;

   function Unset_Reference (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Void_Id
         | E_Variable_Id
         | Formal_Kind_Id;
   procedure Set_Unset_Reference (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Void_Id
         | E_Variable_Id
         | Formal_Kind_Id;

   function Used_As_Generic_Actual (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Used_As_Generic_Actual (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Uses_Lock_Free (N : Protected_Kind_Id) return Flag with Inline;
   procedure Set_Uses_Lock_Free (N : Protected_Kind_Id; Val : Flag := True) with Inline;

   function Uses_Sec_Stack (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Uses_Sec_Stack (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Validated_Object (N : E_Variable_Id) return Node_Id with Inline;
   procedure Set_Validated_Object (N : E_Variable_Id; Val : Node_Id) with Inline;

   function Warnings_Off (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Warnings_Off (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Warnings_Off_Used (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Warnings_Off_Used (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Warnings_Off_Used_Unmodified (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Warnings_Off_Used_Unmodified (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Warnings_Off_Used_Unreferenced (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Warnings_Off_Used_Unreferenced (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Was_Hidden (N : Entity_Id) return Flag with Inline, Pre =>
      N in N_Entity_Id;
   procedure Set_Was_Hidden (N : Entity_Id; Val : Flag := True) with Inline, Pre =>
      N in N_Entity_Id;

   function Wrapped_Entity (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;
   procedure Set_Wrapped_Entity (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id;

   function Wrapped_Statements (N : Entity_Id) return Node_Id with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;
   procedure Set_Wrapped_Statements (N : Entity_Id; Val : Node_Id) with Inline, Pre =>
      N in E_Function_Id
         | E_Procedure_Id
         | E_Entry_Id
         | E_Entry_Family_Id;

   --  Table of sizes in 32-bit slots for given Entity_Kind, for use by Atree:

   Min_Entity_Size : constant Field_Offset := 19;
   Max_Entity_Size : constant Field_Offset := 64;

   Size : constant array (Entity_Kind) of Field_Offset :=
     (E_Void => 59,
      E_Enumeration_Type => 47,
      E_Enumeration_Subtype => 47,
      E_Signed_Integer_Type => 47,
      E_Signed_Integer_Subtype => 47,
      E_Modular_Integer_Type => 47,
      E_Modular_Integer_Subtype => 47,
      E_Ordinary_Fixed_Point_Type => 49,
      E_Ordinary_Fixed_Point_Subtype => 49,
      E_Decimal_Fixed_Point_Type => 59,
      E_Decimal_Fixed_Point_Subtype => 59,
      E_Floating_Point_Type => 49,
      E_Floating_Point_Subtype => 49,
      E_Access_Type => 45,
      E_Access_Subtype => 45,
      E_Access_Attribute_Type => 45,
      E_Allocator_Type => 45,
      E_General_Access_Type => 45,
      E_Access_Subprogram_Type => 46,
      E_Access_Protected_Subprogram_Type => 46,
      E_Anonymous_Access_Protected_Subprogram_Type => 46,
      E_Anonymous_Access_Subprogram_Type => 45,
      E_Anonymous_Access_Type => 45,
      E_Array_Type => 49,
      E_Array_Subtype => 49,
      E_String_Literal_Subtype => 48,
      E_Class_Wide_Type => 50,
      E_Class_Wide_Subtype => 51,
      E_Record_Type => 50,
      E_Record_Subtype => 51,
      E_Record_Type_With_Private => 51,
      E_Record_Subtype_With_Private => 51,
      E_Private_Type => 51,
      E_Private_Subtype => 51,
      E_Limited_Private_Type => 51,
      E_Limited_Private_Subtype => 51,
      E_Incomplete_Type => 49,
      E_Incomplete_Subtype => 49,
      E_Task_Type => 50,
      E_Task_Subtype => 50,
      E_Protected_Type => 58,
      E_Protected_Subtype => 58,
      E_Exception_Type => 46,
      E_Subprogram_Type => 44,
      E_Component => 42,
      E_Discriminant => 54,
      E_Constant => 45,
      E_Variable => 51,
      E_Loop_Parameter => 36,
      E_Out_Parameter => 38,
      E_In_Out_Parameter => 38,
      E_In_Parameter => 38,
      E_Generic_In_Out_Parameter => 34,
      E_Generic_In_Parameter => 29,
      E_Exception => 23,
      E_Named_Integer => 19,
      E_Named_Real => 19,
      E_Enumeration_Literal => 42,
      E_Function => 64,
      E_Operator => 53,
      E_Procedure => 63,
      E_Abstract_State => 45,
      E_Entry => 57,
      E_Entry_Family => 57,
      E_Block => 49,
      E_Entry_Index_Parameter => 19,
      E_Generic_Function => 41,
      E_Generic_Procedure => 41,
      E_Generic_Package => 56,
      E_Label => 55,
      E_Loop => 37,
      E_Return_Statement => 46,
      E_Package => 52,
      E_Package_Body => 45,
      E_Protected_Body => 29,
      E_Task_Body => 32,
      E_Subprogram_Body => 42); -- Size

   subtype Entity_Field is
     Node_Or_Entity_Field range F_Ekind .. F_Wrapped_Statements;

   type Entity_Field_Index is new Pos;
   type Entity_Field_Array is array (Entity_Field_Index range <>) of Entity_Field;
   type Entity_Field_Array_Ref is access constant Entity_Field_Array;
   subtype A is Entity_Field_Array;

   --  Table mapping Entity_Kinds to the sequence of fields that exist in that Entity_Kind:

   Entity_Field_Table : constant array (Entity_Kind) of Entity_Field_Array_Ref :=
     (E_Void =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Accept_Address,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Formal_Package,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Corresponding_Remote_Type,
               F_CR_Discriminant,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Debug_Renaming_Link,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminal_Link,
               F_Discriminant_Default_Value,
               F_Discriminant_Number,
               F_Enclosing_Scope,
               F_Entry_Bodies_Array,
               F_Entry_Cancel_Parameter,
               F_Entry_Component,
               F_Entry_Formal,
               F_Entry_Parameters_Type,
               F_Esize,
               F_Extra_Formal,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Generic_Homonym,
               F_Generic_Renamings,
               F_Handler_Records,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Static_Discriminants,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Initialization_Statements,
               F_Inner_Instances,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_Next_Inlined_Subprogram,
               F_No_Return,
               F_Original_Record_Component,
               F_Overlays_Constant,
               F_Package_Instantiation,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Applies_To,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Scale_Value,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Unset_Reference,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Enumeration_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Enum_Pos_To_Rep,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Literal,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Enumeration_Rep_Clause,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Ordered,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Lit_Hash,
               F_Lit_Indexes,
               F_Lit_Strings,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Dynamic_Predicate_On_Actual,
               F_No_Predicate_On_Actual,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Nonzero_Is_True,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Discrete_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Enumeration_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Literal,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Enumeration_Rep_Clause,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Ordered,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Lit_Hash,
               F_Lit_Indexes,
               F_Lit_Strings,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Dynamic_Predicate_On_Actual,
               F_No_Predicate_On_Actual,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Nonzero_Is_True,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Discrete_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Signed_Integer_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Shift_Operator,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Dynamic_Predicate_On_Actual,
               F_No_Predicate_On_Actual,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Discrete_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Signed_Integer_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Shift_Operator,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Dynamic_Predicate_On_Actual,
               F_No_Predicate_On_Actual,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Discrete_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Modular_Integer_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Shift_Operator,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Modulus,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Dynamic_Predicate_On_Actual,
               F_No_Predicate_On_Actual,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Original_Array_Type,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Discrete_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Modular_Integer_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Shift_Operator,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Modulus,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Dynamic_Predicate_On_Actual,
               F_No_Predicate_On_Actual,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Original_Array_Type,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Discrete_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Ordinary_Fixed_Point_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Delta_Value,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Small_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Small_Value,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Ordinary_Fixed_Point_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Delta_Value,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Small_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Small_Value,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Decimal_Fixed_Point_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Delta_Value,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Digits_Value,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Machine_Radix_Clause,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Machine_Radix_10,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Scale_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Small_Value,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Decimal_Fixed_Point_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Delta_Value,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Digits_Value,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Machine_Radix_Clause,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Machine_Radix_10,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Scale_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Small_Value,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Floating_Point_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Digits_Value,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Floating_Point_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Digits_Value,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Access_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Access_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Access_Attribute_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Allocator_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_General_Access_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Access_Subprogram_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Equivalent_Type,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Original_Access_Type,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Access_Protected_Subprogram_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Equivalent_Type,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Anonymous_Access_Protected_Subprogram_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Equivalent_Type,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Anonymous_Access_Subprogram_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Anonymous_Access_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Associated_Storage_Pool,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Directly_Designated_Type,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Finalization_Master,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Controlled,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Access_Constant,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Local_Anonymous_Access,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Param_Block_Component_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Pure_Unit_Access_Type,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Master_Id,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Pool_Assigned,
               F_No_Return,
               F_No_Strict_Aliasing,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Array_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Component_Size,
               F_Component_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Component_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Index,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Component_Size_Clause,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Original_Array_Type,
               F_Overlays_Constant,
               F_Packed_Array_Impl_Type,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Array_Object,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Array_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Component_Size,
               F_Component_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Component_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicated_Parent,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Index,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Component_Size_Clause,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Original_Array_Type,
               F_Overlays_Constant,
               F_Packed_Array_Impl_Type,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Array_Object,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Static_Real_Or_String_Predicate,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_String_Literal_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Component_Size,
               F_Component_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Aspect_Component_Value,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Index,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Component_Size_Clause,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Original_Array_Type,
               F_Overlays_Constant,
               F_Packed_Array_Impl_Type,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Array_Object,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_String_Literal_Length,
               F_String_Literal_Low_Bound,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Class_Wide_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_C_Pass_By_Copy,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Contract,
               F_Corresponding_Remote_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Equivalent_Type,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Complex_Representation,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Record_Rep_Clause,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Interfaces,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Reordering,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Non_Limited_View,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Parent_Subtype,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Bit_Order,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Class_Wide_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_C_Pass_By_Copy,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Cloned_Subtype,
               F_Component_Alignment,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Equivalent_Type,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Complex_Representation,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Record_Rep_Clause,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Interfaces,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Reordering,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Non_Limited_View,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Parent_Subtype,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Bit_Order,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Record_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Access_Disp_Table,
               F_Access_Disp_Table_Elab_Flag,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_C_Pass_By_Copy,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Contract,
               F_Corresponding_Concurrent_Type,
               F_Corresponding_Remote_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Dispatch_Table_Wrappers,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Complex_Representation,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Record_Rep_Clause,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Interfaces,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Reordering,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Parent_Subtype,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Bit_Order,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Record_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Record_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Access_Disp_Table,
               F_Access_Disp_Table_Elab_Flag,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_C_Pass_By_Copy,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Cloned_Subtype,
               F_Component_Alignment,
               F_Contract,
               F_Corresponding_Remote_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicated_Parent,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Dispatch_Table_Wrappers,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Complex_Representation,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Record_Rep_Clause,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Interfaces,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Reordering,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Parent_Subtype,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Bit_Order,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Record_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Record_Type_With_Private =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Access_Disp_Table,
               F_Access_Disp_Table_Elab_Flag,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_C_Pass_By_Copy,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Contract,
               F_Corresponding_Remote_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Complex_Representation,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Record_Rep_Clause,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Interfaces,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Reordering,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Parent_Subtype,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Bit_Order,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Full_View,
               F_Underlying_Record_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Record_Subtype_With_Private =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_C_Pass_By_Copy,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Component_Alignment,
               F_Contract,
               F_Corresponding_Remote_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicated_Parent,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Complex_Representation,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Pack,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Record_Rep_Clause,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Interfaces,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Reordering,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Parent_Subtype,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Reverse_Bit_Order,
               F_Reverse_Storage_Order,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_SSO_Set_High_By_Default,
               F_SSO_Set_Low_By_Default,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Full_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Private_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Full_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Private_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Full_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Limited_Private_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Full_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Limited_Private_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Underlying_Full_View,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Incomplete_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Non_Limited_View,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scalar_Range,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Incomplete_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Non_Limited_View,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Private_Dependents,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Task_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Anonymous_Object,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Corresponding_Record_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Private_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Relative_Deadline_Variable,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Aux_Pragma,
               F_SPARK_Aux_Pragma_Inherited,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Task_Body_Procedure,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Task_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Corresponding_Record_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Private_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Storage_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Relative_Deadline_Variable,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Storage_Size_Variable,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Task_Body_Procedure,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Protected_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Anonymous_Object,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Corresponding_Record_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Entry_Bodies_Array,
               F_Entry_Max_Queue_Lengths_Array,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Private_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Aux_Pragma,
               F_SPARK_Aux_Pragma_Inherited,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Lock_Free,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Protected_Subtype =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Corresponding_Record_Type,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Constraint,
               F_Entry_Bodies_Array,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Private_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stored_Constraint,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Lock_Free,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Exception_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Equivalent_Type,
               F_Esize,
               F_Finalize_Storage_Only,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Subprogram_Type =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Access_Subprogram_Wrapper,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Can_Never_Be_Null,
               F_Can_Use_Internal_Rep,
               F_Checks_May_Be_Suppressed,
               F_Class_Wide_Type,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Derived_Type_Link,
               F_Predicates_Ignored,
               F_Direct_Primitive_Operations,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_Extra_Accessibility_Of_Result,
               F_Extra_Formals,
               F_Finalize_Storage_Only,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Completion_In_Body,
               F_Has_Constrained_Partial_View,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Discriminants,
               F_Has_Dispatch_Table,
               F_Has_Dynamic_Predicate_Aspect,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Inheritable_Invariants,
               F_Has_Inherited_DIC,
               F_Has_Inherited_Invariants,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Object_Size_Clause,
               F_Has_Own_DIC,
               F_Has_Own_Invariants,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unreferenced_Objects,
               F_Has_Pragma_Unused,
               F_Has_Predicates,
               F_Has_Primitive_Operations,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Private_Extension,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Specified_Layout,
               F_Has_Specified_Stream_Input,
               F_Has_Specified_Stream_Output,
               F_Has_Specified_Stream_Read,
               F_Has_Specified_Stream_Write,
               F_Has_Static_Discriminants,
               F_Has_Static_Predicate,
               F_Has_Static_Predicate_Aspect,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Unknown_Discriminants,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Type,
               F_Is_Actual_Subtype,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Fixed_Lower_Bound_Array_Subtype,
               F_Is_Fixed_Lower_Bound_Index_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Type,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Non_Static_Subtype,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Composite,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_RACW_Stub_Type,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Unsigned_Type,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Itype_Printed,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Known_To_Have_Preelab_Init,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Must_Be_On_Byte_Boundary,
               F_Must_Have_Preelab_Init,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_No_Return,
               F_No_Tagged_Streams_Pragma,
               F_Non_Binary_Modulus,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Partial_View_Has_Unknown_Discr,
               F_Pending_Access_Types,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_RM_Size,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subprograms_For_Type,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Universal_Aliasing,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Component =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Component_Bit_Offset,
               F_Component_Clause,
               F_Corresponding_Record_Component,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminant_Checking_Func,
               F_DT_Entry_Count,
               F_DT_Offset_To_Top_Func,
               F_Entry_Formal,
               F_Esize,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Normalized_First_Bit,
               F_Normalized_Position,
               F_Original_Record_Component,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Prival,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Type,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Discriminant =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Component_Bit_Offset,
               F_Component_Clause,
               F_Corresponding_Discriminant,
               F_Corresponding_Record_Component,
               F_CR_Discriminant,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminal,
               F_Discriminant_Default_Value,
               F_Discriminant_Number,
               F_Entry_Formal,
               F_Esize,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Completely_Hidden,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Normalized_First_Bit,
               F_Normalized_Position,
               F_Original_Record_Component,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Constant =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Activation_Record_Component,
               F_Actual_Subtype,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_BIP_Initialization_Call,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminal_Link,
               F_Encapsulating_State,
               F_Esize,
               F_Extra_Accessibility,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Full_View,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Initialization_Statements,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_Finalized_Transient,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Ignored_Transient,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Aggregate_Assignment,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Prival_Link,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Related_Type,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Return_Statement,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Check_Code,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Status_Flag_Or_Transient_Decl,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Variable =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Activation_Record_Component,
               F_Actual_Subtype,
               F_Address_Taken,
               F_Alignment,
               F_Anonymous_Designated_Type,
               F_Associated_Entity,
               F_BIP_Initialization_Call,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Debug_Renaming_Link,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminal_Link,
               F_Encapsulating_State,
               F_Esize,
               F_Extra_Accessibility,
               F_Extra_Constrained,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Initial_Value,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Hiding_Loop_Variable,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Initialization_Statements,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_Finalized_Transient,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Ignored_Transient,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Aggregate_Assignment,
               F_Last_Assignment,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_OK_To_Rename,
               F_Optimize_Alignment_Space,
               F_Optimize_Alignment_Time,
               F_Overlays_Constant,
               F_Part_Of_Constituents,
               F_Part_Of_References,
               F_Prev_Entity,
               F_Prival_Link,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Related_Type,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Return_Statement,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Shared_Var_Procs_Instance,
               F_Size_Check_Code,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Status_Flag_Or_Transient_Decl,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Initialization,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Unset_Reference,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Validated_Object,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Loop_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Activation_Record_Component,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_Finalized_Transient,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Ignored_Transient,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Status_Flag_Or_Transient_Decl,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Out_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Activation_Record_Component,
               F_Actual_Subtype,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expr_Function,
               F_Default_Expressions_Processed,
               F_Default_Value,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Entry_Component,
               F_Esize,
               F_Extra_Accessibility,
               F_Extra_Constrained,
               F_Extra_Formal,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Initial_Value,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_Controlling_Formal,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Only_Out_Parameter,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Assignment,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Mechanism,
               F_Minimum_Accessibility,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Protected_Formal,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Spec_Entity,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Unset_Reference,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_In_Out_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Activation_Record_Component,
               F_Actual_Subtype,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expr_Function,
               F_Default_Expressions_Processed,
               F_Default_Value,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Entry_Component,
               F_Esize,
               F_Extra_Accessibility,
               F_Extra_Constrained,
               F_Extra_Formal,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Initial_Value,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_Controlling_Formal,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Only_Out_Parameter,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Assignment,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Mechanism,
               F_Minimum_Accessibility,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Protected_Formal,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Spec_Entity,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Unset_Reference,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_In_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Activation_Record_Component,
               F_Actual_Subtype,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expr_Function,
               F_Default_Expressions_Processed,
               F_Default_Value,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Discriminal_Link,
               F_Discriminant_Default_Value,
               F_Entry_Component,
               F_Esize,
               F_Extra_Accessibility,
               F_Extra_Constrained,
               F_Extra_Formal,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Initial_Value,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Activation_Record,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_Controlling_Formal,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Only_Out_Parameter,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Mechanism,
               F_Minimum_Accessibility,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Protected_Formal,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Spec_Entity,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Unset_Reference,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Generic_In_Out_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Actual_Subtype,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Entry_Component,
               F_Esize,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Generic_In_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Current_Value,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Entry_Component,
               F_Esize,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Exception =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Esize,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Raised,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Register_Exception_Call,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Named_Integer =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Named_Real =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Enumeration_Literal =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Alignment,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Enumeration_Pos,
               F_Enumeration_Rep,
               F_Enumeration_Rep_Expr,
               F_Esize,
               F_Extra_Formals,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Abstract_Subprogram,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Requires_Overriding,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Function =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Anonymous_Masters,
               F_Associated_Entity,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Class_Postconditions,
               F_Class_Preconditions,
               F_Class_Preconditions_Subprogram,
               F_Contract,
               F_Corresponding_Equality,
               F_Corresponding_Procedure,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Dynamic_Call_Helper,
               F_DT_Position,
               F_DTC_Entity,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_Extra_Accessibility_Of_Result,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Generic_Renamings,
               F_Handler_Records,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Expanded_Contract,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Missing_Return,
               F_Has_Nested_Block_With_Handler,
               F_Has_Nested_Subprogram,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Recursive_Call,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignored_Class_Postconditions,
               F_Ignored_Class_Preconditions,
               F_Ignore_SPARK_Mode_Pragmas,
               F_Import_Pragma,
               F_Indirect_Call_Wrapper,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Inner_Instances,
               F_Interface_Alias,
               F_Interface_Name,
               F_Is_Abstract_Subprogram,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Called,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_CUDA_Kernel,
               F_Is_Descendant_Of_Address,
               F_Is_DIC_Procedure,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Subprogram,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Initial_Condition_Procedure,
               F_Is_Inlined,
               F_Is_Inlined_Always,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Invariant_Procedure,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Machine_Code_Subprogram,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Partial_Invariant_Procedure,
               F_Is_Potentially_Use_Visible,
               F_Is_Predicate_Function,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Primitive_Wrapper,
               F_Is_Private_Descendant,
               F_Is_Private_Primitive,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_LSP_Subprogram,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Mechanism,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_Next_Inlined_Subprogram,
               F_No_Return,
               F_Original_Protected_Subprogram,
               F_Overlays_Constant,
               F_Overridden_Operation,
               F_Postconditions_Proc,
               F_Predicate_Expression,
               F_Prev_Entity,
               F_Protected_Body_Subprogram,
               F_Protected_Subprogram,
               F_Protection_Object,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Expression,
               F_Renamed_Or_Alias,
               F_Requires_Overriding,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Rewritten_For_C,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Call_Helper,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subps_Index,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Thunk_Entity,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden,
               F_Wrapped_Entity,
               F_Wrapped_Statements),
      E_Operator =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Class_Postconditions,
               F_Class_Preconditions,
               F_Class_Preconditions_Subprogram,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Dynamic_Call_Helper,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_Extra_Accessibility_Of_Result,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Expanded_Contract,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Nested_Subprogram,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Recursive_Call,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignored_Class_Postconditions,
               F_Ignored_Class_Preconditions,
               F_Ignore_SPARK_Mode_Pragmas,
               F_Import_Pragma,
               F_Indirect_Call_Wrapper,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Alias,
               F_Interface_Name,
               F_Is_Abstract_Subprogram,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Machine_Code_Subprogram,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_LSP_Subprogram,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Overridden_Operation,
               F_Prev_Entity,
               F_Protected_Body_Subprogram,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Requires_Overriding,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Call_Helper,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subps_Index,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Procedure =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Anonymous_Masters,
               F_Associated_Entity,
               F_Associated_Node_For_Itype,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Class_Postconditions,
               F_Class_Preconditions,
               F_Class_Preconditions_Subprogram,
               F_Contract,
               F_Corresponding_Function,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Dynamic_Call_Helper,
               F_DT_Position,
               F_DTC_Entity,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_Entry_Parameters_Type,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Generic_Renamings,
               F_Handler_Records,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Expanded_Contract,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Nested_Subprogram,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Recursive_Call,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignored_Class_Postconditions,
               F_Ignored_Class_Preconditions,
               F_Ignore_SPARK_Mode_Pragmas,
               F_Import_Pragma,
               F_Indirect_Call_Wrapper,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Inner_Instances,
               F_Interface_Alias,
               F_Interface_Name,
               F_Is_Abstract_Subprogram,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Asynchronous,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Called,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_CUDA_Kernel,
               F_Is_Descendant_Of_Address,
               F_Is_DIC_Procedure,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Actual_Subprogram,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Initial_Condition_Procedure,
               F_Is_Inlined,
               F_Is_Inlined_Always,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Invariant_Procedure,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Machine_Code_Subprogram,
               F_Is_Null_Init_Proc,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Partial_Invariant_Procedure,
               F_Is_Potentially_Use_Visible,
               F_Is_Predicate_Function,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Primitive_Wrapper,
               F_Is_Private_Descendant,
               F_Is_Private_Primitive,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Valued_Procedure,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Linker_Section_Pragma,
               F_Low_Bound_Tested,
               F_LSP_Subprogram,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_Next_Inlined_Subprogram,
               F_No_Return,
               F_Original_Protected_Subprogram,
               F_Overlays_Constant,
               F_Overridden_Operation,
               F_Postconditions_Proc,
               F_Prev_Entity,
               F_Protected_Body_Subprogram,
               F_Protected_Subprogram,
               F_Protection_Object,
               F_Receiving_Entry,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Requires_Overriding,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Call_Helper,
               F_Static_Initialization,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Subps_Index,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Thunk_Entity,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden,
               F_Wrapped_Entity,
               F_Wrapped_Statements),
      E_Abstract_State =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Body_References,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Encapsulating_State,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Partial_Visible_Refinement,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Visible_Refinement,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Abstract_Subprogram,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Non_Limited_View,
               F_Overlays_Constant,
               F_Part_Of_Constituents,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Refinement_Constituents,
               F_Renamed_Or_Alias,
               F_Requires_Overriding,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Entry =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Accept_Address,
               F_Address_Taken,
               F_Associated_Entity,
               F_Barrier_Function,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Contract_Wrapper,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_Entry_Accepted,
               F_Entry_Parameters_Type,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Abstract_Subprogram,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Postconditions_Proc,
               F_Prev_Entity,
               F_Protected_Body_Subprogram,
               F_Protection_Object,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Requires_Overriding,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden,
               F_Wrapped_Statements),
      E_Entry_Family =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Accept_Address,
               F_Address_Taken,
               F_Associated_Entity,
               F_Barrier_Function,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Contract_Wrapper,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_Entry_Accepted,
               F_Entry_Parameters_Type,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Needs_No_Actuals,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Postconditions_Proc,
               F_Prev_Entity,
               F_Protected_Body_Subprogram,
               F_Protection_Object,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden,
               F_Wrapped_Statements),
      E_Block =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Block_Node,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Entry_Cancel_Parameter,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exception_Handler,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Applies_To,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Entry_Index_Parameter =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Entry_Index_Constant,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Generic_Function =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Missing_Return,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Inner_Instances,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_Next_Inlined_Subprogram,
               F_No_Return,
               F_Overlays_Constant,
               F_Overridden_Operation,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Generic_Procedure =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Out_Or_In_Out_Parameter,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Inner_Instances,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Primitive,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_Next_Inlined_Subprogram,
               F_No_Return,
               F_Overlays_Constant,
               F_Overridden_Operation,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Generic_Package =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Abstract_States,
               F_Address_Taken,
               F_Associated_Entity,
               F_Body_Entity,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_First_Entity,
               F_First_Private_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Generic_Homonym,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Inner_Instances,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Package_Instantiation,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Aux_Pragma,
               F_SPARK_Aux_Pragma_Inherited,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Label =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Enclosing_Scope,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Reachable,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Loop =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_First_Entity,
               F_First_Exit_Statement,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Loop_Entry_Attributes,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Return_Statement =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Return_Applies_To,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Package =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Abstract_States,
               F_Address_Taken,
               F_Anonymous_Masters,
               F_Associated_Entity,
               F_Associated_Formal_Package,
               F_Body_Entity,
               F_Body_Needed_For_Inlining,
               F_Body_Needed_For_SAL,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Current_Use_Clause,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Dependent_Instances,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Elaborate_Body_Desirable,
               F_Elaboration_Entity,
               F_Elaboration_Entity_Required,
               F_Finalizer,
               F_First_Entity,
               F_First_Private_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Generic_Renamings,
               F_Handler_Records,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_RACW,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Hidden_In_Formal_Instance,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_Incomplete_Actuals,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Inner_Instances,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Called,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Elaboration_Checks_OK_Id,
               F_Is_Elaboration_Warnings_OK_Id,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Limited_View,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Package_Instantiation,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Instance,
               F_Renamed_In_Spec,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Aux_Pragma,
               F_SPARK_Aux_Pragma_Inherited,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Static_Elaboration_Desired,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Package_Body =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Finalizer,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Handler_Records,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Related_Instance,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Aux_Pragma,
               F_SPARK_Aux_Pragma_Inherited,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Spec_Entity,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Protected_Body =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Task_Body =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden),
      E_Subprogram_Body =>
        new A'(F_Ekind,
               F_Basic_Convention,
               F_Address_Taken,
               F_Anonymous_Masters,
               F_Associated_Entity,
               F_Can_Never_Be_Null,
               F_Checks_May_Be_Suppressed,
               F_Contract,
               F_Debug_Info_Off,
               F_Default_Expressions_Processed,
               F_Delay_Cleanups,
               F_Delay_Subprogram_Descriptors,
               F_Depends_On_Private,
               F_Disable_Controlled,
               F_Discard_Names,
               F_Extra_Formals,
               F_First_Entity,
               F_First_Rep_Item,
               F_Freeze_Node,
               F_From_Limited_With,
               F_Has_Aliased_Components,
               F_Has_Alignment_Clause,
               F_Has_All_Calls_Remote,
               F_Has_Atomic_Components,
               F_Has_Biased_Representation,
               F_Has_Completion,
               F_Has_Contiguous_Rep,
               F_Has_Controlled_Component,
               F_Has_Controlling_Result,
               F_Has_Convention_Pragma,
               F_Has_Default_Aspect,
               F_Has_Delayed_Aspects,
               F_Has_Delayed_Freeze,
               F_Has_Delayed_Rep_Aspects,
               F_Has_Exit,
               F_Has_Forward_Instantiation,
               F_Has_Fully_Qualified_Name,
               F_Has_Gigi_Rep_Item,
               F_Has_Homonym,
               F_Has_Implicit_Dereference,
               F_Has_Independent_Components,
               F_Has_Master_Entity,
               F_Has_Nested_Block_With_Handler,
               F_Has_Non_Standard_Rep,
               F_Has_Per_Object_Constraint,
               F_Has_Pragma_Elaborate_Body,
               F_Has_Pragma_Inline,
               F_Has_Pragma_Inline_Always,
               F_Has_Pragma_No_Inline,
               F_Has_Pragma_Preelab_Init,
               F_Has_Pragma_Pure,
               F_Has_Pragma_Pure_Function,
               F_Has_Pragma_Thread_Local_Storage,
               F_Has_Pragma_Unmodified,
               F_Has_Pragma_Unreferenced,
               F_Has_Pragma_Unused,
               F_Has_Private_Ancestor,
               F_Has_Private_Declaration,
               F_Has_Protected,
               F_Has_Qualified_Name,
               F_Has_Size_Clause,
               F_Has_Stream_Size_Clause,
               F_Has_Task,
               F_Has_Timing_Event,
               F_Has_Thunks,
               F_Has_Unchecked_Union,
               F_Has_Volatile_Components,
               F_Has_Xref_Entry,
               F_Has_Yield_Aspect,
               F_Homonym,
               F_Ignore_SPARK_Mode_Pragmas,
               F_In_Package_Body,
               F_In_Private_Part,
               F_In_Use,
               F_Interface_Name,
               F_Is_Ada_2005_Only,
               F_Is_Ada_2012_Only,
               F_Is_Ada_2022_Only,
               F_Is_Aliased,
               F_Is_Atomic,
               F_Is_Bit_Packed_Array,
               F_Is_Character_Type,
               F_Is_Checked_Ghost_Entity,
               F_Is_Child_Unit,
               F_Is_Class_Wide_Equivalent_Type,
               F_Is_Class_Wide_Wrapper,
               F_Is_Compilation_Unit,
               F_Is_Concurrent_Record_Type,
               F_Is_Constr_Subt_For_U_Nominal,
               F_Is_Constr_Subt_For_UN_Aliased,
               F_Is_Constrained,
               F_Is_Constructor,
               F_Is_Controlled_Active,
               F_Is_CPP_Class,
               F_Is_Descendant_Of_Address,
               F_Is_Discrim_SO_Function,
               F_Is_Discriminant_Check_Function,
               F_Is_Dispatch_Table_Entity,
               F_Is_Dispatch_Table_Wrapper,
               F_Is_Dispatching_Operation,
               F_Is_Eliminated,
               F_Is_Entry_Formal,
               F_Is_Entry_Wrapper,
               F_Is_Exported,
               F_Is_First_Subtype,
               F_Is_Formal_Subprogram,
               F_Is_Frozen,
               F_Is_Generic_Instance,
               F_Is_Generic_Type,
               F_Is_Hidden,
               F_Is_Hidden_Non_Overridden_Subpgm,
               F_Is_Hidden_Open_Scope,
               F_Is_Ignored_Ghost_Entity,
               F_Is_Immediately_Visible,
               F_Is_Implementation_Defined,
               F_Is_Imported,
               F_Is_Independent,
               F_Is_Inlined,
               F_Is_Instantiated,
               F_Is_Interface,
               F_Is_Internal,
               F_Is_Interrupt_Handler,
               F_Is_Intrinsic_Subprogram,
               F_Is_Itype,
               F_Is_Known_Non_Null,
               F_Is_Known_Null,
               F_Is_Known_Valid,
               F_Is_Limited_Composite,
               F_Is_Limited_Interface,
               F_Is_Limited_Record,
               F_Is_Loop_Parameter,
               F_Is_Obsolescent,
               F_Is_Package_Body_Entity,
               F_Is_Packed,
               F_Is_Packed_Array_Impl_Type,
               F_Is_Potentially_Use_Visible,
               F_Is_Preelaborated,
               F_Is_Private_Descendant,
               F_Is_Public,
               F_Is_Pure,
               F_Is_Remote_Call_Interface,
               F_Is_Remote_Types,
               F_Is_Renaming_Of_Object,
               F_Is_Return_Object,
               F_Is_Safe_To_Reevaluate,
               F_Is_Shared_Passive,
               F_Is_Static_Type,
               F_Is_Statically_Allocated,
               F_Is_Tag,
               F_Is_Tagged_Type,
               F_Is_Thunk,
               F_Is_Trivial_Subprogram,
               F_Is_True_Constant,
               F_Is_Unchecked_Union,
               F_Is_Underlying_Full_View,
               F_Is_Underlying_Record_View,
               F_Is_Unimplemented,
               F_Is_Uplevel_Referenced_Entity,
               F_Is_Visible_Formal,
               F_Is_Visible_Lib_Unit,
               F_Is_Volatile_Type,
               F_Is_Volatile_Object,
               F_Is_Volatile_Full_Access,
               F_Is_Wrapper,
               F_Kill_Elaboration_Checks,
               F_Kill_Range_Checks,
               F_Last_Entity,
               F_Low_Bound_Tested,
               F_Materialize_Entity,
               F_May_Inherit_Delayed_Rep_Aspects,
               F_Needs_Activation_Record,
               F_Needs_Debug_Info,
               F_Never_Set_In_Source,
               F_No_Return,
               F_Overlays_Constant,
               F_Prev_Entity,
               F_Referenced,
               F_Referenced_As_LHS,
               F_Referenced_As_Out_Parameter,
               F_Renamed_Or_Alias,
               F_Return_Present,
               F_Returns_By_Ref,
               F_Scope_Depth_Value,
               F_Sec_Stack_Needed_For_Return,
               F_Size_Depends_On_Discriminant,
               F_Size_Known_At_Compile_Time,
               F_SPARK_Pragma,
               F_SPARK_Pragma_Inherited,
               F_Stores_Attribute_Old_Prefix,
               F_Strict_Alignment,
               F_Suppress_Elaboration_Warnings,
               F_Suppress_Style_Checks,
               F_Suppress_Value_Tracking_On_Call,
               F_Treat_As_Volatile,
               F_Used_As_Generic_Actual,
               F_Uses_Sec_Stack,
               F_Warnings_Off,
               F_Warnings_Off_Used,
               F_Warnings_Off_Used_Unmodified,
               F_Warnings_Off_Used_Unreferenced,
               F_Was_Hidden)); -- Entity_Field_Table

end Einfo.Entities;
