/* MultPuzzle.c generated by valac 0.12.0, the Vala compiler
 * generated from MultPuzzle.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2004-2008,2011 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>


#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;
typedef struct _MultPuzzlePrivate MultPuzzlePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

struct _MultPuzzle {
	GObject parent_instance;
	MultPuzzlePrivate * priv;
};

struct _MultPuzzleClass {
	GObjectClass parent_class;
};

struct _MultPuzzlePrivate {
	gint _num_x_digits;
	gint _num_y_digits;
	gint _total_guesses;
	gint _wrong_guesses;
	gint _correct_guesses;
	gboolean _is_done;
	MultPuzzleChar* symbols;
	gint symbols_length1;
	gint _symbols_size_;
	gboolean* needed;
	gint needed_length1;
	gint _needed_size_;
	gboolean* unknown;
	gint unknown_length1;
	gint _unknown_size_;
	gboolean* have_guessed;
	gint have_guessed_length1;
	gint _have_guessed_size_;
	gchar* x;
	gchar* y;
	gchar* z;
	gchar** addends;
	gint addends_length1;
	gint _addends_size_;
};


static gpointer mult_puzzle_parent_class = NULL;

GType mult_puzzle_guess_status_get_type (void) G_GNUC_CONST;
GType mult_puzzle_char_get_type (void) G_GNUC_CONST;
GType mult_puzzle_get_type (void) G_GNUC_CONST;
#define MULT_PUZZLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MULT_PUZZLE, MultPuzzlePrivate))
enum  {
	MULT_PUZZLE_DUMMY_PROPERTY,
	MULT_PUZZLE_NUM_X_DIGITS,
	MULT_PUZZLE_NUM_Y_DIGITS,
	MULT_PUZZLE_TOTAL_GUESSES,
	MULT_PUZZLE_WRONG_GUESSES,
	MULT_PUZZLE_CORRECT_GUESSES,
	MULT_PUZZLE_IS_DONE
};
MultPuzzle* mult_puzzle_new (gint num_x, gint num_y);
MultPuzzle* mult_puzzle_construct (GType object_type, gint num_x, gint num_y);
gchar* mult_puzzle_get_multiplicand (MultPuzzle* self);
gchar* mult_puzzle_get_multiplier (MultPuzzle* self);
gchar* mult_puzzle_get_answer (MultPuzzle* self);
guint mult_puzzle_get_num_addends (MultPuzzle* self);
gchar* mult_puzzle_get_addend (MultPuzzle* self, gint n);
MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter);
MultPuzzleChar mult_puzzle_solve_digit (MultPuzzle* self, gint digit);
gint mult_puzzle_get_total_guesses (MultPuzzle* self);
static void mult_puzzle_set_total_guesses (MultPuzzle* self, gint value);
gint mult_puzzle_get_correct_guesses (MultPuzzle* self);
static void mult_puzzle_set_correct_guesses (MultPuzzle* self, gint value);
gint mult_puzzle_get_wrong_guesses (MultPuzzle* self);
static void mult_puzzle_set_wrong_guesses (MultPuzzle* self, gint value);
void mult_puzzle_solve (MultPuzzle* self);
static void mult_puzzle_replace (MultPuzzle* self, gchar** n, gint digit);
static void mult_puzzle_set_is_done (MultPuzzle* self, gboolean value);
gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1);
gboolean* mult_puzzle_get_needed_digits (MultPuzzle* self, int* result_length1);
gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1);
static void mult_puzzle_expand_num_string (MultPuzzle* self, gchar** n, gsize minimum);
static void mult_puzzle_shuffle (MultPuzzleChar* symbolList, int symbolList_length1);
static void mult_puzzle_interpret (MultPuzzle* self, gchar** n);
static void mult_puzzle_note_needed (MultPuzzle* self, const gchar* n);
static gint mult_puzzle_num_with_n_digits (gint n);
gint mult_puzzle_get_num_x_digits (MultPuzzle* self);
static void mult_puzzle_set_num_x_digits (MultPuzzle* self, gint value);
gint mult_puzzle_get_num_y_digits (MultPuzzle* self);
static void mult_puzzle_set_num_y_digits (MultPuzzle* self, gint value);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
static void g_cclosure_user_marshal_VOID__INT_ENUM_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * mult_puzzle_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void mult_puzzle_finalize (GObject* obj);
static void _vala_mult_puzzle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_mult_puzzle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType mult_puzzle_guess_status_get_type (void) {
	static volatile gsize mult_puzzle_guess_status_type_id__volatile = 0;
	if (g_once_init_enter (&mult_puzzle_guess_status_type_id__volatile)) {
		static const GEnumValue values[] = {{MULT_PUZZLE_GUESS_STATUS_WRONG, "MULT_PUZZLE_GUESS_STATUS_WRONG", "wrong"}, {MULT_PUZZLE_GUESS_STATUS_CORRECT, "MULT_PUZZLE_GUESS_STATUS_CORRECT", "correct"}, {MULT_PUZZLE_GUESS_STATUS_KNOWN, "MULT_PUZZLE_GUESS_STATUS_KNOWN", "known"}, {MULT_PUZZLE_GUESS_STATUS_INVALID, "MULT_PUZZLE_GUESS_STATUS_INVALID", "invalid"}, {0, NULL, NULL}};
		GType mult_puzzle_guess_status_type_id;
		mult_puzzle_guess_status_type_id = g_enum_register_static ("MultPuzzleGuessStatus", values);
		g_once_init_leave (&mult_puzzle_guess_status_type_id__volatile, mult_puzzle_guess_status_type_id);
	}
	return mult_puzzle_guess_status_type_id__volatile;
}


GType mult_puzzle_char_get_type (void) {
	static volatile gsize mult_puzzle_char_type_id__volatile = 0;
	if (g_once_init_enter (&mult_puzzle_char_type_id__volatile)) {
		static const GEnumValue values[] = {{MULT_PUZZLE_CHAR_A, "MULT_PUZZLE_CHAR_A", "a"}, {MULT_PUZZLE_CHAR_B, "MULT_PUZZLE_CHAR_B", "b"}, {MULT_PUZZLE_CHAR_C, "MULT_PUZZLE_CHAR_C", "c"}, {MULT_PUZZLE_CHAR_D, "MULT_PUZZLE_CHAR_D", "d"}, {MULT_PUZZLE_CHAR_E, "MULT_PUZZLE_CHAR_E", "e"}, {MULT_PUZZLE_CHAR_F, "MULT_PUZZLE_CHAR_F", "f"}, {MULT_PUZZLE_CHAR_G, "MULT_PUZZLE_CHAR_G", "g"}, {MULT_PUZZLE_CHAR_H, "MULT_PUZZLE_CHAR_H", "h"}, {MULT_PUZZLE_CHAR_I, "MULT_PUZZLE_CHAR_I", "i"}, {MULT_PUZZLE_CHAR_J, "MULT_PUZZLE_CHAR_J", "j"}, {MULT_PUZZLE_CHAR_INVALID, "MULT_PUZZLE_CHAR_INVALID", "invalid"}, {0, NULL, NULL}};
		GType mult_puzzle_char_type_id;
		mult_puzzle_char_type_id = g_enum_register_static ("MultPuzzleChar", values);
		g_once_init_leave (&mult_puzzle_char_type_id__volatile, mult_puzzle_char_type_id);
	}
	return mult_puzzle_char_type_id__volatile;
}


MultPuzzle* mult_puzzle_construct (GType object_type, gint num_x, gint num_y) {
	MultPuzzle * self = NULL;
	self = (MultPuzzle*) g_object_new (object_type, "num-x-digits", num_x, "num-y-digits", num_y, NULL);
	return self;
}


MultPuzzle* mult_puzzle_new (gint num_x, gint num_y) {
	return mult_puzzle_construct (TYPE_MULT_PUZZLE, num_x, num_y);
}


gchar* mult_puzzle_get_multiplicand (MultPuzzle* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->x);
	result = _tmp0_;
	return result;
}


gchar* mult_puzzle_get_multiplier (MultPuzzle* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->y);
	result = _tmp0_;
	return result;
}


gchar* mult_puzzle_get_answer (MultPuzzle* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->z);
	result = _tmp0_;
	return result;
}


guint mult_puzzle_get_num_addends (MultPuzzle* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) self->priv->addends_length1;
	return result;
}


gchar* mult_puzzle_get_addend (MultPuzzle* self, gint n) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (n < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = n >= self->priv->addends_length1;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_strdup (self->priv->addends[n]);
	result = _tmp1_;
	return result;
}


MultPuzzleGuessStatus mult_puzzle_guess (MultPuzzle* self, gint digit, MultPuzzleChar letter) {
	MultPuzzleGuessStatus result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	MultPuzzleGuessStatus rv = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (digit < 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = digit > 9;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = letter == MULT_PUZZLE_CHAR_INVALID;
	}
	if (_tmp0_) {
		result = MULT_PUZZLE_GUESS_STATUS_INVALID;
		return result;
	}
	if (self->priv->symbols[digit] == letter) {
		gint _tmp2_;
		gint _tmp3_;
		mult_puzzle_solve_digit (self, digit);
		_tmp2_ = self->priv->_total_guesses;
		mult_puzzle_set_total_guesses (self, _tmp2_ + 1);
		_tmp3_ = self->priv->_correct_guesses;
		mult_puzzle_set_correct_guesses (self, _tmp3_ + 1);
		self->priv->have_guessed[((((gint) letter) - ((gint) MULT_PUZZLE_CHAR_A)) * 10) + digit] = TRUE;
		rv = MULT_PUZZLE_GUESS_STATUS_CORRECT;
	} else {
		if (self->priv->symbols[digit] == MULT_PUZZLE_CHAR_INVALID) {
			rv = MULT_PUZZLE_GUESS_STATUS_KNOWN;
		} else {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = self->priv->_total_guesses;
			mult_puzzle_set_total_guesses (self, _tmp4_ + 1);
			_tmp5_ = self->priv->_wrong_guesses;
			mult_puzzle_set_wrong_guesses (self, _tmp5_ + 1);
			self->priv->have_guessed[((((gint) letter) - ((gint) MULT_PUZZLE_CHAR_A)) * 10) + digit] = TRUE;
			rv = MULT_PUZZLE_GUESS_STATUS_WRONG;
		}
	}
	g_signal_emit_by_name (self, "guessed", digit, letter, rv);
	result = rv;
	return result;
}


void mult_puzzle_solve (MultPuzzle* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				mult_puzzle_solve_digit (self, i);
			}
		}
	}
}


MultPuzzleChar mult_puzzle_solve_digit (MultPuzzle* self, gint digit) {
	MultPuzzleChar result = 0;
	gboolean _tmp0_ = FALSE;
	MultPuzzleChar symbol;
	gboolean any_left;
	g_return_val_if_fail (self != NULL, 0);
	if (digit < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = digit > 9;
	}
	if (_tmp0_) {
		result = MULT_PUZZLE_CHAR_INVALID;
		return result;
	}
	if (!self->priv->needed[digit]) {
		result = MULT_PUZZLE_CHAR_INVALID;
		return result;
	}
	mult_puzzle_replace (self, &self->priv->x, digit);
	mult_puzzle_replace (self, &self->priv->y, digit);
	mult_puzzle_replace (self, &self->priv->z, digit);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_;
				gchar* addend;
				gchar* _tmp3_;
				gchar* _tmp4_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < self->priv->addends_length1)) {
					break;
				}
				_tmp2_ = g_strdup (self->priv->addends[i]);
				addend = _tmp2_;
				mult_puzzle_replace (self, &addend, digit);
				_tmp3_ = g_strdup (addend);
				_tmp4_ = _tmp3_;
				_g_free0 (self->priv->addends[i]);
				self->priv->addends[i] = _tmp4_;
				_g_free0 (addend);
			}
		}
	}
	symbol = self->priv->symbols[digit];
	self->priv->symbols[digit] = MULT_PUZZLE_CHAR_INVALID;
	self->priv->needed[digit] = FALSE;
	self->priv->unknown[digit] = FALSE;
	any_left = FALSE;
	{
		gboolean* g_collection;
		int g_collection_length1;
		int g_it;
		g_collection = self->priv->needed;
		g_collection_length1 = self->priv->needed_length1;
		for (g_it = 0; g_it < self->priv->needed_length1; g_it = g_it + 1) {
			gboolean g;
			g = g_collection[g_it];
			{
				if (g) {
					any_left = TRUE;
					break;
				}
			}
		}
	}
	if (!any_left) {
		mult_puzzle_set_is_done (self, TRUE);
	}
	g_signal_emit_by_name (self, "changed");
	result = symbol;
	return result;
}


gboolean* mult_puzzle_get_unknown_digits (MultPuzzle* self, int* result_length1) {
	gboolean* result = NULL;
	gboolean* _tmp0_ = NULL;
	gboolean* rv;
	gint rv_length1;
	gint _rv_size_;
	gboolean* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gboolean, self->priv->unknown_length1);
	rv = _tmp0_;
	rv_length1 = self->priv->unknown_length1;
	_rv_size_ = self->priv->unknown_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < self->priv->unknown_length1)) {
					break;
				}
				rv[i] = self->priv->unknown[i];
			}
		}
	}
	_tmp2_ = rv;
	*result_length1 = rv_length1;
	result = _tmp2_;
	return result;
}


gboolean* mult_puzzle_get_needed_digits (MultPuzzle* self, int* result_length1) {
	gboolean* result = NULL;
	gboolean* _tmp0_ = NULL;
	gboolean* rv;
	gint rv_length1;
	gint _rv_size_;
	gboolean* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gboolean, self->priv->needed_length1);
	rv = _tmp0_;
	rv_length1 = self->priv->needed_length1;
	_rv_size_ = self->priv->needed_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < self->priv->needed_length1)) {
					break;
				}
				rv[i] = self->priv->needed[i];
			}
		}
	}
	_tmp2_ = rv;
	*result_length1 = rv_length1;
	result = _tmp2_;
	return result;
}


gboolean* mult_puzzle_get_letter_guesses (MultPuzzle* self, MultPuzzleChar letter, int* result_length1) {
	gboolean* result = NULL;
	gboolean* _tmp0_ = NULL;
	gboolean* rv;
	gint rv_length1;
	gint _rv_size_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gboolean, 10);
	rv = _tmp0_;
	rv_length1 = 10;
	_rv_size_ = 10;
	if (letter == MULT_PUZZLE_CHAR_INVALID) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					if (!_tmp1_) {
						i++;
					}
					_tmp1_ = FALSE;
					if (!(i < 10)) {
						break;
					}
					rv[i] = FALSE;
				}
			}
		}
	} else {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!(i < 10)) {
						break;
					}
					rv[i] = self->priv->have_guessed[((((gint) letter) - ((gint) MULT_PUZZLE_CHAR_A)) * 10) + i];
				}
			}
		}
	}
	_tmp3_ = rv;
	*result_length1 = rv_length1;
	result = _tmp3_;
	return result;
}


static void mult_puzzle_expand_num_string (MultPuzzle* self, gchar** n, gsize minimum) {
	gint _tmp0_;
	gint _tmp1_;
	gsize difference;
	GString* _tmp2_ = NULL;
	GString* rv;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = strlen (*n);
	if (_tmp0_ >= minimum) {
		return;
	}
	_tmp1_ = strlen (*n);
	difference = minimum - _tmp1_;
	_tmp2_ = g_string_new ("");
	rv = _tmp2_;
	{
		gsize i;
		i = (gsize) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					i = i + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < difference)) {
					break;
				}
				g_string_append_c (rv, '0');
			}
		}
	}
	g_string_append (rv, *n);
	_tmp4_ = g_strdup (rv->str);
	_g_free0 (*n);
	*n = _tmp4_;
	_g_string_free0 (rv);
}


static void mult_puzzle_shuffle (MultPuzzleChar* symbolList, int symbolList_length1) {
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint32 _tmp1_;
				gint spot;
				gint j = 0;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				_tmp1_ = g_random_int_range ((gint32) 0, (gint32) (10 - i));
				spot = (gint) _tmp1_;
				{
					gboolean _tmp2_;
					j = 0;
					_tmp2_ = TRUE;
					while (TRUE) {
						if (!_tmp2_) {
							j++;
						}
						_tmp2_ = FALSE;
						if (!(j < 10)) {
							break;
						}
						if (symbolList[j] == MULT_PUZZLE_CHAR_INVALID) {
							gint _tmp3_;
							_tmp3_ = spot;
							spot = _tmp3_ - 1;
							if (_tmp3_ == 0) {
								break;
							}
						}
					}
				}
				symbolList[j] = (MultPuzzleChar) (i + 65);
			}
		}
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static void mult_puzzle_replace (MultPuzzle* self, gchar** n, gint digit) {
	GString* _tmp0_ = NULL;
	GString* rv;
	const gchar* np;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = g_string_new ("");
	rv = _tmp0_;
	np = *n;
	while (TRUE) {
		gint _tmp1_;
		gunichar _tmp2_;
		gunichar ch;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = strlen (np);
		if (!(_tmp1_ > 0)) {
			break;
		}
		_tmp2_ = string_get_char (np, (glong) 0);
		ch = _tmp2_;
		if (((gint) ch) == ((gint) self->priv->symbols[digit])) {
			g_string_append_c (rv, (gchar) (digit + 48));
		} else {
			g_string_append_unichar (rv, ch);
		}
		_tmp3_ = g_utf8_next_char (np);
		np = _tmp3_;
	}
	_tmp4_ = g_strdup (rv->str);
	_g_free0 (*n);
	*n = _tmp4_;
	_g_string_free0 (rv);
}


static void mult_puzzle_interpret (MultPuzzle* self, gchar** n) {
	GString* _tmp0_ = NULL;
	GString* rv;
	const gchar* np;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = g_string_new ("");
	rv = _tmp0_;
	np = *n;
	while (TRUE) {
		gint _tmp1_;
		gunichar _tmp2_;
		gunichar ch;
		gboolean _tmp3_;
		const gchar* _tmp5_ = NULL;
		_tmp1_ = strlen (np);
		if (!(_tmp1_ > 0)) {
			break;
		}
		_tmp2_ = string_get_char (np, (glong) 0);
		ch = _tmp2_;
		_tmp3_ = g_unichar_isdigit (ch);
		if (_tmp3_) {
			gint _tmp4_;
			_tmp4_ = g_unichar_digit_value (ch);
			g_string_append_c (rv, (gchar) self->priv->symbols[_tmp4_]);
		} else {
			g_string_append_unichar (rv, ch);
		}
		_tmp5_ = g_utf8_next_char (np);
		np = _tmp5_;
	}
	_tmp6_ = g_strdup (rv->str);
	_g_free0 (*n);
	*n = _tmp6_;
	_g_string_free0 (rv);
}


static void mult_puzzle_note_needed (MultPuzzle* self, const gchar* n) {
	const gchar* np;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	np = n;
	while (TRUE) {
		gint _tmp0_;
		gunichar _tmp1_;
		gunichar ch;
		gboolean _tmp2_;
		const gchar* _tmp4_ = NULL;
		_tmp0_ = strlen (np);
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = string_get_char (np, (glong) 0);
		ch = _tmp1_;
		_tmp2_ = g_unichar_isdigit (ch);
		if (_tmp2_) {
			gint _tmp3_;
			_tmp3_ = g_unichar_digit_value (ch);
			self->priv->needed[_tmp3_] = TRUE;
		}
		_tmp4_ = g_utf8_next_char (np);
		np = _tmp4_;
	}
}


static gint mult_puzzle_num_with_n_digits (gint n) {
	gint result = 0;
	gint32 low = 0;
	gint32 high = 0;
	gdouble _tmp1_;
	gint32 _tmp2_;
	if (n <= 1) {
		low = (gint32) 0;
	} else {
		gdouble _tmp0_;
		_tmp0_ = pow ((gdouble) 10, (gdouble) (n - 1));
		low = (gint32) _tmp0_;
	}
	_tmp1_ = pow ((gdouble) 10, (gdouble) n);
	high = (gint32) _tmp1_;
	_tmp2_ = g_random_int_range (low, high);
	result = (gint) _tmp2_;
	return result;
}


gint mult_puzzle_get_num_x_digits (MultPuzzle* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_num_x_digits;
	return result;
}


static void mult_puzzle_set_num_x_digits (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_num_x_digits = value;
	g_object_notify ((GObject *) self, "num-x-digits");
}


gint mult_puzzle_get_num_y_digits (MultPuzzle* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_num_y_digits;
	return result;
}


static void mult_puzzle_set_num_y_digits (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_num_y_digits = value;
	g_object_notify ((GObject *) self, "num-y-digits");
}


gint mult_puzzle_get_total_guesses (MultPuzzle* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_total_guesses;
	return result;
}


static void mult_puzzle_set_total_guesses (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_total_guesses = value;
	g_object_notify ((GObject *) self, "total-guesses");
}


gint mult_puzzle_get_wrong_guesses (MultPuzzle* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_wrong_guesses;
	return result;
}


static void mult_puzzle_set_wrong_guesses (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_wrong_guesses = value;
	g_object_notify ((GObject *) self, "wrong-guesses");
}


gint mult_puzzle_get_correct_guesses (MultPuzzle* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_correct_guesses;
	return result;
}


static void mult_puzzle_set_correct_guesses (MultPuzzle* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_correct_guesses = value;
	g_object_notify ((GObject *) self, "correct-guesses");
}


gboolean mult_puzzle_get_is_done (MultPuzzle* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_done;
	return result;
}


static void mult_puzzle_set_is_done (MultPuzzle* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_done = value;
	g_object_notify ((GObject *) self, "is-done");
}


static void g_cclosure_user_marshal_VOID__INT_ENUM_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_ENUM_ENUM) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_ENUM_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_ENUM_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_enum (param_values + 2), g_value_get_enum (param_values + 3), data2);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static GObject * mult_puzzle_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MultPuzzle * self;
	gboolean* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	MultPuzzleChar* _tmp2_ = NULL;
	gboolean* _tmp3_ = NULL;
	gint _tmp6_;
	gint valX;
	gint valY = 0;
	gint valZ;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** _tmp15_ = NULL;
	parent_class = G_OBJECT_CLASS (mult_puzzle_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MULT_PUZZLE (obj);
	_tmp0_ = g_new0 (gboolean, 10);
	self->priv->needed = (g_free (self->priv->needed), NULL);
	self->priv->needed = _tmp0_;
	self->priv->needed_length1 = 10;
	self->priv->_needed_size_ = 10;
	_tmp1_ = g_new0 (gboolean, 10);
	self->priv->unknown = (g_free (self->priv->unknown), NULL);
	self->priv->unknown = _tmp1_;
	self->priv->unknown_length1 = 10;
	self->priv->_unknown_size_ = 10;
	_tmp2_ = g_new0 (MultPuzzleChar, 10);
	self->priv->symbols = (g_free (self->priv->symbols), NULL);
	self->priv->symbols = _tmp2_;
	self->priv->symbols_length1 = 10;
	self->priv->_symbols_size_ = 10;
	_tmp3_ = g_new0 (gboolean, 100);
	self->priv->have_guessed = (g_free (self->priv->have_guessed), NULL);
	self->priv->have_guessed = _tmp3_;
	self->priv->have_guessed_length1 = 100;
	self->priv->_have_guessed_size_ = 100;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i = i + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				self->priv->needed[i] = FALSE;
				self->priv->unknown[i] = TRUE;
				self->priv->symbols[i] = MULT_PUZZLE_CHAR_INVALID;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							if (!_tmp5_) {
								j++;
							}
							_tmp5_ = FALSE;
							if (!(j < 10)) {
								break;
							}
							self->priv->have_guessed[(i * 10) + j] = FALSE;
						}
					}
				}
			}
		}
	}
	mult_puzzle_shuffle (self->priv->symbols, self->priv->symbols_length1);
	_tmp6_ = mult_puzzle_num_with_n_digits (self->priv->_num_x_digits);
	valX = _tmp6_;
	{
		gboolean _tmp7_;
		_tmp7_ = TRUE;
		while (TRUE) {
			gint _tmp8_;
			if (!_tmp7_) {
				if (!((valY % 10) == 0)) {
					break;
				}
			}
			_tmp7_ = FALSE;
			_tmp8_ = mult_puzzle_num_with_n_digits (self->priv->_num_y_digits);
			valY = _tmp8_;
		}
	}
	valZ = valX * valY;
	_tmp9_ = g_strdup_printf ("%i", valX);
	_g_free0 (self->priv->x);
	self->priv->x = _tmp9_;
	_tmp10_ = g_strdup_printf ("%i", valY);
	_g_free0 (self->priv->y);
	self->priv->y = _tmp10_;
	_tmp11_ = g_strdup_printf ("%i", valZ);
	_g_free0 (self->priv->z);
	self->priv->z = _tmp11_;
	_tmp12_ = strlen (self->priv->x);
	_tmp13_ = strlen (self->priv->y);
	mult_puzzle_expand_num_string (self, &self->priv->z, (gsize) (_tmp12_ + _tmp13_));
	_tmp14_ = strlen (self->priv->y);
	_tmp15_ = g_new0 (gchar*, _tmp14_ + 1);
	self->priv->addends = (_vala_array_free (self->priv->addends, self->priv->addends_length1, (GDestroyNotify) g_free), NULL);
	self->priv->addends = _tmp15_;
	self->priv->addends_length1 = _tmp14_;
	self->priv->_addends_size_ = _tmp14_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				gint _tmp18_;
				gchar _tmp19_;
				gint _tmp20_;
				gint addend;
				gchar* _tmp21_ = NULL;
				gchar* addend_str;
				gint _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				if (!_tmp16_) {
					i++;
				}
				_tmp16_ = FALSE;
				_tmp17_ = strlen (self->priv->y);
				if (!(i < _tmp17_)) {
					break;
				}
				_tmp18_ = strlen (self->priv->y);
				_tmp19_ = string_get (self->priv->y, (glong) ((_tmp18_ - i) - 1));
				_tmp20_ = g_ascii_digit_value (_tmp19_);
				addend = valX * _tmp20_;
				_tmp21_ = g_strdup_printf ("%i", addend);
				addend_str = _tmp21_;
				_tmp22_ = strlen (self->priv->x);
				mult_puzzle_expand_num_string (self, &addend_str, (gsize) (_tmp22_ + 1));
				mult_puzzle_note_needed (self, addend_str);
				mult_puzzle_interpret (self, &addend_str);
				_tmp23_ = g_strdup (addend_str);
				_tmp24_ = _tmp23_;
				_g_free0 (self->priv->addends[i]);
				self->priv->addends[i] = _tmp24_;
				_g_free0 (addend_str);
			}
		}
	}
	mult_puzzle_note_needed (self, self->priv->x);
	mult_puzzle_note_needed (self, self->priv->y);
	mult_puzzle_note_needed (self, self->priv->z);
	mult_puzzle_interpret (self, &self->priv->x);
	mult_puzzle_interpret (self, &self->priv->y);
	mult_puzzle_interpret (self, &self->priv->z);
	return obj;
}


static void mult_puzzle_class_init (MultPuzzleClass * klass) {
	mult_puzzle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MultPuzzlePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_mult_puzzle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mult_puzzle_set_property;
	G_OBJECT_CLASS (klass)->constructor = mult_puzzle_constructor;
	G_OBJECT_CLASS (klass)->finalize = mult_puzzle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_NUM_X_DIGITS, g_param_spec_int ("num-x-digits", "num-x-digits", "num-x-digits", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_NUM_Y_DIGITS, g_param_spec_int ("num-y-digits", "num-y-digits", "num-y-digits", G_MININT, G_MAXINT, 2, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_TOTAL_GUESSES, g_param_spec_int ("total-guesses", "total-guesses", "total-guesses", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_WRONG_GUESSES, g_param_spec_int ("wrong-guesses", "wrong-guesses", "wrong-guesses", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_CORRECT_GUESSES, g_param_spec_int ("correct-guesses", "correct-guesses", "correct-guesses", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MULT_PUZZLE_IS_DONE, g_param_spec_boolean ("is-done", "is-done", "is-done", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("guessed", TYPE_MULT_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_ENUM_ENUM, G_TYPE_NONE, 3, G_TYPE_INT, TYPE_MULT_PUZZLE_CHAR, TYPE_MULT_PUZZLE_GUESS_STATUS);
	g_signal_new ("changed", TYPE_MULT_PUZZLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void mult_puzzle_instance_init (MultPuzzle * self) {
	self->priv = MULT_PUZZLE_GET_PRIVATE (self);
	self->priv->_num_x_digits = 3;
	self->priv->_num_y_digits = 2;
	self->priv->_total_guesses = 0;
	self->priv->_wrong_guesses = 0;
	self->priv->_correct_guesses = 0;
	self->priv->_is_done = FALSE;
}


static void mult_puzzle_finalize (GObject* obj) {
	MultPuzzle * self;
	self = MULT_PUZZLE (obj);
	self->priv->symbols = (g_free (self->priv->symbols), NULL);
	self->priv->needed = (g_free (self->priv->needed), NULL);
	self->priv->unknown = (g_free (self->priv->unknown), NULL);
	self->priv->have_guessed = (g_free (self->priv->have_guessed), NULL);
	_g_free0 (self->priv->x);
	_g_free0 (self->priv->y);
	_g_free0 (self->priv->z);
	self->priv->addends = (_vala_array_free (self->priv->addends, self->priv->addends_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (mult_puzzle_parent_class)->finalize (obj);
}


GType mult_puzzle_get_type (void) {
	static volatile gsize mult_puzzle_type_id__volatile = 0;
	if (g_once_init_enter (&mult_puzzle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MultPuzzleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mult_puzzle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultPuzzle), 0, (GInstanceInitFunc) mult_puzzle_instance_init, NULL };
		GType mult_puzzle_type_id;
		mult_puzzle_type_id = g_type_register_static (G_TYPE_OBJECT, "MultPuzzle", &g_define_type_info, 0);
		g_once_init_leave (&mult_puzzle_type_id__volatile, mult_puzzle_type_id);
	}
	return mult_puzzle_type_id__volatile;
}


static void _vala_mult_puzzle_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MultPuzzle * self;
	self = MULT_PUZZLE (object);
	switch (property_id) {
		case MULT_PUZZLE_NUM_X_DIGITS:
		g_value_set_int (value, mult_puzzle_get_num_x_digits (self));
		break;
		case MULT_PUZZLE_NUM_Y_DIGITS:
		g_value_set_int (value, mult_puzzle_get_num_y_digits (self));
		break;
		case MULT_PUZZLE_TOTAL_GUESSES:
		g_value_set_int (value, mult_puzzle_get_total_guesses (self));
		break;
		case MULT_PUZZLE_WRONG_GUESSES:
		g_value_set_int (value, mult_puzzle_get_wrong_guesses (self));
		break;
		case MULT_PUZZLE_CORRECT_GUESSES:
		g_value_set_int (value, mult_puzzle_get_correct_guesses (self));
		break;
		case MULT_PUZZLE_IS_DONE:
		g_value_set_boolean (value, mult_puzzle_get_is_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_mult_puzzle_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MultPuzzle * self;
	self = MULT_PUZZLE (object);
	switch (property_id) {
		case MULT_PUZZLE_NUM_X_DIGITS:
		mult_puzzle_set_num_x_digits (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_NUM_Y_DIGITS:
		mult_puzzle_set_num_y_digits (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_TOTAL_GUESSES:
		mult_puzzle_set_total_guesses (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_WRONG_GUESSES:
		mult_puzzle_set_wrong_guesses (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_CORRECT_GUESSES:
		mult_puzzle_set_correct_guesses (self, g_value_get_int (value));
		break;
		case MULT_PUZZLE_IS_DONE:
		mult_puzzle_set_is_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



