/****************************************************************************
** Shared Class code from reading file 'KReportSection.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.2
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
 * Copyright (C) 2001-2007 by OpenMFG, LLC (info@openmfg.com)
 * Copyright (C) 2007-2008 by Adam Pigg (adam@piggz.co.uk)
 * Copyright (C) 2010-2015 Jarosław Staniek <staniek@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KREPORTSECTION_H
#define KREPORTSECTION_H

#include <QCoreApplication>
#include <QSet>
#include <KReportElement>
#include <QSharedData>

//! @brief The KReportSection class represents a section of a report design
/*! A section has optional report header, report footer, page header, page footer,
    group header, group footer and detail.
    In the case of page header and page footer it is possible to define (firstpage, odd, even or lastpage). */
/*! @note objects of this class are explicitly shared, what means they behave like regular
          C++ pointers, except that by doing reference counting and not deleting the shared
          data object until the reference count is 0, they avoid the dangling pointer problem.
          See <a href="http://doc.qt.io/qt-5/qexplicitlyshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: explicit, operator==, custom_clone, virtual_dtor
class KREPORT_EXPORT KReportSection
{
    Q_DECLARE_TR_FUNCTIONS(KReportSection)
public:
    enum Type {
        InvalidType = 0,
        PageHeaderFirst = 1,
        PageHeaderOdd,
        PageHeaderEven,
        PageHeaderLast,
        PageHeaderAny,
        ReportHeader,
        ReportFooter,
        PageFooterFirst,
        PageFooterOdd,
        PageFooterEven,
        PageFooterLast,
        PageFooterAny,
        GroupHeader,
        GroupFooter,
        Detail
    };






    //! @internal data class used to implement explicitly shared class KReportSection.
    //! Provides thread-safe reference counting.
    class KREPORT_EXPORT Data : public QSharedData
    {
    public:
        Data()
        : type(KReportSection::InvalidType)
        , height(-1)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , type(other.type)
         , height(other.height)
         , backgroundColor(other.backgroundColor)
         , elements(other.elements)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const;

        KReportSection::Type type; //!< @see KReportSection::type(), KReportSection::setType()
        qreal height; //!< @see KReportSection::height(), KReportSection::setHeight()
        QColor backgroundColor; //!< @see KReportSection::backgroundColor(), KReportSection::setBackgroundColor()
        QList<KReportElement> elements; //!< @see KReportSection::elements()

        /*! @internal A set that helps to quickly check if element is part of the section. */
        QSet<KReportElement> elementsSet; //!< @internal
    };

    KReportSection()
     : d(new Data)
    {
    }

    KReportSection(const KReportSection &other)
     : d(other.d)
    {
    }

    virtual ~KReportSection();

    /*!
    @return section type
    Default section type is InvalidType.
    */
    KReportSection::Type type() const {
        return d->type;
    }

    /*!
    Sets section type.
    */
    void setType(KReportSection::Type type) {
        d->type = type;
    }

    /*!
    @return section height measured in points
    It is equal to KReportSection::defaultHeight() unless setHeight()
    is called with value > 0.
    */
    qreal height() const;

    /*!
    Sets section height measured in points.
    Set negative value to reset to the default height.
    */
    void setHeight(qreal height) {
        d->height = height;
    }

    /*!
    @return section background color
    It is equal to KReportSection::defaultBackgroundColor() unless setBackgroundColor()
    is called with a valid color.
    */
    QColor backgroundColor() const;

    /*!
    Sets section background color.
    Set invalid color (QColor()) to reset to the default background color.
    */
    void setBackgroundColor(const QColor & backgroundColor) {
        d->backgroundColor = backgroundColor;
    }

    /*!
    @return all elements of this section
    */
    QList<KReportElement> elements() const;

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KReportSection &other) const {
        return d == other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KReportSection &other) const {
        return !operator==(other);
    }

    //! Clones the object with all attributes; the copy isn't shared with the original.
    virtual KReportSection clone() const {
        return KReportSection(d->clone());
    }

    //! Adds element @a element to this section.
    //! @return true on success.
    //! Adding fails if element is already added to this or other section.
    //! Use KReportElement::clone() to add a copy.
    bool addElement(const KReportElement &element);

    //! Adds element @a element to this section at index position @a i.
    //! @return true on success.
    //! Adding fails if element is already added to this or other section or if
    //! position @a i is out of bounds.
    //! Use KReportElement::clone() to add a copy.
    bool insertElement(int i, const KReportElement &element);

    //! Removes element @a element from this section.
    //! @return true on success.
    //! Removing fails if element @a element is not added in this section.
    bool removeElement(const KReportElement &element);

    //! Removes element from index position @a i from this section.
    //! @return true on success.
    //! Removing fails position @a i is out of bounds.
    bool removeElementAt(int i);

    //! @return default height for report sections. The standard is 2cm (converted to points).
    static qreal defaultHeight();

    //! Sets default height for report sections in points.
    static void setDefaultHeight(qreal height);

    //! @return default background color for report sections. The standard is white.
    static QColor defaultBackgroundColor();

    //! Sets default background color for report sections.
    static void setDefaultBackgroundColor(const QColor &color);

protected:
    KReportSection(Data *data)
     : d(data)
    {
    }

    KReportSection(QExplicitlySharedDataPointer<KReportSection::Data> &data)
     : d(data)
    {
    }

    QExplicitlySharedDataPointer<Data> d;
};

template<>
KREPORT_EXPORT KReportSection::Data *QSharedDataPointer<KReportSection::Data>::clone();

#endif // KREPORTSECTION_H
