/*
	CabIVModels.h
	
	Copyright 2012 Tim Goetze <tim@quitte.de>
	
	http://quitte.de/dsp/

*/
/*
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 3
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA or point your web browser to http://www.gnu.org.
*/

/* mega wookie 800 */
ParModel<16,128> mega_wookie_800_46722 = {
	0.21193892, 
	{
		4.80748428, -4.85616408, -0.05815100, 0.08299078,
		-1.34901638, -0.92736245, -0.01325643, -0.02714517,
		0.07331849, -0.01506278, -0.06447990, 0.07655136,
		-0.01951140, -0.05089339, -0.00510127, 0.00332944,
		-0.01231372, 0.02506967, -0.00497168, -0.02351747,
		-0.00021155, 0.00083574, -0.00526852, -0.01423403,
		-0.01019678, -0.00062682, 0.00773828, 0.00485999,
		0.00187431, -0.00065865, 7.73890850, -0.86691238,
	}, 
	{
		0.72266888, 1.91857663, 0.03159686, -0.09060433,
		2.47503459, 0.48367658, 0.02029131, 0.11416821,
		-0.12042531, -0.01705459, 0.04982942, -0.07568787,
		0.01943511, 0.04300538, 0.00661081, -0.00365472,
		0.01267277, -0.02887421, 0.00387104, 0.01880805,
		0.00090925, -0.00182520, 0.00545063, 0.01455859,
		0.00828050, 0.00159781, -0.00797348, -0.00477123,
		-0.00182287, 0.00065459, 9.65343304, 0.86538120,
	}, 
	{
		-0.07780496, -0.02296236, 0.83998577, 1.14074908,
		1.19943236, 1.29235747, 1.60890392, 1.67548970,
		1.76163361, 1.81372742, 1.85949092, 1.87082575,
		1.89758229, 1.90844189, 1.93634596, 1.94527821,
		1.94821677, 1.95243500, 1.96610359, 1.97304970,
		1.97422778, 1.97459810, 1.98066986, 1.98315093,
		1.98538890, 1.99054106, 1.99249078, 1.99431801,
		1.99571706, 1.99834774, -1.79655156, 1.82404846,
	}, 
	{
		-0.78673921, -0.62665871, -0.95380031, -0.94842174,
		-0.45948040, -0.86134357, -0.97395038, -0.94837890,
		-0.96354492, -0.97385731, -0.97657976, -0.97002905,
		-0.97981798, -0.97585686, -0.99320255, -0.98844924,
		-0.98512332, -0.98079135, -0.99065371, -0.98027582,
		-0.98885253, -0.99395707, -0.99257204, -0.99068957,
		-0.98915753, -0.99452224, -0.99355670, -0.99642180,
		-0.99617440, -0.99835290, -0.80579410, -0.82479332,
	}, 
	{
		-4.29538929, 3.09901019, -0.55472772, 0.04161946,
		1.35421535, -4.70363820, 7.17398145, -5.27665849,
		6.40392413, -7.04782360, 8.41218535, -8.59603180,
		6.35559929, -8.18787084, 8.17232933, -7.78252547,
		7.30530951, -6.56503804, 7.61292981, -6.81291447,
		6.39960671, -5.57349408, 6.44982190, -5.64717655,
		5.04175692, -5.29843156, 4.32775458, -5.18010205,
		3.89943456, -4.00584923, 3.89179457, -3.58703881,
		3.41122886, -3.11552735, 2.81861016, -3.12962723,
		2.33278973, -2.64006329, 2.10895428, -2.36920860,
		1.84959381, -2.04852304, 1.56372089, -1.84285315,
		1.45561346, -1.45912045, 1.34962169, -1.25001765,
		1.23012135, -1.04165647, 1.01941665, -1.06978569,
		0.71349125, -1.02336236, 0.65765752, -0.74827346,
		0.72539695, -0.59477658, 0.57473309, -0.61001238,
		0.44717129, -0.53451147, 0.38907872, -0.49894153,
		0.27166534, -0.49523902, 0.21864946, -0.39834960,
		0.23588877, -0.32053314, 0.21790031, -0.25808805,
		0.20579291, -0.23767771, 0.14812501, -0.21040047,
		0.16428347, -0.13840964, 0.16692063, -0.11129239,
		0.15334731, -0.08922627, 0.12747125, -0.10357818,
		0.06603435, -0.13776259, 0.03726706, -0.09061515,
		0.09409915, -0.02395851, 0.09525042, -0.05166070,
		0.03883586, -0.06927533, 0.03032785, -0.05503071,
		0.03489016, -0.03342098, 0.05440526, 0.00216772,
		0.07401808, 0.01323585, 0.05599905, -0.01724595,
		0.00357766, -0.06188520, -0.03264198, -0.07954195,
		-0.04767567, -0.07684088, -0.03069340, -0.04118242,
		-0.00111820, -0.01826989, 0.01615859, 0.00915537,
		0.04157939, 0.02562829, 0.03825804, 0.01729152,
		0.03287969, 0.02244307, 0.03648308, 0.01622729,
		0.01278104, -0.01312582, -0.01242443, -0.02208893,
	}, 
};
/* mega wookie 812 */
ParModel<16,128> mega_wookie_812_46722 = {
	0.21112462, 
	{
		0.82005101, -0.43370979, -0.01560255, -0.00145069,
		-0.66305466, -0.03336245, 0.41217890, -0.08619036,
		-0.01906294, -0.03702998, -0.06501303, -0.04640138,
		-0.11484345, -0.00455994, 0.00295470, -0.01031939,
		0.00160387, -0.01420344, 0.10541219, -0.12273518,
		-0.01147490, 0.00103143, -0.00853796, 0.02195727,
		-0.01133870, 0.00731582, 0.00676483, 0.00868036,
		0.00123462, 0.00074705, 0.02585200, 0.41735702,
	}, 
	{
		0.01183173, 0.54492722, 0.02418536, -0.01844933,
		0.57581720, 0.04443274, -0.35891298, -0.03792343,
		-0.00506071, 0.02290247, 0.03364140, 0.04394898,
		0.08825003, 0.00549101, -0.00276165, 0.01123953,
		-0.00415766, 0.01271068, -0.09784876, 0.11540325,
		0.01185493, -0.00186617, 0.00885037, -0.02434381,
		0.01169603, -0.00784147, -0.00666466, -0.00844738,
		-0.00120854, -0.00075071, 0.02148544, -0.41392651,
	}, 
	{
		-0.12028471, 0.20234656, 0.85150019, 1.16026437,
		1.33840554, 1.60253300, 1.67430263, 1.75966176,
		1.81555691, 1.86031850, 1.87523633, 1.89309268,
		1.89829373, 1.93755799, 1.94666691, 1.94701154,
		1.95786503, 1.96443653, 1.96540433, 1.96662494,
		1.97124527, 1.97547261, 1.98037069, 1.98091996,
		1.98439528, 1.99019847, 1.99229494, 1.99301887,
		1.99608288, 1.99867551, -1.68052316, 1.45822775,
	}, 
	{
		-0.80893732, -0.47545464, -0.95966318, -0.96101398,
		-0.82479194, -0.96684310, -0.93535557, -0.95591611,
		-0.97494716, -0.97821605, -0.96842123, -0.97479034,
		-0.96623996, -0.99461184, -0.98993348, -0.98377111,
		-0.98610988, -0.98889137, -0.97417570, -0.96908171,
		-0.98601125, -0.99477397, -0.99237945, -0.98560501,
		-0.99191795, -0.99123184, -0.99613983, -0.99515523,
		-0.99655235, -0.99868079, -0.70592262, -0.45928780,
	}, 
	{
		0.06826552, 0.57788107, 1.41369110, 1.21246040,
		0.87311915, 1.34268893, 1.27916232, 0.35038824,
		-0.31734163, -0.43808801, -0.85157151, -1.41228150,
		-1.29776419, -0.66717802, -0.28003031, -0.08134507,
		0.30159291, 0.65457127, 0.61209196, 0.44974520,
		0.45238132, 0.41360046, 0.10539711, -0.20054030,
		-0.28833138, -0.25697419, -0.20626290, -0.03808039,
		0.20255436, 0.33190953, 0.30143001, 0.23157279,
		0.14324434, -0.03620794, -0.24847633, -0.35019842,
		-0.30830482, -0.21486707, -0.10138409, 0.04106620,
		0.16645113, 0.21533573, 0.21465738, 0.21259616,
		0.20166435, 0.16310925, 0.11950670, 0.09273088,
		0.07953308, 0.06356960, 0.02618474, -0.03423229,
		-0.09236590, -0.10829644, -0.07086828, -0.01286436,
		0.01930749, 0.01672806, -0.00452456, -0.02959313,
		-0.05107520, -0.06483929, -0.08205931, -0.11044817,
		-0.14287995, -0.16054774, -0.16045734, -0.15582566,
		-0.16227585, -0.17310262, -0.16973663, -0.15333295,
		-0.14203296, -0.14732657, -0.14982488, -0.13449501,
		-0.10871934, -0.09181024, -0.08472499, -0.07724179,
		-0.06711674, -0.06430875, -0.07507439, -0.09449387,
		-0.11297232, -0.12027381, -0.10718813, -0.08027911,
		-0.05827850, -0.05451214, -0.07313442, -0.10171019,
		-0.12019379, -0.12161485, -0.11375378, -0.09575533,
		-0.06518011, -0.02345549, 0.02112359, 0.05682829,
		0.07457128, 0.07440437, 0.06059546, 0.03561860,
		0.00538379, -0.01893620, -0.03261370, -0.03979403,
		-0.04012336, -0.03109409, -0.01120476, 0.01209958,
		0.02953465, 0.04032320, 0.05137609, 0.06428590,
		0.07518655, 0.08041280, 0.08104268, 0.08251858,
		0.08534490, 0.08684820, 0.08206524, 0.06812220,
		0.04746923, 0.02579720, 0.00782180, -0.00257819,
	}, 
};
/* mega wookie 828 */
ParModel<16,128> mega_wookie_828_46722 = {
	0.05058584, 
	{
		-1.91762811, 0.23297480, 0.07802613, 8.51111858,
		22.98955610, 0.01404198, -37.92124410, -0.38462752,
		0.02051863, -0.05724593, -0.01582068, -25.41501310,
		0.04672848, -0.00298481, 0.00747345, -0.00123030,
		-0.02796623, -0.00544748, 0.01820335, -0.02379866,
		-0.00227920, -0.00394961, -0.00894536, -0.00065352,
		-0.00022033, 0.00535611, -0.00276227, 0.00020454,
		0.00364316, 0.00031150, 7.86922305, 9.00225397,
	}, 
	{
		10.70179350, -0.62145989, -0.03675497, 0.60454089,
		0.96328850, 0.01712925, 33.72864920, 0.43606364,
		-0.04985231, 0.03596456, 0.02407081, 22.08308560,
		-0.04804894, 0.00360927, -0.00603146, 0.00053620,
		0.02426847, 0.00236257, -0.01477163, 0.02360282,
		0.00120283, 0.00414924, 0.00897881, -0.00012445,
		0.00111893, -0.00571144, 0.00280337, 0.00023952,
		-0.00360425, -0.00031117, 7.37339692, -9.00189496,
	}, 
	{
		-0.16842471, 0.80032628, 1.13584137, 1.21337465,
		1.46606275, 1.61019433, 1.66781311, 1.72058718,
		1.80780596, 1.85622760, 1.89051020, 1.89895009,
		1.90623987, 1.93811897, 1.94370353, 1.94432856,
		1.95144159, 1.96102764, 1.96899522, 1.97198205,
		1.97493311, 1.97854642, 1.98548951, 1.98933618,
		1.98996795, 1.99270182, 1.99284884, 1.99361164,
		1.99583414, 1.99960973, -1.46971896, 1.28963982,
	}, 
	{
		-0.86343592, -0.92266817, -0.94998369, -0.71854162,
		-0.61537973, -0.96779993, -0.79701964, -0.94207295,
		-0.97137869, -0.97358628, -0.97841933, -0.91376074,
		-0.98039262, -0.99524774, -0.98727731, -0.98147110,
		-0.97862384, -0.98615739, -0.98335984, -0.98013525,
		-0.99409838, -0.99037105, -0.99283147, -0.99379033,
		-0.99143701, -0.99639052, -0.99367677, -0.99585586,
		-0.99626107, -0.99961661, -0.53091124, -0.28966616,
	}, 
	{
		17.19469920, 1.87625952, 0.64010253, 12.31385430,
		2.09828272, -3.27813375, 8.52851034, 10.12113280,
		1.51219761, 0.47146557, 13.71438560, 16.43363920,
		12.96756870, 14.69477920, 20.27367810, 14.67442230,
		7.20777383, 6.95375695, 8.45017929, 2.26931134,
		-3.09249863, -2.68011669, -2.76319995, -7.60444826,
		-9.95507423, -8.26996485, -8.18727978, -10.51331920,
		-9.74764439, -6.94314927, -6.88757109, -8.52279726,
		-7.60170103, -5.69696856, -5.86109385, -6.44435755,
		-5.15050563, -3.99257968, -4.44936662, -4.50183425,
		-3.15816087, -2.47453772, -2.94974161, -2.64841548,
		-1.27757301, -0.54156025, -0.51870068, 0.08097179,
		1.05712431, 1.36286002, 1.38251165, 1.88117861,
		2.29951463, 2.05614327, 1.85437143, 2.21976193,
		2.49530396, 2.25434738, 2.03455507, 2.10767584,
		2.06023173, 1.82168680, 1.75602699, 1.77937388,
		1.52075779, 1.13644718, 1.00017836, 0.96994114,
		0.72756364, 0.40773641, 0.26281384, 0.18189838,
		0.01293539, -0.12661736, -0.15238461, -0.20313892,
		-0.31855112, -0.36260595, -0.33220560, -0.37813068,
		-0.50485267, -0.58361276, -0.60754270, -0.66145844,
		-0.72752781, -0.73931858, -0.71851515, -0.70328586,
		-0.65475724, -0.55936087, -0.49631104, -0.49735084,
		-0.48789120, -0.42428189, -0.35157268, -0.29254188,
		-0.22424708, -0.14674692, -0.08455938, -0.03040279,
		0.03376589, 0.08896166, 0.10961204, 0.11095812,
		0.12161745, 0.13983512, 0.14924353, 0.15060341,
		0.15383676, 0.15701491, 0.16314738, 0.17711977,
		0.18979029, 0.19051098, 0.19096055, 0.20627754,
		0.22887925, 0.23869447, 0.23174176, 0.21966911,
		0.20549148, 0.18632887, 0.16071968, 0.12712630,
		0.08458370, 0.04061204, 0.00868356, -0.00438831,
	}, 
};
/* mega wookie 868 */
ParModel<16,128> mega_wookie_868_46722 = {
	0.24673261, 
	{
		-3.17009039, -0.02101757, 0.03717231, 0.97959864,
		-0.01161164, -0.90015231, 0.01443770, -0.00937293,
		0.17590030, 0.04866781, -0.00634597, -0.00694342,
		-0.01993695, 1.34838487, -0.04309322, 0.00493718,
		-0.00038805, -0.00105489, -0.01689570, -0.00452598,
		0.00068549, 0.02732062, 0.00090928, -0.00636016,
		-0.00216862, 0.00041380, -0.00344889, 0.00373427,
		-0.00031045, -0.00000350, 0.58384874, 0.03859264,
	}, 
	{
		-0.28340784, -0.70138380, 0.00577653, -1.28282850,
		0.03767093, 0.59638568, -0.02447474, -0.00424231,
		-0.27863833, -0.04909413, 0.00888529, 0.00582361,
		0.02111640, -1.30361163, 0.03123850, -0.00640673,
		-0.00061455, 0.00076489, 0.01570138, 0.00422485,
		-0.00051693, -0.02753979, -0.00096271, 0.00651199,
		0.00204842, -0.00068008, 0.00365894, -0.00383749,
		0.00027903, 0.00000345, 0.69193984, -0.03857959,
	}, 
	{
		-0.13835994, 0.80255459, 1.12662695, 1.59254152,
		1.60430792, 1.70831244, 1.81434009, 1.85876011,
		1.89167528, 1.89429730, 1.93476644, 1.94108706,
		1.94590016, 1.94591728, 1.95305120, 1.96574926,
		1.97407892, 1.97580946, 1.98044019, 1.98269248,
		1.98497076, 1.98874809, 1.98993976, 1.99300366,
		1.99336045, 1.99371742, 1.99425312, 1.99433005,
		1.99689107, 1.99992369, -0.86191190, 1.98415052,
	}, 
	{
		-0.78390325, -0.84928129, -0.95485548, -0.65712580,
		-0.96688761, -0.93515591, -0.97922432, -0.97843004,
		-0.96338121, -0.97789967, -0.99152670, -0.98321537,
		-0.98276257, -0.94812427, -0.97946239, -0.99070351,
		-0.99326962, -0.99152687, -0.98802842, -0.99508234,
		-0.99465472, -0.98908763, -0.99647200, -0.99458304,
		-0.99771448, -0.99728911, -0.99660575, -0.99536392,
		-0.99739786, -0.99993002, -0.03268804, -0.98415621,
	}, 
	{
		1.16163281, 0.17672641, -1.14792741, 1.08606535,
		2.21567566, -0.65019912, -1.19397168, 0.39744881,
		0.17573246, -2.10155361, -1.93703071, -0.14351389,
		0.29308822, -0.64575072, -0.64457791, -0.33714766,
		-0.84439248, -1.43140995, -1.12885746, -0.92416871,
		-1.38893805, -1.63897531, -1.13115182, -0.66573479,
		-0.67774844, -0.66951364, -0.37456670, -0.16548497,
		-0.14466945, -0.08852889, -0.06740471, -0.30781972,
		-0.62349377, -0.70375891, -0.58193398, -0.46534111,
		-0.33907875, -0.15596184, -0.00713250, 0.01652509,
		-0.03864465, -0.13747569, -0.29131052, -0.45080423,
		-0.50977105, -0.45229047, -0.35089106, -0.23960595,
		-0.08259931, 0.11176680, 0.26499785, 0.33257368,
		0.33825257, 0.31889756, 0.29338972, 0.27374475,
		0.25151121, 0.20434463, 0.12324470, 0.03773927,
		-0.01021130, -0.00682846, 0.01959693, 0.03760826,
		0.03280286, 0.01394444, -0.00334981, -0.00926164,
		-0.01231793, -0.01666167, -0.00978805, 0.01672702,
		0.05790987, 0.10592257, 0.17264727, 0.25817836,
		0.33877705, 0.38514738, 0.39505786, 0.38033219,
		0.34375795, 0.27908973, 0.19098412, 0.09829748,
		0.02035876, -0.02896767, -0.03979562, -0.01810233,
		0.01764709, 0.05129998, 0.07034106, 0.07523024,
		0.07706848, 0.08218131, 0.08834580, 0.10099231,
		0.12194355, 0.14678197, 0.16772917, 0.17926689,
		0.18014486, 0.17329250, 0.15820209, 0.12894315,
		0.08623391, 0.04224190, 0.00575731, -0.02510475,
		-0.05060350, -0.06835375, -0.07304225, -0.06505147,
		-0.04784461, -0.02167452, 0.01565318, 0.05937490,
		0.10090824, 0.13368350, 0.15586063, 0.16931288,
		0.17215346, 0.16278082, 0.14074398, 0.10849614,
		0.07184705, 0.03737695, 0.00984264, -0.00627249,
	}, 
};
/* mega wookie 908 */
ParModel<16,128> mega_wookie_908_46722 = {
	0.19871431, 
	{
		3.84100637, -2.79235737, -0.13725829, 0.08668872,
		0.57534124, -0.11600868, -0.01722286, 0.02001765,
		0.39753550, -0.00002740, -0.00377675, 0.00252666,
		-0.00149320, -0.01901449, -0.00459626, -0.02347584,
		0.00900180, 0.00024609, -0.01579822, -0.00023586,
		-0.00096014, -0.00398772, -0.00210725, -0.00505608,
		0.00166931, -0.00070258, 0.00504544, 0.00091789,
		-0.00027065, -0.00001856, 1.02878592, 0.71520740,
	}, 
	{
		1.33582843, 1.66743014, 0.23545574, -0.11338443,
		-0.91541566, 0.08636745, 0.03081813, -0.01693399,
		-0.38863289, -0.00026443, 0.00274947, -0.00386329,
		0.00108757, 0.01856916, 0.00423494, 0.02320298,
		-0.00804328, -0.00017427, 0.01597259, -0.00002129,
		0.00137879, 0.00380680, 0.00184037, 0.00523727,
		-0.00167472, 0.00085897, -0.00500812, -0.00090830,
		0.00028924, 0.00001846, -4.07916298, -0.71486679,
	}, 
	{
		0.14022729, 1.06825599, 1.58753968, 1.80375644,
		1.83476684, 1.85396599, 1.89344817, 1.92727602,
		1.92755187, 1.94227563, 1.96654690, 1.97321286,
		1.97624292, 1.97897308, 1.98225147, 1.98267465,
		1.98439210, 1.98686582, 1.98772925, 1.98857568,
		1.99010083, 1.99260153, 1.99365954, 1.99418209,
		1.99516009, 1.99554534, 1.99559620, 1.99757606,
		1.99791772, 1.99958769, -0.77941842, 1.92197577,
	}, 
	{
		-0.72610066, -0.90633347, -0.94970041, -0.97083017,
		-0.88440438, -0.97122091, -0.97605044, -0.98246318,
		-0.95806093, -0.98019811, -0.99158169, -0.99254723,
		-0.99207364, -0.98417348, -0.99470522, -0.98998968,
		-0.98494975, -0.99660761, -0.98785126, -0.99517958,
		-0.99264295, -0.99692302, -0.99718013, -0.99652209,
		-0.99528710, -0.99708135, -0.99670483, -0.99825395,
		-0.99834338, -0.99959452, 0.14634613, -0.92201308,
	}, 
	{
		-3.33710615, 3.81381186, -2.42504101, 3.79309274,
		-5.66786909, 3.52245087, 0.92944936, 6.61923968,
		-2.66527088, 0.45565790, -3.46267740, 2.78331135,
		-0.98475045, 2.89121159, -1.27647545, 1.37397835,
		-2.79143188, 0.58109171, -0.94369655, 2.74632755,
		-0.22703895, 0.84890033, -2.31889301, -0.30844413,
		-1.76221678, 0.56197603, -0.99132698, 0.30402492,
		-1.66588768, -0.43429637, -1.34512547, 0.50710393,
		-0.33296832, 0.48226772, -1.00819231, -0.29761931,
		-0.90692903, 0.46172446, 0.12369848, 0.86334969,
		-0.18093221, -0.03541567, -0.87480316, -0.22215797,
		-0.46349563, 0.18076543, -0.34083631, -0.10304496,
		-0.57397124, -0.06604894, -0.17167456, 0.29265720,
		-0.07386540, 0.01882289, -0.38782287, -0.09986996,
		-0.13367052, 0.29735887, 0.16942554, 0.26006244,
		-0.09400509, -0.03782952, -0.18586120, 0.03239616,
		-0.06624758, 0.01619320, -0.20261716, -0.16505965,
		-0.26854522, -0.10347606, -0.12206141, -0.02364924,
		-0.17069377, -0.19244987, -0.30152445, -0.17645049,
		-0.12290839, 0.02714885, 0.00568784, 0.04817845,
		-0.00934683, 0.04083733, 0.01389307, 0.05480271,
		-0.00717586, -0.01767758, -0.07806572, -0.03639871,
		-0.01841455, 0.05760743, 0.05226766, 0.05397072,
		-0.00546622, -0.01162896, -0.03228148, 0.00810230,
		0.02276304, 0.05600562, 0.03659275, 0.02884229,
		-0.00627570, -0.00803632, -0.02746368, -0.03420788,
		-0.07172270, -0.08490893, -0.09471425, -0.06939286,
		-0.05069956, -0.02167643, -0.01563031, -0.00797514,
		-0.01838301, -0.01406017, -0.00743548, 0.01792308,
		0.03420074, 0.05340467, 0.06120244, 0.07815444,
		0.08789553, 0.09758658, 0.08822171, 0.07013537,
		0.03845174, 0.01274807, -0.00954400, -0.01526026,
	}, 
};
/* mega wookie 912 */
ParModel<16,128> mega_wookie_912_46722 = {
	0.22232572, 
	{
		5.88227552, -0.59616358, -0.17517108, 0.07386986,
		-0.25178552, 0.12569101, -0.03342823, -0.03716491,
		0.00421993, -0.00050502, -0.00910720, 0.00371576,
		-0.00365801, -0.00573289, -0.02087807, -0.00762809,
		0.00063121, -0.02038860, 0.00016700, -0.01852337,
		-0.00623277, 0.01098433, -0.01260606, -0.00270654,
		-0.00230578, -0.00061065, 0.00426470, 0.00120033,
		-0.00014706, -0.00001473, -1.04816498, 0.00197711,
	}, 
	{
		0.09753179, 1.10042965, 0.14811415, -0.12160476,
		0.23780737, -0.15612861, 0.03956416, 0.12967531,
		-0.00093517, -0.00342390, 0.00821913, -0.00493576,
		0.00316239, 0.00542834, 0.02037805, 0.00826780,
		-0.00053761, 0.02044985, -0.00032118, 0.01843817,
		0.00606378, -0.01071685, 0.01293847, 0.00248937,
		0.00226353, 0.00073926, -0.00424072, -0.00119800,
		0.00016361, 0.00001459, -0.55672961, -0.00197660,
	}, 
	{
		0.06640773, 1.05933081, 1.58182824, 1.80300140,
		1.85104847, 1.86173742, 1.89428551, 1.91513291,
		1.92733182, 1.94273643, 1.96568412, 1.97356453,
		1.97523880, 1.98193563, 1.98252137, 1.98403132,
		1.98691337, 1.98699217, 1.98973453, 1.99069756,
		1.99205162, 1.99235755, 1.99348891, 1.99383211,
		1.99514273, 1.99585501, 1.99586429, 1.99740011,
		1.99805562, 1.99958047, -0.28932666, 1.99162256,
	}, 
	{
		-0.79088215, -0.89567058, -0.95243442, -0.96879293,
		-0.96589906, -0.88853684, -0.97793779, -0.95021383,
		-0.98389863, -0.98062595, -0.99046119, -0.99294257,
		-0.99074000, -0.99432254, -0.98987326, -0.98886804,
		-0.99653861, -0.98770686, -0.99630762, -0.99088875,
		-0.99634525, -0.99481178, -0.99584969, -0.99732937,
		-0.99525440, -0.99739090, -0.99697070, -0.99806953,
		-0.99847980, -0.99958734, 0.55330495, -0.99162649,
	}, 
	{
		-3.65356011, 0.17252589, 5.11153398, 1.04785343,
		-2.28280283, 0.45513077, 3.76437930, 0.34375235,
		-3.37199881, -2.42217681, 0.76818682, 0.36882380,
		-1.15541738, -0.89906038, 0.49890206, -0.04862544,
		-0.85650446, -0.10133747, 1.52445800, 1.43795365,
		0.39929114, 0.00511624, 0.51081184, 0.44734608,
		-0.06459288, -0.32842140, -0.14646350, -0.29326791,
		-0.55155011, -0.42143259, 0.12098890, 0.28649509,
		-0.00474319, -0.34574888, -0.35040071, -0.24930731,
		-0.12527099, 0.00410167, 0.13977376, 0.06182723,
		-0.17561417, -0.37764536, -0.38435930, -0.34598526,
		-0.36352005, -0.41811531, -0.39759599, -0.31997237,
		-0.19082755, -0.03409496, 0.10361308, 0.12173186,
		0.03621787, -0.04770531, -0.02862166, 0.06248645,
		0.14790191, 0.17619708, 0.15676672, 0.10644722,
		0.06293846, 0.05168048, 0.06388797, 0.05496014,
		0.00644131, -0.05598443, -0.08754639, -0.07760565,
		-0.05002388, -0.03249736, -0.02922754, -0.04445314,
		-0.07661318, -0.11481966, -0.12597000, -0.10249106,
		-0.06582926, -0.04243547, -0.02634672, -0.00252419,
		0.02673456, 0.03990557, 0.02527746, -0.01008137,
		-0.04840738, -0.07140756, -0.06349285, -0.02976611,
		0.00945869, 0.03709975, 0.04465435, 0.03823546,
		0.03220690, 0.03100636, 0.02847069, 0.02720829,
		0.02979651, 0.03480649, 0.03769677, 0.03408306,
		0.02258575, 0.00695232, -0.00949644, -0.02752597,
		-0.04328300, -0.04642814, -0.03457320, -0.01816211,
		-0.00488904, 0.00300443, 0.00898862, 0.01223330,
		0.00969290, 0.00310792, -0.00046561, 0.00167852,
		0.00894010, 0.02020670, 0.03479236, 0.05184468,
		0.06526120, 0.07014698, 0.06458954, 0.05039772,
		0.03207328, 0.01377448, -0.00213539, -0.01195318,
	}, 
};
/* mega wookie 936 */
ParModel<16,128> mega_wookie_936_46722 = {
	0.21051962, 
	{
		-0.33627567, -4.18626416, 0.22629570, -0.01946175,
		-0.00326176, -0.00523471, 0.20370494, -0.02088684,
		0.26096376, 0.00251935, -0.10156129, -0.00401239,
		0.00006874, -0.03802707, -0.01935397, -0.00993982,
		-0.01508690, -0.00192288, -0.01032058, -0.00485454,
		0.00410507, -0.00297263, -0.00053900, -0.00088736,
		0.00000745, 0.00191398, -0.00013801, -0.00066363,
		-0.00056689, -0.00003416, 0.87352380, 1.35085824,
	}, 
	{
		0.59765827, 3.60956517, -0.29929083, -0.05949040,
		0.00571130, 0.00525043, -0.24384173, 0.02147856,
		-0.26339907, -0.00443823, 0.09958281, 0.00257032,
		0.00053150, 0.03661368, 0.02040198, 0.00764694,
		0.01528989, 0.00157376, 0.01005897, 0.00481335,
		-0.00401648, 0.00295872, 0.00054580, 0.00088787,
		-0.00001407, -0.00191454, 0.00012425, 0.00066712,
		0.00056548, 0.00004670, 0.86024311, -1.34645216,
	}, 
	{
		1.02325505, 1.48311403, 1.82221047, 1.87200597,
		1.92728450, 1.94740847, 1.94950866, 1.96068572,
		1.97074029, 1.97379361, 1.97801341, 1.97991715,
		1.98315807, 1.98389874, 1.98466608, 1.98802245,
		1.99066903, 1.99239549, 1.99302309, 1.99504790,
		1.99576323, 1.99625665, 1.99788812, 1.99794166,
		1.99795363, 1.99795674, 1.99798913, 1.99817598,
		1.99821722, 1.99871571, -1.07272711, 1.69904997,
	}, 
	{
		-0.83510514, -0.83100005, -0.95395878, -0.96614162,
		-0.98577443, -0.98456645, -0.96601635, -0.98548036,
		-0.97691991, -0.99313162, -0.97920703, -0.99268306,
		-0.99295213, -0.99022047, -0.99167274, -0.99113854,
		-0.99246834, -0.99676362, -0.99648118, -0.99748202,
		-0.99690636, -0.99786948, -0.99795844, -0.99808054,
		-0.99796495, -0.99796179, -0.99824570, -0.99893045,
		-0.99880665, -0.99914378, -0.24168712, -0.69972674,
	}, 
	{
		2.06082074, 1.84097948, 0.18619296, -1.27161806,
		-1.34332941, -1.25684016, -0.39848298, 0.13404836,
		0.85226543, 1.21267888, 1.43398140, 1.05421827,
		0.33535396, -0.57905515, -1.16482218, -1.26042632,
		-0.79674730, -0.02519723, 0.76012987, 1.26001132,
		1.38818863, 1.20475222, 0.84786770, 0.46819021,
		0.16703883, 0.00366744, -0.00915329, 0.09642118,
		0.23532521, 0.32191727, 0.28803522, 0.11475339,
		-0.15329960, -0.42728015, -0.59315072, -0.58424713,
		-0.41254221, -0.18338609, 0.01179289, 0.13006358,
		0.16569696, 0.12475103, 0.04464517, -0.03103536,
		-0.08072767, -0.10758652, -0.11958373, -0.12330605,
		-0.11408711, -0.09885237, -0.10846259, -0.15471079,
		-0.20712966, -0.22080066, -0.17994219, -0.10157756,
		-0.01929537, 0.04460846, 0.07795020, 0.08287354,
		0.07498503, 0.06936728, 0.05820441, 0.03170545,
		-0.00762756, -0.04362915, -0.06715291, -0.07941327,
		-0.09119555, -0.10301668, -0.10551888, -0.10180937,
		-0.10731154, -0.13247151, -0.15912056, -0.17251863,
		-0.17731310, -0.18736128, -0.19860398, -0.20070809,
		-0.19644914, -0.19994917, -0.21573472, -0.23424314,
		-0.24556386, -0.24556545, -0.23190535, -0.21169972,
		-0.19665579, -0.19146834, -0.19809645, -0.21095054,
		-0.22019239, -0.22394420, -0.22705413, -0.22229754,
		-0.20340283, -0.17144503, -0.13392299, -0.09793278,
		-0.06549577, -0.03225633, 0.00350398, 0.03564695,
		0.06002021, 0.08029126, 0.09687840, 0.10328933,
		0.09939604, 0.09051446, 0.08472168, 0.08260786,
		0.08067347, 0.07981990, 0.08605413, 0.10038485,
		0.11955603, 0.13959198, 0.15795617, 0.17387722,
		0.18285936, 0.18175794, 0.16911229, 0.14565329,
		0.11429962, 0.07867463, 0.04248554, 0.01232696,
	}, 
};
/* mega wookie 968 */
ParModel<16,128> mega_wookie_968_46722 = {
	0.18560194, 
	{
		4.15720962, -0.35196509, -0.06660922, -3.03358779,
		-0.00140135, 0.02288476, 0.02946101, 0.11817485,
		0.00083560, -0.05001579, 0.04755750, -0.00377023,
		-0.00908896, -0.00335351, -0.00173801, 0.00061784,
		-0.00595189, 0.00303944, -0.00345043, -0.00235085,
		-0.00054841, -0.00091167, -0.00079649, -0.00029133,
		0.00081483, 0.00077234, -0.00088655, -0.00053786,
		0.00011383, -0.00047203, -0.00022658, -0.00020637,
	}, 
	{
		2.24617923, 1.86072693, 0.02124081, 3.10792863,
		0.00126134, -0.02217774, -0.03437755, -0.12270852,
		-0.00056109, 0.05280073, -0.04685635, 0.00359787,
		0.00952277, 0.00308692, 0.00160148, -0.00066909,
		0.00594757, -0.00296899, 0.00344602, 0.00236742,
		0.00055604, 0.00091629, 0.00078201, 0.00032945,
		-0.00081368, -0.00077821, 0.00088682, 0.00053869,
		-0.00011903, 0.00047338, 0.00022398, 0.00020653,
	}, 
	{
		-0.78629330, 1.11857871, 1.87853719, 1.93622457,
		1.95385687, 1.96994877, 1.97117873, 1.97140258,
		1.98490403, 1.98573292, 1.98895934, 1.99227915,
		1.99372441, 1.99401612, 1.99473327, 1.99601070,
		1.99603408, 1.99687754, 1.99714021, 1.99788815,
		1.99803554, 1.99816960, 1.99819191, 1.99820883,
		1.99830524, 1.99859610, 1.99877984, 1.99889453,
		1.99896050, 1.99896282, 1.99921112, 1.99942459,
	}, 
	{
		-0.17274227, -0.66855189, -0.97214231, -0.94890669,
		-0.99080451, -0.99076541, -0.98365094, -0.97692689,
		-0.99212157, -0.98817269, -0.98961534, -0.99653641,
		-0.99546434, -0.99751958, -0.99715205, -0.99691626,
		-0.99761006, -0.99800960, -0.99714355, -0.99846659,
		-0.99807312, -0.99818908, -0.99893310, -0.99864553,
		-0.99864028, -0.99886047, -0.99879047, -0.99898905,
		-0.99915310, -0.99902914, -0.99935010, -0.99942977,
	}, 
	{
		-0.64080559, 2.85383857, 1.35623479, 1.99483574,
		2.97901733, 3.03247505, 2.53295988, 1.31038628,
		0.10543638, -0.73842725, -1.02850402, -0.99923466,
		-0.88817085, -0.88976880, -1.03715585, -1.29727131,
		-1.55749519, -1.69327523, -1.67723082, -1.57560256,
		-1.49305521, -1.49080170, -1.59685079, -1.74604842,
		-1.86860551, -1.89601628, -1.81702481, -1.66031569,
		-1.49168863, -1.34528125, -1.23402706, -1.15224166,
		-1.08806981, -1.02730272, -0.93291115, -0.77523876,
		-0.55042081, -0.31234940, -0.09903530, 0.07753826,
		0.21512134, 0.30702394, 0.37473727, 0.44863875,
		0.53813231, 0.62687506, 0.69507514, 0.73162852,
		0.74756724, 0.75029761, 0.72302336, 0.66005093,
		0.58813017, 0.54343936, 0.53536750, 0.54752617,
		0.55340437, 0.53989334, 0.50166889, 0.44359526,
		0.38076882, 0.32634328, 0.27012989, 0.19941640,
		0.11308505, 0.02378673, -0.06109515, -0.14142457,
		-0.22356112, -0.30208438, -0.36232066, -0.40412753,
		-0.44187603, -0.48631663, -0.52000702, -0.52899595,
		-0.51902493, -0.50572773, -0.48754542, -0.45698339,
		-0.41945888, -0.39119046, -0.37819707, -0.37187184,
		-0.36269650, -0.34619717, -0.31880388, -0.28561587,
		-0.25595431, -0.23236239, -0.21540945, -0.19913264,
		-0.17429535, -0.14037999, -0.10410668, -0.06042315,
		-0.00533089, 0.05795493, 0.12019326, 0.17317670,
		0.21452751, 0.24898358, 0.27925928, 0.30065574,
		0.31073429, 0.31498824, 0.31559953, 0.30758371,
		0.29187715, 0.27428445, 0.26276045, 0.25723324,
		0.25315263, 0.25017003, 0.25303479, 0.26166449,
		0.27202488, 0.27978308, 0.28252020, 0.28004343,
		0.26881408, 0.24688855, 0.21409209, 0.17237089,
		0.12565569, 0.07827854, 0.03428868, 0.00023333,
	}, 
};
/* mega wookie 992 */
ParModel<16,128> mega_wookie_992_46722 = {
	0.23434262, 
	{
		0.58165294, 0.10164938, -0.01719820, 0.00650457,
		0.00394676, 0.00904611, 0.00025157, -0.00016501,
		0.00020791, -0.00047715, -0.00093271, 0.00132128,
		0.00118168, -0.00035874, -0.00037456, -0.00022080,
		0.00016017, 0.00011813, 0.00007015, -0.00032881,
		0.00000335, -0.00016487, 0.00018307, -0.00007449,
		-0.00000456, 0.00009177, -0.00008215, -0.00013487,
		0.00008688, 0.00006926, 0.00016066, -0.16547404,
	}, 
	{
		-0.38283071, -0.10460305, 0.01624078, -0.00643445,
		-0.00396526, -0.00928594, -0.00023634, 0.00014970,
		-0.00019801, 0.00046456, 0.00092916, -0.00131790,
		-0.00117983, 0.00035427, 0.00037494, 0.00022259,
		-0.00015915, -0.00011684, -0.00006888, 0.00032989,
		-0.00000203, 0.00016558, -0.00018272, 0.00007572,
		0.00000467, -0.00009223, 0.00008246, 0.00013477,
		-0.00008680, -0.00006925, -0.00016054, 0.15823370,
	}, 
	{
		1.63217727, 1.96365034, 1.98327831, 1.99278252,
		1.99421539, 1.99428296, 1.99718721, 1.99841213,
		1.99841262, 1.99873984, 1.99877638, 1.99905802,
		1.99906165, 1.99918377, 1.99939547, 1.99949697,
		1.99953674, 1.99953927, 1.99958470, 1.99960365,
		1.99961304, 1.99961872, 1.99962360, 1.99962756,
		1.99971533, 1.99971591, 1.99972525, 1.99976049,
		1.99978403, 1.99981515, 1.99983076, 1.07091547,
	}, 
	{
		-0.68493390, -0.97232991, -0.98675206, -0.99475087,
		-0.99493141, -0.99534565, -0.99777633, -0.99870854,
		-0.99884343, -0.99896855, -0.99889374, -0.99906717,
		-0.99906340, -0.99936346, -0.99953564, -0.99957255,
		-0.99955795, -0.99956695, -0.99961955, -0.99960993,
		-0.99965628, -0.99968353, -0.99963913, -0.99968062,
		-0.99971585, -0.99972680, -0.99981858, -0.99976197,
		-0.99978741, -0.99981519, -0.99983754, -0.07363420,
	}, 
	{
		-0.31820322, -0.08745310, 0.22249842, 0.46996336,
		0.50026417, 0.36663486, 0.10243348, -0.25891906,
		-0.56480992, -0.70808154, -0.63361530, -0.46628729,
		-0.27253918, -0.11792223, -0.01043174, 0.02455022,
		0.01789181, 0.04222943, 0.12303906, 0.22830283,
		0.29493589, 0.28740341, 0.18061034, 0.02756940,
		-0.11600792, -0.18817159, -0.17490657, -0.09711282,
		-0.01371025, 0.04346942, 0.05920163, 0.03483274,
		-0.02118206, -0.09536306, -0.14872451, -0.14807351,
		-0.08567625, -0.01191834, 0.03831697, 0.05614206,
		0.04265299, -0.00528346, -0.06275990, -0.09659278,
		-0.09555075, -0.07527379, -0.05590477, -0.04975387,
		-0.04762102, -0.04435338, -0.05924784, -0.10057944,
		-0.14408382, -0.15578893, -0.12806783, -0.07851145,
		-0.03423035, -0.00836307, -0.00579227, -0.02088436,
		-0.03761257, -0.04190374, -0.04320052, -0.05378321,
		-0.07475987, -0.09395749, -0.10497388, -0.10912097,
		-0.11458770, -0.11803916, -0.10699130, -0.08343209,
		-0.06364476, -0.05993352, -0.05594228, -0.03826942,
		-0.01264579, 0.00584296, 0.01977493, 0.03803222,
		0.05682425, 0.06165553, 0.04818342, 0.02651387,
		0.00738050, -0.00388478, -0.00324675, 0.00427231,
		0.00908220, 0.00809939, 0.00004130, -0.00990323,
		-0.01321822, -0.00994814, -0.00713059, 0.00027285,
		0.01657746, 0.03920816, 0.05984751, 0.07142700,
		0.07283347, 0.07009314, 0.06712770, 0.06026708,
		0.04784142, 0.03579468, 0.02641134, 0.01446169,
		0.00031905, -0.01103674, -0.01266080, -0.00573082,
		0.00409523, 0.01544861, 0.03222353, 0.05370597,
		0.07548873, 0.09313389, 0.10436882, 0.10935871,
		0.10507633, 0.09017239, 0.06507354, 0.03226087,
		-0.00393071, -0.03894484, -0.06871746, -0.08690387,
	}, 
};
/* unmatched */
ParModel<16,128> unmatched_46722 = {
	0.10239974, 
	{
		-0.17912432, -0.01442562, -0.05322812, 0.04526132,
		0.44320346, 0.06457513, 0.00956053, -0.05095579,
		-0.00101306, 0.00222894, -0.00015071, 0.00346827,
		0.00316668, -0.00061584, -0.00167643, -0.00022875,
		-0.00022404, -0.00052300, 0.00025100, -0.00066157,
		-0.00060573, -0.00025383, -0.00034791, -0.00021294,
		-0.00024970, -0.00018806, -0.00020005, -0.00019736,
		-0.00016506, 0.00020418, -0.00035024, -0.02000277,
	}, 
	{
		1.13321588, -0.00808117, 0.05362893, -0.04513120,
		-0.43080485, -0.07016376, -0.01099341, 0.05046307,
		0.00113104, -0.00211266, 0.00039261, -0.00349542,
		-0.00318889, 0.00058061, 0.00167600, 0.00022319,
		0.00021806, 0.00052394, -0.00025654, 0.00066177,
		0.00060586, 0.00025769, 0.00034593, 0.00021380,
		0.00025040, 0.00018678, 0.00020037, 0.00019728,
		0.00016560, -0.00020309, 0.00035071, 0.01915514,
	}, 
	{
		1.40624623, 1.95746546, 1.98105432, 1.98141043,
		1.98448429, 1.98783267, 1.99265050, 1.99265165,
		1.99514527, 1.99658588, 1.99745650, 1.99764127,
		1.99766987, 1.99831583, 1.99881172, 1.99905942,
		1.99908346, 1.99914194, 1.99914302, 1.99916710,
		1.99917338, 1.99924371, 1.99932147, 1.99937757,
		1.99937771, 1.99942839, 1.99943952, 1.99946720,
		1.99947523, 1.99951593, 1.99954579, 1.07482430,
	}, 
	{
		-0.60280002, -0.97915591, -0.99052262, -0.98596083,
		-0.98593428, -0.98965169, -0.99509879, -0.99395275,
		-0.99605460, -0.99705283, -0.99809487, -0.99799193,
		-0.99790736, -0.99858868, -0.99886603, -0.99920851,
		-0.99920786, -0.99914576, -0.99933160, -0.99916888,
		-0.99917383, -0.99930696, -0.99936623, -0.99938996,
		-0.99939579, -0.99952919, -0.99946468, -0.99950124,
		-0.99955511, -0.99952343, -0.99955212, -0.07530178,
	}, 
	{
		-0.00402808, -0.44992299, -0.22950452, 0.14755519,
		0.47387646, 0.65508582, 0.51696852, 0.07777206,
		-0.34450683, -0.55589721, -0.66044094, -0.74813566,
		-0.78292862, -0.78051390, -0.79433907, -0.78120732,
		-0.65423124, -0.43625907, -0.24337571, -0.14653167,
		-0.16150927, -0.23912544, -0.31138713, -0.37586636,
		-0.41235607, -0.38028549, -0.29667918, -0.22708025,
		-0.23915660, -0.31299490, -0.41017570, -0.56248824,
		-0.76384204, -0.90501339, -0.90841286, -0.81053517,
		-0.66638115, -0.46915685, -0.26024323, -0.13195458,
		-0.09786566, -0.08837454, -0.06215530, -0.02931482,
		0.00546984, 0.04042834, 0.02256705, -0.08094804,
		-0.20333460, -0.30062708, -0.37211197, -0.37879903,
		-0.26889452, -0.08262298, 0.08792818, 0.21398264,
		0.30989841, 0.35659717, 0.34573192, 0.32947646,
		0.34917377, 0.38842840, 0.39587543, 0.33904151,
		0.22550223, 0.08182242, -0.05389052, -0.13931502,
		-0.14719809, -0.08863873, -0.01215214, 0.04625977,
		0.06479992, 0.04054622, 0.01040606, 0.01324348,
		0.05417999, 0.12252758, 0.19941582, 0.25419977,
		0.27063271, 0.26418990, 0.24957949, 0.21900042,
		0.17928997, 0.15432936, 0.13923826, 0.11195223,
		0.06906101, 0.02767195, -0.00072867, -0.01018554,
		0.00379441, 0.04420645, 0.10806279, 0.18359146,
		0.23837700, 0.25089256, 0.23693099, 0.22308764,
		0.21903520, 0.22430957, 0.24235523, 0.26437635,
		0.26316791, 0.22478641, 0.16095620, 0.09287901,
		0.03154419, -0.01204798, -0.02290871, 0.00036741,
		0.03913518, 0.07145290, 0.08663240, 0.08416427,
		0.06972264, 0.05151382, 0.03415002, 0.01876283,
		0.00462008, -0.00976095, -0.02556056, -0.04017744,
		-0.05252473, -0.06630665, -0.08079801, -0.08790548,
	}, 
};
/* twin A */
ParModel<16,128> twin_A_46722 = {
	0.08142807, 
	{
		0.86994992, 0.11593682, -0.55401334, -0.31544740,
		1.30033914, -0.00835065, -0.50382202, 0.07149074,
		-0.22878511, -0.16073341, -0.02148291, -0.03832777,
		0.06359039, -0.00401595, 0.00509997, -0.00556660,
		0.00346487, -0.03769784, -0.03308185, 0.00744715,
		-0.00073590, 0.00055824, 0.00528397, 0.00317778,
		0.00376320, 0.00155159, -0.00190290, 0.00231887,
		-0.00253570, 0.00023595, 0.00000746, 0.19432713,
	}, 
	{
		0.66626681, -0.02980249, 1.66699574, 0.17246830,
		-1.34580083, -0.02342325, 0.49029806, -0.08266480,
		0.23514400, 0.17372542, 0.02106002, 0.03563695,
		-0.06124120, 0.00429810, -0.00399278, 0.00549236,
		-0.00288132, 0.03807097, 0.03307565, -0.00738434,
		0.00132825, -0.00058411, -0.00530958, -0.00314127,
		-0.00364254, -0.00146388, 0.00206566, -0.00231316,
		0.00251061, -0.00023665, -0.00000746, -0.19408802,
	}, 
	{
		-1.29332255, 0.97791220, 1.49965412, 1.80079097,
		1.81801144, 1.89856104, 1.91023567, 1.94714076,
		1.95020502, 1.96367882, 1.97686479, 1.97764345,
		1.98354920, 1.98601676, 1.98968489, 1.99127308,
		1.99178642, 1.99307404, 1.99325912, 1.99371644,
		1.99472429, 1.99473771, 1.99516778, 1.99522785,
		1.99651374, 1.99660577, 1.99660943, 1.99756002,
		1.99773601, 1.99881244, 1.99989223, 1.98812882,
	}, 
	{
		-0.67028778, -0.85367920, -0.75197957, -0.94470005,
		-0.83100506, -0.96688235, -0.96028614, -0.97957087,
		-0.97405158, -0.98222804, -0.98757693, -0.99231954,
		-0.98538954, -0.99496392, -0.99449588, -0.99771429,
		-0.99732904, -0.99388200, -0.99488046, -0.99743663,
		-0.99652151, -0.99702056, -0.99527552, -0.99838898,
		-0.99764532, -0.99692124, -0.99705781, -0.99775011,
		-0.99842721, -0.99885342, -0.99989239, -0.98814213,
	}, 
	{
		-0.47463183, 0.48630575, 0.19232834, 0.21077759,
		1.14947709, 0.68351130, 1.26250686, 1.08343888,
		0.58731036, 0.38044627, -0.33204627, -0.53649815,
		-0.70601887, -0.76035725, -0.49400889, -0.38173724,
		-0.20644748, -0.17800847, -0.28689368, -0.36873818,
		-0.54017557, -0.65864822, -0.74119939, -0.76657635,
		-0.65902881, -0.48268718, -0.21296337, 0.03788076,
		0.16128274, 0.20807127, 0.17858472, 0.04349256,
		-0.16385916, -0.33439357, -0.41435448, -0.44331312,
		-0.44634393, -0.41779632, -0.36133903, -0.27667669,
		-0.16632512, -0.08348025, -0.08695759, -0.16631909,
		-0.25295221, -0.30421075, -0.34839874, -0.38028920,
		-0.33826053, -0.21148504, -0.07587915, -0.02695152,
		-0.08829131, -0.17801220, -0.22485934, -0.26809525,
		-0.35805913, -0.45229465, -0.47798739, -0.44958800,
		-0.44805229, -0.47923595, -0.47251996, -0.40342280,
		-0.33492366, -0.31995903, -0.33333273, -0.32961826,
		-0.30887277, -0.30452305, -0.34320119, -0.39494430,
		-0.39389623, -0.31978833, -0.23561987, -0.21177534,
		-0.22203923, -0.18065659, -0.07509849, 0.00883085,
		0.00718600, -0.03037212, -0.01730963, 0.05925759,
		0.13005401, 0.14052736, 0.10739066, 0.07841091,
		0.06318595, 0.02790312, -0.04773833, -0.14437846,
		-0.22046943, -0.25255239, -0.26150135, -0.27010253,
		-0.27605257, -0.27150144, -0.26748833, -0.27903775,
		-0.29628806, -0.28985551, -0.25186766, -0.21198666,
		-0.20763848, -0.23793270, -0.25548598, -0.22343406,
		-0.16895572, -0.14569854, -0.15827785, -0.15410072,
		-0.10524284, -0.04859293, -0.02786326, -0.03879518,
		-0.05412920, -0.06363616, -0.06739900, -0.06018251,
		-0.04625055, -0.04425041, -0.06304972, -0.08234068,
		-0.07138058, -0.03056568, 0.00251090, 0.00060570,
	}, 
};
/* twin B */
ParModel<16,128> twin_B_46722 = {
	0.13054328, 
	{
		-0.58480687, 0.35537795, 0.79502005, 0.12252318,
		0.05054238, -0.39298138, -0.01638795, 0.01712935,
		-0.00161108, 0.10914419, 0.00463996, 0.00029243,
		-0.00169509, 0.02201116, 0.00687665, -0.00007673,
		-0.00020149, 0.02987389, -0.00061690, 0.00814746,
		-0.00431750, 0.00397501, 0.00821747, -0.00197945,
		0.00379144, 0.00385628, 0.00223073, 0.00166292,
		0.00125779, 0.00025342, -0.00081081, -0.00011803,
	}, 
	{
		-0.35561553, 0.10663728, -0.95630584, -0.14926639,
		-0.04938280, 0.40169254, 0.01734888, -0.01614295,
		0.00194996, -0.10833312, -0.00459961, -0.00039057,
		0.00192367, -0.02230393, -0.00675743, -0.00008859,
		0.00015741, -0.03017012, 0.00060066, -0.00815946,
		0.00434676, -0.00395643, -0.00808749, 0.00189965,
		-0.00381870, -0.00384689, -0.00223677, -0.00167080,
		-0.00126171, -0.00025487, 0.00081045, 0.00011793,
	}, 
	{
		-0.82079513, 1.72516100, 1.91167608, 1.95062711,
		1.95833100, 1.96564825, 1.98479517, 1.98613107,
		1.98944857, 1.99294353, 1.99335161, 1.99502736,
		1.99503214, 1.99541888, 1.99594468, 1.99657995,
		1.99661149, 1.99670137, 1.99708589, 1.99731746,
		1.99739209, 1.99765661, 1.99765904, 1.99778132,
		1.99786691, 1.99824160, 1.99842090, 1.99842135,
		1.99856599, 1.99896605, 1.99898702, 1.99960360,
	}, 
	{
		-0.47272871, -0.81273275, -0.95102232, -0.96018086,
		-0.97402033, -0.96596803, -0.98600819, -0.99075701,
		-0.99586070, -0.99326139, -0.99658837, -0.99717852,
		-0.99585324, -0.99582582, -0.99658315, -0.99705014,
		-0.99830849, -0.99678113, -0.99824076, -0.99749065,
		-0.99768417, -0.99787375, -0.99772763, -0.99788247,
		-0.99800269, -0.99828932, -0.99845271, -0.99844166,
		-0.99857818, -0.99897173, -0.99898743, -0.99960520,
	}, 
	{
		-0.27114077, -0.46505616, 0.19893101, 1.08509262,
		0.93615911, 0.81450668, 0.51320928, -0.05178542,
		-0.35228906, -0.39507784, -0.19613672, 0.20544407,
		0.57615146, 0.85592842, 1.04995055, 1.13788199,
		1.14641612, 1.09875150, 0.97992332, 0.76918141,
		0.45088555, 0.03617223, -0.36249190, -0.63834826,
		-0.79993511, -0.88846671, -0.95188598, -1.00000191,
		-1.05701535, -1.13040415, -1.17356136, -1.12583726,
		-0.96012573, -0.72433531, -0.46673542, -0.21377723,
		-0.00271014, 0.11651644, 0.13493756, 0.09604190,
		0.04491464, 0.00185256, -0.02974328, -0.05604113,
		-0.08293593, -0.12393422, -0.19069295, -0.31010283,
		-0.48482170, -0.65799354, -0.76664288, -0.77382547,
		-0.68704772, -0.54003868, -0.38145553, -0.27867632,
		-0.28618758, -0.39944543, -0.57413707, -0.72855092,
		-0.79816840, -0.77760895, -0.71339006, -0.66739777,
		-0.65338925, -0.64803537, -0.62921275, -0.56248019,
		-0.41968528, -0.21057656, 0.00767066, 0.16212033,
		0.21749796, 0.20304322, 0.16413918, 0.13128197,
		0.10957673, 0.08084931, 0.03617688, -0.02213245,
		-0.08105475, -0.14044999, -0.20989971, -0.28591535,
		-0.35645909, -0.41225574, -0.44439691, -0.44946416,
		-0.42802365, -0.38205560, -0.31184955, -0.23456613,
		-0.18574472, -0.17767790, -0.19124060, -0.19792017,
		-0.18343733, -0.16106628, -0.15076057, -0.16221974,
		-0.19492914, -0.23835353, -0.27467739, -0.27961714,
		-0.24118012, -0.16469824, -0.07128207, 0.00266090,
		0.02970543, 0.00647625, -0.04422158, -0.09786796,
		-0.14335812, -0.17923294, -0.21135532, -0.24443912,
		-0.27778859, -0.30289371, -0.30747255, -0.28487449,
		-0.24449750, -0.20753759, -0.19190346, -0.19780290,
		-0.20660711, -0.20180664, -0.17767189, -0.13548117,
	}, 
};
/* twin C */
ParModel<16,128> twin_C_46722 = {
	0.13081192, 
	{
		1.20590241, 1.12478604, 0.01912124, 0.25382267,
		-0.14236164, -0.03379052, 0.00242529, 0.00298148,
		0.00693017, 0.01103081, -0.00052947, -0.00965219,
		-0.00134284, -0.00486586, -0.00372683, 0.00025963,
		-0.00179932, -0.00156765, 0.00328193, -0.00126936,
		0.00166098, 0.00190066, -0.00410146, 0.00011987,
		0.00089535, 0.00092077, 0.00007988, 0.00064511,
		0.00085257, -0.00046769, -0.96996884, 0.03203810,
	}, 
	{
		-1.42804041, -0.97307432, -0.01458931, -0.25980000,
		0.14687044, 0.03495132, -0.00215463, -0.00329585,
		-0.00679457, -0.01126450, 0.00039260, 0.00965710,
		0.00138670, 0.00488316, 0.00383172, -0.00017793,
		0.00182609, 0.00161557, -0.00324741, 0.00128080,
		-0.00165038, -0.00189408, 0.00410022, -0.00010980,
		-0.00088836, -0.00091627, -0.00008222, -0.00064682,
		-0.00085220, 0.00046753, -0.67926126, -0.03202784,
	}, 
	{
		1.76689418, 1.92414870, 1.96914772, 1.97511832,
		1.98681859, 1.98769845, 1.98935603, 1.99392063,
		1.99546505, 1.99578341, 1.99633006, 1.99679750,
		1.99696569, 1.99748105, 1.99780039, 1.99786435,
		1.99827082, 1.99829020, 1.99845516, 1.99888721,
		1.99893895, 1.99896330, 1.99906371, 1.99908252,
		1.99910365, 1.99920891, 1.99930367, 1.99934439,
		1.99934650, 1.99963389, -0.36019654, 1.99736734,
	}, 
	{
		-0.83694998, -0.95142612, -0.98073004, -0.97872754,
		-0.98747422, -0.99126468, -0.99556568, -0.99602876,
		-0.99629948, -0.99641493, -0.99800540, -0.99716892,
		-0.99813082, -0.99793140, -0.99793023, -0.99809408,
		-0.99856369, -0.99848439, -0.99860394, -0.99899127,
		-0.99897402, -0.99900893, -0.99906429, -0.99916227,
		-0.99916423, -0.99923401, -0.99930832, -0.99935383,
		-0.99936275, -0.99963550, -0.02749544, -0.99736834,
	}, 
	{
		-1.22413408, -0.78880820, -0.12952006, 0.83655963,
		1.03567405, 0.85846346, 0.34701708, -0.30552621,
		-0.86844330, -1.14897491, -1.11417030, -0.87369051,
		-0.57748022, -0.28854158, -0.02362284, 0.21540099,
		0.43549598, 0.64122888, 0.80826899, 0.89386936,
		0.86509676, 0.71948488, 0.55458524, 0.46728987,
		0.44255227, 0.43496579, 0.39641153, 0.31961449,
		0.18512985, -0.00753219, -0.20348408, -0.33296332,
		-0.35931227, -0.32105181, -0.25757232, -0.18726404,
		-0.14042862, -0.16133368, -0.25463721, -0.37397300,
		-0.47278461, -0.53065078, -0.54529257, -0.52510875,
		-0.47917516, -0.42495282, -0.37863800, -0.37205371,
		-0.41299173, -0.44974623, -0.42433449, -0.30448875,
		-0.10193610, 0.14594688, 0.38752134, 0.55315980,
		0.58689755, 0.49258325, 0.31460273, 0.13546913,
		0.02116902, -0.02086422, -0.03460770, -0.07902855,
		-0.16470299, -0.26497838, -0.35438354, -0.39521815,
		-0.35626332, -0.24448565, -0.11464009, -0.03766445,
		-0.04729968, -0.11326153, -0.18961732, -0.24580497,
		-0.27710972, -0.30251091, -0.33209822, -0.36502946,
		-0.38997668, -0.40865328, -0.43257805, -0.46021176,
		-0.48141047, -0.48867623, -0.47470819, -0.43748230,
		-0.37871289, -0.30126017, -0.20601453, -0.11045819,
		-0.05018280, -0.03728275, -0.05221121, -0.06584295,
		-0.06313297, -0.05647699, -0.06487901, -0.09705905,
		-0.15153221, -0.21683813, -0.27431270, -0.29892637,
		-0.27806324, -0.21656848, -0.13520994, -0.07019752,
		-0.04889950, -0.07476497, -0.12517934, -0.17591188,
		-0.21622581, -0.24508684, -0.26881714, -0.29260240,
		-0.31621053, -0.33156837, -0.32678808, -0.29555741,
		-0.24754761, -0.20415687, -0.18342261, -0.18560888,
		-0.19207472, -0.18623683, -0.16223898, -0.12119058,
	}, 
};
/* blue A */
ParModel<16,128> blue_A_46722 = {
	0.08952776, 
	{
		-0.00064088, -0.11527311, -0.08459448, 0.54324495,
		0.22943506, 0.16067459, -0.03468293, -0.26885985,
		0.01940322, -0.05195301, -0.04680409, -0.02539474,
		0.01415882, -0.01245275, -0.02676917, -0.07775339,
		-0.00201378, 0.00122802, 0.00537202, 0.00580999,
		-0.01333447, 0.00950862, 0.00219430, -0.00005307,
		0.02092125, -0.00066140, -0.00207954, 0.00265685,
		-0.00284764, -0.00421378, 0.00145201, -0.69721772,
	}, 
	{
		0.00041417, -0.14096282, -0.39318086, 2.90790632,
		-0.35833542, -0.08920167, 0.01971473, -0.03917090,
		-0.02353869, 0.04930174, 0.04526089, 0.02337471,
		-0.01579045, 0.01334396, 0.02623872, 0.07948770,
		0.00167578, -0.00136063, -0.00551493, -0.00566476,
		0.01376917, -0.00934159, -0.00238662, 0.00065335,
		-0.02082898, 0.00105766, 0.00222930, -0.00266334,
		0.00289716, 0.00427268, -0.00144993, 0.97657611,
	}, 
	{
		-1.60697431, 1.03689274, 1.23116473, 1.53870386,
		1.81259941, 1.87610477, 1.91142882, 1.91470952,
		1.93078565, 1.96231216, 1.97097546, 1.97223085,
		1.97789636, 1.98475430, 1.98518241, 1.98833937,
		1.98947394, 1.98966271, 1.99082060, 1.99345849,
		1.99363698, 1.99384536, 1.99396353, 1.99451065,
		1.99517817, 1.99588759, 1.99627219, 1.99666536,
		1.99682882, 1.99861234, 1.99907540, 1.61353041,
	}, 
	{
		-0.98286690, -0.94313108, -0.55905705, -0.76096270,
		-0.96553661, -0.98302405, -0.97804552, -0.95105487,
		-0.97845555, -0.99051762, -0.98973158, -0.99432509,
		-0.99194423, -0.99621577, -0.99436103, -0.98904428,
		-0.99737964, -0.99632997, -0.99410210, -0.99759738,
		-0.99634986, -0.99408782, -0.99908266, -0.99610020,
		-0.99520012, -0.99797988, -0.99666681, -0.99738969,
		-0.99797974, -0.99872662, -0.99907725, -0.63410303,
	}, 
	{
		0.75164407, -1.37925311, -2.30900703, -2.23229786,
		-1.25123512, 0.25237347, 1.67613013, 2.53520576,
		2.68000998, 2.30975538, 1.67574783, 1.08132686,
		0.55536837, -0.07473647, -0.81028512, -1.44301475,
		-1.79371279, -1.77475912, -1.44225131, -0.99932122,
		-0.73251487, -0.76027564, -0.97259617, -1.17361303,
		-1.21694552, -1.12725905, -0.99340929, -0.91236574,
		-0.92525741, -0.93724698, -0.86332154, -0.71786935,
		-0.57557393, -0.48027276, -0.37377773, -0.20181942,
		0.02933073, 0.28037635, 0.44583375, 0.46785886,
		0.35326366, 0.18197850, 0.02925159, -0.09658320,
		-0.19295397, -0.28003105, -0.37437393, -0.43692295,
		-0.40760670, -0.27903208, -0.14409258, -0.10988040,
		-0.18713776, -0.31926432, -0.44449346, -0.55371228,
		-0.65247488, -0.76073435, -0.90190157, -1.01728425,
		-1.03801884, -0.94498678, -0.75783680, -0.52650034,
		-0.31525504, -0.17356862, -0.07976557, 0.00975822,
		0.09645820, 0.16772655, 0.19368662, 0.16003328,
		0.08800664, 0.02027616, -0.00483154, -0.01008342,
		-0.02903035, -0.06737169, -0.11115260, -0.13810908,
		-0.15125151, -0.16253855, -0.18292212, -0.21825207,
		-0.24778844, -0.25695685, -0.23687044, -0.20252521,
		-0.19041455, -0.20584466, -0.24750051, -0.31042790,
		-0.37121708, -0.40576944, -0.41010153, -0.39997890,
		-0.36756207, -0.29819541, -0.19594598, -0.07085474,
		0.04524015, 0.12388432, 0.15716434, 0.15814953,
		0.15448627, 0.15056056, 0.14898400, 0.14660788,
		0.12648069, 0.09107574, 0.04881875, 0.01308097,
		-0.00931735, -0.02244438, -0.02701404, -0.03024008,
		-0.02897943, -0.02678554, -0.03890331, -0.06800742,
		-0.11439920, -0.16249304, -0.18980545, -0.18244432,
		-0.13554470, -0.07253938, -0.01735219, 0.01899457,
	}, 
};
/* blue B */
ParModel<16,128> blue_B_46722 = {
	0.08345286, 
	{
		0.00118301, 0.96930195, 1.31784232, -0.84102859,
		0.23153677, 0.20034883, 0.82080998, -3.22485855,
		-0.03700623, 0.36876838, -0.04730678, -0.07479076,
		-0.00453326, -0.01710625, -0.01328559, -0.00866941,
		0.00486463, -0.00123052, 0.00108118, 0.00646739,
		-0.00667341, 0.00583094, -0.00358165, -0.00115943,
		0.00113166, 0.00125451, 0.00230535, -0.00124662,
		-0.00062445, 0.00604219, -0.00506721, 0.00316265,
	}, 
	{
		0.00020617, -0.66496280, 0.61759197, 0.00931422,
		0.56904259, -0.34797681, -0.54530662, 3.27798486,
		0.03310330, -0.36451937, 0.04160636, 0.08282406,
		0.00847893, 0.01706696, 0.01313546, 0.00865813,
		-0.00596477, 0.00042527, -0.00132174, -0.00646491,
		0.00674420, -0.00570702, 0.00392373, 0.00144164,
		-0.00103347, -0.00121606, -0.00230306, 0.00126647,
		0.00066965, -0.00603552, 0.00511724, -0.00315885,
	}, 
	{
		-1.63712403, 1.02152174, 1.61695260, 1.72965317,
		1.85180600, 1.89694000, 1.91118023, 1.94939630,
		1.96089849, 1.96114524, 1.96942557, 1.96985299,
		1.98294235, 1.98542765, 1.98603844, 1.98893022,
		1.99155048, 1.99292463, 1.99373861, 1.99416252,
		1.99451374, 1.99613203, 1.99616234, 1.99619534,
		1.99633698, 1.99670041, 1.99764314, 1.99769915,
		1.99780066, 1.99823349, 1.99874487, 1.99881038,
	}, 
	{
		-0.98301652, -0.85419879, -0.82215309, -0.86635725,
		-0.95916245, -0.96033450, -0.95484389, -0.95056596,
		-0.98945930, -0.97393833, -0.99159002, -0.98760552,
		-0.99424516, -0.99445419, -0.99227051, -0.99654248,
		-0.99281593, -0.99607018, -0.99880336, -0.99826731,
		-0.99718516, -0.99724127, -0.99775390, -0.99826684,
		-0.99674520, -0.99726593, -0.99788213, -0.99841031,
		-0.99785150, -0.99824215, -0.99886089, -0.99881207,
	}, 
	{
		0.64633741, 0.09380756, 0.45146227, 0.75640901,
		0.67852342, 0.43561220, 0.39422421, 0.72523035,
		1.30274186, 1.79522663, 1.93572855, 1.86627952,
		1.80093225, 1.83135279, 1.91254329, 1.95048783,
		1.77479398, 1.37073541, 0.94709114, 0.66542605,
		0.49217060, 0.26557329, -0.13144306, -0.64360266,
		-1.09605268, -1.29644001, -1.16787432, -0.83365519,
		-0.50972622, -0.33106432, -0.27474986, -0.27562322,
		-0.28183663, -0.27639593, -0.30095395, -0.41226333,
		-0.66436090, -1.00729183, -1.36471934, -1.68757892,
		-1.94821231, -2.15338133, -2.30437920, -2.37736265,
		-2.31888590, -2.08464123, -1.72945985, -1.32345650,
		-0.90857692, -0.53676403, -0.25398563, -0.11486734,
		-0.10947670, -0.20895985, -0.41860989, -0.73107245,
		-1.11235164, -1.50521696, -1.87510209, -2.17817818,
		-2.37064539, -2.46429997, -2.45711634, -2.34367777,
		-2.16141934, -1.95549368, -1.75511882, -1.55748072,
		-1.36795599, -1.18824652, -1.01715633, -0.88321376,
		-0.79816106, -0.75437571, -0.73243032, -0.72439385,
		-0.73741782, -0.75616134, -0.77186844, -0.78617758,
		-0.79827851, -0.80850439, -0.79689746, -0.75461721,
		-0.67884791, -0.57737271, -0.47200423, -0.37976055,
		-0.32756708, -0.31828546, -0.35248133, -0.44878582,
		-0.59205558, -0.75040467, -0.89790153, -1.01792582,
		-1.09256180, -1.10339140, -1.05857782, -0.96694435,
		-0.84417816, -0.71235698, -0.57897762, -0.44981586,
		-0.32338507, -0.21025218, -0.11729008, -0.04368018,
		-0.00800462, -0.01601748, -0.06571686, -0.14774335,
		-0.24202104, -0.33470708, -0.41030338, -0.46668871,
		-0.50313985, -0.52290882, -0.53920451, -0.54871548,
		-0.54763322, -0.52704578, -0.47577081, -0.39385932,
		-0.28358009, -0.16783058, -0.06844908, 0.00457084,
	}, 
};
/* tweedie A */
ParModel<16,128> tweedie_A_46722 = {
	0.09367442, 
	{
		1.24680472, -0.23067831, 0.11829568, -0.01051626,
		0.01310018, -0.01651824, 0.00065646, -0.00155159,
		-0.00418783, 0.00051482, 0.00031155, 0.00045324,
		-0.00097135, -0.00089568, -0.00090868, -0.00074809,
		-0.00002138, -0.00077023, -0.00060345, -0.00110265,
		-0.00057851, -0.00044565, -0.00034647, 0.00053955,
		-0.00030885, -0.00056234, 0.00004398, -0.00025463,
		-0.00015599, -0.00007931, -0.00019699, -0.29751135,
	}, 
	{
		-0.54745830, 0.23288336, -0.11407735, 0.01009832,
		-0.01332497, 0.01757204, -0.00050009, 0.00153728,
		0.00421300, -0.00050392, -0.00032759, -0.00046123,
		0.00097563, 0.00090144, 0.00091161, 0.00074990,
		0.00001626, 0.00077600, 0.00060459, 0.00110216,
		0.00058322, 0.00044644, 0.00034289, -0.00054760,
		0.00030952, 0.00056366, -0.00004285, 0.00025435,
		0.00015670, 0.00007938, 0.00019699, 0.29735841,
	}, 
	{
		1.68231663, 1.95241632, 1.97259454, 1.99199345,
		1.99233200, 1.99240437, 1.99717337, 1.99809111,
		1.99859676, 1.99863172, 1.99887344, 1.99902746,
		1.99929177, 1.99929927, 1.99930608, 1.99933038,
		1.99934365, 1.99934720, 1.99936346, 1.99938582,
		1.99939979, 1.99940299, 1.99944355, 1.99945472,
		1.99945974, 1.99950696, 1.99953370, 1.99956726,
		1.99969244, 1.99981767, 1.99985421, 1.20282576,
	}, 
	{
		-0.75371326, -0.96746493, -0.97448572, -0.99494123,
		-0.99357999, -0.99309205, -0.99802384, -0.99868298,
		-0.99868021, -0.99900616, -0.99908274, -0.99929184,
		-0.99932194, -0.99933663, -0.99932985, -0.99934844,
		-0.99950907, -0.99939247, -0.99937659, -0.99938821,
		-0.99945372, -0.99941197, -0.99957672, -0.99953615,
		-0.99946536, -0.99957182, -0.99953678, -0.99956848,
		-0.99979861, -0.99981790, -0.99985429, -0.20291640,
	}, 
	{
		-0.50814389, -0.44380496, -0.01609459, 0.34534892,
		0.56261551, 0.54736462, 0.21202324, -0.32921217,
		-0.81362861, -1.04252868, -1.01745390, -0.72809357,
		-0.30527351, 0.02203877, 0.13912461, 0.16213447,
		0.13271073, 0.02310389, -0.12252249, -0.21579550,
		-0.24060782, -0.26708313, -0.33615420, -0.39613669,
		-0.39850687, -0.35874773, -0.26855888, -0.13080866,
		-0.02298318, -0.01603222, -0.10633893, -0.26135879,
		-0.45188235, -0.63827829, -0.75079728, -0.75237640,
		-0.67911087, -0.56849040, -0.42935458, -0.28930057,
		-0.16569896, -0.06219326, -0.01875618, -0.05617911,
		-0.14358446, -0.22739763, -0.27039398, -0.27020396,
		-0.24953315, -0.21474557, -0.16403706, -0.12606538,
		-0.11548510, -0.12718187, -0.12348283, -0.08879935,
		-0.04007267, 0.00217491, 0.02940177, 0.03366629,
		0.01280496, -0.02018499, -0.05869179, -0.10803540,
		-0.16145925, -0.18983785, -0.18684007, -0.16925117,
		-0.13764615, -0.08364165, -0.02431630, 0.01095907,
		0.01016465, -0.01674825, -0.05719108, -0.09559514,
		-0.10861043, -0.08036142, -0.01988712, 0.05846273,
		0.14359589, 0.20968059, 0.22932567, 0.20454404,
		0.16051260, 0.11765782, 0.07926418, 0.04441983,
		0.02102152, 0.00823712, -0.00188274, -0.00990119,
		-0.01066267, -0.00394693, 0.00633703, 0.01770568,
		0.02201651, 0.00999100, -0.01061414, -0.01938946,
		-0.00668288, 0.01620591, 0.03857274, 0.05351969,
		0.05389740, 0.04017189, 0.02011288, 0.00419701,
		-0.00168938, 0.00319961, 0.01479959, 0.02569612,
		0.02227850, 0.00187392, -0.02246339, -0.03946235,
		-0.05129405, -0.05820027, -0.05570182, -0.04637539,
		-0.03768161, -0.03345049, -0.03030978, -0.02426676,
		-0.01575810, -0.00740044, -0.00450680, -0.01604295,
	}, 
};
/* tweedie B */
ParModel<16,128> tweedie_B_46722 = {
	0.06886520, 
	{
		0.78071236, 0.10977394, -2.62974849, -2.06284876,
		5.32658731, -0.72912316, -0.00887685, -0.02580427,
		-0.00990508, -0.00957447, 0.04603544, 0.00017633,
		0.00778067, 0.00162571, 0.00097317, 0.02443903,
		-0.00090406, -0.00258076, -0.01527316, 0.00106980,
		-0.00037127, -0.00071846, -0.00000245, -0.00226258,
		-0.00086286, -0.00281024, -0.00217928, -0.00117751,
		0.00037577, -0.00178549, 0.00068012, -0.96534753,
	}, 
	{
		0.65581206, 0.13332362, 4.36593229, 0.06786140,
		-5.10942906, 0.62458965, 0.00444796, 0.02227603,
		0.00846570, 0.00822016, -0.04562827, -0.00033110,
		-0.00750902, -0.00121510, -0.00086574, -0.02513801,
		0.00107386, 0.00231109, 0.01539027, -0.00144414,
		0.00032410, 0.00079728, -0.00006046, 0.00237888,
		0.00084323, 0.00280923, 0.00225034, 0.00119181,
		-0.00038473, 0.00179762, -0.00067937, 0.96523278,
	}, 
	{
		-1.45239458, 1.07829441, 1.64606171, 1.83570396,
		1.87192506, 1.91464732, 1.96464751, 1.96818712,
		1.97913989, 1.98029515, 1.98507923, 1.98584696,
		1.98771109, 1.98889209, 1.98895434, 1.99264934,
		1.99265440, 1.99441872, 1.99446143, 1.99564241,
		1.99565830, 1.99621950, 1.99654576, 1.99709055,
		1.99736173, 1.99770031, 1.99795938, 1.99809629,
		1.99810837, 1.99814095, 1.99869148, 1.97983294,
	}, 
	{
		-0.62968050, -0.82883717, -0.82993924, -0.94255149,
		-0.94609173, -0.95688171, -0.99347402, -0.98704126,
		-0.99443209, -0.99199559, -0.98696499, -0.99488275,
		-0.99364683, -0.99340412, -0.99648600, -0.99377285,
		-0.99670810, -0.99755957, -0.99452037, -0.99696406,
		-0.99592774, -0.99872715, -0.99846437, -0.99781873,
		-0.99755241, -0.99772837, -0.99885671, -0.99819391,
		-0.99851604, -0.99876608, -0.99869356, -0.97983534,
	}, 
	{
		0.47459153, 1.69799708, 1.45487813, 2.38480087,
		3.39119425, 3.78025163, 4.51898316, 4.15322143,
		4.25243191, 3.82352013, 3.47105194, 2.84136407,
		1.95220302, 0.93178050, -0.31718831, -1.21476102,
		-1.83749998, -2.05401636, -1.98347297, -1.59694448,
		-0.96917236, -0.30657826, 0.28524250, 0.71111334,
		0.97933857, 1.03114860, 0.92749990, 0.74929167,
		0.51666057, 0.25312285, 0.01286461, -0.13680294,
		-0.16878362, -0.05780473, 0.22724795, 0.66665399,
		1.15475420, 1.58056233, 1.87769204, 1.98370417,
		1.87750796, 1.57665014, 1.08176835, 0.42453884,
		-0.30527406, -0.99224322, -1.54018435, -1.89627679,
		-2.04857746, -1.98881275, -1.72176329, -1.30136842,
		-0.78164004, -0.20616749, 0.40917920, 1.02549051,
		1.57471507, 1.99318292, 2.24158749, 2.29675465,
		2.15791025, 1.85507615, 1.42490229, 0.90169218,
		0.33759608, -0.19108675, -0.63323855, -0.96739143,
		-1.16605350, -1.20554313, -1.10146621, -0.89500483,
		-0.62137221, -0.30235188, 0.03776016, 0.37614950,
		0.69995116, 0.99439887, 1.22817890, 1.37487657,
		1.42221124, 1.35350770, 1.15931566, 0.86606694,
		0.52709068, 0.19179289, -0.10955310, -0.35535242,
		-0.52161826, -0.60069684, -0.59999374, -0.52697287,
		-0.38961582, -0.20535266, 0.00176199, 0.20870353,
		0.38838181, 0.51586924, 0.58784714, 0.61896215,
		0.61857366, 0.58015992, 0.50199807, 0.38917203,
		0.24812768, 0.09311711, -0.05543553, -0.17663723,
		-0.25722316, -0.29254265, -0.28628392, -0.24871444,
		-0.19893730, -0.14696684, -0.08804954, -0.01928340,
		0.04952712, 0.11188890, 0.16785041, 0.21243024,
		0.23776241, 0.24137925, 0.22939434, 0.20943604,
		0.18508194, 0.15762196, 0.12513556, 0.08124487,
	}, 
};
/* mini wookie A */
ParModel<16,128> mini_wookie_A_46722 = {
	0.04388360, 
	{
		-2.72197846, -3.87510896, 4.45810694, -0.00860687,
		-0.11515978, -0.04194108, 0.29009473, -0.08897838,
		-0.10064439, -0.03010057, -0.02878825, 0.04186125,
		0.01468695, -0.00605116, 0.00090023, 0.00464860,
		0.00313531, -0.00413903, 0.00288873, 0.00051723,
		0.00168892, 0.00843707, 0.00010699, 0.00059750,
		0.00423501, 0.00161633, 0.00215061, 0.00093460,
		-0.00274931, 0.00111853, 0.03501672, -0.01404229,
	}, 
	{
		0.14011221, -1.20667755, -4.84491725, 0.00671891,
		0.11521109, 0.03621528, -0.26935233, 0.09043322,
		0.10630374, 0.02882811, 0.02796848, -0.04344168,
		-0.01466071, 0.00584208, -0.00079633, -0.00449147,
		-0.00340421, 0.00419654, -0.00288584, -0.00046199,
		-0.00167735, -0.00838552, -0.00005833, -0.00053910,
		-0.00417673, -0.00158531, -0.00209299, -0.00090893,
		0.00274490, -0.00112144, 0.05577522, 0.01404107,
	}, 
	{
		0.59590254, 1.82998755, 1.90027300, 1.97192696,
		1.97775716, 1.97889379, 1.98304970, 1.98737781,
		1.98960436, 1.99105425, 1.99141962, 1.99180010,
		1.99561058, 1.99578938, 1.99599956, 1.99679252,
		1.99693601, 1.99728396, 1.99784284, 1.99798707,
		1.99803645, 1.99805636, 1.99824345, 1.99831598,
		1.99833363, 1.99836575, 1.99842145, 1.99863038,
		1.99897997, 1.99920950, 0.21890688, 1.99889493,
	}, 
	{
		-0.46362927, -0.90873572, -0.94342532, -0.99527785,
		-0.98792474, -0.99239647, -0.98772973, -0.99077290,
		-0.99367209, -0.99375245, -0.99844259, -0.99408561,
		-0.99701274, -0.99602546, -0.99675075, -0.99773683,
		-0.99855915, -0.99787589, -0.99896266, -0.99812133,
		-0.99840745, -0.99812034, -0.99842292, -0.99858992,
		-0.99837787, -0.99882575, -0.99851625, -0.99865922,
		-0.99898220, -0.99921906, 0.77740904, -0.99889503,
	}, 
	{
		2.40164424, 6.88126383, 9.83484319, 12.80994810,
		15.51667250, 16.66305670, 15.83021020, 13.56459250,
		10.56340040, 7.19136443, 3.84856826, 0.80086961,
		-1.86292203, -3.97018810, -5.37342712, -6.13562055,
		-6.35201394, -6.09440981, -5.44781171, -4.46645153,
		-3.20295618, -1.82700788, -0.51336032, 0.62548904,
		1.50457895, 2.04921331, 2.24797782, 2.11661845,
		1.69716564, 1.09279508, 0.37488832, -0.44196067,
		-1.26800238, -1.96662053, -2.50255688, -2.83483545,
		-2.90226926, -2.69243212, -2.24832351, -1.63424575,
		-0.91423882, -0.17576417, 0.50110083, 1.08442780,
		1.53654888, 1.82849535, 1.95157404, 1.91445181,
		1.74802274, 1.47259700, 1.10815125, 0.68623876,
		0.23357399, -0.23314962, -0.69689822, -1.11767934,
		-1.44321057, -1.64613146, -1.71621711, -1.66568721,
		-1.51368733, -1.26477274, -0.94215310, -0.58474284,
		-0.20660883, 0.17746549, 0.53026466, 0.83524494,
		1.08865882, 1.26885467, 1.35714964, 1.36140833,
		1.29610745, 1.15190105, 0.93492447, 0.67515737,
		0.38138259, 0.07987837, -0.19460022, -0.43291236,
		-0.62941772, -0.76535062, -0.82598341, -0.83013302,
		-0.79647063, -0.72735445, -0.65552076, -0.60526479,
		-0.55526641, -0.49739647, -0.43704626, -0.37391843,
		-0.30812229, -0.24811927, -0.21047986, -0.19515147,
		-0.20092517, -0.22344197, -0.24584082, -0.26212566,
		-0.26851484, -0.26003352, -0.24550629, -0.23237196,
		-0.21871884, -0.20530866, -0.19649156, -0.19468072,
		-0.20093770, -0.21004019, -0.22033891, -0.23118000,
		-0.24290564, -0.25731478, -0.26828757, -0.27724708,
		-0.28502466, -0.29000041, -0.29074182, -0.28634607,
		-0.27178030, -0.24305811, -0.20927736, -0.17312646,
		-0.13110285, -0.08882776, -0.05605578, -0.02924089,
	}, 
};
/* mini wookie B */
ParModel<16,128> mini_wookie_B_46722 = {
	0.07322146, 
	{
		0.17510190, 1.18232778, 0.60608382, -0.07600123,
		-0.00881267, 0.09375062, -0.04370336, 0.07262572,
		0.04918594, 0.04372244, 0.02034113, 0.00097095,
		0.01206110, -0.00817134, -0.00073641, 0.00599710,
		-0.00706027, 0.00282794, 0.00304317, -0.00033347,
		0.00193112, 0.00081336, 0.00014027, -0.00127293,
		0.00451518, 0.00092025, -0.00467850, -0.00073422,
		0.00133258, 0.00070654, 0.00037870, -0.74745364,
	}, 
	{
		-0.31693037, -1.13439039, -0.75119894, 0.07252671,
		-0.00316474, -0.09617138, 0.04234719, -0.06976817,
		-0.05030201, -0.04385940, -0.02035558, -0.00065025,
		-0.01192952, 0.00869245, 0.00032189, -0.00575038,
		0.00721175, -0.00280367, -0.00299209, 0.00033855,
		-0.00187397, -0.00071296, -0.00009404, 0.00132096,
		-0.00446118, -0.00088564, 0.00467971, 0.00074993,
		-0.00132770, -0.00070394, -0.00037866, 1.69824256,
	}, 
	{
		-0.23241814, 1.89468875, 1.95080284, 1.96026513,
		1.97594196, 1.98958023, 1.99058614, 1.99073231,
		1.99145689, 1.99363430, 1.99417962, 1.99564423,
		1.99626652, 1.99639036, 1.99639445, 1.99650529,
		1.99681146, 1.99757297, 1.99786537, 1.99814733,
		1.99831104, 1.99835584, 1.99859256, 1.99859386,
		1.99860816, 1.99862211, 1.99876730, 1.99887545,
		1.99918948, 1.99928954, 1.99977242, 1.38958760,
	}, 
	{
		-0.61150022, -0.95738453, -0.96549916, -0.98372207,
		-0.98708314, -0.99405830, -0.99757617, -0.99452795,
		-0.99434653, -0.99598966, -0.99559837, -0.99639025,
		-0.99652865, -0.99650254, -0.99800855, -0.99744021,
		-0.99740664, -0.99869151, -0.99824561, -0.99842910,
		-0.99877528, -0.99854084, -0.99865337, -0.99863785,
		-0.99875094, -0.99864898, -0.99885854, -0.99889175,
		-0.99919582, -0.99929201, -0.99977249, -0.45088570,
	}, 
	{
		-1.14364509, -1.23968398, -1.33142434, -0.98601641,
		-0.01411940, 0.58756341, 0.59349888, 0.61629585,
		0.67653911, 0.49160054, 0.33188803, 0.45714489,
		0.65932972, 0.84266934, 1.06979979, 1.25479391,
		1.27799385, 1.14162403, 0.89657851, 0.62050117,
		0.39469013, 0.21361108, 0.05618288, -0.07356374,
		-0.17461309, -0.26152082, -0.32563564, -0.36956006,
		-0.39710811, -0.37222126, -0.30880463, -0.28495249,
		-0.30054355, -0.29920594, -0.31159238, -0.34249756,
		-0.35363210, -0.33285714, -0.30242572, -0.28740080,
		-0.29859482, -0.36168308, -0.49182001, -0.65810183,
		-0.84243870, -1.02914262, -1.19612660, -1.31937322,
		-1.36841365, -1.33819606, -1.23680643, -1.07073317,
		-0.85791750, -0.62927903, -0.41473416, -0.21727238,
		-0.02084063, 0.17455067, 0.36192325, 0.52250216,
		0.64092210, 0.72572366, 0.77450614, 0.77485747,
		0.74265034, 0.69416493, 0.62217148, 0.53709138,
		0.45755352, 0.37857715, 0.29181748, 0.20900720,
		0.14233843, 0.07473524, 0.00016922, -0.06676087,
		-0.13455246, -0.19478929, -0.22993281, -0.24635179,
		-0.25136852, -0.23604857, -0.19204808, -0.14106485,
		-0.10132847, -0.07181059, -0.07944242, -0.14091833,
		-0.22618683, -0.31791516, -0.41242650, -0.50101377,
		-0.57644919, -0.64122196, -0.70746273, -0.77226039,
		-0.83307340, -0.88559523, -0.91419880, -0.91506081,
		-0.88725214, -0.82907497, -0.75282064, -0.66938242,
		-0.58012896, -0.48880968, -0.40239374, -0.32550677,
		-0.26101023, -0.20508716, -0.15713311, -0.11722078,
		-0.08614469, -0.06592269, -0.05045485, -0.04101181,
		-0.03811923, -0.03971124, -0.04377852, -0.04871901,
		-0.04868852, -0.03879180, -0.02714047, -0.01538594,
		0.00102962, 0.01752131, 0.02531226, 0.02882800,
	}, 
};
/* rosie A */
ParModel<16,128> rosie_A_46722 = {
	0.12076034, 
	{
		2.02279630, -0.33140797, -0.11019237, 0.23086268,
		0.01081880, -0.00371573, -0.04126374, 0.02103617,
		-0.09062880, -0.00764670, 0.00370704, -0.00463752,
		0.00317324, -0.06400532, -0.00218657, -0.00626170,
		-0.03234947, -0.02704109, -0.00194082, 0.01055127,
		0.00302538, -0.01795864, 0.00987231, 0.01037021,
		-0.00429663, -0.00308178, -0.00331655, -0.00325436,
		-0.00512114, -0.00147162, -0.27536263, -0.64957528,
	}, 
	{
		-1.07741027, 0.27503409, 0.13509038, -0.20451591,
		-0.01395683, 0.00419758, 0.04225136, -0.02166284,
		0.08980973, 0.00699305, -0.00396698, 0.00459604,
		-0.00334645, 0.06363015, 0.00211926, 0.00618864,
		0.03232584, 0.02669006, 0.00173036, -0.01062638,
		-0.00305137, 0.01790167, -0.00994183, -0.01039005,
		0.00428123, 0.00306366, 0.00331697, 0.00324888,
		0.00510534, 0.00148517, -0.29822140, 0.64839601,
	}, 
	{
		1.70630960, 1.94707960, 1.96688503, 1.97559640,
		1.98358676, 1.98869570, 1.99045708, 1.99376010,
		1.99481505, 1.99536576, 1.99578494, 1.99638902,
		1.99683118, 1.99708855, 1.99732450, 1.99741743,
		1.99747594, 1.99761468, 1.99812115, 1.99842373,
		1.99849080, 1.99850372, 1.99859103, 1.99862096,
		1.99885576, 1.99888373, 1.99910891, 1.99914697,
		1.99922016, 1.99928200, -0.45443803, 1.86435874,
	}, 
	{
		-0.77493985, -0.96468822, -0.97762447, -0.97797814,
		-0.98898080, -0.99231785, -0.99238997, -0.99462436,
		-0.99505697, -0.99589672, -0.99686087, -0.99805133,
		-0.99727882, -0.99719013, -0.99796507, -0.99775037,
		-0.99763442, -0.99767958, -0.99826345, -0.99851632,
		-0.99871453, -0.99853982, -0.99862252, -0.99867792,
		-0.99886421, -0.99890279, -0.99910943, -0.99915923,
		-0.99922283, -0.99928507, -0.04872993, -0.86443993,
	}, 
	{
		-0.43000433, -0.47032984, -0.31644349, 0.31935715,
		0.59720481, 0.58358405, 0.23605889, -0.21900642,
		-0.59153306, -0.78357715, -0.79604235, -0.71870759,
		-0.62145741, -0.51457611, -0.37797715, -0.16049601,
		0.09826112, 0.30614410, 0.41281446, 0.38139151,
		0.24389435, 0.03355620, -0.20026593, -0.41327024,
		-0.66800960, -0.97602213, -1.26693293, -1.45125785,
		-1.46195445, -1.30392366, -0.98320183, -0.56469258,
		-0.16905787, 0.11155564, 0.24177043, 0.24047653,
		0.15128687, 0.05771540, -0.01409922, -0.11104824,
		-0.21971973, -0.30645027, -0.35585257, -0.33135606,
		-0.22985114, -0.06212508, 0.15053276, 0.37809482,
		0.58907387, 0.74434427, 0.82548508, 0.77627524,
		0.58188878, 0.33170119, 0.08258458, -0.10468486,
		-0.14101330, -0.01247948, 0.17150856, 0.31883428,
		0.40163852, 0.42313576, 0.43807677, 0.47861202,
		0.53529382, 0.57620861, 0.56624272, 0.51271483,
		0.43204801, 0.33216313, 0.23762742, 0.15980986,
		0.08716011, 0.03677678, 0.04647140, 0.10609405,
		0.19798696, 0.30146241, 0.38120077, 0.43525513,
		0.47365787, 0.49381186, 0.48162444, 0.43629680,
		0.36857820, 0.29173817, 0.25260613, 0.28335185,
		0.37414412, 0.48993821, 0.57923608, 0.59915353,
		0.54940527, 0.46881175, 0.39058487, 0.34819555,
		0.36431247, 0.41800445, 0.46654434, 0.49039394,
		0.49723798, 0.49627523, 0.49218607, 0.48576049,
		0.46565666, 0.43865550, 0.43185212, 0.46059930,
		0.51121973, 0.55818530, 0.57843269, 0.54957292,
		0.46809451, 0.36023538, 0.26510622, 0.20907842,
		0.19297306, 0.20138962, 0.22234807, 0.24921959,
		0.27893770, 0.30285670, 0.31015766, 0.29374912,
		0.23906605, 0.14336029, 0.03362199, -0.06395018,
	}, 
};
/* rosie B */
ParModel<16,128> rosie_B_46722 = {
	0.11610618, 
	{
		0.82791163, 0.17373555, 0.06908801, 0.00519779,
		-0.00379965, -0.16283277, -0.01721824, -0.00714683,
		-0.00139356, -0.00081819, -0.00422308, 0.00252630,
		0.00594783, 0.00032801, -0.00344692, -0.00119257,
		0.00649945, 0.00488370, -0.00696124, 0.00060531,
		0.00069493, 0.00151436, -0.00074625, 0.00022582,
		-0.00112224, -0.00161557, -0.00091109, -0.00104488,
		-0.00105567, -0.00005860, -0.34951796, 0.33270796,
	}, 
	{
		-0.75503429, -0.19456290, -0.06671774, -0.00552091,
		0.00362398, 0.16239281, 0.01743041, 0.00739113,
		0.00136433, 0.00080247, 0.00425372, -0.00252764,
		-0.00585640, -0.00030803, 0.00345325, 0.00125542,
		-0.00644964, -0.00488408, 0.00695743, -0.00061831,
		-0.00070551, -0.00151287, 0.00074336, -0.00023060,
		0.00112113, 0.00161791, 0.00090527, 0.00104356,
		0.00105727, 0.00006030, -0.30151381, -0.33266295,
	}, 
	{
		1.84041604, 1.95361178, 1.97799666, 1.98677239,
		1.98892576, 1.99108831, 1.99394296, 1.99589966,
		1.99622737, 1.99696407, 1.99710472, 1.99760258,
		1.99760785, 1.99771746, 1.99783115, 1.99802235,
		1.99807135, 1.99834710, 1.99874067, 1.99877287,
		1.99885202, 1.99887610, 1.99912718, 1.99914330,
		1.99916434, 1.99918204, 1.99919782, 1.99921468,
		1.99931527, 1.99940680, -0.89527488, 1.86323766,
	}, 
	{
		-0.86059774, -0.96785994, -0.98377716, -0.99047109,
		-0.99092089, -0.99118403, -0.99457217, -0.99613432,
		-0.99723936, -0.99862131, -0.99755695, -0.99822768,
		-0.99776321, -0.99803929, -0.99804000, -0.99815571,
		-0.99815615, -0.99844648, -0.99874223, -0.99881142,
		-0.99890168, -0.99894158, -0.99914794, -0.99917309,
		-0.99917159, -0.99919581, -0.99920952, -0.99921522,
		-0.99931773, -0.99941040, -0.20036572, -0.86328219,
	}, 
	{
		-0.65726742, -0.38073944, 0.32141616, 1.08148235,
		1.29530108, 1.21364455, 0.66227932, 0.03285180,
		-0.53396695, -0.87458989, -0.99983974, -0.98035975,
		-0.89126546, -0.74335097, -0.52505653, -0.19358802,
		0.20092164, 0.55623470, 0.81229651, 0.92380415,
		0.91580506, 0.81626810, 0.67097312, 0.52225826,
		0.30703380, 0.01442557, -0.28358555, -0.49522634,
		-0.55072823, -0.45204691, -0.20223737, 0.13667053,
		0.44667656, 0.63801630, 0.67737990, 0.58540232,
		0.40713110, 0.22723149, 0.07274590, -0.10252094,
		-0.28462938, -0.43952014, -0.55151076, -0.58381135,
		-0.53315085, -0.41020116, -0.23617657, -0.04106850,
		0.14363077, 0.27874504, 0.34575186, 0.28827244,
		0.09126242, -0.15618462, -0.39754275, -0.57244487,
		-0.59226543, -0.44360482, -0.23643825, -0.06348564,
		0.04676479, 0.09688418, 0.14097734, 0.21055787,
		0.29556163, 0.36348966, 0.37868362, 0.34796685,
		0.28732373, 0.20429903, 0.12315099, 0.05500984,
		-0.01184148, -0.06039872, -0.05287315, 0.00063207,
		0.08257237, 0.17243572, 0.23513574, 0.26901082,
		0.28442449, 0.27915005, 0.23949750, 0.16509571,
		0.06713938, -0.04064623, -0.11097284, -0.11121578,
		-0.05076206, 0.03577070, 0.09728860, 0.09128321,
		0.01781192, -0.08399939, -0.18067400, -0.23851958,
		-0.23469123, -0.18999050, -0.14706179, -0.12540727,
		-0.11735191, -0.11375074, -0.11001910, -0.10550180,
		-0.11171135, -0.12206966, -0.10971258, -0.05954213,
		0.01449025, 0.08656761, 0.13332768, 0.13207709,
		0.07899900, 0.00002931, -0.06601582, -0.09304831,
		-0.08051563, -0.04406908, 0.00408106, 0.05709840,
		0.11173347, 0.15918339, 0.18849882, 0.19248502,
		0.15650085, 0.07774875, -0.01680466, -0.10095947,
	}, 
};
/* indigo */
ParModel<16,128> indigo_46722 = {
	0.08355515, 
	{
		-0.18831307, -0.01489415, 0.03769281, -0.92020919,
		0.37416341, -0.10192115, -0.20753037, 0.02538938,
		-0.42354604, 0.00521749, -0.01465589, 0.15060583,
		-0.01965474, -0.00817360, 0.02642329, -0.00006895,
		0.04179047, 0.00459378, -0.00157873, -0.00122643,
		0.04134522, -0.00003561, -0.00164716, 0.00004710,
		0.01718270, -0.00123740, 0.00978649, 0.00701871,
		-0.00040526, 0.00773993, -0.00110908, 1.08973761,
	}, 
	{
		-0.16488910, 0.02861666, -0.00925620, 1.14591887,
		-0.34956767, 0.08690439, 0.53484538, -0.03967774,
		0.06495180, -0.02062870, 0.01469762, -0.16963312,
		0.02191244, 0.00339663, -0.02124396, 0.00062739,
		-0.04041547, -0.00420745, 0.00183596, 0.00114860,
		-0.04127810, 0.00016538, 0.00161630, -0.00006945,
		-0.01703082, 0.00131710, -0.00929235, -0.00680413,
		0.00053942, -0.00773256, 0.00110853, -1.08298034,
	}, 
	{
		-1.56014619, 0.37520676, 1.42188443, 1.53040636,
		1.79636713, 1.86612195, 1.88222345, 1.93196180,
		1.93833574, 1.94396107, 1.95937613, 1.97230057,
		1.97550747, 1.97589107, 1.97652012, 1.97996354,
		1.98420173, 1.98535256, 1.99045666, 1.99326241,
		1.99432486, 1.99436530, 1.99475128, 1.99516799,
		1.99522135, 1.99537880, 1.99573205, 1.99588380,
		1.99656220, 1.99856580, 1.99965419, 1.94663490,
	}, 
	{
		-0.94250003, -0.81859216, -0.97596995, -0.76450550,
		-0.97362008, -0.97719473, -0.95610076, -0.99035978,
		-0.95883087, -0.98547198, -0.99374532, -0.98050053,
		-0.99524894, -0.99184655, -0.98199856, -0.99290555,
		-0.99217669, -0.99562586, -0.99699167, -0.99783634,
		-0.99477021, -0.99814591, -0.99702254, -0.99795448,
		-0.99589721, -0.99704777, -0.99584395, -0.99681055,
		-0.99789931, -0.99859049, -0.99965472, -0.94682556,
	}, 
	{
		0.31863189, 0.03509656, 0.48626897, 0.86453391,
		0.80077789, 1.19373515, 0.92933547, 0.93125954,
		0.79353162, 0.40200445, 0.57779299, 0.30340350,
		0.44481786, 0.71025964, 0.74619618, 1.09960669,
		0.89798437, 0.88577549, 0.82561772, 0.49915663,
		0.56941701, 0.25838113, 0.01942244, -0.35507603,
		-1.01531771, -1.34670118, -1.94143602, -2.25480612,
		-2.33064897, -2.39184690, -2.03577346, -1.88075151,
		-1.56594022, -1.22601390, -1.14068904, -0.86908169,
		-0.83398695, -0.71605363, -0.57381093, -0.58204591,
		-0.35595324, -0.35455904, -0.33415384, -0.26564119,
		-0.27605994, -0.03969012, 0.05417409, 0.20701329,
		0.39709280, 0.41463301, 0.52743776, 0.45874777,
		0.38894827, 0.29669431, 0.03675775, -0.05997976,
		-0.19109456, -0.21683077, -0.13683000, -0.12552573,
		-0.00058685, -0.00116705, -0.01041613, 0.01105065,
		-0.07320113, -0.07210870, -0.15669100, -0.23456579,
		-0.29588877, -0.48216620, -0.61209490, -0.79968817,
		-0.94691404, -1.00965234, -1.08383640, -1.01465447,
		-0.94232458, -0.84675628, -0.73121405, -0.70873058,
		-0.63324544, -0.57933813, -0.49535461, -0.35844287,
		-0.27247593, -0.14069759, -0.06279666, -0.01506371,
		0.03727292, 0.02274770, 0.05154404, 0.05937287,
		0.07109901, 0.12087979, 0.13174620, 0.17027507,
		0.15627831, 0.09893836, 0.04510809, -0.03818931,
		-0.06020705, -0.07603534, -0.08760343, -0.07058654,
		-0.08290682, -0.06595964, -0.05907172, -0.05113173,
		-0.01363062, -0.00307964, 0.01906062, 0.01211248,
		-0.02182792, -0.05789649, -0.13662114, -0.20434480,
		-0.27365108, -0.32993549, -0.34767189, -0.37385405,
		-0.37769307, -0.38171647, -0.38383725, -0.35823100,
		-0.33169568, -0.26731851, -0.18935103, -0.11687808,
	}, 
};
/* angel */
ParModel<16,128> angel_46722 = {
	0.08963475, 
	{
		0.00356619, 0.07545678, -0.04924916, -0.02463282,
		-0.02773379, 0.01085792, 0.01440215, 0.00275388,
		-0.00084257, -0.00460338, -0.00003050, 0.00385496,
		0.00059081, 0.00486302, -0.00105111, 0.00511345,
		0.00577292, 0.00158044, 0.01191528, 0.00431313,
		0.00296971, 0.00331258, 0.00106012, 0.00027141,
		0.00110275, 0.00229599, 0.00098899, 0.00897951,
		0.00073653, 0.00409658, 0.00100469, 0.00192850,
	}, 
	{
		-0.00398265, -0.06731096, 0.05003784, 0.02420177,
		0.02765557, -0.01124074, -0.01466378, -0.00287300,
		0.00102423, 0.00462468, 0.00007806, -0.00374787,
		-0.00054407, -0.00481329, 0.00107250, -0.00513330,
		-0.00577668, -0.00159938, -0.01192675, -0.00431730,
		-0.00294681, -0.00332503, -0.00106848, -0.00026289,
		-0.00110896, -0.00229343, -0.00099061, -0.00897779,
		-0.00073306, -0.00409494, -0.00100610, -0.00192834,
	}, 
	{
		0.78831253, 1.96313768, 1.98633019, 1.98832154,
		1.98890040, 1.99372936, 1.99491502, 1.99635516,
		1.99717764, 1.99730790, 1.99809402, 1.99827540,
		1.99838489, 1.99852473, 1.99901770, 1.99905898,
		1.99913211, 1.99917904, 1.99918535, 1.99922492,
		1.99927406, 1.99928232, 1.99934166, 1.99934438,
		1.99942326, 1.99942376, 1.99943856, 1.99944563,
		1.99944639, 1.99957638, 1.99957712, 1.99977174,
	}, 
	{
		-0.98725528, -0.98113342, -0.98860645, -0.99011121,
		-0.99514572, -0.99405696, -0.99543862, -0.99706428,
		-0.99823888, -0.99759771, -0.99830761, -0.99838711,
		-0.99855173, -0.99865725, -0.99911251, -0.99908525,
		-0.99915298, -0.99921154, -0.99919367, -0.99924057,
		-0.99928101, -0.99929343, -0.99938235, -0.99942099,
		-0.99942426, -0.99942786, -0.99948925, -0.99944623,
		-0.99950881, -0.99957661, -0.99957919, -0.99977176,
	}, 
	{
		0.34901398, 1.09975778, 1.66831773, 1.90049630,
		1.79866389, 1.26673957, 0.55479230, -0.07217918,
		-0.47050850, -0.59853037, -0.49731688, -0.37644728,
		-0.33716441, -0.36654353, -0.42378814, -0.43134422,
		-0.32709305, -0.19159881, -0.09308842, -0.02224674,
		0.06572460, 0.19853866, 0.35170354, 0.46599465,
		0.51053720, 0.44840170, 0.29672314, 0.06750230,
		-0.17424219, -0.34313745, -0.46256045, -0.54745612,
		-0.59252996, -0.59145891, -0.53169717, -0.42051114,
		-0.30042338, -0.17183981, -0.02608586, 0.13010371,
		0.21959370, 0.20921921, 0.10728033, -0.04368938,
		-0.17654459, -0.26886600, -0.34747319, -0.40544401,
		-0.45382326, -0.48961108, -0.52383677, -0.55051282,
		-0.56288488, -0.54079650, -0.49223217, -0.44087163,
		-0.42114788, -0.39485860, -0.33486059, -0.25772001,
		-0.18398711, -0.11383591, -0.09017028, -0.11003376,
		-0.16323508, -0.22726308, -0.27553721, -0.29505670,
		-0.28937127, -0.26385997, -0.23400699, -0.19352437,
		-0.13738413, -0.07398955, -0.02419795, 0.00470791,
		0.01574946, 0.00766061, -0.02193876, -0.06554291,
		-0.10607697, -0.12843391, -0.13377851, -0.13222828,
		-0.14170313, -0.18386354, -0.24671362, -0.30624015,
		-0.33893852, -0.32681815, -0.27466112, -0.21232051,
		-0.16332623, -0.15512029, -0.19152088, -0.25650184,
		-0.32508017, -0.38640917, -0.42554372, -0.43607076,
		-0.41375214, -0.36726583, -0.29419235, -0.21356640,
		-0.13900263, -0.07816205, -0.03937509, -0.03148536,
		-0.04286057, -0.06151094, -0.06924628, -0.06209800,
		-0.03740716, -0.00251301, 0.03658150, 0.07084635,
		0.09166731, 0.08837712, 0.06608003, 0.03136429,
		-0.00190263, -0.02475124, -0.03846831, -0.04015635,
		-0.02326541, 0.00528124, 0.03626656, 0.05758019,
	}, 
};
/* sixty-one */
ParModel<16,128> sixty_one_46722 = {
	0.07033468, 
	{
		1.32205123, -0.67213780, 0.73480338, -0.65708946,
		-0.07590085, 0.18438439, -0.33717570, -0.00826603,
		-0.01269447, -0.56994215, -0.16278067, -0.00318307,
		-0.00128040, -0.00395389, 0.44432469, 0.01988023,
		-0.01008156, -0.00594194, -0.00214282, -0.00154140,
		-0.05111459, 0.00024600, -0.01716252, 0.00742322,
		-0.00057382, -0.00016850, -0.00064800, 0.00907928,
		-0.00039839, 0.00309767, 0.00173302, 0.04489670,
	}, 
	{
		-0.48252809, 0.88515203, 0.04477000, 0.46112317,
		0.07185063, -0.12507069, 0.18395619, 0.01929884,
		0.00567228, 0.57761453, 0.14378813, 0.00268239,
		0.00153734, 0.00397511, -0.44222226, -0.02012654,
		0.01038523, 0.00477440, 0.00217600, 0.00099164,
		0.05300285, -0.00041488, 0.01673420, -0.00732757,
		0.00012063, 0.00043888, 0.00118488, -0.00920014,
		0.00044691, -0.00309470, -0.00172666, 0.03651971,
	}, 
	{
		0.90356194, 1.19039430, 1.74176796, 1.80545795,
		1.90936332, 1.91771179, 1.94325894, 1.95071603,
		1.96856490, 1.97227132, 1.97933861, 1.98068781,
		1.98126951, 1.98653698, 1.98821554, 1.99129445,
		1.99151046, 1.99204502, 1.99274965, 1.99350120,
		1.99502457, 1.99579297, 1.99584967, 1.99609709,
		1.99662106, 1.99699114, 1.99703176, 1.99740675,
		1.99836248, 1.99884832, 1.99919473, -1.55645445,
	}, 
	{
		-0.56122106, -0.59288779, -0.82949135, -0.96283164,
		-0.98055438, -0.96488676, -0.96101607, -0.98185150,
		-0.99192555, -0.97589370, -0.98600967, -0.99816667,
		-0.99401779, -0.99603252, -0.98917724, -0.99499311,
		-0.99832096, -0.99474185, -0.99800204, -0.99667553,
		-0.99587611, -0.99785135, -0.99703072, -0.99783054,
		-0.99690067, -0.99709198, -0.99766691, -0.99781462,
		-0.99840977, -0.99885047, -0.99920869, -0.60346557,
	}, 
	{
		-0.03424592, -0.13041675, 0.42533014, 1.06046993,
		1.27774533, 1.22950016, 0.88605882, 0.45174793,
		0.06789316, -0.11058444, -0.09346235, 0.19806635,
		0.70792146, 1.26412773, 1.70607171, 2.01270364,
		2.15108370, 2.08240301, 1.84661780, 1.50747065,
		1.04151847, 0.42826422, -0.25490004, -0.87834786,
		-1.33922166, -1.56952160, -1.55126599, -1.34472011,
		-1.09369754, -0.93325310, -0.90426396, -0.95537199,
		-1.05674276, -1.18052267, -1.26156930, -1.26875730,
		-1.24673511, -1.24621409, -1.27399916, -1.30935739,
		-1.32351909, -1.26960198, -1.12525682, -0.93666477,
		-0.74321421, -0.54454165, -0.38327577, -0.33447461,
		-0.38803181, -0.45772564, -0.49701472, -0.51367096,
		-0.51435370, -0.49564120, -0.45583468, -0.40469038,
		-0.36195091, -0.33724694, -0.30716004, -0.25716485,
		-0.21267319, -0.19251825, -0.16638905, -0.11633918,
		-0.07075978, -0.04859563, -0.03723410, -0.04552658,
		-0.09435598, -0.16996249, -0.24258491, -0.29371935,
		-0.30626761, -0.26830557, -0.19708577, -0.12258334,
		-0.05814963, -0.01085073, 0.01066204, 0.01751168,
		0.03292733, 0.05744046, 0.07196902, 0.06688388,
		0.04560346, 0.00892174, -0.04339154, -0.09453869,
		-0.11564823, -0.08940274, -0.02150786, 0.07148023,
		0.17376779, 0.26882422, 0.34133761, 0.38307914,
		0.39865281, 0.39989869, 0.38842295, 0.35877444,
		0.31461897, 0.26656662, 0.22519805, 0.19659078,
		0.17863073, 0.17116691, 0.17675082, 0.19303580,
		0.20712618, 0.20923922, 0.20506413, 0.19914310,
		0.18939668, 0.17542721, 0.15830519, 0.13300960,
		0.09758227, 0.05559486, 0.01117883, -0.03509015,
		-0.07887120, -0.11495862, -0.14545760, -0.17082193,
		-0.18418826, -0.17735644, -0.15016378, -0.10860181,
	}, 
};
/* sixty-two */
ParModel<16,128> sixty_two_46722 = {
	0.10107641, 
	{
		0.33022317, -0.00982124, 0.07564261, -0.05066740,
		0.00185833, -0.01223350, 0.00478386, -0.00262340,
		0.00283210, -0.71755773, 0.00020800, -0.04410598,
		0.00236638, 0.00293977, -0.00042695, 0.00220966,
		0.00120705, -0.00819226, -0.17169090, -0.00638855,
		0.62982408, 0.12551846, -0.45900114, 0.29756750,
		-0.33204202, 0.38943671, -0.43949474, 0.12003653,
		0.28298284, 0.06050613, 0.14380584, 0.21252354,
	}, 
	{
		-0.28147519, 0.01093297, -0.07547213, 0.05497712,
		-0.00180611, 0.01218560, -0.00470640, 0.00265590,
		-0.00279549, 0.71491519, -0.00018523, 0.04404862,
		-0.00238204, -0.00294548, 0.00040597, -0.00220636,
		-0.00119745, 0.00818883, 0.17258795, 0.00632402,
		-0.62991608, -0.12600534, 0.45836469, -0.29731799,
		0.33199774, -0.38962676, 0.43931897, -0.12001673,
		-0.28297240, -0.06053962, -0.14382291, 0.25116870,
	}, 
	{
		1.95742654, 1.98648468, 1.98883816, 1.99711659,
		1.99736491, 1.99761365, 1.99860025, 1.99893015,
		1.99898234, 1.99910123, 1.99925778, 1.99928120,
		1.99936046, 1.99936676, 1.99939832, 1.99941365,
		1.99943628, 1.99944487, 1.99950073, 1.99953715,
		1.99954993, 1.99962659, 1.99965819, 1.99966145,
		1.99969403, 1.99971481, 1.99971796, 1.99972966,
		1.99973260, 1.99975661, 1.99978684, 1.06318064,
	}, 
	{
		-0.96669221, -0.98842607, -0.98957158, -0.99711975,
		-0.99786041, -0.99784237, -0.99868413, -0.99908238,
		-0.99908782, -0.99910753, -0.99932588, -0.99929352,
		-0.99938722, -0.99940106, -0.99941888, -0.99945690,
		-0.99949024, -0.99946017, -0.99950292, -0.99954787,
		-0.99955266, -0.99963013, -0.99965875, -0.99966665,
		-0.99969552, -0.99971513, -0.99971889, -0.99972969,
		-0.99973272, -0.99976369, -0.99979294, -0.14981996,
	}, 
	{
		-0.09878966, 0.32006942, 0.93191157, 1.23613018,
		1.08582451, 0.57975025, -0.12192796, -0.82540880,
		-1.30678059, -1.51811729, -1.43573491, -1.06234480,
		-0.61675383, -0.35671703, -0.29853742, -0.36482382,
		-0.35901404, -0.14057574, 0.16597723, 0.39286574,
		0.40798447, 0.21657738, -0.09930425, -0.41256801,
		-0.53532221, -0.40664248, -0.13572284, 0.17031063,
		0.42323314, 0.53014782, 0.46072800, 0.23524234,
		-0.01463137, -0.12086002, -0.08214363, 0.05535675,
		0.22258858, 0.34522165, 0.39716895, 0.34486141,
		0.27579019, 0.26479085, 0.26803306, 0.28243498,
		0.28691990, 0.22583629, 0.10451863, -0.04032100,
		-0.13902957, -0.16506498, -0.14067922, -0.04059697,
		0.09786367, 0.19743753, 0.25532610, 0.25624771,
		0.19697291, 0.12510627, 0.03517550, -0.07414301,
		-0.18347164, -0.29744947, -0.38837771, -0.43451283,
		-0.40825276, -0.30308241, -0.18422491, -0.09907046,
		-0.06399500, -0.08142976, -0.12025989, -0.17150670,
		-0.22602617, -0.26433576, -0.28084020, -0.26881602,
		-0.25264219, -0.24391414, -0.21325474, -0.17380165,
		-0.12935090, -0.06041408, -0.00258823, 0.02435666,
		0.01880051, -0.01271187, -0.05061290, -0.09078162,
		-0.12707980, -0.15243389, -0.17612016, -0.20225868,
		-0.21820831, -0.21518037, -0.18394054, -0.13663860,
		-0.07693549, 0.00530184, 0.08819851, 0.15272563,
		0.19110737, 0.20160453, 0.19887645, 0.18557413,
		0.15841942, 0.11970132, 0.06726296, 0.01594984,
		-0.02159477, -0.04027294, -0.02582876, 0.01671054,
		0.06286991, 0.09677260, 0.11612560, 0.12449210,
		0.12589863, 0.12639855, 0.13300105, 0.14119087,
		0.13697627, 0.10870276, 0.05698609, -0.00597731,
		-0.06670145, -0.10822857, -0.11868610, -0.10019628,
	}, 
};

const char * CabIVModelDict="{0: 'mega wookie 800', 1: 'mega wookie 812', 2: 'mega wookie 828', 3: 'mega wookie 868', 4: 'mega wookie 908', 5: 'mega wookie 912', 6: 'mega wookie 936', 7: 'mega wookie 968', 8: 'mega wookie 992', 9: 'unmatched', 10: 'twin A', 11: 'twin B', 12: 'twin C', 13: 'blue A', 14: 'blue B', 15: 'tweedie A', 16: 'tweedie B', 17: 'mini wookie A', 18: 'mini wookie B', 19: 'rosie A', 20: 'rosie B', 21: 'indigo', 22: 'angel', 23: 'sixty-one', 24: 'sixty-two'}";
ParModel<16,128> CabIVModels[] = { 
	mega_wookie_800_46722, 
	mega_wookie_812_46722, 
	mega_wookie_828_46722, 
	mega_wookie_868_46722, 
	mega_wookie_908_46722, 
	mega_wookie_912_46722, 
	mega_wookie_936_46722, 
	mega_wookie_968_46722, 
	mega_wookie_992_46722, 
	unmatched_46722, 
	twin_A_46722, 
	twin_B_46722, 
	twin_C_46722, 
	blue_A_46722, 
	blue_B_46722, 
	tweedie_A_46722, 
	tweedie_B_46722, 
	mini_wookie_A_46722, 
	mini_wookie_B_46722, 
	rosie_A_46722, 
	rosie_B_46722, 
	indigo_46722, 
	angel_46722, 
	sixty_one_46722, 
	sixty_two_46722, 
};
enum {NCabIVModels=25};
