; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv64 -mattr=+v -global-isel -stop-after=riscv-prelegalizer-combiner | FileCheck %s

; Make sure we don't crash in the prelegalizer combiner for scalable vector
; insert and extracts.

define <vscale x 1 x i1> @insertelement_nxv1i1_0(<vscale x 1 x i1> %x) {
  ; CHECK-LABEL: name: insertelement_nxv1i1_0
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<vscale x 1 x s1>) = COPY $v0
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s1) = G_CONSTANT i1 false
  ; CHECK-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[IVEC:%[0-9]+]]:_(<vscale x 1 x s1>) = G_INSERT_VECTOR_ELT [[COPY]], [[C]](s1), [[C1]](s64)
  ; CHECK-NEXT:   $v0 = COPY [[IVEC]](<vscale x 1 x s1>)
  ; CHECK-NEXT:   PseudoRET implicit $v0
  %a = insertelement <vscale x 1 x i1> %x, i1 0, i32 0
  ret <vscale x 1 x i1> %a
}

define <vscale x 1 x i1> @shufflevector_nxv1i1_0(<vscale x 1 x i1> %x) {
  ; CHECK-LABEL: name: shufflevector_nxv1i1_0
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK-NEXT:   liveins: $v0
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:_(<vscale x 1 x s1>) = COPY $v0
  ; CHECK-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; CHECK-NEXT:   [[EVEC:%[0-9]+]]:_(s1) = G_EXTRACT_VECTOR_ELT [[COPY]](<vscale x 1 x s1>), [[C]](s64)
  ; CHECK-NEXT:   [[SPLAT_VECTOR:%[0-9]+]]:_(<vscale x 1 x s1>) = G_SPLAT_VECTOR [[EVEC]](s1)
  ; CHECK-NEXT:   $v0 = COPY [[SPLAT_VECTOR]](<vscale x 1 x s1>)
  ; CHECK-NEXT:   PseudoRET implicit $v0
  %a = shufflevector <vscale x 1 x i1> %x, <vscale x 1 x i1> poison, <vscale x 1 x i32> poison
  ret <vscale x 1 x i1> %a
}
