/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of Lzma.xs. Do not edit this file, edit Lzma.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Lzma.xs"
/* Filename: Lzma.xs
 * Author  : Paul Marquess, <pmqs@cpan.org>
 * Created : 14th March 2009
 * Version : 2.000
 *
 *   Copyright (c) 2009-2024 Paul Marquess. All rights reserved.
 *   This program is free software; you can redistribute it and/or
 *   modify it under the same terms as Perl itself.
 *
 */


#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "lzma.h"

#define NEED_sv_2pv_nolen
#include "ppport.h"


#if PERL_VERSION < 18

/* Proposed fix for https://github.com/Dual-Life/Devel-PPPort/issues/231 */

#  ifdef sv_2pv
#    undef sv_2pv
#  endif

#  if defined(__GNUC__) && !defined(PERL_GCC_BRACE_GROUPS_FORBIDDEN)
#    define sv_2pv(sv, lp) ({ SV *_sv_2pv = (sv); SvPOKp(_sv_2pv) ? ((*(lp) = SvCUR(_sv_2pv)), SvPVX(_sv_2pv)) : Perl_sv_2pv(aTHX_ _sv_2pv, (lp)); })
#  else
#    define sv_2pv(sv, lp) (SvPOKp(sv) ? ((*(lp) = SvCUR(sv)), SvPVX(sv)) : Perl_sv_2pv(aTHX_ (sv), (lp)))
#  endif

#endif

#if PERL_REVISION == 5 && (PERL_VERSION < 8 || (PERL_VERSION == 8 && PERL_SUBVERSION < 4 ))

#    ifdef SvPVbyte_force
#        undef SvPVbyte_force
#    endif

#    define SvPVbyte_force(sv,lp) SvPV_force(sv,lp)

#endif

#ifndef SvPVbyte_nolen
#    define SvPVbyte_nolen SvPV_nolen
#endif

#if PERL_REVISION == 5 && (PERL_VERSION >= 8 || (PERL_VERSION == 8 && PERL_SUBVERSION < 4 ))
#    define UTF8_AVAILABLE
#endif

typedef int                     DualType ;
typedef int                     int_undef ;

typedef unsigned long           uLong;
typedef unsigned int            uInt;

typedef struct di_stream {
    int      flags ;
#define FLAG_APPEND_OUTPUT      1
#define FLAG_CONSUME_INPUT      8
#define FLAG_LIMIT_OUTPUT       16

    //bool     is_tainted;
    bool        forZip;
    void*       extraAddress ;
    lzma_stream stream ;

    lzma_filter filters[LZMA_FILTERS_MAX + 1];
    SV* sv_filters[LZMA_FILTERS_MAX];

    uInt     bufsize;
    int      last_error ;

    uint64_t    bytesInflated ;
    uint64_t    compressedBytes ;
    uint64_t    uncompressedBytes ;

} di_stream;

typedef struct di_filter {
    lzma_filter filter;
    SV* dict;
} di_filter;

typedef di_stream * deflateStream ;
typedef di_stream * Compress__Raw__Lzma ;
typedef di_stream * Compress__Raw__Lzma__Encoder ;
typedef di_stream * Compress__Raw__Lzma__Decoder ;

typedef di_filter * Lzma__Filter ;
typedef di_filter * Lzma__Filter__Lzma;
typedef di_filter * Lzma__Filter__BCJ ;
typedef di_filter * Lzma__Filter__Delta ;
typedef di_filter * Lzma__Filter__SubBlock ;

typedef di_stream * inflateStream ;
typedef lzma_options_lzma * Compress__Raw__Lzma__Options;

#define COMPRESS_CLASS    "Compress::Raw::Lzma::Encoder"
#define UNCOMPRESS_CLASS  "Compress::Raw::Lzma::Decoder"

#define ZMALLOC(to, typ) (((to) = (typ *)safemalloc(sizeof(typ))), \
                                Zero((to),1,typ))

#define setDefaultOptions(options) \
    {	\
		Zero((options),1,lzma_options_lzma); \
		(options)->dict_size        = LZMA_DICT_SIZE_DEFAULT;	\
		(options)->preset_dict      = NULL;	\
		(options)->preset_dict_size = 0;	\
		(options)->lc               = LZMA_LC_DEFAULT;	\
		(options)->lp               = LZMA_LP_DEFAULT;	\
		(options)->pb               = LZMA_PB_DEFAULT;	\
		(options)->mode             = LZMA_MODE_NORMAL;	\
		(options)->nice_len         = 64;	\
		(options)->mf               = LZMA_MF_BT4;	\
		(options)->depth            = 0;	\
    }


#if 0
#if sizeof(unsigned long) >= 8
  #define IN_u64(arg) (unsigned long)SvUV(arg)
  #define OUT_u64(arg, var) sv_setuv(arg, (IV)var)
#else
  #define IN_u64(arg) 	if (SvOK($arg))
            $var = ($type)SvPVbyte_nolen($arg);
	else
            $var = NULL ;

  #define OUT_u64(arg, var) sv_setpv((SV*)arg, var);
#endif
#endif


/*** Tainting ***/


#define isTainted(sv) ( SvTAINTED(sv) || (SvROK(sv) ? SvTAINTED(SvRV(sv)) : FALSE))
#define rememberTainting(sv) STMT_START { s->is_tainted |= isTainted(sv); } STMT_END
#define setTainted(sv) STMT_START { SvTAINTED_on(sv); } STMT_END

#define taintedStack(x) ( FALSE || items >= x && isTainted(ST(x-1)) )
/* #define taintedStack(items) ( isTainted(ST(items-1)) ) */
#define taintedStack_1   ( taintedStack(1) )
#define taintedStack_2   ( taintedStack_1 || taintedStack(2) )
#define taintedStack_3   ( taintedStack_2 || taintedStack(3) )
#define taintedStack_4   ( taintedStack_3 || taintedStack(4) )
#define taintedStack_5   ( taintedStack_4 || taintedStack(5) )
#define taintedStack_6   ( taintedStack_5 || taintedStack(6) )
#define taintedStack_7   ( taintedStack_6 || taintedStack(7) )
#define taintedStack_8   ( taintedStack_7 || taintedStack(8) )

#define getTaint1 ( s->is_tainted = s->is_tainted || taintedStack_1 )
#define getTaint2 ( s->is_tainted = s->is_tainted || taintedStack_2 )
#define getTaint3 ( s->is_tainted = s->is_tainted || taintedStack_3 )
#define getTaint4 ( s->is_tainted = s->is_tainted || taintedStack_4 )
#define getTaint5 ( s->is_tainted = s->is_tainted || taintedStack_5 )
#define getTaint6 ( s->is_tainted = s->is_tainted || taintedStack_6 )
#define getTaint7 ( s->is_tainted = s->is_tainted || taintedStack_7 )
#define getTaint8 ( s->is_tainted = s->is_tainted || taintedStack_8 )

/*** End Tainting ***/


//static const char * const my_l_errmsg[] = {
static const char my_l_errmsg[][34] = {
    "OK",		                            /* LZMA_OK                  = 0 */
    "End of stream",		                /* LZMA_STREAM_END          = 1 */
    "No integrity check",                   /* LZMA_NO_CHECK       	    = 2 */
    "Cannot calculate integrity check",	    /* LZMA_UNSUPPORTED_CHECK   = 3 */
    "Integrity check type available",       /* LZMA_GET_CHECK           = 4 */
    "Cannot allocate memory",		        /* LZMA_MEM_ERROR           = 5 */
    "Memory usage limit was reached",		/* LZMA_MEMLIMIT_ERROR      = 6 */
    "File format not recognized",		    /* LZMA_FORMAT_ERROR        = 7 */
    "Invalid or unsupported options",		/* LZMA_OPTIONS_ERROR       = 8 */
    "Data is corrupt",		                /* LZMA_DATA_ERROR          = 9 */
    "No progress is possible",		        /* LZMA_BUF_ERROR           = 10 */
    "Programming error",                    /* LZMA_PROG_ERROR          = 11 */
    ""};

#define setDUALstatus(var, err)                                         \
                sv_setnv(var, (double)err) ;                            \
                sv_setpv(var, ((err) ? GetErrorString(err) : "")) ;     \
                SvNOK_on(var);


#if defined(__SYMBIAN32__)
# define NO_WRITEABLE_DATA
#endif

#define TRACE_DEFAULT 0

#ifdef NO_WRITEABLE_DATA
#  define trace TRACE_DEFAULT
#else
  static int trace = TRACE_DEFAULT ;
#endif

/* Dodge PerlIO hiding of these functions. */
#undef printf

#if 1
#define getInnerObject(x) (*av_fetch((AV*)SvRV(x), 0, FALSE))
#else
#define getInnerObject(x) ((SV*)SvRV(sv))
#endif

static char *
#ifdef CAN_PROTOTYPE
GetErrorString(int error_no)
#else
GetErrorString(error_no)
int error_no ;
#endif
{
    dTHX;
    char * errstr ;

    errstr = (char*) my_l_errmsg[error_no];

    return errstr ;
}

#if 0
static void
#ifdef CAN_PROTOTYPE
DispHex(void * ptr, int length)
#else
DispHex(ptr, length)
    void * ptr;
    int length;
#endif
{
    char * p = (char*)ptr;
    int i;
    for (i = 0; i < length; ++i) {
        printf(" %02x", 0xFF & *(p+i));
    }
}

static void
#ifdef CAN_PROTOTYPE
DispStream(di_stream * s, SV* sv, const char * message)
#else
DispStream(s, message)
    di_stream * s;
    const char * message;
#endif
{
    dTHX;

#if 0
    if (! trace)
        return ;
#endif

#define EnDis(f) (s->flags & f ? "Enabled" : "Disabled")

    printf("DispStream 0x%p", s) ;
    if (message)
        printf("- %s \n", message) ;
    printf("\n") ;

    if (sv) {
        sv_dump(sv);
        printf("\n") ;
    }

    if (!s)  {
        printf("    stream pointer is NULL\n");
    }
    else     {
        printf("    stream           0x%p\n", &(s->stream));
        printf("           next_in   0x%p", s->stream.next_in);
        if (s->stream.next_in){
            printf(" =>");
            DispHex((void*)s->stream.next_in, 4);
        }
        printf("\n");

        printf("           next_out  0x%p", s->stream.next_out);
        if (s->stream.next_out){
            printf(" =>");
            DispHex((void*)s->stream.next_out, 4);
        }
        printf("\n");

        printf("           avail_in  %lu\n",  (unsigned long)s->stream.avail_in);
        printf("           avail_out %lu\n",  (unsigned long)s->stream.avail_out);
        printf("    bufsize          %lu\n",  (unsigned long)s->bufsize);
        printf("    flags            0x%x\n", s->flags);
        printf("           APPEND    %s\n",   EnDis(FLAG_APPEND_OUTPUT));
        printf("           CONSUME   %s\n",   EnDis(FLAG_CONSUME_INPUT));
        printf("           LIMIT     %s\n",   EnDis(FLAG_LIMIT_OUTPUT));

        printf("\n");

    }
}
#endif

void* my_alloc (void* opaque, size_t items, size_t size)
{
    PERL_UNUSED_VAR(opaque);
    return safemalloc(items * size);
}

void my_free (void* opaque, void* ptr)
{
    PERL_UNUSED_VAR(opaque);
    safefree(ptr);

    return;
}

static di_stream *
#ifdef CAN_PROTOTYPE
InitStream(void)
#else
InitStream()
#endif
{
    dTHX;
    di_stream *s ;
    lzma_allocator * allocator;

    ZMALLOC(s, di_stream) ;

    /* lzma_memory_usage(lzma_preset_lzma, TRUE); */

    ZMALLOC(allocator, lzma_allocator) ;
    allocator->alloc = my_alloc;
    allocator->free = my_free;
    s->stream.allocator = allocator;

    return s ;

}

static void
#ifdef CAN_PROTOTYPE
PostInitStream(di_stream * s, int flags, int bufsize)
#else
PostInitStream(s, flags, bufsize)
    di_stream *s ;
    int flags ;
    int bufsize;
#endif
{
    s->bufsize  = bufsize;
    s->last_error = LZMA_OK ;
    s->flags    = flags ;
}

bool
setupFilters(di_stream* s, AV* filters, const char* properties)
{
    dTHX;
    int i = 0;

    if (properties) {
        s->filters[0].id = LZMA_FILTER_LZMA1;

        if (lzma_properties_decode(&s->filters[0], s->stream.allocator,
                (const uint8_t*)properties, 5) != LZMA_OK)
            return FALSE;

        s->extraAddress = (void*)s->filters[0].options;

        ++i;
    }
    else {
        AV*   f = filters;
        int	count = av_len(f)  ;

        for (i = 0; i <= count; ++i)
        {
            SV * fptr = (SV*) * av_fetch(f, i, FALSE) ;
            IV tmp = SvIV((SV*)SvRV(fptr));
            di_filter* filter = INT2PTR(di_filter*, tmp);

            /* Keep a reference to the filter so it doesn't get destroyed */
            s->sv_filters[i] = newSVsv(fptr) ;

            s->filters[i].id = filter->filter.id;
            s->filters[i].options = filter->filter.options;
        }
    }

    /* Terminate the filter list */
    s->filters[i].id = LZMA_VLI_UNKNOWN ;
    return TRUE;
}

void
destroyStream(di_stream * s)
{
    dTHX;
    if (s)
    {
        int i;

        if (s->extraAddress)
            Safefree(s->extraAddress) ;

	    if (s->stream.allocator)
    	    Safefree(s->stream.allocator);

        for (i = 0; i < LZMA_FILTERS_MAX; ++i)
        {
            if (s->sv_filters[i])
                SvREFCNT_dec(s->sv_filters[i]);
        }

        Safefree(s) ;
    }
}

static SV*
#ifdef CAN_PROTOTYPE
deRef(SV * sv, char * string)
#else
deRef(sv, string)
SV * sv ;
char * string;
#endif
{
    dTHX;
    SvGETMAGIC(sv);

    if (SvROK(sv)) {
        sv = SvRV(sv) ;
        SvGETMAGIC(sv);
        switch(SvTYPE(sv)) {
            case SVt_PVAV:
            case SVt_PVHV:
            case SVt_PVCV:
                croak("%s: buffer parameter is not a SCALAR reference", string);
            default:
                break;
        }
        if (SvROK(sv))
            croak("%s: buffer parameter is a reference to a reference", string) ;
    }

    if (!SvOK(sv)) {
        sv = sv_2mortal(newSVpv("", 0));
    }

    return sv ;
}

static SV*
#ifdef CAN_PROTOTYPE
deRef_l(SV * sv, char * string)
#else
deRef_l(sv, string)
SV * sv ;
char * string ;
#endif
{
    dTHX;
    bool wipe = 0 ;
    STRLEN na;

    SvGETMAGIC(sv);
    wipe = ! SvOK(sv) ;

    if (SvROK(sv)) {
        sv = SvRV(sv) ;
        SvGETMAGIC(sv);
        wipe = ! SvOK(sv) ;

        switch(SvTYPE(sv)) {
            case SVt_PVAV:
            case SVt_PVHV:
            case SVt_PVCV:
                croak("%s: buffer parameter is not a SCALAR reference", string);
            default:
                break;
        }
        if (SvROK(sv))
            croak("%s: buffer parameter is a reference to a reference", string) ;
    }

    if (SvREADONLY(sv) && PL_curcop != &PL_compiling)
        croak("%s: buffer parameter is read-only", string);

    SvUPGRADE(sv, SVt_PV);

    if (wipe)
        sv_setpv(sv, "") ;
    else
        (void)SvPVbyte_force(sv, na) ;

    return sv ;
}




#if 0
static lzma_filter all_filters[LZMA_FILTERS_MAX + 1];

//static lzma_options_filter lzma->filters[8];
static size_t filters_count = 0;
static size_t preset_number = 6 ;
static size_t opt_memory = 1024 * 1024 * 1000 ;
#endif




#if 0
static void
set_compression_settings(lzma_data * lzma)
{
	lzma->preset_default = lzma->filters_count == 0;
    size_t i;

	if (lzma->preset_default) {
		lzma->filters[0].id = LZMA_FILTER_LZMA1;
		lzma->filters[0].options = (lzma_options_lzma *)(
				lzma_preset_lzma + lzma->preset_number);
		lzma->filters_count = 1;
	}

	// Terminate the filter options array.
	lzma->filters[lzma->filters_count].id = UINT64_MAX;

	// Optimize the filter chain a little by removing all
	// Copy filters.
	for (i = 0; lzma->filters[i].id != UINT64_MAX; ++i) {
		while (lzma->filters[i].id == LZMA_FILTER_COPY) {
			size_t j = i;
			do {
				lzma->filters[j] = lzma->filters[j + 1];
			} while (lzma->filters[++j].id != UINT64_MAX);
		}
	}

	const uint32_t memory_limit = opt_memory / (1024 * 1024) + 1;
	uint32_t memory_usage = lzma_memory_usage(lzma->filters, TRUE);

	// Don't go over the memory limits when the default
	// setting is used.
	if (preset_default) {
		while (memory_usage > memory_limit) {
			if (lzma->preset_number == 0) {
				croak("Memory usage limit is too "
						"small for any internal "
						"filter preset");
				exit(-1);
			}

			--lzma->preset_number;
			lzma->filters[0].options = (lzma_options_lzma *)(
					lzma_preset_lzma
					+ lzma->preset_number);
			memory_usage = lzma_memory_usage(lzma->filters,
					TRUE);
		}
	} else {
		if (memory_usage > memory_limit) {
			croak("Memory usage limit is too small "
					"for the given filter setup");
			exit(-1);
		}
	}

	// Limit the number of worked threads so that memory usage
	// limit isn't exceeded.
	// FIXME: Probably should use bytes instead of mebibytes for
	// memory_usage and memory_limit.
	if (memory_usage == 0)
		memory_usage = 1;

#if 0
	size_t thread_limit = memory_limit / memory_usage;
	if (thread_limit == 0)
		thread_limit = 1;

	if (opt_threads > thread_limit)
		opt_threads = thread_limit;
#endif

	return;
}
#endif

lzma_ret
#ifdef CAN_PROTOTYPE
addZipProperties(di_stream* s, SV* output)
#else
addZipProperties(s, output)
di_stream* s;
SV* output ;
#endif
{
    dTHX;
    uint32_t size;
    int cur_length =  SvCUR(output) ;
    lzma_ret status = lzma_properties_size(&size, &s->filters[0]);
    uint8_t *props ;

    if (status != LZMA_OK)
        return status;


    Sv_Grow(output, SvLEN(output) + size + 4) ;
    props = (uint8_t*) SvPVbyte_nolen(output) + cur_length;

    *props = (uint8_t)LZMA_VERSION_MAJOR ; ++ props;
    *props = (uint8_t)LZMA_VERSION_MINOR ; ++ props;
    *props = size ; ++ props;
    *props = 0 ; ++ props;

    status = lzma_properties_encode(&s->filters[0], props);
    SvCUR_set(output, cur_length + size + 4);

    s->forZip = FALSE ;

    return status ;
}


#include "constants.h"

#line 647 "Lzma.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 791 "Lzma.c"

/* INCLUDE:  Including 'constants.xs' from 'Lzma.xs' */


XS_EUPXS(XS_Compress__Raw__Lzma_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 4 "./constants.xs"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	IV		iv = 0; /* avoid uninit var warning */
	/* NV		nv;	Uncomment this if you need to return NVs */
	const char	*pv = NULL; /* avoid uninit var warning */
#line 816 "Lzma.c"
	SV *	sv = ST(0)
;
	const char *	s = SvPV(sv, len);
#line 18 "./constants.xs"
        /* Change this to constant(aTHX_ s, len, &iv, &nv);
           if you need to return both NVs and IVs */
	type = constant(aTHX_ s, len, &iv, &pv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv =
	    sv_2mortal(newSVpvf("%s is not a valid Lzma macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined Lzma macro %s, used",
				   s));
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break;
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
	/* Uncomment this if you need to return NVs
        case PERL_constant_ISNV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break; */
        case PERL_constant_ISPV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break;
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
	/* Uncomment this if you need to return UVs
        case PERL_constant_ISUV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break; */
	/* Uncomment this if you need to return YESs
        case PERL_constant_ISYES:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break; */
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing Lzma macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 893 "Lzma.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'Lzma.xs' from 'constants.xs' */

#define MY_LZMA_VERSION() LZMA_VERSION

XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_VERSION)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	uint32_t	RETVAL;
	dXSTARG;

	RETVAL = MY_LZMA_VERSION();
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_version_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_version_number)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	uint32_t	RETVAL;
	dXSTARG;

	RETVAL = lzma_version_number();
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_version_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_version_string)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;

	RETVAL = lzma_version_string();
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}

#define MY_LZMA_VERSION_STRING() LZMA_VERSION_STRING

XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_VERSION_STRING); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_VERSION_STRING)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;

	RETVAL = MY_LZMA_VERSION_STRING();
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}

#define MY_LZMA_FILTER_LZMA1() LZMA_FILTER_LZMA1

XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_FILTER_LZMA1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_FILTER_LZMA1)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	uint64_t	RETVAL;
	dXSTARG;

	RETVAL = MY_LZMA_FILTER_LZMA1();
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}

#define MY_LZMA_BACKWARD_SIZE_MAX() LZMA_BACKWARD_SIZE_MAX

XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_BACKWARD_SIZE_MAX); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_LZMA_BACKWARD_SIZE_MAX)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	uint64_t	RETVAL;
	dXSTARG;

	RETVAL = MY_LZMA_BACKWARD_SIZE_MAX();
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_mf_is_supported); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_mf_is_supported)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "match_finder");
    {
	lzma_match_finder        match_finder = (lzma_match_finder)SvIV(ST(0))
;
	lzma_bool	RETVAL;

	RETVAL = lzma_mf_is_supported(match_finder);
	{
	    SV * RETVALSV;
	    RETVALSV = boolSV(RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_mode_is_supported); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_mode_is_supported)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	lzma_mode        mode = (lzma_mode)SvIV(ST(0))
;
	lzma_bool	RETVAL;

	RETVAL = lzma_mode_is_supported(mode);
	{
	    SV * RETVALSV;
	    RETVALSV = boolSV(RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_check_is_supported); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_check_is_supported)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "check");
    {
	lzma_check        check = (lzma_check)SvIV(ST(0))
;
	lzma_bool	RETVAL;

	RETVAL = lzma_check_is_supported(check);
	{
	    SV * RETVALSV;
	    RETVALSV = boolSV(RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_check_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_check_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "check");
    {
	lzma_check        check = (lzma_check)SvIV(ST(0))
;
	uint32_t	RETVAL;
	dXSTARG;

	RETVAL = lzma_check_size(check);
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_stream_buffer_bound); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_stream_buffer_bound)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "uncompressed_size");
    {
	size_t	uncompressed_size = (unsigned long)SvUV(ST(0))
;
	size_t	RETVAL;
	dXSTARG;

	RETVAL = lzma_stream_buffer_bound(uncompressed_size);
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_filter_encoder_is_supported); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_filter_encoder_is_supported)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	lzma_vli	id = (unsigned long)SvUV(ST(0))
;
	lzma_bool	RETVAL;

	RETVAL = lzma_filter_encoder_is_supported(id);
	{
	    SV * RETVALSV;
	    RETVALSV = boolSV(RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_filter_decoder_is_supported); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_filter_decoder_is_supported)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "id");
    {
	lzma_vli	id = (unsigned long)SvUV(ST(0))
;
	lzma_bool	RETVAL;

	RETVAL = lzma_filter_decoder_is_supported(id);
	{
	    SV * RETVALSV;
	    RETVALSV = boolSV(RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_easy_encoder_memusage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_easy_encoder_memusage)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "preset");
    {
	uint32_t	preset = (unsigned long)SvUV(ST(0))
;
	uint64_t	RETVAL;
	dXSTARG;

	RETVAL = lzma_easy_encoder_memusage(preset);
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_easy_decoder_memusage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_easy_decoder_memusage)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "preset");
    {
	uint32_t	preset = (unsigned long)SvUV(ST(0))
;
	uint64_t	RETVAL;
	dXSTARG;

	RETVAL = lzma_easy_decoder_memusage(preset);
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_alone_encoder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_alone_encoder)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "Class, flags, bufsize, filters");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	Class;
	int	flags = (int)SvIV(ST(1))
;
	uLong	bufsize = (unsigned long)SvUV(ST(2))
;
	AV*	filters;

	if (SvOK(ST(0)))
            Class = (const char *)SvPVbyte_nolen(ST(0));
	else
            Class = NULL
;

	if (SvROK(ST(3)) && SvTYPE(SvRV(ST(3))) == SVt_PVAV)
        /* if (sv_isa(ST(3), "AVPtr")) */
            filters = (AV*)SvRV(ST(3));
        else
            croak("filters is not an array reference")
;
#line 718 "Lzma.xs"
  {
    lzma_ret err = LZMA_OK;
    deflateStream s = NULL;

    if ((s = InitStream() )) {
        setupFilters(s, filters, NULL);
        err = lzma_alone_encoder ( &(s->stream), (const lzma_options_lzma*)s->filters[0].options );

        if (err != LZMA_OK) {
            Safefree(s) ;
            s = NULL ;
        }
        else {
            PostInitStream(s, flags, bufsize) ;
            //s->is_tainted = is_tainted;
        }
    }
    else {
        err = LZMA_MEM_ERROR ;
        s = NULL;
    }

    {
        SV* obj = sv_setref_pv(sv_newmortal(), Class, (void*)s);
        //if (is_tainted)
            //setTainted(obj);
        XPUSHs(obj);
    }
    if (GIMME_V == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
        setDUALstatus(sv, err);
        //if (is_tainted)
            //setTainted(sv);
        XPUSHs(sv) ;
    }
  }
#line 1277 "Lzma.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_raw_encoder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_raw_encoder)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "Class, flags, bufsize, filters, forZip");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	Class;
	int	flags = (int)SvIV(ST(1))
;
	uLong	bufsize = (unsigned long)SvUV(ST(2))
;
	AV*	filters;
	bool        forZip = (bool)SvTRUE(ST(4))
;

	if (SvOK(ST(0)))
            Class = (const char *)SvPVbyte_nolen(ST(0));
	else
            Class = NULL
;

	if (SvROK(ST(3)) && SvTYPE(SvRV(ST(3))) == SVt_PVAV)
        /* if (sv_isa(ST(3), "AVPtr")) */
            filters = (AV*)SvRV(ST(3));
        else
            croak("filters is not an array reference")
;
#line 763 "Lzma.xs"
  {
    lzma_ret err = LZMA_OK;
    deflateStream s = NULL;
    if ((s = InitStream() )) {
        setupFilters(s, filters, NULL);

        s->forZip = forZip ;
        err = lzma_raw_encoder ( &(s->stream), (const lzma_filter*)&s->filters );

        if (err != LZMA_OK) {
            Safefree(s) ;
            s = NULL ;
        }
        else {
            PostInitStream(s, flags, bufsize) ;
            //s->is_tainted = is_tainted;
        }
    }
    else {
        err = LZMA_MEM_ERROR ;
        s = NULL;
    }

    {
        SV* obj = sv_setref_pv(sv_newmortal(), Class, (void*)s);
        //if (is_tainted)
            //setTainted(obj);
        XPUSHs(obj);
    }
    if (GIMME_V == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
        setDUALstatus(sv, err);
        //if (is_tainted)
            //setTainted(sv);
        XPUSHs(sv) ;
    }
  }
#line 1352 "Lzma.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_stream_encoder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_stream_encoder)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "Class, flags, bufsize, filters, check=LZMA_CHECK_CRC32");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	Class;
	int	flags = (int)SvIV(ST(1))
;
	uLong	bufsize = (unsigned long)SvUV(ST(2))
;
	AV*	filters;
	lzma_check	check;

	if (SvOK(ST(0)))
            Class = (const char *)SvPVbyte_nolen(ST(0));
	else
            Class = NULL
;

	if (SvROK(ST(3)) && SvTYPE(SvRV(ST(3))) == SVt_PVAV)
        /* if (sv_isa(ST(3), "AVPtr")) */
            filters = (AV*)SvRV(ST(3));
        else
            croak("filters is not an array reference")
;

	if (items < 5)
	    check = LZMA_CHECK_CRC32;
	else {
	check = (lzma_check)SvIV(ST(4))
;
	}
#line 809 "Lzma.xs"
  {
    lzma_ret err = LZMA_OK;
    deflateStream s = NULL;

    if ((s = InitStream() )) {
        setupFilters(s, filters, NULL);

        err = lzma_stream_encoder ( &(s->stream), (const lzma_filter*)&s->filters, check );

        if (err != LZMA_OK) {
            Safefree(s) ;
            s = NULL ;
        }
        else {
            PostInitStream(s, flags, bufsize) ;
            //s->is_tainted = is_tainted;
        }
    }
    else {
        err = LZMA_MEM_ERROR ;
        s = NULL;
    }

    {
        SV* obj = sv_setref_pv(sv_newmortal(), Class, (void*)s);
        //if (is_tainted)
            //setTainted(obj);
        XPUSHs(obj);
    }
    if (GIMME_V == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
        setDUALstatus(sv, err);
        //if (is_tainted)
            //setTainted(sv);
        XPUSHs(sv) ;
    }
  }
#line 1433 "Lzma.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_easy_encoder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_easy_encoder)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "Class, flags, bufsize, preset=LZMA_PRESET_DEFAULT, check=LZMA_CHECK_CRC32");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	Class;
	int	flags = (int)SvIV(ST(1))
;
	int	preset;
	lzma_check	check;
	uLong	bufsize = (unsigned long)SvUV(ST(2))
;

	if (SvOK(ST(0)))
            Class = (const char *)SvPVbyte_nolen(ST(0));
	else
            Class = NULL
;

	if (items < 4)
	    preset = LZMA_PRESET_DEFAULT;
	else {
	    preset = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    check = LZMA_CHECK_CRC32;
	else {
	check = (lzma_check)SvIV(ST(4))
;
	}
#line 856 "Lzma.xs"
  {
    lzma_ret err = LZMA_OK;
    deflateStream s = NULL;

    if ((s = InitStream())) {
        err = lzma_easy_encoder ( &(s->stream), preset, check);

        if (err != LZMA_OK) {
            Safefree(s) ;
            s = NULL ;
        }
        else {
            PostInitStream(s, flags, bufsize) ;
            //s->is_tainted = is_tainted;
        }
    }
    else {
        err = LZMA_MEM_ERROR ;
        s = NULL;
    }

    {
        SV* obj = sv_setref_pv(sv_newmortal(), Class, (void*)s);
        //if (is_tainted)
            //setTainted(obj);
        XPUSHs(obj);
    }
    if (GIMME_V == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
        setDUALstatus(sv, err);
        //if (is_tainted)
            //setTainted(sv);
        XPUSHs(sv) ;
    }
  }
#line 1512 "Lzma.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Encoder	s;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Lzma__Encoder,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Raw::Lzma::Encoder::DESTROY",
			"s")
;
#line 901 "Lzma.xs"
    lzma_end(&s->stream) ;
    destroyStream(s) ;
#line 1540 "Lzma.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_code); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_code)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, buf, output");
    {
	Compress__Raw__Lzma__Encoder	s;
	SV *	buf = ST(1)
;
	SV *	output = ST(2)
;
	uInt	cur_length;
	uInt	increment;
	lzma_ret	RETVAL = LZMA_OK;
	uInt	bufinc;
	//bool	is_tainted = getTaint3;
	STRLEN	origlen;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Encoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Encoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Encoder::code",
                        "s", "Compress::Raw::Lzma::Encoder")
;
#line 918 "Lzma.xs"
    bufinc = s->bufsize;

    /* If the input buffer is a reference, dereference it */
    buf = deRef(buf, (char*)"code") ;

    /* initialise the input buffer */
#ifdef UTF8_AVAILABLE
    if (DO_UTF8(buf) && !sv_utf8_downgrade(buf, 1))
         croak("Wide character in " COMPRESS_CLASS "::code input parameter");
#endif
    s->stream.next_in = (uint8_t*)SvPV_nomg(buf, origlen) ;
    s->stream.avail_in = origlen;

    //if (is_tainted)
        //setTainted(output);
    /* and retrieve the output buffer */
    output = deRef_l(output, (char*)"code") ;
#ifdef UTF8_AVAILABLE
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " COMPRESS_CLASS "::code output parameter");
#endif

    if((s->flags & FLAG_APPEND_OUTPUT) == FLAG_APPEND_OUTPUT) {
        SvOOK_off(output);
    } else {
        SvCUR_set(output, 0);
    }

    if (s->forZip)
        addZipProperties(s, output) ;

    cur_length =  SvCUR(output) ;
    s->stream.next_out = (uint8_t*) SvPVX(output) + cur_length;
    increment =  SvLEN(output) -  cur_length;
    s->stream.avail_out =  increment;
    while (s->stream.avail_in != 0) {

        if (s->stream.avail_out == 0) {
	    /* out of space in the output buffer so make it bigger */
            s->stream.next_out = (uint8_t*)Sv_Grow(output, SvLEN(output) + bufinc) ;
            cur_length += increment ;
            s->stream.next_out += cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }

        RETVAL = lzma_code(&(s->stream), LZMA_RUN);

        if (RETVAL == LZMA_STREAM_END)
            break;
        if (RETVAL != LZMA_OK)
            break;

        /* if (RETVAL == LZMA_BUF_ERROR) { */

            if (s->stream.avail_out == 0)
                continue ;
            if (s->stream.avail_in == 0) {
                RETVAL = LZMA_OK ;
                break ;
            }


        if (RETVAL != LZMA_OK)
            break;
    }

    s->compressedBytes    += cur_length + increment - s->stream.avail_out ;
    s->uncompressedBytes  += origlen - s->stream.avail_in  ;

    s->last_error = RETVAL ;
    if (RETVAL == LZMA_OK) {
        SvPOK_only(output);
        SvCUR_set(output, cur_length + increment - s->stream.avail_out) ;
        SvSETMAGIC(output);
    }
#line 1652 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    setDUALstatus(RETVALSV, RETVAL) ;
	    //if (is_tainted) setTainted(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_flush)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "s, output, f=LZMA_FINISH");
    {
	Compress__Raw__Lzma__Encoder	s;
	SV *	output = ST(1)
;
	uInt	cur_length;
	uInt	increment;
	uInt	bufinc;
	lzma_ret	RETVAL = LZMA_OK;
	lzma_action	f;
	//bool	is_tainted = getTaint2;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Encoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Encoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Encoder::flush",
                        "s", "Compress::Raw::Lzma::Encoder")
;

	if (items < 3)
	    f = LZMA_FINISH;
	else {
	f = (lzma_action)SvIV(ST(2))
;
	}
#line 1010 "Lzma.xs"
    //if (is_tainted)
        //setTainted(output);
    bufinc = s->bufsize;

    s->stream.avail_in = 0; /* should be zero already anyway */

    /* retrieve the output buffer */
    output = deRef_l(output, (char*)"flush") ;
#ifdef UTF8_AVAILABLE
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " COMPRESS_CLASS "::flush input parameter");
#endif
    if((s->flags & FLAG_APPEND_OUTPUT) == FLAG_APPEND_OUTPUT) {
        SvOOK_off(output);
    } else {
        SvCUR_set(output, 0);
    }

    if (s->forZip)
        addZipProperties(s, output) ;

    cur_length =  SvCUR(output) ;
    s->stream.next_out = (uint8_t*) SvPVX(output) + cur_length;
    increment =  SvLEN(output) -  cur_length;
    s->stream.avail_out =  increment;

    for (;;) {
        if (s->stream.avail_out == 0) {
	    /* consumed all the available output, so extend it */
            s->stream.next_out = (uint8_t*)Sv_Grow(output, SvLEN(output) + bufinc) ;
            cur_length += increment ;
            s->stream.next_out += cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }

        RETVAL = lzma_code(&(s->stream), f);

        /* deflate has finished flushing only when it hasn't used up
         * all the available space in the output buffer:
         */
        /* if (s->stream.avail_out != 0 || RETVAL < 0 ) */
        if (RETVAL != LZMA_OK)
            break;
    }

    /* TODO -- ??? */
    /* RETVAL =  (RETVAL == LZMA_STREAM_END ? LZMA_OK : RETVAL) ; */
    s->last_error = RETVAL ;

    s->compressedBytes    += cur_length + increment - s->stream.avail_out ;

    if (RETVAL == LZMA_STREAM_END) {
        SvPOK_only(output);
        SvCUR_set(output, cur_length + increment - s->stream.avail_out) ;
        SvSETMAGIC(output);
    }
#line 1757 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    setDUALstatus(RETVALSV, RETVAL) ;
	    //if (is_tainted) setTainted(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_compressedBytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_compressedBytes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Encoder	s;
	uLong	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Encoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Encoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Encoder::compressedBytes",
                        "s", "Compress::Raw::Lzma::Encoder")
;
#line 1076 "Lzma.xs"
        //bool is_tainted = getTaint1;
        RETVAL = s->compressedBytes;
#line 1793 "Lzma.c"
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_uncompressedBytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Encoder_uncompressedBytes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Encoder	s;
	uLong	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Encoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Encoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Encoder::uncompressedBytes",
                        "s", "Compress::Raw::Lzma::Encoder")
;
#line 1085 "Lzma.xs"
        //bool is_tainted = getTaint1;
        RETVAL = s->uncompressedBytes;
#line 1824 "Lzma.c"
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_auto_decoder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_auto_decoder)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "Class, flags, bufsize, memlimit=UINT64_MAX, fl=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	Class;
	int	flags = (int)SvIV(ST(1))
;
	int	fl;
	uint64_t	memlimit;
	uLong	bufsize = (unsigned long)SvUV(ST(2))
;

	if (SvOK(ST(0)))
            Class = (const char *)SvPVbyte_nolen(ST(0));
	else
            Class = NULL
;

	if (items < 5)
	    fl = 0;
	else {
	    fl = (int)SvIV(ST(4))
;
	}

	if (items < 4)
	    memlimit = UINT64_MAX;
	else {
	    memlimit = (unsigned long)SvUV(ST(3))
;
	}
#line 1105 "Lzma.xs"
  {
    int err = LZMA_OK ;
    inflateStream s = NULL;
    if ((s = InitStream() )) {
        if (ix == 0)
            err = lzma_auto_decoder ( &(s->stream), memlimit, fl );
        else if (ix == 1)
            err = lzma_stream_decoder ( &(s->stream), memlimit, fl );
        else if (ix == 2)
            err = lzma_alone_decoder ( &(s->stream), memlimit );

        if (err != LZMA_OK) {
            Safefree(s) ;
            s = NULL ;
	}
	if (s) {
            //s->is_tainted = is_tainted;
	    PostInitStream(s, flags, bufsize) ;
        }
    }
    else
        err = LZMA_MEM_ERROR ;

    {
        SV* obj = sv_setref_pv(sv_newmortal(), Class, (void*)s);
        //if (is_tainted)
            //setTainted(obj);
        XPUSHs(obj);
    }
    if (GIMME_V == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
        setDUALstatus(sv, err);
        //if (is_tainted)
            //setTainted(sv);
        XPUSHs(sv) ;
    }
  }
#line 1907 "Lzma.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Raw__Lzma_lzma_raw_decoder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma_lzma_raw_decoder)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "Class, flags, bufsize, filters, properties");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	Class;
	int	flags = (int)SvIV(ST(1))
;
	uLong	bufsize = (unsigned long)SvUV(ST(2))
;
	AV*	filters;
	const char*	properties;

	if (SvOK(ST(0)))
            Class = (const char *)SvPVbyte_nolen(ST(0));
	else
            Class = NULL
;

	if (SvROK(ST(3)) && SvTYPE(SvRV(ST(3))) == SVt_PVAV)
        /* if (sv_isa(ST(3), "AVPtr")) */
            filters = (AV*)SvRV(ST(3));
        else
            croak("filters is not an array reference")
;

	if (SvOK(ST(4)))
            properties = (const char *)SvPVbyte_nolen(ST(4));
	else
            properties = NULL
;
#line 1151 "Lzma.xs"
  {
    int err = LZMA_OK ;
    inflateStream s = NULL;
    if ((s = InitStream() )) {

        if (! setupFilters(s, filters, properties)) {
            Safefree(s) ;
            s = NULL ;
        }

        err = lzma_raw_decoder ( &(s->stream), (const lzma_filter*)&s->filters );

        if (err != LZMA_OK) {
            Safefree(s) ;
            s = NULL ;
	}
	if (s) {
            //s->is_tainted = is_tainted;
	    PostInitStream(s, flags, bufsize) ;
        }
    }
    else
        err = LZMA_MEM_ERROR ;

    {
        SV* obj = sv_setref_pv(sv_newmortal(), Class, (void*)s);
        //if (is_tainted)
            //setTainted(obj);
        XPUSHs(obj);
    }
    if (GIMME_V == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
        setDUALstatus(sv, err);
        //if (is_tainted)
            //setTainted(sv);
        XPUSHs(sv) ;
    }
  }
#line 1988 "Lzma.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Decoder	s;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Lzma__Decoder,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Raw::Lzma::Decoder::DESTROY",
			"s")
;
#line 1196 "Lzma.xs"
    lzma_end(&s->stream) ;
    destroyStream(s) ;
#line 2016 "Lzma.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_code); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_code)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, buf, output");
    {
	Compress__Raw__Lzma__Decoder	s;
	SV *	buf = ST(1)
;
	SV *	output = ST(2)
;
	uInt	cur_length = 0;
	uInt	prefix_length = 0;
	uInt	increment = 0;
	uInt	bufinc;
	STRLEN	na;
	STRLEN	origlen;
#line 1212 "Lzma.xs"
#ifdef UTF8_AVAILABLE
    bool	out_utf8  = FALSE;
#endif
#line 2044 "Lzma.c"
	DualType	RETVAL;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Decoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Decoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Decoder::code",
                        "s", "Compress::Raw::Lzma::Decoder")
;
#line 1216 "Lzma.xs"
    //bool is_tainted = getTaint3;
    //if (is_tainted)
        //setTainted(output);
    bufinc = s->bufsize;
    /* If the buffer is a reference, dereference it */
    buf = deRef(buf, (char*)"inflate") ;

    if (s->flags & FLAG_CONSUME_INPUT) {
        if (SvREADONLY(buf))
            croak(UNCOMPRESS_CLASS "::code input parameter cannot be read-only when ConsumeInput is specified");
        SvPV_force(buf, na);
    }
#ifdef UTF8_AVAILABLE
    if (DO_UTF8(buf) && !sv_utf8_downgrade(buf, 1))
         croak("Wide character in " UNCOMPRESS_CLASS "::code input parameter");
#endif

    /* initialise the input buffer */
    s->stream.next_in = (uint8_t*)SvPV_nomg(buf, origlen) ;
    s->stream.avail_in = origlen;

    /* and retrieve the output buffer */
    output = deRef_l(output, (char*)"inflate") ;
#ifdef UTF8_AVAILABLE
    if (DO_UTF8(output))
         out_utf8 = TRUE ;
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " UNCOMPRESS_CLASS "::code output parameter");
#endif
    if((s->flags & FLAG_APPEND_OUTPUT) == FLAG_APPEND_OUTPUT) {
        SvOOK_off(output);
    } else {
        SvCUR_set(output, 0);
    }


    /* Assume no output buffer - the code below will update if there is any available */
    s->stream.avail_out = 0;


    if (SvLEN(output)) {
        prefix_length = cur_length =  SvCUR(output) ;

        if (s->flags & FLAG_LIMIT_OUTPUT && SvLEN(output) - cur_length - 1 < bufinc)
        {
            Sv_Grow(output, bufinc + cur_length + 1) ;
        }

        /* Only setup the stream output pointers if there is spare
           capacity in the outout SV
        */
        if (SvLEN(output) > cur_length + 1)
        {
            s->stream.next_out = (uint8_t*) SvPVX(output) + cur_length;
            increment = SvLEN(output) -  cur_length - 1;
            s->stream.avail_out = increment;
        }
    }


    s->bytesInflated = 0;

    while (1) {

        if (s->stream.avail_out == 0) {
	    /* out of space in the output buffer so make it bigger */
            s->stream.next_out = (uint8_t*)Sv_Grow(output, SvLEN(output) + bufinc + 1) ;
            cur_length += increment ;
            s->stream.next_out += cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }

        RETVAL = lzma_code(&(s->stream), LZMA_RUN);

        if (s->flags & FLAG_LIMIT_OUTPUT) {
            if (RETVAL == LZMA_BUF_ERROR && s->stream.avail_in == 0) {
                RETVAL = LZMA_OK ;
                //continue;
            }

            break;
        }

        if (RETVAL == LZMA_BUF_ERROR) {
            if (s->stream.avail_out == 0)
                continue ;
            if (s->stream.avail_in == 0) {
                RETVAL = LZMA_OK ;
                break ;
            }
        }

        if (RETVAL != LZMA_OK)
            break;
    }

    s->last_error = RETVAL ;
    if (RETVAL == LZMA_OK || RETVAL == LZMA_STREAM_END || RETVAL == LZMA_BUF_ERROR) {
	    unsigned in ;

        s->bytesInflated = cur_length + increment - s->stream.avail_out - prefix_length;
        s->uncompressedBytes += s->bytesInflated ;
        s->compressedBytes   += origlen - s->stream.avail_in  ;

        SvPOK_only(output);
        SvCUR_set(output, prefix_length + s->bytesInflated) ;
	*SvEND(output) = '\0';
#ifdef UTF8_AVAILABLE
        if (out_utf8)
            sv_utf8_upgrade(output);
#endif
        SvSETMAGIC(output);

	/* fix the input buffer */
	if (s->flags & FLAG_CONSUME_INPUT || s->flags & FLAG_LIMIT_OUTPUT) {
	    in = s->stream.avail_in ;
	    SvCUR_set(buf, in) ;
	    if (in)
	        Move(s->stream.next_in, SvPVX(buf), in, char) ;
            *SvEND(buf) = '\0';
            //if (is_tainted)
                //setTainted(buf);
            SvSETMAGIC(buf);
	}
    }
#line 2184 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    setDUALstatus(RETVALSV, RETVAL) ;
	    //if (is_tainted) setTainted(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_compressedBytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_compressedBytes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Decoder	s;
	uLong	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Decoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Decoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Decoder::compressedBytes",
                        "s", "Compress::Raw::Lzma::Decoder")
;
#line 1350 "Lzma.xs"
        //bool is_tainted = getTaint1;
        RETVAL = s->compressedBytes;
#line 2220 "Lzma.c"
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_uncompressedBytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Decoder_uncompressedBytes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Decoder	s;
	uLong	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Decoder")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Decoder,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Decoder::uncompressedBytes",
                        "s", "Compress::Raw::Lzma::Decoder")
;
#line 1359 "Lzma.xs"
        //bool is_tainted = getTaint1;
        RETVAL = s->uncompressedBytes;
#line 2251 "Lzma.c"
	XSprePUSH;
	PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Lzma__Filter_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Lzma__Filter_id)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "filter");
    {
	Lzma__Filter	filter;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lzma::Filter")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            filter = INT2PTR(Lzma__Filter,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lzma::Filter::id",
                        "filter", "Lzma::Filter")
;
#line 1370 "Lzma.xs"
    RETVAL = filter->filter.id;
#line 2281 "Lzma.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Lzma__Filter_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Lzma__Filter_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Lzma__Filter	s;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Lzma__Filter,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Lzma::Filter::DESTROY",
			"s")
;
#line 1378 "Lzma.xs"
    if (s->filter.options)
        Safefree(s->filter.options) ;
    if (s->dict)
        SvREFCNT_dec(s->dict);
    Safefree(s) ;
#line 2313 "Lzma.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Lzma__Filter__Lzma__mk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Lzma__Filter__Lzma__mk)
{
    dVAR; dXSARGS;
    if (items != 10)
       croak_xs_usage(cv,  "want_lzma2, dict_size, lc, lp, pb, mode, nice_len, mf, depth, preset_dict");
    {
	bool        want_lzma2 = (bool)SvTRUE(ST(0))
;
	uint32_t	dict_size = (unsigned long)SvUV(ST(1))
;
	uint32_t	lc = (unsigned long)SvUV(ST(2))
;
	uint32_t	lp = (unsigned long)SvUV(ST(3))
;
	uint32_t	pb = (unsigned long)SvUV(ST(4))
;
	lzma_mode        mode = (lzma_mode)SvIV(ST(5))
;
	uint32_t	nice_len = (unsigned long)SvUV(ST(6))
;
	lzma_match_finder        mf = (lzma_match_finder)SvIV(ST(7))
;
	uint32_t	depth = (unsigned long)SvUV(ST(8))
;
	SV*	preset_dict = ST(9)
;
	Lzma__Filter__Lzma	RETVAL;
#line 1400 "Lzma.xs"
        lzma_options_lzma* p;
        size_t preset_len = 0;
        ZMALLOC(RETVAL, di_filter) ;
        RETVAL->filter.id = want_lzma2 ? LZMA_FILTER_LZMA2 : LZMA_FILTER_LZMA1 ;
        ZMALLOC(RETVAL->filter.options, lzma_options_lzma) ;
        p = (lzma_options_lzma*)RETVAL->filter.options;
        setDefaultOptions(p);

        RETVAL->dict = newSVsv( deRef(preset_dict, (char*)"preset dict") );

        p->preset_dict = (const uint8_t*)SvPVbyte_force(RETVAL->dict,preset_len);
        p->preset_dict_size = preset_len;
        if ( p->preset_dict_size == 0 ) {
          SvREFCNT_dec(RETVAL->dict);
          p->preset_dict = NULL;
          RETVAL->dict = NULL;
        }

        p->dict_size = dict_size ;
        p->lc = lc ;
        p->lp = lp ;
        p->pb = pb ;
        p->mode = mode ;
        p->nice_len = nice_len ;
        p->mf = mf ;
        p->depth = depth ;
#line 2374 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Lzma::Filter::Lzma", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Lzma__Filter__Lzma__mkPreset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Lzma__Filter__Lzma__mkPreset)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "want_lzma2, preset");
    {
	bool        want_lzma2 = (bool)SvTRUE(ST(0))
;
	uint32_t	preset = (unsigned long)SvUV(ST(1))
;
	Lzma__Filter__Lzma	RETVAL;
#line 1434 "Lzma.xs"
        lzma_options_lzma* p;
        ZMALLOC(RETVAL, di_filter) ;
        RETVAL->filter.id = want_lzma2 ? LZMA_FILTER_LZMA2 : LZMA_FILTER_LZMA1 ;
        ZMALLOC(RETVAL->filter.options, lzma_options_lzma) ;
        p = (lzma_options_lzma*)RETVAL->filter.options;
        lzma_lzma_preset(p, preset);
#line 2405 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Lzma::Filter::Lzma", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Lzma__Filter__BCJ__mk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Lzma__Filter__BCJ__mk)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "id, offset=0");
    {
	int	id = (int)SvIV(ST(0))
;
	int	offset;
	Lzma__Filter__BCJ	RETVAL;

	if (items < 2)
	    offset = 0;
	else {
	    offset = (int)SvIV(ST(1))
;
	}
#line 1450 "Lzma.xs"
        ZMALLOC(RETVAL, di_filter) ;
        ZMALLOC(RETVAL->filter.options, lzma_options_bcj) ;
        RETVAL->filter.id = id;
        ((lzma_options_bcj*)(RETVAL->filter.options))->start_offset = offset;
#line 2440 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Lzma::Filter::BCJ", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Lzma__Filter__Delta__mk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Lzma__Filter__Delta__mk)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 2)
       croak_xs_usage(cv,  "type=LZMA_DELTA_TYPE_BYTE, dist=LZMA_DELTA_DIST_MIN");
    {
	lzma_delta_type	type;
	uint32_t	dist;
	Lzma__Filter__Delta	RETVAL;

	if (items < 1)
	    type = LZMA_DELTA_TYPE_BYTE;
	else {
	type = (lzma_delta_type)SvIV(ST(0))
;
	}

	if (items < 2)
	    dist = LZMA_DELTA_DIST_MIN;
	else {
	    dist = (unsigned long)SvUV(ST(1))
;
	}
#line 1464 "Lzma.xs"
        ZMALLOC(RETVAL, di_filter) ;
        ZMALLOC(RETVAL->filter.options, lzma_options_delta) ;
        RETVAL->filter.id = LZMA_FILTER_DELTA;
        ((lzma_options_delta*)(RETVAL->filter.options))->type = type;
        ((lzma_options_delta*)(RETVAL->filter.options))->dist = dist;
#line 2482 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Lzma::Filter::Delta", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Options_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Options_new)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	Compress__Raw__Lzma__Options	RETVAL;
#line 1477 "Lzma.xs"
        ZMALLOC(RETVAL, lzma_options_lzma) ;
        setDefaultOptions(RETVAL);
#line 2505 "Lzma.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Raw::Lzma::Options", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Options_lzma_lzma_preset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Options_lzma_lzma_preset)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, preset");
    {
	Compress__Raw__Lzma__Options	s;
	uint32_t	preset = (unsigned long)SvUV(ST(1))
;
	lzma_bool	RETVAL;

        if (sv_derived_from(ST(0), "Compress::Raw::Lzma::Options")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            s = INT2PTR(Compress__Raw__Lzma__Options,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Compress::Raw::Lzma::Options::lzma_lzma_preset",
                        "s", "Compress::Raw::Lzma::Options")
;

	RETVAL = lzma_lzma_preset(s, preset);
	{
	    SV * RETVALSV;
	    RETVALSV = boolSV(RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Raw__Lzma__Options_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Raw__Lzma__Options_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Lzma__Options	s;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Lzma__Options,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Raw::Lzma::Options::DESTROY",
			"s")
;
#line 1491 "Lzma.xs"
    Safefree(s) ;
#line 2571 "Lzma.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Compress__Raw__Lzma); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Compress__Raw__Lzma)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Compress::Raw::Lzma::constant", XS_Compress__Raw__Lzma_constant);
        newXS_deffile("Compress::Raw::Lzma::LZMA_VERSION", XS_Compress__Raw__Lzma_LZMA_VERSION);
        newXS_deffile("Compress::Raw::Lzma::lzma_version_number", XS_Compress__Raw__Lzma_lzma_version_number);
        newXS_deffile("Compress::Raw::Lzma::lzma_version_string", XS_Compress__Raw__Lzma_lzma_version_string);
        newXS_deffile("Compress::Raw::Lzma::LZMA_VERSION_STRING", XS_Compress__Raw__Lzma_LZMA_VERSION_STRING);
        newXS_deffile("Compress::Raw::Lzma::LZMA_FILTER_LZMA1", XS_Compress__Raw__Lzma_LZMA_FILTER_LZMA1);
        newXS_deffile("Compress::Raw::Lzma::LZMA_BACKWARD_SIZE_MAX", XS_Compress__Raw__Lzma_LZMA_BACKWARD_SIZE_MAX);
        newXS_deffile("Compress::Raw::Lzma::lzma_mf_is_supported", XS_Compress__Raw__Lzma_lzma_mf_is_supported);
        newXS_deffile("Compress::Raw::Lzma::lzma_mode_is_supported", XS_Compress__Raw__Lzma_lzma_mode_is_supported);
        newXS_deffile("Compress::Raw::Lzma::lzma_check_is_supported", XS_Compress__Raw__Lzma_lzma_check_is_supported);
        newXS_deffile("Compress::Raw::Lzma::lzma_check_size", XS_Compress__Raw__Lzma_lzma_check_size);
        newXS_deffile("Compress::Raw::Lzma::lzma_stream_buffer_bound", XS_Compress__Raw__Lzma_lzma_stream_buffer_bound);
        newXS_deffile("Compress::Raw::Lzma::lzma_filter_encoder_is_supported", XS_Compress__Raw__Lzma_lzma_filter_encoder_is_supported);
        newXS_deffile("Compress::Raw::Lzma::lzma_filter_decoder_is_supported", XS_Compress__Raw__Lzma_lzma_filter_decoder_is_supported);
        newXS_deffile("Compress::Raw::Lzma::lzma_easy_encoder_memusage", XS_Compress__Raw__Lzma_lzma_easy_encoder_memusage);
        newXS_deffile("Compress::Raw::Lzma::lzma_easy_decoder_memusage", XS_Compress__Raw__Lzma_lzma_easy_decoder_memusage);
        newXS_deffile("Compress::Raw::Lzma::lzma_alone_encoder", XS_Compress__Raw__Lzma_lzma_alone_encoder);
        newXS_deffile("Compress::Raw::Lzma::lzma_raw_encoder", XS_Compress__Raw__Lzma_lzma_raw_encoder);
        newXS_deffile("Compress::Raw::Lzma::lzma_stream_encoder", XS_Compress__Raw__Lzma_lzma_stream_encoder);
        newXS_deffile("Compress::Raw::Lzma::lzma_easy_encoder", XS_Compress__Raw__Lzma_lzma_easy_encoder);
        newXS_deffile("Compress::Raw::Lzma::Encoder::DESTROY", XS_Compress__Raw__Lzma__Encoder_DESTROY);
        newXS_deffile("Compress::Raw::Lzma::Encoder::code", XS_Compress__Raw__Lzma__Encoder_code);
        newXS_deffile("Compress::Raw::Lzma::Encoder::flush", XS_Compress__Raw__Lzma__Encoder_flush);
        newXS_deffile("Compress::Raw::Lzma::Encoder::compressedBytes", XS_Compress__Raw__Lzma__Encoder_compressedBytes);
        newXS_deffile("Compress::Raw::Lzma::Encoder::uncompressedBytes", XS_Compress__Raw__Lzma__Encoder_uncompressedBytes);
        cv = newXS_deffile("Compress::Raw::Lzma::lzma_alone_decoder", XS_Compress__Raw__Lzma_lzma_auto_decoder);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("Compress::Raw::Lzma::lzma_auto_decoder", XS_Compress__Raw__Lzma_lzma_auto_decoder);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Compress::Raw::Lzma::lzma_stream_decoder", XS_Compress__Raw__Lzma_lzma_auto_decoder);
        XSANY.any_i32 = 1;
        newXS_deffile("Compress::Raw::Lzma::lzma_raw_decoder", XS_Compress__Raw__Lzma_lzma_raw_decoder);
        newXS_deffile("Compress::Raw::Lzma::Decoder::DESTROY", XS_Compress__Raw__Lzma__Decoder_DESTROY);
        newXS_deffile("Compress::Raw::Lzma::Decoder::code", XS_Compress__Raw__Lzma__Decoder_code);
        newXS_deffile("Compress::Raw::Lzma::Decoder::compressedBytes", XS_Compress__Raw__Lzma__Decoder_compressedBytes);
        newXS_deffile("Compress::Raw::Lzma::Decoder::uncompressedBytes", XS_Compress__Raw__Lzma__Decoder_uncompressedBytes);
        newXS_deffile("Lzma::Filter::id", XS_Lzma__Filter_id);
        newXS_deffile("Lzma::Filter::DESTROY", XS_Lzma__Filter_DESTROY);
        newXS_deffile("Lzma::Filter::Lzma::_mk", XS_Lzma__Filter__Lzma__mk);
        newXS_deffile("Lzma::Filter::Lzma::_mkPreset", XS_Lzma__Filter__Lzma__mkPreset);
        newXS_deffile("Lzma::Filter::BCJ::_mk", XS_Lzma__Filter__BCJ__mk);
        newXS_deffile("Lzma::Filter::Delta::_mk", XS_Lzma__Filter__Delta__mk);
        newXS_deffile("Compress::Raw::Lzma::Options::new", XS_Compress__Raw__Lzma__Options_new);
        newXS_deffile("Compress::Raw::Lzma::Options::lzma_lzma_preset", XS_Compress__Raw__Lzma__Options_lzma_lzma_preset);
        newXS_deffile("Compress::Raw::Lzma::Options::DESTROY", XS_Compress__Raw__Lzma__Options_DESTROY);

    /* Initialisation Section */

#line 645 "Lzma.xs"
    {
        PERL_UNUSED_VAR(trace);
    }

#line 2657 "Lzma.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
